package com.book.pongv2;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;

import com.book.simplegameenginev2.SGEntity;
import com.book.simplegameenginev2.SGImage;
import com.book.simplegameenginev2.SGImageFactory;
import com.book.simplegameenginev2.SGRenderer;
import com.book.simplegameenginev2.SGView;

public class GameView extends SGView
{
	private boolean 		mIsDebug = false;
	private GameModel 	    mModel;
	private Rect            mTempSrcRect = new Rect();
	private SGImage         mBallImage;
	private SGImage 		mOpponentImage;
	private SGImage 		mPlayerImage;

	private GameView(Context context)
	{
		super(context);
	}

	public GameView(Context context, GameModel model)
	{
		super(context);
		mModel = model;
	}

	@Override
	public void setup()
	{
		mModel.setup();

		SGImageFactory imageFactory = getImageFactory();

		mBallImage = imageFactory.createImage("ball.png");
		mPlayerImage = imageFactory.createImage("player.png");
		mOpponentImage = imageFactory.createImage("opponent.png");
	}

	@Override
	public void step(Canvas canvas, float elapsedTimeInSeconds)
	{
		mModel.step(elapsedTimeInSeconds);
		SGRenderer renderer = getRenderer();
		renderer.beginDrawing(canvas, Color.BLACK);

		if(mIsDebug == true)
		{
			SGEntity opponent = mModel.getOpponent();
			renderer.drawRect(opponent.getPosition(), opponent.getDimensions(), opponent.getDebugColor());

			SGEntity player = mModel.getPlayer();
			renderer.drawRect(player.getPosition(), player.getDimensions(), player.getDebugColor());

			SGEntity ball = mModel.getBall();
			renderer.drawRect(ball.getPosition(), ball.getDimensions(), ball.getDebugColor());
		}
		else
		{
			mTempSrcRect.set(0, 0, GameModel.PADDLE_WIDTH, GameModel.PADDLE_HEIGHT);
			SGEntity opponent = mModel.getOpponent();
			renderer.drawImage(mOpponentImage, mTempSrcRect, opponent.getPosition(), opponent.getDimensions());

			mTempSrcRect.set(0, 0, GameModel.PADDLE_WIDTH, GameModel.PADDLE_HEIGHT);
			SGEntity player = mModel.getPlayer();
			renderer.drawImage(mPlayerImage, mTempSrcRect, player.getPosition(), player.getDimensions());

			mTempSrcRect.set(0, 0, GameModel.BALL_SIZE, GameModel.BALL_SIZE);
			SGEntity ball = mModel.getBall();
			renderer.drawImage(mBallImage, mTempSrcRect, ball.getPosition(), ball.getDimensions());
		}

		renderer.endDrawing();
	}
}


