package com.book.pongv1;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;

import com.book.simplegameenginev1.SGActivity;
import com.book.simplegameenginev1.SGPreferences;

public class GameActivity extends SGActivity implements GestureDetector.OnGestureListener
{
    public static final String TAG = "PongV1";

	private GestureDetector mGestureDetector;
	private GameView mView;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        enableFullScreen();
        enableKeepScreenOn();

        // setContentView(R.layout.activity_game);

        SGPreferences preferences = new SGPreferences(this);
        if(preferences.getInt("first_time", -1) == -1) {
            preferences.begin()
                .putInt("first_time", 1)
                .putInt("difficulty", 0)
                .putInt("high_score", 15)
                .end();

            Log.d(TAG, "Primeira inicialização.");
        }

	    StringBuilder stringBuilder = new StringBuilder();
	    stringBuilder.append("Nível de dificuldade: ");
	    stringBuilder.append(preferences.getInt("difficulty", 0));

	    Log.d(TAG, stringBuilder.toString());

	    stringBuilder.setLength(0);
	    stringBuilder.append("High score: ");
	    stringBuilder.append(preferences.getInt("high_score", 0));

	    Log.d(TAG, stringBuilder.toString());

	    mView = new GameView(this);
	    setContentView(mView);

	    mGestureDetector = new GestureDetector(this, this);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event)
    {
	    return mGestureDetector.onTouchEvent(event);
    }

	@Override
	public boolean onDown(MotionEvent event)
	{
		Log.d(TAG, "onDown() chamado.");

		return true;
	}

	@Override
	public boolean onFling(MotionEvent downEvent, MotionEvent moveEvent2, float velocityX, float velocityY)
	{
		Log.d(TAG, "onFling() chamado.");

		return true;
	}

	@Override
	public void onLongPress(MotionEvent event)
	{
		Log.d(TAG, "onLongPress() chamado.");
	}

	@Override
	public boolean onScroll(MotionEvent downEvent, MotionEvent moveEvent, float distanceX, float distanceY)
	{
		mView.movePlayer(-distanceX, -distanceY);

		Log.d(TAG, "onScroll() chamado.");

		return true;

	}

	@Override
	public void onShowPress(MotionEvent event)
	{
		Log.d(TAG, "onShowPress() chamado.");
	}

	public boolean onSingleTapUp(MotionEvent event)
	{
		Log.d(TAG, "onSingleTapUp() chamado.");

		return true;
	}
}

