package com.book.c02.guessthenumber;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import java.util.Random;

public class GuessTheNumberActivity extends Activity {

    private static final String TAG = "GuessTheNumber";

    private int mCurrentNumber;

    public void compareNumbers(View v) {
        EditText edtGuess = (EditText) findViewById(R.id.edtGuess);
        TextView txtAnswer = (TextView) findViewById(R.id.txtAnswer);

        if(edtGuess.getText().toString().length() == 0) {
            txtAnswer.setText("The answer field is empty.");
        }
        else {
            int number = Integer.valueOf(edtGuess.getText().toString());

            if (number < mCurrentNumber) {
                txtAnswer.setText(R.string.low);
            } else if (number > mCurrentNumber) {
                txtAnswer.setText(R.string.high);
            } else {
                txtAnswer.setText(R.string.correct);
            }

            Log.d(TAG, "Palpite do jogador: " + String.valueOf(number));
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_guess_the_number);

        Random random = new Random();
        mCurrentNumber = random.nextInt(10) + 1;

        Log.d(TAG, "onCreate() executado.");

        Log.d(TAG, "Número a ser encontrado: " + String.valueOf(mCurrentNumber));
    }

    @Override
    protected void onStart() {
        super.onStart();
        Log.d(TAG, "onStart() executado.");
    }

    @Override
    protected void onResume() {
        super.onResume();
        Log.d(TAG, "onResume() executado.");
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.d(TAG, "onPause() executado.");
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        Log.d(TAG, "onRestart() executado.");
    }

    @Override
    protected void onStop() {
        super.onStop();
        Log.d(TAG, "onStop() executado.");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "onDestroy() executado.");
    }
}

