/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev4;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.SoundPool;
import android.util.Log;
import java.io.IOException;

public class SGSoundPool {
    private static final int MAX_SOUNDS = 16;
    private Context mContext = null;
    private SoundPool mSoundPool = new SoundPool(16, 3, 0);

    public SGSoundPool(Context context) {
        this.mContext = context;
    }

    public int loadSound(int resourceId) {
        return this.mSoundPool.load(this.mContext, resourceId, 1);
    }

    public int loadSound(String filename) {
        try {
            AssetFileDescriptor descriptor = this.mContext.getAssets().openFd(filename);
            return this.mSoundPool.load(descriptor, 1);
        }
        catch (IOException e) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SGSoundPool.loadSound(): arquivo ");
            stringBuilder.append(filename);
            stringBuilder.append(" n\u00e3o encontrado!");
            Log.d((String)"SimpleGameEngine", (String)stringBuilder.toString());
            return -1;
        }
    }

    public void playSound(int soundId, float volumeLeft, float volumeRight, int loop, float rate) {
        this.mSoundPool.play(soundId, volumeLeft, volumeRight, 0, loop, rate);
    }

    public void unloadSound(int soundId) {
        this.mSoundPool.unload(soundId);
    }
}

