/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev1;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.book.simplegameenginev1.SGInputSubscriber;
import java.util.ArrayList;

public class SGInputPublisher
implements GestureDetector.OnGestureListener {
    protected GestureDetector mGestureDetector = null;
    protected ArrayList<SGInputSubscriber> mSubscribers = new ArrayList();

    public SGInputPublisher(Context context) {
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
    }

    public void registerSubscriber(SGInputSubscriber listener) {
        this.mSubscribers.add(listener);
    }

    public boolean unregisterSubscriber(SGInputSubscriber listener) {
        return this.mSubscribers.remove(listener);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getActionMasked();
        if (action == 1) {
            for (int i = 0; i < this.mSubscribers.size(); ++i) {
                this.mSubscribers.get(i).onUp(event);
            }
            return true;
        }
        return this.mGestureDetector.onTouchEvent(event);
    }

    public boolean onDown(MotionEvent event) {
        for (int i = 0; i < this.mSubscribers.size(); ++i) {
            this.mSubscribers.get(i).onDown(event);
        }
        return true;
    }

    public boolean onFling(MotionEvent downEvent, MotionEvent moveEvent, float velocityX, float velocityY) {
        return true;
    }

    public void onLongPress(MotionEvent event) {
    }

    public boolean onScroll(MotionEvent downEvent, MotionEvent moveEvent, float distanceX, float distanceY) {
        for (int i = 0; i < this.mSubscribers.size(); ++i) {
            this.mSubscribers.get(i).onScroll(downEvent, moveEvent, distanceX, distanceY);
        }
        return true;
    }

    public void onShowPress(MotionEvent event) {
    }

    public boolean onSingleTapUp(MotionEvent event) {
        return true;
    }
}

