/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev1;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.book.simplegameenginev1.SGImage;
import java.io.IOException;
import java.io.InputStream;

public class SGImageFactory {
    protected Context mContext = null;

    public SGImageFactory(Context context) {
        this.mContext = context;
    }

    public SGImage createImage(String filename) {
        Bitmap bitmap = null;
        try {
            AssetManager assetManager = this.mContext.getAssets();
            InputStream inputStream = assetManager.open(filename);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SGImageFactory.createImage(): arquivo ");
            stringBuilder.append(filename);
            stringBuilder.append(" n\u00e3o encontrado!");
            Log.d((String)"SimpleGameEngine", (String)stringBuilder.toString());
            return null;
        }
        SGImage image = new SGImage(bitmap);
        return image;
    }

    public SGImage createImage(int resourceId) {
        Bitmap bitmap = null;
        try {
            Resources resources = this.mContext.getResources();
            InputStream inputStream = resources.openRawResource(resourceId);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        SGImage image = new SGImage(bitmap);
        return image;
    }

    public Context getContext() {
        return this.mContext;
    }
}

