/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev4;

import android.graphics.PointF;
import com.book.simplegameenginev4.SGFont;
import com.book.simplegameenginev4.SGRenderer;
import com.book.simplegameenginev4.SGText;
import com.book.simplegameenginev4.SGWidget;

public class SGWidgetLabel
extends SGWidget {
    protected SGFont mFont;
    protected SGText mText;

    public SGWidgetLabel(SGWidget.Alignment alignment, PointF position, SGFont font, String text) {
        super("label", alignment, position, new PointF(0.0f, 0.0f));
        this.mFont = font;
        this.mText = new SGText(text);
        this.mDimensions = this.mFont.measureText(this.mText);
    }

    @Override
    public void render(SGRenderer renderer) {
        renderer.drawText(this.mText, this.mFont, this.mAbsolutePosition);
    }

    @Override
    public void update() {
        PointF textDimensions = this.mFont.measureText(this.mText);
        if (this.mAlignment == SGWidget.Alignment.Left) {
            this.mAbsolutePosition.x = this.mRelativePosition.x;
        } else if (this.mAlignment == SGWidget.Alignment.Center) {
            float halfOffset = (float)(this.mSceneDimensions.x / 2) - textDimensions.x / 2.0f;
            this.mAbsolutePosition.x = halfOffset + this.mRelativePosition.x;
        } else {
            this.mAbsolutePosition.x = (float)this.mSceneDimensions.x - textDimensions.x + this.mRelativePosition.x;
        }
        this.mAbsolutePosition.y = this.mRelativePosition.y;
        this.mArea.left = this.mAbsolutePosition.x;
        this.mArea.top = this.mAbsolutePosition.y;
        this.mArea.right = this.mArea.left + this.mDimensions.x;
        this.mArea.bottom = this.mArea.top + this.mDimensions.y;
    }

    public SGFont getFont() {
        return this.mFont;
    }

    public String getString() {
        return this.mText.getString();
    }

    public void setString(String label) {
        this.mText.setString(label);
    }
}

