/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev4;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.util.Log;
import com.book.simplegameenginev4.SGFont;
import com.book.simplegameenginev4.SGImage;
import com.book.simplegameenginev4.SGText;
import com.book.simplegameenginev4.SGTileset;
import com.book.simplegameenginev4.SGViewport;

public class SGRenderer {
    private Canvas mTempCanvas;
    private Paint mTempPaint = new Paint();
    private RectF mTempDstRect = new RectF();
    private PointF mTempPosition = new PointF();
    private SGViewport mViewport;

    public void beginDrawing(Canvas canvas, int screenColor, int viewportColor) {
        this.mTempCanvas = canvas;
        this.mTempCanvas.drawColor(screenColor);
        if (this.mViewport != null) {
            canvas.clipRect(this.mViewport.getDrawingArea(), Region.Op.REPLACE);
            canvas.drawColor(viewportColor);
        }
    }

    public void endDrawing() {
    }

    public void drawRect(Rect worldDestination, int color) {
        if (this.mViewport != null) {
            Point offsetFromOrigin = this.mViewport.getOffsetFromOrigin();
            PointF scalingFactor = this.mViewport.getScalingFactor();
            this.mTempDstRect.left = (float)worldDestination.left * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.top = (float)worldDestination.top * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right = (float)worldDestination.right * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.bottom = (float)worldDestination.bottom * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempPaint.setColor(color);
            this.mTempPaint.setStyle(Paint.Style.FILL);
            this.mTempCanvas.drawRect(this.mTempDstRect, this.mTempPaint);
        } else {
            Log.d((String)"SimpleGameEngine", (String)"SGRenderer.drawImage(): viewport n\u00e3o foi definida!");
            System.exit(1);
        }
    }

    public void drawRect(RectF worldDestination, int color) {
        if (this.mViewport != null) {
            Point offsetFromOrigin = this.mViewport.getOffsetFromOrigin();
            PointF scalingFactor = this.mViewport.getScalingFactor();
            this.mTempDstRect.left = worldDestination.left * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.top = worldDestination.top * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right = worldDestination.right * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.bottom = worldDestination.bottom * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempPaint.setColor(color);
            this.mTempPaint.setStyle(Paint.Style.FILL);
            this.mTempCanvas.drawRect(this.mTempDstRect, this.mTempPaint);
        } else {
            Log.d((String)"SimpleGameEngine", (String)"SGRenderer.drawImage(): viewport n\u00e3o foi definida!");
            System.exit(1);
        }
    }

    public void drawRect(PointF worldDestination, PointF dstDimensions, int color) {
        if (this.mViewport != null) {
            Point offsetFromOrigin = this.mViewport.getOffsetFromOrigin();
            PointF scalingFactor = this.mViewport.getScalingFactor();
            this.mTempDstRect.left = worldDestination.x * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.top = worldDestination.y * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right = (worldDestination.x + dstDimensions.x) * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.bottom = (worldDestination.y + dstDimensions.y) * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempPaint.setColor(color);
            this.mTempPaint.setStyle(Paint.Style.FILL);
            this.mTempCanvas.drawRect(this.mTempDstRect, this.mTempPaint);
        } else {
            Log.d((String)"SimpleGameEngine", (String)"SGRenderer.drawImage(): viewport n\u00e3o foi definida!");
            System.exit(1);
        }
    }

    public void drawOutlineRect(Rect worldDestination, int color) {
        if (this.mViewport != null) {
            Point offsetFromOrigin = this.mViewport.getOffsetFromOrigin();
            PointF scalingFactor = this.mViewport.getScalingFactor();
            this.mTempDstRect.left = (float)worldDestination.left * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.top = (float)worldDestination.top * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right = (float)worldDestination.right * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.bottom = (float)worldDestination.bottom * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right -= 1.0f;
            this.mTempDstRect.bottom -= 1.0f;
            this.mTempPaint.setColor(color);
            this.mTempPaint.setStyle(Paint.Style.STROKE);
            this.mTempPaint.setStrokeWidth(0.0f);
            this.mTempCanvas.drawRect(this.mTempDstRect, this.mTempPaint);
        } else {
            Log.d((String)"SimpleGameEngine", (String)"SGRenderer.drawImage(): viewport n\u00e3o foi definida!");
            System.exit(1);
        }
    }

    public void drawOutlineRect(RectF worldDestination, int color) {
        if (this.mViewport != null) {
            Point offsetFromOrigin = this.mViewport.getOffsetFromOrigin();
            PointF scalingFactor = this.mViewport.getScalingFactor();
            this.mTempDstRect.left = worldDestination.left * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.top = worldDestination.top * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right = worldDestination.right * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.bottom = worldDestination.bottom * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right -= 1.0f;
            this.mTempDstRect.bottom -= 1.0f;
            this.mTempPaint.setColor(color);
            this.mTempPaint.setStyle(Paint.Style.STROKE);
            this.mTempPaint.setStrokeWidth(0.0f);
            this.mTempCanvas.drawRect(this.mTempDstRect, this.mTempPaint);
        } else {
            Log.d((String)"SimpleGameEngine", (String)"SGRenderer.drawImage(): viewport n\u00e3o foi definida!");
            System.exit(1);
        }
    }

    public void drawOutlineRect(PointF worldDestination, PointF dstDimensions, int color) {
        if (this.mViewport != null) {
            Point offsetFromOrigin = this.mViewport.getOffsetFromOrigin();
            PointF scalingFactor = this.mViewport.getScalingFactor();
            this.mTempDstRect.left = worldDestination.x * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.top = worldDestination.y * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right = (worldDestination.x + dstDimensions.x) * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.bottom = (worldDestination.y + dstDimensions.y) * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right -= 1.0f;
            this.mTempDstRect.bottom -= 1.0f;
            this.mTempPaint.setColor(color);
            this.mTempPaint.setStyle(Paint.Style.STROKE);
            this.mTempPaint.setStrokeWidth(0.0f);
            this.mTempCanvas.drawRect(this.mTempDstRect, this.mTempPaint);
        } else {
            Log.d((String)"SimpleGameEngine", (String)"SGRenderer.drawImage(): viewport n\u00e3o foi definida!");
            System.exit(1);
        }
    }

    public void drawImage(SGImage image, Rect objSource, RectF worldDestination) {
        if (this.mViewport != null) {
            Point offsetFromOrigin = this.mViewport.getOffsetFromOrigin();
            PointF scalingFactor = this.mViewport.getScalingFactor();
            this.mTempDstRect.left = worldDestination.left * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.top = worldDestination.top * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right = worldDestination.right * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.bottom = worldDestination.bottom * scalingFactor.y + (float)offsetFromOrigin.y;
            if (image != null) {
                Bitmap bitmap = image.getBitmap();
                this.mTempCanvas.drawBitmap(bitmap, objSource, this.mTempDstRect, this.mTempPaint);
            } else {
                this.drawRect(this.mTempDstRect, -65536);
            }
        } else {
            Log.d((String)"SimpleGameEngine", (String)"SGRenderer.drawImage(): viewport n\u00e3o foi definida!");
            System.exit(1);
        }
    }

    public void drawImage(SGImage image, Rect objSource, PointF worldDestination, PointF dstDimensions) {
        if (this.mViewport != null) {
            Point offsetFromOrigin = this.mViewport.getOffsetFromOrigin();
            PointF scalingFactor = this.mViewport.getScalingFactor();
            this.mTempDstRect.left = worldDestination.x * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.top = worldDestination.y * scalingFactor.y + (float)offsetFromOrigin.y;
            this.mTempDstRect.right = (worldDestination.x + dstDimensions.x) * scalingFactor.x + (float)offsetFromOrigin.x;
            this.mTempDstRect.bottom = (worldDestination.y + dstDimensions.y) * scalingFactor.y + (float)offsetFromOrigin.y;
            if (image != null) {
                Bitmap bitmap = image.getBitmap();
                this.mTempCanvas.drawBitmap(bitmap, objSource, this.mTempDstRect, this.mTempPaint);
            } else {
                this.drawRect(this.mTempDstRect, -65536);
            }
        } else {
            Log.d((String)"SimpleGameEngine", (String)"SGRenderer.drawImage(): viewport n\u00e3o foi definida!");
            System.exit(1);
        }
    }

    public void drawText(SGText text, SGFont font, PointF worldDestination) {
        SGTileset fontTileSet = font.getTileSet();
        char[] textChars = text.getCharacters();
        this.mTempPosition.set(worldDestination);
        for (int i = 0; i < textChars.length; ++i) {
            Rect character = fontTileSet.getTile(textChars[i]);
            this.drawImage(fontTileSet.getImage(), character, this.mTempPosition, font.getFontDimensions());
            this.mTempPosition.x += font.getFontDimensions().x;
        }
    }

    public SGViewport getViewport() {
        return this.mViewport;
    }

    public void setViewport(SGViewport viewport) {
        this.mViewport = viewport;
    }
}

