/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev2;

import android.app.Activity;
import android.content.SharedPreferences;
import android.util.Log;

public class SGPreferences {
    private SharedPreferences.Editor mEditor = null;
    private SharedPreferences mPreferences = null;

    public SGPreferences(Activity activity) {
        this.mPreferences = activity.getPreferences(0);
    }

    public SGPreferences begin() {
        this.mEditor = this.mPreferences.edit();
        return this;
    }

    public void end() {
        this.mEditor.commit();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.mPreferences.getBoolean(key, defaultValue);
        }
        catch (ClassCastException e) {
            Log.d((String)"SimpleGameEngine", (String)"SGPreferences.getBoolean(): Valor possui um tipo diferente!");
            return defaultValue;
        }
    }

    public float getFloat(String key, float defaultValue) {
        try {
            return this.mPreferences.getFloat(key, defaultValue);
        }
        catch (Exception e) {
            Log.d((String)"SimpleGameEngine", (String)"SGPreferences.getFloat(): Valor possui um tipo diferente!");
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            return this.mPreferences.getInt(key, defaultValue);
        }
        catch (Exception e) {
            Log.d((String)"SimpleGameEngine", (String)"SGPreferences.getInt(): Valor possui um tipo diferente!");
            return defaultValue;
        }
    }

    public long getLong(String key, long defaultValue) {
        try {
            return this.mPreferences.getLong(key, defaultValue);
        }
        catch (Exception e) {
            Log.d((String)"SimpleGameEngine", (String)"SGPreferences.getLong(): Valor possui um tipo diferente!");
            return defaultValue;
        }
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.mPreferences.getString(key, defaultValue);
        }
        catch (Exception e) {
            Log.d((String)"SimpleGameEngine", (String)"SGPreferences.getString(): Valor possui um tipo diferente!");
            return defaultValue;
        }
    }

    public SGPreferences putBoolean(String key, boolean value) {
        this.mEditor.putBoolean(key, value);
        return this;
    }

    public SGPreferences putFloat(String key, float value) {
        this.mEditor.putFloat(key, value);
        return this;
    }

    public SGPreferences putInt(String key, int value) {
        this.mEditor.putInt(key, value);
        return this;
    }

    public SGPreferences putLong(String key, long value) {
        this.mEditor.putLong(key, value);
        return this;
    }

    public SGPreferences putString(String key, String value) {
        this.mEditor.putString(key, value);
        return this;
    }

    public SGPreferences remove(String key) {
        this.mEditor.remove(key);
        return this;
    }
}

