/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev4;

import android.graphics.PointF;
import android.graphics.RectF;
import com.book.simplegameenginev4.SGRenderer;
import com.book.simplegameenginev4.SGWidget;
import java.util.HashMap;
import java.util.Map;

public class SGWidgetContainer
extends SGWidget {
    protected HashMap<String, SGWidget> mChildren = new HashMap();

    public SGWidgetContainer(SGWidget.Alignment alignment, PointF position, PointF dimensions) {
        super("container", alignment, position, dimensions);
        if (dimensions.x == 0.0f || dimensions.y == 0.0f) {
            this.mArea.set(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        }
    }

    public void addChild(String name, SGWidget widget) {
        this.mChildren.put(name, widget);
        widget.setSceneDimensions(this.mSceneDimensions);
        widget.setParent(this);
        this._updateArea();
    }

    public SGWidget removeChild(String name) {
        SGWidget widget = this.mChildren.remove(name);
        widget.setParent(null);
        this._updateArea();
        return widget;
    }

    private void _updateArea() {
        if (!this.mChildren.isEmpty()) {
            for (Map.Entry<String, SGWidget> entry : this.mChildren.entrySet()) {
                SGWidget widget = entry.getValue();
                RectF childArea = widget.getArea();
                if (Float.isNaN(this.mArea.left) || childArea.left < this.mArea.left) {
                    this.mArea.left = childArea.left;
                }
                if (Float.isNaN(this.mArea.right) || childArea.right > this.mArea.right) {
                    this.mArea.right = childArea.right;
                }
                if (Float.isNaN(this.mArea.bottom) || childArea.bottom > this.mArea.bottom) {
                    this.mArea.bottom = childArea.bottom;
                }
                if (!Float.isNaN(this.mArea.top) && !(childArea.top < this.mArea.top)) continue;
                this.mArea.top = childArea.top;
            }
        } else {
            this.mArea.set(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        }
    }

    @Override
    public boolean injectDown(PointF position) {
        for (Map.Entry<String, SGWidget> entry : this.mChildren.entrySet()) {
            SGWidget widget = entry.getValue();
            if (!widget.isEnabled()) continue;
            RectF area = widget.getArea();
            if (!(position.x >= area.left) || !(position.x <= area.right) || !(position.y >= area.top) || !(position.y <= area.bottom) || !entry.getValue().injectDown(position)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean injectUp(PointF position) {
        for (Map.Entry<String, SGWidget> entry : this.mChildren.entrySet()) {
            SGWidget widget = entry.getValue();
            if (!widget.isEnabled()) continue;
            RectF area = widget.getArea();
            if (!(position.x >= area.left) || !(position.x <= area.right) || !(position.y >= area.top) || !(position.y <= area.bottom) || !entry.getValue().injectUp(position)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void render(SGRenderer renderer) {
        for (Map.Entry<String, SGWidget> entry : this.mChildren.entrySet()) {
            SGWidget widget = entry.getValue();
            if (!widget.isVisible()) continue;
            widget.render(renderer);
        }
    }

    @Override
    public void update() {
        super.update();
        for (Map.Entry<String, SGWidget> entry : this.mChildren.entrySet()) {
            SGWidget widget = entry.getValue();
            widget.update();
        }
        this._updateArea();
    }

    public SGWidget getChild(String name) {
        return this.mChildren.get(name);
    }
}

