/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev4;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import com.book.simplegameenginev4.SGRenderer;

public class SGWidget {
    protected PointF mAbsolutePosition = new PointF();
    protected Alignment mAlignment = Alignment.Left;
    protected RectF mArea = new RectF();
    protected PointF mDimensions = new PointF();
    protected boolean mIsEnabled = true;
    protected boolean mIsVisible = true;
    protected SGWidget mParent = null;
    protected PointF mRelativePosition = new PointF();
    protected Point mSceneDimensions = new Point();
    protected String mType;

    public SGWidget(String type, Alignment alignment, PointF relativePosition, PointF dimensions) {
        this.mType = type;
        this.mAlignment = alignment;
        this.mRelativePosition.set(relativePosition.x, relativePosition.y);
        this.mDimensions.set(dimensions.x, dimensions.y);
    }

    public void setSceneDimensions(Point sceneDimensions) {
        this.mSceneDimensions = sceneDimensions;
        this.update();
    }

    public void update() {
        if (this.mAlignment == Alignment.Left) {
            this.mAbsolutePosition.x = this.mRelativePosition.x;
        } else if (this.mAlignment == Alignment.Center) {
            float halfOffset = (float)(this.mSceneDimensions.x / 2) - this.mDimensions.x / 2.0f;
            this.mAbsolutePosition.x = halfOffset + this.mRelativePosition.x;
        } else {
            this.mAbsolutePosition.x = (float)this.mSceneDimensions.x + this.mRelativePosition.x;
        }
        this.mAbsolutePosition.y = this.mRelativePosition.y;
        this.mArea.left = this.mAbsolutePosition.x;
        this.mArea.top = this.mAbsolutePosition.y;
        this.mArea.right = this.mArea.left + this.mDimensions.x;
        this.mArea.bottom = this.mArea.top + this.mDimensions.y;
    }

    public boolean injectDown(PointF position) {
        return this.onDown(position);
    }

    public boolean injectUp(PointF position) {
        return this.onUp(position);
    }

    public boolean onDown(PointF position) {
        return false;
    }

    public boolean onUp(PointF position) {
        return false;
    }

    public void render(SGRenderer renderer) {
    }

    public PointF getAbsolutePosition() {
        return this.mAbsolutePosition;
    }

    public Alignment getAlignment() {
        return this.mAlignment;
    }

    public RectF getArea() {
        return this.mArea;
    }

    public PointF getDimensions() {
        return this.mDimensions;
    }

    public SGWidget getParent() {
        return this.mParent;
    }

    public PointF getRelativePosition() {
        return this.mAbsolutePosition;
    }

    public String getType() {
        return this.mType;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public void setAlignment(Alignment alignment) {
        this.mAlignment = alignment;
        this.update();
    }

    public void setArea(float left, float top, float right, float bottom) {
        this.mArea.set(left, top, right, bottom);
    }

    public void setIsEnabled(boolean isEnabled) {
        this.mIsEnabled = isEnabled;
    }

    public void setIsVisible(boolean isVisible) {
        this.mIsVisible = isVisible;
    }

    public void setParent(SGWidget parent) {
        this.mParent = parent;
    }

    public static enum Alignment {
        Center,
        Left,
        Right;

    }
}

