/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev3;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import com.book.simplegameenginev3.SGImage;

public class SGRenderer {
    private Canvas mTempCanvas;
    private Paint mTempPaint = new Paint();
    private RectF mTempDstRect = new RectF();

    public void beginDrawing(Canvas canvas, int backgroundColor) {
        this.mTempCanvas = canvas;
        canvas.drawColor(backgroundColor);
    }

    public void endDrawing() {
    }

    public void drawRect(Rect source, int color) {
        this.mTempPaint.setColor(color);
        this.mTempPaint.setStyle(Paint.Style.FILL);
        this.mTempCanvas.drawRect(source, this.mTempPaint);
    }

    public void drawRect(RectF source, int color) {
        this.mTempPaint.setColor(color);
        this.mTempPaint.setStyle(Paint.Style.FILL);
        this.mTempCanvas.drawRect(source, this.mTempPaint);
    }

    public void drawRect(PointF position, PointF dimensions, int color) {
        this.mTempPaint.setColor(color);
        this.mTempPaint.setStyle(Paint.Style.FILL);
        this.mTempDstRect.set(position.x, position.y, position.x + dimensions.x, position.y + dimensions.y);
        this.mTempCanvas.drawRect(this.mTempDstRect, this.mTempPaint);
    }

    public void drawOutlineRect(Rect worldSpaceDestination, int color) {
        this.mTempPaint.setColor(color);
        this.mTempPaint.setStyle(Paint.Style.STROKE);
        this.mTempPaint.setStrokeWidth(0.0f);
        this.mTempDstRect.set(worldSpaceDestination);
        this.mTempDstRect.right -= 1.0f;
        this.mTempDstRect.bottom -= 1.0f;
        this.mTempCanvas.drawRect(this.mTempDstRect, this.mTempPaint);
    }

    public void drawOutlineRect(RectF worldSpaceDestination, int color) {
        this.mTempPaint.setColor(color);
        this.mTempPaint.setStyle(Paint.Style.STROKE);
        this.mTempPaint.setStrokeWidth(0.0f);
        this.mTempDstRect.set(worldSpaceDestination);
        this.mTempDstRect.right -= 1.0f;
        this.mTempDstRect.bottom -= 1.0f;
        this.mTempCanvas.drawRect(this.mTempDstRect, this.mTempPaint);
    }

    public void drawOutlineRect(PointF position, PointF dimensions, int color) {
        this.mTempPaint.setColor(color);
        this.mTempPaint.setStyle(Paint.Style.STROKE);
        this.mTempPaint.setStrokeWidth(0.0f);
        this.mTempDstRect.set(position.x, position.y, position.x + dimensions.x, position.y + dimensions.y);
        this.mTempDstRect.right -= 1.0f;
        this.mTempDstRect.bottom -= 1.0f;
        this.mTempCanvas.drawRect(this.mTempDstRect, this.mTempPaint);
    }

    public void drawImage(SGImage image, Rect source, RectF destination) {
        if (image != null) {
            Bitmap bitmap = image.getBitmap();
            this.mTempCanvas.drawBitmap(bitmap, source, destination, this.mTempPaint);
        } else {
            this.drawRect(destination, -65536);
        }
    }

    public void drawImage(SGImage image, Rect source, PointF dstPosition, PointF dstDimensions) {
        this.mTempDstRect.set(dstPosition.x, dstPosition.y, dstPosition.x + dstDimensions.x, dstPosition.y + dstDimensions.y);
        if (image != null) {
            Bitmap bitmap = image.getBitmap();
            this.mTempCanvas.drawBitmap(bitmap, source, this.mTempDstRect, this.mTempPaint);
        } else {
            this.drawRect(this.mTempDstRect, -65536);
        }
    }
}

