/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev3;

import android.util.Log;

public class SGAnimation {
    protected float mAccumulator;
    protected int mCurrentIndex;
    protected float mFrameDuration;
    protected boolean mHasStarted;
    protected boolean mIsRunning;
    protected int mNumberOfRepetitions;
    protected boolean mResetAfterRunning;
    protected int[] mTiles;

    public SGAnimation(int[] tiles, float frameDurationInSeconds) {
        if (frameDurationInSeconds < 0.0f) {
            Log.e((String)"SimpleGameEngine", (String)(Float.toString(frameDurationInSeconds) + " n\u00e3o \u00e9 um valor v\u00e1lido para" + " frameDurationInSeconds."));
            throw new Error();
        }
        this.mTiles = tiles;
        this.mCurrentIndex = 0;
        this.mFrameDuration = frameDurationInSeconds;
        this.mResetAfterRunning = true;
    }

    public void start(int numberOfRepetitions) {
        this.mIsRunning = true;
        this.mHasStarted = true;
        this.mNumberOfRepetitions = numberOfRepetitions;
    }

    public void play() {
        if (this.mHasStarted) {
            this.mIsRunning = true;
        }
    }

    public void pause() {
        if (this.mHasStarted) {
            this.mIsRunning = false;
        }
    }

    public void reset() {
        this.mCurrentIndex = 0;
    }

    public void stop() {
        this.mHasStarted = false;
        this.mIsRunning = false;
        this.mCurrentIndex = this.mResetAfterRunning ? 0 : this.mTiles.length - 1;
    }

    public int step(float elapsedTimeInSeconds) {
        this.mAccumulator += elapsedTimeInSeconds;
        while (this.mAccumulator > this.mFrameDuration) {
            if (this.mIsRunning && this.mFrameDuration > 0.0f) {
                ++this.mCurrentIndex;
                if (this.mCurrentIndex == this.mTiles.length) {
                    if (this.mNumberOfRepetitions > 0) {
                        if (--this.mNumberOfRepetitions == 0) {
                            this.stop();
                        } else {
                            this.reset();
                        }
                    } else {
                        this.reset();
                    }
                }
            }
            this.mAccumulator -= this.mFrameDuration;
        }
        return this.mTiles[this.mCurrentIndex];
    }

    public int getCurrentTile() {
        return this.mTiles[this.mCurrentIndex];
    }

    public void setResetAfterRunning(boolean reset) {
        this.mResetAfterRunning = reset;
    }
}

