/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev2;

import android.util.Log;

public class SGTimer {
    protected float mAccumulator = 0.0f;
    protected boolean mHasStarted = false;
    protected float mInterval = 0.0f;

    public SGTimer(float interval) {
        if (interval > 0.0f) {
            this.mInterval = interval;
        } else {
            Log.d((String)"SimpleGameEngine", (String)"SGTimer: intervalo inv\u00e1lido.");
        }
    }

    public void onInterval() {
    }

    public void start() {
        this.mHasStarted = true;
    }

    public void stop() {
        this.mHasStarted = false;
    }

    public boolean step(float elapsedTimeInSeconds) {
        if (this.mHasStarted) {
            this.mAccumulator += elapsedTimeInSeconds;
            if (this.mAccumulator >= this.mInterval) {
                this.mAccumulator -= this.mInterval;
                this.onInterval();
                return true;
            }
        }
        return false;
    }

    public void reset() {
        this.mAccumulator = 0.0f;
    }

    public void stopAndReset() {
        this.mHasStarted = false;
        this.mAccumulator = 0.0f;
    }

    public float getInterval() {
        return this.mInterval;
    }

    public boolean hasStarted() {
        return this.mHasStarted;
    }
}

