/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev4;

import android.graphics.PointF;
import android.util.Log;
import com.book.simplegameenginev4.SGGui;
import com.book.simplegameenginev4.SGRenderer;
import com.book.simplegameenginev4.SGTileset;
import com.book.simplegameenginev4.SGWidget;

public class SGWidgetButton
extends SGWidget {
    protected int mCurrentTile = 0;
    protected SGGui mGui;
    protected SGTileset mTileset = null;

    public SGWidgetButton(SGWidget.Alignment alignment, PointF position, PointF dimensions, SGTileset tileset, SGGui gui) {
        super("button", alignment, position, dimensions);
        this.mTileset = tileset;
        this.mGui = gui;
    }

    @Override
    public void render(SGRenderer renderer) {
        renderer.drawImage(this.mTileset.getImage(), this.mTileset.getTile(this.mCurrentTile), this.mArea);
    }

    @Override
    public boolean injectDown(PointF position) {
        if (this.mIsEnabled) {
            Log.d((String)"SimpleGameEngineV4", (String)"injectDown");
            this.mGui.setCurrentButton(this);
            this.mCurrentTile = 1;
            return this.onDown(position);
        }
        return false;
    }

    @Override
    public boolean injectUp(PointF position) {
        if (this.mIsEnabled) {
            if (this.mGui.getCurrentButton() == this) {
                this.mGui.setCurrentButton(null);
                this.mCurrentTile = 0;
                return this.onUp(position);
            }
            if (this.mGui.getCurrentButton() != null) {
                this.mGui.getCurrentButton().reset();
                this.mGui.setCurrentButton(null);
                return false;
            }
            return false;
        }
        if (this.mGui.getCurrentButton() != null) {
            this.mGui.getCurrentButton().reset();
            this.mGui.setCurrentButton(null);
        }
        return false;
    }

    @Override
    public boolean onDown(PointF position) {
        return true;
    }

    @Override
    public boolean onUp(PointF position) {
        return true;
    }

    public void reset() {
        this.mCurrentTile = 0;
    }
}

