/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev4;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;

public class SGViewport {
    private Rect mDrawingArea = new Rect();
    private Point mOffsetFromOrigin = new Point();
    private PointF mScalingFactor = new PointF();

    public SGViewport(Point sceneDimensions, Point screenDimensions, ScalingMode scalingMode) {
        if (scalingMode == ScalingMode.FULL_SCREEN) {
            this.mScalingFactor.set((float)screenDimensions.x / (float)sceneDimensions.x, (float)screenDimensions.y / (float)sceneDimensions.y);
        } else if (scalingMode == ScalingMode.FULL_SCREEN_KEEP_ORIGINAL_ASPECT) {
            this.mScalingFactor.set((float)screenDimensions.x / (float)sceneDimensions.x, (float)screenDimensions.y / (float)sceneDimensions.y);
            if (this.mScalingFactor.x > this.mScalingFactor.y) {
                this.mScalingFactor.x = this.mScalingFactor.y;
            } else {
                this.mScalingFactor.y = this.mScalingFactor.x;
            }
        } else if (scalingMode == ScalingMode.INTEGER_RATIO) {
            this.mScalingFactor.set((float)screenDimensions.x / (float)sceneDimensions.x, (float)screenDimensions.y / (float)sceneDimensions.y);
            if (this.mScalingFactor.x >= 1.0f && this.mScalingFactor.y >= 1.0f) {
                if (this.mScalingFactor.x > this.mScalingFactor.y) {
                    this.mScalingFactor.x = this.mScalingFactor.y = (float)((int)this.mScalingFactor.y);
                } else {
                    this.mScalingFactor.y = this.mScalingFactor.x = (float)((int)this.mScalingFactor.x);
                }
            }
        } else {
            this.mScalingFactor.x = 1.0f;
            this.mScalingFactor.y = 1.0f;
        }
        this.mOffsetFromOrigin.x = (int)(((float)screenDimensions.x - (float)sceneDimensions.x * this.mScalingFactor.x) / 2.0f);
        this.mOffsetFromOrigin.y = (int)(((float)screenDimensions.y - (float)sceneDimensions.y * this.mScalingFactor.y) / 2.0f);
        this.mDrawingArea.left = this.mOffsetFromOrigin.x;
        this.mDrawingArea.top = this.mOffsetFromOrigin.y;
        this.mDrawingArea.right = (int)((float)sceneDimensions.x * this.mScalingFactor.x + (float)this.mOffsetFromOrigin.x);
        this.mDrawingArea.bottom = (int)((float)sceneDimensions.y * this.mScalingFactor.y + (float)this.mOffsetFromOrigin.y);
    }

    public Rect getDrawingArea() {
        return this.mDrawingArea;
    }

    public Point getOffsetFromOrigin() {
        return this.mOffsetFromOrigin;
    }

    public PointF getScalingFactor() {
        return this.mScalingFactor;
    }

    public static enum ScalingMode {
        FULL_SCREEN,
        FULL_SCREEN_KEEP_ORIGINAL_ASPECT,
        INTEGER_RATIO,
        ORIGINAL;

    }
}

