/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev4;

import android.graphics.Point;
import android.graphics.PointF;
import com.book.simplegameenginev4.SGRenderer;
import com.book.simplegameenginev4.SGWidget;
import com.book.simplegameenginev4.SGWidgetButton;
import com.book.simplegameenginev4.SGWidgetContainer;

public class SGGui {
    private SGWidgetButton mCurrentButton = null;
    private SGRenderer mRenderer;
    private SGWidgetContainer mRoot;
    private PointF mTempPosition = new PointF();

    public SGGui(SGRenderer renderer, Point sceneDimensions) {
        this.mRenderer = renderer;
        PointF position = new PointF(0.0f, 0.0f);
        PointF dimensions = new PointF((float)sceneDimensions.x, (float)sceneDimensions.y);
        this.mRoot = new SGWidgetContainer(SGWidget.Alignment.Left, position, dimensions);
        this.mRoot.setSceneDimensions(sceneDimensions);
    }

    public boolean injectDown(PointF position) {
        return this.mRoot.injectDown(this._screenToScene(position));
    }

    public boolean injectUp(PointF position) {
        boolean result = this.mRoot.injectUp(this._screenToScene(position));
        if (!result && this.mCurrentButton != null) {
            this.mCurrentButton.reset();
            this.mCurrentButton = null;
        }
        return result;
    }

    public void render() {
        this.mRoot.render(this.mRenderer);
    }

    public void update() {
        this.mRoot.update();
    }

    public SGWidgetButton getCurrentButton() {
        return this.mCurrentButton;
    }

    public SGWidgetContainer getRoot() {
        return this.mRoot;
    }

    public void setCurrentButton(SGWidgetButton currentButton) {
        this.mCurrentButton = currentButton;
    }

    private PointF _screenToScene(PointF position) {
        Point offsetFromOrigin = this.mRenderer.getViewport().getOffsetFromOrigin();
        PointF scalingFactor = this.mRenderer.getViewport().getScalingFactor();
        this.mTempPosition.x = (position.x - (float)offsetFromOrigin.x) / scalingFactor.x;
        this.mTempPosition.y = (position.y - (float)offsetFromOrigin.y) / scalingFactor.y;
        return this.mTempPosition;
    }
}

