/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev3;

import android.graphics.PointF;
import android.graphics.RectF;
import com.book.simplegameenginev3.SGEntity;
import com.book.simplegameenginev3.SGWorld;
import java.util.ArrayList;

public class SGTrigger
extends SGEntity {
    private ArrayList<SGEntity> mObservedEntities = new ArrayList();

    public SGTrigger(SGWorld world, int id, PointF position, PointF dimensions) {
        super(world, id, "trigger", position, dimensions);
        this.setDebugColor(-65281);
        this.setDebugDrawingStyle(SGEntity.DebugDrawingStyle.OUTLINE);
    }

    public boolean addObservedEntity(SGEntity entity) {
        if (this.mObservedEntities.contains(entity)) {
            return false;
        }
        this.mObservedEntities.add(entity);
        return true;
    }

    public boolean removeObservedEntity(SGEntity entity) {
        return this.mObservedEntities.remove(entity);
    }

    public void onHit(SGEntity entity, float elapsedTimeInSeconds) {
    }

    @Override
    public void step(float elapsedTimeInSeconds) {
        SGWorld world = this.getWorld();
        RectF triggerBoundingBox = this.getBoundingBox();
        int arraySize = this.mObservedEntities.size();
        for (int i = 0; i < arraySize; ++i) {
            SGEntity currentEntity = this.mObservedEntities.get(i);
            if (!world.collisionTest(triggerBoundingBox, currentEntity.getBoundingBox())) continue;
            this.onHit(currentEntity, elapsedTimeInSeconds);
        }
    }
}

