/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev3;

import android.graphics.PointF;
import android.graphics.RectF;
import com.book.simplegameenginev3.SGWorld;

public class SGEntity {
    protected RectF mBBoxPadding = new RectF();
    protected RectF mBoundingBox = new RectF();
    private String mCategory;
    protected int mDebugColor = -65536;
    private DebugDrawingStyle mDebugDrawingStyle = DebugDrawingStyle.FILLED;
    protected PointF mDimensions = new PointF();
    private int mId;
    private boolean mIsActive = true;
    protected PointF mPosition = new PointF();
    private SGWorld mWorld;

    public SGEntity(SGWorld world, int id, String category, PointF position, PointF dimensions) {
        this.mWorld = world;
        this.mId = id;
        this.mCategory = category;
        this.mPosition.set(position);
        this.mDimensions.set(dimensions);
        this._updateBoundingBox();
    }

    public void move(float offsetX, float offsetY) {
        this.mPosition.x += offsetX;
        this.mPosition.y += offsetY;
        this._updateBoundingBox();
    }

    public void step(float elapsedTimeInSeconds) {
    }

    private void _updateBoundingBox() {
        this.mBoundingBox.set(this.mPosition.x + this.mBBoxPadding.left, this.mPosition.y + this.mBBoxPadding.top, this.mPosition.x + this.mDimensions.x - this.mBBoxPadding.right, this.mPosition.y + this.mDimensions.y - this.mBBoxPadding.bottom);
    }

    public RectF getBoundingBox() {
        return this.mBoundingBox;
    }

    public RectF getBBoxPadding() {
        return this.mBBoxPadding;
    }

    public String getCategory() {
        return this.mCategory;
    }

    public int getDebugColor() {
        return this.mDebugColor;
    }

    public DebugDrawingStyle getDebugDrawingStyle() {
        return this.mDebugDrawingStyle;
    }

    public PointF getDimensions() {
        return this.mDimensions;
    }

    public int getId() {
        return this.mId;
    }

    public PointF getPosition() {
        return this.mPosition;
    }

    public SGWorld getWorld() {
        return this.mWorld;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public void setBBoxPadding(RectF padding) {
        this.mBBoxPadding.set(padding);
        this._updateBoundingBox();
    }

    public void setDebugColor(int color) {
        this.mDebugColor = color;
    }

    public void setDebugDrawingStyle(DebugDrawingStyle drawingStyle) {
        this.mDebugDrawingStyle = drawingStyle;
    }

    public void setDimensions(float x, float y) {
        this.mDimensions.set(x, y);
    }

    public void setDimensions(PointF dimensions) {
        this.mDimensions.set(dimensions);
    }

    public void setIsActive(boolean isActive) {
        this.mIsActive = isActive;
    }

    public void setPosition(float x, float y) {
        this.mPosition.set(x, y);
        this._updateBoundingBox();
    }

    public void setPosition(PointF position) {
        this.mPosition.set(position);
        this._updateBoundingBox();
    }

    public static enum DebugDrawingStyle {
        FILLED,
        OUTLINE;

    }
}

