/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev3;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.Window;
import com.book.simplegameenginev3.SGInputPublisher;

public class SGActivity
extends Activity {
    public static final String TAG = "SimpleGameEngine";
    protected SGInputPublisher mInputPublisher = null;

    public void enableFullScreen() {
        Window window = this.getWindow();
        window.addFlags(1024);
        window.requestFeature(1);
        if (Build.VERSION.SDK_INT >= 19) {
            window.getDecorView().setSystemUiVisibility(4098);
        }
    }

    public void enableKeepScreenOn() {
        Window window = this.getWindow();
        window.addFlags(128);
    }

    public void setOrientation(SGOrientation orientation) {
        switch (orientation) {
            case LANDSCAPE: {
                this.setRequestedOrientation(0);
                break;
            }
            case PORTRAIT: {
                this.setRequestedOrientation(1);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mInputPublisher != null) {
            return this.mInputPublisher.onTouchEvent(event);
        }
        return false;
    }

    public void setInputPublisher(SGInputPublisher inputPublisher) {
        this.mInputPublisher = inputPublisher;
    }

    public SGInputPublisher getInputPublisher() {
        return this.mInputPublisher;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void onDestroy() {
        super.onDestroy();
        Log.d((String)TAG, (String)"onDestroy() chamado.");
    }

    protected void onPause() {
        super.onPause();
        Log.d((String)TAG, (String)"onPause() chamado.");
    }

    protected void onRestart() {
        super.onRestart();
        Log.d((String)TAG, (String)"onRestart() chamado.");
    }

    protected void onResume() {
        super.onResume();
        Log.d((String)TAG, (String)"onResume() chamado.");
    }

    protected void onStart() {
        super.onStart();
        Log.d((String)TAG, (String)"onStart() chamado.");
    }

    protected void onStop() {
        super.onStop();
        Log.d((String)TAG, (String)"onStop() chamado.");
    }

    public static enum SGOrientation {
        LANDSCAPE,
        PORTRAIT;

    }
}

