/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev3;

import android.graphics.PointF;
import android.util.Log;
import com.book.simplegameenginev3.SGAnimation;
import com.book.simplegameenginev3.SGEntity;
import com.book.simplegameenginev3.SGImage;
import com.book.simplegameenginev3.SGSpriteDesc;
import com.book.simplegameenginev3.SGTileset;
import java.util.HashMap;

public class SGSprite {
    private static StringBuilder stringBuilder = new StringBuilder();
    private HashMap<String, SGAnimation> mAnimations = new HashMap();
    private SGAnimation mCurrentAnimation;
    private PointF mDimensions = new PointF();
    private SGEntity mEntity;
    private boolean mIsVisible = true;
    private PointF mPosition = new PointF();
    private SGTileset mTileset = null;

    public SGSprite(SGSpriteDesc spriteDesc) {
        this.mTileset = spriteDesc.getTileset();
        this.mAnimations = spriteDesc.getAnimations();
    }

    public SGSprite(SGSpriteDesc spriteDesc, SGEntity entity) {
        this.mEntity = entity;
        this.mPosition.set(this.mEntity.getPosition());
        this.mDimensions.set(this.mEntity.getDimensions());
        this.mTileset = spriteDesc.getTileset();
        this.mAnimations = spriteDesc.getAnimations();
    }

    public void changeDesc(SGSpriteDesc spriteDesc) {
        this.mTileset = spriteDesc.getTileset();
        this.mAnimations = spriteDesc.getAnimations();
    }

    public void step(float elapsedTimeInSeconds) {
        this.mCurrentAnimation.step(elapsedTimeInSeconds);
        if (this.mEntity != null) {
            this.mPosition.set(this.mEntity.getPosition());
            this.mDimensions.set(this.mEntity.getDimensions());
        }
    }

    public SGAnimation getAnimation(String animationName) {
        SGAnimation animation = this.mAnimations.get(animationName);
        if (animation == null) {
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append("SGEntity.getAnimation(): A entidade '");
            stringBuilder.append(this.mEntity.getId());
            stringBuilder.append("' n\u00e3o possui uma anima\u00e7\u00e3o de nome '");
            stringBuilder.append(animationName);
            stringBuilder.append("'");
            Log.d((String)"SimpleGameEngine", (String)stringBuilder.toString());
        }
        return animation;
    }

    public SGAnimation getCurrentAnimation() {
        return this.mCurrentAnimation;
    }

    public PointF getDimensions() {
        return this.mDimensions;
    }

    public SGEntity getEntity() {
        return this.mEntity;
    }

    public SGImage getImage() {
        return this.mTileset.getImage();
    }

    public PointF getPosition() {
        return this.mPosition;
    }

    public SGTileset getTileSet() {
        return this.mTileset;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public void setCurrentAnimation(String animationName, boolean stopCurrentAnimation) {
        SGAnimation animation = this.mAnimations.get(animationName);
        if (animation != null && animation != this.mCurrentAnimation) {
            if (this.mCurrentAnimation != null && stopCurrentAnimation) {
                this.mCurrentAnimation.stop();
            }
            this.mCurrentAnimation = animation;
        }
    }

    public void setDimensions(PointF dimensions) {
        if (this.mEntity != null) {
            this.mDimensions = dimensions;
        }
    }

    public void setEntity(SGEntity entity) {
        this.mEntity = entity;
    }

    public void setIsVisible(boolean isVisible) {
        this.mIsVisible = isVisible;
    }

    public void setPosition(PointF position) {
        if (this.mEntity != null) {
            this.mPosition = position;
        }
    }
}

