/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev3;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import com.book.simplegameenginev3.SGImage;

public class SGTileset {
    protected Point m2dNumberOfTiles = new Point();
    protected PointF mDimensions = new PointF();
    protected Rect mDrawableTileArea = new Rect();
    protected SGImage mImage;
    protected Rect mTempTileArea = new Rect();
    protected Point mTileDimensions = new Point(0, 0);

    public SGTileset(SGImage image, Point tilesNum, Rect drawableTileArea) {
        this.mDimensions.set((float)image.getDimensions().x, (float)image.getDimensions().y);
        this.mImage = image;
        this.m2dNumberOfTiles.set(tilesNum.x, tilesNum.y);
        this.mTileDimensions.x = (int)this.mDimensions.x / this.m2dNumberOfTiles.x;
        this.mTileDimensions.y = (int)this.mDimensions.y / this.m2dNumberOfTiles.y;
        if (drawableTileArea != null) {
            this.mDrawableTileArea.set(drawableTileArea);
        } else {
            this.mDrawableTileArea.set(0, 0, this.mTileDimensions.x, this.mTileDimensions.y);
        }
    }

    public PointF getDimensions() {
        return this.mDimensions;
    }

    public Rect getDrawableTileArea() {
        return this.mDrawableTileArea;
    }

    public SGImage getImage() {
        return this.mImage;
    }

    public int get1dNumberOfTiles() {
        return this.m2dNumberOfTiles.x * this.m2dNumberOfTiles.y;
    }

    public Point get2dNumberOfTiles() {
        return this.m2dNumberOfTiles;
    }

    public Point getTileDimensions() {
        return this.mTileDimensions;
    }

    public Rect getTile(int x, int y) {
        int left = this.mTileDimensions.x * x;
        int top = this.mTileDimensions.y * y;
        this.mTempTileArea.set(left + this.mDrawableTileArea.left, top + this.mDrawableTileArea.top, left + this.mDrawableTileArea.right, top + this.mDrawableTileArea.bottom);
        return this.mTempTileArea;
    }

    public Rect getTile(int index) {
        int x = index % this.m2dNumberOfTiles.x;
        int y = index / this.m2dNumberOfTiles.x;
        int left = this.mTileDimensions.x * x;
        int top = this.mTileDimensions.y * y;
        this.mTempTileArea.set(left + this.mDrawableTileArea.left, top + this.mDrawableTileArea.top, left + this.mDrawableTileArea.right, top + this.mDrawableTileArea.bottom);
        return this.mTempTileArea;
    }
}

