/*
 * Decompiled with CFR 0.152.
 */
package com.book.simplegameenginev3;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import java.io.IOException;

public class SGMusicPlayer {
    private Context mContext = null;
    private MediaPlayer mMediaPlayer = null;
    private boolean mHasInitialized = false;
    private boolean mIsPaused = false;
    private boolean mIsPlaying = false;

    public SGMusicPlayer(Context context) {
        this.mContext = context;
        this.mMediaPlayer = new MediaPlayer();
    }

    public void loadMusic(String filename) {
        if (this.mHasInitialized) {
            this.mMediaPlayer.reset();
        }
        try {
            AssetFileDescriptor descriptor = this.mContext.getAssets().openFd(filename);
            this.mMediaPlayer.setDataSource(descriptor.getFileDescriptor(), descriptor.getStartOffset(), descriptor.getLength());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mHasInitialized = true;
    }

    public void play(boolean enableLooping, float leftVolume, float rightVolume) {
        if (this.mHasInitialized) {
            try {
                this.mMediaPlayer.prepare();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mMediaPlayer.setVolume(leftVolume, rightVolume);
            if (enableLooping) {
                this.mMediaPlayer.setLooping(true);
            }
            this.mMediaPlayer.start();
            this.mIsPaused = false;
            this.mIsPlaying = true;
        }
    }

    public void pause() {
        this.mMediaPlayer.pause();
        this.mIsPaused = true;
        this.mIsPlaying = false;
    }

    public void stop() {
        if (this.mHasInitialized) {
            this.mMediaPlayer.seekTo(0);
            this.mMediaPlayer.stop();
            this.mIsPaused = false;
            this.mIsPlaying = false;
        }
    }

    public void resume() {
        if (this.mIsPaused) {
            this.mMediaPlayer.start();
            this.mIsPaused = false;
            this.mIsPlaying = true;
        }
    }

    public void reset() {
        this.mMediaPlayer.reset();
        this.mHasInitialized = false;
        this.mIsPaused = false;
        this.mIsPlaying = false;
    }

    public void release() {
        this.mMediaPlayer.release();
        this.mMediaPlayer = null;
        this.mHasInitialized = false;
        this.mIsPaused = false;
        this.mIsPlaying = false;
    }

    public boolean hasInitialized() {
        return this.mHasInitialized;
    }

    public boolean isPaused() {
        return this.mIsPaused;
    }

    public boolean isPlaying() {
        return this.mIsPlaying;
    }

    public void setVolume(float leftVolume, float rightVolume) {
        this.mMediaPlayer.setVolume(leftVolume, rightVolume);
    }
}

