// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { isWindows } from "./_os.ts";
import { normalizeGlob as posixNormalizeGlob } from "./posix/normalize_glob.ts";
import { normalizeGlob as windowsNormalizeGlob } from "./windows/normalize_glob.ts";
/** Like normalize(), but doesn't collapse "**\/.." when `globstar` is true. */ export function normalizeGlob(glob, options = {}) {
  return isWindows ? windowsNormalizeGlob(glob, options) : posixNormalizeGlob(glob, options);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vanNyLmlvL0BzdGQvcGF0aC8wLjIyNC4wL25vcm1hbGl6ZV9nbG9iLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDE4LTIwMjQgdGhlIERlbm8gYXV0aG9ycy4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG4vLyBUaGlzIG1vZHVsZSBpcyBicm93c2VyIGNvbXBhdGlibGUuXG5cbmltcG9ydCB0eXBlIHsgR2xvYk9wdGlvbnMgfSBmcm9tIFwiLi9fY29tbW9uL2dsb2JfdG9fcmVnX2V4cC50c1wiO1xuaW1wb3J0IHsgaXNXaW5kb3dzIH0gZnJvbSBcIi4vX29zLnRzXCI7XG5pbXBvcnQgeyBub3JtYWxpemVHbG9iIGFzIHBvc2l4Tm9ybWFsaXplR2xvYiB9IGZyb20gXCIuL3Bvc2l4L25vcm1hbGl6ZV9nbG9iLnRzXCI7XG5pbXBvcnQge1xuICBub3JtYWxpemVHbG9iIGFzIHdpbmRvd3NOb3JtYWxpemVHbG9iLFxufSBmcm9tIFwiLi93aW5kb3dzL25vcm1hbGl6ZV9nbG9iLnRzXCI7XG5cbmV4cG9ydCB0eXBlIHsgR2xvYk9wdGlvbnMgfTtcblxuLyoqIExpa2Ugbm9ybWFsaXplKCksIGJ1dCBkb2Vzbid0IGNvbGxhcHNlIFwiKipcXC8uLlwiIHdoZW4gYGdsb2JzdGFyYCBpcyB0cnVlLiAqL1xuZXhwb3J0IGZ1bmN0aW9uIG5vcm1hbGl6ZUdsb2IoXG4gIGdsb2I6IHN0cmluZyxcbiAgb3B0aW9uczogR2xvYk9wdGlvbnMgPSB7fSxcbik6IHN0cmluZyB7XG4gIHJldHVybiBpc1dpbmRvd3NcbiAgICA/IHdpbmRvd3NOb3JtYWxpemVHbG9iKGdsb2IsIG9wdGlvbnMpXG4gICAgOiBwb3NpeE5vcm1hbGl6ZUdsb2IoZ2xvYiwgb3B0aW9ucyk7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLHFDQUFxQztBQUdyQyxTQUFTLFNBQVMsUUFBUSxXQUFXO0FBQ3JDLFNBQVMsaUJBQWlCLGtCQUFrQixRQUFRLDRCQUE0QjtBQUNoRixTQUNFLGlCQUFpQixvQkFBb0IsUUFDaEMsOEJBQThCO0FBSXJDLDZFQUE2RSxHQUM3RSxPQUFPLFNBQVMsY0FDZCxJQUFZLEVBQ1osVUFBdUIsQ0FBQyxDQUFDO0VBRXpCLE9BQU8sWUFDSCxxQkFBcUIsTUFBTSxXQUMzQixtQkFBbUIsTUFBTTtBQUMvQiJ9