"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name3 in all)
    __defProp(target, name3, { get: all[name3], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp(target, key, result);
  return result;
};
var __decorateParam = (index, decorator) => (target, key) => decorator(target, key, index);

// node_modules/@vscode/l10n/dist/main.js
var require_main = __commonJS({
  "node_modules/@vscode/l10n/dist/main.js"(exports2, module2) {
    "use strict";
    var __defProp3 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames3 = Object.getOwnPropertyNames;
    var __hasOwnProp3 = Object.prototype.hasOwnProperty;
    var __export3 = (target, all) => {
      for (var name3 in all)
        __defProp3(target, name3, { get: all[name3], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames3(from))
          if (!__hasOwnProp3.call(to, key) && key !== except)
            __defProp3(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp3({}, "__esModule", { value: true }), mod);
    var main_exports2 = {};
    __export3(main_exports2, {
      config: () => config3,
      t: () => t92
    });
    module2.exports = __toCommonJS2(main_exports2);
    var import_fs13 = require("fs");
    var import_promises8 = require("fs/promises");
    async function readFileFromUri(uri) {
      if (uri.protocol === "file:") {
        return await (0, import_promises8.readFile)(uri, "utf8");
      }
      if (uri.protocol === "http:" || uri.protocol === "https:") {
        const res = await fetch(uri.toString(), {
          headers: {
            "Accept-Encoding": "gzip, deflate",
            "Accept": "application/json"
          },
          redirect: "follow"
        });
        if (!res.ok) {
          let error2 = `Unexpected ${res.status} response while trying to read ${uri}`;
          try {
            error2 += `: ${await res.text()}`;
          } catch {
          }
          throw new Error(error2);
        }
        const decoded = await res.text();
        return decoded;
      }
      throw new Error("Unsupported protocol");
    }
    function readFileFromFsPath(fsPath) {
      return (0, import_fs13.readFileSync)(fsPath, "utf8");
    }
    var bundle;
    function config3(config22) {
      if ("contents" in config22) {
        if (typeof config22.contents === "string") {
          bundle = JSON.parse(config22.contents);
        } else {
          bundle = config22.contents;
        }
        return;
      }
      if ("fsPath" in config22) {
        const fileContent = readFileFromFsPath(config22.fsPath);
        const content = JSON.parse(fileContent);
        bundle = isBuiltinExtension(content) ? content.contents.bundle : content;
        return;
      }
      if (config22.uri) {
        let uri = config22.uri;
        if (typeof config22.uri === "string") {
          uri = new URL(config22.uri);
        }
        return new Promise((resolve3, reject) => {
          readFileFromUri(uri).then((uriContent) => {
            try {
              const content = JSON.parse(uriContent);
              bundle = isBuiltinExtension(content) ? content.contents.bundle : content;
              resolve3();
            } catch (err2) {
              reject(err2);
            }
          }).catch((err2) => {
            reject(err2);
          });
        });
      }
    }
    function t92(...args2) {
      const firstArg = args2[0];
      let key;
      let message;
      let formatArgs;
      if (typeof firstArg === "string") {
        key = firstArg;
        message = firstArg;
        args2.splice(0, 1);
        formatArgs = !args2 || typeof args2[0] !== "object" ? args2 : args2[0];
      } else if (firstArg instanceof Array) {
        const replacements = args2.slice(1);
        if (firstArg.length !== replacements.length + 1) {
          throw new Error("expected a string as the first argument to l10n.t");
        }
        let str = firstArg[0];
        for (let i2 = 1; i2 < firstArg.length; i2++) {
          str += `{${i2 - 1}}` + firstArg[i2];
        }
        return t92(str, ...replacements);
      } else {
        message = firstArg.message;
        key = message;
        if (firstArg.comment && firstArg.comment.length > 0) {
          key += `/${Array.isArray(firstArg.comment) ? firstArg.comment.join("") : firstArg.comment}`;
        }
        formatArgs = firstArg.args ?? {};
      }
      const messageFromBundle = bundle?.[key];
      if (!messageFromBundle) {
        return format4(message, formatArgs);
      }
      if (typeof messageFromBundle === "string") {
        return format4(messageFromBundle, formatArgs);
      }
      if (messageFromBundle.comment) {
        return format4(messageFromBundle.message, formatArgs);
      }
      return format4(message, formatArgs);
    }
    var _format2Regexp = /{([^}]+)}/g;
    function format4(template, values) {
      if (Object.keys(values).length === 0) {
        return template;
      }
      return template.replace(_format2Regexp, (match4, group) => values[group] ?? match4);
    }
    function isBuiltinExtension(json) {
      return !!(typeof json?.contents?.bundle === "object" && typeof json?.version === "string");
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/util/assert.js
var require_assert = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/util/assert.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.assertNever = assertNever2;
    function assertNever2(value, msg = `unexpected value ${value}`) {
      throw new Error(`Unreachable: ${msg}`);
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/output/rawTypes.js
var require_rawTypes = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/output/rawTypes.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ChatCompletionContentPartOpaque = exports2.ChatCompletionContentPartKind = exports2.ChatRole = void 0;
    var assert_1 = require_assert();
    var ChatRole;
    (function(ChatRole2) {
      ChatRole2[ChatRole2["System"] = 0] = "System";
      ChatRole2[ChatRole2["User"] = 1] = "User";
      ChatRole2[ChatRole2["Assistant"] = 2] = "Assistant";
      ChatRole2[ChatRole2["Tool"] = 3] = "Tool";
    })(ChatRole || (exports2.ChatRole = ChatRole = {}));
    (function(ChatRole2) {
      function display(role) {
        switch (role) {
          case ChatRole2.System:
            return "system";
          case ChatRole2.User:
            return "user";
          case ChatRole2.Assistant:
            return "assistant";
          case ChatRole2.Tool:
            return "tool";
          default:
            (0, assert_1.assertNever)(role, `unknown chat role ${role}}`);
        }
      }
      ChatRole2.display = display;
    })(ChatRole || (exports2.ChatRole = ChatRole = {}));
    var ChatCompletionContentPartKind3;
    (function(ChatCompletionContentPartKind4) {
      ChatCompletionContentPartKind4[ChatCompletionContentPartKind4["Image"] = 0] = "Image";
      ChatCompletionContentPartKind4[ChatCompletionContentPartKind4["Text"] = 1] = "Text";
      ChatCompletionContentPartKind4[ChatCompletionContentPartKind4["Opaque"] = 2] = "Opaque";
      ChatCompletionContentPartKind4[ChatCompletionContentPartKind4["CacheBreakpoint"] = 3] = "CacheBreakpoint";
    })(ChatCompletionContentPartKind3 || (exports2.ChatCompletionContentPartKind = ChatCompletionContentPartKind3 = {}));
    var ChatCompletionContentPartOpaque;
    (function(ChatCompletionContentPartOpaque2) {
      function usableIn(part, mode) {
        return !part.scope || (part.scope & mode) !== 0;
      }
      ChatCompletionContentPartOpaque2.usableIn = usableIn;
    })(ChatCompletionContentPartOpaque || (exports2.ChatCompletionContentPartOpaque = ChatCompletionContentPartOpaque = {}));
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/output/openaiTypes.js
var require_openaiTypes = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/output/openaiTypes.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.BaseTokensPerName = exports2.BaseTokensPerMessage = exports2.BaseTokensPerCompletion = exports2.ChatRole = void 0;
    var ChatRole;
    (function(ChatRole2) {
      ChatRole2["System"] = "system";
      ChatRole2["User"] = "user";
      ChatRole2["Assistant"] = "assistant";
      ChatRole2["Function"] = "function";
      ChatRole2["Tool"] = "tool";
    })(ChatRole || (exports2.ChatRole = ChatRole = {}));
    exports2.BaseTokensPerCompletion = 3;
    exports2.BaseTokensPerMessage = 3;
    exports2.BaseTokensPerName = 1;
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/output/openaiConvert.js
var require_openaiConvert = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/output/openaiConvert.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.toOpenAiChatMessage = toOpenAiChatMessage;
    exports2.toOpenAIChatMessages = toOpenAIChatMessages;
    var Raw38 = require_rawTypes();
    var OpenAI4 = require_openaiTypes();
    var mode_1 = require_mode();
    function onlyStringContent(content) {
      return content.filter((part) => part.type === Raw38.ChatCompletionContentPartKind.Text).map((part) => part.text).join("");
    }
    function stringAndImageContent(content) {
      const parts2 = content.map((part) => {
        if (part.type === Raw38.ChatCompletionContentPartKind.Text) {
          return {
            type: "text",
            text: part.text
          };
        } else if (part.type === Raw38.ChatCompletionContentPartKind.Image) {
          return {
            image_url: part.imageUrl,
            type: "image_url"
          };
        } else if (part.type === Raw38.ChatCompletionContentPartKind.Opaque && Raw38.ChatCompletionContentPartOpaque.usableIn(part, mode_1.OutputMode.OpenAI)) {
          return part.value;
        }
      }).filter((r) => !!r);
      if (parts2.every((part) => part.type === "text")) {
        return parts2.map((p2) => p2.text).join("");
      }
      return parts2;
    }
    function toOpenAiChatMessage(message) {
      switch (message.role) {
        case Raw38.ChatRole.System:
          return {
            role: OpenAI4.ChatRole.System,
            content: onlyStringContent(message.content),
            name: message.name
          };
        case Raw38.ChatRole.User:
          return {
            role: OpenAI4.ChatRole.User,
            content: stringAndImageContent(message.content),
            name: message.name
          };
        case Raw38.ChatRole.Assistant:
          return {
            role: OpenAI4.ChatRole.Assistant,
            content: onlyStringContent(message.content),
            name: message.name,
            tool_calls: message.toolCalls?.map((toolCall) => ({
              id: toolCall.id,
              function: toolCall.function,
              type: "function"
            }))
          };
        case Raw38.ChatRole.Tool:
          return {
            role: OpenAI4.ChatRole.Tool,
            content: stringAndImageContent(message.content),
            tool_call_id: message.toolCallId
          };
        default:
          return void 0;
      }
    }
    function toOpenAIChatMessages(messages) {
      return messages.map(toOpenAiChatMessage).filter((r) => !!r);
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/output/vscode.js
var require_vscode = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/output/vscode.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.toVsCodeChatMessage = toVsCodeChatMessage;
    exports2.toVsCodeChatMessages = toVsCodeChatMessages;
    var Raw38 = require_rawTypes();
    function onlyStringContent(content) {
      return content.filter((part) => part.type === Raw38.ChatCompletionContentPartKind.Text).map((part) => part.text).join("");
    }
    var vscode93;
    function toVsCodeChatMessage(m2) {
      vscode93 ??= require("vscode");
      switch (m2.role) {
        case Raw38.ChatRole.Assistant:
          const message = vscode93.LanguageModelChatMessage.Assistant(onlyStringContent(m2.content), m2.name);
          if (m2.toolCalls) {
            message.content = [
              new vscode93.LanguageModelTextPart(onlyStringContent(m2.content)),
              ...m2.toolCalls.map((tc) => {
                let parsedArgs;
                try {
                  parsedArgs = JSON.parse(tc.function.arguments);
                } catch (err2) {
                  throw new Error("Invalid JSON in tool call arguments for tool call: " + tc.id);
                }
                return new vscode93.LanguageModelToolCallPart(tc.id, tc.function.name, parsedArgs);
              })
            ];
          }
          return message;
        case Raw38.ChatRole.User:
          return vscode93.LanguageModelChatMessage.User(onlyStringContent(m2.content), m2.name);
        case Raw38.ChatRole.Tool: {
          const message2 = vscode93.LanguageModelChatMessage.User("");
          message2.content = [
            new vscode93.LanguageModelToolResultPart(m2.toolCallId, [
              new vscode93.LanguageModelTextPart(onlyStringContent(m2.content))
            ])
          ];
          return message2;
        }
        default:
          return void 0;
      }
    }
    function toVsCodeChatMessages(messages) {
      return messages.map(toVsCodeChatMessage).filter((r) => !!r);
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/output/mode.js
var require_mode = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/output/mode.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.OutputMode = exports2.Raw = exports2.OpenAI = void 0;
    exports2.toMode = toMode3;
    exports2.toVSCode = toVSCode;
    exports2.toOpenAI = toOpenAI;
    var openaiConvert_1 = require_openaiConvert();
    var vscode_1 = require_vscode();
    exports2.OpenAI = require_openaiTypes();
    exports2.Raw = require_rawTypes();
    var OutputMode5;
    (function(OutputMode6) {
      OutputMode6[OutputMode6["Raw"] = 1] = "Raw";
      OutputMode6[OutputMode6["OpenAI"] = 2] = "OpenAI";
      OutputMode6[OutputMode6["VSCode"] = 4] = "VSCode";
    })(OutputMode5 || (exports2.OutputMode = OutputMode5 = {}));
    function toMode3(mode, messages) {
      switch (mode) {
        case OutputMode5.Raw:
          return messages;
        case OutputMode5.VSCode:
          return messages instanceof Array ? (0, vscode_1.toVsCodeChatMessages)(messages) : (0, vscode_1.toVsCodeChatMessage)(messages);
        case OutputMode5.OpenAI:
          return messages instanceof Array ? (0, openaiConvert_1.toOpenAIChatMessages)(messages) : (0, openaiConvert_1.toOpenAiChatMessage)(messages);
        default:
          throw new Error(`Unknown output mode: ${mode}`);
      }
    }
    function toVSCode(messages) {
      return toMode3(OutputMode5.VSCode, messages);
    }
    function toOpenAI(messages) {
      return toMode3(OutputMode5.OpenAI, messages);
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/jsonTypes.js
var require_jsonTypes = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/jsonTypes.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.jsonRetainedProps = void 0;
    exports2.forEachNode = forEachNode;
    exports2.jsonRetainedProps = Object.keys({
      flexBasis: 1,
      flexGrow: 1,
      flexReserve: 1,
      passPriority: 1,
      priority: 1
    });
    function forEachNode(node, fn) {
      fn(node);
      if (node.type === 1) {
        for (const child of node.children) {
          forEachNode(child, fn);
        }
      }
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/once.js
var require_once = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/once.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.once = once;
    function once(fn) {
      let result;
      let called = false;
      const wrappedFunction = (...args2) => {
        if (!called) {
          result = fn(...args2);
          called = true;
        }
        return result;
      };
      wrappedFunction.clear = () => {
        called = false;
      };
      return wrappedFunction;
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/materialized.js
var require_materialized = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/materialized.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.BudgetExceededError = exports2.MaterializedChatMessageImage = exports2.MaterializedChatMessageBreakpoint = exports2.MaterializedChatMessageOpaque = exports2.MaterializedChatMessage = exports2.MaterializedChatMessageTextChunk = exports2.GenericMaterializedContainer = void 0;
    var once_1 = require_once();
    var mode_1 = require_mode();
    var GenericMaterializedContainer = class _GenericMaterializedContainer {
      parent;
      id;
      name;
      priority;
      metadata;
      flags;
      children;
      keepWithId;
      constructor(parent, id2, name3, priority, childrenRef, metadata3, flags2) {
        this.parent = parent;
        this.id = id2;
        this.name = name3;
        this.priority = priority;
        this.metadata = metadata3;
        this.flags = flags2;
        this.children = childrenRef(this);
        if (flags2 & 8) {
          if (this.children.length !== 2) {
            throw new Error("Invalid number of children for EmptyAlternate flag");
          }
          const [ifEmpty, defaultChild] = this.children;
          if (defaultChild.isEmpty) {
            this.children = [ifEmpty];
          } else {
            this.children = [defaultChild];
          }
        }
      }
      has(flag) {
        return !!(this.flags & flag);
      }
      /** @inheritdoc */
      async tokenCount(tokenizer) {
        let total = 0;
        await Promise.all(this.children.map(async (child) => {
          const amt = isContainerType(child) ? await child.tokenCount(tokenizer) : await child.upperBoundTokenCount(tokenizer);
          total += amt;
        }));
        return total;
      }
      /** @inheritdoc */
      async upperBoundTokenCount(tokenizer) {
        let total = 0;
        await Promise.all(this.children.map(async (child) => {
          const amt = await child.upperBoundTokenCount(tokenizer);
          total += amt;
        }));
        return total;
      }
      /**
       * Replaces a node in the tree with the given one, by its ID.
       */
      replaceNode(nodeId, withNode) {
        return replaceNode(nodeId, this.children, withNode);
      }
      /**
       * Gets all metadata the container holds.
       */
      allMetadata() {
        return allMetadata(this);
      }
      /**
       * Finds a node in the tree by ID.
       */
      findById(nodeId) {
        return findNodeById(nodeId, this);
      }
      /**
       * Gets whether the container is empty.
       */
      get isEmpty() {
        return !this.children.some((c) => !c.isEmpty);
      }
      /**
       * Called when children change, so caches can be invalidated.
       */
      onChunksChange() {
        this.parent?.onChunksChange();
      }
      /**
       * Gets the chat messages the container holds.
       */
      *toChatMessages() {
        for (const child of this.children) {
          assertContainerOrChatMessage(child);
          if (child instanceof _GenericMaterializedContainer) {
            yield* child.toChatMessages();
          } else if (!child.isEmpty && child instanceof MaterializedChatMessage) {
            yield child.toChatMessage();
          }
        }
      }
      async baseMessageTokenCount(tokenizer) {
        let sum2 = 0;
        await Promise.all(this.children.map(async (child) => {
          if (child instanceof MaterializedChatMessage || child instanceof _GenericMaterializedContainer) {
            const amount = await child.baseMessageTokenCount(tokenizer);
            sum2 += amount;
          }
        }));
        return sum2;
      }
      /**
       * Removes the node in the tree with the lowest priority. Returns the
       * list of nodes that were removed.
       */
      removeLowestPriorityChild() {
        const removed = [];
        removeLowestPriorityChild(this, removed);
        return removed;
      }
    };
    exports2.GenericMaterializedContainer = GenericMaterializedContainer;
    var MaterializedChatMessageTextChunk = class {
      parent;
      text;
      priority;
      metadata;
      lineBreakBefore;
      constructor(parent, text3, priority, metadata3 = [], lineBreakBefore) {
        this.parent = parent;
        this.text = text3;
        this.priority = priority;
        this.metadata = metadata3;
        this.lineBreakBefore = lineBreakBefore;
      }
      upperBoundTokenCount(tokenizer) {
        return this._upperBound(tokenizer);
      }
      _upperBound = (0, once_1.once)(async (tokenizer) => {
        const textTokens = await tokenizer.tokenLength({
          type: mode_1.Raw.ChatCompletionContentPartKind.Text,
          text: this.text
        });
        return textTokens + (this.lineBreakBefore !== 0 ? 1 : 0);
      });
      get isEmpty() {
        return !/\S/.test(this.text);
      }
    };
    exports2.MaterializedChatMessageTextChunk = MaterializedChatMessageTextChunk;
    var MaterializedChatMessage = class {
      parent;
      id;
      role;
      name;
      toolCalls;
      toolCallId;
      priority;
      metadata;
      children;
      constructor(parent, id2, role, name3, toolCalls, toolCallId, priority, metadata3, childrenRef) {
        this.parent = parent;
        this.id = id2;
        this.role = role;
        this.name = name3;
        this.toolCalls = toolCalls;
        this.toolCallId = toolCallId;
        this.priority = priority;
        this.metadata = metadata3;
        this.children = childrenRef(this);
      }
      /** @inheritdoc */
      async tokenCount(tokenizer) {
        return this._tokenCount(tokenizer);
      }
      /** @inheritdoc */
      async upperBoundTokenCount(tokenizer) {
        return this._upperBound(tokenizer);
      }
      /** Gets the text this message contains */
      get text() {
        return this._text();
      }
      /** Gets whether the message is empty */
      get isEmpty() {
        return !this.toolCalls?.length && !this.children.some((element) => !element.isEmpty);
      }
      /**
       * Replaces a node in the tree with the given one, by its ID.
       */
      replaceNode(nodeId, withNode) {
        const replaced = replaceNode(nodeId, this.children, withNode);
        if (replaced) {
          this.onChunksChange();
        }
        return replaced;
      }
      removeLowestPriorityChild() {
        const removed = [];
        removeLowestPriorityChild(this, removed);
        return removed;
      }
      onChunksChange() {
        this._tokenCount.clear();
        this._upperBound.clear();
        this._text.clear();
        this.parent?.onChunksChange();
      }
      /**
       * Finds a node in the tree by ID.
       */
      findById(nodeId) {
        return findNodeById(nodeId, this);
      }
      _tokenCount = (0, once_1.once)(async (tokenizer) => {
        const raw2 = this.toChatMessage();
        return tokenizer.countMessageTokens((0, mode_1.toMode)(tokenizer.mode, raw2));
      });
      _upperBound = (0, once_1.once)(async (tokenizer) => {
        let total = await this.baseMessageTokenCount(tokenizer);
        await Promise.all(this.children.map(async (chunk) => {
          const amt = await chunk.upperBoundTokenCount(tokenizer);
          total += amt;
        }));
        return total;
      });
      baseMessageTokenCount = (0, once_1.once)((tokenizer) => {
        const raw2 = this.toChatMessage();
        raw2.content = raw2.content.map((message) => {
          if (message.type === mode_1.Raw.ChatCompletionContentPartKind.Text) {
            return { ...message, text: "" };
          } else if (message.type === mode_1.Raw.ChatCompletionContentPartKind.Image) {
            return void 0;
          } else {
            return message;
          }
        }).filter((r) => !!r);
        return tokenizer.countMessageTokens((0, mode_1.toMode)(tokenizer.mode, raw2));
      });
      _text = (0, once_1.once)(() => {
        let result = [];
        for (const { content, isTextSibling } of contentChunks(this)) {
          if (content instanceof MaterializedChatMessageImage || content instanceof MaterializedChatMessageOpaque) {
            result.push(content);
            continue;
          }
          if (content instanceof MaterializedChatMessageBreakpoint) {
            if (result.at(-1) instanceof MaterializedChatMessageBreakpoint) {
              result[result.length - 1] = content;
            } else {
              result.push(content);
            }
            continue;
          }
          if (content.lineBreakBefore === 1 || content.lineBreakBefore === 2 && !isTextSibling) {
            let prev = result[result.length - 1];
            if (typeof prev === "string" && prev && !prev.endsWith("\n")) {
              result[result.length - 1] = prev + "\n";
            }
          }
          if (typeof result[result.length - 1] === "string") {
            result[result.length - 1] += content.text;
          } else {
            result.push(content.text);
          }
        }
        return result;
      });
      toChatMessage() {
        const content = this.text.map((element) => {
          if (typeof element === "string") {
            return { type: mode_1.Raw.ChatCompletionContentPartKind.Text, text: element };
          } else if (element instanceof MaterializedChatMessageImage) {
            return {
              type: mode_1.Raw.ChatCompletionContentPartKind.Image,
              // updated type reference
              imageUrl: { url: getEncodedBase64(element.src), detail: element.detail }
            };
          } else if (element instanceof MaterializedChatMessageOpaque) {
            return { type: mode_1.Raw.ChatCompletionContentPartKind.Opaque, value: element.value };
          } else if (element instanceof MaterializedChatMessageBreakpoint) {
            return element.part;
          } else {
            throw new Error("Unexpected element type");
          }
        });
        if (this.role === mode_1.Raw.ChatRole.System) {
          return {
            role: this.role,
            content,
            ...this.name ? { name: this.name } : {}
          };
        } else if (this.role === mode_1.Raw.ChatRole.Assistant) {
          const msg = { role: this.role, content };
          if (this.name) {
            msg.name = this.name;
          }
          if (this.toolCalls?.length) {
            msg.toolCalls = this.toolCalls.map((tc) => ({
              function: tc.function,
              id: tc.id,
              type: tc.type
            }));
          }
          return msg;
        } else if (this.role === mode_1.Raw.ChatRole.User) {
          return {
            role: this.role,
            content,
            ...this.name ? { name: this.name } : {}
          };
        } else if (this.role === mode_1.Raw.ChatRole.Tool) {
          return {
            role: this.role,
            content,
            toolCallId: this.toolCallId
          };
        } else {
          return {
            role: this.role,
            content,
            name: this.name
          };
        }
      }
    };
    exports2.MaterializedChatMessage = MaterializedChatMessage;
    var MaterializedChatMessageOpaque = class {
      parent;
      part;
      priority;
      metadata = [];
      get value() {
        return this.part.value;
      }
      constructor(parent, part, priority = Number.MAX_SAFE_INTEGER) {
        this.parent = parent;
        this.part = part;
        this.priority = priority;
      }
      upperBoundTokenCount(tokenizer) {
        return this.part.tokenUsage && mode_1.Raw.ChatCompletionContentPartOpaque.usableIn(this.part, tokenizer.mode) ? this.part.tokenUsage : 0;
      }
      isEmpty = false;
    };
    exports2.MaterializedChatMessageOpaque = MaterializedChatMessageOpaque;
    var MaterializedChatMessageBreakpoint = class {
      parent;
      part;
      metadata = [];
      priority = Number.MAX_SAFE_INTEGER;
      constructor(parent, part) {
        this.parent = parent;
        this.part = part;
      }
      upperBoundTokenCount(_tokenizer) {
        return 0;
      }
      isEmpty = false;
    };
    exports2.MaterializedChatMessageBreakpoint = MaterializedChatMessageBreakpoint;
    var MaterializedChatMessageImage = class {
      parent;
      id;
      src;
      priority;
      metadata;
      lineBreakBefore;
      detail;
      constructor(parent, id2, src, priority, metadata3 = [], lineBreakBefore, detail) {
        this.parent = parent;
        this.id = id2;
        this.src = src;
        this.priority = priority;
        this.metadata = metadata3;
        this.lineBreakBefore = lineBreakBefore;
        this.detail = detail;
      }
      upperBoundTokenCount(tokenizer) {
        return this._upperBound(tokenizer);
      }
      _upperBound = (0, once_1.once)(async (tokenizer) => {
        return tokenizer.tokenLength({
          type: mode_1.Raw.ChatCompletionContentPartKind.Image,
          imageUrl: { url: getEncodedBase64(this.src), detail: this.detail }
        });
      });
      isEmpty = false;
    };
    exports2.MaterializedChatMessageImage = MaterializedChatMessageImage;
    function isContainerType(node) {
      return node instanceof GenericMaterializedContainer || node instanceof MaterializedChatMessage;
    }
    function isContentType(node) {
      return node instanceof MaterializedChatMessageTextChunk || node instanceof MaterializedChatMessageImage || node instanceof MaterializedChatMessageOpaque || node instanceof MaterializedChatMessageBreakpoint;
    }
    function assertContainerOrChatMessage(v) {
      if (!isContainerType(v)) {
        throw new Error(`Cannot have a text node outside a ChatMessage. Text: "${v.text}"`);
      }
    }
    function* contentChunks(node, isTextSibling = false) {
      for (const child of node.children) {
        if (child instanceof MaterializedChatMessageTextChunk) {
          yield { content: child, isTextSibling };
          isTextSibling = true;
        } else if (child instanceof MaterializedChatMessageImage || child instanceof MaterializedChatMessageOpaque || child instanceof MaterializedChatMessageBreakpoint) {
          yield { content: child, isTextSibling: false };
        } else if (child instanceof MaterializedChatMessageOpaque) {
          yield { content: child, isTextSibling: true };
        } else {
          if (child)
            yield* contentChunks(child, isTextSibling);
          isTextSibling = false;
        }
      }
    }
    function removeLowestPriorityLegacy(root, removed) {
      let lowest;
      function findLowestInTree(node, chain) {
        if (isContentType(node)) {
          if (!lowest || node.priority < lowest.node.priority) {
            lowest = { chain: chain.slice(), node };
          }
        } else {
          chain.push(node);
          for (const child of node.children) {
            findLowestInTree(child, chain);
          }
          chain.pop();
        }
      }
      findLowestInTree(root, []);
      if (!lowest) {
        throw new Error("No lowest priority node found");
      }
      removeNode(lowest.node, removed);
    }
    var _hasCachePointMemo = /* @__PURE__ */ new WeakMap();
    function hasCachePoint(node) {
      let known = _hasCachePointMemo.get(node);
      if (known !== void 0) {
        return known;
      }
      let result = false;
      if (node instanceof MaterializedChatMessageBreakpoint) {
        result = true;
      } else if (node instanceof MaterializedChatMessage) {
        result = node.children.some((c) => c instanceof MaterializedChatMessageBreakpoint);
      } else if (node instanceof GenericMaterializedContainer) {
        result = node.children.some(hasCachePoint);
      }
      _hasCachePointMemo.set(node, result);
      return result;
    }
    function shouldLookForCachePointInNode(node) {
      if (node instanceof MaterializedChatMessage) {
        return true;
      }
      for (let p2 = node.parent; p2; p2 = p2.parent) {
        if (p2 instanceof MaterializedChatMessage) {
          return false;
        }
      }
      return true;
    }
    function removeLowestPriorityChild(node, removed) {
      let lowest;
      if (node instanceof GenericMaterializedContainer && node.has(
        1
        /* ContainerFlags.IsLegacyPrioritization */
      )) {
        removeLowestPriorityLegacy(node, removed);
        return;
      }
      const shouldLookForCachePoint = shouldLookForCachePointInNode(node);
      const queue = node.children.map((_, i2) => ({ chain: [node], index: i2 }));
      for (let i2 = 0; i2 < queue.length; i2++) {
        const { chain, index } = queue[i2];
        const child = chain[chain.length - 1].children[index];
        if (shouldLookForCachePoint && hasCachePoint(child)) {
          lowest = void 0;
          if (child instanceof MaterializedChatMessageBreakpoint) {
            continue;
          }
        }
        if (child instanceof GenericMaterializedContainer && child.has(
          4
          /* ContainerFlags.PassPriority */
        ) && child.children.length) {
          const newChain = [...chain, child];
          queue.splice(i2 + 1, 0, ...child.children.map((_, i3) => ({ chain: newChain, index: i3 })));
        } else if (!lowest || child.priority < lowest.value.priority) {
          lowest = { chain, index, value: child };
        } else if (child.priority === lowest.value.priority) {
          lowest.lowestNested ??= getLowestPriorityAmongChildren(lowest.value);
          const lowestNestedPriority = getLowestPriorityAmongChildren(child);
          if (lowestNestedPriority < lowest.lowestNested) {
            lowest = { chain, index, value: child, lowestNested: lowestNestedPriority };
          }
        }
      }
      if (!lowest) {
        throw new BudgetExceededError3(node);
      }
      if (isContentType(lowest.value) || lowest.value instanceof GenericMaterializedContainer && lowest.value.has(
        2
        /* ContainerFlags.IsChunk */
      ) || isContainerType(lowest.value) && !lowest.value.children.length) {
        removeNode(lowest.value, removed);
      } else {
        removeLowestPriorityChild(lowest.value, removed);
      }
    }
    var BudgetExceededError3 = class extends Error {
      metadata;
      messages;
      constructor(node) {
        let path15 = [node];
        while (path15[0].parent) {
          path15.unshift(path15[0].parent);
        }
        const parts2 = path15.map((n) => n instanceof MaterializedChatMessage ? n.role : n.name || "(anonymous)");
        super(`No lowest priority node found (path: ${parts2.join(" -> ")})`);
      }
    };
    exports2.BudgetExceededError = BudgetExceededError3;
    function getLowestPriorityAmongChildren(node) {
      if (!isContainerType(node)) {
        return -1;
      }
      let lowest = Number.MAX_SAFE_INTEGER;
      for (const child of node.children) {
        lowest = Math.min(lowest, child.priority);
      }
      return lowest;
    }
    function* allMetadata(node) {
      yield* node.metadata;
      for (const child of node.children) {
        if (isContainerType(child)) {
          yield* allMetadata(child);
        } else {
          yield* child.metadata;
        }
      }
    }
    function replaceNode(nodeId, children, withNode) {
      for (let i2 = 0; i2 < children.length; i2++) {
        const child = children[i2];
        if (isContainerType(child)) {
          if (child.id === nodeId) {
            const oldNode = children[i2];
            withNode.parent = child.parent;
            children[i2] = withNode;
            return oldNode;
          }
          const inner = child.replaceNode(nodeId, withNode);
          if (inner) {
            return inner;
          }
        }
      }
    }
    function* forEachNode(node) {
      const queue = [node];
      while (queue.length > 0) {
        const current = queue.pop();
        yield current;
        if (isContainerType(current)) {
          queue.push(...current.children);
        }
      }
    }
    function getRoot2(node) {
      let current = node;
      while (current.parent) {
        current = current.parent;
      }
      return current;
    }
    function isKeepWith(node) {
      return node instanceof GenericMaterializedContainer && node.keepWithId !== void 0;
    }
    var currentlyBeingRemovedKeepWiths = /* @__PURE__ */ new Set();
    function removeOtherKeepWiths(nodeThatWasRemoved, removed) {
      const removeKeepWithIds = /* @__PURE__ */ new Set();
      for (const node of forEachNode(nodeThatWasRemoved)) {
        if (isKeepWith(node) && !currentlyBeingRemovedKeepWiths.has(node.keepWithId)) {
          removeKeepWithIds.add(node.keepWithId);
        }
      }
      if (removeKeepWithIds.size === 0) {
        return false;
      }
      for (const id2 of removeKeepWithIds) {
        currentlyBeingRemovedKeepWiths.add(id2);
      }
      try {
        const root = getRoot2(nodeThatWasRemoved);
        for (const node of forEachNode(root)) {
          if (isKeepWith(node) && removeKeepWithIds.has(node.keepWithId)) {
            removeNode(node, removed);
          } else if (node instanceof MaterializedChatMessage && node.toolCalls) {
            node.toolCalls = filterIfDifferent(node.toolCalls, (c) => !(c.keepWith && removeKeepWithIds.has(c.keepWith.id)));
            if (node.isEmpty) {
              removeNode(node, removed);
            }
          }
        }
      } finally {
        for (const id2 of removeKeepWithIds) {
          currentlyBeingRemovedKeepWiths.delete(id2);
        }
      }
    }
    function findNodeById(nodeId, container) {
      if (container.id === nodeId) {
        return container;
      }
      for (const child of container.children) {
        if (isContainerType(child)) {
          const inner = findNodeById(nodeId, child);
          if (inner) {
            return inner;
          }
        }
      }
    }
    function removeNode(node, removed) {
      const parent = node.parent;
      if (!parent) {
        return;
      }
      const index = parent.children.indexOf(node);
      if (index === -1) {
        return;
      }
      parent.children.splice(index, 1);
      removed.push(node);
      removeOtherKeepWiths(node, removed);
      if (parent.isEmpty) {
        removeNode(parent, removed);
      } else {
        parent.onChunksChange();
      }
    }
    function getEncodedBase64(base64String) {
      const mimeTypes = {
        "/9j/": "image/jpeg",
        iVBOR: "image/png",
        R0lGOD: "image/gif",
        UklGR: "image/webp"
      };
      for (const prefix of Object.keys(mimeTypes)) {
        if (base64String.startsWith(prefix)) {
          return `data:${mimeTypes[prefix]};base64,${base64String}`;
        }
      }
      return base64String;
    }
    function filterIfDifferent(arr, predicate) {
      for (let i2 = 0; i2 < arr.length; i2++) {
        if (predicate(arr[i2])) {
          continue;
        }
        const newArr = arr.slice(0, i2);
        for (let k = i2 + 1; k < arr.length; k++) {
          if (predicate(arr[k])) {
            newArr.push(arr[k]);
          }
        }
        return newArr;
      }
      return arr;
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/tsx.js
var require_tsx = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/tsx.js"() {
    "use strict";
    function _vscpp(ctor, props, ...children) {
      return { ctor, props, children: children.flat() };
    }
    function _vscppf() {
      throw new Error(`This should not be invoked!`);
    }
    _vscppf.isFragment = true;
    globalThis.vscpp = _vscpp;
    globalThis.vscppf = _vscppf;
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/promptElement.js
var require_promptElement = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/promptElement.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PromptElement = void 0;
    require_tsx();
    var PromptElement130 = class {
      props;
      get priority() {
        return this.props.priority ?? Number.MAX_SAFE_INTEGER;
      }
      get insertLineBreakBefore() {
        return true;
      }
      constructor(props) {
        this.props = props;
      }
    };
    exports2.PromptElement = PromptElement130;
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/promptElements.js
var require_promptElements = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/promptElements.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LogicalWrapper = exports2.IfEmpty = exports2.AbstractKeepWith = exports2.TokenLimit = exports2.Expandable = exports2.Chunk = exports2.LegacyPrioritization = exports2.ToolResult = exports2.PrioritizedList = exports2.Image = exports2.TextChunk = exports2.ToolMessage = exports2.AssistantMessage = exports2.UserMessage = exports2.SystemMessage = exports2.BaseChatMessage = void 0;
    exports2.isChatMessagePromptElement = isChatMessagePromptElement;
    exports2.useKeepWith = useKeepWith4;
    var _1 = require_base();
    var promptElement_1 = require_promptElement();
    function isChatMessagePromptElement(element) {
      return element instanceof SystemMessage52 || element instanceof UserMessage70 || element instanceof AssistantMessage11;
    }
    var BaseChatMessage = class extends promptElement_1.PromptElement {
      render() {
        return vscpp(vscppf, null, this.props.children);
      }
    };
    exports2.BaseChatMessage = BaseChatMessage;
    var SystemMessage52 = class extends BaseChatMessage {
      constructor(props) {
        props.role = _1.Raw.ChatRole.System;
        super(props);
      }
    };
    exports2.SystemMessage = SystemMessage52;
    var UserMessage70 = class extends BaseChatMessage {
      constructor(props) {
        props.role = _1.Raw.ChatRole.User;
        super(props);
      }
    };
    exports2.UserMessage = UserMessage70;
    var AssistantMessage11 = class extends BaseChatMessage {
      constructor(props) {
        props.role = _1.Raw.ChatRole.Assistant;
        super(props);
      }
    };
    exports2.AssistantMessage = AssistantMessage11;
    var WHITESPACE_RE = /\s+/g;
    var ToolMessage3 = class extends BaseChatMessage {
      constructor(props) {
        props.role = _1.Raw.ChatRole.Tool;
        super(props);
      }
    };
    exports2.ToolMessage = ToolMessage3;
    var TextChunk30 = class extends promptElement_1.PromptElement {
      async prepare(sizing, _progress, token) {
        const breakOn = this.props.breakOnWhitespace ? WHITESPACE_RE : this.props.breakOn;
        if (!breakOn) {
          return vscpp(vscppf, null, this.props.children);
        }
        let fullText = "";
        const intrinsics = [];
        for (const child of this.props.children || []) {
          if (child && typeof child === "object") {
            if (typeof child.ctor !== "string") {
              throw new Error("TextChunk children must be text literals or intrinsic attributes.");
            } else if (child.ctor === "br") {
              fullText += "\n";
            } else {
              intrinsics.push(child);
            }
          } else if (child != null) {
            fullText += child;
          }
        }
        const text3 = await getTextContentBelowBudget(sizing, breakOn, fullText, token);
        return vscpp(
          vscppf,
          null,
          intrinsics,
          text3
        );
      }
      render(piece) {
        return piece;
      }
    };
    exports2.TextChunk = TextChunk30;
    async function getTextContentBelowBudget(sizing, breakOn, fullText, cancellation) {
      if (breakOn instanceof RegExp) {
        if (!breakOn.global) {
          throw new Error(`\`breakOn\` expression must have the global flag set (got ${breakOn})`);
        }
        breakOn.lastIndex = 0;
      }
      let outputText = "";
      let lastIndex = -1;
      while (lastIndex < fullText.length) {
        let index;
        if (typeof breakOn === "string") {
          index = fullText.indexOf(breakOn, lastIndex === -1 ? 0 : lastIndex + breakOn.length);
        } else {
          index = breakOn.exec(fullText)?.index ?? -1;
        }
        if (index === -1) {
          index = fullText.length;
        }
        const next = outputText + fullText.slice(Math.max(0, lastIndex), index);
        if (await sizing.countTokens({ type: _1.Raw.ChatCompletionContentPartKind.Text, text: next }, cancellation) > sizing.tokenBudget) {
          return outputText;
        }
        outputText = next;
        lastIndex = index;
      }
      return outputText;
    }
    var Image5 = class extends promptElement_1.PromptElement {
      constructor(props) {
        super(props);
      }
      render() {
        return vscpp(vscppf, null, this.props.children);
      }
    };
    exports2.Image = Image5;
    var PrioritizedList9 = class extends promptElement_1.PromptElement {
      render() {
        const { children, priority = 0, descending } = this.props;
        if (!children) {
          return;
        }
        return vscpp(vscppf, null, children.map((child, i2) => {
          if (!child) {
            return;
          }
          const thisPriority = descending ? (
            // First element in array of children has highest priority
            priority - i2
          ) : (
            // Last element in array of children has highest priority
            priority - children.length + i2
          );
          if (typeof child !== "object") {
            return vscpp(TextChunk30, { priority: thisPriority }, child);
          }
          child.props ??= {};
          child.props.priority = thisPriority;
          return child;
        }));
      }
    };
    exports2.PrioritizedList = PrioritizedList9;
    var ToolResult2 = class extends promptElement_1.PromptElement {
      render() {
        return vscpp(vscppf, null, this.props.data.content.map((part) => {
          if (part && typeof part.value === "string") {
            return part.value;
          } else if (part && part.value && typeof part.value.node === "object") {
            return vscpp("elementJSON", { data: part.value });
          }
        }));
      }
    };
    exports2.ToolResult = ToolResult2;
    var LegacyPrioritization = class extends promptElement_1.PromptElement {
      render() {
        return vscpp(vscppf, null, this.props.children);
      }
    };
    exports2.LegacyPrioritization = LegacyPrioritization;
    var Chunk9 = class extends promptElement_1.PromptElement {
      render() {
        return vscpp(vscppf, null, this.props.children);
      }
    };
    exports2.Chunk = Chunk9;
    var Expandable = class extends promptElement_1.PromptElement {
      async render(_state, sizing) {
        return vscpp(vscppf, null, await this.props.value(sizing));
      }
    };
    exports2.Expandable = Expandable;
    var TokenLimit7 = class extends promptElement_1.PromptElement {
      render() {
        return vscpp(vscppf, null, this.props.children);
      }
    };
    exports2.TokenLimit = TokenLimit7;
    var AbstractKeepWith = class extends promptElement_1.PromptElement {
    };
    exports2.AbstractKeepWith = AbstractKeepWith;
    var keepWidthId = 0;
    function useKeepWith4() {
      const id2 = keepWidthId++;
      return class KeepWith extends AbstractKeepWith {
        static id = id2;
        id = id2;
        render() {
          return vscpp(vscppf, null, this.props.children);
        }
      };
    }
    var IfEmpty2 = class extends promptElement_1.PromptElement {
      render() {
        return vscpp(
          vscppf,
          null,
          vscpp(LogicalWrapper, null, this.props.alt),
          vscpp(LogicalWrapper, { flexGrow: 1 }, this.props.children)
        );
      }
    };
    exports2.IfEmpty = IfEmpty2;
    var LogicalWrapper = class extends promptElement_1.PromptElement {
      render() {
        return vscpp(vscppf, null, this.props.children);
      }
    };
    exports2.LogicalWrapper = LogicalWrapper;
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/util/vs/nls.js
var require_nls = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/util/vs/nls.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.localize = localize2;
    exports2.localize2 = localize22;
    exports2.getConfiguredDefaultLocale = getConfiguredDefaultLocale;
    function _format3(message, args2) {
      let result;
      if (args2.length === 0) {
        result = message;
      } else {
        result = message.replace(/\{(\d+)\}/g, function(match4, rest) {
          const index = rest[0];
          return typeof args2[index] !== "undefined" ? args2[index] : match4;
        });
      }
      return result;
    }
    function localize2(data, message, ...args2) {
      return _format3(message, args2);
    }
    function localize22(data, message, ...args2) {
      const res = _format3(message, args2);
      return {
        original: res,
        value: res
      };
    }
    function getConfiguredDefaultLocale(_) {
      return void 0;
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/util/vs/common/platform.js
var require_platform = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/util/vs/common/platform.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isAndroid = exports2.isEdge = exports2.isSafari = exports2.isFirefox = exports2.isChrome = exports2.OS = exports2.setTimeout0 = exports2.setTimeout0IsFaster = exports2.translationsConfigFile = exports2.platformLocale = exports2.locale = exports2.Language = exports2.language = exports2.userAgent = exports2.platform = exports2.isCI = exports2.isMobile = exports2.isIOS = exports2.webWorkerOrigin = exports2.isWebWorker = exports2.isWeb = exports2.isElectron = exports2.isNative = exports2.isLinuxSnap = exports2.isLinux = exports2.isMacintosh = exports2.isWindows = exports2.LANGUAGE_DEFAULT = void 0;
    exports2.PlatformToString = PlatformToString;
    exports2.isLittleEndian = isLittleEndian;
    exports2.isBigSurOrNewer = isBigSurOrNewer;
    var nls = require_nls();
    exports2.LANGUAGE_DEFAULT = "en";
    var _isWindows2 = false;
    var _isMacintosh2 = false;
    var _isLinux2 = false;
    var _isLinuxSnap2 = false;
    var _isNative2 = false;
    var _isWeb2 = false;
    var _isElectron2 = false;
    var _isIOS2 = false;
    var _isCI2 = false;
    var _isMobile2 = false;
    var _locale2 = void 0;
    var _language2 = exports2.LANGUAGE_DEFAULT;
    var _platformLocale2 = exports2.LANGUAGE_DEFAULT;
    var _translationsConfigFile2 = void 0;
    var _userAgent2 = void 0;
    var $globalThis2 = globalThis;
    var nodeProcess2 = void 0;
    if (typeof $globalThis2.vscode !== "undefined" && typeof $globalThis2.vscode.process !== "undefined") {
      nodeProcess2 = $globalThis2.vscode.process;
    } else if (typeof process !== "undefined") {
      nodeProcess2 = process;
    }
    var isElectronProcess2 = typeof nodeProcess2?.versions?.electron === "string";
    var isElectronRenderer2 = isElectronProcess2 && nodeProcess2?.type === "renderer";
    if (typeof nodeProcess2 === "object") {
      _isWindows2 = nodeProcess2.platform === "win32";
      _isMacintosh2 = nodeProcess2.platform === "darwin";
      _isLinux2 = nodeProcess2.platform === "linux";
      _isLinuxSnap2 = _isLinux2 && !!nodeProcess2.env["SNAP"] && !!nodeProcess2.env["SNAP_REVISION"];
      _isElectron2 = isElectronProcess2;
      _isCI2 = !!nodeProcess2.env["CI"] || !!nodeProcess2.env["BUILD_ARTIFACTSTAGINGDIRECTORY"];
      _locale2 = exports2.LANGUAGE_DEFAULT;
      _language2 = exports2.LANGUAGE_DEFAULT;
      const rawNlsConfig = nodeProcess2.env["VSCODE_NLS_CONFIG"];
      if (rawNlsConfig) {
        try {
          const nlsConfig = JSON.parse(rawNlsConfig);
          const resolved = nlsConfig.availableLanguages["*"];
          _locale2 = nlsConfig.locale;
          _platformLocale2 = nlsConfig.osLocale;
          _language2 = resolved ? resolved : exports2.LANGUAGE_DEFAULT;
          _translationsConfigFile2 = nlsConfig._translationsConfigFile;
        } catch (e) {
        }
      }
      _isNative2 = true;
    } else if (typeof navigator === "object" && !isElectronRenderer2) {
      _userAgent2 = navigator.userAgent;
      _isWindows2 = _userAgent2.indexOf("Windows") >= 0;
      _isMacintosh2 = _userAgent2.indexOf("Macintosh") >= 0;
      _isIOS2 = (_userAgent2.indexOf("Macintosh") >= 0 || _userAgent2.indexOf("iPad") >= 0 || _userAgent2.indexOf("iPhone") >= 0) && !!navigator.maxTouchPoints && navigator.maxTouchPoints > 0;
      _isLinux2 = _userAgent2.indexOf("Linux") >= 0;
      _isMobile2 = _userAgent2?.indexOf("Mobi") >= 0;
      _isWeb2 = true;
      const configuredLocale = nls.getConfiguredDefaultLocale(
        // This call _must_ be done in the file that calls `nls.getConfiguredDefaultLocale`
        // to ensure that the NLS AMD Loader plugin has been loaded and configured.
        // This is because the loader plugin decides what the default locale is based on
        // how it's able to resolve the strings.
        nls.localize({ key: "ensureLoaderPluginIsLoaded", comment: ["{Locked}"] }, "_")
      );
      _locale2 = configuredLocale || exports2.LANGUAGE_DEFAULT;
      _language2 = _locale2;
      _platformLocale2 = navigator.language;
    } else {
      console.error("Unable to resolve platform.");
    }
    function PlatformToString(platform10) {
      switch (platform10) {
        case 0:
          return "Web";
        case 1:
          return "Mac";
        case 2:
          return "Linux";
        case 3:
          return "Windows";
      }
    }
    var _platform2 = 0;
    if (_isMacintosh2) {
      _platform2 = 1;
    } else if (_isWindows2) {
      _platform2 = 3;
    } else if (_isLinux2) {
      _platform2 = 2;
    }
    exports2.isWindows = _isWindows2;
    exports2.isMacintosh = _isMacintosh2;
    exports2.isLinux = _isLinux2;
    exports2.isLinuxSnap = _isLinuxSnap2;
    exports2.isNative = _isNative2;
    exports2.isElectron = _isElectron2;
    exports2.isWeb = _isWeb2;
    exports2.isWebWorker = _isWeb2 && typeof $globalThis2.importScripts === "function";
    exports2.webWorkerOrigin = exports2.isWebWorker ? $globalThis2.origin : void 0;
    exports2.isIOS = _isIOS2;
    exports2.isMobile = _isMobile2;
    exports2.isCI = _isCI2;
    exports2.platform = _platform2;
    exports2.userAgent = _userAgent2;
    exports2.language = _language2;
    var Language3;
    (function(Language4) {
      function value() {
        return exports2.language;
      }
      Language4.value = value;
      function isDefaultVariant() {
        if (exports2.language.length === 2) {
          return exports2.language === "en";
        } else if (exports2.language.length >= 3) {
          return exports2.language[0] === "e" && exports2.language[1] === "n" && exports2.language[2] === "-";
        } else {
          return false;
        }
      }
      Language4.isDefaultVariant = isDefaultVariant;
      function isDefault() {
        return exports2.language === "en";
      }
      Language4.isDefault = isDefault;
    })(Language3 || (exports2.Language = Language3 = {}));
    exports2.locale = _locale2;
    exports2.platformLocale = _platformLocale2;
    exports2.translationsConfigFile = _translationsConfigFile2;
    exports2.setTimeout0IsFaster = typeof $globalThis2.postMessage === "function" && !$globalThis2.importScripts;
    exports2.setTimeout0 = (() => {
      if (exports2.setTimeout0IsFaster) {
        const pending = [];
        $globalThis2.addEventListener("message", (e) => {
          if (e.data && e.data.vscodeScheduleAsyncWork) {
            for (let i2 = 0, len = pending.length; i2 < len; i2++) {
              const candidate = pending[i2];
              if (candidate.id === e.data.vscodeScheduleAsyncWork) {
                pending.splice(i2, 1);
                candidate.callback();
                return;
              }
            }
          }
        });
        let lastId = 0;
        return (callback) => {
          const myId = ++lastId;
          pending.push({
            id: myId,
            callback
          });
          $globalThis2.postMessage({ vscodeScheduleAsyncWork: myId }, "*");
        };
      }
      return (callback) => setTimeout(callback);
    })();
    exports2.OS = _isMacintosh2 || _isIOS2 ? 2 : _isWindows2 ? 1 : 3;
    var _isLittleEndian = true;
    var _isLittleEndianComputed = false;
    function isLittleEndian() {
      if (!_isLittleEndianComputed) {
        _isLittleEndianComputed = true;
        const test2 = new Uint8Array(2);
        test2[0] = 1;
        test2[1] = 2;
        const view = new Uint16Array(test2.buffer);
        _isLittleEndian = view[0] === (2 << 8) + 1;
      }
      return _isLittleEndian;
    }
    exports2.isChrome = !!(exports2.userAgent && exports2.userAgent.indexOf("Chrome") >= 0);
    exports2.isFirefox = !!(exports2.userAgent && exports2.userAgent.indexOf("Firefox") >= 0);
    exports2.isSafari = !!(!exports2.isChrome && (exports2.userAgent && exports2.userAgent.indexOf("Safari") >= 0));
    exports2.isEdge = !!(exports2.userAgent && exports2.userAgent.indexOf("Edg/") >= 0);
    exports2.isAndroid = !!(exports2.userAgent && exports2.userAgent.indexOf("Android") >= 0);
    function isBigSurOrNewer(osVersion) {
      return parseFloat(osVersion) >= 20;
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/util/vs/common/process.js
var require_process = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/util/vs/common/process.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.arch = exports2.platform = exports2.env = exports2.cwd = void 0;
    var platform_1 = require_platform();
    var safeProcess2;
    var vscodeGlobal2 = globalThis.vscode;
    if (typeof vscodeGlobal2 !== "undefined" && typeof vscodeGlobal2.process !== "undefined") {
      const sandboxProcess = vscodeGlobal2.process;
      safeProcess2 = {
        get platform() {
          return sandboxProcess.platform;
        },
        get arch() {
          return sandboxProcess.arch;
        },
        get env() {
          return sandboxProcess.env;
        },
        cwd() {
          return sandboxProcess.cwd();
        }
      };
    } else if (typeof process !== "undefined") {
      safeProcess2 = {
        get platform() {
          return process.platform;
        },
        get arch() {
          return process.arch;
        },
        get env() {
          return process.env;
        },
        cwd() {
          return process.env["VSCODE_CWD"] || process.cwd();
        }
      };
    } else {
      safeProcess2 = {
        // Supported
        get platform() {
          return platform_1.isWindows ? "win32" : platform_1.isMacintosh ? "darwin" : "linux";
        },
        get arch() {
          return void 0;
        },
        // Unsupported
        get env() {
          return {};
        },
        cwd() {
          return "/";
        }
      };
    }
    exports2.cwd = safeProcess2.cwd;
    exports2.env = safeProcess2.env;
    exports2.platform = safeProcess2.platform;
    exports2.arch = safeProcess2.arch;
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/util/vs/common/path.js
var require_path = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/util/vs/common/path.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.delimiter = exports2.sep = exports2.toNamespacedPath = exports2.parse = exports2.format = exports2.extname = exports2.basename = exports2.dirname = exports2.relative = exports2.resolve = exports2.join = exports2.isAbsolute = exports2.normalize = exports2.posix = exports2.win32 = void 0;
    var process2 = require_process();
    var CHAR_UPPERCASE_A2 = 65;
    var CHAR_LOWERCASE_A2 = 97;
    var CHAR_UPPERCASE_Z2 = 90;
    var CHAR_LOWERCASE_Z2 = 122;
    var CHAR_DOT2 = 46;
    var CHAR_FORWARD_SLASH2 = 47;
    var CHAR_BACKWARD_SLASH2 = 92;
    var CHAR_COLON2 = 58;
    var CHAR_QUESTION_MARK2 = 63;
    var ErrorInvalidArgType2 = class extends Error {
      code;
      constructor(name3, expected, actual) {
        let determiner;
        if (typeof expected === "string" && expected.indexOf("not ") === 0) {
          determiner = "must not be";
          expected = expected.replace(/^not /, "");
        } else {
          determiner = "must be";
        }
        const type = name3.indexOf(".") !== -1 ? "property" : "argument";
        let msg = `The "${name3}" ${type} ${determiner} of type ${expected}`;
        msg += `. Received type ${typeof actual}`;
        super(msg);
        this.code = "ERR_INVALID_ARG_TYPE";
      }
    };
    function validateObject2(pathObject, name3) {
      if (pathObject === null || typeof pathObject !== "object") {
        throw new ErrorInvalidArgType2(name3, "Object", pathObject);
      }
    }
    function validateString2(value, name3) {
      if (typeof value !== "string") {
        throw new ErrorInvalidArgType2(name3, "string", value);
      }
    }
    var platformIsWin322 = process2.platform === "win32";
    function isPathSeparator3(code3) {
      return code3 === CHAR_FORWARD_SLASH2 || code3 === CHAR_BACKWARD_SLASH2;
    }
    function isPosixPathSeparator2(code3) {
      return code3 === CHAR_FORWARD_SLASH2;
    }
    function isWindowsDeviceRoot2(code3) {
      return code3 >= CHAR_UPPERCASE_A2 && code3 <= CHAR_UPPERCASE_Z2 || code3 >= CHAR_LOWERCASE_A2 && code3 <= CHAR_LOWERCASE_Z2;
    }
    function normalizeString2(path15, allowAboveRoot, separator, isPathSeparator4) {
      let res = "";
      let lastSegmentLength = 0;
      let lastSlash = -1;
      let dots = 0;
      let code3 = 0;
      for (let i2 = 0; i2 <= path15.length; ++i2) {
        if (i2 < path15.length) {
          code3 = path15.charCodeAt(i2);
        } else if (isPathSeparator4(code3)) {
          break;
        } else {
          code3 = CHAR_FORWARD_SLASH2;
        }
        if (isPathSeparator4(code3)) {
          if (lastSlash === i2 - 1 || dots === 1) {
          } else if (dots === 2) {
            if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== CHAR_DOT2 || res.charCodeAt(res.length - 2) !== CHAR_DOT2) {
              if (res.length > 2) {
                const lastSlashIndex = res.lastIndexOf(separator);
                if (lastSlashIndex === -1) {
                  res = "";
                  lastSegmentLength = 0;
                } else {
                  res = res.slice(0, lastSlashIndex);
                  lastSegmentLength = res.length - 1 - res.lastIndexOf(separator);
                }
                lastSlash = i2;
                dots = 0;
                continue;
              } else if (res.length !== 0) {
                res = "";
                lastSegmentLength = 0;
                lastSlash = i2;
                dots = 0;
                continue;
              }
            }
            if (allowAboveRoot) {
              res += res.length > 0 ? `${separator}..` : "..";
              lastSegmentLength = 2;
            }
          } else {
            if (res.length > 0) {
              res += `${separator}${path15.slice(lastSlash + 1, i2)}`;
            } else {
              res = path15.slice(lastSlash + 1, i2);
            }
            lastSegmentLength = i2 - lastSlash - 1;
          }
          lastSlash = i2;
          dots = 0;
        } else if (code3 === CHAR_DOT2 && dots !== -1) {
          ++dots;
        } else {
          dots = -1;
        }
      }
      return res;
    }
    function _format3(sep3, pathObject) {
      validateObject2(pathObject, "pathObject");
      const dir = pathObject.dir || pathObject.root;
      const base2 = pathObject.base || `${pathObject.name || ""}${pathObject.ext || ""}`;
      if (!dir) {
        return base2;
      }
      return dir === pathObject.root ? `${dir}${base2}` : `${dir}${sep3}${base2}`;
    }
    exports2.win32 = {
      // path.resolve([from ...], to)
      resolve(...pathSegments) {
        let resolvedDevice = "";
        let resolvedTail = "";
        let resolvedAbsolute = false;
        for (let i2 = pathSegments.length - 1; i2 >= -1; i2--) {
          let path15;
          if (i2 >= 0) {
            path15 = pathSegments[i2];
            validateString2(path15, "path");
            if (path15.length === 0) {
              continue;
            }
          } else if (resolvedDevice.length === 0) {
            path15 = process2.cwd();
          } else {
            path15 = process2.env[`=${resolvedDevice}`] || process2.cwd();
            if (path15 === void 0 || path15.slice(0, 2).toLowerCase() !== resolvedDevice.toLowerCase() && path15.charCodeAt(2) === CHAR_BACKWARD_SLASH2) {
              path15 = `${resolvedDevice}\\`;
            }
          }
          const len = path15.length;
          let rootEnd = 0;
          let device = "";
          let isAbsolute4 = false;
          const code3 = path15.charCodeAt(0);
          if (len === 1) {
            if (isPathSeparator3(code3)) {
              rootEnd = 1;
              isAbsolute4 = true;
            }
          } else if (isPathSeparator3(code3)) {
            isAbsolute4 = true;
            if (isPathSeparator3(path15.charCodeAt(1))) {
              let j = 2;
              let last = j;
              while (j < len && !isPathSeparator3(path15.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                const firstPart = path15.slice(last, j);
                last = j;
                while (j < len && isPathSeparator3(path15.charCodeAt(j))) {
                  j++;
                }
                if (j < len && j !== last) {
                  last = j;
                  while (j < len && !isPathSeparator3(path15.charCodeAt(j))) {
                    j++;
                  }
                  if (j === len || j !== last) {
                    device = `\\\\${firstPart}\\${path15.slice(last, j)}`;
                    rootEnd = j;
                  }
                }
              }
            } else {
              rootEnd = 1;
            }
          } else if (isWindowsDeviceRoot2(code3) && path15.charCodeAt(1) === CHAR_COLON2) {
            device = path15.slice(0, 2);
            rootEnd = 2;
            if (len > 2 && isPathSeparator3(path15.charCodeAt(2))) {
              isAbsolute4 = true;
              rootEnd = 3;
            }
          }
          if (device.length > 0) {
            if (resolvedDevice.length > 0) {
              if (device.toLowerCase() !== resolvedDevice.toLowerCase()) {
                continue;
              }
            } else {
              resolvedDevice = device;
            }
          }
          if (resolvedAbsolute) {
            if (resolvedDevice.length > 0) {
              break;
            }
          } else {
            resolvedTail = `${path15.slice(rootEnd)}\\${resolvedTail}`;
            resolvedAbsolute = isAbsolute4;
            if (isAbsolute4 && resolvedDevice.length > 0) {
              break;
            }
          }
        }
        resolvedTail = normalizeString2(resolvedTail, !resolvedAbsolute, "\\", isPathSeparator3);
        return resolvedAbsolute ? `${resolvedDevice}\\${resolvedTail}` : `${resolvedDevice}${resolvedTail}` || ".";
      },
      normalize(path15) {
        validateString2(path15, "path");
        const len = path15.length;
        if (len === 0) {
          return ".";
        }
        let rootEnd = 0;
        let device;
        let isAbsolute4 = false;
        const code3 = path15.charCodeAt(0);
        if (len === 1) {
          return isPosixPathSeparator2(code3) ? "\\" : path15;
        }
        if (isPathSeparator3(code3)) {
          isAbsolute4 = true;
          if (isPathSeparator3(path15.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator3(path15.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              const firstPart = path15.slice(last, j);
              last = j;
              while (j < len && isPathSeparator3(path15.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator3(path15.charCodeAt(j))) {
                  j++;
                }
                if (j === len) {
                  return `\\\\${firstPart}\\${path15.slice(last)}\\`;
                }
                if (j !== last) {
                  device = `\\\\${firstPart}\\${path15.slice(last, j)}`;
                  rootEnd = j;
                }
              }
            }
          } else {
            rootEnd = 1;
          }
        } else if (isWindowsDeviceRoot2(code3) && path15.charCodeAt(1) === CHAR_COLON2) {
          device = path15.slice(0, 2);
          rootEnd = 2;
          if (len > 2 && isPathSeparator3(path15.charCodeAt(2))) {
            isAbsolute4 = true;
            rootEnd = 3;
          }
        }
        let tail = rootEnd < len ? normalizeString2(path15.slice(rootEnd), !isAbsolute4, "\\", isPathSeparator3) : "";
        if (tail.length === 0 && !isAbsolute4) {
          tail = ".";
        }
        if (tail.length > 0 && isPathSeparator3(path15.charCodeAt(len - 1))) {
          tail += "\\";
        }
        if (device === void 0) {
          return isAbsolute4 ? `\\${tail}` : tail;
        }
        return isAbsolute4 ? `${device}\\${tail}` : `${device}${tail}`;
      },
      isAbsolute(path15) {
        validateString2(path15, "path");
        const len = path15.length;
        if (len === 0) {
          return false;
        }
        const code3 = path15.charCodeAt(0);
        return isPathSeparator3(code3) || // Possible device root
        len > 2 && isWindowsDeviceRoot2(code3) && path15.charCodeAt(1) === CHAR_COLON2 && isPathSeparator3(path15.charCodeAt(2));
      },
      join(...paths) {
        if (paths.length === 0) {
          return ".";
        }
        let joined;
        let firstPart;
        for (let i2 = 0; i2 < paths.length; ++i2) {
          const arg = paths[i2];
          validateString2(arg, "path");
          if (arg.length > 0) {
            if (joined === void 0) {
              joined = firstPart = arg;
            } else {
              joined += `\\${arg}`;
            }
          }
        }
        if (joined === void 0) {
          return ".";
        }
        let needsReplace = true;
        let slashCount = 0;
        if (typeof firstPart === "string" && isPathSeparator3(firstPart.charCodeAt(0))) {
          ++slashCount;
          const firstLen = firstPart.length;
          if (firstLen > 1 && isPathSeparator3(firstPart.charCodeAt(1))) {
            ++slashCount;
            if (firstLen > 2) {
              if (isPathSeparator3(firstPart.charCodeAt(2))) {
                ++slashCount;
              } else {
                needsReplace = false;
              }
            }
          }
        }
        if (needsReplace) {
          while (slashCount < joined.length && isPathSeparator3(joined.charCodeAt(slashCount))) {
            slashCount++;
          }
          if (slashCount >= 2) {
            joined = `\\${joined.slice(slashCount)}`;
          }
        }
        return exports2.win32.normalize(joined);
      },
      // It will solve the relative path from `from` to `to`, for instance:
      //  from = 'C:\\orandea\\test\\aaa'
      //  to = 'C:\\orandea\\impl\\bbb'
      // The output of the function should be: '..\\..\\impl\\bbb'
      relative(from, to) {
        validateString2(from, "from");
        validateString2(to, "to");
        if (from === to) {
          return "";
        }
        const fromOrig = exports2.win32.resolve(from);
        const toOrig = exports2.win32.resolve(to);
        if (fromOrig === toOrig) {
          return "";
        }
        from = fromOrig.toLowerCase();
        to = toOrig.toLowerCase();
        if (from === to) {
          return "";
        }
        let fromStart = 0;
        while (fromStart < from.length && from.charCodeAt(fromStart) === CHAR_BACKWARD_SLASH2) {
          fromStart++;
        }
        let fromEnd = from.length;
        while (fromEnd - 1 > fromStart && from.charCodeAt(fromEnd - 1) === CHAR_BACKWARD_SLASH2) {
          fromEnd--;
        }
        const fromLen = fromEnd - fromStart;
        let toStart = 0;
        while (toStart < to.length && to.charCodeAt(toStart) === CHAR_BACKWARD_SLASH2) {
          toStart++;
        }
        let toEnd = to.length;
        while (toEnd - 1 > toStart && to.charCodeAt(toEnd - 1) === CHAR_BACKWARD_SLASH2) {
          toEnd--;
        }
        const toLen = toEnd - toStart;
        const length = fromLen < toLen ? fromLen : toLen;
        let lastCommonSep = -1;
        let i2 = 0;
        for (; i2 < length; i2++) {
          const fromCode = from.charCodeAt(fromStart + i2);
          if (fromCode !== to.charCodeAt(toStart + i2)) {
            break;
          } else if (fromCode === CHAR_BACKWARD_SLASH2) {
            lastCommonSep = i2;
          }
        }
        if (i2 !== length) {
          if (lastCommonSep === -1) {
            return toOrig;
          }
        } else {
          if (toLen > length) {
            if (to.charCodeAt(toStart + i2) === CHAR_BACKWARD_SLASH2) {
              return toOrig.slice(toStart + i2 + 1);
            }
            if (i2 === 2) {
              return toOrig.slice(toStart + i2);
            }
          }
          if (fromLen > length) {
            if (from.charCodeAt(fromStart + i2) === CHAR_BACKWARD_SLASH2) {
              lastCommonSep = i2;
            } else if (i2 === 2) {
              lastCommonSep = 3;
            }
          }
          if (lastCommonSep === -1) {
            lastCommonSep = 0;
          }
        }
        let out2 = "";
        for (i2 = fromStart + lastCommonSep + 1; i2 <= fromEnd; ++i2) {
          if (i2 === fromEnd || from.charCodeAt(i2) === CHAR_BACKWARD_SLASH2) {
            out2 += out2.length === 0 ? ".." : "\\..";
          }
        }
        toStart += lastCommonSep;
        if (out2.length > 0) {
          return `${out2}${toOrig.slice(toStart, toEnd)}`;
        }
        if (toOrig.charCodeAt(toStart) === CHAR_BACKWARD_SLASH2) {
          ++toStart;
        }
        return toOrig.slice(toStart, toEnd);
      },
      toNamespacedPath(path15) {
        if (typeof path15 !== "string" || path15.length === 0) {
          return path15;
        }
        const resolvedPath = exports2.win32.resolve(path15);
        if (resolvedPath.length <= 2) {
          return path15;
        }
        if (resolvedPath.charCodeAt(0) === CHAR_BACKWARD_SLASH2) {
          if (resolvedPath.charCodeAt(1) === CHAR_BACKWARD_SLASH2) {
            const code3 = resolvedPath.charCodeAt(2);
            if (code3 !== CHAR_QUESTION_MARK2 && code3 !== CHAR_DOT2) {
              return `\\\\?\\UNC\\${resolvedPath.slice(2)}`;
            }
          }
        } else if (isWindowsDeviceRoot2(resolvedPath.charCodeAt(0)) && resolvedPath.charCodeAt(1) === CHAR_COLON2 && resolvedPath.charCodeAt(2) === CHAR_BACKWARD_SLASH2) {
          return `\\\\?\\${resolvedPath}`;
        }
        return path15;
      },
      dirname(path15) {
        validateString2(path15, "path");
        const len = path15.length;
        if (len === 0) {
          return ".";
        }
        let rootEnd = -1;
        let offset = 0;
        const code3 = path15.charCodeAt(0);
        if (len === 1) {
          return isPathSeparator3(code3) ? path15 : ".";
        }
        if (isPathSeparator3(code3)) {
          rootEnd = offset = 1;
          if (isPathSeparator3(path15.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator3(path15.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && isPathSeparator3(path15.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator3(path15.charCodeAt(j))) {
                  j++;
                }
                if (j === len) {
                  return path15;
                }
                if (j !== last) {
                  rootEnd = offset = j + 1;
                }
              }
            }
          }
        } else if (isWindowsDeviceRoot2(code3) && path15.charCodeAt(1) === CHAR_COLON2) {
          rootEnd = len > 2 && isPathSeparator3(path15.charCodeAt(2)) ? 3 : 2;
          offset = rootEnd;
        }
        let end = -1;
        let matchedSlash = true;
        for (let i2 = len - 1; i2 >= offset; --i2) {
          if (isPathSeparator3(path15.charCodeAt(i2))) {
            if (!matchedSlash) {
              end = i2;
              break;
            }
          } else {
            matchedSlash = false;
          }
        }
        if (end === -1) {
          if (rootEnd === -1) {
            return ".";
          }
          end = rootEnd;
        }
        return path15.slice(0, end);
      },
      basename(path15, ext2) {
        if (ext2 !== void 0) {
          validateString2(ext2, "ext");
        }
        validateString2(path15, "path");
        let start2 = 0;
        let end = -1;
        let matchedSlash = true;
        let i2;
        if (path15.length >= 2 && isWindowsDeviceRoot2(path15.charCodeAt(0)) && path15.charCodeAt(1) === CHAR_COLON2) {
          start2 = 2;
        }
        if (ext2 !== void 0 && ext2.length > 0 && ext2.length <= path15.length) {
          if (ext2 === path15) {
            return "";
          }
          let extIdx = ext2.length - 1;
          let firstNonSlashEnd = -1;
          for (i2 = path15.length - 1; i2 >= start2; --i2) {
            const code3 = path15.charCodeAt(i2);
            if (isPathSeparator3(code3)) {
              if (!matchedSlash) {
                start2 = i2 + 1;
                break;
              }
            } else {
              if (firstNonSlashEnd === -1) {
                matchedSlash = false;
                firstNonSlashEnd = i2 + 1;
              }
              if (extIdx >= 0) {
                if (code3 === ext2.charCodeAt(extIdx)) {
                  if (--extIdx === -1) {
                    end = i2;
                  }
                } else {
                  extIdx = -1;
                  end = firstNonSlashEnd;
                }
              }
            }
          }
          if (start2 === end) {
            end = firstNonSlashEnd;
          } else if (end === -1) {
            end = path15.length;
          }
          return path15.slice(start2, end);
        }
        for (i2 = path15.length - 1; i2 >= start2; --i2) {
          if (isPathSeparator3(path15.charCodeAt(i2))) {
            if (!matchedSlash) {
              start2 = i2 + 1;
              break;
            }
          } else if (end === -1) {
            matchedSlash = false;
            end = i2 + 1;
          }
        }
        if (end === -1) {
          return "";
        }
        return path15.slice(start2, end);
      },
      extname(path15) {
        validateString2(path15, "path");
        let start2 = 0;
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let preDotState = 0;
        if (path15.length >= 2 && path15.charCodeAt(1) === CHAR_COLON2 && isWindowsDeviceRoot2(path15.charCodeAt(0))) {
          start2 = startPart = 2;
        }
        for (let i2 = path15.length - 1; i2 >= start2; --i2) {
          const code3 = path15.charCodeAt(i2);
          if (isPathSeparator3(code3)) {
            if (!matchedSlash) {
              startPart = i2 + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i2 + 1;
          }
          if (code3 === CHAR_DOT2) {
            if (startDot === -1) {
              startDot = i2;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          return "";
        }
        return path15.slice(startDot, end);
      },
      format: _format3.bind(null, "\\"),
      parse(path15) {
        validateString2(path15, "path");
        const ret = { root: "", dir: "", base: "", ext: "", name: "" };
        if (path15.length === 0) {
          return ret;
        }
        const len = path15.length;
        let rootEnd = 0;
        let code3 = path15.charCodeAt(0);
        if (len === 1) {
          if (isPathSeparator3(code3)) {
            ret.root = ret.dir = path15;
            return ret;
          }
          ret.base = ret.name = path15;
          return ret;
        }
        if (isPathSeparator3(code3)) {
          rootEnd = 1;
          if (isPathSeparator3(path15.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator3(path15.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && isPathSeparator3(path15.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator3(path15.charCodeAt(j))) {
                  j++;
                }
                if (j === len) {
                  rootEnd = j;
                } else if (j !== last) {
                  rootEnd = j + 1;
                }
              }
            }
          }
        } else if (isWindowsDeviceRoot2(code3) && path15.charCodeAt(1) === CHAR_COLON2) {
          if (len <= 2) {
            ret.root = ret.dir = path15;
            return ret;
          }
          rootEnd = 2;
          if (isPathSeparator3(path15.charCodeAt(2))) {
            if (len === 3) {
              ret.root = ret.dir = path15;
              return ret;
            }
            rootEnd = 3;
          }
        }
        if (rootEnd > 0) {
          ret.root = path15.slice(0, rootEnd);
        }
        let startDot = -1;
        let startPart = rootEnd;
        let end = -1;
        let matchedSlash = true;
        let i2 = path15.length - 1;
        let preDotState = 0;
        for (; i2 >= rootEnd; --i2) {
          code3 = path15.charCodeAt(i2);
          if (isPathSeparator3(code3)) {
            if (!matchedSlash) {
              startPart = i2 + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i2 + 1;
          }
          if (code3 === CHAR_DOT2) {
            if (startDot === -1) {
              startDot = i2;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (end !== -1) {
          if (startDot === -1 || // We saw a non-dot character immediately before the dot
          preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
          preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
            ret.base = ret.name = path15.slice(startPart, end);
          } else {
            ret.name = path15.slice(startPart, startDot);
            ret.base = path15.slice(startPart, end);
            ret.ext = path15.slice(startDot, end);
          }
        }
        if (startPart > 0 && startPart !== rootEnd) {
          ret.dir = path15.slice(0, startPart - 1);
        } else {
          ret.dir = ret.root;
        }
        return ret;
      },
      sep: "\\",
      delimiter: ";",
      win32: null,
      posix: null
    };
    var posixCwd2 = (() => {
      if (platformIsWin322) {
        const regexp = /\\/g;
        return () => {
          const cwd2 = process2.cwd().replace(regexp, "/");
          return cwd2.slice(cwd2.indexOf("/"));
        };
      }
      return () => process2.cwd();
    })();
    exports2.posix = {
      // path.resolve([from ...], to)
      resolve(...pathSegments) {
        let resolvedPath = "";
        let resolvedAbsolute = false;
        for (let i2 = pathSegments.length - 1; i2 >= -1 && !resolvedAbsolute; i2--) {
          const path15 = i2 >= 0 ? pathSegments[i2] : posixCwd2();
          validateString2(path15, "path");
          if (path15.length === 0) {
            continue;
          }
          resolvedPath = `${path15}/${resolvedPath}`;
          resolvedAbsolute = path15.charCodeAt(0) === CHAR_FORWARD_SLASH2;
        }
        resolvedPath = normalizeString2(resolvedPath, !resolvedAbsolute, "/", isPosixPathSeparator2);
        if (resolvedAbsolute) {
          return `/${resolvedPath}`;
        }
        return resolvedPath.length > 0 ? resolvedPath : ".";
      },
      normalize(path15) {
        validateString2(path15, "path");
        if (path15.length === 0) {
          return ".";
        }
        const isAbsolute4 = path15.charCodeAt(0) === CHAR_FORWARD_SLASH2;
        const trailingSeparator = path15.charCodeAt(path15.length - 1) === CHAR_FORWARD_SLASH2;
        path15 = normalizeString2(path15, !isAbsolute4, "/", isPosixPathSeparator2);
        if (path15.length === 0) {
          if (isAbsolute4) {
            return "/";
          }
          return trailingSeparator ? "./" : ".";
        }
        if (trailingSeparator) {
          path15 += "/";
        }
        return isAbsolute4 ? `/${path15}` : path15;
      },
      isAbsolute(path15) {
        validateString2(path15, "path");
        return path15.length > 0 && path15.charCodeAt(0) === CHAR_FORWARD_SLASH2;
      },
      join(...paths) {
        if (paths.length === 0) {
          return ".";
        }
        let joined;
        for (let i2 = 0; i2 < paths.length; ++i2) {
          const arg = paths[i2];
          validateString2(arg, "path");
          if (arg.length > 0) {
            if (joined === void 0) {
              joined = arg;
            } else {
              joined += `/${arg}`;
            }
          }
        }
        if (joined === void 0) {
          return ".";
        }
        return exports2.posix.normalize(joined);
      },
      relative(from, to) {
        validateString2(from, "from");
        validateString2(to, "to");
        if (from === to) {
          return "";
        }
        from = exports2.posix.resolve(from);
        to = exports2.posix.resolve(to);
        if (from === to) {
          return "";
        }
        const fromStart = 1;
        const fromEnd = from.length;
        const fromLen = fromEnd - fromStart;
        const toStart = 1;
        const toLen = to.length - toStart;
        const length = fromLen < toLen ? fromLen : toLen;
        let lastCommonSep = -1;
        let i2 = 0;
        for (; i2 < length; i2++) {
          const fromCode = from.charCodeAt(fromStart + i2);
          if (fromCode !== to.charCodeAt(toStart + i2)) {
            break;
          } else if (fromCode === CHAR_FORWARD_SLASH2) {
            lastCommonSep = i2;
          }
        }
        if (i2 === length) {
          if (toLen > length) {
            if (to.charCodeAt(toStart + i2) === CHAR_FORWARD_SLASH2) {
              return to.slice(toStart + i2 + 1);
            }
            if (i2 === 0) {
              return to.slice(toStart + i2);
            }
          } else if (fromLen > length) {
            if (from.charCodeAt(fromStart + i2) === CHAR_FORWARD_SLASH2) {
              lastCommonSep = i2;
            } else if (i2 === 0) {
              lastCommonSep = 0;
            }
          }
        }
        let out2 = "";
        for (i2 = fromStart + lastCommonSep + 1; i2 <= fromEnd; ++i2) {
          if (i2 === fromEnd || from.charCodeAt(i2) === CHAR_FORWARD_SLASH2) {
            out2 += out2.length === 0 ? ".." : "/..";
          }
        }
        return `${out2}${to.slice(toStart + lastCommonSep)}`;
      },
      toNamespacedPath(path15) {
        return path15;
      },
      dirname(path15) {
        validateString2(path15, "path");
        if (path15.length === 0) {
          return ".";
        }
        const hasRoot = path15.charCodeAt(0) === CHAR_FORWARD_SLASH2;
        let end = -1;
        let matchedSlash = true;
        for (let i2 = path15.length - 1; i2 >= 1; --i2) {
          if (path15.charCodeAt(i2) === CHAR_FORWARD_SLASH2) {
            if (!matchedSlash) {
              end = i2;
              break;
            }
          } else {
            matchedSlash = false;
          }
        }
        if (end === -1) {
          return hasRoot ? "/" : ".";
        }
        if (hasRoot && end === 1) {
          return "//";
        }
        return path15.slice(0, end);
      },
      basename(path15, ext2) {
        if (ext2 !== void 0) {
          validateString2(ext2, "ext");
        }
        validateString2(path15, "path");
        let start2 = 0;
        let end = -1;
        let matchedSlash = true;
        let i2;
        if (ext2 !== void 0 && ext2.length > 0 && ext2.length <= path15.length) {
          if (ext2 === path15) {
            return "";
          }
          let extIdx = ext2.length - 1;
          let firstNonSlashEnd = -1;
          for (i2 = path15.length - 1; i2 >= 0; --i2) {
            const code3 = path15.charCodeAt(i2);
            if (code3 === CHAR_FORWARD_SLASH2) {
              if (!matchedSlash) {
                start2 = i2 + 1;
                break;
              }
            } else {
              if (firstNonSlashEnd === -1) {
                matchedSlash = false;
                firstNonSlashEnd = i2 + 1;
              }
              if (extIdx >= 0) {
                if (code3 === ext2.charCodeAt(extIdx)) {
                  if (--extIdx === -1) {
                    end = i2;
                  }
                } else {
                  extIdx = -1;
                  end = firstNonSlashEnd;
                }
              }
            }
          }
          if (start2 === end) {
            end = firstNonSlashEnd;
          } else if (end === -1) {
            end = path15.length;
          }
          return path15.slice(start2, end);
        }
        for (i2 = path15.length - 1; i2 >= 0; --i2) {
          if (path15.charCodeAt(i2) === CHAR_FORWARD_SLASH2) {
            if (!matchedSlash) {
              start2 = i2 + 1;
              break;
            }
          } else if (end === -1) {
            matchedSlash = false;
            end = i2 + 1;
          }
        }
        if (end === -1) {
          return "";
        }
        return path15.slice(start2, end);
      },
      extname(path15) {
        validateString2(path15, "path");
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let preDotState = 0;
        for (let i2 = path15.length - 1; i2 >= 0; --i2) {
          const code3 = path15.charCodeAt(i2);
          if (code3 === CHAR_FORWARD_SLASH2) {
            if (!matchedSlash) {
              startPart = i2 + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i2 + 1;
          }
          if (code3 === CHAR_DOT2) {
            if (startDot === -1) {
              startDot = i2;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          return "";
        }
        return path15.slice(startDot, end);
      },
      format: _format3.bind(null, "/"),
      parse(path15) {
        validateString2(path15, "path");
        const ret = { root: "", dir: "", base: "", ext: "", name: "" };
        if (path15.length === 0) {
          return ret;
        }
        const isAbsolute4 = path15.charCodeAt(0) === CHAR_FORWARD_SLASH2;
        let start2;
        if (isAbsolute4) {
          ret.root = "/";
          start2 = 1;
        } else {
          start2 = 0;
        }
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let i2 = path15.length - 1;
        let preDotState = 0;
        for (; i2 >= start2; --i2) {
          const code3 = path15.charCodeAt(i2);
          if (code3 === CHAR_FORWARD_SLASH2) {
            if (!matchedSlash) {
              startPart = i2 + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i2 + 1;
          }
          if (code3 === CHAR_DOT2) {
            if (startDot === -1) {
              startDot = i2;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (end !== -1) {
          const start3 = startPart === 0 && isAbsolute4 ? 1 : startPart;
          if (startDot === -1 || // We saw a non-dot character immediately before the dot
          preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
          preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
            ret.base = ret.name = path15.slice(start3, end);
          } else {
            ret.name = path15.slice(start3, startDot);
            ret.base = path15.slice(start3, end);
            ret.ext = path15.slice(startDot, end);
          }
        }
        if (startPart > 0) {
          ret.dir = path15.slice(0, startPart - 1);
        } else if (isAbsolute4) {
          ret.dir = "/";
        }
        return ret;
      },
      sep: "/",
      delimiter: ":",
      win32: null,
      posix: null
    };
    exports2.posix.win32 = exports2.win32.win32 = exports2.win32;
    exports2.posix.posix = exports2.win32.posix = exports2.posix;
    exports2.normalize = platformIsWin322 ? exports2.win32.normalize : exports2.posix.normalize;
    exports2.isAbsolute = platformIsWin322 ? exports2.win32.isAbsolute : exports2.posix.isAbsolute;
    exports2.join = platformIsWin322 ? exports2.win32.join : exports2.posix.join;
    exports2.resolve = platformIsWin322 ? exports2.win32.resolve : exports2.posix.resolve;
    exports2.relative = platformIsWin322 ? exports2.win32.relative : exports2.posix.relative;
    exports2.dirname = platformIsWin322 ? exports2.win32.dirname : exports2.posix.dirname;
    exports2.basename = platformIsWin322 ? exports2.win32.basename : exports2.posix.basename;
    exports2.extname = platformIsWin322 ? exports2.win32.extname : exports2.posix.extname;
    exports2.format = platformIsWin322 ? exports2.win32.format : exports2.posix.format;
    exports2.parse = platformIsWin322 ? exports2.win32.parse : exports2.posix.parse;
    exports2.toNamespacedPath = platformIsWin322 ? exports2.win32.toNamespacedPath : exports2.posix.toNamespacedPath;
    exports2.sep = platformIsWin322 ? exports2.win32.sep : exports2.posix.sep;
    exports2.delimiter = platformIsWin322 ? exports2.win32.delimiter : exports2.posix.delimiter;
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/util/vs/common/uri.js
var require_uri = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/util/vs/common/uri.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.URI = void 0;
    exports2.isUriComponents = isUriComponents2;
    exports2.uriToFsPath = uriToFsPath2;
    var paths = require_path();
    var platform_1 = require_platform();
    var _schemePattern2 = /^\w[\w\d+.-]*$/;
    var _singleSlashStart2 = /^\//;
    var _doubleSlashStart2 = /^\/\//;
    function _validateUri2(ret, _strict) {
      if (!ret.scheme && _strict) {
        throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${ret.authority}", path: "${ret.path}", query: "${ret.query}", fragment: "${ret.fragment}"}`);
      }
      if (ret.scheme && !_schemePattern2.test(ret.scheme)) {
        throw new Error("[UriError]: Scheme contains illegal characters.");
      }
      if (ret.path) {
        if (ret.authority) {
          if (!_singleSlashStart2.test(ret.path)) {
            throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
          }
        } else {
          if (_doubleSlashStart2.test(ret.path)) {
            throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
          }
        }
      }
    }
    function _schemeFix2(scheme, _strict) {
      if (!scheme && !_strict) {
        return "file";
      }
      return scheme;
    }
    function _referenceResolution2(scheme, path15) {
      switch (scheme) {
        case "https":
        case "http":
        case "file":
          if (!path15) {
            path15 = _slash2;
          } else if (path15[0] !== _slash2) {
            path15 = _slash2 + path15;
          }
          break;
      }
      return path15;
    }
    var _empty2 = "";
    var _slash2 = "/";
    var _regexp2 = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
    var URI2 = class _URI {
      static isUri(thing) {
        if (thing instanceof _URI) {
          return true;
        }
        if (!thing) {
          return false;
        }
        return typeof thing.authority === "string" && typeof thing.fragment === "string" && typeof thing.path === "string" && typeof thing.query === "string" && typeof thing.scheme === "string" && typeof thing.fsPath === "string" && typeof thing.with === "function" && typeof thing.toString === "function";
      }
      /**
       * scheme is the 'http' part of 'http://www.example.com/some/path?query#fragment'.
       * The part before the first colon.
       */
      scheme;
      /**
       * authority is the 'www.example.com' part of 'http://www.example.com/some/path?query#fragment'.
       * The part between the first double slashes and the next slash.
       */
      authority;
      /**
       * path is the '/some/path' part of 'http://www.example.com/some/path?query#fragment'.
       */
      path;
      /**
       * query is the 'query' part of 'http://www.example.com/some/path?query#fragment'.
       */
      query;
      /**
       * fragment is the 'fragment' part of 'http://www.example.com/some/path?query#fragment'.
       */
      fragment;
      /**
       * @internal
       */
      constructor(schemeOrData, authority, path15, query2, fragment, _strict = false) {
        if (typeof schemeOrData === "object") {
          this.scheme = schemeOrData.scheme || _empty2;
          this.authority = schemeOrData.authority || _empty2;
          this.path = schemeOrData.path || _empty2;
          this.query = schemeOrData.query || _empty2;
          this.fragment = schemeOrData.fragment || _empty2;
        } else {
          this.scheme = _schemeFix2(schemeOrData, _strict);
          this.authority = authority || _empty2;
          this.path = _referenceResolution2(this.scheme, path15 || _empty2);
          this.query = query2 || _empty2;
          this.fragment = fragment || _empty2;
          _validateUri2(this, _strict);
        }
      }
      // ---- filesystem path -----------------------
      /**
       * Returns a string representing the corresponding file system path of this URI.
       * Will handle UNC paths, normalizes windows drive letters to lower-case, and uses the
       * platform specific path separator.
       *
       * * Will *not* validate the path for invalid characters and semantics.
       * * Will *not* look at the scheme of this URI.
       * * The result shall *not* be used for display purposes but for accessing a file on disk.
       *
       *
       * The *difference* to `URI#path` is the use of the platform specific separator and the handling
       * of UNC paths. See the below sample of a file-uri with an authority (UNC path).
       *
       * ```ts
          const u = URI.parse('file://server/c$/folder/file.txt')
          u.authority === 'server'
          u.path === '/shares/c$/file.txt'
          u.fsPath === '\\server\c$\folder\file.txt'
      ```
       *
       * Using `URI#path` to read a file (using fs-apis) would not be enough because parts of the path,
       * namely the server name, would be missing. Therefore `URI#fsPath` exists - it's sugar to ease working
       * with URIs that represent files on disk (`file` scheme).
       */
      get fsPath() {
        return uriToFsPath2(this, false);
      }
      // ---- modify to new -------------------------
      with(change) {
        if (!change) {
          return this;
        }
        let { scheme, authority, path: path15, query: query2, fragment } = change;
        if (scheme === void 0) {
          scheme = this.scheme;
        } else if (scheme === null) {
          scheme = _empty2;
        }
        if (authority === void 0) {
          authority = this.authority;
        } else if (authority === null) {
          authority = _empty2;
        }
        if (path15 === void 0) {
          path15 = this.path;
        } else if (path15 === null) {
          path15 = _empty2;
        }
        if (query2 === void 0) {
          query2 = this.query;
        } else if (query2 === null) {
          query2 = _empty2;
        }
        if (fragment === void 0) {
          fragment = this.fragment;
        } else if (fragment === null) {
          fragment = _empty2;
        }
        if (scheme === this.scheme && authority === this.authority && path15 === this.path && query2 === this.query && fragment === this.fragment) {
          return this;
        }
        return new Uri48(scheme, authority, path15, query2, fragment);
      }
      // ---- parse & validate ------------------------
      /**
       * Creates a new URI from a string, e.g. `http://www.example.com/some/path`,
       * `file:///usr/home`, or `scheme:with/path`.
       *
       * @param value A string which represents an URI (see `URI#toString`).
       */
      static parse(value, _strict = false) {
        const match4 = _regexp2.exec(value);
        if (!match4) {
          return new Uri48(_empty2, _empty2, _empty2, _empty2, _empty2);
        }
        return new Uri48(match4[2] || _empty2, percentDecode2(match4[4] || _empty2), percentDecode2(match4[5] || _empty2), percentDecode2(match4[7] || _empty2), percentDecode2(match4[9] || _empty2), _strict);
      }
      /**
       * Creates a new URI from a file system path, e.g. `c:\my\files`,
       * `/usr/home`, or `\\server\share\some\path`.
       *
       * The *difference* between `URI#parse` and `URI#file` is that the latter treats the argument
       * as path, not as stringified-uri. E.g. `URI.file(path)` is **not the same as**
       * `URI.parse('file://' + path)` because the path might contain characters that are
       * interpreted (# and ?). See the following sample:
       * ```ts
      const good = URI.file('/coding/c#/project1');
      good.scheme === 'file';
      good.path === '/coding/c#/project1';
      good.fragment === '';
      const bad = URI.parse('file://' + '/coding/c#/project1');
      bad.scheme === 'file';
      bad.path === '/coding/c'; // path is now broken
      bad.fragment === '/project1';
      ```
       *
       * @param path A file system path (see `URI#fsPath`)
       */
      static file(path15) {
        let authority = _empty2;
        if (platform_1.isWindows) {
          path15 = path15.replace(/\\/g, _slash2);
        }
        if (path15[0] === _slash2 && path15[1] === _slash2) {
          const idx = path15.indexOf(_slash2, 2);
          if (idx === -1) {
            authority = path15.substring(2);
            path15 = _slash2;
          } else {
            authority = path15.substring(2, idx);
            path15 = path15.substring(idx) || _slash2;
          }
        }
        return new Uri48("file", authority, path15, _empty2, _empty2);
      }
      /**
       * Creates new URI from uri components.
       *
       * Unless `strict` is `true` the scheme is defaults to be `file`. This function performs
       * validation and should be used for untrusted uri components retrieved from storage,
       * user input, command arguments etc
       */
      static from(components, strict) {
        const result = new Uri48(components.scheme, components.authority, components.path, components.query, components.fragment, strict);
        return result;
      }
      /**
       * Join a URI path with path fragments and normalizes the resulting path.
       *
       * @param uri The input URI.
       * @param pathFragment The path fragment to add to the URI path.
       * @returns The resulting URI.
       */
      static joinPath(uri, ...pathFragment) {
        if (!uri.path) {
          throw new Error(`[UriError]: cannot call joinPath on URI without path`);
        }
        let newPath;
        if (platform_1.isWindows && uri.scheme === "file") {
          newPath = _URI.file(paths.win32.join(uriToFsPath2(uri, true), ...pathFragment)).path;
        } else {
          newPath = paths.posix.join(uri.path, ...pathFragment);
        }
        return uri.with({ path: newPath });
      }
      // ---- printing/externalize ---------------------------
      /**
       * Creates a string representation for this URI. It's guaranteed that calling
       * `URI.parse` with the result of this function creates an URI which is equal
       * to this URI.
       *
       * * The result shall *not* be used for display purposes but for externalization or transport.
       * * The result will be encoded using the percentage encoding and encoding happens mostly
       * ignore the scheme-specific encoding rules.
       *
       * @param skipEncoding Do not encode the result, default is `false`
       */
      toString(skipEncoding = false) {
        return _asFormatted2(this, skipEncoding);
      }
      toJSON() {
        return this;
      }
      static revive(data) {
        if (!data) {
          return data;
        } else if (data instanceof _URI) {
          return data;
        } else {
          const result = new Uri48(data);
          result._formatted = data.external ?? null;
          result._fsPath = data._sep === _pathSepMarker2 ? data.fsPath ?? null : null;
          return result;
        }
      }
    };
    exports2.URI = URI2;
    function isUriComponents2(thing) {
      if (!thing || typeof thing !== "object") {
        return false;
      }
      return typeof thing.scheme === "string" && (typeof thing.authority === "string" || typeof thing.authority === "undefined") && (typeof thing.path === "string" || typeof thing.path === "undefined") && (typeof thing.query === "string" || typeof thing.query === "undefined") && (typeof thing.fragment === "string" || typeof thing.fragment === "undefined");
    }
    var _pathSepMarker2 = platform_1.isWindows ? 1 : void 0;
    var Uri48 = class extends URI2 {
      _formatted = null;
      _fsPath = null;
      get fsPath() {
        if (!this._fsPath) {
          this._fsPath = uriToFsPath2(this, false);
        }
        return this._fsPath;
      }
      toString(skipEncoding = false) {
        if (!skipEncoding) {
          if (!this._formatted) {
            this._formatted = _asFormatted2(this, false);
          }
          return this._formatted;
        } else {
          return _asFormatted2(this, true);
        }
      }
      toJSON() {
        const res = {
          $mid: 1
          /* MarshalledId.Uri */
        };
        if (this._fsPath) {
          res.fsPath = this._fsPath;
          res._sep = _pathSepMarker2;
        }
        if (this._formatted) {
          res.external = this._formatted;
        }
        if (this.path) {
          res.path = this.path;
        }
        if (this.scheme) {
          res.scheme = this.scheme;
        }
        if (this.authority) {
          res.authority = this.authority;
        }
        if (this.query) {
          res.query = this.query;
        }
        if (this.fragment) {
          res.fragment = this.fragment;
        }
        return res;
      }
    };
    var encodeTable2 = {
      [
        58
        /* CharCode.Colon */
      ]: "%3A",
      // gen-delims
      [
        47
        /* CharCode.Slash */
      ]: "%2F",
      [
        63
        /* CharCode.QuestionMark */
      ]: "%3F",
      [
        35
        /* CharCode.Hash */
      ]: "%23",
      [
        91
        /* CharCode.OpenSquareBracket */
      ]: "%5B",
      [
        93
        /* CharCode.CloseSquareBracket */
      ]: "%5D",
      [
        64
        /* CharCode.AtSign */
      ]: "%40",
      [
        33
        /* CharCode.ExclamationMark */
      ]: "%21",
      // sub-delims
      [
        36
        /* CharCode.DollarSign */
      ]: "%24",
      [
        38
        /* CharCode.Ampersand */
      ]: "%26",
      [
        39
        /* CharCode.SingleQuote */
      ]: "%27",
      [
        40
        /* CharCode.OpenParen */
      ]: "%28",
      [
        41
        /* CharCode.CloseParen */
      ]: "%29",
      [
        42
        /* CharCode.Asterisk */
      ]: "%2A",
      [
        43
        /* CharCode.Plus */
      ]: "%2B",
      [
        44
        /* CharCode.Comma */
      ]: "%2C",
      [
        59
        /* CharCode.Semicolon */
      ]: "%3B",
      [
        61
        /* CharCode.Equals */
      ]: "%3D",
      [
        32
        /* CharCode.Space */
      ]: "%20"
    };
    function encodeURIComponentFast2(uriComponent, isPath, isAuthority) {
      let res = void 0;
      let nativeEncodePos = -1;
      for (let pos2 = 0; pos2 < uriComponent.length; pos2++) {
        const code3 = uriComponent.charCodeAt(pos2);
        if (code3 >= 97 && code3 <= 122 || code3 >= 65 && code3 <= 90 || code3 >= 48 && code3 <= 57 || code3 === 45 || code3 === 46 || code3 === 95 || code3 === 126 || isPath && code3 === 47 || isAuthority && code3 === 91 || isAuthority && code3 === 93 || isAuthority && code3 === 58) {
          if (nativeEncodePos !== -1) {
            res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos2));
            nativeEncodePos = -1;
          }
          if (res !== void 0) {
            res += uriComponent.charAt(pos2);
          }
        } else {
          if (res === void 0) {
            res = uriComponent.substr(0, pos2);
          }
          const escaped = encodeTable2[code3];
          if (escaped !== void 0) {
            if (nativeEncodePos !== -1) {
              res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos2));
              nativeEncodePos = -1;
            }
            res += escaped;
          } else if (nativeEncodePos === -1) {
            nativeEncodePos = pos2;
          }
        }
      }
      if (nativeEncodePos !== -1) {
        res += encodeURIComponent(uriComponent.substring(nativeEncodePos));
      }
      return res !== void 0 ? res : uriComponent;
    }
    function encodeURIComponentMinimal2(path15) {
      let res = void 0;
      for (let pos2 = 0; pos2 < path15.length; pos2++) {
        const code3 = path15.charCodeAt(pos2);
        if (code3 === 35 || code3 === 63) {
          if (res === void 0) {
            res = path15.substr(0, pos2);
          }
          res += encodeTable2[code3];
        } else {
          if (res !== void 0) {
            res += path15[pos2];
          }
        }
      }
      return res !== void 0 ? res : path15;
    }
    function uriToFsPath2(uri, keepDriveLetterCasing) {
      let value;
      if (uri.authority && uri.path.length > 1 && uri.scheme === "file") {
        value = `//${uri.authority}${uri.path}`;
      } else if (uri.path.charCodeAt(0) === 47 && (uri.path.charCodeAt(1) >= 65 && uri.path.charCodeAt(1) <= 90 || uri.path.charCodeAt(1) >= 97 && uri.path.charCodeAt(1) <= 122) && uri.path.charCodeAt(2) === 58) {
        if (!keepDriveLetterCasing) {
          value = uri.path[1].toLowerCase() + uri.path.substr(2);
        } else {
          value = uri.path.substr(1);
        }
      } else {
        value = uri.path;
      }
      if (platform_1.isWindows) {
        value = value.replace(/\//g, "\\");
      }
      return value;
    }
    function _asFormatted2(uri, skipEncoding) {
      const encoder = !skipEncoding ? encodeURIComponentFast2 : encodeURIComponentMinimal2;
      let res = "";
      let { scheme, authority, path: path15, query: query2, fragment } = uri;
      if (scheme) {
        res += scheme;
        res += ":";
      }
      if (authority || scheme === "file") {
        res += _slash2;
        res += _slash2;
      }
      if (authority) {
        let idx = authority.indexOf("@");
        if (idx !== -1) {
          const userinfo = authority.substr(0, idx);
          authority = authority.substr(idx + 1);
          idx = userinfo.lastIndexOf(":");
          if (idx === -1) {
            res += encoder(userinfo, false, false);
          } else {
            res += encoder(userinfo.substr(0, idx), false, false);
            res += ":";
            res += encoder(userinfo.substr(idx + 1), false, true);
          }
          res += "@";
        }
        authority = authority.toLowerCase();
        idx = authority.lastIndexOf(":");
        if (idx === -1) {
          res += encoder(authority, false, true);
        } else {
          res += encoder(authority.substr(0, idx), false, true);
          res += authority.substr(idx);
        }
      }
      if (path15) {
        if (path15.length >= 3 && path15.charCodeAt(0) === 47 && path15.charCodeAt(2) === 58) {
          const code3 = path15.charCodeAt(1);
          if (code3 >= 65 && code3 <= 90) {
            path15 = `/${String.fromCharCode(code3 + 32)}:${path15.substr(3)}`;
          }
        } else if (path15.length >= 2 && path15.charCodeAt(1) === 58) {
          const code3 = path15.charCodeAt(0);
          if (code3 >= 65 && code3 <= 90) {
            path15 = `${String.fromCharCode(code3 + 32)}:${path15.substr(2)}`;
          }
        }
        res += encoder(path15, true, false);
      }
      if (query2) {
        res += "?";
        res += encoder(query2, false, false);
      }
      if (fragment) {
        res += "#";
        res += !skipEncoding ? encodeURIComponentFast2(fragment, false, false) : fragment;
      }
      return res;
    }
    function decodeURIComponentGraceful2(str) {
      try {
        return decodeURIComponent(str);
      } catch {
        if (str.length > 3) {
          return str.substr(0, 3) + decodeURIComponentGraceful2(str.substr(3));
        } else {
          return str;
        }
      }
    }
    var _rEncodedAsHex2 = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
    function percentDecode2(str) {
      if (!str.match(_rEncodedAsHex2)) {
        return str;
      }
      return str.replace(_rEncodedAsHex2, (match4) => decodeURIComponentGraceful2(match4));
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/results.js
var require_results = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/results.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PromptReference = exports2.ChatResponseReferencePartStatusKind = exports2.PromptMetadata = void 0;
    var uri_1 = require_uri();
    var PromptMetadata6 = class {
      _marker;
      toString() {
        return Object.getPrototypeOf(this).constructor.name;
      }
    };
    exports2.PromptMetadata = PromptMetadata6;
    var ChatResponseReferencePartStatusKind4;
    (function(ChatResponseReferencePartStatusKind5) {
      ChatResponseReferencePartStatusKind5[ChatResponseReferencePartStatusKind5["Complete"] = 1] = "Complete";
      ChatResponseReferencePartStatusKind5[ChatResponseReferencePartStatusKind5["Partial"] = 2] = "Partial";
      ChatResponseReferencePartStatusKind5[ChatResponseReferencePartStatusKind5["Omitted"] = 3] = "Omitted";
    })(ChatResponseReferencePartStatusKind4 || (exports2.ChatResponseReferencePartStatusKind = ChatResponseReferencePartStatusKind4 = {}));
    var PromptReference29 = class _PromptReference {
      anchor;
      iconPath;
      options;
      static fromJSON(json) {
        const uriOrLocation = (v) => "scheme" in v ? uri_1.URI.from(v) : { uri: uri_1.URI.from(v.uri), range: v.range };
        return new _PromptReference("variableName" in json.anchor ? {
          variableName: json.anchor.variableName,
          value: json.anchor.value && uriOrLocation(json.anchor.value)
        } : uriOrLocation(json.anchor), json.iconPath && ("scheme" in json.iconPath ? uri_1.URI.from(json.iconPath) : "light" in json.iconPath ? { light: uri_1.URI.from(json.iconPath.light), dark: uri_1.URI.from(json.iconPath.dark) } : json.iconPath), json.options);
      }
      constructor(anchor, iconPath, options) {
        this.anchor = anchor;
        this.iconPath = iconPath;
        this.options = options;
      }
      toJSON() {
        return {
          anchor: this.anchor,
          iconPath: this.iconPath,
          options: this.options
        };
      }
    };
    exports2.PromptReference = PromptReference29;
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/promptRenderer.js
var require_promptRenderer = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/promptRenderer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PromptRenderer = exports2.MetadataMap = void 0;
    var JSONT = require_jsonTypes();
    var materialized_1 = require_materialized();
    var mode_1 = require_mode();
    var promptElements_1 = require_promptElements();
    var results_1 = require_results();
    var MetadataMap3;
    (function(MetadataMap4) {
      MetadataMap4.empty = {
        get: () => void 0,
        getAll: () => []
      };
      MetadataMap4.from = (metadata3) => {
        return {
          get: (ctor) => metadata3.find((m2) => m2 instanceof ctor),
          getAll: (ctor) => metadata3.filter((m2) => m2 instanceof ctor)
        };
      };
    })(MetadataMap3 || (exports2.MetadataMap = MetadataMap3 = {}));
    var PromptRenderer3 = class {
      _endpoint;
      _ctor;
      _props;
      _tokenizer;
      _usedContext = [];
      _ignoredFiles = [];
      _growables = [];
      _root = new PromptTreeElement(null, 0);
      _tokenLimits = [];
      /** Epoch used to tracing the order in which elements render. */
      tracer = void 0;
      /**
       * @param _endpoint The chat endpoint that the rendered prompt will be sent to.
       * @param _ctor The prompt element constructor to render.
       * @param _props The props to pass to the prompt element.
       */
      constructor(_endpoint, _ctor, _props, _tokenizer) {
        this._endpoint = _endpoint;
        this._ctor = _ctor;
        this._props = _props;
        this._tokenizer = _tokenizer;
      }
      getIgnoredFiles() {
        return Array.from(new Set(this._ignoredFiles));
      }
      getUsedContext() {
        return this._usedContext;
      }
      createElement(element) {
        return new element.ctor(element.props);
      }
      async _processPromptPieces(sizing, pieces, progress, token) {
        const promptElements = /* @__PURE__ */ new Map();
        for (const [i2, element] of pieces.entries()) {
          if (Array.isArray(element.children)) {
            element.props = element.props ?? {};
            element.props.children = element.children;
          }
          if (!element.ctor) {
            const loc = atPath(element.path);
            throw new Error(`Invalid ChatMessage child! Child must be a TSX component that extends PromptElement at ${loc}`);
          }
          const promptElement = this.createElement(element);
          let tokenLimit;
          if (promptElement instanceof promptElements_1.TokenLimit) {
            tokenLimit = element.props.max;
            this._tokenLimits.push({ limit: tokenLimit, id: element.node.id });
          }
          element.node.setObj(promptElement);
          const flexGroupValue = element.props.flexGrow ?? Infinity;
          let flexGroup = promptElements.get(flexGroupValue);
          if (!flexGroup) {
            flexGroup = [];
            promptElements.set(flexGroupValue, flexGroup);
          }
          flexGroup.push({ element, promptElementInstance: promptElement, tokenLimit });
        }
        if (promptElements.size === 0) {
          return;
        }
        const flexGroups = [...promptElements.entries()].sort(([a], [b]) => b - a).map(([_, group]) => group);
        const setReserved = (groupIndex) => {
          let reservedTokens = 0;
          for (let i2 = groupIndex + 1; i2 < flexGroups.length; i2++) {
            for (const { element } of flexGroups[i2]) {
              if (!element.props.flexReserve) {
                continue;
              }
              const reserve = typeof element.props.flexReserve === "string" ? (
                // Typings ensure the string is `/${number}`
                Math.floor(sizing.remainingTokenBudget / Number(element.props.flexReserve.slice(1)))
              ) : element.props.flexReserve;
              reservedTokens += reserve;
            }
          }
          sizing.consume(reservedTokens);
          return reservedTokens;
        };
        for (const [groupIndex, promptElements2] of flexGroups.entries()) {
          const reservedTokens = setReserved(groupIndex);
          let flexBasisSum = 0;
          for (const { element } of promptElements2) {
            flexBasisSum += element.props.flexBasis ?? 1;
          }
          let constantTokenLimits = 0;
          const useConstantLimitsForIndex = promptElements2.map((e) => {
            if (e.tokenLimit === void 0) {
              return false;
            }
            const flexBasis = e.element.props.flexBasis ?? 1;
            const proportion = flexBasis / flexBasisSum;
            const proportionateUsage = Math.floor(sizing.remainingTokenBudget * proportion);
            if (proportionateUsage < e.tokenLimit) {
              return false;
            }
            flexBasisSum -= flexBasis;
            constantTokenLimits += e.tokenLimit;
            return true;
          });
          const elementSizings = promptElements2.map((e, i2) => {
            const proportion = (e.element.props.flexBasis ?? 1) / flexBasisSum;
            return {
              tokenBudget: useConstantLimitsForIndex[i2] ? e.tokenLimit : Math.floor((sizing.remainingTokenBudget - constantTokenLimits) * proportion),
              endpoint: sizing.endpoint,
              countTokens: (text3, cancellation) => this._tokenizer.tokenLength(typeof text3 === "string" ? { type: mode_1.Raw.ChatCompletionContentPartKind.Text, text: text3 } : text3, cancellation)
            };
          });
          sizing.consume(-reservedTokens);
          this.tracer?.addRenderEpoch?.({
            inNode: promptElements2[0].element.node.parent?.id,
            flexValue: promptElements2[0].element.props.flexGrow ?? 0,
            tokenBudget: sizing.remainingTokenBudget,
            reservedTokens,
            elements: promptElements2.map((e, i2) => ({
              id: e.element.node.id,
              tokenBudget: elementSizings[i2].tokenBudget
            }))
          });
          await Promise.all(promptElements2.map(async ({ element, promptElementInstance }, i2) => {
            const state = await annotateError(element, () => promptElementInstance.prepare?.(elementSizings[i2], progress, token));
            element.node.setState(state);
          }));
          const templates = await Promise.all(promptElements2.map(async ({ element, promptElementInstance }, i2) => {
            const elementSizing = elementSizings[i2];
            return await annotateError(element, () => promptElementInstance.render(element.node.getState(), elementSizing, progress, token));
          }));
          for (const [i2, { element, promptElementInstance }] of promptElements2.entries()) {
            const elementSizing = elementSizings[i2];
            const template = templates[i2];
            if (!template) {
              continue;
            }
            const childConsumption = await this._processPromptRenderPiece(new PromptSizingContext(elementSizing.tokenBudget, this._endpoint), element, promptElementInstance, template, progress, token);
            if (promptElementInstance instanceof promptElements_1.Expandable) {
              this._growables.push({ initialConsume: childConsumption, elem: element.node });
            }
            sizing.consume(childConsumption);
          }
        }
      }
      async _processPromptRenderPiece(elementSizing, element, promptElementInstance, template, progress, token) {
        const pieces = flattenAndReduce(template);
        const childSizing = new PromptSizingContext(elementSizing.tokenBudget, this._endpoint);
        const { tokensConsumed } = await computeTokensConsumedByLiterals(this._tokenizer, element, promptElementInstance, pieces);
        childSizing.consume(tokensConsumed);
        await this._handlePromptChildren(element, pieces, childSizing, progress, token);
        return childSizing.consumed;
      }
      /**
       * Renders the prompt element and its children to a JSON-serializable state.
       * @returns A promise that resolves to an object containing the rendered chat messages and the total token count.
       * The total token count is guaranteed to be less than or equal to the token budget.
       */
      async renderElementJSON(token) {
        await this._processPromptPieces(new PromptSizingContext(this._endpoint.modelMaxPromptTokens, this._endpoint), [
          {
            node: this._root,
            ctor: this._ctor,
            props: this._props,
            children: [],
            path: [this._ctor]
          }
        ], void 0, token);
        return {
          node: this._root.toJSON()
        };
      }
      /**
       * Renders the prompt element and its children.
       * @returns A promise that resolves to an object containing the rendered chat messages and the total token count.
       * The total token count is guaranteed to be less than or equal to the token budget.
       */
      async render(progress, token) {
        const result = await this.renderRaw(progress, token);
        return { ...result, messages: (0, mode_1.toMode)(this._tokenizer.mode, result.messages) };
      }
      /**
       * Renders the prompt element and its children. Similar to {@link render}, but
       * returns the original message representation.
       */
      async renderRaw(progress, token) {
        await this._processPromptPieces(new PromptSizingContext(this._endpoint.modelMaxPromptTokens, this._endpoint), [
          {
            node: this._root,
            ctor: this._ctor,
            props: this._props,
            children: [],
            path: [this._ctor]
          }
        ], progress, token);
        const { container, allMetadata, removed } = await this._getFinalElementTree(this._endpoint.modelMaxPromptTokens, token);
        this.tracer?.didMaterializeTree?.({
          budget: this._endpoint.modelMaxPromptTokens,
          renderedTree: { container, removed, budget: this._endpoint.modelMaxPromptTokens },
          tokenizer: this._tokenizer,
          renderTree: (budget) => this._getFinalElementTree(budget, void 0).then((r) => ({ ...r, budget }))
        });
        const messageResult = [...container.toChatMessages()];
        const tokenCount = await container.tokenCount(this._tokenizer);
        const remainingMetadata = [...container.allMetadata()];
        const referenceNames = /* @__PURE__ */ new Set();
        const references = remainingMetadata.map((m2) => {
          if (!(m2 instanceof ReferenceMetadata)) {
            return;
          }
          const ref = m2.reference;
          const isVariableName = "variableName" in ref.anchor;
          if (isVariableName && !referenceNames.has(ref.anchor.variableName)) {
            referenceNames.add(ref.anchor.variableName);
            return ref;
          } else if (!isVariableName) {
            return ref;
          }
        }).filter(isDefined3);
        const omittedReferences = allMetadata.map((m2) => {
          if (!(m2 instanceof ReferenceMetadata) || remainingMetadata.includes(m2)) {
            return;
          }
          const ref = m2.reference;
          const isVariableName = "variableName" in ref.anchor;
          if (isVariableName && !referenceNames.has(ref.anchor.variableName)) {
            referenceNames.add(ref.anchor.variableName);
            return ref;
          } else if (!isVariableName) {
            return ref;
          }
        }).filter(isDefined3);
        return {
          metadata: MetadataMap3.from(remainingMetadata),
          messages: messageResult,
          hasIgnoredFiles: this._ignoredFiles.length > 0,
          tokenCount,
          references,
          omittedReferences
        };
      }
      /**
       * Note: this may be called multiple times from the tracer as users play
       * around with budgets. It should be side-effect-free.
       */
      async _getFinalElementTree(tokenBudget, token) {
        const root = this._root.materialize();
        const originalMessages = [...root.toChatMessages()];
        const allMetadata = [...root.allMetadata()];
        const limits = [{ limit: tokenBudget, id: this._root.id }, ...this._tokenLimits];
        let removed = 0;
        for (let i2 = limits.length - 1; i2 >= 0; i2--) {
          const limit = limits[i2];
          if (limit.limit > tokenBudget) {
            continue;
          }
          const container = root.findById(limit.id);
          if (!container) {
            continue;
          }
          const initialTokenCount = await container.tokenCount(this._tokenizer);
          if (initialTokenCount < limit.limit) {
            const didChange = await this._grow(container, initialTokenCount, limit.limit, token);
            if (!didChange) {
              continue;
            }
          }
          try {
            let tokenCount = await container.tokenCount(this._tokenizer);
            while (tokenCount > limit.limit) {
              const overhead = await container.baseMessageTokenCount(this._tokenizer);
              do {
                for (const node of container.removeLowestPriorityChild()) {
                  removed++;
                  const rmCount = node.upperBoundTokenCount(this._tokenizer);
                  tokenCount -= (typeof rmCount === "number" ? rmCount : await rmCount) * 1.25;
                }
              } while (tokenCount - overhead > limit.limit);
              tokenCount = await container.tokenCount(this._tokenizer);
            }
          } catch (e) {
            if (e instanceof materialized_1.BudgetExceededError) {
              e.metadata = MetadataMap3.from([...root.allMetadata()]);
              e.messages = originalMessages;
            }
            throw e;
          }
        }
        return { container: root, allMetadata, removed };
      }
      /** Grows all Expandable elements, returns if any changes were made. */
      async _grow(tree, tokensUsed, tokenBudget, token) {
        if (!this._growables.length) {
          return false;
        }
        for (const growable of this._growables) {
          if (!tree.findById(growable.elem.id)) {
            continue;
          }
          const obj = growable.elem.getObj();
          if (!(obj instanceof promptElements_1.Expandable)) {
            throw new Error("unreachable: expected growable");
          }
          const tempRoot = new PromptTreeElement(null, 0, growable.elem.id);
          const sizing = new PromptSizingContext(tokenBudget - tokensUsed + growable.initialConsume, this._endpoint);
          const newConsumed = await this._processPromptRenderPiece(sizing, { node: tempRoot, ctor: this._ctor, props: {}, children: [], path: [this._ctor] }, obj, await obj.render(void 0, {
            tokenBudget: sizing.tokenBudget,
            endpoint: this._endpoint,
            countTokens: (text3, cancellation) => this._tokenizer.tokenLength(typeof text3 === "string" ? { type: mode_1.Raw.ChatCompletionContentPartKind.Text, text: text3 } : text3, cancellation)
          }), void 0, token);
          const newContainer = tempRoot.materialize();
          const oldContainer = tree.replaceNode(growable.elem.id, newContainer);
          if (!oldContainer) {
            throw new Error("unreachable: could not find old element to replace");
          }
          tokensUsed -= growable.initialConsume;
          tokensUsed += newConsumed;
          if (tokensUsed >= tokenBudget) {
            break;
          }
        }
        return true;
      }
      _handlePromptChildren(element, pieces, sizing, progress, token) {
        if (element.ctor === promptElements_1.TextChunk) {
          this._handleExtrinsicTextChunkChildren(element.node, element.node, element.props, pieces);
          return;
        }
        let todo = [];
        for (const piece of pieces) {
          if (piece.kind === "literal") {
            element.node.appendStringChild(piece.value, element.props.priority ?? Number.MAX_SAFE_INTEGER);
            continue;
          }
          if (piece.kind === "intrinsic") {
            this._handleIntrinsic(element.node, piece.name, {
              priority: element.props.priority ?? Number.MAX_SAFE_INTEGER,
              ...piece.props
            }, flattenAndReduceArr(piece.children));
            continue;
          }
          const childNode = element.node.createChild();
          todo.push({
            node: childNode,
            ctor: piece.ctor,
            props: piece.props,
            children: piece.children,
            path: [...element.path, piece.ctor]
          });
        }
        return this._processPromptPieces(sizing, todo, progress, token);
      }
      _handleIntrinsic(node, name3, props, children, sortIndex) {
        switch (name3) {
          case "meta":
            return this._handleIntrinsicMeta(node, props, children);
          case "br":
            return this._handleIntrinsicLineBreak(node, props, children, props.priority, sortIndex);
          case "usedContext":
            return this._handleIntrinsicUsedContext(node, props, children);
          case "references":
            return this._handleIntrinsicReferences(node, props, children);
          case "ignoredFiles":
            return this._handleIntrinsicIgnoredFiles(node, props, children);
          case "elementJSON":
            return this._handleIntrinsicElementJSON(node, props.data);
          case "cacheBreakpoint":
            return this._handleIntrinsicCacheBreakpoint(node, props, children, sortIndex);
          case "opaque":
            return this._handleIntrinsicOpaque(node, props, sortIndex);
        }
        throw new Error(`Unknown intrinsic element ${name3}!`);
      }
      _handleIntrinsicCacheBreakpoint(node, props, children, sortIndex) {
        if (children.length > 0) {
          throw new Error(`<cacheBreakpoint /> must not have children!`);
        }
        node.addCacheBreakpoint(props, sortIndex);
      }
      _handleIntrinsicMeta(node, props, children) {
        if (children.length > 0) {
          throw new Error(`<meta /> must not have children!`);
        }
        if (props.local) {
          node.addMetadata(props.value);
        } else {
          this._root.addMetadata(props.value);
        }
      }
      _handleIntrinsicLineBreak(node, props, children, inheritedPriority, sortIndex) {
        if (children.length > 0) {
          throw new Error(`<br /> must not have children!`);
        }
        node.appendLineBreak(inheritedPriority ?? Number.MAX_SAFE_INTEGER, sortIndex);
      }
      _handleIntrinsicOpaque(node, props, sortIndex) {
        node.appendOpaque(props.value, props.tokenUsage, props.priority, sortIndex);
      }
      _handleIntrinsicElementJSON(node, data) {
        const appended = node.appendPieceJSON(data.node);
        if (this.tracer?.includeInEpoch) {
          for (const child of appended.elements()) {
            this.tracer.includeInEpoch({ id: child.id, tokenBudget: 0 });
          }
        }
      }
      _handleIntrinsicUsedContext(node, props, children) {
        if (children.length > 0) {
          throw new Error(`<usedContext /> must not have children!`);
        }
        this._usedContext.push(...props.value);
      }
      _handleIntrinsicReferences(node, props, children) {
        if (children.length > 0) {
          throw new Error(`<reference /> must not have children!`);
        }
        for (const ref of props.value) {
          node.addMetadata(new ReferenceMetadata(ref));
        }
      }
      _handleIntrinsicIgnoredFiles(node, props, children) {
        if (children.length > 0) {
          throw new Error(`<ignoredFiles /> must not have children!`);
        }
        this._ignoredFiles.push(...props.value);
      }
      /**
       * @param node Parent of the <TextChunk />
       * @param textChunkNode The <TextChunk /> node. All children are in-order
       * appended to the parent using the same sort index to ensure order is preserved.
       * @param props Props of the <TextChunk />
       * @param children Rendered children of the <TextChunk />
       */
      _handleExtrinsicTextChunkChildren(node, textChunkNode, props, children) {
        const content = [];
        const metadata3 = [];
        for (const child of children) {
          if (child.kind === "extrinsic") {
            throw new Error("TextChunk cannot have extrinsic children!");
          }
          if (child.kind === "literal") {
            content.push(child.value);
          }
          if (child.kind === "intrinsic") {
            if (child.name === "br") {
              content.push("\n");
            } else if (child.name === "references") {
              for (const reference2 of child.props.value) {
                metadata3.push(new ReferenceMetadata(reference2));
              }
            } else {
              this._handleIntrinsic(node, child.name, child.props, flattenAndReduceArr(child.children), textChunkNode.childIndex);
            }
          }
        }
        node.appendStringChild(content.join(""), props?.priority ?? Number.MAX_SAFE_INTEGER, metadata3, textChunkNode.childIndex, true);
      }
    };
    exports2.PromptRenderer = PromptRenderer3;
    async function computeTokensConsumedByLiterals(tokenizer, element, instance2, pieces) {
      let tokensConsumed = 0;
      if ((0, promptElements_1.isChatMessagePromptElement)(instance2)) {
        const raw2 = {
          role: element.props.role,
          content: [],
          ...element.props.name ? { name: element.props.name } : void 0,
          ...element.props.toolCalls ? { toolCalls: element.props.toolCalls } : void 0,
          ...element.props.toolCallId ? { toolCallId: element.props.toolCallId } : void 0
        };
        tokensConsumed += await tokenizer.countMessageTokens((0, mode_1.toMode)(tokenizer.mode, raw2));
      }
      for (const piece of pieces) {
        if (piece.kind === "literal") {
          tokensConsumed += await tokenizer.tokenLength({
            type: mode_1.Raw.ChatCompletionContentPartKind.Text,
            text: piece.value
          });
        }
      }
      return { tokensConsumed };
    }
    function flattenAndReduce(c, into = []) {
      if (typeof c === "undefined" || typeof c === "boolean") {
        return [];
      } else if (typeof c === "string" || typeof c === "number") {
        into.push(new LiteralPromptPiece(String(c)));
      } else if (isFragmentCtor(c)) {
        flattenAndReduceArr(c.children, into);
      } else if (isIterable3(c)) {
        flattenAndReduceArr(c, into);
      } else if (typeof c.ctor === "string") {
        into.push(new IntrinsicPromptPiece(c.ctor, c.props, c.children));
      } else {
        into.push(new ExtrinsicPromptPiece(c.ctor, c.props, c.children));
      }
      return into;
    }
    function flattenAndReduceArr(arr, into = []) {
      for (const entry of arr) {
        flattenAndReduce(entry, into);
      }
      return into;
    }
    var IntrinsicPromptPiece = class {
      name;
      props;
      children;
      kind = "intrinsic";
      constructor(name3, props, children) {
        this.name = name3;
        this.props = props;
        this.children = children;
      }
    };
    var ExtrinsicPromptPiece = class {
      ctor;
      props;
      children;
      kind = "extrinsic";
      constructor(ctor, props, children) {
        this.ctor = ctor;
        this.props = props;
        this.children = children;
      }
    };
    var LiteralPromptPiece = class {
      value;
      priority;
      kind = "literal";
      constructor(value, priority) {
        this.value = value;
        this.priority = priority;
      }
    };
    var PromptOpaque = class _PromptOpaque {
      parent;
      childIndex;
      value;
      tokenUsage;
      priority;
      static fromJSON(parent, index, json) {
        return new _PromptOpaque(parent, index, json.value, json.tokenUsage, json.priority);
      }
      kind = 2;
      constructor(parent, childIndex, value, tokenUsage, priority) {
        this.parent = parent;
        this.childIndex = childIndex;
        this.value = value;
        this.tokenUsage = tokenUsage;
        this.priority = priority;
      }
      materialize(parent) {
        return new materialized_1.MaterializedChatMessageOpaque(parent, {
          type: mode_1.Raw.ChatCompletionContentPartKind.Opaque,
          value: this.value,
          tokenUsage: this.tokenUsage
        }, this.priority);
      }
      toJSON() {
        return {
          type: 3,
          value: this.value,
          tokenUsage: this.tokenUsage,
          priority: this.priority
        };
      }
    };
    var PromptSizingContext = class {
      tokenBudget;
      endpoint;
      _consumed = 0;
      constructor(tokenBudget, endpoint) {
        this.tokenBudget = tokenBudget;
        this.endpoint = endpoint;
      }
      get consumed() {
        return this._consumed > this.tokenBudget ? this.tokenBudget : this._consumed;
      }
      get remainingTokenBudget() {
        return Math.max(0, this.tokenBudget - this._consumed);
      }
      /** Marks part of the budget as having been consumed by a render() call. */
      consume(budget) {
        this._consumed += budget;
      }
    };
    var PromptTreeElement = class _PromptTreeElement {
      parent;
      childIndex;
      id;
      static _nextId = 0;
      static fromJSON(index, json, keepWithMap) {
        const element = new _PromptTreeElement(null, index);
        element._metadata = json.references?.map((r) => new ReferenceMetadata(results_1.PromptReference.fromJSON(r))) ?? [];
        element._children = json.children.map((childJson, i2) => {
          switch (childJson.type) {
            case 1:
              return _PromptTreeElement.fromJSON(i2, childJson, keepWithMap);
            case 2:
              return PromptText.fromJSON(element, i2, childJson);
            case 3:
              return PromptOpaque.fromJSON(element, i2, childJson);
            default:
              softAssertNever(childJson);
          }
        }).filter(isDefined3);
        switch (json.ctor) {
          case 1:
            element._objFlags = json.flags ?? 0;
            element._obj = new promptElements_1.BaseChatMessage(json.props);
            break;
          case 2: {
            if (json.keepWithId !== void 0) {
              let kw = keepWithMap.get(json.keepWithId);
              if (!kw) {
                kw = (0, promptElements_1.useKeepWith)();
                keepWithMap.set(json.keepWithId, kw);
              }
              element._obj = new kw(json.props || {});
            } else {
              element._obj = new promptElements_1.LogicalWrapper(json.props || {});
            }
            element._objFlags = json.flags ?? 0;
            break;
          }
          case 3:
            element._obj = new promptElements_1.Image(json.props);
            break;
          default:
            softAssertNever(json);
        }
        return element;
      }
      kind = 1;
      _obj = null;
      _state = void 0;
      _children = [];
      _metadata = [];
      _objFlags = 0;
      constructor(parent = null, childIndex, id2 = _PromptTreeElement._nextId++) {
        this.parent = parent;
        this.childIndex = childIndex;
        this.id = id2;
      }
      setObj(obj) {
        this._obj = obj;
        if (this._obj instanceof promptElements_1.LegacyPrioritization)
          this._objFlags |= 1;
        if (this._obj instanceof promptElements_1.Chunk)
          this._objFlags |= 2;
        if (this._obj instanceof promptElements_1.IfEmpty)
          this._objFlags |= 8;
        if (this._obj.props.passPriority)
          this._objFlags |= 4;
      }
      /** @deprecated remove when Expandable is gone */
      getObj() {
        return this._obj;
      }
      setState(state) {
        this._state = state;
      }
      getState() {
        return this._state;
      }
      createChild() {
        const child = new _PromptTreeElement(this, this._children.length);
        this._children.push(child);
        return child;
      }
      appendPieceJSON(data) {
        const child = _PromptTreeElement.fromJSON(this._children.length, data, /* @__PURE__ */ new Map());
        this._children.push(child);
        return child;
      }
      appendStringChild(text3, priority, metadata3, sortIndex = this._children.length, lineBreakBefore = false) {
        this._children.push(new PromptText(this, sortIndex, text3, priority, metadata3, lineBreakBefore));
      }
      appendLineBreak(priority, sortIndex = this._children.length) {
        this._children.push(new PromptText(this, sortIndex, "\n", priority));
      }
      appendOpaque(value, tokenUsage, priority, sortIndex = this._children.length) {
        this._children.push(new PromptOpaque(this, sortIndex, value, tokenUsage, priority));
      }
      toJSON() {
        const json = {
          type: 1,
          ctor: 2,
          ctorName: this._obj?.constructor.name,
          children: this._children.slice().sort((a, b) => a.childIndex - b.childIndex).map((c) => c.toJSON()).filter(isDefined3),
          props: {},
          references: this._metadata.filter((m2) => m2 instanceof ReferenceMetadata).map((r) => r.reference.toJSON())
        };
        if (this._obj) {
          json.props = pickProps(this._obj.props, JSONT.jsonRetainedProps);
        }
        if (this._obj instanceof promptElements_1.BaseChatMessage) {
          json.ctor = 1;
          Object.assign(json.props, pickProps(this._obj.props, ["role", "name", "toolCalls", "toolCallId"]));
        } else if (this._obj instanceof promptElements_1.Image) {
          return {
            ...json,
            ctor: 3,
            props: {
              ...json.props,
              ...pickProps(this._obj.props, ["src", "detail"])
            }
          };
        } else if (this._obj instanceof promptElements_1.AbstractKeepWith) {
          json.keepWithId = this._obj.id;
        }
        if (this._objFlags !== 0) {
          json.flags = this._objFlags;
        }
        return json;
      }
      materialize(parent) {
        this._children.sort((a, b) => a.childIndex - b.childIndex);
        if (this._obj instanceof promptElements_1.Image) {
          return new materialized_1.MaterializedChatMessageImage(parent, this.id, this._obj.props.src, this._obj.props.priority ?? Number.MAX_SAFE_INTEGER, this._metadata, 0, this._obj.props.detail ?? void 0);
        }
        if (this._obj instanceof promptElements_1.BaseChatMessage) {
          if (this._obj.props.role === void 0 || typeof this._obj.props.role !== "number") {
            throw new Error(`Invalid ChatMessage!`);
          }
          return new materialized_1.MaterializedChatMessage(parent, this.id, this._obj.props.role, this._obj.props.name, this._obj instanceof promptElements_1.AssistantMessage ? this._obj.props.toolCalls : void 0, this._obj instanceof promptElements_1.ToolMessage ? this._obj.props.toolCallId : void 0, this._obj.props.priority ?? Number.MAX_SAFE_INTEGER, this._metadata, (parent2) => this._children.map((child) => child.materialize(parent2)));
        } else {
          const container = new materialized_1.GenericMaterializedContainer(parent, this.id, this._obj?.constructor.name, this._obj?.props.priority ?? (this._obj?.props.passPriority ? 0 : Number.MAX_SAFE_INTEGER), (parent2) => this._children.map((child) => child.materialize(parent2)), this._metadata, this._objFlags);
          if (this._obj instanceof promptElements_1.AbstractKeepWith) {
            container.keepWithId = this._obj.id;
          }
          return container;
        }
      }
      addMetadata(metadata3) {
        this._metadata.push(metadata3);
      }
      addCacheBreakpoint(breakpoint, sortIndex = this._children.length) {
        if (!(this._obj instanceof promptElements_1.BaseChatMessage)) {
          throw new Error("Cache breakpoints may only be direct children of chat messages");
        }
        this._children.push(new PromptCacheBreakpoint({ type: mode_1.Raw.ChatCompletionContentPartKind.CacheBreakpoint, cacheType: breakpoint.type }, sortIndex));
      }
      *elements() {
        yield this;
        for (const child of this._children) {
          if (child instanceof _PromptTreeElement) {
            yield* child.elements();
          }
        }
      }
    };
    var PromptCacheBreakpoint = class {
      part;
      childIndex;
      constructor(part, childIndex) {
        this.part = part;
        this.childIndex = childIndex;
      }
      toJSON() {
        return void 0;
      }
      materialize(parent) {
        return new materialized_1.MaterializedChatMessageBreakpoint(parent, this.part);
      }
    };
    var PromptText = class _PromptText {
      parent;
      childIndex;
      text;
      priority;
      metadata;
      lineBreakBefore;
      static fromJSON(parent, index, json) {
        return new _PromptText(parent, index, json.text, json.priority, json.references?.map((r) => new ReferenceMetadata(results_1.PromptReference.fromJSON(r))), json.lineBreakBefore);
      }
      kind = 2;
      constructor(parent, childIndex, text3, priority, metadata3, lineBreakBefore = false) {
        this.parent = parent;
        this.childIndex = childIndex;
        this.text = text3;
        this.priority = priority;
        this.metadata = metadata3;
        this.lineBreakBefore = lineBreakBefore;
      }
      materialize(parent) {
        const lineBreak = this.lineBreakBefore ? 1 : this.childIndex === 0 ? 2 : 0;
        return new materialized_1.MaterializedChatMessageTextChunk(parent, this.text, this.priority ?? Number.MAX_SAFE_INTEGER, this.metadata || [], lineBreak);
      }
      toJSON() {
        return {
          type: 2,
          priority: this.priority,
          text: this.text,
          references: this.metadata?.filter((m2) => m2 instanceof ReferenceMetadata).map((r) => r.reference.toJSON()),
          lineBreakBefore: this.lineBreakBefore
        };
      }
    };
    function isFragmentCtor(template) {
      return (typeof template.ctor === "function" && template.ctor.isFragment) ?? false;
    }
    function softAssertNever(x) {
    }
    function isDefined3(x) {
      return x !== void 0;
    }
    var InternalMetadata = class extends results_1.PromptMetadata {
    };
    var ReferenceMetadata = class extends InternalMetadata {
      reference;
      constructor(reference2) {
        super();
        this.reference = reference2;
      }
    };
    function isIterable3(t92) {
      return !!t92 && typeof t92[Symbol.iterator] === "function";
    }
    function pickProps(obj, keys) {
      const result = {};
      for (const key of keys) {
        if (obj.hasOwnProperty(key)) {
          result[key] = obj[key];
        }
      }
      return result;
    }
    function atPath(path15) {
      return path15.map((p2) => typeof p2 === "string" ? p2 : p2 ? p2.name || "<anonymous>" : String(p2)).join(" > ");
    }
    var annotatedErrors = /* @__PURE__ */ new WeakSet();
    async function annotateError(q2, fn) {
      try {
        return await fn();
      } catch (e) {
        if (e instanceof Error && !annotatedErrors.has(e) && e.constructor.name !== "CancellationError") {
          annotatedErrors.add(e);
          e.message += ` (at tsx element ${atPath(q2.path)})`;
        }
        throw e;
      }
    }
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/tokenizer/tokenizer.js
var require_tokenizer = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/tokenizer/tokenizer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.VSCodeTokenizer = void 0;
    var mode_1 = require_mode();
    var VSCodeTokenizer = class {
      countTokens;
      mode = mode_1.OutputMode.VSCode;
      constructor(countTokens, mode) {
        this.countTokens = countTokens;
        if (mode !== mode_1.OutputMode.VSCode) {
          throw new Error("`mode` must be set to vscode when using vscode.LanguageModelChat as the tokenizer");
        }
      }
      async tokenLength(part, token) {
        if (part.type === mode_1.Raw.ChatCompletionContentPartKind.Text) {
          return this.countTokens(part.text, token);
        }
        return Promise.resolve(0);
      }
      async countMessageTokens(message) {
        return this.countTokens(message);
      }
    };
    exports2.VSCodeTokenizer = VSCodeTokenizer;
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/htmlTracerSrc.js
var require_htmlTracerSrc = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/htmlTracerSrc.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.tracerCss = exports2.tracerSrc = void 0;
    exports2.tracerSrc = '"use strict";(()=>{var $,m,se,Ue,w,re,le,q,X,G,K,Ae,D={},ce=[],Re=/acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i,J=Array.isArray;function E(t,e){for(var n in e)t[n]=e[n];return t}function ue(t){t&&t.parentNode&&t.parentNode.removeChild(t)}function l(t,e,n){var o,r,_,c={};for(_ in e)_=="key"?o=e[_]:_=="ref"?r=e[_]:c[_]=e[_];if(arguments.length>2&&(c.children=arguments.length>3?$.call(arguments,2):n),typeof t=="function"&&t.defaultProps!=null)for(_ in t.defaultProps)c[_]===void 0&&(c[_]=t.defaultProps[_]);return R(t,c,o,r,null)}function R(t,e,n,o,r){var _={type:t,props:e,key:n,ref:o,__k:null,__:null,__b:0,__e:null,__d:void 0,__c:null,constructor:void 0,__v:r??++se,__i:-1,__u:0};return r==null&&m.vnode!=null&&m.vnode(_),_}function N(t){return t.children}function B(t,e){this.props=t,this.context=e}function I(t,e){if(e==null)return t.__?I(t.__,t.__i+1):null;for(var n;e<t.__k.length;e++)if((n=t.__k[e])!=null&&n.__e!=null)return n.__e;return typeof t.type=="function"?I(t):null}function de(t){var e,n;if((t=t.__)!=null&&t.__c!=null){for(t.__e=t.__c.base=null,e=0;e<t.__k.length;e++)if((n=t.__k[e])!=null&&n.__e!=null){t.__e=t.__c.base=n.__e;break}return de(t)}}function ie(t){(!t.__d&&(t.__d=!0)&&w.push(t)&&!O.__r++||re!==m.debounceRendering)&&((re=m.debounceRendering)||le)(O)}function O(){var t,e,n,o,r,_,c,a;for(w.sort(q);t=w.shift();)t.__d&&(e=w.length,o=void 0,_=(r=(n=t).__v).__e,c=[],a=[],n.__P&&((o=E({},r)).__v=r.__v+1,m.vnode&&m.vnode(o),Q(n.__P,o,r,n.__n,n.__P.namespaceURI,32&r.__u?[_]:null,c,_??I(r),!!(32&r.__u),a),o.__v=r.__v,o.__.__k[o.__i]=o,me(c,o,a),o.__e!=_&&de(o)),w.length>e&&w.sort(q));O.__r=0}function pe(t,e,n,o,r,_,c,a,u,s,p){var i,f,d,b,x,C=o&&o.__k||ce,h=e.length;for(n.__d=u,Be(n,e,C),u=n.__d,i=0;i<h;i++)(d=n.__k[i])!=null&&(f=d.__i===-1?D:C[d.__i]||D,d.__i=i,Q(t,d,f,r,_,c,a,u,s,p),b=d.__e,d.ref&&f.ref!=d.ref&&(f.ref&&Y(f.ref,null,d),p.push(d.ref,d.__c||b,d)),x==null&&b!=null&&(x=b),65536&d.__u||f.__k===d.__k?u=fe(d,u,t):typeof d.type=="function"&&d.__d!==void 0?u=d.__d:b&&(u=b.nextSibling),d.__d=void 0,d.__u&=-196609);n.__d=u,n.__e=x}function Be(t,e,n){var o,r,_,c,a,u=e.length,s=n.length,p=s,i=0;for(t.__k=[],o=0;o<u;o++)(r=e[o])!=null&&typeof r!="boolean"&&typeof r!="function"?(c=o+i,(r=t.__k[o]=typeof r=="string"||typeof r=="number"||typeof r=="bigint"||r.constructor==String?R(null,r,null,null,null):J(r)?R(N,{children:r},null,null,null):r.constructor===void 0&&r.__b>0?R(r.type,r.props,r.key,r.ref?r.ref:null,r.__v):r).__=t,r.__b=t.__b+1,_=null,(a=r.__i=Oe(r,n,c,p))!==-1&&(p--,(_=n[a])&&(_.__u|=131072)),_==null||_.__v===null?(a==-1&&i--,typeof r.type!="function"&&(r.__u|=65536)):a!==c&&(a==c-1?i--:a==c+1?i++:(a>c?i--:i++,r.__u|=65536))):r=t.__k[o]=null;if(p)for(o=0;o<s;o++)(_=n[o])!=null&&(131072&_.__u)==0&&(_.__e==t.__d&&(t.__d=I(_)),he(_,_))}function fe(t,e,n){var o,r;if(typeof t.type=="function"){for(o=t.__k,r=0;o&&r<o.length;r++)o[r]&&(o[r].__=t,e=fe(o[r],e,n));return e}t.__e!=e&&(e&&t.type&&!n.contains(e)&&(e=I(t)),n.insertBefore(t.__e,e||null),e=t.__e);do e=e&&e.nextSibling;while(e!=null&&e.nodeType===8);return e}function Oe(t,e,n,o){var r=t.key,_=t.type,c=n-1,a=n+1,u=e[n];if(u===null||u&&r==u.key&&_===u.type&&(131072&u.__u)==0)return n;if(o>(u!=null&&(131072&u.__u)==0?1:0))for(;c>=0||a<e.length;){if(c>=0){if((u=e[c])&&(131072&u.__u)==0&&r==u.key&&_===u.type)return c;c--}if(a<e.length){if((u=e[a])&&(131072&u.__u)==0&&r==u.key&&_===u.type)return a;a++}}return-1}function _e(t,e,n){e[0]==="-"?t.setProperty(e,n??""):t[e]=n==null?"":typeof n!="number"||Re.test(e)?n:n+"px"}function A(t,e,n,o,r){var _;e:if(e==="style")if(typeof n=="string")t.style.cssText=n;else{if(typeof o=="string"&&(t.style.cssText=o=""),o)for(e in o)n&&e in n||_e(t.style,e,"");if(n)for(e in n)o&&n[e]===o[e]||_e(t.style,e,n[e])}else if(e[0]==="o"&&e[1]==="n")_=e!==(e=e.replace(/(PointerCapture)$|Capture$/i,"$1")),e=e.toLowerCase()in t||e==="onFocusOut"||e==="onFocusIn"?e.toLowerCase().slice(2):e.slice(2),t.l||(t.l={}),t.l[e+_]=n,n?o?n.u=o.u:(n.u=X,t.addEventListener(e,_?K:G,_)):t.removeEventListener(e,_?K:G,_);else{if(r=="http://www.w3.org/2000/svg")e=e.replace(/xlink(H|:h)/,"h").replace(/sName$/,"s");else if(e!="width"&&e!="height"&&e!="href"&&e!="list"&&e!="form"&&e!="tabIndex"&&e!="download"&&e!="rowSpan"&&e!="colSpan"&&e!="role"&&e!="popover"&&e in t)try{t[e]=n??"";break e}catch{}typeof n=="function"||(n==null||n===!1&&e[4]!=="-"?t.removeAttribute(e):t.setAttribute(e,e=="popover"&&n==1?"":n))}}function ae(t){return function(e){if(this.l){var n=this.l[e.type+t];if(e.t==null)e.t=X++;else if(e.t<n.u)return;return n(m.event?m.event(e):e)}}}function Q(t,e,n,o,r,_,c,a,u,s){var p,i,f,d,b,x,C,h,v,H,M,P,F,oe,z,j,k=e.type;if(e.constructor!==void 0)return null;128&n.__u&&(u=!!(32&n.__u),_=[a=e.__e=n.__e]),(p=m.__b)&&p(e);e:if(typeof k=="function")try{if(h=e.props,v="prototype"in k&&k.prototype.render,H=(p=k.contextType)&&o[p.__c],M=p?H?H.props.value:p.__:o,n.__c?C=(i=e.__c=n.__c).__=i.__E:(v?e.__c=i=new k(h,M):(e.__c=i=new B(h,M),i.constructor=k,i.render=We),H&&H.sub(i),i.props=h,i.state||(i.state={}),i.context=M,i.__n=o,f=i.__d=!0,i.__h=[],i._sb=[]),v&&i.__s==null&&(i.__s=i.state),v&&k.getDerivedStateFromProps!=null&&(i.__s==i.state&&(i.__s=E({},i.__s)),E(i.__s,k.getDerivedStateFromProps(h,i.__s))),d=i.props,b=i.state,i.__v=e,f)v&&k.getDerivedStateFromProps==null&&i.componentWillMount!=null&&i.componentWillMount(),v&&i.componentDidMount!=null&&i.__h.push(i.componentDidMount);else{if(v&&k.getDerivedStateFromProps==null&&h!==d&&i.componentWillReceiveProps!=null&&i.componentWillReceiveProps(h,M),!i.__e&&(i.shouldComponentUpdate!=null&&i.shouldComponentUpdate(h,i.__s,M)===!1||e.__v===n.__v)){for(e.__v!==n.__v&&(i.props=h,i.state=i.__s,i.__d=!1),e.__e=n.__e,e.__k=n.__k,e.__k.some(function(U){U&&(U.__=e)}),P=0;P<i._sb.length;P++)i.__h.push(i._sb[P]);i._sb=[],i.__h.length&&c.push(i);break e}i.componentWillUpdate!=null&&i.componentWillUpdate(h,i.__s,M),v&&i.componentDidUpdate!=null&&i.__h.push(function(){i.componentDidUpdate(d,b,x)})}if(i.context=M,i.props=h,i.__P=t,i.__e=!1,F=m.__r,oe=0,v){for(i.state=i.__s,i.__d=!1,F&&F(e),p=i.render(i.props,i.state,i.context),z=0;z<i._sb.length;z++)i.__h.push(i._sb[z]);i._sb=[]}else do i.__d=!1,F&&F(e),p=i.render(i.props,i.state,i.context),i.state=i.__s;while(i.__d&&++oe<25);i.state=i.__s,i.getChildContext!=null&&(o=E(E({},o),i.getChildContext())),v&&!f&&i.getSnapshotBeforeUpdate!=null&&(x=i.getSnapshotBeforeUpdate(d,b)),pe(t,J(j=p!=null&&p.type===N&&p.key==null?p.props.children:p)?j:[j],e,n,o,r,_,c,a,u,s),i.base=e.__e,e.__u&=-161,i.__h.length&&c.push(i),C&&(i.__E=i.__=null)}catch(U){if(e.__v=null,u||_!=null){for(e.__u|=u?160:32;a&&a.nodeType===8&&a.nextSibling;)a=a.nextSibling;_[_.indexOf(a)]=null,e.__e=a}else e.__e=n.__e,e.__k=n.__k;m.__e(U,e,n)}else _==null&&e.__v===n.__v?(e.__k=n.__k,e.__e=n.__e):e.__e=$e(n.__e,e,n,o,r,_,c,u,s);(p=m.diffed)&&p(e)}function me(t,e,n){e.__d=void 0;for(var o=0;o<n.length;o++)Y(n[o],n[++o],n[++o]);m.__c&&m.__c(e,t),t.some(function(r){try{t=r.__h,r.__h=[],t.some(function(_){_.call(r)})}catch(_){m.__e(_,r.__v)}})}function $e(t,e,n,o,r,_,c,a,u){var s,p,i,f,d,b,x,C=n.props,h=e.props,v=e.type;if(v==="svg"?r="http://www.w3.org/2000/svg":v==="math"?r="http://www.w3.org/1998/Math/MathML":r||(r="http://www.w3.org/1999/xhtml"),_!=null){for(s=0;s<_.length;s++)if((d=_[s])&&"setAttribute"in d==!!v&&(v?d.localName===v:d.nodeType===3)){t=d,_[s]=null;break}}if(t==null){if(v===null)return document.createTextNode(h);t=document.createElementNS(r,v,h.is&&h),a&&(m.__m&&m.__m(e,_),a=!1),_=null}if(v===null)C===h||a&&t.data===h||(t.data=h);else{if(_=_&&$.call(t.childNodes),C=n.props||D,!a&&_!=null)for(C={},s=0;s<t.attributes.length;s++)C[(d=t.attributes[s]).name]=d.value;for(s in C)if(d=C[s],s!="children"){if(s=="dangerouslySetInnerHTML")i=d;else if(!(s in h)){if(s=="value"&&"defaultValue"in h||s=="checked"&&"defaultChecked"in h)continue;A(t,s,null,d,r)}}for(s in h)d=h[s],s=="children"?f=d:s=="dangerouslySetInnerHTML"?p=d:s=="value"?b=d:s=="checked"?x=d:a&&typeof d!="function"||C[s]===d||A(t,s,d,C[s],r);if(p)a||i&&(p.__html===i.__html||p.__html===t.innerHTML)||(t.innerHTML=p.__html),e.__k=[];else if(i&&(t.innerHTML=""),pe(t,J(f)?f:[f],e,n,o,v==="foreignObject"?"http://www.w3.org/1999/xhtml":r,_,c,_?_[0]:n.__k&&I(n,0),a,u),_!=null)for(s=_.length;s--;)ue(_[s]);a||(s="value",v==="progress"&&b==null?t.removeAttribute("value"):b!==void 0&&(b!==t[s]||v==="progress"&&!b||v==="option"&&b!==C[s])&&A(t,s,b,C[s],r),s="checked",x!==void 0&&x!==t[s]&&A(t,s,x,C[s],r))}return t}function Y(t,e,n){try{if(typeof t=="function"){var o=typeof t.__u=="function";o&&t.__u(),o&&e==null||(t.__u=t(e))}else t.current=e}catch(r){m.__e(r,n)}}function he(t,e,n){var o,r;if(m.unmount&&m.unmount(t),(o=t.ref)&&(o.current&&o.current!==t.__e||Y(o,null,e)),(o=t.__c)!=null){if(o.componentWillUnmount)try{o.componentWillUnmount()}catch(_){m.__e(_,e)}o.base=o.__P=null}if(o=t.__k)for(r=0;r<o.length;r++)o[r]&&he(o[r],e,n||typeof t.type!="function");n||ue(t.__e),t.__c=t.__=t.__e=t.__d=void 0}function We(t,e,n){return this.constructor(t,n)}function ve(t,e,n){var o,r,_,c;m.__&&m.__(t,e),r=(o=typeof n=="function")?null:n&&n.__k||e.__k,_=[],c=[],Q(e,t=(!o&&n||e).__k=l(N,null,[t]),r||D,D,e.namespaceURI,!o&&n?[n]:r?null:e.firstChild?$.call(e.childNodes):null,_,!o&&n?n:r?r.__e:e.firstChild,o,c),me(_,t,c)}$=ce.slice,m={__e:function(t,e,n,o){for(var r,_,c;e=e.__;)if((r=e.__c)&&!r.__)try{if((_=r.constructor)&&_.getDerivedStateFromError!=null&&(r.setState(_.getDerivedStateFromError(t)),c=r.__d),r.componentDidCatch!=null&&(r.componentDidCatch(t,o||{}),c=r.__d),c)return r.__E=r}catch(a){t=a}throw t}},se=0,Ue=function(t){return t!=null&&t.constructor==null},B.prototype.setState=function(t,e){var n;n=this.__s!=null&&this.__s!==this.state?this.__s:this.__s=E({},this.state),typeof t=="function"&&(t=t(E({},n),this.props)),t&&E(n,t),t!=null&&this.__v&&(e&&this._sb.push(e),ie(this))},B.prototype.forceUpdate=function(t){this.__v&&(this.__e=!0,t&&this.__h.push(t),ie(this))},B.prototype.render=N,w=[],le=typeof Promise=="function"?Promise.prototype.then.bind(Promise.resolve()):setTimeout,q=function(t,e){return t.__v.__b-e.__v.__b},O.__r=0,X=0,G=ae(!1),K=ae(!0),Ae=0;var L,g,Z,ge,V=0,Ee=[],y=m,be=y.__b,ye=y.__r,Ce=y.diffed,xe=y.__c,ke=y.unmount,Te=y.__;function te(t,e){y.__h&&y.__h(g,t,V||e),V=0;var n=g.__H||(g.__H={__:[],__h:[]});return t>=n.__.length&&n.__.push({}),n.__[t]}function S(t){return V=1,Ve(Ne,t)}function Ve(t,e,n){var o=te(L++,2);if(o.t=t,!o.__c&&(o.__=[n?n(e):Ne(void 0,e),function(a){var u=o.__N?o.__N[0]:o.__[0],s=o.t(u,a);u!==s&&(o.__N=[s,o.__[1]],o.__c.setState({}))}],o.__c=g,!g.u)){var r=function(a,u,s){if(!o.__c.__H)return!0;var p=o.__c.__H.__.filter(function(f){return!!f.__c});if(p.every(function(f){return!f.__N}))return!_||_.call(this,a,u,s);var i=!1;return p.forEach(function(f){if(f.__N){var d=f.__[0];f.__=f.__N,f.__N=void 0,d!==f.__[0]&&(i=!0)}}),!(!i&&o.__c.props===a)&&(!_||_.call(this,a,u,s))};g.u=!0;var _=g.shouldComponentUpdate,c=g.componentWillUpdate;g.componentWillUpdate=function(a,u,s){if(this.__e){var p=_;_=void 0,r(a,u,s),_=p}c&&c.call(this,a,u,s)},g.shouldComponentUpdate=r}return o.__N||o.__}function Se(t,e){var n=te(L++,3);!y.__s&&Ie(n.__H,e)&&(n.__=t,n.i=e,g.__H.__h.push(n))}function we(t){return V=5,je(function(){return{current:t}},[])}function je(t,e){var n=te(L++,7);return Ie(n.__H,e)&&(n.__=t(),n.__H=e,n.__h=t),n.__}function qe(){for(var t;t=Ee.shift();)if(t.__P&&t.__H)try{t.__H.__h.forEach(W),t.__H.__h.forEach(ee),t.__H.__h=[]}catch(e){t.__H.__h=[],y.__e(e,t.__v)}}y.__b=function(t){g=null,be&&be(t)},y.__=function(t,e){t&&e.__k&&e.__k.__m&&(t.__m=e.__k.__m),Te&&Te(t,e)},y.__r=function(t){ye&&ye(t),L=0;var e=(g=t.__c).__H;e&&(Z===g?(e.__h=[],g.__h=[],e.__.forEach(function(n){n.__N&&(n.__=n.__N),n.i=n.__N=void 0})):(e.__h.forEach(W),e.__h.forEach(ee),e.__h=[],L=0)),Z=g},y.diffed=function(t){Ce&&Ce(t);var e=t.__c;e&&e.__H&&(e.__H.__h.length&&(Ee.push(e)!==1&&ge===y.requestAnimationFrame||((ge=y.requestAnimationFrame)||Ge)(qe)),e.__H.__.forEach(function(n){n.i&&(n.__H=n.i),n.i=void 0})),Z=g=null},y.__c=function(t,e){e.some(function(n){try{n.__h.forEach(W),n.__h=n.__h.filter(function(o){return!o.__||ee(o)})}catch(o){e.some(function(r){r.__h&&(r.__h=[])}),e=[],y.__e(o,n.__v)}}),xe&&xe(t,e)},y.unmount=function(t){ke&&ke(t);var e,n=t.__c;n&&n.__H&&(n.__H.__.forEach(function(o){try{W(o)}catch(r){e=r}}),n.__H=void 0,e&&y.__e(e,n.__v))};var Me=typeof requestAnimationFrame=="function";function Ge(t){var e,n=function(){clearTimeout(o),Me&&cancelAnimationFrame(e),setTimeout(t)},o=setTimeout(n,100);Me&&(e=requestAnimationFrame(n))}function W(t){var e=g,n=t.__c;typeof n=="function"&&(t.__c=void 0,n()),g=e}function ee(t){var e=g;t.__c=t.__(),g=e}function Ie(t,e){return!t||t.length!==e.length||e.some(function(n,o){return n!==t[o]})}function Ne(t,e){return typeof e=="function"?e(t):e}function He(t,e){let n=we(void 0),o=(...r)=>{n.current&&clearTimeout(n.current),n.current=window.setTimeout(()=>{t(...r)},e)};return Se(()=>()=>{n.current&&clearTimeout(n.current)},[]),o}var Ke=new Intl.NumberFormat("en-US"),T=({value:t})=>l(N,null,Ke.format(t));var ne=[{bg:"#c1e7ff",fg:"#000"},{bg:"#abd2ec",fg:"#000"},{bg:"#94bed9",fg:"#000"},{bg:"#7faac6",fg:"#000"},{bg:"#6996b3",fg:"#fff"},{bg:"#5383a1",fg:"#fff"},{bg:"#3d708f",fg:"#fff"},{bg:"#255e7e",fg:"#fff"}],Xe=({scoreBy:t,nodes:e,epoch:n})=>{if(e.length===0)return null;let o=t;if(t.field!=="tokens"){let r=e[0][t.field],_=e[0][t.field];for(let c=1;c<e.length;c++)r=Math.max(r,e[c][t.field]),_=Math.max(_,e[c][t.field]);o={field:t.field,max:r,min:_}}return l("div",{className:"node-children"},e.map((r,_)=>r.type===2?l(Je,{scoreBy:o,key:_,node:r}):l(Le,{scoreBy:o,key:_,node:r,epoch:n})))},Fe=({node:t})=>l("div",{className:"node-stats"},"Used Tokens: ",l(T,{value:t.tokens})," / ","Priority:"," ",t.priority===Number.MAX_SAFE_INTEGER?"MAX":l(T,{value:t.priority})),De=({scoreBy:t,node:e,children:n,...o})=>{let r=0;if(t.max!==t.min){let _=(e[t.field]-t.min)/(t.max-t.min);r=Math.round((ne.length-1)*_)}return l("div",{...o,className:`node ${o.className||""}`,style:{backgroundColor:ne[r].bg,color:ne[r].fg}},n)},Je=({scoreBy:t,node:e})=>l(De,{node:e,scoreBy:t,tabIndex:0,className:"node-text"},l(Fe,{node:e}),l("div",{className:"node-content"},e.value)),Le=({scoreBy:t,node:e,epoch:n})=>{let[o,r]=S(!1),_=EPOCHS.findIndex(i=>i.elements.some(f=>f.id===e.id));if(_===void 0)throw new Error(`epoch not found for ${e.id}`);let c=EPOCHS[_],a=EPOCHS.at(n),u=c.elements.find(i=>i.id===e.id).tokenBudget,s=e.type===1?e.name||e.role.slice(0,1).toUpperCase()+e.role.slice(1)+"Message":e.name,p=_===n?"new-in-epoch":n<_?"before-epoch":"";return l(De,{node:e,scoreBy:t,className:p},l(Fe,{node:e}),l("div",{className:"node-content node-toggler",onClick:()=>r(i=>!i)},l("span",null,a?.inNode===e.id?"\\u{1F3C3} ":"",`<${s}>`),l("span",{className:"indicator"},o?"[+]":"[-]")),n===_&&l("div",{className:"node-stats"},"Token Budget: ",l(T,{value:u})),a?.inNode===e.id&&l("div",{className:"node-stats"},"Rendering flexGrow=",a.flexValue,l("br",null),l("br",null),"Splitting"," ",a.reservedTokens?`${a.tokenBudget} - ${a.reservedTokens} (reserved) = `:"",l(T,{value:a.tokenBudget})," tokens among ",a.elements.length," ","elements"),!o&&l(Xe,{nodes:e.children,scoreBy:t,epoch:n}))},Pe=({scoreBy:t,node:e,epoch:n})=>{let o;return t==="tokens"?o={field:"tokens",max:e.tokens,min:0}:o={field:"priority",max:e.priority,min:e.priority},l(Le,{scoreBy:o,node:e,epoch:n})};var ze=({label:t,value:e,onChange:n,min:o,max:r})=>{let _=a=>{n(a.target.valueAsNumber)},c=`number-slider-${Math.random()}`;return l("div",{className:"controls-slider"},l("label",{htmlFor:c},t),l("input",{id:c,type:"range",min:o,max:r,value:e,onInput:_}),l("input",{type:"number",min:o,value:e,onInput:_,onChange:_}))},Qe=({scoreBy:t,onScoreByChange:e})=>{let n=o=>{let r=o.target.value;e(r)};return l("div",{className:"controls-scoreby"},"Visualize by",l("label",null,l("input",{type:"radio",name:"scoreBy",value:"tokens",checked:t==="tokens",onChange:n}),"Tokens"),l("label",null,l("input",{type:"radio",name:"scoreBy",value:"priority",checked:t==="priority",onChange:n}),"Priority"))},Ye=()=>{let[t,e]=S(DEFAULT_TOKENS),[n,o]=S(EPOCHS.length),[r,_]=S(DEFAULT_MODEL),[c,a]=S("tokens"),[u,s]=S("epoch"),p=He(async f=>{if(f===DEFAULT_TOKENS)return DEFAULT_MODEL;let b=await(await fetch(`${SERVER_ADDRESS}regen?n=${f}`)).json();_(b)},100),i=f=>{e(f),p(f),o(EPOCHS.length)};return l("div",{className:"app"},l("div",{className:"controls"},l("div",{className:"tabs"},l("div",{className:`tab ${u==="epoch"?"active":""}`,onClick:()=>s("epoch")},"View Order"),l("div",{className:`tab ${u==="tokens"?"active":""}`,onClick:()=>s("tokens")},"Change Token Budget")),l("div",{className:`tab-content ${u==="epoch"?"active":""}`},l(ze,{label:"Render Epoch",value:n,onChange:o,min:0,max:EPOCHS.length})),l("div",{className:`tab-content ${u==="tokens"?"active":""}`},l(ze,{label:"Token Budget",value:t,onChange:i,min:0,max:DEFAULT_TOKENS*2}))),l("div",{className:"control-description"},u==="tokens"?l("p",null,"Token changes here will prune elements and re-render Expandable ones, but the entire prompt is not being re-rendered"):l("p",null,"Changing the render epoch lets you see the order in which elements are rendered and how the token budget is allocated."),l("div",{className:"controls-stats"},l("span",null,"Used ",l(T,{value:r.container.tokens}),"/",l(T,{value:r.budget})," tokens"),l("span",null,"Removed ",l(T,{value:r.removed})," nodes"),l(Qe,{scoreBy:c,onScoreByChange:a}))),l(Pe,{node:r.container,scoreBy:c,epoch:n}))};ve(l(Ye,null),document.body);})();\n';
    exports2.tracerCss = "body{font-family:-apple-system,BlinkMacSystemFont,Segoe WPC,Segoe UI,system-ui,Ubuntu,Droid Sans,sans-serif;background:#fff;margin:0}.render-pass{border-left:2px solid #ccc;&:hover{border-left-color:#000}}.literals li{white-space:pre;font-family:SF Mono,Monaco,Menlo,Consolas,Ubuntu Mono,Liberation Mono,DejaVu Sans Mono,Courier New,monospace}.render-flex,.render-element{padding-left:10px}.node{border:1px solid rgba(255,255,255,.5);margin:3px 10px;padding:3px 10px;border-radius:4px;width:fit-content;&.new-in-epoch{box-shadow:0 0 3px 2px red}&.before-epoch{pointer-events:none;filter:grayscale(1);color:#777!important;.node{color:#777!important}}&:last-child{margin-bottom:0}}.node-content{font-weight:700}.node-children{margin-left:20px;border-left:2px dashed rgba(255,255,255,.5);padding-left:10px}.node-toggler{cursor:pointer;display:flex;align-items:center;justify-content:space-between;.indicator{font-size:.7em}}.node-text{width:400px;&:focus,&:focus-within{outline:1px solid orange;.node-content{white-space:normal}}.node-content{font-weight:400;font-size:.8em;white-space:nowrap;text-overflow:ellipsis;overflow:hidden}}.node-stats{font-family:SF Mono,Monaco,Menlo,Consolas,Ubuntu Mono,Liberation Mono,DejaVu Sans Mono,Courier New,monospace;font-size:.8em}.control-description{padding:10px;p{font-size:.9em;max-width:500px;margin-top:0}}.controls{display:flex;flex-direction:column;gap:10px;position:sticky;top:0;padding:10px;background:#fff;border-bottom:1px solid #ccc;z-index:1}.controls-slider{display:flex;align-items:center;gap:10px}.controls-stats{display:flex;gap:20px;list-style:none;padding:0;margin-top:0}.controls-scoreby{display:flex;gap:10px}.tabs{display:flex;border-bottom:1px solid #ccc;margin-bottom:10px}.tab{padding:10px;cursor:pointer;border:1px solid transparent;border-bottom:none}.tab.active{border-color:#ccc;border-bottom:1px solid #fff;background-color:#f9f9f9}.tab-content{display:none}.tab-content.active{display:block}\n";
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/htmlTracer.js
var require_htmlTracer = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/htmlTracer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HTMLTracer = void 0;
    var htmlTracerSrc_1 = require_htmlTracerSrc();
    var materialized_1 = require_materialized();
    var mode_1 = require_mode();
    var HTMLTracer2 = class {
      traceData;
      epochs = [];
      addRenderEpoch(epoch) {
        this.epochs.push(epoch);
      }
      includeInEpoch(data) {
        this.epochs[this.epochs.length - 1].elements.push(data);
      }
      didMaterializeTree(traceData) {
        this.traceData = traceData;
      }
      /**
       * Returns HTML to trace the output. Note that is starts a server which is
       * used for client interaction to resize the prompt and its `address` should
       * be displayed or opened as a link in a browser.
       *
       * The server runs until it is disposed.
       */
      async serveHTML() {
        return RequestServer2.create({
          epochs: this.epochs,
          traceData: mustGet(this.traceData)
        });
      }
      /**
       * Gets an HTML router for a server at the URL. URL is the form `http://127.0.0.1:1234`.
       */
      serveRouter(url) {
        return new RequestRouter({
          baseAddress: url,
          epochs: this.epochs,
          traceData: mustGet(this.traceData)
        });
      }
    };
    exports2.HTMLTracer = HTMLTracer2;
    var RequestRouter = class {
      opts;
      serverToken = crypto.randomUUID();
      constructor(opts) {
        this.opts = opts;
      }
      route(httpIncomingMessage, httpOutgoingMessage) {
        const req = httpIncomingMessage;
        const res = httpOutgoingMessage;
        const url = new URL(req.url || "/", `http://localhost`);
        const prefix = `/${this.serverToken}`;
        switch (url.pathname) {
          case prefix:
          case `${prefix}/`:
            this.onRoot(url, req, res);
            break;
          case `${prefix}/regen`:
            this.onRegen(url, req, res);
            break;
          default:
            return false;
        }
        return true;
      }
      get address() {
        return this.opts.baseAddress + "/" + this.serverToken;
      }
      async getHTML() {
        const { traceData, epochs } = this.opts;
        return `<body>
			<style>${htmlTracerSrc_1.tracerCss}</style>
			<script>
				const DEFAULT_TOKENS = ${JSON.stringify(traceData.budget)};
				const EPOCHS = ${JSON.stringify(epochs)};
				const DEFAULT_MODEL = ${JSON.stringify(await serializeRenderData(traceData.tokenizer, traceData.renderedTree))};
				const SERVER_ADDRESS = ${JSON.stringify(this.opts.baseAddress + "/" + this.serverToken + "/")};
				${htmlTracerSrc_1.tracerSrc}
			</script>
		</body>`;
      }
      async onRegen(url, _req, res) {
        const { traceData } = this.opts;
        const budget = Number(url.searchParams.get("n") || traceData.budget);
        const renderedTree = await traceData.renderTree(budget);
        const serialized = await serializeRenderData(traceData.tokenizer, renderedTree);
        const json = JSON.stringify(serialized);
        res.setHeader("Content-Type", "application/json");
        res.setHeader("Content-Length", Buffer.byteLength(json));
        res.end(json);
      }
      onRoot(_url, _req, res) {
        this.getHTML().then((html) => {
          res.setHeader("Content-Type", "text/html");
          res.setHeader("Content-Length", Buffer.byteLength(html));
          res.end(html);
        });
      }
    };
    var RequestServer2 = class _RequestServer extends RequestRouter {
      server;
      static async create(opts) {
        const { createServer: createServer3 } = await Promise.resolve().then(() => require("http"));
        const server = createServer3((req, res) => {
          try {
            if (!instance2.route(req, res)) {
              res.statusCode = 404;
              res.end("Not Found");
            }
          } catch (e) {
            res.statusCode = 500;
            res.end(String(e));
          }
        });
        const port = await new Promise((resolve3, reject) => {
          server.listen(0, "127.0.0.1", () => resolve3(server.address().port)).on("error", reject);
        });
        const instance2 = new _RequestServer({
          ...opts,
          baseAddress: `http://127.0.0.1:${port}`
        }, server);
        return instance2;
      }
      constructor(opts, server) {
        super(opts);
        this.server = server;
      }
      dispose() {
        this.server.closeAllConnections();
        this.server.close();
      }
    };
    async function serializeRenderData(tokenizer, tree) {
      return {
        container: await serializeMaterialized(tokenizer, tree.container, false),
        removed: tree.removed,
        budget: tree.budget
      };
    }
    async function serializeMaterialized(tokenizer, materialized, inChatMessage) {
      const common = {
        metadata: materialized.metadata.map(serializeMetadata),
        priority: materialized.priority
      };
      if (materialized instanceof materialized_1.MaterializedChatMessageTextChunk) {
        return {
          ...common,
          type: 2,
          value: materialized.text,
          tokens: await materialized.upperBoundTokenCount(tokenizer)
        };
      } else if (materialized instanceof materialized_1.MaterializedChatMessageImage) {
        return {
          ...common,
          name: materialized.id.toString(),
          id: materialized.id,
          type: 3,
          value: materialized.src,
          tokens: await materialized.upperBoundTokenCount(tokenizer)
        };
      } else if (materialized instanceof materialized_1.MaterializedChatMessageOpaque || materialized instanceof materialized_1.MaterializedChatMessageBreakpoint) {
        return void 0;
      } else {
        const containerCommon = {
          ...common,
          id: materialized.id,
          name: materialized.name,
          children: (await Promise.all(materialized.children.map((c) => serializeMaterialized(tokenizer, c, inChatMessage || materialized instanceof materialized_1.MaterializedChatMessage)))).filter((r) => !!r),
          tokens: inChatMessage ? await materialized.upperBoundTokenCount(tokenizer) : await materialized.tokenCount(tokenizer)
        };
        if (materialized instanceof materialized_1.GenericMaterializedContainer) {
          return {
            ...containerCommon,
            type: 0
          };
        } else if (materialized instanceof materialized_1.MaterializedChatMessage) {
          const content = materialized.text.filter((element) => typeof element === "string").join("").trim();
          return {
            ...containerCommon,
            type: 1,
            role: mode_1.Raw.ChatRole.display(materialized.role),
            text: content
          };
        }
      }
      assertNever2(materialized);
    }
    function assertNever2(x) {
      throw new Error("unreachable");
    }
    function serializeMetadata(metadata3) {
      return { name: metadata3.constructor.name, value: JSON.stringify(metadata3) };
    }
    var mustGet = (value) => {
      if (value === void 0) {
        throw new Error("Prompt must be rendered before calling HTMLTRacer.serveHTML");
      }
      return value;
    };
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/tracer.js
var require_tracer = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/tracer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/tsx-globals.js
var require_tsx_globals = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/tsx-globals.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/types.js
var require_types = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// node_modules/@vscode/prompt-tsx/dist/base/index.js
var require_base = __commonJS({
  "node_modules/@vscode/prompt-tsx/dist/base/index.js"(exports2) {
    "use strict";
    var __createBinding3 = exports2 && exports2.__createBinding || (Object.create ? function(o, m2, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m2, k);
      if (!desc || ("get" in desc ? !m2.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m2[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m2, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m2[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m2, exports3) {
      for (var p2 in m2) if (p2 !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p2)) __createBinding3(exports3, m2, p2);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.contentType = exports2.PromptRenderer = exports2.MetadataMap = exports2.PromptElement = exports2.JSONTree = void 0;
    exports2.renderPrompt = renderPrompt2;
    exports2.renderElementJSON = renderElementJSON;
    var mode_1 = require_mode();
    var promptRenderer_1 = require_promptRenderer();
    var tokenizer_1 = require_tokenizer();
    __exportStar2(require_htmlTracer(), exports2);
    exports2.JSONTree = require_jsonTypes();
    __exportStar2(require_mode(), exports2);
    __exportStar2(require_promptElements(), exports2);
    __exportStar2(require_results(), exports2);
    __exportStar2(require_tracer(), exports2);
    __exportStar2(require_tsx_globals(), exports2);
    __exportStar2(require_types(), exports2);
    var promptElement_1 = require_promptElement();
    Object.defineProperty(exports2, "PromptElement", { enumerable: true, get: function() {
      return promptElement_1.PromptElement;
    } });
    var promptRenderer_2 = require_promptRenderer();
    Object.defineProperty(exports2, "MetadataMap", { enumerable: true, get: function() {
      return promptRenderer_2.MetadataMap;
    } });
    Object.defineProperty(exports2, "PromptRenderer", { enumerable: true, get: function() {
      return promptRenderer_2.PromptRenderer;
    } });
    async function renderPrompt2(ctor, props, endpoint, tokenizerMetadata, progress, token, mode = mode_1.OutputMode.VSCode) {
      let tokenizer = "countTokens" in tokenizerMetadata ? new tokenizer_1.VSCodeTokenizer((text3, token2) => tokenizerMetadata.countTokens(text3, token2), mode) : tokenizerMetadata;
      const renderer = new promptRenderer_1.PromptRenderer(endpoint, ctor, props, tokenizer);
      const renderResult = await renderer.render(progress, token);
      const usedContext = renderer.getUsedContext();
      return { ...renderResult, usedContext };
    }
    exports2.contentType = "application/vnd.codechat.prompt+json.1";
    function renderElementJSON(ctor, props, budgetInformation, token) {
      const renderer = new promptRenderer_1.PromptRenderer(
        { modelMaxPromptTokens: budgetInformation?.tokenBudget ?? Number.MAX_SAFE_INTEGER },
        ctor,
        props,
        // note: if tokenBudget is given, countTokens is also give and vise-versa.
        // `1` is used only as a dummy fallback to avoid errors if no/unlimited budget is provided.
        {
          mode: mode_1.OutputMode.Raw,
          countMessageTokens(message) {
            throw new Error("Tools may only return text, not messages.");
          },
          tokenLength(part, token2) {
            if (part.type === mode_1.Raw.ChatCompletionContentPartKind.Text) {
              return Promise.resolve(budgetInformation?.countTokens(part.text, token2) ?? Promise.resolve(1));
            }
            return Promise.resolve(1);
          }
        }
      );
      return renderer.renderElementJSON(token);
    }
  }
});

// node_modules/@microsoft/tiktokenizer/dist/bytePairEncode.js
var require_bytePairEncode = __commonJS({
  "node_modules/@microsoft/tiktokenizer/dist/bytePairEncode.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.bytePairEncode = exports2.BinaryMap = exports2.binaryMapKey = void 0;
    var binaryMapKey = (k, start2, end) => {
      const length = end - start2;
      const lowerMask = 16777215 >>> Math.max(0, (3 - length) * 8);
      const lower = (k[start2 + 0] | k[start2 + 1] << 8 | k[start2 + 2] << 16) & lowerMask;
      const upperMask = 16777215 >>> Math.min(31, Math.max(0, (6 - length) * 8));
      const upper = (k[start2 + 3] | k[start2 + 4] << 8 | k[start2 + 5] << 16) & upperMask;
      return lower + 16777216 * upper;
    };
    exports2.binaryMapKey = binaryMapKey;
    var BinaryMap = class _BinaryMap {
      constructor() {
        this.nested = /* @__PURE__ */ new Map();
        this.final = /* @__PURE__ */ new Map();
      }
      get(key, start2 = 0, end = key.length) {
        const isFinal = end < 6 + start2;
        const mapKey = (0, exports2.binaryMapKey)(key, start2, end);
        if (isFinal) {
          return this.final.get(mapKey);
        }
        return this.nested.get(mapKey)?.get(key, 6 + start2, end);
      }
      set(key, value) {
        const k = (0, exports2.binaryMapKey)(key, 0, key.length);
        const isFinal = key.length < 6;
        if (isFinal) {
          this.final.set(k, value);
          return;
        }
        const existing = this.nested.get(k);
        if (existing instanceof _BinaryMap) {
          existing.set(key.subarray(
            6
            /* Constant.BytesPerLevel */
          ), value);
        } else {
          const newMap = new _BinaryMap();
          newMap.set(key.subarray(
            6
            /* Constant.BytesPerLevel */
          ), value);
          this.nested.set(k, newMap);
        }
      }
    };
    exports2.BinaryMap = BinaryMap;
    var ranksBuf = new Int32Array(128);
    var indicesBuf = new Int32Array(128);
    function bytePairEncode(mergingBytes, ranks, length) {
      if (length === 1) {
        return [ranks.get(mergingBytes)];
      }
      let minRank = 2147483647;
      let minIndex = -1;
      while (ranksBuf.length < length * 2) {
        indicesBuf = new Int32Array(indicesBuf.length * 2);
        ranksBuf = new Int32Array(ranksBuf.length * 2);
      }
      for (let i2 = 0; i2 < length - 1; i2++) {
        const rank = ranks.get(mergingBytes, i2, i2 + 2) ?? 2147483647;
        if (rank < minRank) {
          minRank = rank;
          minIndex = i2;
        }
        indicesBuf[i2] = i2;
        ranksBuf[i2] = rank;
      }
      indicesBuf[length - 1] = length - 1;
      ranksBuf[length - 1] = 2147483647;
      indicesBuf[length] = length;
      ranksBuf[length] = 2147483647;
      let maxIndex = length + 1;
      function getRank(startIndex, skip = 0) {
        if (startIndex + skip + 2 < maxIndex) {
          const rank = ranks.get(mergingBytes, indicesBuf[startIndex], indicesBuf[startIndex + skip + 2]);
          if (rank !== void 0) {
            return rank;
          }
        }
        return 2147483647;
      }
      while (minRank !== 2147483647) {
        ranksBuf[indicesBuf[minIndex]] = getRank(minIndex, 1);
        if (minIndex > 0) {
          ranksBuf[indicesBuf[minIndex - 1]] = getRank(minIndex - 1, 1);
        }
        for (let i2 = minIndex + 1; i2 < maxIndex - 1; i2++) {
          indicesBuf[i2] = indicesBuf[i2 + 1];
        }
        maxIndex--;
        minIndex = -1;
        minRank = 2147483647;
        for (let i2 = 0; i2 < maxIndex - 1; i2++) {
          const rank = ranksBuf[indicesBuf[i2]];
          if (ranksBuf[indicesBuf[i2]] < minRank) {
            minRank = rank;
            minIndex = i2;
          }
        }
      }
      const outList = [];
      for (let i2 = 0; i2 < maxIndex - 1; i2++) {
        outList.push(ranks.get(mergingBytes, indicesBuf[i2], indicesBuf[i2 + 1]));
      }
      return outList;
    }
    exports2.bytePairEncode = bytePairEncode;
  }
});

// node_modules/@microsoft/tiktokenizer/dist/textEncoder.js
var require_textEncoder = __commonJS({
  "node_modules/@microsoft/tiktokenizer/dist/textEncoder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.makeTextEncoder = void 0;
    var UniversalTextEncoder = class {
      constructor() {
        this.length = 0;
        this.encoder = new TextEncoder();
      }
      encode(text3) {
        const arr = this.encoder.encode(text3);
        this.length = arr.length;
        return arr;
      }
    };
    var NodeTextEncoder = class {
      constructor() {
        this.buffer = Buffer.alloc(256);
        this.length = 0;
      }
      encode(text3) {
        while (true) {
          this.length = this.buffer.write(text3, "utf8");
          if (this.length < this.buffer.length - 4) {
            return this.buffer;
          }
          this.buffer = Buffer.alloc(this.length * 2);
          this.length = this.buffer.write(text3);
        }
      }
    };
    var makeTextEncoder = () => typeof Buffer !== "undefined" ? new NodeTextEncoder() : new UniversalTextEncoder();
    exports2.makeTextEncoder = makeTextEncoder;
  }
});

// node_modules/@microsoft/tiktokenizer/dist/lru.js
var require_lru = __commonJS({
  "node_modules/@microsoft/tiktokenizer/dist/lru.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LRUCache = void 0;
    var LRUCache4 = class {
      constructor(size) {
        this.size = size;
        this.nodes = /* @__PURE__ */ new Map();
      }
      get(key) {
        const node = this.nodes.get(key);
        if (node) {
          this.moveToHead(node);
          return node.value;
        }
        return void 0;
      }
      set(key, value) {
        const node = this.nodes.get(key);
        if (node) {
          node.value = value;
          this.moveToHead(node);
        } else {
          const newNode = new Node7(key, value);
          this.nodes.set(key, newNode);
          this.addNode(newNode);
          if (this.nodes.size > this.size) {
            this.nodes.delete(this.tail.key);
            this.removeNode(this.tail);
          }
        }
      }
      moveToHead(node) {
        this.removeNode(node);
        node.next = void 0;
        node.prev = void 0;
        this.addNode(node);
      }
      addNode(node) {
        if (this.head) {
          this.head.prev = node;
          node.next = this.head;
        }
        if (!this.tail) {
          this.tail = node;
        }
        this.head = node;
      }
      removeNode(node) {
        if (node.prev) {
          node.prev.next = node.next;
        } else {
          this.head = node.next;
        }
        if (node.next) {
          node.next.prev = node.prev;
        } else {
          this.tail = node.prev;
        }
      }
    };
    exports2.LRUCache = LRUCache4;
    var Node7 = class {
      constructor(key, value) {
        this.key = key;
        this.value = value;
      }
    };
  }
});

// node_modules/@microsoft/tiktokenizer/dist/tikTokenizer.js
var require_tikTokenizer = __commonJS({
  "node_modules/@microsoft/tiktokenizer/dist/tikTokenizer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TikTokenizer = void 0;
    var bytePairEncode_1 = require_bytePairEncode();
    var textEncoder_1 = require_textEncoder();
    var lru_1 = require_lru();
    function loadTikTokenBpe(tikTokenBpeFile) {
      const bpeDict = /* @__PURE__ */ new Map();
      try {
        const fs19 = require("fs");
        const fileContent = fs19.readFileSync(tikTokenBpeFile, "utf-8");
        processBpeRanks(fileContent);
        return bpeDict;
      } catch (ex) {
        throw new Error(`Failed to load from BPE encoder file stream: ${ex}`);
      }
      function processBpeRanks(fileContent) {
        for (const line of fileContent.split(/[\r\n]+/)) {
          if (line.trim() === "") {
            continue;
          }
          const tokens = line.split(" ");
          if (tokens.length !== 2) {
            throw new Error("Invalid format in the BPE encoder file stream");
          }
          const tokenBytes = new Uint8Array(Buffer.from(tokens[0], "base64"));
          const rank = parseInt(tokens[1]);
          if (!isNaN(rank)) {
            bpeDict.set(tokenBytes, rank);
          } else {
            throw new Error(`Can't parse ${tokens[1]} to integer`);
          }
        }
      }
    }
    function escapeRegExp(regex) {
      return regex.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    }
    var TikTokenizer2 = class {
      /**
       * Take the encoder tokens mapping from OpenAI tiktoken dump to build the encoder
       * For gpt-3.5-turbo/gpt4, you can download the BPE tokens mapping from:
       * https://openaipublic.blob.core.windows.net/encodings/cl100k_base.tiktoken
       * @param tikTokenBpeFileOrDict BPE rank file path or parsed dictionary
       * @param specialTokensEncoder special tokens encoder
       * @param regexPattern regex pattern to split the input text
       * @param cacheSize cache size
       */
      constructor(tikTokenBpeFileOrDict, specialTokensEncoder, regexPattern, cacheSize = 8192) {
        this.textEncoder = (0, textEncoder_1.makeTextEncoder)();
        this.textDecoder = new TextDecoder("utf-8");
        this.cache = new lru_1.LRUCache(cacheSize);
        const bpeDict = typeof tikTokenBpeFileOrDict === "string" ? loadTikTokenBpe(tikTokenBpeFileOrDict) : tikTokenBpeFileOrDict;
        this.init(bpeDict, specialTokensEncoder, regexPattern);
      }
      init(bpeDict, specialTokensEncoder, regexPattern) {
        this.encoder = new bytePairEncode_1.BinaryMap();
        for (const [key, value] of bpeDict) {
          this.encoder.set(key, value);
        }
        this.regex = new RegExp(regexPattern, "gu");
        this.specialTokensRegex = new RegExp(Array.from(specialTokensEncoder.keys()).map((s2) => escapeRegExp(s2)).join("|"));
        this.specialTokensEncoder = specialTokensEncoder;
        this.decoder = /* @__PURE__ */ new Map();
        for (const [key, value] of bpeDict) {
          this.decoder.set(value, key);
        }
        if (bpeDict.size !== this.decoder.size) {
          throw new Error("Encoder and decoder sizes do not match");
        }
        this.specialTokensDecoder = /* @__PURE__ */ new Map();
        for (const [key, value] of specialTokensEncoder) {
          this.specialTokensDecoder.set(value, key);
        }
      }
      findNextSpecialToken(text3, start2, allowedSpecial) {
        let startFind = start2;
        let nextSpecial = null;
        if (allowedSpecial && this.specialTokensRegex) {
          while (true) {
            nextSpecial = text3.slice(startFind).match(this.specialTokensRegex);
            if (!nextSpecial) {
              break;
            }
            if (allowedSpecial && allowedSpecial.includes(nextSpecial[0])) {
              break;
            }
            startFind += nextSpecial.index + 1;
          }
        }
        const end = nextSpecial ? startFind + nextSpecial.index : text3.length;
        return [nextSpecial, end];
      }
      /**
       * Encode a string with a set of allowed special tokens that are not broken apart.
       * @param text text to encode
       * @param allowedSpecial allowed special tokens
       * @returns number[] encoded token ids
       */
      encode(text3, allowedSpecial) {
        const tokenIds = [];
        let start2 = 0;
        while (true) {
          let nextSpecial;
          let end;
          [nextSpecial, end] = this.findNextSpecialToken(text3, start2, allowedSpecial);
          if (end > start2) {
            this.encodeByIndex(text3, tokenIds, start2, end);
          }
          if (nextSpecial) {
            start2 = start2 + this.encodeSpecialToken(tokenIds, nextSpecial);
            if (start2 >= text3.length) {
              break;
            }
          } else {
            break;
          }
        }
        return tokenIds;
      }
      encodeSpecialToken(tokenIds, nextSpecial) {
        const token = this.specialTokensEncoder?.get(nextSpecial[0]);
        tokenIds.push(token);
        return nextSpecial.index + nextSpecial[0].length;
      }
      encodeByIndex(text3, tokenIds, start2, end) {
        let match4;
        const substring = text3.substring(start2, end);
        this.regex.lastIndex = 0;
        while (match4 = this.regex.exec(substring)) {
          const cached = this.cache.get(match4[0]);
          if (cached) {
            for (const b of cached) {
              tokenIds.push(b);
            }
          } else {
            const bytes = this.textEncoder.encode(match4[0]);
            const token = this.encoder.get(bytes, 0, this.textEncoder.length);
            if (token !== void 0) {
              tokenIds.push(token);
              this.cache.set(match4[0], [token]);
            } else {
              const encodedTokens = (0, bytePairEncode_1.bytePairEncode)(bytes, this.encoder, this.textEncoder.length);
              for (const b of encodedTokens) {
                tokenIds.push(b);
              }
              this.cache.set(match4[0], encodedTokens);
            }
          }
        }
      }
      encodeTrimSuffixByIndex(text3, tokenIds, start2, end, maxTokenCount, tokenCount, encodeLength) {
        let match4;
        const substring = text3.substring(start2, end);
        this.regex.lastIndex = 0;
        while (match4 = this.regex.exec(substring)) {
          const piece = match4[0];
          const cachedTokens = this.cache.get(piece);
          if (cachedTokens) {
            if (tokenCount + cachedTokens.length <= maxTokenCount) {
              tokenCount += cachedTokens.length;
              encodeLength += piece.length;
              tokenIds.push(...cachedTokens);
            } else {
              let remainingTokens = maxTokenCount - tokenCount;
              tokenCount += remainingTokens;
              encodeLength += piece.length;
              tokenIds.push(...cachedTokens.slice(0, remainingTokens));
              break;
            }
          } else {
            const bytes = this.textEncoder.encode(piece);
            const token = this.encoder.get(bytes, 0, bytes.length);
            if (token !== void 0) {
              this.cache.set(piece, [token]);
              if (tokenCount + 1 <= maxTokenCount) {
                tokenCount++;
                encodeLength += piece.length;
                tokenIds.push(token);
              } else {
                break;
              }
            } else {
              const encodedTokens = (0, bytePairEncode_1.bytePairEncode)(bytes, this.encoder, this.textEncoder.length);
              this.cache.set(piece, encodedTokens);
              if (tokenCount + encodedTokens.length <= maxTokenCount) {
                tokenCount += encodedTokens.length;
                encodeLength += piece.length;
                for (const b of encodedTokens) {
                  tokenIds.push(b);
                }
              } else {
                let remainingTokens = maxTokenCount - tokenCount;
                tokenCount += remainingTokens;
                encodeLength += piece.length;
                for (let i2 = 0; i2 < remainingTokens; i2++) {
                  tokenIds.push(encodedTokens[i2]);
                }
                break;
              }
            }
          }
          if (tokenCount >= maxTokenCount) {
            break;
          }
        }
        return { tokenCount, encodeLength };
      }
      /**
       * Encode a piece of text limited by max token count through trimming suffix
       * @param text text to encode
       * @param maxTokenCount max token count
       * @param allowedSpecial allowed special tokens
       * @returns { tokenIds: number[], text: string } encoded token ids and trimmed text
       */
      encodeTrimSuffix(text3, maxTokenCount, allowedSpecial) {
        const tokenIds = [];
        let start2 = 0;
        let tokenCount = 0;
        let encodeLength = 0;
        while (true) {
          let nextSpecial;
          let end;
          [nextSpecial, end] = this.findNextSpecialToken(text3, start2, allowedSpecial);
          if (end > start2) {
            const { tokenCount: newTokenCount, encodeLength: newEncodeLength } = this.encodeTrimSuffixByIndex(text3, tokenIds, start2, end, maxTokenCount, tokenCount, encodeLength);
            tokenCount = newTokenCount;
            encodeLength = newEncodeLength;
            if (tokenCount >= maxTokenCount) {
              break;
            }
          }
          if (nextSpecial !== null) {
            tokenCount++;
            if (tokenCount <= maxTokenCount) {
              start2 = start2 + this.encodeSpecialToken(tokenIds, nextSpecial);
              encodeLength += nextSpecial[0].length;
              if (start2 >= text3.length) {
                break;
              }
            }
            if (tokenCount >= maxTokenCount) {
              break;
            }
          } else {
            break;
          }
        }
        const encodedText = encodeLength === text3.length ? text3 : text3.slice(0, encodeLength);
        return { tokenIds, text: encodedText };
      }
      /**
       * Encode a piece of text limited by max token count through trimming prefix
       * @param text text to encode
       * @param maxTokenCount max token count
       * @param allowedSpecial allowed special tokens
       * @returns { tokenIds: number[], text: string } encoded token ids and trimmed text
       */
      encodeTrimPrefix(text3, maxTokenCount, allowedSpecial) {
        const tokenIds = [];
        let start2 = 0;
        let tokenCount = 0;
        let encodeLength = 0;
        const tokenCountMap = /* @__PURE__ */ new Map();
        tokenCountMap.set(tokenCount, encodeLength);
        while (true) {
          let nextSpecial;
          let end;
          [nextSpecial, end] = this.findNextSpecialToken(text3, start2, allowedSpecial);
          if (end > start2) {
            let match4;
            const substring = text3.substring(start2, end);
            this.regex.lastIndex = 0;
            while (match4 = this.regex.exec(substring)) {
              const piece = match4[0];
              const cachedTokens = this.cache.get(piece);
              if (cachedTokens) {
                tokenCount += cachedTokens.length;
                encodeLength += piece.length;
                tokenIds.push(...cachedTokens);
                tokenCountMap.set(tokenCount, encodeLength);
              } else {
                const bytes = this.textEncoder.encode(piece);
                const token = this.encoder.get(bytes);
                if (token !== void 0) {
                  this.cache.set(piece, [token]);
                  tokenCount++;
                  encodeLength += piece.length;
                  tokenIds.push(token);
                  tokenCountMap.set(tokenCount, encodeLength);
                } else {
                  const encodedTokens = (0, bytePairEncode_1.bytePairEncode)(bytes, this.encoder, this.textEncoder.length);
                  this.cache.set(piece, encodedTokens);
                  tokenCount += encodedTokens.length;
                  encodeLength += piece.length;
                  for (const b of encodedTokens) {
                    tokenIds.push(b);
                  }
                  tokenCountMap.set(tokenCount, encodeLength);
                }
              }
            }
          }
          if (nextSpecial !== null) {
            start2 = start2 + this.encodeSpecialToken(tokenIds, nextSpecial);
            tokenCount++;
            encodeLength += nextSpecial[0].length;
            tokenCountMap.set(tokenCount, encodeLength);
            if (start2 >= text3.length) {
              break;
            }
          } else {
            break;
          }
        }
        if (tokenCount <= maxTokenCount) {
          return { tokenIds, text: text3 };
        }
        const prefixTokenCount = tokenCount - maxTokenCount;
        let actualPrefixTokenCount = 0;
        let actualPrefixStrLength = 0;
        for (const [key, value] of tokenCountMap) {
          if (key >= prefixTokenCount) {
            actualPrefixTokenCount = key;
            actualPrefixStrLength = value;
            break;
          }
        }
        if (actualPrefixTokenCount > maxTokenCount) {
          const encodedTokens = this.encode(text3, allowedSpecial);
          const slicedTokens = encodedTokens.slice(encodedTokens.length - maxTokenCount);
          return {
            tokenIds: slicedTokens,
            text: this.decode(slicedTokens)
          };
        }
        return {
          tokenIds: tokenIds.slice(actualPrefixTokenCount),
          text: text3.slice(actualPrefixStrLength)
        };
      }
      /**
       * Decode an array of integer token ids
       * @param tokens array of integer token ids
       * @returns string decoded text
       */
      decode(tokens) {
        const decoded = [];
        for (const token of tokens) {
          let tokenBytes = [];
          const value = this.decoder?.get(token);
          if (value !== void 0) {
            tokenBytes = Array.from(value);
          } else {
            const specialTokenValue = this.specialTokensDecoder?.get(token);
            if (specialTokenValue !== void 0) {
              const bytes = this.textEncoder.encode(specialTokenValue);
              tokenBytes = Array.from(bytes.subarray(0, this.textEncoder.length));
            }
          }
          decoded.push(...tokenBytes);
        }
        return this.textDecoder.decode(new Uint8Array(decoded));
      }
    };
    exports2.TikTokenizer = TikTokenizer2;
  }
});

// node_modules/@microsoft/tiktokenizer/dist/tokenizerBuilder.js
var require_tokenizerBuilder = __commonJS({
  "node_modules/@microsoft/tiktokenizer/dist/tokenizerBuilder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createTokenizer = exports2.createByEncoderName = exports2.createByModelName = exports2.getRegexByModel = exports2.getRegexByEncoder = exports2.getSpecialTokensByModel = exports2.getSpecialTokensByEncoder = exports2.MODEL_TO_ENCODING = void 0;
    var tikTokenizer_1 = require_tikTokenizer();
    var MODEL_PREFIX_TO_ENCODING = /* @__PURE__ */ new Map([
      // chat
      ["gpt-4o-", "o200k_base"],
      ["gpt-4-", "cl100k_base"],
      ["gpt-3.5-turbo-", "cl100k_base"],
      ["gpt-35-turbo-", "cl100k_base"]
      // Azure deployment name
    ]);
    exports2.MODEL_TO_ENCODING = /* @__PURE__ */ new Map([
      // chat
      ["gpt-4o", "o200k_base"],
      ["gpt-4", "cl100k_base"],
      ["gpt-3.5-turbo", "cl100k_base"],
      // text
      ["text-davinci-003", "p50k_base"],
      ["text-davinci-002", "p50k_base"],
      ["text-davinci-001", "r50k_base"],
      ["text-curie-001", "r50k_base"],
      ["text-babbage-001", "r50k_base"],
      ["text-ada-001", "r50k_base"],
      ["davinci", "r50k_base"],
      ["curie", "r50k_base"],
      ["babbage", "r50k_base"],
      ["ada", "r50k_base"],
      // code
      ["code-davinci-002", "p50k_base"],
      ["code-davinci-001", "p50k_base"],
      ["code-cushman-002", "p50k_base"],
      ["code-cushman-001", "p50k_base"],
      ["davinci-codex", "p50k_base"],
      ["cushman-codex", "p50k_base"],
      // edit
      ["text-davinci-edit-001", "p50k_edit"],
      ["code-davinci-edit-001", "p50k_edit"],
      // embeddings
      ["text-embedding-ada-002", "cl100k_base"],
      // old embeddings
      ["text-similarity-davinci-001", "r50k_base"],
      ["text-similarity-curie-001", "r50k_base"],
      ["text-similarity-babbage-001", "r50k_base"],
      ["text-similarity-ada-001", "r50k_base"],
      ["text-search-davinci-doc-001", "r50k_base"],
      ["text-search-curie-doc-001", "r50k_base"],
      ["text-search-babbage-doc-001", "r50k_base"],
      ["text-search-ada-doc-001", "r50k_base"],
      ["code-search-babbage-code-001", "r50k_base"],
      ["code-search-ada-code-001", "r50k_base"],
      // open source
      ["gpt2", "gpt2"]
    ]);
    var ENDOFTEXT = "<|endoftext|>";
    var FIM_PREFIX = "<|fim_prefix|>";
    var FIM_MIDDLE = "<|fim_middle|>";
    var FIM_SUFFIX = "<|fim_suffix|>";
    var ENDOFPROMPT = "<|endofprompt|>";
    var REGEX_PATTERN_1 = "'s|'t|'re|'ve|'m|'ll|'d| ?\\p{L}+| ?\\p{N}+| ?[^\\s\\p{L}\\p{N}]+|\\s+(?!\\S)|\\s+";
    var REGEX_PATTERN_2 = "(?:'s|'S|'t|'T|'re|'RE|'Re|'eR|'ve|'VE|'vE|'Ve|'m|'M|'ll|'lL|'Ll|'LL|'d|'D)|[^\\r\\n\\p{L}\\p{N}]?\\p{L}+|\\p{N}{1,3}| ?[^\\s\\p{L}\\p{N}]+[\\r\\n]*|\\s*[\\r\\n]+|\\s+(?!\\S)|\\s+";
    var patterns = [
      `[^\r
\\p{L}\\p{N}]?[\\p{Lu}\\p{Lt}\\p{Lm}\\p{Lo}\\p{M}]*[\\p{Ll}\\p{Lm}\\p{Lo}\\p{M}]+(?:'s|'S|'t|'T|'re|'RE|'Re|'eR|'ve|'VE|'vE|'Ve|'m|'M|'ll|'lL|'Ll|'LL|'d|'D)?`,
      `[^\r
\\p{L}\\p{N}]?[\\p{Lu}\\p{Lt}\\p{Lm}\\p{Lo}\\p{M}]+[\\p{Ll}\\p{Lm}\\p{Lo}\\p{M}]*(?:'s|'S|'t|'T|'re|'RE|'Re|'eR|'ve|'VE|'vE|'Ve|'m|'M|'ll|'lL|'Ll|'LL|'d|'D)?`,
      `\\p{N}{1,3}`,
      ` ?[^\\s\\p{L}\\p{N}]+[\\r\\n/]*`,
      `\\s*[\\r\\n]+`,
      `\\s+(?!\\S)`,
      `\\s+`
    ];
    var REGEX_PATTERN_3 = patterns.join("|");
    function getEncoderFromModelName(modelName) {
      let encoder = "";
      if (!exports2.MODEL_TO_ENCODING.has(modelName)) {
        for (const [prefix, encoding] of MODEL_PREFIX_TO_ENCODING) {
          if (modelName.startsWith(prefix)) {
            encoder = encoding;
            break;
          }
        }
      } else {
        encoder = exports2.MODEL_TO_ENCODING.get(modelName);
      }
      return encoder;
    }
    async function fetchAndSaveFile(mergeableRanksFileUrl, filePath) {
      const fs19 = require("fs");
      const response = await fetch(mergeableRanksFileUrl);
      if (!response.ok) {
        throw new Error(`Failed to fetch file from ${mergeableRanksFileUrl}. Status code: ${response.status}`);
      }
      const text3 = await response.text();
      fs19.writeFileSync(filePath, text3);
    }
    function getSpecialTokensByEncoder2(encoder) {
      let specialTokens = /* @__PURE__ */ new Map([[ENDOFTEXT, 50256]]);
      switch (encoder) {
        case "o200k_base":
          specialTokens = /* @__PURE__ */ new Map([
            [ENDOFTEXT, 199999],
            [ENDOFPROMPT, 200018]
          ]);
          break;
        case "cl100k_base":
          specialTokens = /* @__PURE__ */ new Map([
            [ENDOFTEXT, 100257],
            [FIM_PREFIX, 100258],
            [FIM_MIDDLE, 100259],
            [FIM_SUFFIX, 100260],
            [ENDOFPROMPT, 100276]
          ]);
          break;
        case "p50k_edit":
          specialTokens = /* @__PURE__ */ new Map([
            [ENDOFTEXT, 50256],
            [FIM_PREFIX, 50281],
            [FIM_MIDDLE, 50282],
            [FIM_SUFFIX, 50283]
          ]);
          break;
        default:
          break;
      }
      return specialTokens;
    }
    exports2.getSpecialTokensByEncoder = getSpecialTokensByEncoder2;
    function getSpecialTokensByModel(modelName) {
      const encoderName = getEncoderFromModelName(modelName);
      const specialTokens = getSpecialTokensByEncoder2(encoderName);
      return specialTokens;
    }
    exports2.getSpecialTokensByModel = getSpecialTokensByModel;
    function getRegexByEncoder2(encoder) {
      switch (encoder) {
        case "o200k_base":
          return REGEX_PATTERN_3;
        case "cl100k_base":
          return REGEX_PATTERN_2;
        default:
          break;
      }
      return REGEX_PATTERN_1;
    }
    exports2.getRegexByEncoder = getRegexByEncoder2;
    function getRegexByModel(modelName) {
      const encoderName = getEncoderFromModelName(modelName);
      const regexPattern = getRegexByEncoder2(encoderName);
      return regexPattern;
    }
    exports2.getRegexByModel = getRegexByModel;
    async function createByModelName(modelName, extraSpecialTokens = null) {
      return createByEncoderName(getEncoderFromModelName(modelName), extraSpecialTokens);
    }
    exports2.createByModelName = createByModelName;
    async function createByEncoderName(encoderName, extraSpecialTokens = null) {
      let regexPattern;
      let mergeableRanksFileUrl;
      let specialTokens = getSpecialTokensByEncoder2(encoderName);
      switch (encoderName) {
        case "o200k_base":
          regexPattern = REGEX_PATTERN_3;
          mergeableRanksFileUrl = `https://openaipublic.blob.core.windows.net/encodings/o200k_base.tiktoken`;
          break;
        case "cl100k_base":
          regexPattern = REGEX_PATTERN_2;
          mergeableRanksFileUrl = `https://openaipublic.blob.core.windows.net/encodings/cl100k_base.tiktoken`;
          break;
        case "p50k_base":
          regexPattern = REGEX_PATTERN_1;
          mergeableRanksFileUrl = `https://openaipublic.blob.core.windows.net/encodings/p50k_base.tiktoken`;
          break;
        case "p50k_edit":
          regexPattern = REGEX_PATTERN_1;
          mergeableRanksFileUrl = `https://openaipublic.blob.core.windows.net/encodings/p50k_base.tiktoken`;
          break;
        case "r50k_base":
          regexPattern = REGEX_PATTERN_1;
          mergeableRanksFileUrl = `https://openaipublic.blob.core.windows.net/encodings/r50k_base.tiktoken`;
          break;
        case "gpt2":
          regexPattern = REGEX_PATTERN_1;
          mergeableRanksFileUrl = `https://raw.githubusercontent.com/microsoft/Tokenizer/main/model/gpt2.tiktoken`;
          break;
        default:
          throw new Error(`Doesn't support this encoder [${encoderName}]`);
      }
      if (extraSpecialTokens !== null) {
        specialTokens = new Map([...specialTokens, ...extraSpecialTokens]);
      }
      const fs19 = require("fs");
      const path15 = require("path");
      const fileName = path15.basename(mergeableRanksFileUrl);
      const dirPath = path15.resolve(__dirname, "..", "model");
      if (!fs19.existsSync(dirPath)) {
        fs19.mkdirSync(dirPath, { recursive: true });
      }
      const filePath = path15.resolve(dirPath, fileName);
      if (!fs19.existsSync(filePath)) {
        console.log(`Downloading file from ${mergeableRanksFileUrl}`);
        await fetchAndSaveFile(mergeableRanksFileUrl, filePath);
        console.log(`Saved file to ${filePath}`);
      }
      return createTokenizer2(filePath, specialTokens, regexPattern);
    }
    exports2.createByEncoderName = createByEncoderName;
    function createTokenizer2(tikTokenBpeFileOrDict, specialTokensEncoder, regexPattern, cacheSize = 8192) {
      const tikTokenizer = new tikTokenizer_1.TikTokenizer(tikTokenBpeFileOrDict, specialTokensEncoder, regexPattern, cacheSize);
      return tikTokenizer;
    }
    exports2.createTokenizer = createTokenizer2;
  }
});

// node_modules/@microsoft/tiktokenizer/dist/index.js
var require_dist = __commonJS({
  "node_modules/@microsoft/tiktokenizer/dist/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createTokenizer = exports2.createByEncoderName = exports2.createByModelName = exports2.getSpecialTokensByModel = exports2.getSpecialTokensByEncoder = exports2.getRegexByModel = exports2.getRegexByEncoder = exports2.MODEL_TO_ENCODING = exports2.TikTokenizer = void 0;
    var tikTokenizer_1 = require_tikTokenizer();
    Object.defineProperty(exports2, "TikTokenizer", { enumerable: true, get: function() {
      return tikTokenizer_1.TikTokenizer;
    } });
    var tokenizerBuilder_1 = require_tokenizerBuilder();
    Object.defineProperty(exports2, "MODEL_TO_ENCODING", { enumerable: true, get: function() {
      return tokenizerBuilder_1.MODEL_TO_ENCODING;
    } });
    Object.defineProperty(exports2, "getRegexByEncoder", { enumerable: true, get: function() {
      return tokenizerBuilder_1.getRegexByEncoder;
    } });
    Object.defineProperty(exports2, "getRegexByModel", { enumerable: true, get: function() {
      return tokenizerBuilder_1.getRegexByModel;
    } });
    Object.defineProperty(exports2, "getSpecialTokensByEncoder", { enumerable: true, get: function() {
      return tokenizerBuilder_1.getSpecialTokensByEncoder;
    } });
    Object.defineProperty(exports2, "getSpecialTokensByModel", { enumerable: true, get: function() {
      return tokenizerBuilder_1.getSpecialTokensByModel;
    } });
    Object.defineProperty(exports2, "createByModelName", { enumerable: true, get: function() {
      return tokenizerBuilder_1.createByModelName;
    } });
    Object.defineProperty(exports2, "createByEncoderName", { enumerable: true, get: function() {
      return tokenizerBuilder_1.createByEncoderName;
    } });
    Object.defineProperty(exports2, "createTokenizer", { enumerable: true, get: function() {
      return tokenizerBuilder_1.createTokenizer;
    } });
  }
});

// node_modules/ajv/dist/compile/codegen/code.js
var require_code = __commonJS({
  "node_modules/ajv/dist/compile/codegen/code.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.regexpCode = exports2.getEsmExportName = exports2.getProperty = exports2.safeStringify = exports2.stringify = exports2.strConcat = exports2.addCodeArg = exports2.str = exports2._ = exports2.nil = exports2._Code = exports2.Name = exports2.IDENTIFIER = exports2._CodeOrName = void 0;
    var _CodeOrName = class {
    };
    exports2._CodeOrName = _CodeOrName;
    exports2.IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
    var Name = class extends _CodeOrName {
      constructor(s2) {
        super();
        if (!exports2.IDENTIFIER.test(s2))
          throw new Error("CodeGen: name must be a valid identifier");
        this.str = s2;
      }
      toString() {
        return this.str;
      }
      emptyStr() {
        return false;
      }
      get names() {
        return { [this.str]: 1 };
      }
    };
    exports2.Name = Name;
    var _Code = class extends _CodeOrName {
      constructor(code3) {
        super();
        this._items = typeof code3 === "string" ? [code3] : code3;
      }
      toString() {
        return this.str;
      }
      emptyStr() {
        if (this._items.length > 1)
          return false;
        const item = this._items[0];
        return item === "" || item === '""';
      }
      get str() {
        var _a17;
        return (_a17 = this._str) !== null && _a17 !== void 0 ? _a17 : this._str = this._items.reduce((s2, c) => `${s2}${c}`, "");
      }
      get names() {
        var _a17;
        return (_a17 = this._names) !== null && _a17 !== void 0 ? _a17 : this._names = this._items.reduce((names, c) => {
          if (c instanceof Name)
            names[c.str] = (names[c.str] || 0) + 1;
          return names;
        }, {});
      }
    };
    exports2._Code = _Code;
    exports2.nil = new _Code("");
    function _(strs, ...args2) {
      const code3 = [strs[0]];
      let i2 = 0;
      while (i2 < args2.length) {
        addCodeArg(code3, args2[i2]);
        code3.push(strs[++i2]);
      }
      return new _Code(code3);
    }
    exports2._ = _;
    var plus = new _Code("+");
    function str(strs, ...args2) {
      const expr = [safeStringify2(strs[0])];
      let i2 = 0;
      while (i2 < args2.length) {
        expr.push(plus);
        addCodeArg(expr, args2[i2]);
        expr.push(plus, safeStringify2(strs[++i2]));
      }
      optimize(expr);
      return new _Code(expr);
    }
    exports2.str = str;
    function addCodeArg(code3, arg) {
      if (arg instanceof _Code)
        code3.push(...arg._items);
      else if (arg instanceof Name)
        code3.push(arg);
      else
        code3.push(interpolate(arg));
    }
    exports2.addCodeArg = addCodeArg;
    function optimize(expr) {
      let i2 = 1;
      while (i2 < expr.length - 1) {
        if (expr[i2] === plus) {
          const res = mergeExprItems(expr[i2 - 1], expr[i2 + 1]);
          if (res !== void 0) {
            expr.splice(i2 - 1, 3, res);
            continue;
          }
          expr[i2++] = "+";
        }
        i2++;
      }
    }
    function mergeExprItems(a, b) {
      if (b === '""')
        return a;
      if (a === '""')
        return b;
      if (typeof a == "string") {
        if (b instanceof Name || a[a.length - 1] !== '"')
          return;
        if (typeof b != "string")
          return `${a.slice(0, -1)}${b}"`;
        if (b[0] === '"')
          return a.slice(0, -1) + b.slice(1);
        return;
      }
      if (typeof b == "string" && b[0] === '"' && !(a instanceof Name))
        return `"${a}${b.slice(1)}`;
      return;
    }
    function strConcat(c1, c2) {
      return c2.emptyStr() ? c1 : c1.emptyStr() ? c2 : str`${c1}${c2}`;
    }
    exports2.strConcat = strConcat;
    function interpolate(x) {
      return typeof x == "number" || typeof x == "boolean" || x === null ? x : safeStringify2(Array.isArray(x) ? x.join(",") : x);
    }
    function stringify2(x) {
      return new _Code(safeStringify2(x));
    }
    exports2.stringify = stringify2;
    function safeStringify2(x) {
      return JSON.stringify(x).replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029");
    }
    exports2.safeStringify = safeStringify2;
    function getProperty(key) {
      return typeof key == "string" && exports2.IDENTIFIER.test(key) ? new _Code(`.${key}`) : _`[${key}]`;
    }
    exports2.getProperty = getProperty;
    function getEsmExportName(key) {
      if (typeof key == "string" && exports2.IDENTIFIER.test(key)) {
        return new _Code(`${key}`);
      }
      throw new Error(`CodeGen: invalid export name: ${key}, use explicit $id name mapping`);
    }
    exports2.getEsmExportName = getEsmExportName;
    function regexpCode(rx) {
      return new _Code(rx.toString());
    }
    exports2.regexpCode = regexpCode;
  }
});

// node_modules/ajv/dist/compile/codegen/scope.js
var require_scope = __commonJS({
  "node_modules/ajv/dist/compile/codegen/scope.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ValueScope = exports2.ValueScopeName = exports2.Scope = exports2.varKinds = exports2.UsedValueState = void 0;
    var code_1 = require_code();
    var ValueError = class extends Error {
      constructor(name3) {
        super(`CodeGen: "code" for ${name3} not defined`);
        this.value = name3.value;
      }
    };
    var UsedValueState;
    (function(UsedValueState2) {
      UsedValueState2[UsedValueState2["Started"] = 0] = "Started";
      UsedValueState2[UsedValueState2["Completed"] = 1] = "Completed";
    })(UsedValueState || (exports2.UsedValueState = UsedValueState = {}));
    exports2.varKinds = {
      const: new code_1.Name("const"),
      let: new code_1.Name("let"),
      var: new code_1.Name("var")
    };
    var Scope2 = class {
      constructor({ prefixes, parent } = {}) {
        this._names = {};
        this._prefixes = prefixes;
        this._parent = parent;
      }
      toName(nameOrPrefix) {
        return nameOrPrefix instanceof code_1.Name ? nameOrPrefix : this.name(nameOrPrefix);
      }
      name(prefix) {
        return new code_1.Name(this._newName(prefix));
      }
      _newName(prefix) {
        const ng = this._names[prefix] || this._nameGroup(prefix);
        return `${prefix}${ng.index++}`;
      }
      _nameGroup(prefix) {
        var _a17, _b4;
        if (((_b4 = (_a17 = this._parent) === null || _a17 === void 0 ? void 0 : _a17._prefixes) === null || _b4 === void 0 ? void 0 : _b4.has(prefix)) || this._prefixes && !this._prefixes.has(prefix)) {
          throw new Error(`CodeGen: prefix "${prefix}" is not allowed in this scope`);
        }
        return this._names[prefix] = { prefix, index: 0 };
      }
    };
    exports2.Scope = Scope2;
    var ValueScopeName = class extends code_1.Name {
      constructor(prefix, nameStr) {
        super(nameStr);
        this.prefix = prefix;
      }
      setValue(value, { property, itemIndex }) {
        this.value = value;
        this.scopePath = (0, code_1._)`.${new code_1.Name(property)}[${itemIndex}]`;
      }
    };
    exports2.ValueScopeName = ValueScopeName;
    var line = (0, code_1._)`\n`;
    var ValueScope = class extends Scope2 {
      constructor(opts) {
        super(opts);
        this._values = {};
        this._scope = opts.scope;
        this.opts = { ...opts, _n: opts.lines ? line : code_1.nil };
      }
      get() {
        return this._scope;
      }
      name(prefix) {
        return new ValueScopeName(prefix, this._newName(prefix));
      }
      value(nameOrPrefix, value) {
        var _a17;
        if (value.ref === void 0)
          throw new Error("CodeGen: ref must be passed in value");
        const name3 = this.toName(nameOrPrefix);
        const { prefix } = name3;
        const valueKey = (_a17 = value.key) !== null && _a17 !== void 0 ? _a17 : value.ref;
        let vs = this._values[prefix];
        if (vs) {
          const _name = vs.get(valueKey);
          if (_name)
            return _name;
        } else {
          vs = this._values[prefix] = /* @__PURE__ */ new Map();
        }
        vs.set(valueKey, name3);
        const s2 = this._scope[prefix] || (this._scope[prefix] = []);
        const itemIndex = s2.length;
        s2[itemIndex] = value.ref;
        name3.setValue(value, { property: prefix, itemIndex });
        return name3;
      }
      getValue(prefix, keyOrRef) {
        const vs = this._values[prefix];
        if (!vs)
          return;
        return vs.get(keyOrRef);
      }
      scopeRefs(scopeName, values = this._values) {
        return this._reduceValues(values, (name3) => {
          if (name3.scopePath === void 0)
            throw new Error(`CodeGen: name "${name3}" has no value`);
          return (0, code_1._)`${scopeName}${name3.scopePath}`;
        });
      }
      scopeCode(values = this._values, usedValues, getCode) {
        return this._reduceValues(values, (name3) => {
          if (name3.value === void 0)
            throw new Error(`CodeGen: name "${name3}" has no value`);
          return name3.value.code;
        }, usedValues, getCode);
      }
      _reduceValues(values, valueCode, usedValues = {}, getCode) {
        let code3 = code_1.nil;
        for (const prefix in values) {
          const vs = values[prefix];
          if (!vs)
            continue;
          const nameSet = usedValues[prefix] = usedValues[prefix] || /* @__PURE__ */ new Map();
          vs.forEach((name3) => {
            if (nameSet.has(name3))
              return;
            nameSet.set(name3, UsedValueState.Started);
            let c = valueCode(name3);
            if (c) {
              const def = this.opts.es5 ? exports2.varKinds.var : exports2.varKinds.const;
              code3 = (0, code_1._)`${code3}${def} ${name3} = ${c};${this.opts._n}`;
            } else if (c = getCode === null || getCode === void 0 ? void 0 : getCode(name3)) {
              code3 = (0, code_1._)`${code3}${c}${this.opts._n}`;
            } else {
              throw new ValueError(name3);
            }
            nameSet.set(name3, UsedValueState.Completed);
          });
        }
        return code3;
      }
    };
    exports2.ValueScope = ValueScope;
  }
});

// node_modules/ajv/dist/compile/codegen/index.js
var require_codegen = __commonJS({
  "node_modules/ajv/dist/compile/codegen/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.or = exports2.and = exports2.not = exports2.CodeGen = exports2.operators = exports2.varKinds = exports2.ValueScopeName = exports2.ValueScope = exports2.Scope = exports2.Name = exports2.regexpCode = exports2.stringify = exports2.getProperty = exports2.nil = exports2.strConcat = exports2.str = exports2._ = void 0;
    var code_1 = require_code();
    var scope_1 = require_scope();
    var code_2 = require_code();
    Object.defineProperty(exports2, "_", { enumerable: true, get: function() {
      return code_2._;
    } });
    Object.defineProperty(exports2, "str", { enumerable: true, get: function() {
      return code_2.str;
    } });
    Object.defineProperty(exports2, "strConcat", { enumerable: true, get: function() {
      return code_2.strConcat;
    } });
    Object.defineProperty(exports2, "nil", { enumerable: true, get: function() {
      return code_2.nil;
    } });
    Object.defineProperty(exports2, "getProperty", { enumerable: true, get: function() {
      return code_2.getProperty;
    } });
    Object.defineProperty(exports2, "stringify", { enumerable: true, get: function() {
      return code_2.stringify;
    } });
    Object.defineProperty(exports2, "regexpCode", { enumerable: true, get: function() {
      return code_2.regexpCode;
    } });
    Object.defineProperty(exports2, "Name", { enumerable: true, get: function() {
      return code_2.Name;
    } });
    var scope_2 = require_scope();
    Object.defineProperty(exports2, "Scope", { enumerable: true, get: function() {
      return scope_2.Scope;
    } });
    Object.defineProperty(exports2, "ValueScope", { enumerable: true, get: function() {
      return scope_2.ValueScope;
    } });
    Object.defineProperty(exports2, "ValueScopeName", { enumerable: true, get: function() {
      return scope_2.ValueScopeName;
    } });
    Object.defineProperty(exports2, "varKinds", { enumerable: true, get: function() {
      return scope_2.varKinds;
    } });
    exports2.operators = {
      GT: new code_1._Code(">"),
      GTE: new code_1._Code(">="),
      LT: new code_1._Code("<"),
      LTE: new code_1._Code("<="),
      EQ: new code_1._Code("==="),
      NEQ: new code_1._Code("!=="),
      NOT: new code_1._Code("!"),
      OR: new code_1._Code("||"),
      AND: new code_1._Code("&&"),
      ADD: new code_1._Code("+")
    };
    var Node7 = class {
      optimizeNodes() {
        return this;
      }
      optimizeNames(_names, _constants) {
        return this;
      }
    };
    var Def = class extends Node7 {
      constructor(varKind, name3, rhs) {
        super();
        this.varKind = varKind;
        this.name = name3;
        this.rhs = rhs;
      }
      render({ es5, _n }) {
        const varKind = es5 ? scope_1.varKinds.var : this.varKind;
        const rhs = this.rhs === void 0 ? "" : ` = ${this.rhs}`;
        return `${varKind} ${this.name}${rhs};` + _n;
      }
      optimizeNames(names, constants4) {
        if (!names[this.name.str])
          return;
        if (this.rhs)
          this.rhs = optimizeExpr(this.rhs, names, constants4);
        return this;
      }
      get names() {
        return this.rhs instanceof code_1._CodeOrName ? this.rhs.names : {};
      }
    };
    var Assign = class extends Node7 {
      constructor(lhs, rhs, sideEffects) {
        super();
        this.lhs = lhs;
        this.rhs = rhs;
        this.sideEffects = sideEffects;
      }
      render({ _n }) {
        return `${this.lhs} = ${this.rhs};` + _n;
      }
      optimizeNames(names, constants4) {
        if (this.lhs instanceof code_1.Name && !names[this.lhs.str] && !this.sideEffects)
          return;
        this.rhs = optimizeExpr(this.rhs, names, constants4);
        return this;
      }
      get names() {
        const names = this.lhs instanceof code_1.Name ? {} : { ...this.lhs.names };
        return addExprNames(names, this.rhs);
      }
    };
    var AssignOp = class extends Assign {
      constructor(lhs, op, rhs, sideEffects) {
        super(lhs, rhs, sideEffects);
        this.op = op;
      }
      render({ _n }) {
        return `${this.lhs} ${this.op}= ${this.rhs};` + _n;
      }
    };
    var Label = class extends Node7 {
      constructor(label) {
        super();
        this.label = label;
        this.names = {};
      }
      render({ _n }) {
        return `${this.label}:` + _n;
      }
    };
    var Break = class extends Node7 {
      constructor(label) {
        super();
        this.label = label;
        this.names = {};
      }
      render({ _n }) {
        const label = this.label ? ` ${this.label}` : "";
        return `break${label};` + _n;
      }
    };
    var Throw = class extends Node7 {
      constructor(error2) {
        super();
        this.error = error2;
      }
      render({ _n }) {
        return `throw ${this.error};` + _n;
      }
      get names() {
        return this.error.names;
      }
    };
    var AnyCode = class extends Node7 {
      constructor(code3) {
        super();
        this.code = code3;
      }
      render({ _n }) {
        return `${this.code};` + _n;
      }
      optimizeNodes() {
        return `${this.code}` ? this : void 0;
      }
      optimizeNames(names, constants4) {
        this.code = optimizeExpr(this.code, names, constants4);
        return this;
      }
      get names() {
        return this.code instanceof code_1._CodeOrName ? this.code.names : {};
      }
    };
    var ParentNode = class extends Node7 {
      constructor(nodes = []) {
        super();
        this.nodes = nodes;
      }
      render(opts) {
        return this.nodes.reduce((code3, n) => code3 + n.render(opts), "");
      }
      optimizeNodes() {
        const { nodes } = this;
        let i2 = nodes.length;
        while (i2--) {
          const n = nodes[i2].optimizeNodes();
          if (Array.isArray(n))
            nodes.splice(i2, 1, ...n);
          else if (n)
            nodes[i2] = n;
          else
            nodes.splice(i2, 1);
        }
        return nodes.length > 0 ? this : void 0;
      }
      optimizeNames(names, constants4) {
        const { nodes } = this;
        let i2 = nodes.length;
        while (i2--) {
          const n = nodes[i2];
          if (n.optimizeNames(names, constants4))
            continue;
          subtractNames(names, n.names);
          nodes.splice(i2, 1);
        }
        return nodes.length > 0 ? this : void 0;
      }
      get names() {
        return this.nodes.reduce((names, n) => addNames(names, n.names), {});
      }
    };
    var BlockNode = class extends ParentNode {
      render(opts) {
        return "{" + opts._n + super.render(opts) + "}" + opts._n;
      }
    };
    var Root = class extends ParentNode {
    };
    var Else = class extends BlockNode {
    };
    Else.kind = "else";
    var If = class _If extends BlockNode {
      constructor(condition, nodes) {
        super(nodes);
        this.condition = condition;
      }
      render(opts) {
        let code3 = `if(${this.condition})` + super.render(opts);
        if (this.else)
          code3 += "else " + this.else.render(opts);
        return code3;
      }
      optimizeNodes() {
        super.optimizeNodes();
        const cond = this.condition;
        if (cond === true)
          return this.nodes;
        let e = this.else;
        if (e) {
          const ns = e.optimizeNodes();
          e = this.else = Array.isArray(ns) ? new Else(ns) : ns;
        }
        if (e) {
          if (cond === false)
            return e instanceof _If ? e : e.nodes;
          if (this.nodes.length)
            return this;
          return new _If(not(cond), e instanceof _If ? [e] : e.nodes);
        }
        if (cond === false || !this.nodes.length)
          return void 0;
        return this;
      }
      optimizeNames(names, constants4) {
        var _a17;
        this.else = (_a17 = this.else) === null || _a17 === void 0 ? void 0 : _a17.optimizeNames(names, constants4);
        if (!(super.optimizeNames(names, constants4) || this.else))
          return;
        this.condition = optimizeExpr(this.condition, names, constants4);
        return this;
      }
      get names() {
        const names = super.names;
        addExprNames(names, this.condition);
        if (this.else)
          addNames(names, this.else.names);
        return names;
      }
    };
    If.kind = "if";
    var For = class extends BlockNode {
    };
    For.kind = "for";
    var ForLoop = class extends For {
      constructor(iteration) {
        super();
        this.iteration = iteration;
      }
      render(opts) {
        return `for(${this.iteration})` + super.render(opts);
      }
      optimizeNames(names, constants4) {
        if (!super.optimizeNames(names, constants4))
          return;
        this.iteration = optimizeExpr(this.iteration, names, constants4);
        return this;
      }
      get names() {
        return addNames(super.names, this.iteration.names);
      }
    };
    var ForRange = class extends For {
      constructor(varKind, name3, from, to) {
        super();
        this.varKind = varKind;
        this.name = name3;
        this.from = from;
        this.to = to;
      }
      render(opts) {
        const varKind = opts.es5 ? scope_1.varKinds.var : this.varKind;
        const { name: name3, from, to } = this;
        return `for(${varKind} ${name3}=${from}; ${name3}<${to}; ${name3}++)` + super.render(opts);
      }
      get names() {
        const names = addExprNames(super.names, this.from);
        return addExprNames(names, this.to);
      }
    };
    var ForIter = class extends For {
      constructor(loop, varKind, name3, iterable) {
        super();
        this.loop = loop;
        this.varKind = varKind;
        this.name = name3;
        this.iterable = iterable;
      }
      render(opts) {
        return `for(${this.varKind} ${this.name} ${this.loop} ${this.iterable})` + super.render(opts);
      }
      optimizeNames(names, constants4) {
        if (!super.optimizeNames(names, constants4))
          return;
        this.iterable = optimizeExpr(this.iterable, names, constants4);
        return this;
      }
      get names() {
        return addNames(super.names, this.iterable.names);
      }
    };
    var Func = class extends BlockNode {
      constructor(name3, args2, async) {
        super();
        this.name = name3;
        this.args = args2;
        this.async = async;
      }
      render(opts) {
        const _async = this.async ? "async " : "";
        return `${_async}function ${this.name}(${this.args})` + super.render(opts);
      }
    };
    Func.kind = "func";
    var Return = class extends ParentNode {
      render(opts) {
        return "return " + super.render(opts);
      }
    };
    Return.kind = "return";
    var Try = class extends BlockNode {
      render(opts) {
        let code3 = "try" + super.render(opts);
        if (this.catch)
          code3 += this.catch.render(opts);
        if (this.finally)
          code3 += this.finally.render(opts);
        return code3;
      }
      optimizeNodes() {
        var _a17, _b4;
        super.optimizeNodes();
        (_a17 = this.catch) === null || _a17 === void 0 ? void 0 : _a17.optimizeNodes();
        (_b4 = this.finally) === null || _b4 === void 0 ? void 0 : _b4.optimizeNodes();
        return this;
      }
      optimizeNames(names, constants4) {
        var _a17, _b4;
        super.optimizeNames(names, constants4);
        (_a17 = this.catch) === null || _a17 === void 0 ? void 0 : _a17.optimizeNames(names, constants4);
        (_b4 = this.finally) === null || _b4 === void 0 ? void 0 : _b4.optimizeNames(names, constants4);
        return this;
      }
      get names() {
        const names = super.names;
        if (this.catch)
          addNames(names, this.catch.names);
        if (this.finally)
          addNames(names, this.finally.names);
        return names;
      }
    };
    var Catch = class extends BlockNode {
      constructor(error2) {
        super();
        this.error = error2;
      }
      render(opts) {
        return `catch(${this.error})` + super.render(opts);
      }
    };
    Catch.kind = "catch";
    var Finally = class extends BlockNode {
      render(opts) {
        return "finally" + super.render(opts);
      }
    };
    Finally.kind = "finally";
    var CodeGen = class {
      constructor(extScope, opts = {}) {
        this._values = {};
        this._blockStarts = [];
        this._constants = {};
        this.opts = { ...opts, _n: opts.lines ? "\n" : "" };
        this._extScope = extScope;
        this._scope = new scope_1.Scope({ parent: extScope });
        this._nodes = [new Root()];
      }
      toString() {
        return this._root.render(this.opts);
      }
      // returns unique name in the internal scope
      name(prefix) {
        return this._scope.name(prefix);
      }
      // reserves unique name in the external scope
      scopeName(prefix) {
        return this._extScope.name(prefix);
      }
      // reserves unique name in the external scope and assigns value to it
      scopeValue(prefixOrName, value) {
        const name3 = this._extScope.value(prefixOrName, value);
        const vs = this._values[name3.prefix] || (this._values[name3.prefix] = /* @__PURE__ */ new Set());
        vs.add(name3);
        return name3;
      }
      getScopeValue(prefix, keyOrRef) {
        return this._extScope.getValue(prefix, keyOrRef);
      }
      // return code that assigns values in the external scope to the names that are used internally
      // (same names that were returned by gen.scopeName or gen.scopeValue)
      scopeRefs(scopeName) {
        return this._extScope.scopeRefs(scopeName, this._values);
      }
      scopeCode() {
        return this._extScope.scopeCode(this._values);
      }
      _def(varKind, nameOrPrefix, rhs, constant) {
        const name3 = this._scope.toName(nameOrPrefix);
        if (rhs !== void 0 && constant)
          this._constants[name3.str] = rhs;
        this._leafNode(new Def(varKind, name3, rhs));
        return name3;
      }
      // `const` declaration (`var` in es5 mode)
      const(nameOrPrefix, rhs, _constant) {
        return this._def(scope_1.varKinds.const, nameOrPrefix, rhs, _constant);
      }
      // `let` declaration with optional assignment (`var` in es5 mode)
      let(nameOrPrefix, rhs, _constant) {
        return this._def(scope_1.varKinds.let, nameOrPrefix, rhs, _constant);
      }
      // `var` declaration with optional assignment
      var(nameOrPrefix, rhs, _constant) {
        return this._def(scope_1.varKinds.var, nameOrPrefix, rhs, _constant);
      }
      // assignment code
      assign(lhs, rhs, sideEffects) {
        return this._leafNode(new Assign(lhs, rhs, sideEffects));
      }
      // `+=` code
      add(lhs, rhs) {
        return this._leafNode(new AssignOp(lhs, exports2.operators.ADD, rhs));
      }
      // appends passed SafeExpr to code or executes Block
      code(c) {
        if (typeof c == "function")
          c();
        else if (c !== code_1.nil)
          this._leafNode(new AnyCode(c));
        return this;
      }
      // returns code for object literal for the passed argument list of key-value pairs
      object(...keyValues) {
        const code3 = ["{"];
        for (const [key, value] of keyValues) {
          if (code3.length > 1)
            code3.push(",");
          code3.push(key);
          if (key !== value || this.opts.es5) {
            code3.push(":");
            (0, code_1.addCodeArg)(code3, value);
          }
        }
        code3.push("}");
        return new code_1._Code(code3);
      }
      // `if` clause (or statement if `thenBody` and, optionally, `elseBody` are passed)
      if(condition, thenBody, elseBody) {
        this._blockNode(new If(condition));
        if (thenBody && elseBody) {
          this.code(thenBody).else().code(elseBody).endIf();
        } else if (thenBody) {
          this.code(thenBody).endIf();
        } else if (elseBody) {
          throw new Error('CodeGen: "else" body without "then" body');
        }
        return this;
      }
      // `else if` clause - invalid without `if` or after `else` clauses
      elseIf(condition) {
        return this._elseNode(new If(condition));
      }
      // `else` clause - only valid after `if` or `else if` clauses
      else() {
        return this._elseNode(new Else());
      }
      // end `if` statement (needed if gen.if was used only with condition)
      endIf() {
        return this._endBlockNode(If, Else);
      }
      _for(node, forBody) {
        this._blockNode(node);
        if (forBody)
          this.code(forBody).endFor();
        return this;
      }
      // a generic `for` clause (or statement if `forBody` is passed)
      for(iteration, forBody) {
        return this._for(new ForLoop(iteration), forBody);
      }
      // `for` statement for a range of values
      forRange(nameOrPrefix, from, to, forBody, varKind = this.opts.es5 ? scope_1.varKinds.var : scope_1.varKinds.let) {
        const name3 = this._scope.toName(nameOrPrefix);
        return this._for(new ForRange(varKind, name3, from, to), () => forBody(name3));
      }
      // `for-of` statement (in es5 mode replace with a normal for loop)
      forOf(nameOrPrefix, iterable, forBody, varKind = scope_1.varKinds.const) {
        const name3 = this._scope.toName(nameOrPrefix);
        if (this.opts.es5) {
          const arr = iterable instanceof code_1.Name ? iterable : this.var("_arr", iterable);
          return this.forRange("_i", 0, (0, code_1._)`${arr}.length`, (i2) => {
            this.var(name3, (0, code_1._)`${arr}[${i2}]`);
            forBody(name3);
          });
        }
        return this._for(new ForIter("of", varKind, name3, iterable), () => forBody(name3));
      }
      // `for-in` statement.
      // With option `ownProperties` replaced with a `for-of` loop for object keys
      forIn(nameOrPrefix, obj, forBody, varKind = this.opts.es5 ? scope_1.varKinds.var : scope_1.varKinds.const) {
        if (this.opts.ownProperties) {
          return this.forOf(nameOrPrefix, (0, code_1._)`Object.keys(${obj})`, forBody);
        }
        const name3 = this._scope.toName(nameOrPrefix);
        return this._for(new ForIter("in", varKind, name3, obj), () => forBody(name3));
      }
      // end `for` loop
      endFor() {
        return this._endBlockNode(For);
      }
      // `label` statement
      label(label) {
        return this._leafNode(new Label(label));
      }
      // `break` statement
      break(label) {
        return this._leafNode(new Break(label));
      }
      // `return` statement
      return(value) {
        const node = new Return();
        this._blockNode(node);
        this.code(value);
        if (node.nodes.length !== 1)
          throw new Error('CodeGen: "return" should have one node');
        return this._endBlockNode(Return);
      }
      // `try` statement
      try(tryBody, catchCode, finallyCode) {
        if (!catchCode && !finallyCode)
          throw new Error('CodeGen: "try" without "catch" and "finally"');
        const node = new Try();
        this._blockNode(node);
        this.code(tryBody);
        if (catchCode) {
          const error2 = this.name("e");
          this._currNode = node.catch = new Catch(error2);
          catchCode(error2);
        }
        if (finallyCode) {
          this._currNode = node.finally = new Finally();
          this.code(finallyCode);
        }
        return this._endBlockNode(Catch, Finally);
      }
      // `throw` statement
      throw(error2) {
        return this._leafNode(new Throw(error2));
      }
      // start self-balancing block
      block(body2, nodeCount) {
        this._blockStarts.push(this._nodes.length);
        if (body2)
          this.code(body2).endBlock(nodeCount);
        return this;
      }
      // end the current self-balancing block
      endBlock(nodeCount) {
        const len = this._blockStarts.pop();
        if (len === void 0)
          throw new Error("CodeGen: not in self-balancing block");
        const toClose = this._nodes.length - len;
        if (toClose < 0 || nodeCount !== void 0 && toClose !== nodeCount) {
          throw new Error(`CodeGen: wrong number of nodes: ${toClose} vs ${nodeCount} expected`);
        }
        this._nodes.length = len;
        return this;
      }
      // `function` heading (or definition if funcBody is passed)
      func(name3, args2 = code_1.nil, async, funcBody) {
        this._blockNode(new Func(name3, args2, async));
        if (funcBody)
          this.code(funcBody).endFunc();
        return this;
      }
      // end function definition
      endFunc() {
        return this._endBlockNode(Func);
      }
      optimize(n = 1) {
        while (n-- > 0) {
          this._root.optimizeNodes();
          this._root.optimizeNames(this._root.names, this._constants);
        }
      }
      _leafNode(node) {
        this._currNode.nodes.push(node);
        return this;
      }
      _blockNode(node) {
        this._currNode.nodes.push(node);
        this._nodes.push(node);
      }
      _endBlockNode(N1, N2) {
        const n = this._currNode;
        if (n instanceof N1 || N2 && n instanceof N2) {
          this._nodes.pop();
          return this;
        }
        throw new Error(`CodeGen: not in block "${N2 ? `${N1.kind}/${N2.kind}` : N1.kind}"`);
      }
      _elseNode(node) {
        const n = this._currNode;
        if (!(n instanceof If)) {
          throw new Error('CodeGen: "else" without "if"');
        }
        this._currNode = n.else = node;
        return this;
      }
      get _root() {
        return this._nodes[0];
      }
      get _currNode() {
        const ns = this._nodes;
        return ns[ns.length - 1];
      }
      set _currNode(node) {
        const ns = this._nodes;
        ns[ns.length - 1] = node;
      }
    };
    exports2.CodeGen = CodeGen;
    function addNames(names, from) {
      for (const n in from)
        names[n] = (names[n] || 0) + (from[n] || 0);
      return names;
    }
    function addExprNames(names, from) {
      return from instanceof code_1._CodeOrName ? addNames(names, from.names) : names;
    }
    function optimizeExpr(expr, names, constants4) {
      if (expr instanceof code_1.Name)
        return replaceName(expr);
      if (!canOptimize(expr))
        return expr;
      return new code_1._Code(expr._items.reduce((items, c) => {
        if (c instanceof code_1.Name)
          c = replaceName(c);
        if (c instanceof code_1._Code)
          items.push(...c._items);
        else
          items.push(c);
        return items;
      }, []));
      function replaceName(n) {
        const c = constants4[n.str];
        if (c === void 0 || names[n.str] !== 1)
          return n;
        delete names[n.str];
        return c;
      }
      function canOptimize(e) {
        return e instanceof code_1._Code && e._items.some((c) => c instanceof code_1.Name && names[c.str] === 1 && constants4[c.str] !== void 0);
      }
    }
    function subtractNames(names, from) {
      for (const n in from)
        names[n] = (names[n] || 0) - (from[n] || 0);
    }
    function not(x) {
      return typeof x == "boolean" || typeof x == "number" || x === null ? !x : (0, code_1._)`!${par(x)}`;
    }
    exports2.not = not;
    var andCode = mappend(exports2.operators.AND);
    function and(...args2) {
      return args2.reduce(andCode);
    }
    exports2.and = and;
    var orCode = mappend(exports2.operators.OR);
    function or2(...args2) {
      return args2.reduce(orCode);
    }
    exports2.or = or2;
    function mappend(op) {
      return (x, y2) => x === code_1.nil ? y2 : y2 === code_1.nil ? x : (0, code_1._)`${par(x)} ${op} ${par(y2)}`;
    }
    function par(x) {
      return x instanceof code_1.Name ? x : (0, code_1._)`(${x})`;
    }
  }
});

// node_modules/ajv/dist/compile/util.js
var require_util = __commonJS({
  "node_modules/ajv/dist/compile/util.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.checkStrictMode = exports2.getErrorPath = exports2.Type = exports2.useFunc = exports2.setEvaluated = exports2.evaluatedPropsToName = exports2.mergeEvaluated = exports2.eachItem = exports2.unescapeJsonPointer = exports2.escapeJsonPointer = exports2.escapeFragment = exports2.unescapeFragment = exports2.schemaRefOrVal = exports2.schemaHasRulesButRef = exports2.schemaHasRules = exports2.checkUnknownRules = exports2.alwaysValidSchema = exports2.toHash = void 0;
    var codegen_1 = require_codegen();
    var code_1 = require_code();
    function toHash(arr) {
      const hash2 = {};
      for (const item of arr)
        hash2[item] = true;
      return hash2;
    }
    exports2.toHash = toHash;
    function alwaysValidSchema(it, schema) {
      if (typeof schema == "boolean")
        return schema;
      if (Object.keys(schema).length === 0)
        return true;
      checkUnknownRules(it, schema);
      return !schemaHasRules(schema, it.self.RULES.all);
    }
    exports2.alwaysValidSchema = alwaysValidSchema;
    function checkUnknownRules(it, schema = it.schema) {
      const { opts, self: self2 } = it;
      if (!opts.strictSchema)
        return;
      if (typeof schema === "boolean")
        return;
      const rules = self2.RULES.keywords;
      for (const key in schema) {
        if (!rules[key])
          checkStrictMode(it, `unknown keyword: "${key}"`);
      }
    }
    exports2.checkUnknownRules = checkUnknownRules;
    function schemaHasRules(schema, rules) {
      if (typeof schema == "boolean")
        return !schema;
      for (const key in schema)
        if (rules[key])
          return true;
      return false;
    }
    exports2.schemaHasRules = schemaHasRules;
    function schemaHasRulesButRef(schema, RULES) {
      if (typeof schema == "boolean")
        return !schema;
      for (const key in schema)
        if (key !== "$ref" && RULES.all[key])
          return true;
      return false;
    }
    exports2.schemaHasRulesButRef = schemaHasRulesButRef;
    function schemaRefOrVal({ topSchemaRef, schemaPath }, schema, keyword, $data) {
      if (!$data) {
        if (typeof schema == "number" || typeof schema == "boolean")
          return schema;
        if (typeof schema == "string")
          return (0, codegen_1._)`${schema}`;
      }
      return (0, codegen_1._)`${topSchemaRef}${schemaPath}${(0, codegen_1.getProperty)(keyword)}`;
    }
    exports2.schemaRefOrVal = schemaRefOrVal;
    function unescapeFragment(str) {
      return unescapeJsonPointer(decodeURIComponent(str));
    }
    exports2.unescapeFragment = unescapeFragment;
    function escapeFragment(str) {
      return encodeURIComponent(escapeJsonPointer(str));
    }
    exports2.escapeFragment = escapeFragment;
    function escapeJsonPointer(str) {
      if (typeof str == "number")
        return `${str}`;
      return str.replace(/~/g, "~0").replace(/\//g, "~1");
    }
    exports2.escapeJsonPointer = escapeJsonPointer;
    function unescapeJsonPointer(str) {
      return str.replace(/~1/g, "/").replace(/~0/g, "~");
    }
    exports2.unescapeJsonPointer = unescapeJsonPointer;
    function eachItem(xs, f2) {
      if (Array.isArray(xs)) {
        for (const x of xs)
          f2(x);
      } else {
        f2(xs);
      }
    }
    exports2.eachItem = eachItem;
    function makeMergeEvaluated({ mergeNames, mergeToName, mergeValues: mergeValues2, resultToName }) {
      return (gen, from, to, toName) => {
        const res = to === void 0 ? from : to instanceof codegen_1.Name ? (from instanceof codegen_1.Name ? mergeNames(gen, from, to) : mergeToName(gen, from, to), to) : from instanceof codegen_1.Name ? (mergeToName(gen, to, from), from) : mergeValues2(from, to);
        return toName === codegen_1.Name && !(res instanceof codegen_1.Name) ? resultToName(gen, res) : res;
      };
    }
    exports2.mergeEvaluated = {
      props: makeMergeEvaluated({
        mergeNames: (gen, from, to) => gen.if((0, codegen_1._)`${to} !== true && ${from} !== undefined`, () => {
          gen.if((0, codegen_1._)`${from} === true`, () => gen.assign(to, true), () => gen.assign(to, (0, codegen_1._)`${to} || {}`).code((0, codegen_1._)`Object.assign(${to}, ${from})`));
        }),
        mergeToName: (gen, from, to) => gen.if((0, codegen_1._)`${to} !== true`, () => {
          if (from === true) {
            gen.assign(to, true);
          } else {
            gen.assign(to, (0, codegen_1._)`${to} || {}`);
            setEvaluated(gen, to, from);
          }
        }),
        mergeValues: (from, to) => from === true ? true : { ...from, ...to },
        resultToName: evaluatedPropsToName
      }),
      items: makeMergeEvaluated({
        mergeNames: (gen, from, to) => gen.if((0, codegen_1._)`${to} !== true && ${from} !== undefined`, () => gen.assign(to, (0, codegen_1._)`${from} === true ? true : ${to} > ${from} ? ${to} : ${from}`)),
        mergeToName: (gen, from, to) => gen.if((0, codegen_1._)`${to} !== true`, () => gen.assign(to, from === true ? true : (0, codegen_1._)`${to} > ${from} ? ${to} : ${from}`)),
        mergeValues: (from, to) => from === true ? true : Math.max(from, to),
        resultToName: (gen, items) => gen.var("items", items)
      })
    };
    function evaluatedPropsToName(gen, ps) {
      if (ps === true)
        return gen.var("props", true);
      const props = gen.var("props", (0, codegen_1._)`{}`);
      if (ps !== void 0)
        setEvaluated(gen, props, ps);
      return props;
    }
    exports2.evaluatedPropsToName = evaluatedPropsToName;
    function setEvaluated(gen, props, ps) {
      Object.keys(ps).forEach((p2) => gen.assign((0, codegen_1._)`${props}${(0, codegen_1.getProperty)(p2)}`, true));
    }
    exports2.setEvaluated = setEvaluated;
    var snippets = {};
    function useFunc(gen, f2) {
      return gen.scopeValue("func", {
        ref: f2,
        code: snippets[f2.code] || (snippets[f2.code] = new code_1._Code(f2.code))
      });
    }
    exports2.useFunc = useFunc;
    var Type;
    (function(Type2) {
      Type2[Type2["Num"] = 0] = "Num";
      Type2[Type2["Str"] = 1] = "Str";
    })(Type || (exports2.Type = Type = {}));
    function getErrorPath(dataProp, dataPropType, jsPropertySyntax) {
      if (dataProp instanceof codegen_1.Name) {
        const isNumber4 = dataPropType === Type.Num;
        return jsPropertySyntax ? isNumber4 ? (0, codegen_1._)`"[" + ${dataProp} + "]"` : (0, codegen_1._)`"['" + ${dataProp} + "']"` : isNumber4 ? (0, codegen_1._)`"/" + ${dataProp}` : (0, codegen_1._)`"/" + ${dataProp}.replace(/~/g, "~0").replace(/\\//g, "~1")`;
      }
      return jsPropertySyntax ? (0, codegen_1.getProperty)(dataProp).toString() : "/" + escapeJsonPointer(dataProp);
    }
    exports2.getErrorPath = getErrorPath;
    function checkStrictMode(it, msg, mode = it.opts.strictSchema) {
      if (!mode)
        return;
      msg = `strict mode: ${msg}`;
      if (mode === true)
        throw new Error(msg);
      it.self.logger.warn(msg);
    }
    exports2.checkStrictMode = checkStrictMode;
  }
});

// node_modules/ajv/dist/compile/names.js
var require_names = __commonJS({
  "node_modules/ajv/dist/compile/names.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var names = {
      // validation function arguments
      data: new codegen_1.Name("data"),
      // data passed to validation function
      // args passed from referencing schema
      valCxt: new codegen_1.Name("valCxt"),
      // validation/data context - should not be used directly, it is destructured to the names below
      instancePath: new codegen_1.Name("instancePath"),
      parentData: new codegen_1.Name("parentData"),
      parentDataProperty: new codegen_1.Name("parentDataProperty"),
      rootData: new codegen_1.Name("rootData"),
      // root data - same as the data passed to the first/top validation function
      dynamicAnchors: new codegen_1.Name("dynamicAnchors"),
      // used to support recursiveRef and dynamicRef
      // function scoped variables
      vErrors: new codegen_1.Name("vErrors"),
      // null or array of validation errors
      errors: new codegen_1.Name("errors"),
      // counter of validation errors
      this: new codegen_1.Name("this"),
      // "globals"
      self: new codegen_1.Name("self"),
      scope: new codegen_1.Name("scope"),
      // JTD serialize/parse name for JSON string and position
      json: new codegen_1.Name("json"),
      jsonPos: new codegen_1.Name("jsonPos"),
      jsonLen: new codegen_1.Name("jsonLen"),
      jsonPart: new codegen_1.Name("jsonPart")
    };
    exports2.default = names;
  }
});

// node_modules/ajv/dist/compile/errors.js
var require_errors = __commonJS({
  "node_modules/ajv/dist/compile/errors.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.extendErrors = exports2.resetErrorsCount = exports2.reportExtraError = exports2.reportError = exports2.keyword$DataError = exports2.keywordError = void 0;
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var names_1 = require_names();
    exports2.keywordError = {
      message: ({ keyword }) => (0, codegen_1.str)`must pass "${keyword}" keyword validation`
    };
    exports2.keyword$DataError = {
      message: ({ keyword, schemaType }) => schemaType ? (0, codegen_1.str)`"${keyword}" keyword must be ${schemaType} ($data)` : (0, codegen_1.str)`"${keyword}" keyword is invalid ($data)`
    };
    function reportError(cxt, error2 = exports2.keywordError, errorPaths, overrideAllErrors) {
      const { it } = cxt;
      const { gen, compositeRule, allErrors } = it;
      const errObj = errorObjectCode(cxt, error2, errorPaths);
      if (overrideAllErrors !== null && overrideAllErrors !== void 0 ? overrideAllErrors : compositeRule || allErrors) {
        addError(gen, errObj);
      } else {
        returnErrors(it, (0, codegen_1._)`[${errObj}]`);
      }
    }
    exports2.reportError = reportError;
    function reportExtraError(cxt, error2 = exports2.keywordError, errorPaths) {
      const { it } = cxt;
      const { gen, compositeRule, allErrors } = it;
      const errObj = errorObjectCode(cxt, error2, errorPaths);
      addError(gen, errObj);
      if (!(compositeRule || allErrors)) {
        returnErrors(it, names_1.default.vErrors);
      }
    }
    exports2.reportExtraError = reportExtraError;
    function resetErrorsCount(gen, errsCount) {
      gen.assign(names_1.default.errors, errsCount);
      gen.if((0, codegen_1._)`${names_1.default.vErrors} !== null`, () => gen.if(errsCount, () => gen.assign((0, codegen_1._)`${names_1.default.vErrors}.length`, errsCount), () => gen.assign(names_1.default.vErrors, null)));
    }
    exports2.resetErrorsCount = resetErrorsCount;
    function extendErrors({ gen, keyword, schemaValue, data, errsCount, it }) {
      if (errsCount === void 0)
        throw new Error("ajv implementation error");
      const err2 = gen.name("err");
      gen.forRange("i", errsCount, names_1.default.errors, (i2) => {
        gen.const(err2, (0, codegen_1._)`${names_1.default.vErrors}[${i2}]`);
        gen.if((0, codegen_1._)`${err2}.instancePath === undefined`, () => gen.assign((0, codegen_1._)`${err2}.instancePath`, (0, codegen_1.strConcat)(names_1.default.instancePath, it.errorPath)));
        gen.assign((0, codegen_1._)`${err2}.schemaPath`, (0, codegen_1.str)`${it.errSchemaPath}/${keyword}`);
        if (it.opts.verbose) {
          gen.assign((0, codegen_1._)`${err2}.schema`, schemaValue);
          gen.assign((0, codegen_1._)`${err2}.data`, data);
        }
      });
    }
    exports2.extendErrors = extendErrors;
    function addError(gen, errObj) {
      const err2 = gen.const("err", errObj);
      gen.if((0, codegen_1._)`${names_1.default.vErrors} === null`, () => gen.assign(names_1.default.vErrors, (0, codegen_1._)`[${err2}]`), (0, codegen_1._)`${names_1.default.vErrors}.push(${err2})`);
      gen.code((0, codegen_1._)`${names_1.default.errors}++`);
    }
    function returnErrors(it, errs) {
      const { gen, validateName, schemaEnv } = it;
      if (schemaEnv.$async) {
        gen.throw((0, codegen_1._)`new ${it.ValidationError}(${errs})`);
      } else {
        gen.assign((0, codegen_1._)`${validateName}.errors`, errs);
        gen.return(false);
      }
    }
    var E = {
      keyword: new codegen_1.Name("keyword"),
      schemaPath: new codegen_1.Name("schemaPath"),
      // also used in JTD errors
      params: new codegen_1.Name("params"),
      propertyName: new codegen_1.Name("propertyName"),
      message: new codegen_1.Name("message"),
      schema: new codegen_1.Name("schema"),
      parentSchema: new codegen_1.Name("parentSchema")
    };
    function errorObjectCode(cxt, error2, errorPaths) {
      const { createErrors } = cxt.it;
      if (createErrors === false)
        return (0, codegen_1._)`{}`;
      return errorObject(cxt, error2, errorPaths);
    }
    function errorObject(cxt, error2, errorPaths = {}) {
      const { gen, it } = cxt;
      const keyValues = [
        errorInstancePath(it, errorPaths),
        errorSchemaPath(cxt, errorPaths)
      ];
      extraErrorProps(cxt, error2, keyValues);
      return gen.object(...keyValues);
    }
    function errorInstancePath({ errorPath }, { instancePath }) {
      const instPath = instancePath ? (0, codegen_1.str)`${errorPath}${(0, util_1.getErrorPath)(instancePath, util_1.Type.Str)}` : errorPath;
      return [names_1.default.instancePath, (0, codegen_1.strConcat)(names_1.default.instancePath, instPath)];
    }
    function errorSchemaPath({ keyword, it: { errSchemaPath } }, { schemaPath, parentSchema }) {
      let schPath = parentSchema ? errSchemaPath : (0, codegen_1.str)`${errSchemaPath}/${keyword}`;
      if (schemaPath) {
        schPath = (0, codegen_1.str)`${schPath}${(0, util_1.getErrorPath)(schemaPath, util_1.Type.Str)}`;
      }
      return [E.schemaPath, schPath];
    }
    function extraErrorProps(cxt, { params, message }, keyValues) {
      const { keyword, data, schemaValue, it } = cxt;
      const { opts, propertyName, topSchemaRef, schemaPath } = it;
      keyValues.push([E.keyword, keyword], [E.params, typeof params == "function" ? params(cxt) : params || (0, codegen_1._)`{}`]);
      if (opts.messages) {
        keyValues.push([E.message, typeof message == "function" ? message(cxt) : message]);
      }
      if (opts.verbose) {
        keyValues.push([E.schema, schemaValue], [E.parentSchema, (0, codegen_1._)`${topSchemaRef}${schemaPath}`], [names_1.default.data, data]);
      }
      if (propertyName)
        keyValues.push([E.propertyName, propertyName]);
    }
  }
});

// node_modules/ajv/dist/compile/validate/boolSchema.js
var require_boolSchema = __commonJS({
  "node_modules/ajv/dist/compile/validate/boolSchema.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.boolOrEmptySchema = exports2.topBoolOrEmptySchema = void 0;
    var errors_1 = require_errors();
    var codegen_1 = require_codegen();
    var names_1 = require_names();
    var boolError = {
      message: "boolean schema is false"
    };
    function topBoolOrEmptySchema(it) {
      const { gen, schema, validateName } = it;
      if (schema === false) {
        falseSchemaError(it, false);
      } else if (typeof schema == "object" && schema.$async === true) {
        gen.return(names_1.default.data);
      } else {
        gen.assign((0, codegen_1._)`${validateName}.errors`, null);
        gen.return(true);
      }
    }
    exports2.topBoolOrEmptySchema = topBoolOrEmptySchema;
    function boolOrEmptySchema(it, valid) {
      const { gen, schema } = it;
      if (schema === false) {
        gen.var(valid, false);
        falseSchemaError(it);
      } else {
        gen.var(valid, true);
      }
    }
    exports2.boolOrEmptySchema = boolOrEmptySchema;
    function falseSchemaError(it, overrideAllErrors) {
      const { gen, data } = it;
      const cxt = {
        gen,
        keyword: "false schema",
        data,
        schema: false,
        schemaCode: false,
        schemaValue: false,
        params: {},
        it
      };
      (0, errors_1.reportError)(cxt, boolError, void 0, overrideAllErrors);
    }
  }
});

// node_modules/ajv/dist/compile/rules.js
var require_rules = __commonJS({
  "node_modules/ajv/dist/compile/rules.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getRules = exports2.isJSONType = void 0;
    var _jsonTypes = ["string", "number", "integer", "boolean", "null", "object", "array"];
    var jsonTypes = new Set(_jsonTypes);
    function isJSONType(x) {
      return typeof x == "string" && jsonTypes.has(x);
    }
    exports2.isJSONType = isJSONType;
    function getRules() {
      const groups = {
        number: { type: "number", rules: [] },
        string: { type: "string", rules: [] },
        array: { type: "array", rules: [] },
        object: { type: "object", rules: [] }
      };
      return {
        types: { ...groups, integer: true, boolean: true, null: true },
        rules: [{ rules: [] }, groups.number, groups.string, groups.array, groups.object],
        post: { rules: [] },
        all: {},
        keywords: {}
      };
    }
    exports2.getRules = getRules;
  }
});

// node_modules/ajv/dist/compile/validate/applicability.js
var require_applicability = __commonJS({
  "node_modules/ajv/dist/compile/validate/applicability.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.shouldUseRule = exports2.shouldUseGroup = exports2.schemaHasRulesForType = void 0;
    function schemaHasRulesForType({ schema, self: self2 }, type) {
      const group = self2.RULES.types[type];
      return group && group !== true && shouldUseGroup(schema, group);
    }
    exports2.schemaHasRulesForType = schemaHasRulesForType;
    function shouldUseGroup(schema, group) {
      return group.rules.some((rule) => shouldUseRule(schema, rule));
    }
    exports2.shouldUseGroup = shouldUseGroup;
    function shouldUseRule(schema, rule) {
      var _a17;
      return schema[rule.keyword] !== void 0 || ((_a17 = rule.definition.implements) === null || _a17 === void 0 ? void 0 : _a17.some((kwd) => schema[kwd] !== void 0));
    }
    exports2.shouldUseRule = shouldUseRule;
  }
});

// node_modules/ajv/dist/compile/validate/dataType.js
var require_dataType = __commonJS({
  "node_modules/ajv/dist/compile/validate/dataType.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.reportTypeError = exports2.checkDataTypes = exports2.checkDataType = exports2.coerceAndCheckDataType = exports2.getJSONTypes = exports2.getSchemaTypes = exports2.DataType = void 0;
    var rules_1 = require_rules();
    var applicability_1 = require_applicability();
    var errors_1 = require_errors();
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var DataType;
    (function(DataType2) {
      DataType2[DataType2["Correct"] = 0] = "Correct";
      DataType2[DataType2["Wrong"] = 1] = "Wrong";
    })(DataType || (exports2.DataType = DataType = {}));
    function getSchemaTypes(schema) {
      const types2 = getJSONTypes(schema.type);
      const hasNull = types2.includes("null");
      if (hasNull) {
        if (schema.nullable === false)
          throw new Error("type: null contradicts nullable: false");
      } else {
        if (!types2.length && schema.nullable !== void 0) {
          throw new Error('"nullable" cannot be used without "type"');
        }
        if (schema.nullable === true)
          types2.push("null");
      }
      return types2;
    }
    exports2.getSchemaTypes = getSchemaTypes;
    function getJSONTypes(ts) {
      const types2 = Array.isArray(ts) ? ts : ts ? [ts] : [];
      if (types2.every(rules_1.isJSONType))
        return types2;
      throw new Error("type must be JSONType or JSONType[]: " + types2.join(","));
    }
    exports2.getJSONTypes = getJSONTypes;
    function coerceAndCheckDataType(it, types2) {
      const { gen, data, opts } = it;
      const coerceTo = coerceToTypes(types2, opts.coerceTypes);
      const checkTypes = types2.length > 0 && !(coerceTo.length === 0 && types2.length === 1 && (0, applicability_1.schemaHasRulesForType)(it, types2[0]));
      if (checkTypes) {
        const wrongType = checkDataTypes(types2, data, opts.strictNumbers, DataType.Wrong);
        gen.if(wrongType, () => {
          if (coerceTo.length)
            coerceData(it, types2, coerceTo);
          else
            reportTypeError(it);
        });
      }
      return checkTypes;
    }
    exports2.coerceAndCheckDataType = coerceAndCheckDataType;
    var COERCIBLE = /* @__PURE__ */ new Set(["string", "number", "integer", "boolean", "null"]);
    function coerceToTypes(types2, coerceTypes) {
      return coerceTypes ? types2.filter((t92) => COERCIBLE.has(t92) || coerceTypes === "array" && t92 === "array") : [];
    }
    function coerceData(it, types2, coerceTo) {
      const { gen, data, opts } = it;
      const dataType = gen.let("dataType", (0, codegen_1._)`typeof ${data}`);
      const coerced = gen.let("coerced", (0, codegen_1._)`undefined`);
      if (opts.coerceTypes === "array") {
        gen.if((0, codegen_1._)`${dataType} == 'object' && Array.isArray(${data}) && ${data}.length == 1`, () => gen.assign(data, (0, codegen_1._)`${data}[0]`).assign(dataType, (0, codegen_1._)`typeof ${data}`).if(checkDataTypes(types2, data, opts.strictNumbers), () => gen.assign(coerced, data)));
      }
      gen.if((0, codegen_1._)`${coerced} !== undefined`);
      for (const t92 of coerceTo) {
        if (COERCIBLE.has(t92) || t92 === "array" && opts.coerceTypes === "array") {
          coerceSpecificType(t92);
        }
      }
      gen.else();
      reportTypeError(it);
      gen.endIf();
      gen.if((0, codegen_1._)`${coerced} !== undefined`, () => {
        gen.assign(data, coerced);
        assignParentData(it, coerced);
      });
      function coerceSpecificType(t92) {
        switch (t92) {
          case "string":
            gen.elseIf((0, codegen_1._)`${dataType} == "number" || ${dataType} == "boolean"`).assign(coerced, (0, codegen_1._)`"" + ${data}`).elseIf((0, codegen_1._)`${data} === null`).assign(coerced, (0, codegen_1._)`""`);
            return;
          case "number":
            gen.elseIf((0, codegen_1._)`${dataType} == "boolean" || ${data} === null
              || (${dataType} == "string" && ${data} && ${data} == +${data})`).assign(coerced, (0, codegen_1._)`+${data}`);
            return;
          case "integer":
            gen.elseIf((0, codegen_1._)`${dataType} === "boolean" || ${data} === null
              || (${dataType} === "string" && ${data} && ${data} == +${data} && !(${data} % 1))`).assign(coerced, (0, codegen_1._)`+${data}`);
            return;
          case "boolean":
            gen.elseIf((0, codegen_1._)`${data} === "false" || ${data} === 0 || ${data} === null`).assign(coerced, false).elseIf((0, codegen_1._)`${data} === "true" || ${data} === 1`).assign(coerced, true);
            return;
          case "null":
            gen.elseIf((0, codegen_1._)`${data} === "" || ${data} === 0 || ${data} === false`);
            gen.assign(coerced, null);
            return;
          case "array":
            gen.elseIf((0, codegen_1._)`${dataType} === "string" || ${dataType} === "number"
              || ${dataType} === "boolean" || ${data} === null`).assign(coerced, (0, codegen_1._)`[${data}]`);
        }
      }
    }
    function assignParentData({ gen, parentData, parentDataProperty }, expr) {
      gen.if((0, codegen_1._)`${parentData} !== undefined`, () => gen.assign((0, codegen_1._)`${parentData}[${parentDataProperty}]`, expr));
    }
    function checkDataType(dataType, data, strictNums, correct = DataType.Correct) {
      const EQ = correct === DataType.Correct ? codegen_1.operators.EQ : codegen_1.operators.NEQ;
      let cond;
      switch (dataType) {
        case "null":
          return (0, codegen_1._)`${data} ${EQ} null`;
        case "array":
          cond = (0, codegen_1._)`Array.isArray(${data})`;
          break;
        case "object":
          cond = (0, codegen_1._)`${data} && typeof ${data} == "object" && !Array.isArray(${data})`;
          break;
        case "integer":
          cond = numCond((0, codegen_1._)`!(${data} % 1) && !isNaN(${data})`);
          break;
        case "number":
          cond = numCond();
          break;
        default:
          return (0, codegen_1._)`typeof ${data} ${EQ} ${dataType}`;
      }
      return correct === DataType.Correct ? cond : (0, codegen_1.not)(cond);
      function numCond(_cond = codegen_1.nil) {
        return (0, codegen_1.and)((0, codegen_1._)`typeof ${data} == "number"`, _cond, strictNums ? (0, codegen_1._)`isFinite(${data})` : codegen_1.nil);
      }
    }
    exports2.checkDataType = checkDataType;
    function checkDataTypes(dataTypes, data, strictNums, correct) {
      if (dataTypes.length === 1) {
        return checkDataType(dataTypes[0], data, strictNums, correct);
      }
      let cond;
      const types2 = (0, util_1.toHash)(dataTypes);
      if (types2.array && types2.object) {
        const notObj = (0, codegen_1._)`typeof ${data} != "object"`;
        cond = types2.null ? notObj : (0, codegen_1._)`!${data} || ${notObj}`;
        delete types2.null;
        delete types2.array;
        delete types2.object;
      } else {
        cond = codegen_1.nil;
      }
      if (types2.number)
        delete types2.integer;
      for (const t92 in types2)
        cond = (0, codegen_1.and)(cond, checkDataType(t92, data, strictNums, correct));
      return cond;
    }
    exports2.checkDataTypes = checkDataTypes;
    var typeError = {
      message: ({ schema }) => `must be ${schema}`,
      params: ({ schema, schemaValue }) => typeof schema == "string" ? (0, codegen_1._)`{type: ${schema}}` : (0, codegen_1._)`{type: ${schemaValue}}`
    };
    function reportTypeError(it) {
      const cxt = getTypeErrorContext(it);
      (0, errors_1.reportError)(cxt, typeError);
    }
    exports2.reportTypeError = reportTypeError;
    function getTypeErrorContext(it) {
      const { gen, data, schema } = it;
      const schemaCode = (0, util_1.schemaRefOrVal)(it, schema, "type");
      return {
        gen,
        keyword: "type",
        data,
        schema: schema.type,
        schemaCode,
        schemaValue: schemaCode,
        parentSchema: schema,
        params: {},
        it
      };
    }
  }
});

// node_modules/ajv/dist/compile/validate/defaults.js
var require_defaults = __commonJS({
  "node_modules/ajv/dist/compile/validate/defaults.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.assignDefaults = void 0;
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    function assignDefaults(it, ty) {
      const { properties, items } = it.schema;
      if (ty === "object" && properties) {
        for (const key in properties) {
          assignDefault(it, key, properties[key].default);
        }
      } else if (ty === "array" && Array.isArray(items)) {
        items.forEach((sch, i2) => assignDefault(it, i2, sch.default));
      }
    }
    exports2.assignDefaults = assignDefaults;
    function assignDefault(it, prop, defaultValue) {
      const { gen, compositeRule, data, opts } = it;
      if (defaultValue === void 0)
        return;
      const childData = (0, codegen_1._)`${data}${(0, codegen_1.getProperty)(prop)}`;
      if (compositeRule) {
        (0, util_1.checkStrictMode)(it, `default is ignored for: ${childData}`);
        return;
      }
      let condition = (0, codegen_1._)`${childData} === undefined`;
      if (opts.useDefaults === "empty") {
        condition = (0, codegen_1._)`${condition} || ${childData} === null || ${childData} === ""`;
      }
      gen.if(condition, (0, codegen_1._)`${childData} = ${(0, codegen_1.stringify)(defaultValue)}`);
    }
  }
});

// node_modules/ajv/dist/vocabularies/code.js
var require_code2 = __commonJS({
  "node_modules/ajv/dist/vocabularies/code.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.validateUnion = exports2.validateArray = exports2.usePattern = exports2.callValidateCode = exports2.schemaProperties = exports2.allSchemaProperties = exports2.noPropertyInData = exports2.propertyInData = exports2.isOwnProperty = exports2.hasPropFunc = exports2.reportMissingProp = exports2.checkMissingProp = exports2.checkReportMissingProp = void 0;
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var names_1 = require_names();
    var util_2 = require_util();
    function checkReportMissingProp(cxt, prop) {
      const { gen, data, it } = cxt;
      gen.if(noPropertyInData(gen, data, prop, it.opts.ownProperties), () => {
        cxt.setParams({ missingProperty: (0, codegen_1._)`${prop}` }, true);
        cxt.error();
      });
    }
    exports2.checkReportMissingProp = checkReportMissingProp;
    function checkMissingProp({ gen, data, it: { opts } }, properties, missing) {
      return (0, codegen_1.or)(...properties.map((prop) => (0, codegen_1.and)(noPropertyInData(gen, data, prop, opts.ownProperties), (0, codegen_1._)`${missing} = ${prop}`)));
    }
    exports2.checkMissingProp = checkMissingProp;
    function reportMissingProp(cxt, missing) {
      cxt.setParams({ missingProperty: missing }, true);
      cxt.error();
    }
    exports2.reportMissingProp = reportMissingProp;
    function hasPropFunc(gen) {
      return gen.scopeValue("func", {
        // eslint-disable-next-line @typescript-eslint/unbound-method
        ref: Object.prototype.hasOwnProperty,
        code: (0, codegen_1._)`Object.prototype.hasOwnProperty`
      });
    }
    exports2.hasPropFunc = hasPropFunc;
    function isOwnProperty(gen, data, property) {
      return (0, codegen_1._)`${hasPropFunc(gen)}.call(${data}, ${property})`;
    }
    exports2.isOwnProperty = isOwnProperty;
    function propertyInData(gen, data, property, ownProperties) {
      const cond = (0, codegen_1._)`${data}${(0, codegen_1.getProperty)(property)} !== undefined`;
      return ownProperties ? (0, codegen_1._)`${cond} && ${isOwnProperty(gen, data, property)}` : cond;
    }
    exports2.propertyInData = propertyInData;
    function noPropertyInData(gen, data, property, ownProperties) {
      const cond = (0, codegen_1._)`${data}${(0, codegen_1.getProperty)(property)} === undefined`;
      return ownProperties ? (0, codegen_1.or)(cond, (0, codegen_1.not)(isOwnProperty(gen, data, property))) : cond;
    }
    exports2.noPropertyInData = noPropertyInData;
    function allSchemaProperties(schemaMap) {
      return schemaMap ? Object.keys(schemaMap).filter((p2) => p2 !== "__proto__") : [];
    }
    exports2.allSchemaProperties = allSchemaProperties;
    function schemaProperties(it, schemaMap) {
      return allSchemaProperties(schemaMap).filter((p2) => !(0, util_1.alwaysValidSchema)(it, schemaMap[p2]));
    }
    exports2.schemaProperties = schemaProperties;
    function callValidateCode({ schemaCode, data, it: { gen, topSchemaRef, schemaPath, errorPath }, it }, func2, context3, passSchema) {
      const dataAndSchema = passSchema ? (0, codegen_1._)`${schemaCode}, ${data}, ${topSchemaRef}${schemaPath}` : data;
      const valCxt = [
        [names_1.default.instancePath, (0, codegen_1.strConcat)(names_1.default.instancePath, errorPath)],
        [names_1.default.parentData, it.parentData],
        [names_1.default.parentDataProperty, it.parentDataProperty],
        [names_1.default.rootData, names_1.default.rootData]
      ];
      if (it.opts.dynamicRef)
        valCxt.push([names_1.default.dynamicAnchors, names_1.default.dynamicAnchors]);
      const args2 = (0, codegen_1._)`${dataAndSchema}, ${gen.object(...valCxt)}`;
      return context3 !== codegen_1.nil ? (0, codegen_1._)`${func2}.call(${context3}, ${args2})` : (0, codegen_1._)`${func2}(${args2})`;
    }
    exports2.callValidateCode = callValidateCode;
    var newRegExp = (0, codegen_1._)`new RegExp`;
    function usePattern({ gen, it: { opts } }, pattern) {
      const u = opts.unicodeRegExp ? "u" : "";
      const { regExp } = opts.code;
      const rx = regExp(pattern, u);
      return gen.scopeValue("pattern", {
        key: rx.toString(),
        ref: rx,
        code: (0, codegen_1._)`${regExp.code === "new RegExp" ? newRegExp : (0, util_2.useFunc)(gen, regExp)}(${pattern}, ${u})`
      });
    }
    exports2.usePattern = usePattern;
    function validateArray(cxt) {
      const { gen, data, keyword, it } = cxt;
      const valid = gen.name("valid");
      if (it.allErrors) {
        const validArr = gen.let("valid", true);
        validateItems(() => gen.assign(validArr, false));
        return validArr;
      }
      gen.var(valid, true);
      validateItems(() => gen.break());
      return valid;
      function validateItems(notValid) {
        const len = gen.const("len", (0, codegen_1._)`${data}.length`);
        gen.forRange("i", 0, len, (i2) => {
          cxt.subschema({
            keyword,
            dataProp: i2,
            dataPropType: util_1.Type.Num
          }, valid);
          gen.if((0, codegen_1.not)(valid), notValid);
        });
      }
    }
    exports2.validateArray = validateArray;
    function validateUnion(cxt) {
      const { gen, schema, keyword, it } = cxt;
      if (!Array.isArray(schema))
        throw new Error("ajv implementation error");
      const alwaysValid = schema.some((sch) => (0, util_1.alwaysValidSchema)(it, sch));
      if (alwaysValid && !it.opts.unevaluated)
        return;
      const valid = gen.let("valid", false);
      const schValid = gen.name("_valid");
      gen.block(() => schema.forEach((_sch, i2) => {
        const schCxt = cxt.subschema({
          keyword,
          schemaProp: i2,
          compositeRule: true
        }, schValid);
        gen.assign(valid, (0, codegen_1._)`${valid} || ${schValid}`);
        const merged = cxt.mergeValidEvaluated(schCxt, schValid);
        if (!merged)
          gen.if((0, codegen_1.not)(valid));
      }));
      cxt.result(valid, () => cxt.reset(), () => cxt.error(true));
    }
    exports2.validateUnion = validateUnion;
  }
});

// node_modules/ajv/dist/compile/validate/keyword.js
var require_keyword = __commonJS({
  "node_modules/ajv/dist/compile/validate/keyword.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.validateKeywordUsage = exports2.validSchemaType = exports2.funcKeywordCode = exports2.macroKeywordCode = void 0;
    var codegen_1 = require_codegen();
    var names_1 = require_names();
    var code_1 = require_code2();
    var errors_1 = require_errors();
    function macroKeywordCode(cxt, def) {
      const { gen, keyword, schema, parentSchema, it } = cxt;
      const macroSchema = def.macro.call(it.self, schema, parentSchema, it);
      const schemaRef = useKeyword(gen, keyword, macroSchema);
      if (it.opts.validateSchema !== false)
        it.self.validateSchema(macroSchema, true);
      const valid = gen.name("valid");
      cxt.subschema({
        schema: macroSchema,
        schemaPath: codegen_1.nil,
        errSchemaPath: `${it.errSchemaPath}/${keyword}`,
        topSchemaRef: schemaRef,
        compositeRule: true
      }, valid);
      cxt.pass(valid, () => cxt.error(true));
    }
    exports2.macroKeywordCode = macroKeywordCode;
    function funcKeywordCode(cxt, def) {
      var _a17;
      const { gen, keyword, schema, parentSchema, $data, it } = cxt;
      checkAsyncKeyword(it, def);
      const validate = !$data && def.compile ? def.compile.call(it.self, schema, parentSchema, it) : def.validate;
      const validateRef = useKeyword(gen, keyword, validate);
      const valid = gen.let("valid");
      cxt.block$data(valid, validateKeyword);
      cxt.ok((_a17 = def.valid) !== null && _a17 !== void 0 ? _a17 : valid);
      function validateKeyword() {
        if (def.errors === false) {
          assignValid();
          if (def.modifying)
            modifyData(cxt);
          reportErrs(() => cxt.error());
        } else {
          const ruleErrs = def.async ? validateAsync() : validateSync();
          if (def.modifying)
            modifyData(cxt);
          reportErrs(() => addErrs(cxt, ruleErrs));
        }
      }
      function validateAsync() {
        const ruleErrs = gen.let("ruleErrs", null);
        gen.try(() => assignValid((0, codegen_1._)`await `), (e) => gen.assign(valid, false).if((0, codegen_1._)`${e} instanceof ${it.ValidationError}`, () => gen.assign(ruleErrs, (0, codegen_1._)`${e}.errors`), () => gen.throw(e)));
        return ruleErrs;
      }
      function validateSync() {
        const validateErrs = (0, codegen_1._)`${validateRef}.errors`;
        gen.assign(validateErrs, null);
        assignValid(codegen_1.nil);
        return validateErrs;
      }
      function assignValid(_await = def.async ? (0, codegen_1._)`await ` : codegen_1.nil) {
        const passCxt = it.opts.passContext ? names_1.default.this : names_1.default.self;
        const passSchema = !("compile" in def && !$data || def.schema === false);
        gen.assign(valid, (0, codegen_1._)`${_await}${(0, code_1.callValidateCode)(cxt, validateRef, passCxt, passSchema)}`, def.modifying);
      }
      function reportErrs(errors2) {
        var _a18;
        gen.if((0, codegen_1.not)((_a18 = def.valid) !== null && _a18 !== void 0 ? _a18 : valid), errors2);
      }
    }
    exports2.funcKeywordCode = funcKeywordCode;
    function modifyData(cxt) {
      const { gen, data, it } = cxt;
      gen.if(it.parentData, () => gen.assign(data, (0, codegen_1._)`${it.parentData}[${it.parentDataProperty}]`));
    }
    function addErrs(cxt, errs) {
      const { gen } = cxt;
      gen.if((0, codegen_1._)`Array.isArray(${errs})`, () => {
        gen.assign(names_1.default.vErrors, (0, codegen_1._)`${names_1.default.vErrors} === null ? ${errs} : ${names_1.default.vErrors}.concat(${errs})`).assign(names_1.default.errors, (0, codegen_1._)`${names_1.default.vErrors}.length`);
        (0, errors_1.extendErrors)(cxt);
      }, () => cxt.error());
    }
    function checkAsyncKeyword({ schemaEnv }, def) {
      if (def.async && !schemaEnv.$async)
        throw new Error("async keyword in sync schema");
    }
    function useKeyword(gen, keyword, result) {
      if (result === void 0)
        throw new Error(`keyword "${keyword}" failed to compile`);
      return gen.scopeValue("keyword", typeof result == "function" ? { ref: result } : { ref: result, code: (0, codegen_1.stringify)(result) });
    }
    function validSchemaType(schema, schemaType, allowUndefined = false) {
      return !schemaType.length || schemaType.some((st) => st === "array" ? Array.isArray(schema) : st === "object" ? schema && typeof schema == "object" && !Array.isArray(schema) : typeof schema == st || allowUndefined && typeof schema == "undefined");
    }
    exports2.validSchemaType = validSchemaType;
    function validateKeywordUsage({ schema, opts, self: self2, errSchemaPath }, def, keyword) {
      if (Array.isArray(def.keyword) ? !def.keyword.includes(keyword) : def.keyword !== keyword) {
        throw new Error("ajv implementation error");
      }
      const deps = def.dependencies;
      if (deps === null || deps === void 0 ? void 0 : deps.some((kwd) => !Object.prototype.hasOwnProperty.call(schema, kwd))) {
        throw new Error(`parent schema must have dependencies of ${keyword}: ${deps.join(",")}`);
      }
      if (def.validateSchema) {
        const valid = def.validateSchema(schema[keyword]);
        if (!valid) {
          const msg = `keyword "${keyword}" value is invalid at path "${errSchemaPath}": ` + self2.errorsText(def.validateSchema.errors);
          if (opts.validateSchema === "log")
            self2.logger.error(msg);
          else
            throw new Error(msg);
        }
      }
    }
    exports2.validateKeywordUsage = validateKeywordUsage;
  }
});

// node_modules/ajv/dist/compile/validate/subschema.js
var require_subschema = __commonJS({
  "node_modules/ajv/dist/compile/validate/subschema.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.extendSubschemaMode = exports2.extendSubschemaData = exports2.getSubschema = void 0;
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    function getSubschema(it, { keyword, schemaProp, schema, schemaPath, errSchemaPath, topSchemaRef }) {
      if (keyword !== void 0 && schema !== void 0) {
        throw new Error('both "keyword" and "schema" passed, only one allowed');
      }
      if (keyword !== void 0) {
        const sch = it.schema[keyword];
        return schemaProp === void 0 ? {
          schema: sch,
          schemaPath: (0, codegen_1._)`${it.schemaPath}${(0, codegen_1.getProperty)(keyword)}`,
          errSchemaPath: `${it.errSchemaPath}/${keyword}`
        } : {
          schema: sch[schemaProp],
          schemaPath: (0, codegen_1._)`${it.schemaPath}${(0, codegen_1.getProperty)(keyword)}${(0, codegen_1.getProperty)(schemaProp)}`,
          errSchemaPath: `${it.errSchemaPath}/${keyword}/${(0, util_1.escapeFragment)(schemaProp)}`
        };
      }
      if (schema !== void 0) {
        if (schemaPath === void 0 || errSchemaPath === void 0 || topSchemaRef === void 0) {
          throw new Error('"schemaPath", "errSchemaPath" and "topSchemaRef" are required with "schema"');
        }
        return {
          schema,
          schemaPath,
          topSchemaRef,
          errSchemaPath
        };
      }
      throw new Error('either "keyword" or "schema" must be passed');
    }
    exports2.getSubschema = getSubschema;
    function extendSubschemaData(subschema, it, { dataProp, dataPropType: dpType, data, dataTypes, propertyName }) {
      if (data !== void 0 && dataProp !== void 0) {
        throw new Error('both "data" and "dataProp" passed, only one allowed');
      }
      const { gen } = it;
      if (dataProp !== void 0) {
        const { errorPath, dataPathArr, opts } = it;
        const nextData = gen.let("data", (0, codegen_1._)`${it.data}${(0, codegen_1.getProperty)(dataProp)}`, true);
        dataContextProps(nextData);
        subschema.errorPath = (0, codegen_1.str)`${errorPath}${(0, util_1.getErrorPath)(dataProp, dpType, opts.jsPropertySyntax)}`;
        subschema.parentDataProperty = (0, codegen_1._)`${dataProp}`;
        subschema.dataPathArr = [...dataPathArr, subschema.parentDataProperty];
      }
      if (data !== void 0) {
        const nextData = data instanceof codegen_1.Name ? data : gen.let("data", data, true);
        dataContextProps(nextData);
        if (propertyName !== void 0)
          subschema.propertyName = propertyName;
      }
      if (dataTypes)
        subschema.dataTypes = dataTypes;
      function dataContextProps(_nextData) {
        subschema.data = _nextData;
        subschema.dataLevel = it.dataLevel + 1;
        subschema.dataTypes = [];
        it.definedProperties = /* @__PURE__ */ new Set();
        subschema.parentData = it.data;
        subschema.dataNames = [...it.dataNames, _nextData];
      }
    }
    exports2.extendSubschemaData = extendSubschemaData;
    function extendSubschemaMode(subschema, { jtdDiscriminator, jtdMetadata, compositeRule, createErrors, allErrors }) {
      if (compositeRule !== void 0)
        subschema.compositeRule = compositeRule;
      if (createErrors !== void 0)
        subschema.createErrors = createErrors;
      if (allErrors !== void 0)
        subschema.allErrors = allErrors;
      subschema.jtdDiscriminator = jtdDiscriminator;
      subschema.jtdMetadata = jtdMetadata;
    }
    exports2.extendSubschemaMode = extendSubschemaMode;
  }
});

// node_modules/fast-deep-equal/index.js
var require_fast_deep_equal = __commonJS({
  "node_modules/fast-deep-equal/index.js"(exports2, module2) {
    "use strict";
    module2.exports = function equal(a, b) {
      if (a === b) return true;
      if (a && b && typeof a == "object" && typeof b == "object") {
        if (a.constructor !== b.constructor) return false;
        var length, i2, keys;
        if (Array.isArray(a)) {
          length = a.length;
          if (length != b.length) return false;
          for (i2 = length; i2-- !== 0; )
            if (!equal(a[i2], b[i2])) return false;
          return true;
        }
        if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
        if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
        if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();
        keys = Object.keys(a);
        length = keys.length;
        if (length !== Object.keys(b).length) return false;
        for (i2 = length; i2-- !== 0; )
          if (!Object.prototype.hasOwnProperty.call(b, keys[i2])) return false;
        for (i2 = length; i2-- !== 0; ) {
          var key = keys[i2];
          if (!equal(a[key], b[key])) return false;
        }
        return true;
      }
      return a !== a && b !== b;
    };
  }
});

// node_modules/json-schema-traverse/index.js
var require_json_schema_traverse = __commonJS({
  "node_modules/json-schema-traverse/index.js"(exports2, module2) {
    "use strict";
    var traverse = module2.exports = function(schema, opts, cb) {
      if (typeof opts == "function") {
        cb = opts;
        opts = {};
      }
      cb = opts.cb || cb;
      var pre = typeof cb == "function" ? cb : cb.pre || function() {
      };
      var post = cb.post || function() {
      };
      _traverse(opts, pre, post, schema, "", schema);
    };
    traverse.keywords = {
      additionalItems: true,
      items: true,
      contains: true,
      additionalProperties: true,
      propertyNames: true,
      not: true,
      if: true,
      then: true,
      else: true
    };
    traverse.arrayKeywords = {
      items: true,
      allOf: true,
      anyOf: true,
      oneOf: true
    };
    traverse.propsKeywords = {
      $defs: true,
      definitions: true,
      properties: true,
      patternProperties: true,
      dependencies: true
    };
    traverse.skipKeywords = {
      default: true,
      enum: true,
      const: true,
      required: true,
      maximum: true,
      minimum: true,
      exclusiveMaximum: true,
      exclusiveMinimum: true,
      multipleOf: true,
      maxLength: true,
      minLength: true,
      pattern: true,
      format: true,
      maxItems: true,
      minItems: true,
      uniqueItems: true,
      maxProperties: true,
      minProperties: true
    };
    function _traverse(opts, pre, post, schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
      if (schema && typeof schema == "object" && !Array.isArray(schema)) {
        pre(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
        for (var key in schema) {
          var sch = schema[key];
          if (Array.isArray(sch)) {
            if (key in traverse.arrayKeywords) {
              for (var i2 = 0; i2 < sch.length; i2++)
                _traverse(opts, pre, post, sch[i2], jsonPtr + "/" + key + "/" + i2, rootSchema, jsonPtr, key, schema, i2);
            }
          } else if (key in traverse.propsKeywords) {
            if (sch && typeof sch == "object") {
              for (var prop in sch)
                _traverse(opts, pre, post, sch[prop], jsonPtr + "/" + key + "/" + escapeJsonPtr(prop), rootSchema, jsonPtr, key, schema, prop);
            }
          } else if (key in traverse.keywords || opts.allKeys && !(key in traverse.skipKeywords)) {
            _traverse(opts, pre, post, sch, jsonPtr + "/" + key, rootSchema, jsonPtr, key, schema);
          }
        }
        post(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
      }
    }
    function escapeJsonPtr(str) {
      return str.replace(/~/g, "~0").replace(/\//g, "~1");
    }
  }
});

// node_modules/ajv/dist/compile/resolve.js
var require_resolve = __commonJS({
  "node_modules/ajv/dist/compile/resolve.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getSchemaRefs = exports2.resolveUrl = exports2.normalizeId = exports2._getFullPath = exports2.getFullPath = exports2.inlineRef = void 0;
    var util_1 = require_util();
    var equal = require_fast_deep_equal();
    var traverse = require_json_schema_traverse();
    var SIMPLE_INLINED = /* @__PURE__ */ new Set([
      "type",
      "format",
      "pattern",
      "maxLength",
      "minLength",
      "maxProperties",
      "minProperties",
      "maxItems",
      "minItems",
      "maximum",
      "minimum",
      "uniqueItems",
      "multipleOf",
      "required",
      "enum",
      "const"
    ]);
    function inlineRef(schema, limit = true) {
      if (typeof schema == "boolean")
        return true;
      if (limit === true)
        return !hasRef(schema);
      if (!limit)
        return false;
      return countKeys(schema) <= limit;
    }
    exports2.inlineRef = inlineRef;
    var REF_KEYWORDS = /* @__PURE__ */ new Set([
      "$ref",
      "$recursiveRef",
      "$recursiveAnchor",
      "$dynamicRef",
      "$dynamicAnchor"
    ]);
    function hasRef(schema) {
      for (const key in schema) {
        if (REF_KEYWORDS.has(key))
          return true;
        const sch = schema[key];
        if (Array.isArray(sch) && sch.some(hasRef))
          return true;
        if (typeof sch == "object" && hasRef(sch))
          return true;
      }
      return false;
    }
    function countKeys(schema) {
      let count2 = 0;
      for (const key in schema) {
        if (key === "$ref")
          return Infinity;
        count2++;
        if (SIMPLE_INLINED.has(key))
          continue;
        if (typeof schema[key] == "object") {
          (0, util_1.eachItem)(schema[key], (sch) => count2 += countKeys(sch));
        }
        if (count2 === Infinity)
          return Infinity;
      }
      return count2;
    }
    function getFullPath(resolver, id2 = "", normalize4) {
      if (normalize4 !== false)
        id2 = normalizeId(id2);
      const p2 = resolver.parse(id2);
      return _getFullPath(resolver, p2);
    }
    exports2.getFullPath = getFullPath;
    function _getFullPath(resolver, p2) {
      const serialized = resolver.serialize(p2);
      return serialized.split("#")[0] + "#";
    }
    exports2._getFullPath = _getFullPath;
    var TRAILING_SLASH_HASH = /#\/?$/;
    function normalizeId(id2) {
      return id2 ? id2.replace(TRAILING_SLASH_HASH, "") : "";
    }
    exports2.normalizeId = normalizeId;
    function resolveUrl(resolver, baseId, id2) {
      id2 = normalizeId(id2);
      return resolver.resolve(baseId, id2);
    }
    exports2.resolveUrl = resolveUrl;
    var ANCHOR = /^[a-z_][-a-z0-9._]*$/i;
    function getSchemaRefs(schema, baseId) {
      if (typeof schema == "boolean")
        return {};
      const { schemaId, uriResolver } = this.opts;
      const schId = normalizeId(schema[schemaId] || baseId);
      const baseIds = { "": schId };
      const pathPrefix = getFullPath(uriResolver, schId, false);
      const localRefs = {};
      const schemaRefs = /* @__PURE__ */ new Set();
      traverse(schema, { allKeys: true }, (sch, jsonPtr, _, parentJsonPtr) => {
        if (parentJsonPtr === void 0)
          return;
        const fullPath = pathPrefix + jsonPtr;
        let innerBaseId = baseIds[parentJsonPtr];
        if (typeof sch[schemaId] == "string")
          innerBaseId = addRef.call(this, sch[schemaId]);
        addAnchor.call(this, sch.$anchor);
        addAnchor.call(this, sch.$dynamicAnchor);
        baseIds[jsonPtr] = innerBaseId;
        function addRef(ref) {
          const _resolve = this.opts.uriResolver.resolve;
          ref = normalizeId(innerBaseId ? _resolve(innerBaseId, ref) : ref);
          if (schemaRefs.has(ref))
            throw ambiguos(ref);
          schemaRefs.add(ref);
          let schOrRef = this.refs[ref];
          if (typeof schOrRef == "string")
            schOrRef = this.refs[schOrRef];
          if (typeof schOrRef == "object") {
            checkAmbiguosRef(sch, schOrRef.schema, ref);
          } else if (ref !== normalizeId(fullPath)) {
            if (ref[0] === "#") {
              checkAmbiguosRef(sch, localRefs[ref], ref);
              localRefs[ref] = sch;
            } else {
              this.refs[ref] = fullPath;
            }
          }
          return ref;
        }
        function addAnchor(anchor) {
          if (typeof anchor == "string") {
            if (!ANCHOR.test(anchor))
              throw new Error(`invalid anchor "${anchor}"`);
            addRef.call(this, `#${anchor}`);
          }
        }
      });
      return localRefs;
      function checkAmbiguosRef(sch1, sch2, ref) {
        if (sch2 !== void 0 && !equal(sch1, sch2))
          throw ambiguos(ref);
      }
      function ambiguos(ref) {
        return new Error(`reference "${ref}" resolves to more than one schema`);
      }
    }
    exports2.getSchemaRefs = getSchemaRefs;
  }
});

// node_modules/ajv/dist/compile/validate/index.js
var require_validate = __commonJS({
  "node_modules/ajv/dist/compile/validate/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getData = exports2.KeywordCxt = exports2.validateFunctionCode = void 0;
    var boolSchema_1 = require_boolSchema();
    var dataType_1 = require_dataType();
    var applicability_1 = require_applicability();
    var dataType_2 = require_dataType();
    var defaults_1 = require_defaults();
    var keyword_1 = require_keyword();
    var subschema_1 = require_subschema();
    var codegen_1 = require_codegen();
    var names_1 = require_names();
    var resolve_1 = require_resolve();
    var util_1 = require_util();
    var errors_1 = require_errors();
    function validateFunctionCode(it) {
      if (isSchemaObj(it)) {
        checkKeywords(it);
        if (schemaCxtHasRules(it)) {
          topSchemaObjCode(it);
          return;
        }
      }
      validateFunction(it, () => (0, boolSchema_1.topBoolOrEmptySchema)(it));
    }
    exports2.validateFunctionCode = validateFunctionCode;
    function validateFunction({ gen, validateName, schema, schemaEnv, opts }, body2) {
      if (opts.code.es5) {
        gen.func(validateName, (0, codegen_1._)`${names_1.default.data}, ${names_1.default.valCxt}`, schemaEnv.$async, () => {
          gen.code((0, codegen_1._)`"use strict"; ${funcSourceUrl(schema, opts)}`);
          destructureValCxtES5(gen, opts);
          gen.code(body2);
        });
      } else {
        gen.func(validateName, (0, codegen_1._)`${names_1.default.data}, ${destructureValCxt(opts)}`, schemaEnv.$async, () => gen.code(funcSourceUrl(schema, opts)).code(body2));
      }
    }
    function destructureValCxt(opts) {
      return (0, codegen_1._)`{${names_1.default.instancePath}="", ${names_1.default.parentData}, ${names_1.default.parentDataProperty}, ${names_1.default.rootData}=${names_1.default.data}${opts.dynamicRef ? (0, codegen_1._)`, ${names_1.default.dynamicAnchors}={}` : codegen_1.nil}}={}`;
    }
    function destructureValCxtES5(gen, opts) {
      gen.if(names_1.default.valCxt, () => {
        gen.var(names_1.default.instancePath, (0, codegen_1._)`${names_1.default.valCxt}.${names_1.default.instancePath}`);
        gen.var(names_1.default.parentData, (0, codegen_1._)`${names_1.default.valCxt}.${names_1.default.parentData}`);
        gen.var(names_1.default.parentDataProperty, (0, codegen_1._)`${names_1.default.valCxt}.${names_1.default.parentDataProperty}`);
        gen.var(names_1.default.rootData, (0, codegen_1._)`${names_1.default.valCxt}.${names_1.default.rootData}`);
        if (opts.dynamicRef)
          gen.var(names_1.default.dynamicAnchors, (0, codegen_1._)`${names_1.default.valCxt}.${names_1.default.dynamicAnchors}`);
      }, () => {
        gen.var(names_1.default.instancePath, (0, codegen_1._)`""`);
        gen.var(names_1.default.parentData, (0, codegen_1._)`undefined`);
        gen.var(names_1.default.parentDataProperty, (0, codegen_1._)`undefined`);
        gen.var(names_1.default.rootData, names_1.default.data);
        if (opts.dynamicRef)
          gen.var(names_1.default.dynamicAnchors, (0, codegen_1._)`{}`);
      });
    }
    function topSchemaObjCode(it) {
      const { schema, opts, gen } = it;
      validateFunction(it, () => {
        if (opts.$comment && schema.$comment)
          commentKeyword(it);
        checkNoDefault(it);
        gen.let(names_1.default.vErrors, null);
        gen.let(names_1.default.errors, 0);
        if (opts.unevaluated)
          resetEvaluated(it);
        typeAndKeywords(it);
        returnResults(it);
      });
      return;
    }
    function resetEvaluated(it) {
      const { gen, validateName } = it;
      it.evaluated = gen.const("evaluated", (0, codegen_1._)`${validateName}.evaluated`);
      gen.if((0, codegen_1._)`${it.evaluated}.dynamicProps`, () => gen.assign((0, codegen_1._)`${it.evaluated}.props`, (0, codegen_1._)`undefined`));
      gen.if((0, codegen_1._)`${it.evaluated}.dynamicItems`, () => gen.assign((0, codegen_1._)`${it.evaluated}.items`, (0, codegen_1._)`undefined`));
    }
    function funcSourceUrl(schema, opts) {
      const schId = typeof schema == "object" && schema[opts.schemaId];
      return schId && (opts.code.source || opts.code.process) ? (0, codegen_1._)`/*# sourceURL=${schId} */` : codegen_1.nil;
    }
    function subschemaCode(it, valid) {
      if (isSchemaObj(it)) {
        checkKeywords(it);
        if (schemaCxtHasRules(it)) {
          subSchemaObjCode(it, valid);
          return;
        }
      }
      (0, boolSchema_1.boolOrEmptySchema)(it, valid);
    }
    function schemaCxtHasRules({ schema, self: self2 }) {
      if (typeof schema == "boolean")
        return !schema;
      for (const key in schema)
        if (self2.RULES.all[key])
          return true;
      return false;
    }
    function isSchemaObj(it) {
      return typeof it.schema != "boolean";
    }
    function subSchemaObjCode(it, valid) {
      const { schema, gen, opts } = it;
      if (opts.$comment && schema.$comment)
        commentKeyword(it);
      updateContext(it);
      checkAsyncSchema(it);
      const errsCount = gen.const("_errs", names_1.default.errors);
      typeAndKeywords(it, errsCount);
      gen.var(valid, (0, codegen_1._)`${errsCount} === ${names_1.default.errors}`);
    }
    function checkKeywords(it) {
      (0, util_1.checkUnknownRules)(it);
      checkRefsAndKeywords(it);
    }
    function typeAndKeywords(it, errsCount) {
      if (it.opts.jtd)
        return schemaKeywords(it, [], false, errsCount);
      const types2 = (0, dataType_1.getSchemaTypes)(it.schema);
      const checkedTypes = (0, dataType_1.coerceAndCheckDataType)(it, types2);
      schemaKeywords(it, types2, !checkedTypes, errsCount);
    }
    function checkRefsAndKeywords(it) {
      const { schema, errSchemaPath, opts, self: self2 } = it;
      if (schema.$ref && opts.ignoreKeywordsWithRef && (0, util_1.schemaHasRulesButRef)(schema, self2.RULES)) {
        self2.logger.warn(`$ref: keywords ignored in schema at path "${errSchemaPath}"`);
      }
    }
    function checkNoDefault(it) {
      const { schema, opts } = it;
      if (schema.default !== void 0 && opts.useDefaults && opts.strictSchema) {
        (0, util_1.checkStrictMode)(it, "default is ignored in the schema root");
      }
    }
    function updateContext(it) {
      const schId = it.schema[it.opts.schemaId];
      if (schId)
        it.baseId = (0, resolve_1.resolveUrl)(it.opts.uriResolver, it.baseId, schId);
    }
    function checkAsyncSchema(it) {
      if (it.schema.$async && !it.schemaEnv.$async)
        throw new Error("async schema in sync schema");
    }
    function commentKeyword({ gen, schemaEnv, schema, errSchemaPath, opts }) {
      const msg = schema.$comment;
      if (opts.$comment === true) {
        gen.code((0, codegen_1._)`${names_1.default.self}.logger.log(${msg})`);
      } else if (typeof opts.$comment == "function") {
        const schemaPath = (0, codegen_1.str)`${errSchemaPath}/$comment`;
        const rootName = gen.scopeValue("root", { ref: schemaEnv.root });
        gen.code((0, codegen_1._)`${names_1.default.self}.opts.$comment(${msg}, ${schemaPath}, ${rootName}.schema)`);
      }
    }
    function returnResults(it) {
      const { gen, schemaEnv, validateName, ValidationError, opts } = it;
      if (schemaEnv.$async) {
        gen.if((0, codegen_1._)`${names_1.default.errors} === 0`, () => gen.return(names_1.default.data), () => gen.throw((0, codegen_1._)`new ${ValidationError}(${names_1.default.vErrors})`));
      } else {
        gen.assign((0, codegen_1._)`${validateName}.errors`, names_1.default.vErrors);
        if (opts.unevaluated)
          assignEvaluated(it);
        gen.return((0, codegen_1._)`${names_1.default.errors} === 0`);
      }
    }
    function assignEvaluated({ gen, evaluated, props, items }) {
      if (props instanceof codegen_1.Name)
        gen.assign((0, codegen_1._)`${evaluated}.props`, props);
      if (items instanceof codegen_1.Name)
        gen.assign((0, codegen_1._)`${evaluated}.items`, items);
    }
    function schemaKeywords(it, types2, typeErrors, errsCount) {
      const { gen, schema, data, allErrors, opts, self: self2 } = it;
      const { RULES } = self2;
      if (schema.$ref && (opts.ignoreKeywordsWithRef || !(0, util_1.schemaHasRulesButRef)(schema, RULES))) {
        gen.block(() => keywordCode(it, "$ref", RULES.all.$ref.definition));
        return;
      }
      if (!opts.jtd)
        checkStrictTypes(it, types2);
      gen.block(() => {
        for (const group of RULES.rules)
          groupKeywords(group);
        groupKeywords(RULES.post);
      });
      function groupKeywords(group) {
        if (!(0, applicability_1.shouldUseGroup)(schema, group))
          return;
        if (group.type) {
          gen.if((0, dataType_2.checkDataType)(group.type, data, opts.strictNumbers));
          iterateKeywords(it, group);
          if (types2.length === 1 && types2[0] === group.type && typeErrors) {
            gen.else();
            (0, dataType_2.reportTypeError)(it);
          }
          gen.endIf();
        } else {
          iterateKeywords(it, group);
        }
        if (!allErrors)
          gen.if((0, codegen_1._)`${names_1.default.errors} === ${errsCount || 0}`);
      }
    }
    function iterateKeywords(it, group) {
      const { gen, schema, opts: { useDefaults } } = it;
      if (useDefaults)
        (0, defaults_1.assignDefaults)(it, group.type);
      gen.block(() => {
        for (const rule of group.rules) {
          if ((0, applicability_1.shouldUseRule)(schema, rule)) {
            keywordCode(it, rule.keyword, rule.definition, group.type);
          }
        }
      });
    }
    function checkStrictTypes(it, types2) {
      if (it.schemaEnv.meta || !it.opts.strictTypes)
        return;
      checkContextTypes(it, types2);
      if (!it.opts.allowUnionTypes)
        checkMultipleTypes(it, types2);
      checkKeywordTypes(it, it.dataTypes);
    }
    function checkContextTypes(it, types2) {
      if (!types2.length)
        return;
      if (!it.dataTypes.length) {
        it.dataTypes = types2;
        return;
      }
      types2.forEach((t92) => {
        if (!includesType(it.dataTypes, t92)) {
          strictTypesError(it, `type "${t92}" not allowed by context "${it.dataTypes.join(",")}"`);
        }
      });
      narrowSchemaTypes(it, types2);
    }
    function checkMultipleTypes(it, ts) {
      if (ts.length > 1 && !(ts.length === 2 && ts.includes("null"))) {
        strictTypesError(it, "use allowUnionTypes to allow union type keyword");
      }
    }
    function checkKeywordTypes(it, ts) {
      const rules = it.self.RULES.all;
      for (const keyword in rules) {
        const rule = rules[keyword];
        if (typeof rule == "object" && (0, applicability_1.shouldUseRule)(it.schema, rule)) {
          const { type } = rule.definition;
          if (type.length && !type.some((t92) => hasApplicableType(ts, t92))) {
            strictTypesError(it, `missing type "${type.join(",")}" for keyword "${keyword}"`);
          }
        }
      }
    }
    function hasApplicableType(schTs, kwdT) {
      return schTs.includes(kwdT) || kwdT === "number" && schTs.includes("integer");
    }
    function includesType(ts, t92) {
      return ts.includes(t92) || t92 === "integer" && ts.includes("number");
    }
    function narrowSchemaTypes(it, withTypes) {
      const ts = [];
      for (const t92 of it.dataTypes) {
        if (includesType(withTypes, t92))
          ts.push(t92);
        else if (withTypes.includes("integer") && t92 === "number")
          ts.push("integer");
      }
      it.dataTypes = ts;
    }
    function strictTypesError(it, msg) {
      const schemaPath = it.schemaEnv.baseId + it.errSchemaPath;
      msg += ` at "${schemaPath}" (strictTypes)`;
      (0, util_1.checkStrictMode)(it, msg, it.opts.strictTypes);
    }
    var KeywordCxt = class {
      constructor(it, def, keyword) {
        (0, keyword_1.validateKeywordUsage)(it, def, keyword);
        this.gen = it.gen;
        this.allErrors = it.allErrors;
        this.keyword = keyword;
        this.data = it.data;
        this.schema = it.schema[keyword];
        this.$data = def.$data && it.opts.$data && this.schema && this.schema.$data;
        this.schemaValue = (0, util_1.schemaRefOrVal)(it, this.schema, keyword, this.$data);
        this.schemaType = def.schemaType;
        this.parentSchema = it.schema;
        this.params = {};
        this.it = it;
        this.def = def;
        if (this.$data) {
          this.schemaCode = it.gen.const("vSchema", getData(this.$data, it));
        } else {
          this.schemaCode = this.schemaValue;
          if (!(0, keyword_1.validSchemaType)(this.schema, def.schemaType, def.allowUndefined)) {
            throw new Error(`${keyword} value must be ${JSON.stringify(def.schemaType)}`);
          }
        }
        if ("code" in def ? def.trackErrors : def.errors !== false) {
          this.errsCount = it.gen.const("_errs", names_1.default.errors);
        }
      }
      result(condition, successAction, failAction) {
        this.failResult((0, codegen_1.not)(condition), successAction, failAction);
      }
      failResult(condition, successAction, failAction) {
        this.gen.if(condition);
        if (failAction)
          failAction();
        else
          this.error();
        if (successAction) {
          this.gen.else();
          successAction();
          if (this.allErrors)
            this.gen.endIf();
        } else {
          if (this.allErrors)
            this.gen.endIf();
          else
            this.gen.else();
        }
      }
      pass(condition, failAction) {
        this.failResult((0, codegen_1.not)(condition), void 0, failAction);
      }
      fail(condition) {
        if (condition === void 0) {
          this.error();
          if (!this.allErrors)
            this.gen.if(false);
          return;
        }
        this.gen.if(condition);
        this.error();
        if (this.allErrors)
          this.gen.endIf();
        else
          this.gen.else();
      }
      fail$data(condition) {
        if (!this.$data)
          return this.fail(condition);
        const { schemaCode } = this;
        this.fail((0, codegen_1._)`${schemaCode} !== undefined && (${(0, codegen_1.or)(this.invalid$data(), condition)})`);
      }
      error(append, errorParams, errorPaths) {
        if (errorParams) {
          this.setParams(errorParams);
          this._error(append, errorPaths);
          this.setParams({});
          return;
        }
        this._error(append, errorPaths);
      }
      _error(append, errorPaths) {
        ;
        (append ? errors_1.reportExtraError : errors_1.reportError)(this, this.def.error, errorPaths);
      }
      $dataError() {
        (0, errors_1.reportError)(this, this.def.$dataError || errors_1.keyword$DataError);
      }
      reset() {
        if (this.errsCount === void 0)
          throw new Error('add "trackErrors" to keyword definition');
        (0, errors_1.resetErrorsCount)(this.gen, this.errsCount);
      }
      ok(cond) {
        if (!this.allErrors)
          this.gen.if(cond);
      }
      setParams(obj, assign3) {
        if (assign3)
          Object.assign(this.params, obj);
        else
          this.params = obj;
      }
      block$data(valid, codeBlock, $dataValid = codegen_1.nil) {
        this.gen.block(() => {
          this.check$data(valid, $dataValid);
          codeBlock();
        });
      }
      check$data(valid = codegen_1.nil, $dataValid = codegen_1.nil) {
        if (!this.$data)
          return;
        const { gen, schemaCode, schemaType, def } = this;
        gen.if((0, codegen_1.or)((0, codegen_1._)`${schemaCode} === undefined`, $dataValid));
        if (valid !== codegen_1.nil)
          gen.assign(valid, true);
        if (schemaType.length || def.validateSchema) {
          gen.elseIf(this.invalid$data());
          this.$dataError();
          if (valid !== codegen_1.nil)
            gen.assign(valid, false);
        }
        gen.else();
      }
      invalid$data() {
        const { gen, schemaCode, schemaType, def, it } = this;
        return (0, codegen_1.or)(wrong$DataType(), invalid$DataSchema());
        function wrong$DataType() {
          if (schemaType.length) {
            if (!(schemaCode instanceof codegen_1.Name))
              throw new Error("ajv implementation error");
            const st = Array.isArray(schemaType) ? schemaType : [schemaType];
            return (0, codegen_1._)`${(0, dataType_2.checkDataTypes)(st, schemaCode, it.opts.strictNumbers, dataType_2.DataType.Wrong)}`;
          }
          return codegen_1.nil;
        }
        function invalid$DataSchema() {
          if (def.validateSchema) {
            const validateSchemaRef = gen.scopeValue("validate$data", { ref: def.validateSchema });
            return (0, codegen_1._)`!${validateSchemaRef}(${schemaCode})`;
          }
          return codegen_1.nil;
        }
      }
      subschema(appl, valid) {
        const subschema = (0, subschema_1.getSubschema)(this.it, appl);
        (0, subschema_1.extendSubschemaData)(subschema, this.it, appl);
        (0, subschema_1.extendSubschemaMode)(subschema, appl);
        const nextContext = { ...this.it, ...subschema, items: void 0, props: void 0 };
        subschemaCode(nextContext, valid);
        return nextContext;
      }
      mergeEvaluated(schemaCxt, toName) {
        const { it, gen } = this;
        if (!it.opts.unevaluated)
          return;
        if (it.props !== true && schemaCxt.props !== void 0) {
          it.props = util_1.mergeEvaluated.props(gen, schemaCxt.props, it.props, toName);
        }
        if (it.items !== true && schemaCxt.items !== void 0) {
          it.items = util_1.mergeEvaluated.items(gen, schemaCxt.items, it.items, toName);
        }
      }
      mergeValidEvaluated(schemaCxt, valid) {
        const { it, gen } = this;
        if (it.opts.unevaluated && (it.props !== true || it.items !== true)) {
          gen.if(valid, () => this.mergeEvaluated(schemaCxt, codegen_1.Name));
          return true;
        }
      }
    };
    exports2.KeywordCxt = KeywordCxt;
    function keywordCode(it, keyword, def, ruleType) {
      const cxt = new KeywordCxt(it, def, keyword);
      if ("code" in def) {
        def.code(cxt, ruleType);
      } else if (cxt.$data && def.validate) {
        (0, keyword_1.funcKeywordCode)(cxt, def);
      } else if ("macro" in def) {
        (0, keyword_1.macroKeywordCode)(cxt, def);
      } else if (def.compile || def.validate) {
        (0, keyword_1.funcKeywordCode)(cxt, def);
      }
    }
    var JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
    var RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
    function getData($data, { dataLevel, dataNames, dataPathArr }) {
      let jsonPointer;
      let data;
      if ($data === "")
        return names_1.default.rootData;
      if ($data[0] === "/") {
        if (!JSON_POINTER.test($data))
          throw new Error(`Invalid JSON-pointer: ${$data}`);
        jsonPointer = $data;
        data = names_1.default.rootData;
      } else {
        const matches = RELATIVE_JSON_POINTER.exec($data);
        if (!matches)
          throw new Error(`Invalid JSON-pointer: ${$data}`);
        const up = +matches[1];
        jsonPointer = matches[2];
        if (jsonPointer === "#") {
          if (up >= dataLevel)
            throw new Error(errorMsg("property/index", up));
          return dataPathArr[dataLevel - up];
        }
        if (up > dataLevel)
          throw new Error(errorMsg("data", up));
        data = dataNames[dataLevel - up];
        if (!jsonPointer)
          return data;
      }
      let expr = data;
      const segments = jsonPointer.split("/");
      for (const segment of segments) {
        if (segment) {
          data = (0, codegen_1._)`${data}${(0, codegen_1.getProperty)((0, util_1.unescapeJsonPointer)(segment))}`;
          expr = (0, codegen_1._)`${expr} && ${data}`;
        }
      }
      return expr;
      function errorMsg(pointerType, up) {
        return `Cannot access ${pointerType} ${up} levels up, current level is ${dataLevel}`;
      }
    }
    exports2.getData = getData;
  }
});

// node_modules/ajv/dist/runtime/validation_error.js
var require_validation_error = __commonJS({
  "node_modules/ajv/dist/runtime/validation_error.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var ValidationError = class extends Error {
      constructor(errors2) {
        super("validation failed");
        this.errors = errors2;
        this.ajv = this.validation = true;
      }
    };
    exports2.default = ValidationError;
  }
});

// node_modules/ajv/dist/compile/ref_error.js
var require_ref_error = __commonJS({
  "node_modules/ajv/dist/compile/ref_error.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var resolve_1 = require_resolve();
    var MissingRefError = class extends Error {
      constructor(resolver, baseId, ref, msg) {
        super(msg || `can't resolve reference ${ref} from id ${baseId}`);
        this.missingRef = (0, resolve_1.resolveUrl)(resolver, baseId, ref);
        this.missingSchema = (0, resolve_1.normalizeId)((0, resolve_1.getFullPath)(resolver, this.missingRef));
      }
    };
    exports2.default = MissingRefError;
  }
});

// node_modules/ajv/dist/compile/index.js
var require_compile = __commonJS({
  "node_modules/ajv/dist/compile/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveSchema = exports2.getCompilingSchema = exports2.resolveRef = exports2.compileSchema = exports2.SchemaEnv = void 0;
    var codegen_1 = require_codegen();
    var validation_error_1 = require_validation_error();
    var names_1 = require_names();
    var resolve_1 = require_resolve();
    var util_1 = require_util();
    var validate_1 = require_validate();
    var SchemaEnv = class {
      constructor(env21) {
        var _a17;
        this.refs = {};
        this.dynamicAnchors = {};
        let schema;
        if (typeof env21.schema == "object")
          schema = env21.schema;
        this.schema = env21.schema;
        this.schemaId = env21.schemaId;
        this.root = env21.root || this;
        this.baseId = (_a17 = env21.baseId) !== null && _a17 !== void 0 ? _a17 : (0, resolve_1.normalizeId)(schema === null || schema === void 0 ? void 0 : schema[env21.schemaId || "$id"]);
        this.schemaPath = env21.schemaPath;
        this.localRefs = env21.localRefs;
        this.meta = env21.meta;
        this.$async = schema === null || schema === void 0 ? void 0 : schema.$async;
        this.refs = {};
      }
    };
    exports2.SchemaEnv = SchemaEnv;
    function compileSchema(sch) {
      const _sch = getCompilingSchema.call(this, sch);
      if (_sch)
        return _sch;
      const rootId = (0, resolve_1.getFullPath)(this.opts.uriResolver, sch.root.baseId);
      const { es5, lines } = this.opts.code;
      const { ownProperties } = this.opts;
      const gen = new codegen_1.CodeGen(this.scope, { es5, lines, ownProperties });
      let _ValidationError;
      if (sch.$async) {
        _ValidationError = gen.scopeValue("Error", {
          ref: validation_error_1.default,
          code: (0, codegen_1._)`require("ajv/dist/runtime/validation_error").default`
        });
      }
      const validateName = gen.scopeName("validate");
      sch.validateName = validateName;
      const schemaCxt = {
        gen,
        allErrors: this.opts.allErrors,
        data: names_1.default.data,
        parentData: names_1.default.parentData,
        parentDataProperty: names_1.default.parentDataProperty,
        dataNames: [names_1.default.data],
        dataPathArr: [codegen_1.nil],
        // TODO can its length be used as dataLevel if nil is removed?
        dataLevel: 0,
        dataTypes: [],
        definedProperties: /* @__PURE__ */ new Set(),
        topSchemaRef: gen.scopeValue("schema", this.opts.code.source === true ? { ref: sch.schema, code: (0, codegen_1.stringify)(sch.schema) } : { ref: sch.schema }),
        validateName,
        ValidationError: _ValidationError,
        schema: sch.schema,
        schemaEnv: sch,
        rootId,
        baseId: sch.baseId || rootId,
        schemaPath: codegen_1.nil,
        errSchemaPath: sch.schemaPath || (this.opts.jtd ? "" : "#"),
        errorPath: (0, codegen_1._)`""`,
        opts: this.opts,
        self: this
      };
      let sourceCode;
      try {
        this._compilations.add(sch);
        (0, validate_1.validateFunctionCode)(schemaCxt);
        gen.optimize(this.opts.code.optimize);
        const validateCode = gen.toString();
        sourceCode = `${gen.scopeRefs(names_1.default.scope)}return ${validateCode}`;
        if (this.opts.code.process)
          sourceCode = this.opts.code.process(sourceCode, sch);
        const makeValidate = new Function(`${names_1.default.self}`, `${names_1.default.scope}`, sourceCode);
        const validate = makeValidate(this, this.scope.get());
        this.scope.value(validateName, { ref: validate });
        validate.errors = null;
        validate.schema = sch.schema;
        validate.schemaEnv = sch;
        if (sch.$async)
          validate.$async = true;
        if (this.opts.code.source === true) {
          validate.source = { validateName, validateCode, scopeValues: gen._values };
        }
        if (this.opts.unevaluated) {
          const { props, items } = schemaCxt;
          validate.evaluated = {
            props: props instanceof codegen_1.Name ? void 0 : props,
            items: items instanceof codegen_1.Name ? void 0 : items,
            dynamicProps: props instanceof codegen_1.Name,
            dynamicItems: items instanceof codegen_1.Name
          };
          if (validate.source)
            validate.source.evaluated = (0, codegen_1.stringify)(validate.evaluated);
        }
        sch.validate = validate;
        return sch;
      } catch (e) {
        delete sch.validate;
        delete sch.validateName;
        if (sourceCode)
          this.logger.error("Error compiling schema, function code:", sourceCode);
        throw e;
      } finally {
        this._compilations.delete(sch);
      }
    }
    exports2.compileSchema = compileSchema;
    function resolveRef(root, baseId, ref) {
      var _a17;
      ref = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, ref);
      const schOrFunc = root.refs[ref];
      if (schOrFunc)
        return schOrFunc;
      let _sch = resolve3.call(this, root, ref);
      if (_sch === void 0) {
        const schema = (_a17 = root.localRefs) === null || _a17 === void 0 ? void 0 : _a17[ref];
        const { schemaId } = this.opts;
        if (schema)
          _sch = new SchemaEnv({ schema, schemaId, root, baseId });
      }
      if (_sch === void 0)
        return;
      return root.refs[ref] = inlineOrCompile.call(this, _sch);
    }
    exports2.resolveRef = resolveRef;
    function inlineOrCompile(sch) {
      if ((0, resolve_1.inlineRef)(sch.schema, this.opts.inlineRefs))
        return sch.schema;
      return sch.validate ? sch : compileSchema.call(this, sch);
    }
    function getCompilingSchema(schEnv) {
      for (const sch of this._compilations) {
        if (sameSchemaEnv(sch, schEnv))
          return sch;
      }
    }
    exports2.getCompilingSchema = getCompilingSchema;
    function sameSchemaEnv(s1, s2) {
      return s1.schema === s2.schema && s1.root === s2.root && s1.baseId === s2.baseId;
    }
    function resolve3(root, ref) {
      let sch;
      while (typeof (sch = this.refs[ref]) == "string")
        ref = sch;
      return sch || this.schemas[ref] || resolveSchema.call(this, root, ref);
    }
    function resolveSchema(root, ref) {
      const p2 = this.opts.uriResolver.parse(ref);
      const refPath = (0, resolve_1._getFullPath)(this.opts.uriResolver, p2);
      let baseId = (0, resolve_1.getFullPath)(this.opts.uriResolver, root.baseId, void 0);
      if (Object.keys(root.schema).length > 0 && refPath === baseId) {
        return getJsonPointer.call(this, p2, root);
      }
      const id2 = (0, resolve_1.normalizeId)(refPath);
      const schOrRef = this.refs[id2] || this.schemas[id2];
      if (typeof schOrRef == "string") {
        const sch = resolveSchema.call(this, root, schOrRef);
        if (typeof (sch === null || sch === void 0 ? void 0 : sch.schema) !== "object")
          return;
        return getJsonPointer.call(this, p2, sch);
      }
      if (typeof (schOrRef === null || schOrRef === void 0 ? void 0 : schOrRef.schema) !== "object")
        return;
      if (!schOrRef.validate)
        compileSchema.call(this, schOrRef);
      if (id2 === (0, resolve_1.normalizeId)(ref)) {
        const { schema } = schOrRef;
        const { schemaId } = this.opts;
        const schId = schema[schemaId];
        if (schId)
          baseId = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, schId);
        return new SchemaEnv({ schema, schemaId, root, baseId });
      }
      return getJsonPointer.call(this, p2, schOrRef);
    }
    exports2.resolveSchema = resolveSchema;
    var PREVENT_SCOPE_CHANGE = /* @__PURE__ */ new Set([
      "properties",
      "patternProperties",
      "enum",
      "dependencies",
      "definitions"
    ]);
    function getJsonPointer(parsedRef, { baseId, schema, root }) {
      var _a17;
      if (((_a17 = parsedRef.fragment) === null || _a17 === void 0 ? void 0 : _a17[0]) !== "/")
        return;
      for (const part of parsedRef.fragment.slice(1).split("/")) {
        if (typeof schema === "boolean")
          return;
        const partSchema = schema[(0, util_1.unescapeFragment)(part)];
        if (partSchema === void 0)
          return;
        schema = partSchema;
        const schId = typeof schema === "object" && schema[this.opts.schemaId];
        if (!PREVENT_SCOPE_CHANGE.has(part) && schId) {
          baseId = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, schId);
        }
      }
      let env21;
      if (typeof schema != "boolean" && schema.$ref && !(0, util_1.schemaHasRulesButRef)(schema, this.RULES)) {
        const $ref = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, schema.$ref);
        env21 = resolveSchema.call(this, root, $ref);
      }
      const { schemaId } = this.opts;
      env21 = env21 || new SchemaEnv({ schema, schemaId, root, baseId });
      if (env21.schema !== env21.root.schema)
        return env21;
      return void 0;
    }
  }
});

// node_modules/ajv/dist/refs/data.json
var require_data = __commonJS({
  "node_modules/ajv/dist/refs/data.json"(exports2, module2) {
    module2.exports = {
      $id: "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#",
      description: "Meta-schema for $data reference (JSON AnySchema extension proposal)",
      type: "object",
      required: ["$data"],
      properties: {
        $data: {
          type: "string",
          anyOf: [{ format: "relative-json-pointer" }, { format: "json-pointer" }]
        }
      },
      additionalProperties: false
    };
  }
});

// node_modules/fast-uri/lib/scopedChars.js
var require_scopedChars = __commonJS({
  "node_modules/fast-uri/lib/scopedChars.js"(exports2, module2) {
    "use strict";
    var HEX = {
      0: 0,
      1: 1,
      2: 2,
      3: 3,
      4: 4,
      5: 5,
      6: 6,
      7: 7,
      8: 8,
      9: 9,
      a: 10,
      A: 10,
      b: 11,
      B: 11,
      c: 12,
      C: 12,
      d: 13,
      D: 13,
      e: 14,
      E: 14,
      f: 15,
      F: 15
    };
    module2.exports = {
      HEX
    };
  }
});

// node_modules/fast-uri/lib/utils.js
var require_utils = __commonJS({
  "node_modules/fast-uri/lib/utils.js"(exports2, module2) {
    "use strict";
    var { HEX } = require_scopedChars();
    var IPV4_REG = /^(?:(?:25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.){3}(?:25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)$/u;
    function normalizeIPv4(host) {
      if (findToken(host, ".") < 3) {
        return { host, isIPV4: false };
      }
      const matches = host.match(IPV4_REG) || [];
      const [address] = matches;
      if (address) {
        return { host: stripLeadingZeros(address, "."), isIPV4: true };
      } else {
        return { host, isIPV4: false };
      }
    }
    function stringArrayToHexStripped(input, keepZero = false) {
      let acc = "";
      let strip2 = true;
      for (const c of input) {
        if (HEX[c] === void 0) return void 0;
        if (c !== "0" && strip2 === true) strip2 = false;
        if (!strip2) acc += c;
      }
      if (keepZero && acc.length === 0) acc = "0";
      return acc;
    }
    function getIPV6(input) {
      let tokenCount = 0;
      const output = { error: false, address: "", zone: "" };
      const address = [];
      const buffer = [];
      let isZone = false;
      let endipv6Encountered = false;
      let endIpv6 = false;
      function consume() {
        if (buffer.length) {
          if (isZone === false) {
            const hex = stringArrayToHexStripped(buffer);
            if (hex !== void 0) {
              address.push(hex);
            } else {
              output.error = true;
              return false;
            }
          }
          buffer.length = 0;
        }
        return true;
      }
      for (let i2 = 0; i2 < input.length; i2++) {
        const cursor = input[i2];
        if (cursor === "[" || cursor === "]") {
          continue;
        }
        if (cursor === ":") {
          if (endipv6Encountered === true) {
            endIpv6 = true;
          }
          if (!consume()) {
            break;
          }
          tokenCount++;
          address.push(":");
          if (tokenCount > 7) {
            output.error = true;
            break;
          }
          if (i2 - 1 >= 0 && input[i2 - 1] === ":") {
            endipv6Encountered = true;
          }
          continue;
        } else if (cursor === "%") {
          if (!consume()) {
            break;
          }
          isZone = true;
        } else {
          buffer.push(cursor);
          continue;
        }
      }
      if (buffer.length) {
        if (isZone) {
          output.zone = buffer.join("");
        } else if (endIpv6) {
          address.push(buffer.join(""));
        } else {
          address.push(stringArrayToHexStripped(buffer));
        }
      }
      output.address = address.join("");
      return output;
    }
    function normalizeIPv6(host) {
      if (findToken(host, ":") < 2) {
        return { host, isIPV6: false };
      }
      const ipv6 = getIPV6(host);
      if (!ipv6.error) {
        let newHost = ipv6.address;
        let escapedHost = ipv6.address;
        if (ipv6.zone) {
          newHost += "%" + ipv6.zone;
          escapedHost += "%25" + ipv6.zone;
        }
        return { host: newHost, escapedHost, isIPV6: true };
      } else {
        return { host, isIPV6: false };
      }
    }
    function stripLeadingZeros(str, token) {
      let out2 = "";
      let skip = true;
      const l3 = str.length;
      for (let i2 = 0; i2 < l3; i2++) {
        const c = str[i2];
        if (c === "0" && skip) {
          if (i2 + 1 <= l3 && str[i2 + 1] === token || i2 + 1 === l3) {
            out2 += c;
            skip = false;
          }
        } else {
          if (c === token) {
            skip = true;
          } else {
            skip = false;
          }
          out2 += c;
        }
      }
      return out2;
    }
    function findToken(str, token) {
      let ind = 0;
      for (let i2 = 0; i2 < str.length; i2++) {
        if (str[i2] === token) ind++;
      }
      return ind;
    }
    var RDS1 = /^\.\.?\//u;
    var RDS2 = /^\/\.(?:\/|$)/u;
    var RDS3 = /^\/\.\.(?:\/|$)/u;
    var RDS5 = /^\/?(?:.|\n)*?(?=\/|$)/u;
    function removeDotSegments(input) {
      const output = [];
      while (input.length) {
        if (input.match(RDS1)) {
          input = input.replace(RDS1, "");
        } else if (input.match(RDS2)) {
          input = input.replace(RDS2, "/");
        } else if (input.match(RDS3)) {
          input = input.replace(RDS3, "/");
          output.pop();
        } else if (input === "." || input === "..") {
          input = "";
        } else {
          const im = input.match(RDS5);
          if (im) {
            const s2 = im[0];
            input = input.slice(s2.length);
            output.push(s2);
          } else {
            throw new Error("Unexpected dot segment condition");
          }
        }
      }
      return output.join("");
    }
    function normalizeComponentEncoding(components, esc) {
      const func2 = esc !== true ? escape : unescape;
      if (components.scheme !== void 0) {
        components.scheme = func2(components.scheme);
      }
      if (components.userinfo !== void 0) {
        components.userinfo = func2(components.userinfo);
      }
      if (components.host !== void 0) {
        components.host = func2(components.host);
      }
      if (components.path !== void 0) {
        components.path = func2(components.path);
      }
      if (components.query !== void 0) {
        components.query = func2(components.query);
      }
      if (components.fragment !== void 0) {
        components.fragment = func2(components.fragment);
      }
      return components;
    }
    function recomposeAuthority(components) {
      const uriTokens = [];
      if (components.userinfo !== void 0) {
        uriTokens.push(components.userinfo);
        uriTokens.push("@");
      }
      if (components.host !== void 0) {
        let host = unescape(components.host);
        const ipV4res = normalizeIPv4(host);
        if (ipV4res.isIPV4) {
          host = ipV4res.host;
        } else {
          const ipV6res = normalizeIPv6(ipV4res.host);
          if (ipV6res.isIPV6 === true) {
            host = `[${ipV6res.escapedHost}]`;
          } else {
            host = components.host;
          }
        }
        uriTokens.push(host);
      }
      if (typeof components.port === "number" || typeof components.port === "string") {
        uriTokens.push(":");
        uriTokens.push(String(components.port));
      }
      return uriTokens.length ? uriTokens.join("") : void 0;
    }
    module2.exports = {
      recomposeAuthority,
      normalizeComponentEncoding,
      removeDotSegments,
      normalizeIPv4,
      normalizeIPv6,
      stringArrayToHexStripped
    };
  }
});

// node_modules/fast-uri/lib/schemes.js
var require_schemes = __commonJS({
  "node_modules/fast-uri/lib/schemes.js"(exports2, module2) {
    "use strict";
    var UUID_REG = /^[\da-f]{8}\b-[\da-f]{4}\b-[\da-f]{4}\b-[\da-f]{4}\b-[\da-f]{12}$/iu;
    var URN_REG = /([\da-z][\d\-a-z]{0,31}):((?:[\w!$'()*+,\-.:;=@]|%[\da-f]{2})+)/iu;
    function isSecure(wsComponents) {
      return typeof wsComponents.secure === "boolean" ? wsComponents.secure : String(wsComponents.scheme).toLowerCase() === "wss";
    }
    function httpParse(components) {
      if (!components.host) {
        components.error = components.error || "HTTP URIs must have a host.";
      }
      return components;
    }
    function httpSerialize(components) {
      const secure = String(components.scheme).toLowerCase() === "https";
      if (components.port === (secure ? 443 : 80) || components.port === "") {
        components.port = void 0;
      }
      if (!components.path) {
        components.path = "/";
      }
      return components;
    }
    function wsParse(wsComponents) {
      wsComponents.secure = isSecure(wsComponents);
      wsComponents.resourceName = (wsComponents.path || "/") + (wsComponents.query ? "?" + wsComponents.query : "");
      wsComponents.path = void 0;
      wsComponents.query = void 0;
      return wsComponents;
    }
    function wsSerialize(wsComponents) {
      if (wsComponents.port === (isSecure(wsComponents) ? 443 : 80) || wsComponents.port === "") {
        wsComponents.port = void 0;
      }
      if (typeof wsComponents.secure === "boolean") {
        wsComponents.scheme = wsComponents.secure ? "wss" : "ws";
        wsComponents.secure = void 0;
      }
      if (wsComponents.resourceName) {
        const [path15, query2] = wsComponents.resourceName.split("?");
        wsComponents.path = path15 && path15 !== "/" ? path15 : void 0;
        wsComponents.query = query2;
        wsComponents.resourceName = void 0;
      }
      wsComponents.fragment = void 0;
      return wsComponents;
    }
    function urnParse(urnComponents, options) {
      if (!urnComponents.path) {
        urnComponents.error = "URN can not be parsed";
        return urnComponents;
      }
      const matches = urnComponents.path.match(URN_REG);
      if (matches) {
        const scheme = options.scheme || urnComponents.scheme || "urn";
        urnComponents.nid = matches[1].toLowerCase();
        urnComponents.nss = matches[2];
        const urnScheme = `${scheme}:${options.nid || urnComponents.nid}`;
        const schemeHandler = SCHEMES[urnScheme];
        urnComponents.path = void 0;
        if (schemeHandler) {
          urnComponents = schemeHandler.parse(urnComponents, options);
        }
      } else {
        urnComponents.error = urnComponents.error || "URN can not be parsed.";
      }
      return urnComponents;
    }
    function urnSerialize(urnComponents, options) {
      const scheme = options.scheme || urnComponents.scheme || "urn";
      const nid = urnComponents.nid.toLowerCase();
      const urnScheme = `${scheme}:${options.nid || nid}`;
      const schemeHandler = SCHEMES[urnScheme];
      if (schemeHandler) {
        urnComponents = schemeHandler.serialize(urnComponents, options);
      }
      const uriComponents = urnComponents;
      const nss = urnComponents.nss;
      uriComponents.path = `${nid || options.nid}:${nss}`;
      options.skipEscape = true;
      return uriComponents;
    }
    function urnuuidParse(urnComponents, options) {
      const uuidComponents = urnComponents;
      uuidComponents.uuid = uuidComponents.nss;
      uuidComponents.nss = void 0;
      if (!options.tolerant && (!uuidComponents.uuid || !UUID_REG.test(uuidComponents.uuid))) {
        uuidComponents.error = uuidComponents.error || "UUID is not valid.";
      }
      return uuidComponents;
    }
    function urnuuidSerialize(uuidComponents) {
      const urnComponents = uuidComponents;
      urnComponents.nss = (uuidComponents.uuid || "").toLowerCase();
      return urnComponents;
    }
    var http4 = {
      scheme: "http",
      domainHost: true,
      parse: httpParse,
      serialize: httpSerialize
    };
    var https4 = {
      scheme: "https",
      domainHost: http4.domainHost,
      parse: httpParse,
      serialize: httpSerialize
    };
    var ws = {
      scheme: "ws",
      domainHost: true,
      parse: wsParse,
      serialize: wsSerialize
    };
    var wss = {
      scheme: "wss",
      domainHost: ws.domainHost,
      parse: ws.parse,
      serialize: ws.serialize
    };
    var urn = {
      scheme: "urn",
      parse: urnParse,
      serialize: urnSerialize,
      skipNormalize: true
    };
    var urnuuid = {
      scheme: "urn:uuid",
      parse: urnuuidParse,
      serialize: urnuuidSerialize,
      skipNormalize: true
    };
    var SCHEMES = {
      http: http4,
      https: https4,
      ws,
      wss,
      urn,
      "urn:uuid": urnuuid
    };
    module2.exports = SCHEMES;
  }
});

// node_modules/fast-uri/index.js
var require_fast_uri = __commonJS({
  "node_modules/fast-uri/index.js"(exports2, module2) {
    "use strict";
    var { normalizeIPv6, normalizeIPv4, removeDotSegments, recomposeAuthority, normalizeComponentEncoding } = require_utils();
    var SCHEMES = require_schemes();
    function normalize4(uri, options) {
      if (typeof uri === "string") {
        uri = serialize2(parse9(uri, options), options);
      } else if (typeof uri === "object") {
        uri = parse9(serialize2(uri, options), options);
      }
      return uri;
    }
    function resolve3(baseURI, relativeURI, options) {
      const schemelessOptions = Object.assign({ scheme: "null" }, options);
      const resolved = resolveComponents(parse9(baseURI, schemelessOptions), parse9(relativeURI, schemelessOptions), schemelessOptions, true);
      return serialize2(resolved, { ...schemelessOptions, skipEscape: true });
    }
    function resolveComponents(base2, relative2, options, skipNormalization) {
      const target = {};
      if (!skipNormalization) {
        base2 = parse9(serialize2(base2, options), options);
        relative2 = parse9(serialize2(relative2, options), options);
      }
      options = options || {};
      if (!options.tolerant && relative2.scheme) {
        target.scheme = relative2.scheme;
        target.userinfo = relative2.userinfo;
        target.host = relative2.host;
        target.port = relative2.port;
        target.path = removeDotSegments(relative2.path || "");
        target.query = relative2.query;
      } else {
        if (relative2.userinfo !== void 0 || relative2.host !== void 0 || relative2.port !== void 0) {
          target.userinfo = relative2.userinfo;
          target.host = relative2.host;
          target.port = relative2.port;
          target.path = removeDotSegments(relative2.path || "");
          target.query = relative2.query;
        } else {
          if (!relative2.path) {
            target.path = base2.path;
            if (relative2.query !== void 0) {
              target.query = relative2.query;
            } else {
              target.query = base2.query;
            }
          } else {
            if (relative2.path.charAt(0) === "/") {
              target.path = removeDotSegments(relative2.path);
            } else {
              if ((base2.userinfo !== void 0 || base2.host !== void 0 || base2.port !== void 0) && !base2.path) {
                target.path = "/" + relative2.path;
              } else if (!base2.path) {
                target.path = relative2.path;
              } else {
                target.path = base2.path.slice(0, base2.path.lastIndexOf("/") + 1) + relative2.path;
              }
              target.path = removeDotSegments(target.path);
            }
            target.query = relative2.query;
          }
          target.userinfo = base2.userinfo;
          target.host = base2.host;
          target.port = base2.port;
        }
        target.scheme = base2.scheme;
      }
      target.fragment = relative2.fragment;
      return target;
    }
    function equal(uriA, uriB, options) {
      if (typeof uriA === "string") {
        uriA = unescape(uriA);
        uriA = serialize2(normalizeComponentEncoding(parse9(uriA, options), true), { ...options, skipEscape: true });
      } else if (typeof uriA === "object") {
        uriA = serialize2(normalizeComponentEncoding(uriA, true), { ...options, skipEscape: true });
      }
      if (typeof uriB === "string") {
        uriB = unescape(uriB);
        uriB = serialize2(normalizeComponentEncoding(parse9(uriB, options), true), { ...options, skipEscape: true });
      } else if (typeof uriB === "object") {
        uriB = serialize2(normalizeComponentEncoding(uriB, true), { ...options, skipEscape: true });
      }
      return uriA.toLowerCase() === uriB.toLowerCase();
    }
    function serialize2(cmpts, opts) {
      const components = {
        host: cmpts.host,
        scheme: cmpts.scheme,
        userinfo: cmpts.userinfo,
        port: cmpts.port,
        path: cmpts.path,
        query: cmpts.query,
        nid: cmpts.nid,
        nss: cmpts.nss,
        uuid: cmpts.uuid,
        fragment: cmpts.fragment,
        reference: cmpts.reference,
        resourceName: cmpts.resourceName,
        secure: cmpts.secure,
        error: ""
      };
      const options = Object.assign({}, opts);
      const uriTokens = [];
      const schemeHandler = SCHEMES[(options.scheme || components.scheme || "").toLowerCase()];
      if (schemeHandler && schemeHandler.serialize) schemeHandler.serialize(components, options);
      if (components.path !== void 0) {
        if (!options.skipEscape) {
          components.path = escape(components.path);
          if (components.scheme !== void 0) {
            components.path = components.path.split("%3A").join(":");
          }
        } else {
          components.path = unescape(components.path);
        }
      }
      if (options.reference !== "suffix" && components.scheme) {
        uriTokens.push(components.scheme, ":");
      }
      const authority = recomposeAuthority(components);
      if (authority !== void 0) {
        if (options.reference !== "suffix") {
          uriTokens.push("//");
        }
        uriTokens.push(authority);
        if (components.path && components.path.charAt(0) !== "/") {
          uriTokens.push("/");
        }
      }
      if (components.path !== void 0) {
        let s2 = components.path;
        if (!options.absolutePath && (!schemeHandler || !schemeHandler.absolutePath)) {
          s2 = removeDotSegments(s2);
        }
        if (authority === void 0) {
          s2 = s2.replace(/^\/\//u, "/%2F");
        }
        uriTokens.push(s2);
      }
      if (components.query !== void 0) {
        uriTokens.push("?", components.query);
      }
      if (components.fragment !== void 0) {
        uriTokens.push("#", components.fragment);
      }
      return uriTokens.join("");
    }
    var hexLookUp = Array.from({ length: 127 }, (_v, k) => /[^!"$&'()*+,\-.;=_`a-z{}~]/u.test(String.fromCharCode(k)));
    function nonSimpleDomain(value) {
      let code3 = 0;
      for (let i2 = 0, len = value.length; i2 < len; ++i2) {
        code3 = value.charCodeAt(i2);
        if (code3 > 126 || hexLookUp[code3]) {
          return true;
        }
      }
      return false;
    }
    var URI_PARSE = /^(?:([^#/:?]+):)?(?:\/\/((?:([^#/?@]*)@)?(\[[^#/?\]]+\]|[^#/:?]*)(?::(\d*))?))?([^#?]*)(?:\?([^#]*))?(?:#((?:.|[\n\r])*))?/u;
    function parse9(uri, opts) {
      const options = Object.assign({}, opts);
      const parsed = {
        scheme: void 0,
        userinfo: void 0,
        host: "",
        port: void 0,
        path: "",
        query: void 0,
        fragment: void 0
      };
      const gotEncoding = uri.indexOf("%") !== -1;
      let isIP = false;
      if (options.reference === "suffix") uri = (options.scheme ? options.scheme + ":" : "") + "//" + uri;
      const matches = uri.match(URI_PARSE);
      if (matches) {
        parsed.scheme = matches[1];
        parsed.userinfo = matches[3];
        parsed.host = matches[4];
        parsed.port = parseInt(matches[5], 10);
        parsed.path = matches[6] || "";
        parsed.query = matches[7];
        parsed.fragment = matches[8];
        if (isNaN(parsed.port)) {
          parsed.port = matches[5];
        }
        if (parsed.host) {
          const ipv4result = normalizeIPv4(parsed.host);
          if (ipv4result.isIPV4 === false) {
            const ipv6result = normalizeIPv6(ipv4result.host);
            parsed.host = ipv6result.host.toLowerCase();
            isIP = ipv6result.isIPV6;
          } else {
            parsed.host = ipv4result.host;
            isIP = true;
          }
        }
        if (parsed.scheme === void 0 && parsed.userinfo === void 0 && parsed.host === void 0 && parsed.port === void 0 && !parsed.path && parsed.query === void 0) {
          parsed.reference = "same-document";
        } else if (parsed.scheme === void 0) {
          parsed.reference = "relative";
        } else if (parsed.fragment === void 0) {
          parsed.reference = "absolute";
        } else {
          parsed.reference = "uri";
        }
        if (options.reference && options.reference !== "suffix" && options.reference !== parsed.reference) {
          parsed.error = parsed.error || "URI is not a " + options.reference + " reference.";
        }
        const schemeHandler = SCHEMES[(options.scheme || parsed.scheme || "").toLowerCase()];
        if (!options.unicodeSupport && (!schemeHandler || !schemeHandler.unicodeSupport)) {
          if (parsed.host && (options.domainHost || schemeHandler && schemeHandler.domainHost) && isIP === false && nonSimpleDomain(parsed.host)) {
            try {
              parsed.host = URL.domainToASCII(parsed.host.toLowerCase());
            } catch (e) {
              parsed.error = parsed.error || "Host's domain name can not be converted to ASCII: " + e;
            }
          }
        }
        if (!schemeHandler || schemeHandler && !schemeHandler.skipNormalize) {
          if (gotEncoding && parsed.scheme !== void 0) {
            parsed.scheme = unescape(parsed.scheme);
          }
          if (gotEncoding && parsed.host !== void 0) {
            parsed.host = unescape(parsed.host);
          }
          if (parsed.path && parsed.path.length) {
            parsed.path = escape(unescape(parsed.path));
          }
          if (parsed.fragment && parsed.fragment.length) {
            parsed.fragment = encodeURI(decodeURIComponent(parsed.fragment));
          }
        }
        if (schemeHandler && schemeHandler.parse) {
          schemeHandler.parse(parsed, options);
        }
      } else {
        parsed.error = parsed.error || "URI can not be parsed.";
      }
      return parsed;
    }
    var fastUri = {
      SCHEMES,
      normalize: normalize4,
      resolve: resolve3,
      resolveComponents,
      equal,
      serialize: serialize2,
      parse: parse9
    };
    module2.exports = fastUri;
    module2.exports.default = fastUri;
    module2.exports.fastUri = fastUri;
  }
});

// node_modules/ajv/dist/runtime/uri.js
var require_uri2 = __commonJS({
  "node_modules/ajv/dist/runtime/uri.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var uri = require_fast_uri();
    uri.code = 'require("ajv/dist/runtime/uri").default';
    exports2.default = uri;
  }
});

// node_modules/ajv/dist/core.js
var require_core = __commonJS({
  "node_modules/ajv/dist/core.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CodeGen = exports2.Name = exports2.nil = exports2.stringify = exports2.str = exports2._ = exports2.KeywordCxt = void 0;
    var validate_1 = require_validate();
    Object.defineProperty(exports2, "KeywordCxt", { enumerable: true, get: function() {
      return validate_1.KeywordCxt;
    } });
    var codegen_1 = require_codegen();
    Object.defineProperty(exports2, "_", { enumerable: true, get: function() {
      return codegen_1._;
    } });
    Object.defineProperty(exports2, "str", { enumerable: true, get: function() {
      return codegen_1.str;
    } });
    Object.defineProperty(exports2, "stringify", { enumerable: true, get: function() {
      return codegen_1.stringify;
    } });
    Object.defineProperty(exports2, "nil", { enumerable: true, get: function() {
      return codegen_1.nil;
    } });
    Object.defineProperty(exports2, "Name", { enumerable: true, get: function() {
      return codegen_1.Name;
    } });
    Object.defineProperty(exports2, "CodeGen", { enumerable: true, get: function() {
      return codegen_1.CodeGen;
    } });
    var validation_error_1 = require_validation_error();
    var ref_error_1 = require_ref_error();
    var rules_1 = require_rules();
    var compile_1 = require_compile();
    var codegen_2 = require_codegen();
    var resolve_1 = require_resolve();
    var dataType_1 = require_dataType();
    var util_1 = require_util();
    var $dataRefSchema = require_data();
    var uri_1 = require_uri2();
    var defaultRegExp = (str, flags2) => new RegExp(str, flags2);
    defaultRegExp.code = "new RegExp";
    var META_IGNORE_OPTIONS = ["removeAdditional", "useDefaults", "coerceTypes"];
    var EXT_SCOPE_NAMES = /* @__PURE__ */ new Set([
      "validate",
      "serialize",
      "parse",
      "wrapper",
      "root",
      "schema",
      "keyword",
      "pattern",
      "formats",
      "validate$data",
      "func",
      "obj",
      "Error"
    ]);
    var removedOptions = {
      errorDataPath: "",
      format: "`validateFormats: false` can be used instead.",
      nullable: '"nullable" keyword is supported by default.',
      jsonPointers: "Deprecated jsPropertySyntax can be used instead.",
      extendRefs: "Deprecated ignoreKeywordsWithRef can be used instead.",
      missingRefs: "Pass empty schema with $id that should be ignored to ajv.addSchema.",
      processCode: "Use option `code: {process: (code, schemaEnv: object) => string}`",
      sourceCode: "Use option `code: {source: true}`",
      strictDefaults: "It is default now, see option `strict`.",
      strictKeywords: "It is default now, see option `strict`.",
      uniqueItems: '"uniqueItems" keyword is always validated.',
      unknownFormats: "Disable strict mode or pass `true` to `ajv.addFormat` (or `formats` option).",
      cache: "Map is used as cache, schema object as key.",
      serialize: "Map is used as cache, schema object as key.",
      ajvErrors: "It is default now."
    };
    var deprecatedOptions = {
      ignoreKeywordsWithRef: "",
      jsPropertySyntax: "",
      unicode: '"minLength"/"maxLength" account for unicode characters by default.'
    };
    var MAX_EXPRESSION = 200;
    function requiredOptions(o) {
      var _a17, _b4, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0;
      const s2 = o.strict;
      const _optz = (_a17 = o.code) === null || _a17 === void 0 ? void 0 : _a17.optimize;
      const optimize = _optz === true || _optz === void 0 ? 1 : _optz || 0;
      const regExp = (_c = (_b4 = o.code) === null || _b4 === void 0 ? void 0 : _b4.regExp) !== null && _c !== void 0 ? _c : defaultRegExp;
      const uriResolver = (_d = o.uriResolver) !== null && _d !== void 0 ? _d : uri_1.default;
      return {
        strictSchema: (_f = (_e = o.strictSchema) !== null && _e !== void 0 ? _e : s2) !== null && _f !== void 0 ? _f : true,
        strictNumbers: (_h = (_g = o.strictNumbers) !== null && _g !== void 0 ? _g : s2) !== null && _h !== void 0 ? _h : true,
        strictTypes: (_k = (_j = o.strictTypes) !== null && _j !== void 0 ? _j : s2) !== null && _k !== void 0 ? _k : "log",
        strictTuples: (_m = (_l = o.strictTuples) !== null && _l !== void 0 ? _l : s2) !== null && _m !== void 0 ? _m : "log",
        strictRequired: (_p = (_o = o.strictRequired) !== null && _o !== void 0 ? _o : s2) !== null && _p !== void 0 ? _p : false,
        code: o.code ? { ...o.code, optimize, regExp } : { optimize, regExp },
        loopRequired: (_q = o.loopRequired) !== null && _q !== void 0 ? _q : MAX_EXPRESSION,
        loopEnum: (_r = o.loopEnum) !== null && _r !== void 0 ? _r : MAX_EXPRESSION,
        meta: (_s = o.meta) !== null && _s !== void 0 ? _s : true,
        messages: (_t = o.messages) !== null && _t !== void 0 ? _t : true,
        inlineRefs: (_u = o.inlineRefs) !== null && _u !== void 0 ? _u : true,
        schemaId: (_v = o.schemaId) !== null && _v !== void 0 ? _v : "$id",
        addUsedSchema: (_w = o.addUsedSchema) !== null && _w !== void 0 ? _w : true,
        validateSchema: (_x = o.validateSchema) !== null && _x !== void 0 ? _x : true,
        validateFormats: (_y = o.validateFormats) !== null && _y !== void 0 ? _y : true,
        unicodeRegExp: (_z = o.unicodeRegExp) !== null && _z !== void 0 ? _z : true,
        int32range: (_0 = o.int32range) !== null && _0 !== void 0 ? _0 : true,
        uriResolver
      };
    }
    var Ajv3 = class {
      constructor(opts = {}) {
        this.schemas = {};
        this.refs = {};
        this.formats = {};
        this._compilations = /* @__PURE__ */ new Set();
        this._loading = {};
        this._cache = /* @__PURE__ */ new Map();
        opts = this.opts = { ...opts, ...requiredOptions(opts) };
        const { es5, lines } = this.opts.code;
        this.scope = new codegen_2.ValueScope({ scope: {}, prefixes: EXT_SCOPE_NAMES, es5, lines });
        this.logger = getLogger2(opts.logger);
        const formatOpt = opts.validateFormats;
        opts.validateFormats = false;
        this.RULES = (0, rules_1.getRules)();
        checkOptions.call(this, removedOptions, opts, "NOT SUPPORTED");
        checkOptions.call(this, deprecatedOptions, opts, "DEPRECATED", "warn");
        this._metaOpts = getMetaSchemaOptions.call(this);
        if (opts.formats)
          addInitialFormats.call(this);
        this._addVocabularies();
        this._addDefaultMetaSchema();
        if (opts.keywords)
          addInitialKeywords.call(this, opts.keywords);
        if (typeof opts.meta == "object")
          this.addMetaSchema(opts.meta);
        addInitialSchemas.call(this);
        opts.validateFormats = formatOpt;
      }
      _addVocabularies() {
        this.addKeyword("$async");
      }
      _addDefaultMetaSchema() {
        const { $data, meta, schemaId } = this.opts;
        let _dataRefSchema = $dataRefSchema;
        if (schemaId === "id") {
          _dataRefSchema = { ...$dataRefSchema };
          _dataRefSchema.id = _dataRefSchema.$id;
          delete _dataRefSchema.$id;
        }
        if (meta && $data)
          this.addMetaSchema(_dataRefSchema, _dataRefSchema[schemaId], false);
      }
      defaultMeta() {
        const { meta, schemaId } = this.opts;
        return this.opts.defaultMeta = typeof meta == "object" ? meta[schemaId] || meta : void 0;
      }
      validate(schemaKeyRef, data) {
        let v;
        if (typeof schemaKeyRef == "string") {
          v = this.getSchema(schemaKeyRef);
          if (!v)
            throw new Error(`no schema with key or ref "${schemaKeyRef}"`);
        } else {
          v = this.compile(schemaKeyRef);
        }
        const valid = v(data);
        if (!("$async" in v))
          this.errors = v.errors;
        return valid;
      }
      compile(schema, _meta) {
        const sch = this._addSchema(schema, _meta);
        return sch.validate || this._compileSchemaEnv(sch);
      }
      compileAsync(schema, meta) {
        if (typeof this.opts.loadSchema != "function") {
          throw new Error("options.loadSchema should be a function");
        }
        const { loadSchema } = this.opts;
        return runCompileAsync.call(this, schema, meta);
        async function runCompileAsync(_schema, _meta) {
          await loadMetaSchema.call(this, _schema.$schema);
          const sch = this._addSchema(_schema, _meta);
          return sch.validate || _compileAsync.call(this, sch);
        }
        async function loadMetaSchema($ref) {
          if ($ref && !this.getSchema($ref)) {
            await runCompileAsync.call(this, { $ref }, true);
          }
        }
        async function _compileAsync(sch) {
          try {
            return this._compileSchemaEnv(sch);
          } catch (e) {
            if (!(e instanceof ref_error_1.default))
              throw e;
            checkLoaded.call(this, e);
            await loadMissingSchema.call(this, e.missingSchema);
            return _compileAsync.call(this, sch);
          }
        }
        function checkLoaded({ missingSchema: ref, missingRef }) {
          if (this.refs[ref]) {
            throw new Error(`AnySchema ${ref} is loaded but ${missingRef} cannot be resolved`);
          }
        }
        async function loadMissingSchema(ref) {
          const _schema = await _loadSchema.call(this, ref);
          if (!this.refs[ref])
            await loadMetaSchema.call(this, _schema.$schema);
          if (!this.refs[ref])
            this.addSchema(_schema, ref, meta);
        }
        async function _loadSchema(ref) {
          const p2 = this._loading[ref];
          if (p2)
            return p2;
          try {
            return await (this._loading[ref] = loadSchema(ref));
          } finally {
            delete this._loading[ref];
          }
        }
      }
      // Adds schema to the instance
      addSchema(schema, key, _meta, _validateSchema = this.opts.validateSchema) {
        if (Array.isArray(schema)) {
          for (const sch of schema)
            this.addSchema(sch, void 0, _meta, _validateSchema);
          return this;
        }
        let id2;
        if (typeof schema === "object") {
          const { schemaId } = this.opts;
          id2 = schema[schemaId];
          if (id2 !== void 0 && typeof id2 != "string") {
            throw new Error(`schema ${schemaId} must be string`);
          }
        }
        key = (0, resolve_1.normalizeId)(key || id2);
        this._checkUnique(key);
        this.schemas[key] = this._addSchema(schema, _meta, key, _validateSchema, true);
        return this;
      }
      // Add schema that will be used to validate other schemas
      // options in META_IGNORE_OPTIONS are alway set to false
      addMetaSchema(schema, key, _validateSchema = this.opts.validateSchema) {
        this.addSchema(schema, key, true, _validateSchema);
        return this;
      }
      //  Validate schema against its meta-schema
      validateSchema(schema, throwOrLogError) {
        if (typeof schema == "boolean")
          return true;
        let $schema;
        $schema = schema.$schema;
        if ($schema !== void 0 && typeof $schema != "string") {
          throw new Error("$schema must be a string");
        }
        $schema = $schema || this.opts.defaultMeta || this.defaultMeta();
        if (!$schema) {
          this.logger.warn("meta-schema not available");
          this.errors = null;
          return true;
        }
        const valid = this.validate($schema, schema);
        if (!valid && throwOrLogError) {
          const message = "schema is invalid: " + this.errorsText();
          if (this.opts.validateSchema === "log")
            this.logger.error(message);
          else
            throw new Error(message);
        }
        return valid;
      }
      // Get compiled schema by `key` or `ref`.
      // (`key` that was passed to `addSchema` or full schema reference - `schema.$id` or resolved id)
      getSchema(keyRef) {
        let sch;
        while (typeof (sch = getSchEnv.call(this, keyRef)) == "string")
          keyRef = sch;
        if (sch === void 0) {
          const { schemaId } = this.opts;
          const root = new compile_1.SchemaEnv({ schema: {}, schemaId });
          sch = compile_1.resolveSchema.call(this, root, keyRef);
          if (!sch)
            return;
          this.refs[keyRef] = sch;
        }
        return sch.validate || this._compileSchemaEnv(sch);
      }
      // Remove cached schema(s).
      // If no parameter is passed all schemas but meta-schemas are removed.
      // If RegExp is passed all schemas with key/id matching pattern but meta-schemas are removed.
      // Even if schema is referenced by other schemas it still can be removed as other schemas have local references.
      removeSchema(schemaKeyRef) {
        if (schemaKeyRef instanceof RegExp) {
          this._removeAllSchemas(this.schemas, schemaKeyRef);
          this._removeAllSchemas(this.refs, schemaKeyRef);
          return this;
        }
        switch (typeof schemaKeyRef) {
          case "undefined":
            this._removeAllSchemas(this.schemas);
            this._removeAllSchemas(this.refs);
            this._cache.clear();
            return this;
          case "string": {
            const sch = getSchEnv.call(this, schemaKeyRef);
            if (typeof sch == "object")
              this._cache.delete(sch.schema);
            delete this.schemas[schemaKeyRef];
            delete this.refs[schemaKeyRef];
            return this;
          }
          case "object": {
            const cacheKey = schemaKeyRef;
            this._cache.delete(cacheKey);
            let id2 = schemaKeyRef[this.opts.schemaId];
            if (id2) {
              id2 = (0, resolve_1.normalizeId)(id2);
              delete this.schemas[id2];
              delete this.refs[id2];
            }
            return this;
          }
          default:
            throw new Error("ajv.removeSchema: invalid parameter");
        }
      }
      // add "vocabulary" - a collection of keywords
      addVocabulary(definitions) {
        for (const def of definitions)
          this.addKeyword(def);
        return this;
      }
      addKeyword(kwdOrDef, def) {
        let keyword;
        if (typeof kwdOrDef == "string") {
          keyword = kwdOrDef;
          if (typeof def == "object") {
            this.logger.warn("these parameters are deprecated, see docs for addKeyword");
            def.keyword = keyword;
          }
        } else if (typeof kwdOrDef == "object" && def === void 0) {
          def = kwdOrDef;
          keyword = def.keyword;
          if (Array.isArray(keyword) && !keyword.length) {
            throw new Error("addKeywords: keyword must be string or non-empty array");
          }
        } else {
          throw new Error("invalid addKeywords parameters");
        }
        checkKeyword.call(this, keyword, def);
        if (!def) {
          (0, util_1.eachItem)(keyword, (kwd) => addRule.call(this, kwd));
          return this;
        }
        keywordMetaschema.call(this, def);
        const definition = {
          ...def,
          type: (0, dataType_1.getJSONTypes)(def.type),
          schemaType: (0, dataType_1.getJSONTypes)(def.schemaType)
        };
        (0, util_1.eachItem)(keyword, definition.type.length === 0 ? (k) => addRule.call(this, k, definition) : (k) => definition.type.forEach((t92) => addRule.call(this, k, definition, t92)));
        return this;
      }
      getKeyword(keyword) {
        const rule = this.RULES.all[keyword];
        return typeof rule == "object" ? rule.definition : !!rule;
      }
      // Remove keyword
      removeKeyword(keyword) {
        const { RULES } = this;
        delete RULES.keywords[keyword];
        delete RULES.all[keyword];
        for (const group of RULES.rules) {
          const i2 = group.rules.findIndex((rule) => rule.keyword === keyword);
          if (i2 >= 0)
            group.rules.splice(i2, 1);
        }
        return this;
      }
      // Add format
      addFormat(name3, format4) {
        if (typeof format4 == "string")
          format4 = new RegExp(format4);
        this.formats[name3] = format4;
        return this;
      }
      errorsText(errors2 = this.errors, { separator = ", ", dataVar = "data" } = {}) {
        if (!errors2 || errors2.length === 0)
          return "No errors";
        return errors2.map((e) => `${dataVar}${e.instancePath} ${e.message}`).reduce((text3, msg) => text3 + separator + msg);
      }
      $dataMetaSchema(metaSchema, keywordsJsonPointers) {
        const rules = this.RULES.all;
        metaSchema = JSON.parse(JSON.stringify(metaSchema));
        for (const jsonPointer of keywordsJsonPointers) {
          const segments = jsonPointer.split("/").slice(1);
          let keywords = metaSchema;
          for (const seg of segments)
            keywords = keywords[seg];
          for (const key in rules) {
            const rule = rules[key];
            if (typeof rule != "object")
              continue;
            const { $data } = rule.definition;
            const schema = keywords[key];
            if ($data && schema)
              keywords[key] = schemaOrData(schema);
          }
        }
        return metaSchema;
      }
      _removeAllSchemas(schemas, regex) {
        for (const keyRef in schemas) {
          const sch = schemas[keyRef];
          if (!regex || regex.test(keyRef)) {
            if (typeof sch == "string") {
              delete schemas[keyRef];
            } else if (sch && !sch.meta) {
              this._cache.delete(sch.schema);
              delete schemas[keyRef];
            }
          }
        }
      }
      _addSchema(schema, meta, baseId, validateSchema = this.opts.validateSchema, addSchema = this.opts.addUsedSchema) {
        let id2;
        const { schemaId } = this.opts;
        if (typeof schema == "object") {
          id2 = schema[schemaId];
        } else {
          if (this.opts.jtd)
            throw new Error("schema must be object");
          else if (typeof schema != "boolean")
            throw new Error("schema must be object or boolean");
        }
        let sch = this._cache.get(schema);
        if (sch !== void 0)
          return sch;
        baseId = (0, resolve_1.normalizeId)(id2 || baseId);
        const localRefs = resolve_1.getSchemaRefs.call(this, schema, baseId);
        sch = new compile_1.SchemaEnv({ schema, schemaId, meta, baseId, localRefs });
        this._cache.set(sch.schema, sch);
        if (addSchema && !baseId.startsWith("#")) {
          if (baseId)
            this._checkUnique(baseId);
          this.refs[baseId] = sch;
        }
        if (validateSchema)
          this.validateSchema(schema, true);
        return sch;
      }
      _checkUnique(id2) {
        if (this.schemas[id2] || this.refs[id2]) {
          throw new Error(`schema with key or id "${id2}" already exists`);
        }
      }
      _compileSchemaEnv(sch) {
        if (sch.meta)
          this._compileMetaSchema(sch);
        else
          compile_1.compileSchema.call(this, sch);
        if (!sch.validate)
          throw new Error("ajv implementation error");
        return sch.validate;
      }
      _compileMetaSchema(sch) {
        const currentOpts = this.opts;
        this.opts = this._metaOpts;
        try {
          compile_1.compileSchema.call(this, sch);
        } finally {
          this.opts = currentOpts;
        }
      }
    };
    Ajv3.ValidationError = validation_error_1.default;
    Ajv3.MissingRefError = ref_error_1.default;
    exports2.default = Ajv3;
    function checkOptions(checkOpts, options, msg, log2 = "error") {
      for (const key in checkOpts) {
        const opt = key;
        if (opt in options)
          this.logger[log2](`${msg}: option ${key}. ${checkOpts[opt]}`);
      }
    }
    function getSchEnv(keyRef) {
      keyRef = (0, resolve_1.normalizeId)(keyRef);
      return this.schemas[keyRef] || this.refs[keyRef];
    }
    function addInitialSchemas() {
      const optsSchemas = this.opts.schemas;
      if (!optsSchemas)
        return;
      if (Array.isArray(optsSchemas))
        this.addSchema(optsSchemas);
      else
        for (const key in optsSchemas)
          this.addSchema(optsSchemas[key], key);
    }
    function addInitialFormats() {
      for (const name3 in this.opts.formats) {
        const format4 = this.opts.formats[name3];
        if (format4)
          this.addFormat(name3, format4);
      }
    }
    function addInitialKeywords(defs) {
      if (Array.isArray(defs)) {
        this.addVocabulary(defs);
        return;
      }
      this.logger.warn("keywords option as map is deprecated, pass array");
      for (const keyword in defs) {
        const def = defs[keyword];
        if (!def.keyword)
          def.keyword = keyword;
        this.addKeyword(def);
      }
    }
    function getMetaSchemaOptions() {
      const metaOpts = { ...this.opts };
      for (const opt of META_IGNORE_OPTIONS)
        delete metaOpts[opt];
      return metaOpts;
    }
    var noLogs = { log() {
    }, warn() {
    }, error() {
    } };
    function getLogger2(logger) {
      if (logger === false)
        return noLogs;
      if (logger === void 0)
        return console;
      if (logger.log && logger.warn && logger.error)
        return logger;
      throw new Error("logger must implement log, warn and error methods");
    }
    var KEYWORD_NAME = /^[a-z_$][a-z0-9_$:-]*$/i;
    function checkKeyword(keyword, def) {
      const { RULES } = this;
      (0, util_1.eachItem)(keyword, (kwd) => {
        if (RULES.keywords[kwd])
          throw new Error(`Keyword ${kwd} is already defined`);
        if (!KEYWORD_NAME.test(kwd))
          throw new Error(`Keyword ${kwd} has invalid name`);
      });
      if (!def)
        return;
      if (def.$data && !("code" in def || "validate" in def)) {
        throw new Error('$data keyword must have "code" or "validate" function');
      }
    }
    function addRule(keyword, definition, dataType) {
      var _a17;
      const post = definition === null || definition === void 0 ? void 0 : definition.post;
      if (dataType && post)
        throw new Error('keyword with "post" flag cannot have "type"');
      const { RULES } = this;
      let ruleGroup = post ? RULES.post : RULES.rules.find(({ type: t92 }) => t92 === dataType);
      if (!ruleGroup) {
        ruleGroup = { type: dataType, rules: [] };
        RULES.rules.push(ruleGroup);
      }
      RULES.keywords[keyword] = true;
      if (!definition)
        return;
      const rule = {
        keyword,
        definition: {
          ...definition,
          type: (0, dataType_1.getJSONTypes)(definition.type),
          schemaType: (0, dataType_1.getJSONTypes)(definition.schemaType)
        }
      };
      if (definition.before)
        addBeforeRule.call(this, ruleGroup, rule, definition.before);
      else
        ruleGroup.rules.push(rule);
      RULES.all[keyword] = rule;
      (_a17 = definition.implements) === null || _a17 === void 0 ? void 0 : _a17.forEach((kwd) => this.addKeyword(kwd));
    }
    function addBeforeRule(ruleGroup, rule, before) {
      const i2 = ruleGroup.rules.findIndex((_rule) => _rule.keyword === before);
      if (i2 >= 0) {
        ruleGroup.rules.splice(i2, 0, rule);
      } else {
        ruleGroup.rules.push(rule);
        this.logger.warn(`rule ${before} is not defined`);
      }
    }
    function keywordMetaschema(def) {
      let { metaSchema } = def;
      if (metaSchema === void 0)
        return;
      if (def.$data && this.opts.$data)
        metaSchema = schemaOrData(metaSchema);
      def.validateSchema = this.compile(metaSchema, true);
    }
    var $dataRef = {
      $ref: "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"
    };
    function schemaOrData(schema) {
      return { anyOf: [schema, $dataRef] };
    }
  }
});

// node_modules/ajv/dist/vocabularies/core/id.js
var require_id = __commonJS({
  "node_modules/ajv/dist/vocabularies/core/id.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var def = {
      keyword: "id",
      code() {
        throw new Error('NOT SUPPORTED: keyword "id", use "$id" for schema ID');
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/core/ref.js
var require_ref = __commonJS({
  "node_modules/ajv/dist/vocabularies/core/ref.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.callRef = exports2.getValidate = void 0;
    var ref_error_1 = require_ref_error();
    var code_1 = require_code2();
    var codegen_1 = require_codegen();
    var names_1 = require_names();
    var compile_1 = require_compile();
    var util_1 = require_util();
    var def = {
      keyword: "$ref",
      schemaType: "string",
      code(cxt) {
        const { gen, schema: $ref, it } = cxt;
        const { baseId, schemaEnv: env21, validateName, opts, self: self2 } = it;
        const { root } = env21;
        if (($ref === "#" || $ref === "#/") && baseId === root.baseId)
          return callRootRef();
        const schOrEnv = compile_1.resolveRef.call(self2, root, baseId, $ref);
        if (schOrEnv === void 0)
          throw new ref_error_1.default(it.opts.uriResolver, baseId, $ref);
        if (schOrEnv instanceof compile_1.SchemaEnv)
          return callValidate(schOrEnv);
        return inlineRefSchema(schOrEnv);
        function callRootRef() {
          if (env21 === root)
            return callRef(cxt, validateName, env21, env21.$async);
          const rootName = gen.scopeValue("root", { ref: root });
          return callRef(cxt, (0, codegen_1._)`${rootName}.validate`, root, root.$async);
        }
        function callValidate(sch) {
          const v = getValidate(cxt, sch);
          callRef(cxt, v, sch, sch.$async);
        }
        function inlineRefSchema(sch) {
          const schName = gen.scopeValue("schema", opts.code.source === true ? { ref: sch, code: (0, codegen_1.stringify)(sch) } : { ref: sch });
          const valid = gen.name("valid");
          const schCxt = cxt.subschema({
            schema: sch,
            dataTypes: [],
            schemaPath: codegen_1.nil,
            topSchemaRef: schName,
            errSchemaPath: $ref
          }, valid);
          cxt.mergeEvaluated(schCxt);
          cxt.ok(valid);
        }
      }
    };
    function getValidate(cxt, sch) {
      const { gen } = cxt;
      return sch.validate ? gen.scopeValue("validate", { ref: sch.validate }) : (0, codegen_1._)`${gen.scopeValue("wrapper", { ref: sch })}.validate`;
    }
    exports2.getValidate = getValidate;
    function callRef(cxt, v, sch, $async) {
      const { gen, it } = cxt;
      const { allErrors, schemaEnv: env21, opts } = it;
      const passCxt = opts.passContext ? names_1.default.this : codegen_1.nil;
      if ($async)
        callAsyncRef();
      else
        callSyncRef();
      function callAsyncRef() {
        if (!env21.$async)
          throw new Error("async schema referenced by sync schema");
        const valid = gen.let("valid");
        gen.try(() => {
          gen.code((0, codegen_1._)`await ${(0, code_1.callValidateCode)(cxt, v, passCxt)}`);
          addEvaluatedFrom(v);
          if (!allErrors)
            gen.assign(valid, true);
        }, (e) => {
          gen.if((0, codegen_1._)`!(${e} instanceof ${it.ValidationError})`, () => gen.throw(e));
          addErrorsFrom(e);
          if (!allErrors)
            gen.assign(valid, false);
        });
        cxt.ok(valid);
      }
      function callSyncRef() {
        cxt.result((0, code_1.callValidateCode)(cxt, v, passCxt), () => addEvaluatedFrom(v), () => addErrorsFrom(v));
      }
      function addErrorsFrom(source) {
        const errs = (0, codegen_1._)`${source}.errors`;
        gen.assign(names_1.default.vErrors, (0, codegen_1._)`${names_1.default.vErrors} === null ? ${errs} : ${names_1.default.vErrors}.concat(${errs})`);
        gen.assign(names_1.default.errors, (0, codegen_1._)`${names_1.default.vErrors}.length`);
      }
      function addEvaluatedFrom(source) {
        var _a17;
        if (!it.opts.unevaluated)
          return;
        const schEvaluated = (_a17 = sch === null || sch === void 0 ? void 0 : sch.validate) === null || _a17 === void 0 ? void 0 : _a17.evaluated;
        if (it.props !== true) {
          if (schEvaluated && !schEvaluated.dynamicProps) {
            if (schEvaluated.props !== void 0) {
              it.props = util_1.mergeEvaluated.props(gen, schEvaluated.props, it.props);
            }
          } else {
            const props = gen.var("props", (0, codegen_1._)`${source}.evaluated.props`);
            it.props = util_1.mergeEvaluated.props(gen, props, it.props, codegen_1.Name);
          }
        }
        if (it.items !== true) {
          if (schEvaluated && !schEvaluated.dynamicItems) {
            if (schEvaluated.items !== void 0) {
              it.items = util_1.mergeEvaluated.items(gen, schEvaluated.items, it.items);
            }
          } else {
            const items = gen.var("items", (0, codegen_1._)`${source}.evaluated.items`);
            it.items = util_1.mergeEvaluated.items(gen, items, it.items, codegen_1.Name);
          }
        }
      }
    }
    exports2.callRef = callRef;
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/core/index.js
var require_core2 = __commonJS({
  "node_modules/ajv/dist/vocabularies/core/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var id_1 = require_id();
    var ref_1 = require_ref();
    var core = [
      "$schema",
      "$id",
      "$defs",
      "$vocabulary",
      { keyword: "$comment" },
      "definitions",
      id_1.default,
      ref_1.default
    ];
    exports2.default = core;
  }
});

// node_modules/ajv/dist/vocabularies/validation/limitNumber.js
var require_limitNumber = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/limitNumber.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var ops = codegen_1.operators;
    var KWDs = {
      maximum: { okStr: "<=", ok: ops.LTE, fail: ops.GT },
      minimum: { okStr: ">=", ok: ops.GTE, fail: ops.LT },
      exclusiveMaximum: { okStr: "<", ok: ops.LT, fail: ops.GTE },
      exclusiveMinimum: { okStr: ">", ok: ops.GT, fail: ops.LTE }
    };
    var error2 = {
      message: ({ keyword, schemaCode }) => (0, codegen_1.str)`must be ${KWDs[keyword].okStr} ${schemaCode}`,
      params: ({ keyword, schemaCode }) => (0, codegen_1._)`{comparison: ${KWDs[keyword].okStr}, limit: ${schemaCode}}`
    };
    var def = {
      keyword: Object.keys(KWDs),
      type: "number",
      schemaType: "number",
      $data: true,
      error: error2,
      code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        cxt.fail$data((0, codegen_1._)`${data} ${KWDs[keyword].fail} ${schemaCode} || isNaN(${data})`);
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/validation/multipleOf.js
var require_multipleOf = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/multipleOf.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var error2 = {
      message: ({ schemaCode }) => (0, codegen_1.str)`must be multiple of ${schemaCode}`,
      params: ({ schemaCode }) => (0, codegen_1._)`{multipleOf: ${schemaCode}}`
    };
    var def = {
      keyword: "multipleOf",
      type: "number",
      schemaType: "number",
      $data: true,
      error: error2,
      code(cxt) {
        const { gen, data, schemaCode, it } = cxt;
        const prec = it.opts.multipleOfPrecision;
        const res = gen.let("res");
        const invalid = prec ? (0, codegen_1._)`Math.abs(Math.round(${res}) - ${res}) > 1e-${prec}` : (0, codegen_1._)`${res} !== parseInt(${res})`;
        cxt.fail$data((0, codegen_1._)`(${schemaCode} === 0 || (${res} = ${data}/${schemaCode}, ${invalid}))`);
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/runtime/ucs2length.js
var require_ucs2length = __commonJS({
  "node_modules/ajv/dist/runtime/ucs2length.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    function ucs2length(str) {
      const len = str.length;
      let length = 0;
      let pos2 = 0;
      let value;
      while (pos2 < len) {
        length++;
        value = str.charCodeAt(pos2++);
        if (value >= 55296 && value <= 56319 && pos2 < len) {
          value = str.charCodeAt(pos2);
          if ((value & 64512) === 56320)
            pos2++;
        }
      }
      return length;
    }
    exports2.default = ucs2length;
    ucs2length.code = 'require("ajv/dist/runtime/ucs2length").default';
  }
});

// node_modules/ajv/dist/vocabularies/validation/limitLength.js
var require_limitLength = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/limitLength.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var ucs2length_1 = require_ucs2length();
    var error2 = {
      message({ keyword, schemaCode }) {
        const comp = keyword === "maxLength" ? "more" : "fewer";
        return (0, codegen_1.str)`must NOT have ${comp} than ${schemaCode} characters`;
      },
      params: ({ schemaCode }) => (0, codegen_1._)`{limit: ${schemaCode}}`
    };
    var def = {
      keyword: ["maxLength", "minLength"],
      type: "string",
      schemaType: "number",
      $data: true,
      error: error2,
      code(cxt) {
        const { keyword, data, schemaCode, it } = cxt;
        const op = keyword === "maxLength" ? codegen_1.operators.GT : codegen_1.operators.LT;
        const len = it.opts.unicode === false ? (0, codegen_1._)`${data}.length` : (0, codegen_1._)`${(0, util_1.useFunc)(cxt.gen, ucs2length_1.default)}(${data})`;
        cxt.fail$data((0, codegen_1._)`${len} ${op} ${schemaCode}`);
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/validation/pattern.js
var require_pattern = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/pattern.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var code_1 = require_code2();
    var codegen_1 = require_codegen();
    var error2 = {
      message: ({ schemaCode }) => (0, codegen_1.str)`must match pattern "${schemaCode}"`,
      params: ({ schemaCode }) => (0, codegen_1._)`{pattern: ${schemaCode}}`
    };
    var def = {
      keyword: "pattern",
      type: "string",
      schemaType: "string",
      $data: true,
      error: error2,
      code(cxt) {
        const { data, $data, schema, schemaCode, it } = cxt;
        const u = it.opts.unicodeRegExp ? "u" : "";
        const regExp = $data ? (0, codegen_1._)`(new RegExp(${schemaCode}, ${u}))` : (0, code_1.usePattern)(cxt, schema);
        cxt.fail$data((0, codegen_1._)`!${regExp}.test(${data})`);
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/validation/limitProperties.js
var require_limitProperties = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/limitProperties.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var error2 = {
      message({ keyword, schemaCode }) {
        const comp = keyword === "maxProperties" ? "more" : "fewer";
        return (0, codegen_1.str)`must NOT have ${comp} than ${schemaCode} properties`;
      },
      params: ({ schemaCode }) => (0, codegen_1._)`{limit: ${schemaCode}}`
    };
    var def = {
      keyword: ["maxProperties", "minProperties"],
      type: "object",
      schemaType: "number",
      $data: true,
      error: error2,
      code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        const op = keyword === "maxProperties" ? codegen_1.operators.GT : codegen_1.operators.LT;
        cxt.fail$data((0, codegen_1._)`Object.keys(${data}).length ${op} ${schemaCode}`);
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/validation/required.js
var require_required = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/required.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var code_1 = require_code2();
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var error2 = {
      message: ({ params: { missingProperty } }) => (0, codegen_1.str)`must have required property '${missingProperty}'`,
      params: ({ params: { missingProperty } }) => (0, codegen_1._)`{missingProperty: ${missingProperty}}`
    };
    var def = {
      keyword: "required",
      type: "object",
      schemaType: "array",
      $data: true,
      error: error2,
      code(cxt) {
        const { gen, schema, schemaCode, data, $data, it } = cxt;
        const { opts } = it;
        if (!$data && schema.length === 0)
          return;
        const useLoop = schema.length >= opts.loopRequired;
        if (it.allErrors)
          allErrorsMode();
        else
          exitOnErrorMode();
        if (opts.strictRequired) {
          const props = cxt.parentSchema.properties;
          const { definedProperties } = cxt.it;
          for (const requiredKey of schema) {
            if ((props === null || props === void 0 ? void 0 : props[requiredKey]) === void 0 && !definedProperties.has(requiredKey)) {
              const schemaPath = it.schemaEnv.baseId + it.errSchemaPath;
              const msg = `required property "${requiredKey}" is not defined at "${schemaPath}" (strictRequired)`;
              (0, util_1.checkStrictMode)(it, msg, it.opts.strictRequired);
            }
          }
        }
        function allErrorsMode() {
          if (useLoop || $data) {
            cxt.block$data(codegen_1.nil, loopAllRequired);
          } else {
            for (const prop of schema) {
              (0, code_1.checkReportMissingProp)(cxt, prop);
            }
          }
        }
        function exitOnErrorMode() {
          const missing = gen.let("missing");
          if (useLoop || $data) {
            const valid = gen.let("valid", true);
            cxt.block$data(valid, () => loopUntilMissing(missing, valid));
            cxt.ok(valid);
          } else {
            gen.if((0, code_1.checkMissingProp)(cxt, schema, missing));
            (0, code_1.reportMissingProp)(cxt, missing);
            gen.else();
          }
        }
        function loopAllRequired() {
          gen.forOf("prop", schemaCode, (prop) => {
            cxt.setParams({ missingProperty: prop });
            gen.if((0, code_1.noPropertyInData)(gen, data, prop, opts.ownProperties), () => cxt.error());
          });
        }
        function loopUntilMissing(missing, valid) {
          cxt.setParams({ missingProperty: missing });
          gen.forOf(missing, schemaCode, () => {
            gen.assign(valid, (0, code_1.propertyInData)(gen, data, missing, opts.ownProperties));
            gen.if((0, codegen_1.not)(valid), () => {
              cxt.error();
              gen.break();
            });
          }, codegen_1.nil);
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/validation/limitItems.js
var require_limitItems = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/limitItems.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var error2 = {
      message({ keyword, schemaCode }) {
        const comp = keyword === "maxItems" ? "more" : "fewer";
        return (0, codegen_1.str)`must NOT have ${comp} than ${schemaCode} items`;
      },
      params: ({ schemaCode }) => (0, codegen_1._)`{limit: ${schemaCode}}`
    };
    var def = {
      keyword: ["maxItems", "minItems"],
      type: "array",
      schemaType: "number",
      $data: true,
      error: error2,
      code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        const op = keyword === "maxItems" ? codegen_1.operators.GT : codegen_1.operators.LT;
        cxt.fail$data((0, codegen_1._)`${data}.length ${op} ${schemaCode}`);
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/runtime/equal.js
var require_equal = __commonJS({
  "node_modules/ajv/dist/runtime/equal.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var equal = require_fast_deep_equal();
    equal.code = 'require("ajv/dist/runtime/equal").default';
    exports2.default = equal;
  }
});

// node_modules/ajv/dist/vocabularies/validation/uniqueItems.js
var require_uniqueItems = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/uniqueItems.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var dataType_1 = require_dataType();
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var equal_1 = require_equal();
    var error2 = {
      message: ({ params: { i: i2, j } }) => (0, codegen_1.str)`must NOT have duplicate items (items ## ${j} and ${i2} are identical)`,
      params: ({ params: { i: i2, j } }) => (0, codegen_1._)`{i: ${i2}, j: ${j}}`
    };
    var def = {
      keyword: "uniqueItems",
      type: "array",
      schemaType: "boolean",
      $data: true,
      error: error2,
      code(cxt) {
        const { gen, data, $data, schema, parentSchema, schemaCode, it } = cxt;
        if (!$data && !schema)
          return;
        const valid = gen.let("valid");
        const itemTypes = parentSchema.items ? (0, dataType_1.getSchemaTypes)(parentSchema.items) : [];
        cxt.block$data(valid, validateUniqueItems, (0, codegen_1._)`${schemaCode} === false`);
        cxt.ok(valid);
        function validateUniqueItems() {
          const i2 = gen.let("i", (0, codegen_1._)`${data}.length`);
          const j = gen.let("j");
          cxt.setParams({ i: i2, j });
          gen.assign(valid, true);
          gen.if((0, codegen_1._)`${i2} > 1`, () => (canOptimize() ? loopN : loopN2)(i2, j));
        }
        function canOptimize() {
          return itemTypes.length > 0 && !itemTypes.some((t92) => t92 === "object" || t92 === "array");
        }
        function loopN(i2, j) {
          const item = gen.name("item");
          const wrongType = (0, dataType_1.checkDataTypes)(itemTypes, item, it.opts.strictNumbers, dataType_1.DataType.Wrong);
          const indices = gen.const("indices", (0, codegen_1._)`{}`);
          gen.for((0, codegen_1._)`;${i2}--;`, () => {
            gen.let(item, (0, codegen_1._)`${data}[${i2}]`);
            gen.if(wrongType, (0, codegen_1._)`continue`);
            if (itemTypes.length > 1)
              gen.if((0, codegen_1._)`typeof ${item} == "string"`, (0, codegen_1._)`${item} += "_"`);
            gen.if((0, codegen_1._)`typeof ${indices}[${item}] == "number"`, () => {
              gen.assign(j, (0, codegen_1._)`${indices}[${item}]`);
              cxt.error();
              gen.assign(valid, false).break();
            }).code((0, codegen_1._)`${indices}[${item}] = ${i2}`);
          });
        }
        function loopN2(i2, j) {
          const eql = (0, util_1.useFunc)(gen, equal_1.default);
          const outer = gen.name("outer");
          gen.label(outer).for((0, codegen_1._)`;${i2}--;`, () => gen.for((0, codegen_1._)`${j} = ${i2}; ${j}--;`, () => gen.if((0, codegen_1._)`${eql}(${data}[${i2}], ${data}[${j}])`, () => {
            cxt.error();
            gen.assign(valid, false).break(outer);
          })));
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/validation/const.js
var require_const = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/const.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var equal_1 = require_equal();
    var error2 = {
      message: "must be equal to constant",
      params: ({ schemaCode }) => (0, codegen_1._)`{allowedValue: ${schemaCode}}`
    };
    var def = {
      keyword: "const",
      $data: true,
      error: error2,
      code(cxt) {
        const { gen, data, $data, schemaCode, schema } = cxt;
        if ($data || schema && typeof schema == "object") {
          cxt.fail$data((0, codegen_1._)`!${(0, util_1.useFunc)(gen, equal_1.default)}(${data}, ${schemaCode})`);
        } else {
          cxt.fail((0, codegen_1._)`${schema} !== ${data}`);
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/validation/enum.js
var require_enum = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/enum.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var equal_1 = require_equal();
    var error2 = {
      message: "must be equal to one of the allowed values",
      params: ({ schemaCode }) => (0, codegen_1._)`{allowedValues: ${schemaCode}}`
    };
    var def = {
      keyword: "enum",
      schemaType: "array",
      $data: true,
      error: error2,
      code(cxt) {
        const { gen, data, $data, schema, schemaCode, it } = cxt;
        if (!$data && schema.length === 0)
          throw new Error("enum must have non-empty array");
        const useLoop = schema.length >= it.opts.loopEnum;
        let eql;
        const getEql = () => eql !== null && eql !== void 0 ? eql : eql = (0, util_1.useFunc)(gen, equal_1.default);
        let valid;
        if (useLoop || $data) {
          valid = gen.let("valid");
          cxt.block$data(valid, loopEnum);
        } else {
          if (!Array.isArray(schema))
            throw new Error("ajv implementation error");
          const vSchema = gen.const("vSchema", schemaCode);
          valid = (0, codegen_1.or)(...schema.map((_x, i2) => equalCode(vSchema, i2)));
        }
        cxt.pass(valid);
        function loopEnum() {
          gen.assign(valid, false);
          gen.forOf("v", schemaCode, (v) => gen.if((0, codegen_1._)`${getEql()}(${data}, ${v})`, () => gen.assign(valid, true).break()));
        }
        function equalCode(vSchema, i2) {
          const sch = schema[i2];
          return typeof sch === "object" && sch !== null ? (0, codegen_1._)`${getEql()}(${data}, ${vSchema}[${i2}])` : (0, codegen_1._)`${data} === ${sch}`;
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/validation/index.js
var require_validation = __commonJS({
  "node_modules/ajv/dist/vocabularies/validation/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var limitNumber_1 = require_limitNumber();
    var multipleOf_1 = require_multipleOf();
    var limitLength_1 = require_limitLength();
    var pattern_1 = require_pattern();
    var limitProperties_1 = require_limitProperties();
    var required_1 = require_required();
    var limitItems_1 = require_limitItems();
    var uniqueItems_1 = require_uniqueItems();
    var const_1 = require_const();
    var enum_1 = require_enum();
    var validation = [
      // number
      limitNumber_1.default,
      multipleOf_1.default,
      // string
      limitLength_1.default,
      pattern_1.default,
      // object
      limitProperties_1.default,
      required_1.default,
      // array
      limitItems_1.default,
      uniqueItems_1.default,
      // any
      { keyword: "type", schemaType: ["string", "array"] },
      { keyword: "nullable", schemaType: "boolean" },
      const_1.default,
      enum_1.default
    ];
    exports2.default = validation;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/additionalItems.js
var require_additionalItems = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/additionalItems.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.validateAdditionalItems = void 0;
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var error2 = {
      message: ({ params: { len } }) => (0, codegen_1.str)`must NOT have more than ${len} items`,
      params: ({ params: { len } }) => (0, codegen_1._)`{limit: ${len}}`
    };
    var def = {
      keyword: "additionalItems",
      type: "array",
      schemaType: ["boolean", "object"],
      before: "uniqueItems",
      error: error2,
      code(cxt) {
        const { parentSchema, it } = cxt;
        const { items } = parentSchema;
        if (!Array.isArray(items)) {
          (0, util_1.checkStrictMode)(it, '"additionalItems" is ignored when "items" is not an array of schemas');
          return;
        }
        validateAdditionalItems(cxt, items);
      }
    };
    function validateAdditionalItems(cxt, items) {
      const { gen, schema, data, keyword, it } = cxt;
      it.items = true;
      const len = gen.const("len", (0, codegen_1._)`${data}.length`);
      if (schema === false) {
        cxt.setParams({ len: items.length });
        cxt.pass((0, codegen_1._)`${len} <= ${items.length}`);
      } else if (typeof schema == "object" && !(0, util_1.alwaysValidSchema)(it, schema)) {
        const valid = gen.var("valid", (0, codegen_1._)`${len} <= ${items.length}`);
        gen.if((0, codegen_1.not)(valid), () => validateItems(valid));
        cxt.ok(valid);
      }
      function validateItems(valid) {
        gen.forRange("i", items.length, len, (i2) => {
          cxt.subschema({ keyword, dataProp: i2, dataPropType: util_1.Type.Num }, valid);
          if (!it.allErrors)
            gen.if((0, codegen_1.not)(valid), () => gen.break());
        });
      }
    }
    exports2.validateAdditionalItems = validateAdditionalItems;
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/items.js
var require_items = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/items.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.validateTuple = void 0;
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var code_1 = require_code2();
    var def = {
      keyword: "items",
      type: "array",
      schemaType: ["object", "array", "boolean"],
      before: "uniqueItems",
      code(cxt) {
        const { schema, it } = cxt;
        if (Array.isArray(schema))
          return validateTuple(cxt, "additionalItems", schema);
        it.items = true;
        if ((0, util_1.alwaysValidSchema)(it, schema))
          return;
        cxt.ok((0, code_1.validateArray)(cxt));
      }
    };
    function validateTuple(cxt, extraItems, schArr = cxt.schema) {
      const { gen, parentSchema, data, keyword, it } = cxt;
      checkStrictTuple(parentSchema);
      if (it.opts.unevaluated && schArr.length && it.items !== true) {
        it.items = util_1.mergeEvaluated.items(gen, schArr.length, it.items);
      }
      const valid = gen.name("valid");
      const len = gen.const("len", (0, codegen_1._)`${data}.length`);
      schArr.forEach((sch, i2) => {
        if ((0, util_1.alwaysValidSchema)(it, sch))
          return;
        gen.if((0, codegen_1._)`${len} > ${i2}`, () => cxt.subschema({
          keyword,
          schemaProp: i2,
          dataProp: i2
        }, valid));
        cxt.ok(valid);
      });
      function checkStrictTuple(sch) {
        const { opts, errSchemaPath } = it;
        const l3 = schArr.length;
        const fullTuple = l3 === sch.minItems && (l3 === sch.maxItems || sch[extraItems] === false);
        if (opts.strictTuples && !fullTuple) {
          const msg = `"${keyword}" is ${l3}-tuple, but minItems or maxItems/${extraItems} are not specified or different at path "${errSchemaPath}"`;
          (0, util_1.checkStrictMode)(it, msg, opts.strictTuples);
        }
      }
    }
    exports2.validateTuple = validateTuple;
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/prefixItems.js
var require_prefixItems = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/prefixItems.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var items_1 = require_items();
    var def = {
      keyword: "prefixItems",
      type: "array",
      schemaType: ["array"],
      before: "uniqueItems",
      code: (cxt) => (0, items_1.validateTuple)(cxt, "items")
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/items2020.js
var require_items2020 = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/items2020.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var code_1 = require_code2();
    var additionalItems_1 = require_additionalItems();
    var error2 = {
      message: ({ params: { len } }) => (0, codegen_1.str)`must NOT have more than ${len} items`,
      params: ({ params: { len } }) => (0, codegen_1._)`{limit: ${len}}`
    };
    var def = {
      keyword: "items",
      type: "array",
      schemaType: ["object", "boolean"],
      before: "uniqueItems",
      error: error2,
      code(cxt) {
        const { schema, parentSchema, it } = cxt;
        const { prefixItems } = parentSchema;
        it.items = true;
        if ((0, util_1.alwaysValidSchema)(it, schema))
          return;
        if (prefixItems)
          (0, additionalItems_1.validateAdditionalItems)(cxt, prefixItems);
        else
          cxt.ok((0, code_1.validateArray)(cxt));
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/contains.js
var require_contains = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/contains.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var error2 = {
      message: ({ params: { min: min2, max: max2 } }) => max2 === void 0 ? (0, codegen_1.str)`must contain at least ${min2} valid item(s)` : (0, codegen_1.str)`must contain at least ${min2} and no more than ${max2} valid item(s)`,
      params: ({ params: { min: min2, max: max2 } }) => max2 === void 0 ? (0, codegen_1._)`{minContains: ${min2}}` : (0, codegen_1._)`{minContains: ${min2}, maxContains: ${max2}}`
    };
    var def = {
      keyword: "contains",
      type: "array",
      schemaType: ["object", "boolean"],
      before: "uniqueItems",
      trackErrors: true,
      error: error2,
      code(cxt) {
        const { gen, schema, parentSchema, data, it } = cxt;
        let min2;
        let max2;
        const { minContains, maxContains } = parentSchema;
        if (it.opts.next) {
          min2 = minContains === void 0 ? 1 : minContains;
          max2 = maxContains;
        } else {
          min2 = 1;
        }
        const len = gen.const("len", (0, codegen_1._)`${data}.length`);
        cxt.setParams({ min: min2, max: max2 });
        if (max2 === void 0 && min2 === 0) {
          (0, util_1.checkStrictMode)(it, `"minContains" == 0 without "maxContains": "contains" keyword ignored`);
          return;
        }
        if (max2 !== void 0 && min2 > max2) {
          (0, util_1.checkStrictMode)(it, `"minContains" > "maxContains" is always invalid`);
          cxt.fail();
          return;
        }
        if ((0, util_1.alwaysValidSchema)(it, schema)) {
          let cond = (0, codegen_1._)`${len} >= ${min2}`;
          if (max2 !== void 0)
            cond = (0, codegen_1._)`${cond} && ${len} <= ${max2}`;
          cxt.pass(cond);
          return;
        }
        it.items = true;
        const valid = gen.name("valid");
        if (max2 === void 0 && min2 === 1) {
          validateItems(valid, () => gen.if(valid, () => gen.break()));
        } else if (min2 === 0) {
          gen.let(valid, true);
          if (max2 !== void 0)
            gen.if((0, codegen_1._)`${data}.length > 0`, validateItemsWithCount);
        } else {
          gen.let(valid, false);
          validateItemsWithCount();
        }
        cxt.result(valid, () => cxt.reset());
        function validateItemsWithCount() {
          const schValid = gen.name("_valid");
          const count2 = gen.let("count", 0);
          validateItems(schValid, () => gen.if(schValid, () => checkLimits(count2)));
        }
        function validateItems(_valid, block2) {
          gen.forRange("i", 0, len, (i2) => {
            cxt.subschema({
              keyword: "contains",
              dataProp: i2,
              dataPropType: util_1.Type.Num,
              compositeRule: true
            }, _valid);
            block2();
          });
        }
        function checkLimits(count2) {
          gen.code((0, codegen_1._)`${count2}++`);
          if (max2 === void 0) {
            gen.if((0, codegen_1._)`${count2} >= ${min2}`, () => gen.assign(valid, true).break());
          } else {
            gen.if((0, codegen_1._)`${count2} > ${max2}`, () => gen.assign(valid, false).break());
            if (min2 === 1)
              gen.assign(valid, true);
            else
              gen.if((0, codegen_1._)`${count2} >= ${min2}`, () => gen.assign(valid, true));
          }
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/dependencies.js
var require_dependencies = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/dependencies.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.validateSchemaDeps = exports2.validatePropertyDeps = exports2.error = void 0;
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var code_1 = require_code2();
    exports2.error = {
      message: ({ params: { property, depsCount, deps } }) => {
        const property_ies = depsCount === 1 ? "property" : "properties";
        return (0, codegen_1.str)`must have ${property_ies} ${deps} when property ${property} is present`;
      },
      params: ({ params: { property, depsCount, deps, missingProperty } }) => (0, codegen_1._)`{property: ${property},
    missingProperty: ${missingProperty},
    depsCount: ${depsCount},
    deps: ${deps}}`
      // TODO change to reference
    };
    var def = {
      keyword: "dependencies",
      type: "object",
      schemaType: "object",
      error: exports2.error,
      code(cxt) {
        const [propDeps, schDeps] = splitDependencies(cxt);
        validatePropertyDeps(cxt, propDeps);
        validateSchemaDeps(cxt, schDeps);
      }
    };
    function splitDependencies({ schema }) {
      const propertyDeps = {};
      const schemaDeps = {};
      for (const key in schema) {
        if (key === "__proto__")
          continue;
        const deps = Array.isArray(schema[key]) ? propertyDeps : schemaDeps;
        deps[key] = schema[key];
      }
      return [propertyDeps, schemaDeps];
    }
    function validatePropertyDeps(cxt, propertyDeps = cxt.schema) {
      const { gen, data, it } = cxt;
      if (Object.keys(propertyDeps).length === 0)
        return;
      const missing = gen.let("missing");
      for (const prop in propertyDeps) {
        const deps = propertyDeps[prop];
        if (deps.length === 0)
          continue;
        const hasProperty = (0, code_1.propertyInData)(gen, data, prop, it.opts.ownProperties);
        cxt.setParams({
          property: prop,
          depsCount: deps.length,
          deps: deps.join(", ")
        });
        if (it.allErrors) {
          gen.if(hasProperty, () => {
            for (const depProp of deps) {
              (0, code_1.checkReportMissingProp)(cxt, depProp);
            }
          });
        } else {
          gen.if((0, codegen_1._)`${hasProperty} && (${(0, code_1.checkMissingProp)(cxt, deps, missing)})`);
          (0, code_1.reportMissingProp)(cxt, missing);
          gen.else();
        }
      }
    }
    exports2.validatePropertyDeps = validatePropertyDeps;
    function validateSchemaDeps(cxt, schemaDeps = cxt.schema) {
      const { gen, data, keyword, it } = cxt;
      const valid = gen.name("valid");
      for (const prop in schemaDeps) {
        if ((0, util_1.alwaysValidSchema)(it, schemaDeps[prop]))
          continue;
        gen.if(
          (0, code_1.propertyInData)(gen, data, prop, it.opts.ownProperties),
          () => {
            const schCxt = cxt.subschema({ keyword, schemaProp: prop }, valid);
            cxt.mergeValidEvaluated(schCxt, valid);
          },
          () => gen.var(valid, true)
          // TODO var
        );
        cxt.ok(valid);
      }
    }
    exports2.validateSchemaDeps = validateSchemaDeps;
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/propertyNames.js
var require_propertyNames = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/propertyNames.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var error2 = {
      message: "property name must be valid",
      params: ({ params }) => (0, codegen_1._)`{propertyName: ${params.propertyName}}`
    };
    var def = {
      keyword: "propertyNames",
      type: "object",
      schemaType: ["object", "boolean"],
      error: error2,
      code(cxt) {
        const { gen, schema, data, it } = cxt;
        if ((0, util_1.alwaysValidSchema)(it, schema))
          return;
        const valid = gen.name("valid");
        gen.forIn("key", data, (key) => {
          cxt.setParams({ propertyName: key });
          cxt.subschema({
            keyword: "propertyNames",
            data: key,
            dataTypes: ["string"],
            propertyName: key,
            compositeRule: true
          }, valid);
          gen.if((0, codegen_1.not)(valid), () => {
            cxt.error(true);
            if (!it.allErrors)
              gen.break();
          });
        });
        cxt.ok(valid);
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/additionalProperties.js
var require_additionalProperties = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/additionalProperties.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var code_1 = require_code2();
    var codegen_1 = require_codegen();
    var names_1 = require_names();
    var util_1 = require_util();
    var error2 = {
      message: "must NOT have additional properties",
      params: ({ params }) => (0, codegen_1._)`{additionalProperty: ${params.additionalProperty}}`
    };
    var def = {
      keyword: "additionalProperties",
      type: ["object"],
      schemaType: ["boolean", "object"],
      allowUndefined: true,
      trackErrors: true,
      error: error2,
      code(cxt) {
        const { gen, schema, parentSchema, data, errsCount, it } = cxt;
        if (!errsCount)
          throw new Error("ajv implementation error");
        const { allErrors, opts } = it;
        it.props = true;
        if (opts.removeAdditional !== "all" && (0, util_1.alwaysValidSchema)(it, schema))
          return;
        const props = (0, code_1.allSchemaProperties)(parentSchema.properties);
        const patProps = (0, code_1.allSchemaProperties)(parentSchema.patternProperties);
        checkAdditionalProperties();
        cxt.ok((0, codegen_1._)`${errsCount} === ${names_1.default.errors}`);
        function checkAdditionalProperties() {
          gen.forIn("key", data, (key) => {
            if (!props.length && !patProps.length)
              additionalPropertyCode(key);
            else
              gen.if(isAdditional(key), () => additionalPropertyCode(key));
          });
        }
        function isAdditional(key) {
          let definedProp;
          if (props.length > 8) {
            const propsSchema = (0, util_1.schemaRefOrVal)(it, parentSchema.properties, "properties");
            definedProp = (0, code_1.isOwnProperty)(gen, propsSchema, key);
          } else if (props.length) {
            definedProp = (0, codegen_1.or)(...props.map((p2) => (0, codegen_1._)`${key} === ${p2}`));
          } else {
            definedProp = codegen_1.nil;
          }
          if (patProps.length) {
            definedProp = (0, codegen_1.or)(definedProp, ...patProps.map((p2) => (0, codegen_1._)`${(0, code_1.usePattern)(cxt, p2)}.test(${key})`));
          }
          return (0, codegen_1.not)(definedProp);
        }
        function deleteAdditional(key) {
          gen.code((0, codegen_1._)`delete ${data}[${key}]`);
        }
        function additionalPropertyCode(key) {
          if (opts.removeAdditional === "all" || opts.removeAdditional && schema === false) {
            deleteAdditional(key);
            return;
          }
          if (schema === false) {
            cxt.setParams({ additionalProperty: key });
            cxt.error();
            if (!allErrors)
              gen.break();
            return;
          }
          if (typeof schema == "object" && !(0, util_1.alwaysValidSchema)(it, schema)) {
            const valid = gen.name("valid");
            if (opts.removeAdditional === "failing") {
              applyAdditionalSchema(key, valid, false);
              gen.if((0, codegen_1.not)(valid), () => {
                cxt.reset();
                deleteAdditional(key);
              });
            } else {
              applyAdditionalSchema(key, valid);
              if (!allErrors)
                gen.if((0, codegen_1.not)(valid), () => gen.break());
            }
          }
        }
        function applyAdditionalSchema(key, valid, errors2) {
          const subschema = {
            keyword: "additionalProperties",
            dataProp: key,
            dataPropType: util_1.Type.Str
          };
          if (errors2 === false) {
            Object.assign(subschema, {
              compositeRule: true,
              createErrors: false,
              allErrors: false
            });
          }
          cxt.subschema(subschema, valid);
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/properties.js
var require_properties = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/properties.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var validate_1 = require_validate();
    var code_1 = require_code2();
    var util_1 = require_util();
    var additionalProperties_1 = require_additionalProperties();
    var def = {
      keyword: "properties",
      type: "object",
      schemaType: "object",
      code(cxt) {
        const { gen, schema, parentSchema, data, it } = cxt;
        if (it.opts.removeAdditional === "all" && parentSchema.additionalProperties === void 0) {
          additionalProperties_1.default.code(new validate_1.KeywordCxt(it, additionalProperties_1.default, "additionalProperties"));
        }
        const allProps = (0, code_1.allSchemaProperties)(schema);
        for (const prop of allProps) {
          it.definedProperties.add(prop);
        }
        if (it.opts.unevaluated && allProps.length && it.props !== true) {
          it.props = util_1.mergeEvaluated.props(gen, (0, util_1.toHash)(allProps), it.props);
        }
        const properties = allProps.filter((p2) => !(0, util_1.alwaysValidSchema)(it, schema[p2]));
        if (properties.length === 0)
          return;
        const valid = gen.name("valid");
        for (const prop of properties) {
          if (hasDefault(prop)) {
            applyPropertySchema(prop);
          } else {
            gen.if((0, code_1.propertyInData)(gen, data, prop, it.opts.ownProperties));
            applyPropertySchema(prop);
            if (!it.allErrors)
              gen.else().var(valid, true);
            gen.endIf();
          }
          cxt.it.definedProperties.add(prop);
          cxt.ok(valid);
        }
        function hasDefault(prop) {
          return it.opts.useDefaults && !it.compositeRule && schema[prop].default !== void 0;
        }
        function applyPropertySchema(prop) {
          cxt.subschema({
            keyword: "properties",
            schemaProp: prop,
            dataProp: prop
          }, valid);
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/patternProperties.js
var require_patternProperties = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/patternProperties.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var code_1 = require_code2();
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var util_2 = require_util();
    var def = {
      keyword: "patternProperties",
      type: "object",
      schemaType: "object",
      code(cxt) {
        const { gen, schema, data, parentSchema, it } = cxt;
        const { opts } = it;
        const patterns = (0, code_1.allSchemaProperties)(schema);
        const alwaysValidPatterns = patterns.filter((p2) => (0, util_1.alwaysValidSchema)(it, schema[p2]));
        if (patterns.length === 0 || alwaysValidPatterns.length === patterns.length && (!it.opts.unevaluated || it.props === true)) {
          return;
        }
        const checkProperties = opts.strictSchema && !opts.allowMatchingProperties && parentSchema.properties;
        const valid = gen.name("valid");
        if (it.props !== true && !(it.props instanceof codegen_1.Name)) {
          it.props = (0, util_2.evaluatedPropsToName)(gen, it.props);
        }
        const { props } = it;
        validatePatternProperties();
        function validatePatternProperties() {
          for (const pat of patterns) {
            if (checkProperties)
              checkMatchingProperties(pat);
            if (it.allErrors) {
              validateProperties(pat);
            } else {
              gen.var(valid, true);
              validateProperties(pat);
              gen.if(valid);
            }
          }
        }
        function checkMatchingProperties(pat) {
          for (const prop in checkProperties) {
            if (new RegExp(pat).test(prop)) {
              (0, util_1.checkStrictMode)(it, `property ${prop} matches pattern ${pat} (use allowMatchingProperties)`);
            }
          }
        }
        function validateProperties(pat) {
          gen.forIn("key", data, (key) => {
            gen.if((0, codegen_1._)`${(0, code_1.usePattern)(cxt, pat)}.test(${key})`, () => {
              const alwaysValid = alwaysValidPatterns.includes(pat);
              if (!alwaysValid) {
                cxt.subschema({
                  keyword: "patternProperties",
                  schemaProp: pat,
                  dataProp: key,
                  dataPropType: util_2.Type.Str
                }, valid);
              }
              if (it.opts.unevaluated && props !== true) {
                gen.assign((0, codegen_1._)`${props}[${key}]`, true);
              } else if (!alwaysValid && !it.allErrors) {
                gen.if((0, codegen_1.not)(valid), () => gen.break());
              }
            });
          });
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/not.js
var require_not = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/not.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var util_1 = require_util();
    var def = {
      keyword: "not",
      schemaType: ["object", "boolean"],
      trackErrors: true,
      code(cxt) {
        const { gen, schema, it } = cxt;
        if ((0, util_1.alwaysValidSchema)(it, schema)) {
          cxt.fail();
          return;
        }
        const valid = gen.name("valid");
        cxt.subschema({
          keyword: "not",
          compositeRule: true,
          createErrors: false,
          allErrors: false
        }, valid);
        cxt.failResult(valid, () => cxt.reset(), () => cxt.error());
      },
      error: { message: "must NOT be valid" }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/anyOf.js
var require_anyOf = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/anyOf.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var code_1 = require_code2();
    var def = {
      keyword: "anyOf",
      schemaType: "array",
      trackErrors: true,
      code: code_1.validateUnion,
      error: { message: "must match a schema in anyOf" }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/oneOf.js
var require_oneOf = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/oneOf.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var error2 = {
      message: "must match exactly one schema in oneOf",
      params: ({ params }) => (0, codegen_1._)`{passingSchemas: ${params.passing}}`
    };
    var def = {
      keyword: "oneOf",
      schemaType: "array",
      trackErrors: true,
      error: error2,
      code(cxt) {
        const { gen, schema, parentSchema, it } = cxt;
        if (!Array.isArray(schema))
          throw new Error("ajv implementation error");
        if (it.opts.discriminator && parentSchema.discriminator)
          return;
        const schArr = schema;
        const valid = gen.let("valid", false);
        const passing = gen.let("passing", null);
        const schValid = gen.name("_valid");
        cxt.setParams({ passing });
        gen.block(validateOneOf);
        cxt.result(valid, () => cxt.reset(), () => cxt.error(true));
        function validateOneOf() {
          schArr.forEach((sch, i2) => {
            let schCxt;
            if ((0, util_1.alwaysValidSchema)(it, sch)) {
              gen.var(schValid, true);
            } else {
              schCxt = cxt.subschema({
                keyword: "oneOf",
                schemaProp: i2,
                compositeRule: true
              }, schValid);
            }
            if (i2 > 0) {
              gen.if((0, codegen_1._)`${schValid} && ${valid}`).assign(valid, false).assign(passing, (0, codegen_1._)`[${passing}, ${i2}]`).else();
            }
            gen.if(schValid, () => {
              gen.assign(valid, true);
              gen.assign(passing, i2);
              if (schCxt)
                cxt.mergeEvaluated(schCxt, codegen_1.Name);
            });
          });
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/allOf.js
var require_allOf = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/allOf.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var util_1 = require_util();
    var def = {
      keyword: "allOf",
      schemaType: "array",
      code(cxt) {
        const { gen, schema, it } = cxt;
        if (!Array.isArray(schema))
          throw new Error("ajv implementation error");
        const valid = gen.name("valid");
        schema.forEach((sch, i2) => {
          if ((0, util_1.alwaysValidSchema)(it, sch))
            return;
          const schCxt = cxt.subschema({ keyword: "allOf", schemaProp: i2 }, valid);
          cxt.ok(valid);
          cxt.mergeEvaluated(schCxt);
        });
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/if.js
var require_if = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/if.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var util_1 = require_util();
    var error2 = {
      message: ({ params }) => (0, codegen_1.str)`must match "${params.ifClause}" schema`,
      params: ({ params }) => (0, codegen_1._)`{failingKeyword: ${params.ifClause}}`
    };
    var def = {
      keyword: "if",
      schemaType: ["object", "boolean"],
      trackErrors: true,
      error: error2,
      code(cxt) {
        const { gen, parentSchema, it } = cxt;
        if (parentSchema.then === void 0 && parentSchema.else === void 0) {
          (0, util_1.checkStrictMode)(it, '"if" without "then" and "else" is ignored');
        }
        const hasThen = hasSchema(it, "then");
        const hasElse = hasSchema(it, "else");
        if (!hasThen && !hasElse)
          return;
        const valid = gen.let("valid", true);
        const schValid = gen.name("_valid");
        validateIf();
        cxt.reset();
        if (hasThen && hasElse) {
          const ifClause = gen.let("ifClause");
          cxt.setParams({ ifClause });
          gen.if(schValid, validateClause("then", ifClause), validateClause("else", ifClause));
        } else if (hasThen) {
          gen.if(schValid, validateClause("then"));
        } else {
          gen.if((0, codegen_1.not)(schValid), validateClause("else"));
        }
        cxt.pass(valid, () => cxt.error(true));
        function validateIf() {
          const schCxt = cxt.subschema({
            keyword: "if",
            compositeRule: true,
            createErrors: false,
            allErrors: false
          }, schValid);
          cxt.mergeEvaluated(schCxt);
        }
        function validateClause(keyword, ifClause) {
          return () => {
            const schCxt = cxt.subschema({ keyword }, schValid);
            gen.assign(valid, schValid);
            cxt.mergeValidEvaluated(schCxt, valid);
            if (ifClause)
              gen.assign(ifClause, (0, codegen_1._)`${keyword}`);
            else
              cxt.setParams({ ifClause: keyword });
          };
        }
      }
    };
    function hasSchema(it, keyword) {
      const schema = it.schema[keyword];
      return schema !== void 0 && !(0, util_1.alwaysValidSchema)(it, schema);
    }
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/thenElse.js
var require_thenElse = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/thenElse.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var util_1 = require_util();
    var def = {
      keyword: ["then", "else"],
      schemaType: ["object", "boolean"],
      code({ keyword, parentSchema, it }) {
        if (parentSchema.if === void 0)
          (0, util_1.checkStrictMode)(it, `"${keyword}" without "if" is ignored`);
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/applicator/index.js
var require_applicator = __commonJS({
  "node_modules/ajv/dist/vocabularies/applicator/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var additionalItems_1 = require_additionalItems();
    var prefixItems_1 = require_prefixItems();
    var items_1 = require_items();
    var items2020_1 = require_items2020();
    var contains_1 = require_contains();
    var dependencies_1 = require_dependencies();
    var propertyNames_1 = require_propertyNames();
    var additionalProperties_1 = require_additionalProperties();
    var properties_1 = require_properties();
    var patternProperties_1 = require_patternProperties();
    var not_1 = require_not();
    var anyOf_1 = require_anyOf();
    var oneOf_1 = require_oneOf();
    var allOf_1 = require_allOf();
    var if_1 = require_if();
    var thenElse_1 = require_thenElse();
    function getApplicator(draft2020 = false) {
      const applicator = [
        // any
        not_1.default,
        anyOf_1.default,
        oneOf_1.default,
        allOf_1.default,
        if_1.default,
        thenElse_1.default,
        // object
        propertyNames_1.default,
        additionalProperties_1.default,
        dependencies_1.default,
        properties_1.default,
        patternProperties_1.default
      ];
      if (draft2020)
        applicator.push(prefixItems_1.default, items2020_1.default);
      else
        applicator.push(additionalItems_1.default, items_1.default);
      applicator.push(contains_1.default);
      return applicator;
    }
    exports2.default = getApplicator;
  }
});

// node_modules/ajv/dist/vocabularies/format/format.js
var require_format = __commonJS({
  "node_modules/ajv/dist/vocabularies/format/format.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var error2 = {
      message: ({ schemaCode }) => (0, codegen_1.str)`must match format "${schemaCode}"`,
      params: ({ schemaCode }) => (0, codegen_1._)`{format: ${schemaCode}}`
    };
    var def = {
      keyword: "format",
      type: ["number", "string"],
      schemaType: "string",
      $data: true,
      error: error2,
      code(cxt, ruleType) {
        const { gen, data, $data, schema, schemaCode, it } = cxt;
        const { opts, errSchemaPath, schemaEnv, self: self2 } = it;
        if (!opts.validateFormats)
          return;
        if ($data)
          validate$DataFormat();
        else
          validateFormat();
        function validate$DataFormat() {
          const fmts = gen.scopeValue("formats", {
            ref: self2.formats,
            code: opts.code.formats
          });
          const fDef = gen.const("fDef", (0, codegen_1._)`${fmts}[${schemaCode}]`);
          const fType = gen.let("fType");
          const format4 = gen.let("format");
          gen.if((0, codegen_1._)`typeof ${fDef} == "object" && !(${fDef} instanceof RegExp)`, () => gen.assign(fType, (0, codegen_1._)`${fDef}.type || "string"`).assign(format4, (0, codegen_1._)`${fDef}.validate`), () => gen.assign(fType, (0, codegen_1._)`"string"`).assign(format4, fDef));
          cxt.fail$data((0, codegen_1.or)(unknownFmt(), invalidFmt()));
          function unknownFmt() {
            if (opts.strictSchema === false)
              return codegen_1.nil;
            return (0, codegen_1._)`${schemaCode} && !${format4}`;
          }
          function invalidFmt() {
            const callFormat = schemaEnv.$async ? (0, codegen_1._)`(${fDef}.async ? await ${format4}(${data}) : ${format4}(${data}))` : (0, codegen_1._)`${format4}(${data})`;
            const validData = (0, codegen_1._)`(typeof ${format4} == "function" ? ${callFormat} : ${format4}.test(${data}))`;
            return (0, codegen_1._)`${format4} && ${format4} !== true && ${fType} === ${ruleType} && !${validData}`;
          }
        }
        function validateFormat() {
          const formatDef = self2.formats[schema];
          if (!formatDef) {
            unknownFormat();
            return;
          }
          if (formatDef === true)
            return;
          const [fmtType, format4, fmtRef] = getFormat(formatDef);
          if (fmtType === ruleType)
            cxt.pass(validCondition());
          function unknownFormat() {
            if (opts.strictSchema === false) {
              self2.logger.warn(unknownMsg());
              return;
            }
            throw new Error(unknownMsg());
            function unknownMsg() {
              return `unknown format "${schema}" ignored in schema at path "${errSchemaPath}"`;
            }
          }
          function getFormat(fmtDef) {
            const code3 = fmtDef instanceof RegExp ? (0, codegen_1.regexpCode)(fmtDef) : opts.code.formats ? (0, codegen_1._)`${opts.code.formats}${(0, codegen_1.getProperty)(schema)}` : void 0;
            const fmt = gen.scopeValue("formats", { key: schema, ref: fmtDef, code: code3 });
            if (typeof fmtDef == "object" && !(fmtDef instanceof RegExp)) {
              return [fmtDef.type || "string", fmtDef.validate, (0, codegen_1._)`${fmt}.validate`];
            }
            return ["string", fmtDef, fmt];
          }
          function validCondition() {
            if (typeof formatDef == "object" && !(formatDef instanceof RegExp) && formatDef.async) {
              if (!schemaEnv.$async)
                throw new Error("async format in sync schema");
              return (0, codegen_1._)`await ${fmtRef}(${data})`;
            }
            return typeof format4 == "function" ? (0, codegen_1._)`${fmtRef}(${data})` : (0, codegen_1._)`${fmtRef}.test(${data})`;
          }
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/vocabularies/format/index.js
var require_format2 = __commonJS({
  "node_modules/ajv/dist/vocabularies/format/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var format_1 = require_format();
    var format4 = [format_1.default];
    exports2.default = format4;
  }
});

// node_modules/ajv/dist/vocabularies/metadata.js
var require_metadata = __commonJS({
  "node_modules/ajv/dist/vocabularies/metadata.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.contentVocabulary = exports2.metadataVocabulary = void 0;
    exports2.metadataVocabulary = [
      "title",
      "description",
      "default",
      "deprecated",
      "readOnly",
      "writeOnly",
      "examples"
    ];
    exports2.contentVocabulary = [
      "contentMediaType",
      "contentEncoding",
      "contentSchema"
    ];
  }
});

// node_modules/ajv/dist/vocabularies/draft7.js
var require_draft7 = __commonJS({
  "node_modules/ajv/dist/vocabularies/draft7.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var core_1 = require_core2();
    var validation_1 = require_validation();
    var applicator_1 = require_applicator();
    var format_1 = require_format2();
    var metadata_1 = require_metadata();
    var draft7Vocabularies = [
      core_1.default,
      validation_1.default,
      (0, applicator_1.default)(),
      format_1.default,
      metadata_1.metadataVocabulary,
      metadata_1.contentVocabulary
    ];
    exports2.default = draft7Vocabularies;
  }
});

// node_modules/ajv/dist/vocabularies/discriminator/types.js
var require_types2 = __commonJS({
  "node_modules/ajv/dist/vocabularies/discriminator/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DiscrError = void 0;
    var DiscrError;
    (function(DiscrError2) {
      DiscrError2["Tag"] = "tag";
      DiscrError2["Mapping"] = "mapping";
    })(DiscrError || (exports2.DiscrError = DiscrError = {}));
  }
});

// node_modules/ajv/dist/vocabularies/discriminator/index.js
var require_discriminator = __commonJS({
  "node_modules/ajv/dist/vocabularies/discriminator/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var codegen_1 = require_codegen();
    var types_1 = require_types2();
    var compile_1 = require_compile();
    var ref_error_1 = require_ref_error();
    var util_1 = require_util();
    var error2 = {
      message: ({ params: { discrError, tagName } }) => discrError === types_1.DiscrError.Tag ? `tag "${tagName}" must be string` : `value of tag "${tagName}" must be in oneOf`,
      params: ({ params: { discrError, tag, tagName } }) => (0, codegen_1._)`{error: ${discrError}, tag: ${tagName}, tagValue: ${tag}}`
    };
    var def = {
      keyword: "discriminator",
      type: "object",
      schemaType: "object",
      error: error2,
      code(cxt) {
        const { gen, data, schema, parentSchema, it } = cxt;
        const { oneOf } = parentSchema;
        if (!it.opts.discriminator) {
          throw new Error("discriminator: requires discriminator option");
        }
        const tagName = schema.propertyName;
        if (typeof tagName != "string")
          throw new Error("discriminator: requires propertyName");
        if (schema.mapping)
          throw new Error("discriminator: mapping is not supported");
        if (!oneOf)
          throw new Error("discriminator: requires oneOf keyword");
        const valid = gen.let("valid", false);
        const tag = gen.const("tag", (0, codegen_1._)`${data}${(0, codegen_1.getProperty)(tagName)}`);
        gen.if((0, codegen_1._)`typeof ${tag} == "string"`, () => validateMapping(), () => cxt.error(false, { discrError: types_1.DiscrError.Tag, tag, tagName }));
        cxt.ok(valid);
        function validateMapping() {
          const mapping = getMapping();
          gen.if(false);
          for (const tagValue in mapping) {
            gen.elseIf((0, codegen_1._)`${tag} === ${tagValue}`);
            gen.assign(valid, applyTagSchema(mapping[tagValue]));
          }
          gen.else();
          cxt.error(false, { discrError: types_1.DiscrError.Mapping, tag, tagName });
          gen.endIf();
        }
        function applyTagSchema(schemaProp) {
          const _valid = gen.name("valid");
          const schCxt = cxt.subschema({ keyword: "oneOf", schemaProp }, _valid);
          cxt.mergeEvaluated(schCxt, codegen_1.Name);
          return _valid;
        }
        function getMapping() {
          var _a17;
          const oneOfMapping = {};
          const topRequired = hasRequired(parentSchema);
          let tagRequired = true;
          for (let i2 = 0; i2 < oneOf.length; i2++) {
            let sch = oneOf[i2];
            if ((sch === null || sch === void 0 ? void 0 : sch.$ref) && !(0, util_1.schemaHasRulesButRef)(sch, it.self.RULES)) {
              const ref = sch.$ref;
              sch = compile_1.resolveRef.call(it.self, it.schemaEnv.root, it.baseId, ref);
              if (sch instanceof compile_1.SchemaEnv)
                sch = sch.schema;
              if (sch === void 0)
                throw new ref_error_1.default(it.opts.uriResolver, it.baseId, ref);
            }
            const propSch = (_a17 = sch === null || sch === void 0 ? void 0 : sch.properties) === null || _a17 === void 0 ? void 0 : _a17[tagName];
            if (typeof propSch != "object") {
              throw new Error(`discriminator: oneOf subschemas (or referenced schemas) must have "properties/${tagName}"`);
            }
            tagRequired = tagRequired && (topRequired || hasRequired(sch));
            addMappings(propSch, i2);
          }
          if (!tagRequired)
            throw new Error(`discriminator: "${tagName}" must be required`);
          return oneOfMapping;
          function hasRequired({ required }) {
            return Array.isArray(required) && required.includes(tagName);
          }
          function addMappings(sch, i2) {
            if (sch.const) {
              addMapping(sch.const, i2);
            } else if (sch.enum) {
              for (const tagValue of sch.enum) {
                addMapping(tagValue, i2);
              }
            } else {
              throw new Error(`discriminator: "properties/${tagName}" must have "const" or "enum"`);
            }
          }
          function addMapping(tagValue, i2) {
            if (typeof tagValue != "string" || tagValue in oneOfMapping) {
              throw new Error(`discriminator: "${tagName}" values must be unique strings`);
            }
            oneOfMapping[tagValue] = i2;
          }
        }
      }
    };
    exports2.default = def;
  }
});

// node_modules/ajv/dist/refs/json-schema-draft-07.json
var require_json_schema_draft_07 = __commonJS({
  "node_modules/ajv/dist/refs/json-schema-draft-07.json"(exports2, module2) {
    module2.exports = {
      $schema: "http://json-schema.org/draft-07/schema#",
      $id: "http://json-schema.org/draft-07/schema#",
      title: "Core schema meta-schema",
      definitions: {
        schemaArray: {
          type: "array",
          minItems: 1,
          items: { $ref: "#" }
        },
        nonNegativeInteger: {
          type: "integer",
          minimum: 0
        },
        nonNegativeIntegerDefault0: {
          allOf: [{ $ref: "#/definitions/nonNegativeInteger" }, { default: 0 }]
        },
        simpleTypes: {
          enum: ["array", "boolean", "integer", "null", "number", "object", "string"]
        },
        stringArray: {
          type: "array",
          items: { type: "string" },
          uniqueItems: true,
          default: []
        }
      },
      type: ["object", "boolean"],
      properties: {
        $id: {
          type: "string",
          format: "uri-reference"
        },
        $schema: {
          type: "string",
          format: "uri"
        },
        $ref: {
          type: "string",
          format: "uri-reference"
        },
        $comment: {
          type: "string"
        },
        title: {
          type: "string"
        },
        description: {
          type: "string"
        },
        default: true,
        readOnly: {
          type: "boolean",
          default: false
        },
        examples: {
          type: "array",
          items: true
        },
        multipleOf: {
          type: "number",
          exclusiveMinimum: 0
        },
        maximum: {
          type: "number"
        },
        exclusiveMaximum: {
          type: "number"
        },
        minimum: {
          type: "number"
        },
        exclusiveMinimum: {
          type: "number"
        },
        maxLength: { $ref: "#/definitions/nonNegativeInteger" },
        minLength: { $ref: "#/definitions/nonNegativeIntegerDefault0" },
        pattern: {
          type: "string",
          format: "regex"
        },
        additionalItems: { $ref: "#" },
        items: {
          anyOf: [{ $ref: "#" }, { $ref: "#/definitions/schemaArray" }],
          default: true
        },
        maxItems: { $ref: "#/definitions/nonNegativeInteger" },
        minItems: { $ref: "#/definitions/nonNegativeIntegerDefault0" },
        uniqueItems: {
          type: "boolean",
          default: false
        },
        contains: { $ref: "#" },
        maxProperties: { $ref: "#/definitions/nonNegativeInteger" },
        minProperties: { $ref: "#/definitions/nonNegativeIntegerDefault0" },
        required: { $ref: "#/definitions/stringArray" },
        additionalProperties: { $ref: "#" },
        definitions: {
          type: "object",
          additionalProperties: { $ref: "#" },
          default: {}
        },
        properties: {
          type: "object",
          additionalProperties: { $ref: "#" },
          default: {}
        },
        patternProperties: {
          type: "object",
          additionalProperties: { $ref: "#" },
          propertyNames: { format: "regex" },
          default: {}
        },
        dependencies: {
          type: "object",
          additionalProperties: {
            anyOf: [{ $ref: "#" }, { $ref: "#/definitions/stringArray" }]
          }
        },
        propertyNames: { $ref: "#" },
        const: true,
        enum: {
          type: "array",
          items: true,
          minItems: 1,
          uniqueItems: true
        },
        type: {
          anyOf: [
            { $ref: "#/definitions/simpleTypes" },
            {
              type: "array",
              items: { $ref: "#/definitions/simpleTypes" },
              minItems: 1,
              uniqueItems: true
            }
          ]
        },
        format: { type: "string" },
        contentMediaType: { type: "string" },
        contentEncoding: { type: "string" },
        if: { $ref: "#" },
        then: { $ref: "#" },
        else: { $ref: "#" },
        allOf: { $ref: "#/definitions/schemaArray" },
        anyOf: { $ref: "#/definitions/schemaArray" },
        oneOf: { $ref: "#/definitions/schemaArray" },
        not: { $ref: "#" }
      },
      default: true
    };
  }
});

// node_modules/ajv/dist/ajv.js
var require_ajv = __commonJS({
  "node_modules/ajv/dist/ajv.js"(exports2, module2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MissingRefError = exports2.ValidationError = exports2.CodeGen = exports2.Name = exports2.nil = exports2.stringify = exports2.str = exports2._ = exports2.KeywordCxt = exports2.Ajv = void 0;
    var core_1 = require_core();
    var draft7_1 = require_draft7();
    var discriminator_1 = require_discriminator();
    var draft7MetaSchema = require_json_schema_draft_07();
    var META_SUPPORT_DATA = ["/properties"];
    var META_SCHEMA_ID = "http://json-schema.org/draft-07/schema";
    var Ajv3 = class extends core_1.default {
      _addVocabularies() {
        super._addVocabularies();
        draft7_1.default.forEach((v) => this.addVocabulary(v));
        if (this.opts.discriminator)
          this.addKeyword(discriminator_1.default);
      }
      _addDefaultMetaSchema() {
        super._addDefaultMetaSchema();
        if (!this.opts.meta)
          return;
        const metaSchema = this.opts.$data ? this.$dataMetaSchema(draft7MetaSchema, META_SUPPORT_DATA) : draft7MetaSchema;
        this.addMetaSchema(metaSchema, META_SCHEMA_ID, false);
        this.refs["http://json-schema.org/schema"] = META_SCHEMA_ID;
      }
      defaultMeta() {
        return this.opts.defaultMeta = super.defaultMeta() || (this.getSchema(META_SCHEMA_ID) ? META_SCHEMA_ID : void 0);
      }
    };
    exports2.Ajv = Ajv3;
    module2.exports = exports2 = Ajv3;
    module2.exports.Ajv = Ajv3;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.default = Ajv3;
    var validate_1 = require_validate();
    Object.defineProperty(exports2, "KeywordCxt", { enumerable: true, get: function() {
      return validate_1.KeywordCxt;
    } });
    var codegen_1 = require_codegen();
    Object.defineProperty(exports2, "_", { enumerable: true, get: function() {
      return codegen_1._;
    } });
    Object.defineProperty(exports2, "str", { enumerable: true, get: function() {
      return codegen_1.str;
    } });
    Object.defineProperty(exports2, "stringify", { enumerable: true, get: function() {
      return codegen_1.stringify;
    } });
    Object.defineProperty(exports2, "nil", { enumerable: true, get: function() {
      return codegen_1.nil;
    } });
    Object.defineProperty(exports2, "Name", { enumerable: true, get: function() {
      return codegen_1.Name;
    } });
    Object.defineProperty(exports2, "CodeGen", { enumerable: true, get: function() {
      return codegen_1.CodeGen;
    } });
    var validation_error_1 = require_validation_error();
    Object.defineProperty(exports2, "ValidationError", { enumerable: true, get: function() {
      return validation_error_1.default;
    } });
    var ref_error_1 = require_ref_error();
    Object.defineProperty(exports2, "MissingRefError", { enumerable: true, get: function() {
      return ref_error_1.default;
    } });
  }
});

// node_modules/@anthropic-ai/claude-agent-sdk/sdk.mjs
var sdk_exports = {};
__export(sdk_exports, {
  createSdkMcpServer: () => createSdkMcpServer,
  query: () => query,
  tool: () => tool
});
function createAbortController(maxListeners = DEFAULT_MAX_LISTENERS) {
  const controller = new AbortController();
  (0, import_events.setMaxListeners)(maxListeners, controller.signal);
  return controller;
}
function getFsImplementation() {
  return activeFs;
}
function isRunningWithBun() {
  return process.versions.bun !== void 0;
}
function isNativeBinary(executablePath) {
  const jsExtensions = [".js", ".mjs", ".tsx", ".ts", ".jsx"];
  return !jsExtensions.some((ext2) => executablePath.endsWith(ext2));
}
function createSharedQuery({
  prompt,
  options: {
    abortController = createAbortController(),
    additionalDirectories = [],
    agents,
    allowedTools = [],
    appendSystemPrompt,
    canUseTool,
    continue: continueConversation,
    customSystemPrompt,
    cwd: cwd2,
    disallowedTools = [],
    env: env21,
    executable = isRunningWithBun() ? "bun" : "node",
    executableArgs = [],
    extraArgs = {},
    fallbackModel,
    forkSession,
    hooks,
    includePartialMessages,
    maxThinkingTokens,
    maxTurns,
    mcpServers,
    model,
    pathToClaudeCodeExecutable,
    permissionMode = "default",
    permissionPromptToolName,
    resume,
    resumeSessionAt,
    settingSources,
    stderr,
    strictMcpConfig
  } = {}
}) {
  if (!env21) {
    env21 = { ...process.env };
  }
  if (!env21.CLAUDE_CODE_ENTRYPOINT) {
    env21.CLAUDE_CODE_ENTRYPOINT = "sdk-ts";
  }
  if (!pathToClaudeCodeExecutable) {
    throw new Error("pathToClaudeCodeExecutable is required");
  }
  const allMcpServers = {};
  const sdkMcpServers = /* @__PURE__ */ new Map();
  if (mcpServers) {
    for (const [name3, config3] of Object.entries(mcpServers)) {
      if (config3.type === "sdk" && "instance" in config3) {
        sdkMcpServers.set(name3, config3.instance);
        allMcpServers[name3] = {
          type: "sdk",
          name: name3
        };
      } else {
        allMcpServers[name3] = config3;
      }
    }
  }
  const isSingleUserTurn = typeof prompt === "string";
  const transport = new ProcessTransport({
    abortController,
    additionalDirectories,
    agents,
    cwd: cwd2,
    executable,
    executableArgs,
    extraArgs,
    pathToClaudeCodeExecutable,
    env: env21,
    forkSession,
    stderr,
    customSystemPrompt,
    appendSystemPrompt,
    maxThinkingTokens,
    maxTurns,
    model,
    fallbackModel,
    permissionMode,
    permissionPromptToolName,
    continueConversation,
    resume,
    resumeSessionAt,
    settingSources,
    allowedTools,
    disallowedTools,
    mcpServers: allMcpServers,
    strictMcpConfig,
    canUseTool: !!canUseTool,
    hooks: !!hooks,
    includePartialMessages
  });
  const query2 = new Query2(transport, isSingleUserTurn, canUseTool, hooks, abortController, sdkMcpServers);
  if (typeof prompt === "string") {
    transport.write(JSON.stringify({
      type: "user",
      session_id: "",
      message: {
        role: "user",
        content: [{ type: "text", text: prompt }]
      },
      parent_tool_use_id: null
    }) + `
`);
  } else {
    query2.streamInput(prompt);
  }
  return query2;
}
function setErrorMap(map2) {
  overrideErrorMap = map2;
}
function getErrorMap() {
  return overrideErrorMap;
}
function addIssueToContext(ctx, issueData) {
  const overrideMap = getErrorMap();
  const issue = makeIssue({
    issueData,
    data: ctx.data,
    path: ctx.path,
    errorMaps: [
      ctx.common.contextualErrorMap,
      ctx.schemaErrorMap,
      overrideMap,
      overrideMap === en_default ? void 0 : en_default
    ].filter((x) => !!x)
  });
  ctx.common.issues.push(issue);
}
function processCreateParams(params) {
  if (!params)
    return {};
  const { errorMap: errorMap2, invalid_type_error, required_error, description } = params;
  if (errorMap2 && (invalid_type_error || required_error)) {
    throw new Error(`Can't use "invalid_type_error" or "required_error" in conjunction with custom error map.`);
  }
  if (errorMap2)
    return { errorMap: errorMap2, description };
  const customMap = (iss, ctx) => {
    const { message } = params;
    if (iss.code === "invalid_enum_value") {
      return { message: message ?? ctx.defaultError };
    }
    if (typeof ctx.data === "undefined") {
      return { message: message ?? required_error ?? ctx.defaultError };
    }
    if (iss.code !== "invalid_type")
      return { message: ctx.defaultError };
    return { message: message ?? invalid_type_error ?? ctx.defaultError };
  };
  return { errorMap: customMap, description };
}
function timeRegexSource(args2) {
  let secondsRegexSource = `[0-5]\\d`;
  if (args2.precision) {
    secondsRegexSource = `${secondsRegexSource}\\.\\d{${args2.precision}}`;
  } else if (args2.precision == null) {
    secondsRegexSource = `${secondsRegexSource}(\\.\\d+)?`;
  }
  const secondsQuantifier = args2.precision ? "+" : "?";
  return `([01]\\d|2[0-3]):[0-5]\\d(:${secondsRegexSource})${secondsQuantifier}`;
}
function timeRegex(args2) {
  return new RegExp(`^${timeRegexSource(args2)}$`);
}
function datetimeRegex(args2) {
  let regex = `${dateRegexSource}T${timeRegexSource(args2)}`;
  const opts = [];
  opts.push(args2.local ? `Z?` : `Z`);
  if (args2.offset)
    opts.push(`([+-]\\d{2}:?\\d{2})`);
  regex = `${regex}(${opts.join("|")})`;
  return new RegExp(`^${regex}$`);
}
function isValidIP(ip, version5) {
  if ((version5 === "v4" || !version5) && ipv4Regex.test(ip)) {
    return true;
  }
  if ((version5 === "v6" || !version5) && ipv6Regex.test(ip)) {
    return true;
  }
  return false;
}
function isValidJWT(jwt, alg) {
  if (!jwtRegex.test(jwt))
    return false;
  try {
    const [header] = jwt.split(".");
    if (!header)
      return false;
    const base64 = header.replace(/-/g, "+").replace(/_/g, "/").padEnd(header.length + (4 - header.length % 4) % 4, "=");
    const decoded = JSON.parse(atob(base64));
    if (typeof decoded !== "object" || decoded === null)
      return false;
    if ("typ" in decoded && decoded?.typ !== "JWT")
      return false;
    if (!decoded.alg)
      return false;
    if (alg && decoded.alg !== alg)
      return false;
    return true;
  } catch {
    return false;
  }
}
function isValidCidr(ip, version5) {
  if ((version5 === "v4" || !version5) && ipv4CidrRegex.test(ip)) {
    return true;
  }
  if ((version5 === "v6" || !version5) && ipv6CidrRegex.test(ip)) {
    return true;
  }
  return false;
}
function floatSafeRemainder(val, step) {
  const valDecCount = (val.toString().split(".")[1] || "").length;
  const stepDecCount = (step.toString().split(".")[1] || "").length;
  const decCount = valDecCount > stepDecCount ? valDecCount : stepDecCount;
  const valInt = Number.parseInt(val.toFixed(decCount).replace(".", ""));
  const stepInt = Number.parseInt(step.toFixed(decCount).replace(".", ""));
  return valInt % stepInt / 10 ** decCount;
}
function deepPartialify(schema) {
  if (schema instanceof ZodObject) {
    const newShape = {};
    for (const key in schema.shape) {
      const fieldSchema = schema.shape[key];
      newShape[key] = ZodOptional.create(deepPartialify(fieldSchema));
    }
    return new ZodObject({
      ...schema._def,
      shape: () => newShape
    });
  } else if (schema instanceof ZodArray) {
    return new ZodArray({
      ...schema._def,
      type: deepPartialify(schema.element)
    });
  } else if (schema instanceof ZodOptional) {
    return ZodOptional.create(deepPartialify(schema.unwrap()));
  } else if (schema instanceof ZodNullable) {
    return ZodNullable.create(deepPartialify(schema.unwrap()));
  } else if (schema instanceof ZodTuple) {
    return ZodTuple.create(schema.items.map((item) => deepPartialify(item)));
  } else {
    return schema;
  }
}
function mergeValues(a, b) {
  const aType = getParsedType(a);
  const bType = getParsedType(b);
  if (a === b) {
    return { valid: true, data: a };
  } else if (aType === ZodParsedType.object && bType === ZodParsedType.object) {
    const bKeys = util.objectKeys(b);
    const sharedKeys = util.objectKeys(a).filter((key) => bKeys.indexOf(key) !== -1);
    const newObj = { ...a, ...b };
    for (const key of sharedKeys) {
      const sharedValue = mergeValues(a[key], b[key]);
      if (!sharedValue.valid) {
        return { valid: false };
      }
      newObj[key] = sharedValue.data;
    }
    return { valid: true, data: newObj };
  } else if (aType === ZodParsedType.array && bType === ZodParsedType.array) {
    if (a.length !== b.length) {
      return { valid: false };
    }
    const newArray = [];
    for (let index = 0; index < a.length; index++) {
      const itemA = a[index];
      const itemB = b[index];
      const sharedValue = mergeValues(itemA, itemB);
      if (!sharedValue.valid) {
        return { valid: false };
      }
      newArray.push(sharedValue.data);
    }
    return { valid: true, data: newArray };
  } else if (aType === ZodParsedType.date && bType === ZodParsedType.date && +a === +b) {
    return { valid: true, data: a };
  } else {
    return { valid: false };
  }
}
function createZodEnum(values, params) {
  return new ZodEnum({
    values,
    typeName: ZodFirstPartyTypeKind.ZodEnum,
    ...processCreateParams(params)
  });
}
function cleanParams(params, data) {
  const p2 = typeof params === "function" ? params(data) : typeof params === "string" ? { message: params } : params;
  const p22 = typeof p2 === "string" ? { message: p2 } : p2;
  return p22;
}
function custom(check, _params = {}, fatal) {
  if (check)
    return ZodAny.create().superRefine((data, ctx) => {
      const r = check(data);
      if (r instanceof Promise) {
        return r.then((r2) => {
          if (!r2) {
            const params = cleanParams(_params, data);
            const _fatal = params.fatal ?? fatal ?? true;
            ctx.addIssue({ code: "custom", ...params, fatal: _fatal });
          }
        });
      }
      if (!r) {
        const params = cleanParams(_params, data);
        const _fatal = params.fatal ?? fatal ?? true;
        ctx.addIssue({ code: "custom", ...params, fatal: _fatal });
      }
      return;
    });
  return ZodAny.create();
}
function mergeCapabilities(base2, additional) {
  return Object.entries(additional).reduce((acc, [key, value]) => {
    if (value && typeof value === "object") {
      acc[key] = acc[key] ? { ...acc[key], ...value } : value;
    } else {
      acc[key] = value;
    }
    return acc;
  }, { ...base2 });
}
function addErrorMessage(res, key, errorMessage, refs) {
  if (!refs?.errorMessages)
    return;
  if (errorMessage) {
    res.errorMessage = {
      ...res.errorMessage,
      [key]: errorMessage
    };
  }
}
function setResponseValueAndErrors(res, key, value, errorMessage, refs) {
  res[key] = value;
  addErrorMessage(res, key, errorMessage, refs);
}
function parseAnyDef() {
  return {};
}
function parseArrayDef(def, refs) {
  const res = {
    type: "array"
  };
  if (def.type?._def && def.type?._def?.typeName !== ZodFirstPartyTypeKind.ZodAny) {
    res.items = parseDef(def.type._def, {
      ...refs,
      currentPath: [...refs.currentPath, "items"]
    });
  }
  if (def.minLength) {
    setResponseValueAndErrors(res, "minItems", def.minLength.value, def.minLength.message, refs);
  }
  if (def.maxLength) {
    setResponseValueAndErrors(res, "maxItems", def.maxLength.value, def.maxLength.message, refs);
  }
  if (def.exactLength) {
    setResponseValueAndErrors(res, "minItems", def.exactLength.value, def.exactLength.message, refs);
    setResponseValueAndErrors(res, "maxItems", def.exactLength.value, def.exactLength.message, refs);
  }
  return res;
}
function parseBigintDef(def, refs) {
  const res = {
    type: "integer",
    format: "int64"
  };
  if (!def.checks)
    return res;
  for (const check of def.checks) {
    switch (check.kind) {
      case "min":
        if (refs.target === "jsonSchema7") {
          if (check.inclusive) {
            setResponseValueAndErrors(res, "minimum", check.value, check.message, refs);
          } else {
            setResponseValueAndErrors(res, "exclusiveMinimum", check.value, check.message, refs);
          }
        } else {
          if (!check.inclusive) {
            res.exclusiveMinimum = true;
          }
          setResponseValueAndErrors(res, "minimum", check.value, check.message, refs);
        }
        break;
      case "max":
        if (refs.target === "jsonSchema7") {
          if (check.inclusive) {
            setResponseValueAndErrors(res, "maximum", check.value, check.message, refs);
          } else {
            setResponseValueAndErrors(res, "exclusiveMaximum", check.value, check.message, refs);
          }
        } else {
          if (!check.inclusive) {
            res.exclusiveMaximum = true;
          }
          setResponseValueAndErrors(res, "maximum", check.value, check.message, refs);
        }
        break;
      case "multipleOf":
        setResponseValueAndErrors(res, "multipleOf", check.value, check.message, refs);
        break;
    }
  }
  return res;
}
function parseBooleanDef() {
  return {
    type: "boolean"
  };
}
function parseBrandedDef(_def, refs) {
  return parseDef(_def.type._def, refs);
}
function parseDateDef(def, refs, overrideDateStrategy) {
  const strategy = overrideDateStrategy ?? refs.dateStrategy;
  if (Array.isArray(strategy)) {
    return {
      anyOf: strategy.map((item, i2) => parseDateDef(def, refs, item))
    };
  }
  switch (strategy) {
    case "string":
    case "format:date-time":
      return {
        type: "string",
        format: "date-time"
      };
    case "format:date":
      return {
        type: "string",
        format: "date"
      };
    case "integer":
      return integerDateParser(def, refs);
  }
}
function parseDefaultDef(_def, refs) {
  return {
    ...parseDef(_def.innerType._def, refs),
    default: _def.defaultValue()
  };
}
function parseEffectsDef(_def, refs) {
  return refs.effectStrategy === "input" ? parseDef(_def.schema._def, refs) : {};
}
function parseEnumDef(def) {
  return {
    type: "string",
    enum: Array.from(def.values)
  };
}
function parseIntersectionDef(def, refs) {
  const allOf = [
    parseDef(def.left._def, {
      ...refs,
      currentPath: [...refs.currentPath, "allOf", "0"]
    }),
    parseDef(def.right._def, {
      ...refs,
      currentPath: [...refs.currentPath, "allOf", "1"]
    })
  ].filter((x) => !!x);
  let unevaluatedProperties = refs.target === "jsonSchema2019-09" ? { unevaluatedProperties: false } : void 0;
  const mergedAllOf = [];
  allOf.forEach((schema) => {
    if (isJsonSchema7AllOfType(schema)) {
      mergedAllOf.push(...schema.allOf);
      if (schema.unevaluatedProperties === void 0) {
        unevaluatedProperties = void 0;
      }
    } else {
      let nestedSchema = schema;
      if ("additionalProperties" in schema && schema.additionalProperties === false) {
        const { additionalProperties, ...rest } = schema;
        nestedSchema = rest;
      } else {
        unevaluatedProperties = void 0;
      }
      mergedAllOf.push(nestedSchema);
    }
  });
  return mergedAllOf.length ? {
    allOf: mergedAllOf,
    ...unevaluatedProperties
  } : void 0;
}
function parseLiteralDef(def, refs) {
  const parsedType = typeof def.value;
  if (parsedType !== "bigint" && parsedType !== "number" && parsedType !== "boolean" && parsedType !== "string") {
    return {
      type: Array.isArray(def.value) ? "array" : "object"
    };
  }
  if (refs.target === "openApi3") {
    return {
      type: parsedType === "bigint" ? "integer" : parsedType,
      enum: [def.value]
    };
  }
  return {
    type: parsedType === "bigint" ? "integer" : parsedType,
    const: def.value
  };
}
function parseStringDef(def, refs) {
  const res = {
    type: "string"
  };
  if (def.checks) {
    for (const check of def.checks) {
      switch (check.kind) {
        case "min":
          setResponseValueAndErrors(res, "minLength", typeof res.minLength === "number" ? Math.max(res.minLength, check.value) : check.value, check.message, refs);
          break;
        case "max":
          setResponseValueAndErrors(res, "maxLength", typeof res.maxLength === "number" ? Math.min(res.maxLength, check.value) : check.value, check.message, refs);
          break;
        case "email":
          switch (refs.emailStrategy) {
            case "format:email":
              addFormat(res, "email", check.message, refs);
              break;
            case "format:idn-email":
              addFormat(res, "idn-email", check.message, refs);
              break;
            case "pattern:zod":
              addPattern(res, zodPatterns.email, check.message, refs);
              break;
          }
          break;
        case "url":
          addFormat(res, "uri", check.message, refs);
          break;
        case "uuid":
          addFormat(res, "uuid", check.message, refs);
          break;
        case "regex":
          addPattern(res, check.regex, check.message, refs);
          break;
        case "cuid":
          addPattern(res, zodPatterns.cuid, check.message, refs);
          break;
        case "cuid2":
          addPattern(res, zodPatterns.cuid2, check.message, refs);
          break;
        case "startsWith":
          addPattern(res, RegExp(`^${escapeLiteralCheckValue(check.value, refs)}`), check.message, refs);
          break;
        case "endsWith":
          addPattern(res, RegExp(`${escapeLiteralCheckValue(check.value, refs)}$`), check.message, refs);
          break;
        case "datetime":
          addFormat(res, "date-time", check.message, refs);
          break;
        case "date":
          addFormat(res, "date", check.message, refs);
          break;
        case "time":
          addFormat(res, "time", check.message, refs);
          break;
        case "duration":
          addFormat(res, "duration", check.message, refs);
          break;
        case "length":
          setResponseValueAndErrors(res, "minLength", typeof res.minLength === "number" ? Math.max(res.minLength, check.value) : check.value, check.message, refs);
          setResponseValueAndErrors(res, "maxLength", typeof res.maxLength === "number" ? Math.min(res.maxLength, check.value) : check.value, check.message, refs);
          break;
        case "includes": {
          addPattern(res, RegExp(escapeLiteralCheckValue(check.value, refs)), check.message, refs);
          break;
        }
        case "ip": {
          if (check.version !== "v6") {
            addFormat(res, "ipv4", check.message, refs);
          }
          if (check.version !== "v4") {
            addFormat(res, "ipv6", check.message, refs);
          }
          break;
        }
        case "base64url":
          addPattern(res, zodPatterns.base64url, check.message, refs);
          break;
        case "jwt":
          addPattern(res, zodPatterns.jwt, check.message, refs);
          break;
        case "cidr": {
          if (check.version !== "v6") {
            addPattern(res, zodPatterns.ipv4Cidr, check.message, refs);
          }
          if (check.version !== "v4") {
            addPattern(res, zodPatterns.ipv6Cidr, check.message, refs);
          }
          break;
        }
        case "emoji":
          addPattern(res, zodPatterns.emoji(), check.message, refs);
          break;
        case "ulid": {
          addPattern(res, zodPatterns.ulid, check.message, refs);
          break;
        }
        case "base64": {
          switch (refs.base64Strategy) {
            case "format:binary": {
              addFormat(res, "binary", check.message, refs);
              break;
            }
            case "contentEncoding:base64": {
              setResponseValueAndErrors(res, "contentEncoding", "base64", check.message, refs);
              break;
            }
            case "pattern:zod": {
              addPattern(res, zodPatterns.base64, check.message, refs);
              break;
            }
          }
          break;
        }
        case "nanoid": {
          addPattern(res, zodPatterns.nanoid, check.message, refs);
        }
        case "toLowerCase":
        case "toUpperCase":
        case "trim":
          break;
        default:
          /* @__PURE__ */ ((_) => {
          })(check);
      }
    }
  }
  return res;
}
function escapeLiteralCheckValue(literal, refs) {
  return refs.patternStrategy === "escape" ? escapeNonAlphaNumeric(literal) : literal;
}
function escapeNonAlphaNumeric(source) {
  let result = "";
  for (let i2 = 0; i2 < source.length; i2++) {
    if (!ALPHA_NUMERIC.has(source[i2])) {
      result += "\\";
    }
    result += source[i2];
  }
  return result;
}
function addFormat(schema, value, message, refs) {
  if (schema.format || schema.anyOf?.some((x) => x.format)) {
    if (!schema.anyOf) {
      schema.anyOf = [];
    }
    if (schema.format) {
      schema.anyOf.push({
        format: schema.format,
        ...schema.errorMessage && refs.errorMessages && {
          errorMessage: { format: schema.errorMessage.format }
        }
      });
      delete schema.format;
      if (schema.errorMessage) {
        delete schema.errorMessage.format;
        if (Object.keys(schema.errorMessage).length === 0) {
          delete schema.errorMessage;
        }
      }
    }
    schema.anyOf.push({
      format: value,
      ...message && refs.errorMessages && { errorMessage: { format: message } }
    });
  } else {
    setResponseValueAndErrors(schema, "format", value, message, refs);
  }
}
function addPattern(schema, regex, message, refs) {
  if (schema.pattern || schema.allOf?.some((x) => x.pattern)) {
    if (!schema.allOf) {
      schema.allOf = [];
    }
    if (schema.pattern) {
      schema.allOf.push({
        pattern: schema.pattern,
        ...schema.errorMessage && refs.errorMessages && {
          errorMessage: { pattern: schema.errorMessage.pattern }
        }
      });
      delete schema.pattern;
      if (schema.errorMessage) {
        delete schema.errorMessage.pattern;
        if (Object.keys(schema.errorMessage).length === 0) {
          delete schema.errorMessage;
        }
      }
    }
    schema.allOf.push({
      pattern: stringifyRegExpWithFlags(regex, refs),
      ...message && refs.errorMessages && { errorMessage: { pattern: message } }
    });
  } else {
    setResponseValueAndErrors(schema, "pattern", stringifyRegExpWithFlags(regex, refs), message, refs);
  }
}
function stringifyRegExpWithFlags(regex, refs) {
  if (!refs.applyRegexFlags || !regex.flags) {
    return regex.source;
  }
  const flags2 = {
    i: regex.flags.includes("i"),
    m: regex.flags.includes("m"),
    s: regex.flags.includes("s")
  };
  const source = flags2.i ? regex.source.toLowerCase() : regex.source;
  let pattern = "";
  let isEscaped = false;
  let inCharGroup = false;
  let inCharRange = false;
  for (let i2 = 0; i2 < source.length; i2++) {
    if (isEscaped) {
      pattern += source[i2];
      isEscaped = false;
      continue;
    }
    if (flags2.i) {
      if (inCharGroup) {
        if (source[i2].match(/[a-z]/)) {
          if (inCharRange) {
            pattern += source[i2];
            pattern += `${source[i2 - 2]}-${source[i2]}`.toUpperCase();
            inCharRange = false;
          } else if (source[i2 + 1] === "-" && source[i2 + 2]?.match(/[a-z]/)) {
            pattern += source[i2];
            inCharRange = true;
          } else {
            pattern += `${source[i2]}${source[i2].toUpperCase()}`;
          }
          continue;
        }
      } else if (source[i2].match(/[a-z]/)) {
        pattern += `[${source[i2]}${source[i2].toUpperCase()}]`;
        continue;
      }
    }
    if (flags2.m) {
      if (source[i2] === "^") {
        pattern += `(^|(?<=[\r
]))`;
        continue;
      } else if (source[i2] === "$") {
        pattern += `($|(?=[\r
]))`;
        continue;
      }
    }
    if (flags2.s && source[i2] === ".") {
      pattern += inCharGroup ? `${source[i2]}\r
` : `[${source[i2]}\r
]`;
      continue;
    }
    pattern += source[i2];
    if (source[i2] === "\\") {
      isEscaped = true;
    } else if (inCharGroup && source[i2] === "]") {
      inCharGroup = false;
    } else if (!inCharGroup && source[i2] === "[") {
      inCharGroup = true;
    }
  }
  try {
    new RegExp(pattern);
  } catch {
    console.warn(`Could not convert regex pattern at ${refs.currentPath.join("/")} to a flag-independent form! Falling back to the flag-ignorant source`);
    return regex.source;
  }
  return pattern;
}
function parseRecordDef(def, refs) {
  if (refs.target === "openAi") {
    console.warn("Warning: OpenAI may not support records in schemas! Try an array of key-value pairs instead.");
  }
  if (refs.target === "openApi3" && def.keyType?._def.typeName === ZodFirstPartyTypeKind.ZodEnum) {
    return {
      type: "object",
      required: def.keyType._def.values,
      properties: def.keyType._def.values.reduce((acc, key) => ({
        ...acc,
        [key]: parseDef(def.valueType._def, {
          ...refs,
          currentPath: [...refs.currentPath, "properties", key]
        }) ?? {}
      }), {}),
      additionalProperties: refs.rejectedAdditionalProperties
    };
  }
  const schema = {
    type: "object",
    additionalProperties: parseDef(def.valueType._def, {
      ...refs,
      currentPath: [...refs.currentPath, "additionalProperties"]
    }) ?? refs.allowedAdditionalProperties
  };
  if (refs.target === "openApi3") {
    return schema;
  }
  if (def.keyType?._def.typeName === ZodFirstPartyTypeKind.ZodString && def.keyType._def.checks?.length) {
    const { type, ...keyType } = parseStringDef(def.keyType._def, refs);
    return {
      ...schema,
      propertyNames: keyType
    };
  } else if (def.keyType?._def.typeName === ZodFirstPartyTypeKind.ZodEnum) {
    return {
      ...schema,
      propertyNames: {
        enum: def.keyType._def.values
      }
    };
  } else if (def.keyType?._def.typeName === ZodFirstPartyTypeKind.ZodBranded && def.keyType._def.type._def.typeName === ZodFirstPartyTypeKind.ZodString && def.keyType._def.type._def.checks?.length) {
    const { type, ...keyType } = parseBrandedDef(def.keyType._def, refs);
    return {
      ...schema,
      propertyNames: keyType
    };
  }
  return schema;
}
function parseMapDef(def, refs) {
  if (refs.mapStrategy === "record") {
    return parseRecordDef(def, refs);
  }
  const keys = parseDef(def.keyType._def, {
    ...refs,
    currentPath: [...refs.currentPath, "items", "items", "0"]
  }) || {};
  const values = parseDef(def.valueType._def, {
    ...refs,
    currentPath: [...refs.currentPath, "items", "items", "1"]
  }) || {};
  return {
    type: "array",
    maxItems: 125,
    items: {
      type: "array",
      items: [keys, values],
      minItems: 2,
      maxItems: 2
    }
  };
}
function parseNativeEnumDef(def) {
  const object = def.values;
  const actualKeys = Object.keys(def.values).filter((key) => {
    return typeof object[object[key]] !== "number";
  });
  const actualValues = actualKeys.map((key) => object[key]);
  const parsedTypes = Array.from(new Set(actualValues.map((values) => typeof values)));
  return {
    type: parsedTypes.length === 1 ? parsedTypes[0] === "string" ? "string" : "number" : ["string", "number"],
    enum: actualValues
  };
}
function parseNeverDef() {
  return {
    not: {}
  };
}
function parseNullDef(refs) {
  return refs.target === "openApi3" ? {
    enum: ["null"],
    nullable: true
  } : {
    type: "null"
  };
}
function parseUnionDef(def, refs) {
  if (refs.target === "openApi3")
    return asAnyOf(def, refs);
  const options = def.options instanceof Map ? Array.from(def.options.values()) : def.options;
  if (options.every((x) => x._def.typeName in primitiveMappings && (!x._def.checks || !x._def.checks.length))) {
    const types2 = options.reduce((types3, x) => {
      const type = primitiveMappings[x._def.typeName];
      return type && !types3.includes(type) ? [...types3, type] : types3;
    }, []);
    return {
      type: types2.length > 1 ? types2 : types2[0]
    };
  } else if (options.every((x) => x._def.typeName === "ZodLiteral" && !x.description)) {
    const types2 = options.reduce((acc, x) => {
      const type = typeof x._def.value;
      switch (type) {
        case "string":
        case "number":
        case "boolean":
          return [...acc, type];
        case "bigint":
          return [...acc, "integer"];
        case "object":
          if (x._def.value === null)
            return [...acc, "null"];
        case "symbol":
        case "undefined":
        case "function":
        default:
          return acc;
      }
    }, []);
    if (types2.length === options.length) {
      const uniqueTypes = types2.filter((x, i2, a) => a.indexOf(x) === i2);
      return {
        type: uniqueTypes.length > 1 ? uniqueTypes : uniqueTypes[0],
        enum: options.reduce((acc, x) => {
          return acc.includes(x._def.value) ? acc : [...acc, x._def.value];
        }, [])
      };
    }
  } else if (options.every((x) => x._def.typeName === "ZodEnum")) {
    return {
      type: "string",
      enum: options.reduce((acc, x) => [
        ...acc,
        ...x._def.values.filter((x2) => !acc.includes(x2))
      ], [])
    };
  }
  return asAnyOf(def, refs);
}
function parseNullableDef(def, refs) {
  if (["ZodString", "ZodNumber", "ZodBigInt", "ZodBoolean", "ZodNull"].includes(def.innerType._def.typeName) && (!def.innerType._def.checks || !def.innerType._def.checks.length)) {
    if (refs.target === "openApi3") {
      return {
        type: primitiveMappings[def.innerType._def.typeName],
        nullable: true
      };
    }
    return {
      type: [
        primitiveMappings[def.innerType._def.typeName],
        "null"
      ]
    };
  }
  if (refs.target === "openApi3") {
    const base22 = parseDef(def.innerType._def, {
      ...refs,
      currentPath: [...refs.currentPath]
    });
    if (base22 && "$ref" in base22)
      return { allOf: [base22], nullable: true };
    return base22 && { ...base22, nullable: true };
  }
  const base2 = parseDef(def.innerType._def, {
    ...refs,
    currentPath: [...refs.currentPath, "anyOf", "0"]
  });
  return base2 && { anyOf: [base2, { type: "null" }] };
}
function parseNumberDef(def, refs) {
  const res = {
    type: "number"
  };
  if (!def.checks)
    return res;
  for (const check of def.checks) {
    switch (check.kind) {
      case "int":
        res.type = "integer";
        addErrorMessage(res, "type", check.message, refs);
        break;
      case "min":
        if (refs.target === "jsonSchema7") {
          if (check.inclusive) {
            setResponseValueAndErrors(res, "minimum", check.value, check.message, refs);
          } else {
            setResponseValueAndErrors(res, "exclusiveMinimum", check.value, check.message, refs);
          }
        } else {
          if (!check.inclusive) {
            res.exclusiveMinimum = true;
          }
          setResponseValueAndErrors(res, "minimum", check.value, check.message, refs);
        }
        break;
      case "max":
        if (refs.target === "jsonSchema7") {
          if (check.inclusive) {
            setResponseValueAndErrors(res, "maximum", check.value, check.message, refs);
          } else {
            setResponseValueAndErrors(res, "exclusiveMaximum", check.value, check.message, refs);
          }
        } else {
          if (!check.inclusive) {
            res.exclusiveMaximum = true;
          }
          setResponseValueAndErrors(res, "maximum", check.value, check.message, refs);
        }
        break;
      case "multipleOf":
        setResponseValueAndErrors(res, "multipleOf", check.value, check.message, refs);
        break;
    }
  }
  return res;
}
function parseObjectDef(def, refs) {
  const forceOptionalIntoNullable = refs.target === "openAi";
  const result = {
    type: "object",
    properties: {}
  };
  const required = [];
  const shape = def.shape();
  for (const propName in shape) {
    let propDef = shape[propName];
    if (propDef === void 0 || propDef._def === void 0) {
      continue;
    }
    let propOptional = safeIsOptional(propDef);
    if (propOptional && forceOptionalIntoNullable) {
      if (propDef instanceof ZodOptional) {
        propDef = propDef._def.innerType;
      }
      if (!propDef.isNullable()) {
        propDef = propDef.nullable();
      }
      propOptional = false;
    }
    const parsedDef = parseDef(propDef._def, {
      ...refs,
      currentPath: [...refs.currentPath, "properties", propName],
      propertyPath: [...refs.currentPath, "properties", propName]
    });
    if (parsedDef === void 0) {
      continue;
    }
    result.properties[propName] = parsedDef;
    if (!propOptional) {
      required.push(propName);
    }
  }
  if (required.length) {
    result.required = required;
  }
  const additionalProperties = decideAdditionalProperties(def, refs);
  if (additionalProperties !== void 0) {
    result.additionalProperties = additionalProperties;
  }
  return result;
}
function decideAdditionalProperties(def, refs) {
  if (def.catchall._def.typeName !== "ZodNever") {
    return parseDef(def.catchall._def, {
      ...refs,
      currentPath: [...refs.currentPath, "additionalProperties"]
    });
  }
  switch (def.unknownKeys) {
    case "passthrough":
      return refs.allowedAdditionalProperties;
    case "strict":
      return refs.rejectedAdditionalProperties;
    case "strip":
      return refs.removeAdditionalStrategy === "strict" ? refs.allowedAdditionalProperties : refs.rejectedAdditionalProperties;
  }
}
function safeIsOptional(schema) {
  try {
    return schema.isOptional();
  } catch {
    return true;
  }
}
function parsePromiseDef(def, refs) {
  return parseDef(def.type._def, refs);
}
function parseSetDef(def, refs) {
  const items = parseDef(def.valueType._def, {
    ...refs,
    currentPath: [...refs.currentPath, "items"]
  });
  const schema = {
    type: "array",
    uniqueItems: true,
    items
  };
  if (def.minSize) {
    setResponseValueAndErrors(schema, "minItems", def.minSize.value, def.minSize.message, refs);
  }
  if (def.maxSize) {
    setResponseValueAndErrors(schema, "maxItems", def.maxSize.value, def.maxSize.message, refs);
  }
  return schema;
}
function parseTupleDef(def, refs) {
  if (def.rest) {
    return {
      type: "array",
      minItems: def.items.length,
      items: def.items.map((x, i2) => parseDef(x._def, {
        ...refs,
        currentPath: [...refs.currentPath, "items", `${i2}`]
      })).reduce((acc, x) => x === void 0 ? acc : [...acc, x], []),
      additionalItems: parseDef(def.rest._def, {
        ...refs,
        currentPath: [...refs.currentPath, "additionalItems"]
      })
    };
  } else {
    return {
      type: "array",
      minItems: def.items.length,
      maxItems: def.items.length,
      items: def.items.map((x, i2) => parseDef(x._def, {
        ...refs,
        currentPath: [...refs.currentPath, "items", `${i2}`]
      })).reduce((acc, x) => x === void 0 ? acc : [...acc, x], [])
    };
  }
}
function parseUndefinedDef() {
  return {
    not: {}
  };
}
function parseUnknownDef() {
  return {};
}
function parseDef(def, refs, forceResolution = false) {
  const seenItem = refs.seen.get(def);
  if (refs.override) {
    const overrideResult = refs.override?.(def, refs, seenItem, forceResolution);
    if (overrideResult !== ignoreOverride) {
      return overrideResult;
    }
  }
  if (seenItem && !forceResolution) {
    const seenSchema = get$ref(seenItem, refs);
    if (seenSchema !== void 0) {
      return seenSchema;
    }
  }
  const newItem = { def, path: refs.currentPath, jsonSchema: void 0 };
  refs.seen.set(def, newItem);
  const jsonSchemaOrGetter = selectParser(def, def.typeName, refs);
  const jsonSchema = typeof jsonSchemaOrGetter === "function" ? parseDef(jsonSchemaOrGetter(), refs) : jsonSchemaOrGetter;
  if (jsonSchema) {
    addMeta(def, refs, jsonSchema);
  }
  if (refs.postProcess) {
    const postProcessResult = refs.postProcess(jsonSchema, def, refs);
    newItem.jsonSchema = jsonSchema;
    return postProcessResult;
  }
  newItem.jsonSchema = jsonSchema;
  return jsonSchema;
}
function processCreateParams2(params) {
  if (!params)
    return {};
  const { errorMap: errorMap2, invalid_type_error, required_error, description } = params;
  if (errorMap2 && (invalid_type_error || required_error)) {
    throw new Error(`Can't use "invalid_type_error" or "required_error" in conjunction with custom error map.`);
  }
  if (errorMap2)
    return { errorMap: errorMap2, description };
  const customMap = (iss, ctx) => {
    var _a17, _b4;
    const { message } = params;
    if (iss.code === "invalid_enum_value") {
      return { message: message !== null && message !== void 0 ? message : ctx.defaultError };
    }
    if (typeof ctx.data === "undefined") {
      return { message: (_a17 = message !== null && message !== void 0 ? message : required_error) !== null && _a17 !== void 0 ? _a17 : ctx.defaultError };
    }
    if (iss.code !== "invalid_type")
      return { message: ctx.defaultError };
    return { message: (_b4 = message !== null && message !== void 0 ? message : invalid_type_error) !== null && _b4 !== void 0 ? _b4 : ctx.defaultError };
  };
  return { errorMap: customMap, description };
}
function isZodRawShape(obj) {
  if (typeof obj !== "object" || obj === null)
    return false;
  const isEmptyObject = Object.keys(obj).length === 0;
  return isEmptyObject || Object.values(obj).some(isZodTypeLike);
}
function isZodTypeLike(value) {
  return value !== null && typeof value === "object" && "parse" in value && typeof value.parse === "function" && "safeParse" in value && typeof value.safeParse === "function";
}
function promptArgumentsFromSchema(schema) {
  return Object.entries(schema.shape).map(([name3, field]) => ({
    name: name3,
    description: field.description,
    required: !field.isOptional()
  }));
}
function createCompletionResult(suggestions) {
  return {
    completion: {
      values: suggestions.slice(0, 100),
      total: suggestions.length,
      hasMore: suggestions.length > 100
    }
  };
}
function tool(name3, description, inputSchema, handler) {
  return { name: name3, description, inputSchema, handler };
}
function createSdkMcpServer(options) {
  const server = new McpServer({
    name: options.name,
    version: options.version ?? "1.0.0"
  }, {
    capabilities: {
      tools: options.tools ? {} : void 0
    }
  });
  if (options.tools) {
    options.tools.forEach((toolDef) => {
      server.tool(toolDef.name, toolDef.description, toolDef.inputSchema, toolDef.handler);
    });
  }
  return {
    type: "sdk",
    name: options.name,
    instance: server
  };
}
function query({
  prompt,
  options
}) {
  const { systemPrompt, settingSources, ...rest } = options ?? {};
  let customSystemPrompt;
  let appendSystemPrompt;
  if (systemPrompt === void 0) {
    customSystemPrompt = "";
  } else if (typeof systemPrompt === "string") {
    customSystemPrompt = systemPrompt;
  } else if (systemPrompt.type === "preset") {
    appendSystemPrompt = systemPrompt.append;
  }
  let pathToClaudeCodeExecutable = rest.pathToClaudeCodeExecutable;
  if (!pathToClaudeCodeExecutable) {
    const filename = (0, import_url.fileURLToPath)(import_meta.url);
    const dirname7 = (0, import_path12.join)(filename, "..");
    pathToClaudeCodeExecutable = (0, import_path12.join)(dirname7, "cli.js");
  }
  process.env.CLAUDE_AGENT_SDK_VERSION = "0.1.9";
  return createSharedQuery({
    prompt,
    options: {
      ...rest,
      pathToClaudeCodeExecutable,
      customSystemPrompt,
      appendSystemPrompt,
      settingSources: settingSources ?? []
    }
  });
}
var import_path12, import_url, import_events, import_child_process, import_readline, fs2, import_promises, import_meta, __create2, __getProtoOf2, __defProp2, __getOwnPropNames2, __hasOwnProp2, __toESM2, __commonJS2, __export2, require_uri_all, require_fast_deep_equal2, require_ucs2length2, require_util2, require_schema_obj, require_json_schema_traverse2, require_resolve2, require_error_classes, require_fast_json_stable_stringify, require_validate2, require_compile2, require_cache, require_formats, require_ref2, require_allOf2, require_anyOf2, require_comment, require_const2, require_contains2, require_dependencies2, require_enum2, require_format3, require_if2, require_items2, require__limit, require__limitItems, require__limitLength, require__limitProperties, require_multipleOf2, require_not2, require_oneOf2, require_pattern2, require_properties2, require_propertyNames2, require_required2, require_uniqueItems2, require_dotjs, require_rules2, require_data2, require_async, require_custom, require_json_schema_draft_072, require_definition_schema, require_keyword2, require_data22, require_ajv2, DEFAULT_MAX_LISTENERS, NodeFsOperations, activeFs, AbortError, ProcessTransport, Stream2, SdkControlServerTransport, Query2, exports_external, util, objectUtil, ZodParsedType, getParsedType, ZodIssueCode, quotelessJson, ZodError, errorMap, en_default, overrideErrorMap, makeIssue, EMPTY_PATH, ParseStatus, INVALID, DIRTY, OK, isAborted, isDirty, isValid, isAsync, errorUtil, ParseInputLazyPath, handleResult, ZodType, cuidRegex, cuid2Regex, ulidRegex, uuidRegex, nanoidRegex, jwtRegex, durationRegex, emailRegex, _emojiRegex, emojiRegex, ipv4Regex, ipv4CidrRegex, ipv6Regex, ipv6CidrRegex, base64Regex, base64urlRegex, dateRegexSource, dateRegex, ZodString, ZodNumber, ZodBigInt, ZodBoolean, ZodDate, ZodSymbol, ZodUndefined, ZodNull, ZodAny, ZodUnknown, ZodNever, ZodVoid, ZodArray, ZodObject, ZodUnion, getDiscriminator, ZodDiscriminatedUnion, ZodIntersection, ZodTuple, ZodRecord, ZodMap, ZodSet, ZodFunction, ZodLazy, ZodLiteral, ZodEnum, ZodNativeEnum, ZodPromise, ZodEffects, ZodOptional, ZodNullable, ZodDefault, ZodCatch, ZodNaN, BRAND, ZodBranded, ZodPipeline, ZodReadonly, late, ZodFirstPartyTypeKind, instanceOfType, stringType, numberType, nanType, bigIntType, booleanType, dateType, symbolType, undefinedType, nullType, anyType, unknownType, neverType, voidType, arrayType, objectType, strictObjectType, unionType, discriminatedUnionType, intersectionType, tupleType, recordType, mapType, setType, functionType, lazyType, literalType, enumType, nativeEnumType, promiseType, effectsType, optionalType, nullableType, preprocessType, pipelineType, ostring, onumber, oboolean, coerce, NEVER, LATEST_PROTOCOL_VERSION, SUPPORTED_PROTOCOL_VERSIONS, JSONRPC_VERSION, ProgressTokenSchema, CursorSchema, RequestMetaSchema, BaseRequestParamsSchema, RequestSchema, BaseNotificationParamsSchema, NotificationSchema, ResultSchema, RequestIdSchema, JSONRPCRequestSchema, isJSONRPCRequest, JSONRPCNotificationSchema, isJSONRPCNotification, JSONRPCResponseSchema, isJSONRPCResponse, ErrorCode, JSONRPCErrorSchema, isJSONRPCError, JSONRPCMessageSchema, EmptyResultSchema, CancelledNotificationSchema, BaseMetadataSchema, ImplementationSchema, ClientCapabilitiesSchema, InitializeRequestSchema, ServerCapabilitiesSchema, InitializeResultSchema, InitializedNotificationSchema, PingRequestSchema, ProgressSchema, ProgressNotificationSchema, PaginatedRequestSchema, PaginatedResultSchema, ResourceContentsSchema, TextResourceContentsSchema, Base64Schema, BlobResourceContentsSchema, ResourceSchema, ResourceTemplateSchema, ListResourcesRequestSchema, ListResourcesResultSchema, ListResourceTemplatesRequestSchema, ListResourceTemplatesResultSchema, ReadResourceRequestSchema, ReadResourceResultSchema, ResourceListChangedNotificationSchema, SubscribeRequestSchema, UnsubscribeRequestSchema, ResourceUpdatedNotificationSchema, PromptArgumentSchema, PromptSchema, ListPromptsRequestSchema, ListPromptsResultSchema, GetPromptRequestSchema, TextContentSchema, ImageContentSchema, AudioContentSchema, EmbeddedResourceSchema, ResourceLinkSchema, ContentBlockSchema, PromptMessageSchema, GetPromptResultSchema, PromptListChangedNotificationSchema, ToolAnnotationsSchema, ToolSchema, ListToolsRequestSchema, ListToolsResultSchema, CallToolResultSchema, CompatibilityCallToolResultSchema, CallToolRequestSchema, ToolListChangedNotificationSchema, LoggingLevelSchema, SetLevelRequestSchema, LoggingMessageNotificationSchema, ModelHintSchema, ModelPreferencesSchema, SamplingMessageSchema, CreateMessageRequestSchema, CreateMessageResultSchema, BooleanSchemaSchema, StringSchemaSchema, NumberSchemaSchema, EnumSchemaSchema, PrimitiveSchemaDefinitionSchema, ElicitRequestSchema, ElicitResultSchema, ResourceTemplateReferenceSchema, PromptReferenceSchema, CompleteRequestSchema, CompleteResultSchema, RootSchema, ListRootsRequestSchema, ListRootsResultSchema, RootsListChangedNotificationSchema, ClientRequestSchema, ClientNotificationSchema, ClientResultSchema, ServerRequestSchema, ServerNotificationSchema, ServerResultSchema, McpError, DEFAULT_REQUEST_TIMEOUT_MSEC, Protocol, import_ajv2, Server, ignoreOverride, defaultOptions, getDefaultOptions, getRefs, parseCatchDef, integerDateParser, isJsonSchema7AllOfType, emojiRegex2, zodPatterns, ALPHA_NUMERIC, primitiveMappings, asAnyOf, parseOptionalDef, parsePipelineDef, parseReadonlyDef, selectParser, get$ref, getRelativePath, addMeta, zodToJsonSchema, McpZodTypeKind, Completable, McpServer, EMPTY_OBJECT_JSON_SCHEMA, EMPTY_COMPLETION_RESULT;
var init_sdk = __esm({
  "node_modules/@anthropic-ai/claude-agent-sdk/sdk.mjs"() {
    import_path12 = require("path");
    import_url = require("url");
    import_events = require("events");
    import_child_process = require("child_process");
    import_readline = require("readline");
    fs2 = __toESM(require("fs"), 1);
    import_promises = require("fs/promises");
    import_meta = {};
    __create2 = Object.create;
    __getProtoOf2 = Object.getPrototypeOf;
    __defProp2 = Object.defineProperty;
    __getOwnPropNames2 = Object.getOwnPropertyNames;
    __hasOwnProp2 = Object.prototype.hasOwnProperty;
    __toESM2 = (mod, isNodeMode, target) => {
      target = mod != null ? __create2(__getProtoOf2(mod)) : {};
      const to = isNodeMode || !mod || !mod.__esModule ? __defProp2(target, "default", { value: mod, enumerable: true }) : target;
      for (let key of __getOwnPropNames2(mod))
        if (!__hasOwnProp2.call(to, key))
          __defProp2(to, key, {
            get: () => mod[key],
            enumerable: true
          });
      return to;
    };
    __commonJS2 = (cb, mod) => () => (mod || cb((mod = { exports: {} }).exports, mod), mod.exports);
    __export2 = (target, all) => {
      for (var name3 in all)
        __defProp2(target, name3, {
          get: all[name3],
          enumerable: true,
          configurable: true,
          set: (newValue) => all[name3] = () => newValue
        });
    };
    require_uri_all = __commonJS2((exports2, module2) => {
      (function(global2, factory) {
        typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2) : typeof define === "function" && define.amd ? define(["exports"], factory) : factory(global2.URI = global2.URI || {});
      })(exports2, function(exports22) {
        function merge3() {
          for (var _len = arguments.length, sets = Array(_len), _key = 0; _key < _len; _key++) {
            sets[_key] = arguments[_key];
          }
          if (sets.length > 1) {
            sets[0] = sets[0].slice(0, -1);
            var xl = sets.length - 1;
            for (var x = 1; x < xl; ++x) {
              sets[x] = sets[x].slice(1, -1);
            }
            sets[xl] = sets[xl].slice(1);
            return sets.join("");
          } else {
            return sets[0];
          }
        }
        function subexp(str) {
          return "(?:" + str + ")";
        }
        function typeOf(o) {
          return o === void 0 ? "undefined" : o === null ? "null" : Object.prototype.toString.call(o).split(" ").pop().split("]").shift().toLowerCase();
        }
        function toUpperCase(str) {
          return str.toUpperCase();
        }
        function toArray(obj) {
          return obj !== void 0 && obj !== null ? obj instanceof Array ? obj : typeof obj.length !== "number" || obj.split || obj.setInterval || obj.call ? [obj] : Array.prototype.slice.call(obj) : [];
        }
        function assign3(target, source) {
          var obj = target;
          if (source) {
            for (var key in source) {
              obj[key] = source[key];
            }
          }
          return obj;
        }
        function buildExps(isIRI2) {
          var ALPHA$$ = "[A-Za-z]", CR$ = "[\\x0D]", DIGIT$$ = "[0-9]", DQUOTE$$ = "[\\x22]", HEXDIG$$2 = merge3(DIGIT$$, "[A-Fa-f]"), LF$$ = "[\\x0A]", SP$$ = "[\\x20]", PCT_ENCODED$2 = subexp(subexp("%[EFef]" + HEXDIG$$2 + "%" + HEXDIG$$2 + HEXDIG$$2 + "%" + HEXDIG$$2 + HEXDIG$$2) + "|" + subexp("%[89A-Fa-f]" + HEXDIG$$2 + "%" + HEXDIG$$2 + HEXDIG$$2) + "|" + subexp("%" + HEXDIG$$2 + HEXDIG$$2)), GEN_DELIMS$$ = "[\\:\\/\\?\\#\\[\\]\\@]", SUB_DELIMS$$ = "[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]", RESERVED$$ = merge3(GEN_DELIMS$$, SUB_DELIMS$$), UCSCHAR$$ = isIRI2 ? "[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]" : "[]", IPRIVATE$$ = isIRI2 ? "[\\uE000-\\uF8FF]" : "[]", UNRESERVED$$2 = merge3(ALPHA$$, DIGIT$$, "[\\-\\.\\_\\~]", UCSCHAR$$), SCHEME$ = subexp(ALPHA$$ + merge3(ALPHA$$, DIGIT$$, "[\\+\\-\\.]") + "*"), USERINFO$ = subexp(subexp(PCT_ENCODED$2 + "|" + merge3(UNRESERVED$$2, SUB_DELIMS$$, "[\\:]")) + "*"), DEC_OCTET$ = subexp(subexp("25[0-5]") + "|" + subexp("2[0-4]" + DIGIT$$) + "|" + subexp("1" + DIGIT$$ + DIGIT$$) + "|" + subexp("[1-9]" + DIGIT$$) + "|" + DIGIT$$), DEC_OCTET_RELAXED$ = subexp(subexp("25[0-5]") + "|" + subexp("2[0-4]" + DIGIT$$) + "|" + subexp("1" + DIGIT$$ + DIGIT$$) + "|" + subexp("0?[1-9]" + DIGIT$$) + "|0?0?" + DIGIT$$), IPV4ADDRESS$ = subexp(DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$), H16$ = subexp(HEXDIG$$2 + "{1,4}"), LS32$ = subexp(subexp(H16$ + "\\:" + H16$) + "|" + IPV4ADDRESS$), IPV6ADDRESS1$ = subexp(subexp(H16$ + "\\:") + "{6}" + LS32$), IPV6ADDRESS2$ = subexp("\\:\\:" + subexp(H16$ + "\\:") + "{5}" + LS32$), IPV6ADDRESS3$ = subexp(subexp(H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{4}" + LS32$), IPV6ADDRESS4$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,1}" + H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{3}" + LS32$), IPV6ADDRESS5$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,2}" + H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{2}" + LS32$), IPV6ADDRESS6$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,3}" + H16$) + "?\\:\\:" + H16$ + "\\:" + LS32$), IPV6ADDRESS7$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,4}" + H16$) + "?\\:\\:" + LS32$), IPV6ADDRESS8$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,5}" + H16$) + "?\\:\\:" + H16$), IPV6ADDRESS9$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,6}" + H16$) + "?\\:\\:"), IPV6ADDRESS$ = subexp([IPV6ADDRESS1$, IPV6ADDRESS2$, IPV6ADDRESS3$, IPV6ADDRESS4$, IPV6ADDRESS5$, IPV6ADDRESS6$, IPV6ADDRESS7$, IPV6ADDRESS8$, IPV6ADDRESS9$].join("|")), ZONEID$ = subexp(subexp(UNRESERVED$$2 + "|" + PCT_ENCODED$2) + "+"), IPV6ADDRZ$ = subexp(IPV6ADDRESS$ + "\\%25" + ZONEID$), IPV6ADDRZ_RELAXED$ = subexp(IPV6ADDRESS$ + subexp("\\%25|\\%(?!" + HEXDIG$$2 + "{2})") + ZONEID$), IPVFUTURE$ = subexp("[vV]" + HEXDIG$$2 + "+\\." + merge3(UNRESERVED$$2, SUB_DELIMS$$, "[\\:]") + "+"), IP_LITERAL$ = subexp("\\[" + subexp(IPV6ADDRZ_RELAXED$ + "|" + IPV6ADDRESS$ + "|" + IPVFUTURE$) + "\\]"), REG_NAME$ = subexp(subexp(PCT_ENCODED$2 + "|" + merge3(UNRESERVED$$2, SUB_DELIMS$$)) + "*"), HOST$ = subexp(IP_LITERAL$ + "|" + IPV4ADDRESS$ + "(?!" + REG_NAME$ + ")|" + REG_NAME$), PORT$ = subexp(DIGIT$$ + "*"), AUTHORITY$ = subexp(subexp(USERINFO$ + "@") + "?" + HOST$ + subexp("\\:" + PORT$) + "?"), PCHAR$ = subexp(PCT_ENCODED$2 + "|" + merge3(UNRESERVED$$2, SUB_DELIMS$$, "[\\:\\@]")), SEGMENT$ = subexp(PCHAR$ + "*"), SEGMENT_NZ$ = subexp(PCHAR$ + "+"), SEGMENT_NZ_NC$ = subexp(subexp(PCT_ENCODED$2 + "|" + merge3(UNRESERVED$$2, SUB_DELIMS$$, "[\\@]")) + "+"), PATH_ABEMPTY$ = subexp(subexp("\\/" + SEGMENT$) + "*"), PATH_ABSOLUTE$ = subexp("\\/" + subexp(SEGMENT_NZ$ + PATH_ABEMPTY$) + "?"), PATH_NOSCHEME$ = subexp(SEGMENT_NZ_NC$ + PATH_ABEMPTY$), PATH_ROOTLESS$ = subexp(SEGMENT_NZ$ + PATH_ABEMPTY$), PATH_EMPTY$ = "(?!" + PCHAR$ + ")", PATH$ = subexp(PATH_ABEMPTY$ + "|" + PATH_ABSOLUTE$ + "|" + PATH_NOSCHEME$ + "|" + PATH_ROOTLESS$ + "|" + PATH_EMPTY$), QUERY$ = subexp(subexp(PCHAR$ + "|" + merge3("[\\/\\?]", IPRIVATE$$)) + "*"), FRAGMENT$ = subexp(subexp(PCHAR$ + "|[\\/\\?]") + "*"), HIER_PART$ = subexp(subexp("\\/\\/" + AUTHORITY$ + PATH_ABEMPTY$) + "|" + PATH_ABSOLUTE$ + "|" + PATH_ROOTLESS$ + "|" + PATH_EMPTY$), URI$ = subexp(SCHEME$ + "\\:" + HIER_PART$ + subexp("\\?" + QUERY$) + "?" + subexp("\\#" + FRAGMENT$) + "?"), RELATIVE_PART$ = subexp(subexp("\\/\\/" + AUTHORITY$ + PATH_ABEMPTY$) + "|" + PATH_ABSOLUTE$ + "|" + PATH_NOSCHEME$ + "|" + PATH_EMPTY$), RELATIVE$ = subexp(RELATIVE_PART$ + subexp("\\?" + QUERY$) + "?" + subexp("\\#" + FRAGMENT$) + "?"), URI_REFERENCE$ = subexp(URI$ + "|" + RELATIVE$), ABSOLUTE_URI$ = subexp(SCHEME$ + "\\:" + HIER_PART$ + subexp("\\?" + QUERY$) + "?"), GENERIC_REF$ = "^(" + SCHEME$ + ")\\:" + subexp(subexp("\\/\\/(" + subexp("(" + USERINFO$ + ")@") + "?(" + HOST$ + ")" + subexp("\\:(" + PORT$ + ")") + "?)") + "?(" + PATH_ABEMPTY$ + "|" + PATH_ABSOLUTE$ + "|" + PATH_ROOTLESS$ + "|" + PATH_EMPTY$ + ")") + subexp("\\?(" + QUERY$ + ")") + "?" + subexp("\\#(" + FRAGMENT$ + ")") + "?$", RELATIVE_REF$ = "^(){0}" + subexp(subexp("\\/\\/(" + subexp("(" + USERINFO$ + ")@") + "?(" + HOST$ + ")" + subexp("\\:(" + PORT$ + ")") + "?)") + "?(" + PATH_ABEMPTY$ + "|" + PATH_ABSOLUTE$ + "|" + PATH_NOSCHEME$ + "|" + PATH_EMPTY$ + ")") + subexp("\\?(" + QUERY$ + ")") + "?" + subexp("\\#(" + FRAGMENT$ + ")") + "?$", ABSOLUTE_REF$ = "^(" + SCHEME$ + ")\\:" + subexp(subexp("\\/\\/(" + subexp("(" + USERINFO$ + ")@") + "?(" + HOST$ + ")" + subexp("\\:(" + PORT$ + ")") + "?)") + "?(" + PATH_ABEMPTY$ + "|" + PATH_ABSOLUTE$ + "|" + PATH_ROOTLESS$ + "|" + PATH_EMPTY$ + ")") + subexp("\\?(" + QUERY$ + ")") + "?$", SAMEDOC_REF$ = "^" + subexp("\\#(" + FRAGMENT$ + ")") + "?$", AUTHORITY_REF$ = "^" + subexp("(" + USERINFO$ + ")@") + "?(" + HOST$ + ")" + subexp("\\:(" + PORT$ + ")") + "?$";
          return {
            NOT_SCHEME: new RegExp(merge3("[^]", ALPHA$$, DIGIT$$, "[\\+\\-\\.]"), "g"),
            NOT_USERINFO: new RegExp(merge3("[^\\%\\:]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
            NOT_HOST: new RegExp(merge3("[^\\%\\[\\]\\:]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
            NOT_PATH: new RegExp(merge3("[^\\%\\/\\:\\@]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
            NOT_PATH_NOSCHEME: new RegExp(merge3("[^\\%\\/\\@]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
            NOT_QUERY: new RegExp(merge3("[^\\%]", UNRESERVED$$2, SUB_DELIMS$$, "[\\:\\@\\/\\?]", IPRIVATE$$), "g"),
            NOT_FRAGMENT: new RegExp(merge3("[^\\%]", UNRESERVED$$2, SUB_DELIMS$$, "[\\:\\@\\/\\?]"), "g"),
            ESCAPE: new RegExp(merge3("[^]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
            UNRESERVED: new RegExp(UNRESERVED$$2, "g"),
            OTHER_CHARS: new RegExp(merge3("[^\\%]", UNRESERVED$$2, RESERVED$$), "g"),
            PCT_ENCODED: new RegExp(PCT_ENCODED$2, "g"),
            IPV4ADDRESS: new RegExp("^(" + IPV4ADDRESS$ + ")$"),
            IPV6ADDRESS: new RegExp("^\\[?(" + IPV6ADDRESS$ + ")" + subexp(subexp("\\%25|\\%(?!" + HEXDIG$$2 + "{2})") + "(" + ZONEID$ + ")") + "?\\]?$")
          };
        }
        var URI_PROTOCOL = buildExps(false);
        var IRI_PROTOCOL = buildExps(true);
        var slicedToArray = /* @__PURE__ */ function() {
          function sliceIterator(arr, i2) {
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = void 0;
            try {
              for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                _arr.push(_s.value);
                if (i2 && _arr.length === i2)
                  break;
              }
            } catch (err2) {
              _d = true;
              _e = err2;
            } finally {
              try {
                if (!_n && _i["return"])
                  _i["return"]();
              } finally {
                if (_d)
                  throw _e;
              }
            }
            return _arr;
          }
          return function(arr, i2) {
            if (Array.isArray(arr)) {
              return arr;
            } else if (Symbol.iterator in Object(arr)) {
              return sliceIterator(arr, i2);
            } else {
              throw new TypeError("Invalid attempt to destructure non-iterable instance");
            }
          };
        }();
        var toConsumableArray = function(arr) {
          if (Array.isArray(arr)) {
            for (var i2 = 0, arr2 = Array(arr.length); i2 < arr.length; i2++)
              arr2[i2] = arr[i2];
            return arr2;
          } else {
            return Array.from(arr);
          }
        };
        var maxInt2 = 2147483647;
        var base2 = 36;
        var tMin2 = 1;
        var tMax2 = 26;
        var skew2 = 38;
        var damp2 = 700;
        var initialBias2 = 72;
        var initialN2 = 128;
        var delimiter3 = "-";
        var regexPunycode2 = /^xn--/;
        var regexNonASCII2 = /[^\0-\x7E]/;
        var regexSeparators2 = /[\x2E\u3002\uFF0E\uFF61]/g;
        var errors2 = {
          overflow: "Overflow: input needs wider integers to process",
          "not-basic": "Illegal input >= 0x80 (not a basic code point)",
          "invalid-input": "Invalid input"
        };
        var baseMinusTMin2 = base2 - tMin2;
        var floor2 = Math.floor;
        var stringFromCharCode2 = String.fromCharCode;
        function error$1(type) {
          throw new RangeError(errors2[type]);
        }
        function map2(array, fn) {
          var result = [];
          var length = array.length;
          while (length--) {
            result[length] = fn(array[length]);
          }
          return result;
        }
        function mapDomain2(string, fn) {
          var parts2 = string.split("@");
          var result = "";
          if (parts2.length > 1) {
            result = parts2[0] + "@";
            string = parts2[1];
          }
          string = string.replace(regexSeparators2, ".");
          var labels = string.split(".");
          var encoded = map2(labels, fn).join(".");
          return result + encoded;
        }
        function ucs2decode2(string) {
          var output = [];
          var counter = 0;
          var length = string.length;
          while (counter < length) {
            var value = string.charCodeAt(counter++);
            if (value >= 55296 && value <= 56319 && counter < length) {
              var extra = string.charCodeAt(counter++);
              if ((extra & 64512) == 56320) {
                output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
              } else {
                output.push(value);
                counter--;
              }
            } else {
              output.push(value);
            }
          }
          return output;
        }
        var ucs2encode2 = function ucs2encode3(array) {
          return String.fromCodePoint.apply(String, toConsumableArray(array));
        };
        var basicToDigit2 = function basicToDigit3(codePoint) {
          if (codePoint - 48 < 10) {
            return codePoint - 22;
          }
          if (codePoint - 65 < 26) {
            return codePoint - 65;
          }
          if (codePoint - 97 < 26) {
            return codePoint - 97;
          }
          return base2;
        };
        var digitToBasic2 = function digitToBasic3(digit, flag) {
          return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
        };
        var adapt2 = function adapt3(delta, numPoints, firstTime) {
          var k = 0;
          delta = firstTime ? floor2(delta / damp2) : delta >> 1;
          delta += floor2(delta / numPoints);
          for (; delta > baseMinusTMin2 * tMax2 >> 1; k += base2) {
            delta = floor2(delta / baseMinusTMin2);
          }
          return floor2(k + (baseMinusTMin2 + 1) * delta / (delta + skew2));
        };
        var decode4 = function decode5(input) {
          var output = [];
          var inputLength = input.length;
          var i2 = 0;
          var n = initialN2;
          var bias = initialBias2;
          var basic = input.lastIndexOf(delimiter3);
          if (basic < 0) {
            basic = 0;
          }
          for (var j = 0; j < basic; ++j) {
            if (input.charCodeAt(j) >= 128) {
              error$1("not-basic");
            }
            output.push(input.charCodeAt(j));
          }
          for (var index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
            var oldi = i2;
            for (var w = 1, k = base2; ; k += base2) {
              if (index >= inputLength) {
                error$1("invalid-input");
              }
              var digit = basicToDigit2(input.charCodeAt(index++));
              if (digit >= base2 || digit > floor2((maxInt2 - i2) / w)) {
                error$1("overflow");
              }
              i2 += digit * w;
              var t92 = k <= bias ? tMin2 : k >= bias + tMax2 ? tMax2 : k - bias;
              if (digit < t92) {
                break;
              }
              var baseMinusT = base2 - t92;
              if (w > floor2(maxInt2 / baseMinusT)) {
                error$1("overflow");
              }
              w *= baseMinusT;
            }
            var out2 = output.length + 1;
            bias = adapt2(i2 - oldi, out2, oldi == 0);
            if (floor2(i2 / out2) > maxInt2 - n) {
              error$1("overflow");
            }
            n += floor2(i2 / out2);
            i2 %= out2;
            output.splice(i2++, 0, n);
          }
          return String.fromCodePoint.apply(String, output);
        };
        var encode5 = function encode6(input) {
          var output = [];
          input = ucs2decode2(input);
          var inputLength = input.length;
          var n = initialN2;
          var delta = 0;
          var bias = initialBias2;
          var _iteratorNormalCompletion = true;
          var _didIteratorError = false;
          var _iteratorError = void 0;
          try {
            for (var _iterator = input[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
              var _currentValue2 = _step.value;
              if (_currentValue2 < 128) {
                output.push(stringFromCharCode2(_currentValue2));
              }
            }
          } catch (err2) {
            _didIteratorError = true;
            _iteratorError = err2;
          } finally {
            try {
              if (!_iteratorNormalCompletion && _iterator.return) {
                _iterator.return();
              }
            } finally {
              if (_didIteratorError) {
                throw _iteratorError;
              }
            }
          }
          var basicLength = output.length;
          var handledCPCount = basicLength;
          if (basicLength) {
            output.push(delimiter3);
          }
          while (handledCPCount < inputLength) {
            var m2 = maxInt2;
            var _iteratorNormalCompletion2 = true;
            var _didIteratorError2 = false;
            var _iteratorError2 = void 0;
            try {
              for (var _iterator2 = input[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                var currentValue = _step2.value;
                if (currentValue >= n && currentValue < m2) {
                  m2 = currentValue;
                }
              }
            } catch (err2) {
              _didIteratorError2 = true;
              _iteratorError2 = err2;
            } finally {
              try {
                if (!_iteratorNormalCompletion2 && _iterator2.return) {
                  _iterator2.return();
                }
              } finally {
                if (_didIteratorError2) {
                  throw _iteratorError2;
                }
              }
            }
            var handledCPCountPlusOne = handledCPCount + 1;
            if (m2 - n > floor2((maxInt2 - delta) / handledCPCountPlusOne)) {
              error$1("overflow");
            }
            delta += (m2 - n) * handledCPCountPlusOne;
            n = m2;
            var _iteratorNormalCompletion3 = true;
            var _didIteratorError3 = false;
            var _iteratorError3 = void 0;
            try {
              for (var _iterator3 = input[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
                var _currentValue = _step3.value;
                if (_currentValue < n && ++delta > maxInt2) {
                  error$1("overflow");
                }
                if (_currentValue == n) {
                  var q2 = delta;
                  for (var k = base2; ; k += base2) {
                    var t92 = k <= bias ? tMin2 : k >= bias + tMax2 ? tMax2 : k - bias;
                    if (q2 < t92) {
                      break;
                    }
                    var qMinusT = q2 - t92;
                    var baseMinusT = base2 - t92;
                    output.push(stringFromCharCode2(digitToBasic2(t92 + qMinusT % baseMinusT, 0)));
                    q2 = floor2(qMinusT / baseMinusT);
                  }
                  output.push(stringFromCharCode2(digitToBasic2(q2, 0)));
                  bias = adapt2(delta, handledCPCountPlusOne, handledCPCount == basicLength);
                  delta = 0;
                  ++handledCPCount;
                }
              }
            } catch (err2) {
              _didIteratorError3 = true;
              _iteratorError3 = err2;
            } finally {
              try {
                if (!_iteratorNormalCompletion3 && _iterator3.return) {
                  _iterator3.return();
                }
              } finally {
                if (_didIteratorError3) {
                  throw _iteratorError3;
                }
              }
            }
            ++delta;
            ++n;
          }
          return output.join("");
        };
        var toUnicode2 = function toUnicode3(input) {
          return mapDomain2(input, function(string) {
            return regexPunycode2.test(string) ? decode4(string.slice(4).toLowerCase()) : string;
          });
        };
        var toASCII2 = function toASCII3(input) {
          return mapDomain2(input, function(string) {
            return regexNonASCII2.test(string) ? "xn--" + encode5(string) : string;
          });
        };
        var punycode2 = {
          version: "2.1.0",
          ucs2: {
            decode: ucs2decode2,
            encode: ucs2encode2
          },
          decode: decode4,
          encode: encode5,
          toASCII: toASCII2,
          toUnicode: toUnicode2
        };
        var SCHEMES = {};
        function pctEncChar(chr) {
          var c = chr.charCodeAt(0);
          var e = void 0;
          if (c < 16)
            e = "%0" + c.toString(16).toUpperCase();
          else if (c < 128)
            e = "%" + c.toString(16).toUpperCase();
          else if (c < 2048)
            e = "%" + (c >> 6 | 192).toString(16).toUpperCase() + "%" + (c & 63 | 128).toString(16).toUpperCase();
          else
            e = "%" + (c >> 12 | 224).toString(16).toUpperCase() + "%" + (c >> 6 & 63 | 128).toString(16).toUpperCase() + "%" + (c & 63 | 128).toString(16).toUpperCase();
          return e;
        }
        function pctDecChars(str) {
          var newStr = "";
          var i2 = 0;
          var il = str.length;
          while (i2 < il) {
            var c = parseInt(str.substr(i2 + 1, 2), 16);
            if (c < 128) {
              newStr += String.fromCharCode(c);
              i2 += 3;
            } else if (c >= 194 && c < 224) {
              if (il - i2 >= 6) {
                var c2 = parseInt(str.substr(i2 + 4, 2), 16);
                newStr += String.fromCharCode((c & 31) << 6 | c2 & 63);
              } else {
                newStr += str.substr(i2, 6);
              }
              i2 += 6;
            } else if (c >= 224) {
              if (il - i2 >= 9) {
                var _c = parseInt(str.substr(i2 + 4, 2), 16);
                var c3 = parseInt(str.substr(i2 + 7, 2), 16);
                newStr += String.fromCharCode((c & 15) << 12 | (_c & 63) << 6 | c3 & 63);
              } else {
                newStr += str.substr(i2, 9);
              }
              i2 += 9;
            } else {
              newStr += str.substr(i2, 3);
              i2 += 3;
            }
          }
          return newStr;
        }
        function _normalizeComponentEncoding(components, protocol) {
          function decodeUnreserved2(str) {
            var decStr = pctDecChars(str);
            return !decStr.match(protocol.UNRESERVED) ? str : decStr;
          }
          if (components.scheme)
            components.scheme = String(components.scheme).replace(protocol.PCT_ENCODED, decodeUnreserved2).toLowerCase().replace(protocol.NOT_SCHEME, "");
          if (components.userinfo !== void 0)
            components.userinfo = String(components.userinfo).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(protocol.NOT_USERINFO, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
          if (components.host !== void 0)
            components.host = String(components.host).replace(protocol.PCT_ENCODED, decodeUnreserved2).toLowerCase().replace(protocol.NOT_HOST, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
          if (components.path !== void 0)
            components.path = String(components.path).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(components.scheme ? protocol.NOT_PATH : protocol.NOT_PATH_NOSCHEME, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
          if (components.query !== void 0)
            components.query = String(components.query).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(protocol.NOT_QUERY, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
          if (components.fragment !== void 0)
            components.fragment = String(components.fragment).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(protocol.NOT_FRAGMENT, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
          return components;
        }
        function _stripLeadingZeros(str) {
          return str.replace(/^0*(.*)/, "$1") || "0";
        }
        function _normalizeIPv4(host, protocol) {
          var matches = host.match(protocol.IPV4ADDRESS) || [];
          var _matches = slicedToArray(matches, 2), address = _matches[1];
          if (address) {
            return address.split(".").map(_stripLeadingZeros).join(".");
          } else {
            return host;
          }
        }
        function _normalizeIPv6(host, protocol) {
          var matches = host.match(protocol.IPV6ADDRESS) || [];
          var _matches2 = slicedToArray(matches, 3), address = _matches2[1], zone = _matches2[2];
          if (address) {
            var _address$toLowerCase$ = address.toLowerCase().split("::").reverse(), _address$toLowerCase$2 = slicedToArray(_address$toLowerCase$, 2), last = _address$toLowerCase$2[0], first = _address$toLowerCase$2[1];
            var firstFields = first ? first.split(":").map(_stripLeadingZeros) : [];
            var lastFields = last.split(":").map(_stripLeadingZeros);
            var isLastFieldIPv4Address = protocol.IPV4ADDRESS.test(lastFields[lastFields.length - 1]);
            var fieldCount = isLastFieldIPv4Address ? 7 : 8;
            var lastFieldsStart = lastFields.length - fieldCount;
            var fields = Array(fieldCount);
            for (var x = 0; x < fieldCount; ++x) {
              fields[x] = firstFields[x] || lastFields[lastFieldsStart + x] || "";
            }
            if (isLastFieldIPv4Address) {
              fields[fieldCount - 1] = _normalizeIPv4(fields[fieldCount - 1], protocol);
            }
            var allZeroFields = fields.reduce(function(acc, field, index) {
              if (!field || field === "0") {
                var lastLongest = acc[acc.length - 1];
                if (lastLongest && lastLongest.index + lastLongest.length === index) {
                  lastLongest.length++;
                } else {
                  acc.push({ index, length: 1 });
                }
              }
              return acc;
            }, []);
            var longestZeroFields = allZeroFields.sort(function(a, b) {
              return b.length - a.length;
            })[0];
            var newHost = void 0;
            if (longestZeroFields && longestZeroFields.length > 1) {
              var newFirst = fields.slice(0, longestZeroFields.index);
              var newLast = fields.slice(longestZeroFields.index + longestZeroFields.length);
              newHost = newFirst.join(":") + "::" + newLast.join(":");
            } else {
              newHost = fields.join(":");
            }
            if (zone) {
              newHost += "%" + zone;
            }
            return newHost;
          } else {
            return host;
          }
        }
        var URI_PARSE = /^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i;
        var NO_MATCH_IS_UNDEFINED = "".match(/(){0}/)[1] === void 0;
        function parse9(uriString) {
          var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          var components = {};
          var protocol = options.iri !== false ? IRI_PROTOCOL : URI_PROTOCOL;
          if (options.reference === "suffix")
            uriString = (options.scheme ? options.scheme + ":" : "") + "//" + uriString;
          var matches = uriString.match(URI_PARSE);
          if (matches) {
            if (NO_MATCH_IS_UNDEFINED) {
              components.scheme = matches[1];
              components.userinfo = matches[3];
              components.host = matches[4];
              components.port = parseInt(matches[5], 10);
              components.path = matches[6] || "";
              components.query = matches[7];
              components.fragment = matches[8];
              if (isNaN(components.port)) {
                components.port = matches[5];
              }
            } else {
              components.scheme = matches[1] || void 0;
              components.userinfo = uriString.indexOf("@") !== -1 ? matches[3] : void 0;
              components.host = uriString.indexOf("//") !== -1 ? matches[4] : void 0;
              components.port = parseInt(matches[5], 10);
              components.path = matches[6] || "";
              components.query = uriString.indexOf("?") !== -1 ? matches[7] : void 0;
              components.fragment = uriString.indexOf("#") !== -1 ? matches[8] : void 0;
              if (isNaN(components.port)) {
                components.port = uriString.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/) ? matches[4] : void 0;
              }
            }
            if (components.host) {
              components.host = _normalizeIPv6(_normalizeIPv4(components.host, protocol), protocol);
            }
            if (components.scheme === void 0 && components.userinfo === void 0 && components.host === void 0 && components.port === void 0 && !components.path && components.query === void 0) {
              components.reference = "same-document";
            } else if (components.scheme === void 0) {
              components.reference = "relative";
            } else if (components.fragment === void 0) {
              components.reference = "absolute";
            } else {
              components.reference = "uri";
            }
            if (options.reference && options.reference !== "suffix" && options.reference !== components.reference) {
              components.error = components.error || "URI is not a " + options.reference + " reference.";
            }
            var schemeHandler = SCHEMES[(options.scheme || components.scheme || "").toLowerCase()];
            if (!options.unicodeSupport && (!schemeHandler || !schemeHandler.unicodeSupport)) {
              if (components.host && (options.domainHost || schemeHandler && schemeHandler.domainHost)) {
                try {
                  components.host = punycode2.toASCII(components.host.replace(protocol.PCT_ENCODED, pctDecChars).toLowerCase());
                } catch (e) {
                  components.error = components.error || "Host's domain name can not be converted to ASCII via punycode: " + e;
                }
              }
              _normalizeComponentEncoding(components, URI_PROTOCOL);
            } else {
              _normalizeComponentEncoding(components, protocol);
            }
            if (schemeHandler && schemeHandler.parse) {
              schemeHandler.parse(components, options);
            }
          } else {
            components.error = components.error || "URI can not be parsed.";
          }
          return components;
        }
        function _recomposeAuthority(components, options) {
          var protocol = options.iri !== false ? IRI_PROTOCOL : URI_PROTOCOL;
          var uriTokens = [];
          if (components.userinfo !== void 0) {
            uriTokens.push(components.userinfo);
            uriTokens.push("@");
          }
          if (components.host !== void 0) {
            uriTokens.push(_normalizeIPv6(_normalizeIPv4(String(components.host), protocol), protocol).replace(protocol.IPV6ADDRESS, function(_, $1, $2) {
              return "[" + $1 + ($2 ? "%25" + $2 : "") + "]";
            }));
          }
          if (typeof components.port === "number" || typeof components.port === "string") {
            uriTokens.push(":");
            uriTokens.push(String(components.port));
          }
          return uriTokens.length ? uriTokens.join("") : void 0;
        }
        var RDS1 = /^\.\.?\//;
        var RDS2 = /^\/\.(\/|$)/;
        var RDS3 = /^\/\.\.(\/|$)/;
        var RDS5 = /^\/?(?:.|\n)*?(?=\/|$)/;
        function removeDotSegments(input) {
          var output = [];
          while (input.length) {
            if (input.match(RDS1)) {
              input = input.replace(RDS1, "");
            } else if (input.match(RDS2)) {
              input = input.replace(RDS2, "/");
            } else if (input.match(RDS3)) {
              input = input.replace(RDS3, "/");
              output.pop();
            } else if (input === "." || input === "..") {
              input = "";
            } else {
              var im = input.match(RDS5);
              if (im) {
                var s2 = im[0];
                input = input.slice(s2.length);
                output.push(s2);
              } else {
                throw new Error("Unexpected dot segment condition");
              }
            }
          }
          return output.join("");
        }
        function serialize2(components) {
          var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          var protocol = options.iri ? IRI_PROTOCOL : URI_PROTOCOL;
          var uriTokens = [];
          var schemeHandler = SCHEMES[(options.scheme || components.scheme || "").toLowerCase()];
          if (schemeHandler && schemeHandler.serialize)
            schemeHandler.serialize(components, options);
          if (components.host) {
            if (protocol.IPV6ADDRESS.test(components.host)) {
            } else if (options.domainHost || schemeHandler && schemeHandler.domainHost) {
              try {
                components.host = !options.iri ? punycode2.toASCII(components.host.replace(protocol.PCT_ENCODED, pctDecChars).toLowerCase()) : punycode2.toUnicode(components.host);
              } catch (e) {
                components.error = components.error || "Host's domain name can not be converted to " + (!options.iri ? "ASCII" : "Unicode") + " via punycode: " + e;
              }
            }
          }
          _normalizeComponentEncoding(components, protocol);
          if (options.reference !== "suffix" && components.scheme) {
            uriTokens.push(components.scheme);
            uriTokens.push(":");
          }
          var authority = _recomposeAuthority(components, options);
          if (authority !== void 0) {
            if (options.reference !== "suffix") {
              uriTokens.push("//");
            }
            uriTokens.push(authority);
            if (components.path && components.path.charAt(0) !== "/") {
              uriTokens.push("/");
            }
          }
          if (components.path !== void 0) {
            var s2 = components.path;
            if (!options.absolutePath && (!schemeHandler || !schemeHandler.absolutePath)) {
              s2 = removeDotSegments(s2);
            }
            if (authority === void 0) {
              s2 = s2.replace(/^\/\//, "/%2F");
            }
            uriTokens.push(s2);
          }
          if (components.query !== void 0) {
            uriTokens.push("?");
            uriTokens.push(components.query);
          }
          if (components.fragment !== void 0) {
            uriTokens.push("#");
            uriTokens.push(components.fragment);
          }
          return uriTokens.join("");
        }
        function resolveComponents(base22, relative2) {
          var options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
          var skipNormalization = arguments[3];
          var target = {};
          if (!skipNormalization) {
            base22 = parse9(serialize2(base22, options), options);
            relative2 = parse9(serialize2(relative2, options), options);
          }
          options = options || {};
          if (!options.tolerant && relative2.scheme) {
            target.scheme = relative2.scheme;
            target.userinfo = relative2.userinfo;
            target.host = relative2.host;
            target.port = relative2.port;
            target.path = removeDotSegments(relative2.path || "");
            target.query = relative2.query;
          } else {
            if (relative2.userinfo !== void 0 || relative2.host !== void 0 || relative2.port !== void 0) {
              target.userinfo = relative2.userinfo;
              target.host = relative2.host;
              target.port = relative2.port;
              target.path = removeDotSegments(relative2.path || "");
              target.query = relative2.query;
            } else {
              if (!relative2.path) {
                target.path = base22.path;
                if (relative2.query !== void 0) {
                  target.query = relative2.query;
                } else {
                  target.query = base22.query;
                }
              } else {
                if (relative2.path.charAt(0) === "/") {
                  target.path = removeDotSegments(relative2.path);
                } else {
                  if ((base22.userinfo !== void 0 || base22.host !== void 0 || base22.port !== void 0) && !base22.path) {
                    target.path = "/" + relative2.path;
                  } else if (!base22.path) {
                    target.path = relative2.path;
                  } else {
                    target.path = base22.path.slice(0, base22.path.lastIndexOf("/") + 1) + relative2.path;
                  }
                  target.path = removeDotSegments(target.path);
                }
                target.query = relative2.query;
              }
              target.userinfo = base22.userinfo;
              target.host = base22.host;
              target.port = base22.port;
            }
            target.scheme = base22.scheme;
          }
          target.fragment = relative2.fragment;
          return target;
        }
        function resolve3(baseURI, relativeURI, options) {
          var schemelessOptions = assign3({ scheme: "null" }, options);
          return serialize2(resolveComponents(parse9(baseURI, schemelessOptions), parse9(relativeURI, schemelessOptions), schemelessOptions, true), schemelessOptions);
        }
        function normalize4(uri, options) {
          if (typeof uri === "string") {
            uri = serialize2(parse9(uri, options), options);
          } else if (typeOf(uri) === "object") {
            uri = parse9(serialize2(uri, options), options);
          }
          return uri;
        }
        function equal(uriA, uriB, options) {
          if (typeof uriA === "string") {
            uriA = serialize2(parse9(uriA, options), options);
          } else if (typeOf(uriA) === "object") {
            uriA = serialize2(uriA, options);
          }
          if (typeof uriB === "string") {
            uriB = serialize2(parse9(uriB, options), options);
          } else if (typeOf(uriB) === "object") {
            uriB = serialize2(uriB, options);
          }
          return uriA === uriB;
        }
        function escapeComponent(str, options) {
          return str && str.toString().replace(!options || !options.iri ? URI_PROTOCOL.ESCAPE : IRI_PROTOCOL.ESCAPE, pctEncChar);
        }
        function unescapeComponent(str, options) {
          return str && str.toString().replace(!options || !options.iri ? URI_PROTOCOL.PCT_ENCODED : IRI_PROTOCOL.PCT_ENCODED, pctDecChars);
        }
        var handler = {
          scheme: "http",
          domainHost: true,
          parse: function parse10(components, options) {
            if (!components.host) {
              components.error = components.error || "HTTP URIs must have a host.";
            }
            return components;
          },
          serialize: function serialize3(components, options) {
            var secure = String(components.scheme).toLowerCase() === "https";
            if (components.port === (secure ? 443 : 80) || components.port === "") {
              components.port = void 0;
            }
            if (!components.path) {
              components.path = "/";
            }
            return components;
          }
        };
        var handler$1 = {
          scheme: "https",
          domainHost: handler.domainHost,
          parse: handler.parse,
          serialize: handler.serialize
        };
        function isSecure(wsComponents) {
          return typeof wsComponents.secure === "boolean" ? wsComponents.secure : String(wsComponents.scheme).toLowerCase() === "wss";
        }
        var handler$2 = {
          scheme: "ws",
          domainHost: true,
          parse: function parse10(components, options) {
            var wsComponents = components;
            wsComponents.secure = isSecure(wsComponents);
            wsComponents.resourceName = (wsComponents.path || "/") + (wsComponents.query ? "?" + wsComponents.query : "");
            wsComponents.path = void 0;
            wsComponents.query = void 0;
            return wsComponents;
          },
          serialize: function serialize3(wsComponents, options) {
            if (wsComponents.port === (isSecure(wsComponents) ? 443 : 80) || wsComponents.port === "") {
              wsComponents.port = void 0;
            }
            if (typeof wsComponents.secure === "boolean") {
              wsComponents.scheme = wsComponents.secure ? "wss" : "ws";
              wsComponents.secure = void 0;
            }
            if (wsComponents.resourceName) {
              var _wsComponents$resourc = wsComponents.resourceName.split("?"), _wsComponents$resourc2 = slicedToArray(_wsComponents$resourc, 2), path15 = _wsComponents$resourc2[0], query2 = _wsComponents$resourc2[1];
              wsComponents.path = path15 && path15 !== "/" ? path15 : void 0;
              wsComponents.query = query2;
              wsComponents.resourceName = void 0;
            }
            wsComponents.fragment = void 0;
            return wsComponents;
          }
        };
        var handler$3 = {
          scheme: "wss",
          domainHost: handler$2.domainHost,
          parse: handler$2.parse,
          serialize: handler$2.serialize
        };
        var O = {};
        var isIRI = true;
        var UNRESERVED$$ = "[A-Za-z0-9\\-\\.\\_\\~" + (isIRI ? "\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF" : "") + "]";
        var HEXDIG$$ = "[0-9A-Fa-f]";
        var PCT_ENCODED$ = subexp(subexp("%[EFef]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%[89A-Fa-f]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%" + HEXDIG$$ + HEXDIG$$));
        var ATEXT$$ = "[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]";
        var QTEXT$$ = "[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]";
        var VCHAR$$ = merge3(QTEXT$$, '[\\"\\\\]');
        var SOME_DELIMS$$ = "[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]";
        var UNRESERVED = new RegExp(UNRESERVED$$, "g");
        var PCT_ENCODED = new RegExp(PCT_ENCODED$, "g");
        var NOT_LOCAL_PART = new RegExp(merge3("[^]", ATEXT$$, "[\\.]", '[\\"]', VCHAR$$), "g");
        var NOT_HFNAME = new RegExp(merge3("[^]", UNRESERVED$$, SOME_DELIMS$$), "g");
        var NOT_HFVALUE = NOT_HFNAME;
        function decodeUnreserved(str) {
          var decStr = pctDecChars(str);
          return !decStr.match(UNRESERVED) ? str : decStr;
        }
        var handler$4 = {
          scheme: "mailto",
          parse: function parse$$1(components, options) {
            var mailtoComponents = components;
            var to = mailtoComponents.to = mailtoComponents.path ? mailtoComponents.path.split(",") : [];
            mailtoComponents.path = void 0;
            if (mailtoComponents.query) {
              var unknownHeaders = false;
              var headers = {};
              var hfields = mailtoComponents.query.split("&");
              for (var x = 0, xl = hfields.length; x < xl; ++x) {
                var hfield = hfields[x].split("=");
                switch (hfield[0]) {
                  case "to":
                    var toAddrs = hfield[1].split(",");
                    for (var _x = 0, _xl = toAddrs.length; _x < _xl; ++_x) {
                      to.push(toAddrs[_x]);
                    }
                    break;
                  case "subject":
                    mailtoComponents.subject = unescapeComponent(hfield[1], options);
                    break;
                  case "body":
                    mailtoComponents.body = unescapeComponent(hfield[1], options);
                    break;
                  default:
                    unknownHeaders = true;
                    headers[unescapeComponent(hfield[0], options)] = unescapeComponent(hfield[1], options);
                    break;
                }
              }
              if (unknownHeaders)
                mailtoComponents.headers = headers;
            }
            mailtoComponents.query = void 0;
            for (var _x2 = 0, _xl2 = to.length; _x2 < _xl2; ++_x2) {
              var addr2 = to[_x2].split("@");
              addr2[0] = unescapeComponent(addr2[0]);
              if (!options.unicodeSupport) {
                try {
                  addr2[1] = punycode2.toASCII(unescapeComponent(addr2[1], options).toLowerCase());
                } catch (e) {
                  mailtoComponents.error = mailtoComponents.error || "Email address's domain name can not be converted to ASCII via punycode: " + e;
                }
              } else {
                addr2[1] = unescapeComponent(addr2[1], options).toLowerCase();
              }
              to[_x2] = addr2.join("@");
            }
            return mailtoComponents;
          },
          serialize: function serialize$$1(mailtoComponents, options) {
            var components = mailtoComponents;
            var to = toArray(mailtoComponents.to);
            if (to) {
              for (var x = 0, xl = to.length; x < xl; ++x) {
                var toAddr = String(to[x]);
                var atIdx = toAddr.lastIndexOf("@");
                var localPart = toAddr.slice(0, atIdx).replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_LOCAL_PART, pctEncChar);
                var domain = toAddr.slice(atIdx + 1);
                try {
                  domain = !options.iri ? punycode2.toASCII(unescapeComponent(domain, options).toLowerCase()) : punycode2.toUnicode(domain);
                } catch (e) {
                  components.error = components.error || "Email address's domain name can not be converted to " + (!options.iri ? "ASCII" : "Unicode") + " via punycode: " + e;
                }
                to[x] = localPart + "@" + domain;
              }
              components.path = to.join(",");
            }
            var headers = mailtoComponents.headers = mailtoComponents.headers || {};
            if (mailtoComponents.subject)
              headers["subject"] = mailtoComponents.subject;
            if (mailtoComponents.body)
              headers["body"] = mailtoComponents.body;
            var fields = [];
            for (var name3 in headers) {
              if (headers[name3] !== O[name3]) {
                fields.push(name3.replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_HFNAME, pctEncChar) + "=" + headers[name3].replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_HFVALUE, pctEncChar));
              }
            }
            if (fields.length) {
              components.query = fields.join("&");
            }
            return components;
          }
        };
        var URN_PARSE = /^([^\:]+)\:(.*)/;
        var handler$5 = {
          scheme: "urn",
          parse: function parse$$1(components, options) {
            var matches = components.path && components.path.match(URN_PARSE);
            var urnComponents = components;
            if (matches) {
              var scheme = options.scheme || urnComponents.scheme || "urn";
              var nid = matches[1].toLowerCase();
              var nss = matches[2];
              var urnScheme = scheme + ":" + (options.nid || nid);
              var schemeHandler = SCHEMES[urnScheme];
              urnComponents.nid = nid;
              urnComponents.nss = nss;
              urnComponents.path = void 0;
              if (schemeHandler) {
                urnComponents = schemeHandler.parse(urnComponents, options);
              }
            } else {
              urnComponents.error = urnComponents.error || "URN can not be parsed.";
            }
            return urnComponents;
          },
          serialize: function serialize$$1(urnComponents, options) {
            var scheme = options.scheme || urnComponents.scheme || "urn";
            var nid = urnComponents.nid;
            var urnScheme = scheme + ":" + (options.nid || nid);
            var schemeHandler = SCHEMES[urnScheme];
            if (schemeHandler) {
              urnComponents = schemeHandler.serialize(urnComponents, options);
            }
            var uriComponents = urnComponents;
            var nss = urnComponents.nss;
            uriComponents.path = (nid || options.nid) + ":" + nss;
            return uriComponents;
          }
        };
        var UUID = /^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/;
        var handler$6 = {
          scheme: "urn:uuid",
          parse: function parse10(urnComponents, options) {
            var uuidComponents = urnComponents;
            uuidComponents.uuid = uuidComponents.nss;
            uuidComponents.nss = void 0;
            if (!options.tolerant && (!uuidComponents.uuid || !uuidComponents.uuid.match(UUID))) {
              uuidComponents.error = uuidComponents.error || "UUID is not valid.";
            }
            return uuidComponents;
          },
          serialize: function serialize3(uuidComponents, options) {
            var urnComponents = uuidComponents;
            urnComponents.nss = (uuidComponents.uuid || "").toLowerCase();
            return urnComponents;
          }
        };
        SCHEMES[handler.scheme] = handler;
        SCHEMES[handler$1.scheme] = handler$1;
        SCHEMES[handler$2.scheme] = handler$2;
        SCHEMES[handler$3.scheme] = handler$3;
        SCHEMES[handler$4.scheme] = handler$4;
        SCHEMES[handler$5.scheme] = handler$5;
        SCHEMES[handler$6.scheme] = handler$6;
        exports22.SCHEMES = SCHEMES;
        exports22.pctEncChar = pctEncChar;
        exports22.pctDecChars = pctDecChars;
        exports22.parse = parse9;
        exports22.removeDotSegments = removeDotSegments;
        exports22.serialize = serialize2;
        exports22.resolveComponents = resolveComponents;
        exports22.resolve = resolve3;
        exports22.normalize = normalize4;
        exports22.equal = equal;
        exports22.escapeComponent = escapeComponent;
        exports22.unescapeComponent = unescapeComponent;
        Object.defineProperty(exports22, "__esModule", { value: true });
      });
    });
    require_fast_deep_equal2 = __commonJS2((exports2, module2) => {
      module2.exports = function equal(a, b) {
        if (a === b)
          return true;
        if (a && b && typeof a == "object" && typeof b == "object") {
          if (a.constructor !== b.constructor)
            return false;
          var length, i2, keys;
          if (Array.isArray(a)) {
            length = a.length;
            if (length != b.length)
              return false;
            for (i2 = length; i2-- !== 0; )
              if (!equal(a[i2], b[i2]))
                return false;
            return true;
          }
          if (a.constructor === RegExp)
            return a.source === b.source && a.flags === b.flags;
          if (a.valueOf !== Object.prototype.valueOf)
            return a.valueOf() === b.valueOf();
          if (a.toString !== Object.prototype.toString)
            return a.toString() === b.toString();
          keys = Object.keys(a);
          length = keys.length;
          if (length !== Object.keys(b).length)
            return false;
          for (i2 = length; i2-- !== 0; )
            if (!Object.prototype.hasOwnProperty.call(b, keys[i2]))
              return false;
          for (i2 = length; i2-- !== 0; ) {
            var key = keys[i2];
            if (!equal(a[key], b[key]))
              return false;
          }
          return true;
        }
        return a !== a && b !== b;
      };
    });
    require_ucs2length2 = __commonJS2((exports2, module2) => {
      module2.exports = function ucs2length(str) {
        var length = 0, len = str.length, pos2 = 0, value;
        while (pos2 < len) {
          length++;
          value = str.charCodeAt(pos2++);
          if (value >= 55296 && value <= 56319 && pos2 < len) {
            value = str.charCodeAt(pos2);
            if ((value & 64512) == 56320)
              pos2++;
          }
        }
        return length;
      };
    });
    require_util2 = __commonJS2((exports2, module2) => {
      module2.exports = {
        copy,
        checkDataType,
        checkDataTypes,
        coerceToTypes,
        toHash,
        getProperty,
        escapeQuotes,
        equal: require_fast_deep_equal2(),
        ucs2length: require_ucs2length2(),
        varOccurences,
        varReplace,
        schemaHasRules,
        schemaHasRulesExcept,
        schemaUnknownRules,
        toQuotedString,
        getPathExpr,
        getPath,
        getData,
        unescapeFragment,
        unescapeJsonPointer,
        escapeFragment,
        escapeJsonPointer
      };
      function copy(o, to) {
        to = to || {};
        for (var key in o)
          to[key] = o[key];
        return to;
      }
      function checkDataType(dataType, data, strictNumbers, negate) {
        var EQUAL = negate ? " !== " : " === ", AND = negate ? " || " : " && ", OK2 = negate ? "!" : "", NOT = negate ? "" : "!";
        switch (dataType) {
          case "null":
            return data + EQUAL + "null";
          case "array":
            return OK2 + "Array.isArray(" + data + ")";
          case "object":
            return "(" + OK2 + data + AND + "typeof " + data + EQUAL + '"object"' + AND + NOT + "Array.isArray(" + data + "))";
          case "integer":
            return "(typeof " + data + EQUAL + '"number"' + AND + NOT + "(" + data + " % 1)" + AND + data + EQUAL + data + (strictNumbers ? AND + OK2 + "isFinite(" + data + ")" : "") + ")";
          case "number":
            return "(typeof " + data + EQUAL + '"' + dataType + '"' + (strictNumbers ? AND + OK2 + "isFinite(" + data + ")" : "") + ")";
          default:
            return "typeof " + data + EQUAL + '"' + dataType + '"';
        }
      }
      function checkDataTypes(dataTypes, data, strictNumbers) {
        switch (dataTypes.length) {
          case 1:
            return checkDataType(dataTypes[0], data, strictNumbers, true);
          default:
            var code3 = "";
            var types2 = toHash(dataTypes);
            if (types2.array && types2.object) {
              code3 = types2.null ? "(" : "(!" + data + " || ";
              code3 += "typeof " + data + ' !== "object")';
              delete types2.null;
              delete types2.array;
              delete types2.object;
            }
            if (types2.number)
              delete types2.integer;
            for (var t92 in types2)
              code3 += (code3 ? " && " : "") + checkDataType(t92, data, strictNumbers, true);
            return code3;
        }
      }
      var COERCE_TO_TYPES = toHash(["string", "number", "integer", "boolean", "null"]);
      function coerceToTypes(optionCoerceTypes, dataTypes) {
        if (Array.isArray(dataTypes)) {
          var types2 = [];
          for (var i2 = 0; i2 < dataTypes.length; i2++) {
            var t92 = dataTypes[i2];
            if (COERCE_TO_TYPES[t92])
              types2[types2.length] = t92;
            else if (optionCoerceTypes === "array" && t92 === "array")
              types2[types2.length] = t92;
          }
          if (types2.length)
            return types2;
        } else if (COERCE_TO_TYPES[dataTypes]) {
          return [dataTypes];
        } else if (optionCoerceTypes === "array" && dataTypes === "array") {
          return ["array"];
        }
      }
      function toHash(arr) {
        var hash2 = {};
        for (var i2 = 0; i2 < arr.length; i2++)
          hash2[arr[i2]] = true;
        return hash2;
      }
      var IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
      var SINGLE_QUOTE = /'|\\/g;
      function getProperty(key) {
        return typeof key == "number" ? "[" + key + "]" : IDENTIFIER.test(key) ? "." + key : "['" + escapeQuotes(key) + "']";
      }
      function escapeQuotes(str) {
        return str.replace(SINGLE_QUOTE, "\\$&").replace(/\n/g, "\\n").replace(/\r/g, "\\r").replace(/\f/g, "\\f").replace(/\t/g, "\\t");
      }
      function varOccurences(str, dataVar) {
        dataVar += "[^0-9]";
        var matches = str.match(new RegExp(dataVar, "g"));
        return matches ? matches.length : 0;
      }
      function varReplace(str, dataVar, expr) {
        dataVar += "([^0-9])";
        expr = expr.replace(/\$/g, "$$$$");
        return str.replace(new RegExp(dataVar, "g"), expr + "$1");
      }
      function schemaHasRules(schema, rules) {
        if (typeof schema == "boolean")
          return !schema;
        for (var key in schema)
          if (rules[key])
            return true;
      }
      function schemaHasRulesExcept(schema, rules, exceptKeyword) {
        if (typeof schema == "boolean")
          return !schema && exceptKeyword != "not";
        for (var key in schema)
          if (key != exceptKeyword && rules[key])
            return true;
      }
      function schemaUnknownRules(schema, rules) {
        if (typeof schema == "boolean")
          return;
        for (var key in schema)
          if (!rules[key])
            return key;
      }
      function toQuotedString(str) {
        return "'" + escapeQuotes(str) + "'";
      }
      function getPathExpr(currentPath, expr, jsonPointers, isNumber4) {
        var path15 = jsonPointers ? "'/' + " + expr + (isNumber4 ? "" : ".replace(/~/g, '~0').replace(/\\//g, '~1')") : isNumber4 ? "'[' + " + expr + " + ']'" : "'[\\'' + " + expr + " + '\\']'";
        return joinPaths(currentPath, path15);
      }
      function getPath(currentPath, prop, jsonPointers) {
        var path15 = jsonPointers ? toQuotedString("/" + escapeJsonPointer(prop)) : toQuotedString(getProperty(prop));
        return joinPaths(currentPath, path15);
      }
      var JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
      var RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
      function getData($data, lvl, paths) {
        var up, jsonPointer, data, matches;
        if ($data === "")
          return "rootData";
        if ($data[0] == "/") {
          if (!JSON_POINTER.test($data))
            throw new Error("Invalid JSON-pointer: " + $data);
          jsonPointer = $data;
          data = "rootData";
        } else {
          matches = $data.match(RELATIVE_JSON_POINTER);
          if (!matches)
            throw new Error("Invalid JSON-pointer: " + $data);
          up = +matches[1];
          jsonPointer = matches[2];
          if (jsonPointer == "#") {
            if (up >= lvl)
              throw new Error("Cannot access property/index " + up + " levels up, current level is " + lvl);
            return paths[lvl - up];
          }
          if (up > lvl)
            throw new Error("Cannot access data " + up + " levels up, current level is " + lvl);
          data = "data" + (lvl - up || "");
          if (!jsonPointer)
            return data;
        }
        var expr = data;
        var segments = jsonPointer.split("/");
        for (var i2 = 0; i2 < segments.length; i2++) {
          var segment = segments[i2];
          if (segment) {
            data += getProperty(unescapeJsonPointer(segment));
            expr += " && " + data;
          }
        }
        return expr;
      }
      function joinPaths(a, b) {
        if (a == '""')
          return b;
        return (a + " + " + b).replace(/([^\\])' \+ '/g, "$1");
      }
      function unescapeFragment(str) {
        return unescapeJsonPointer(decodeURIComponent(str));
      }
      function escapeFragment(str) {
        return encodeURIComponent(escapeJsonPointer(str));
      }
      function escapeJsonPointer(str) {
        return str.replace(/~/g, "~0").replace(/\//g, "~1");
      }
      function unescapeJsonPointer(str) {
        return str.replace(/~1/g, "/").replace(/~0/g, "~");
      }
    });
    require_schema_obj = __commonJS2((exports2, module2) => {
      var util32 = require_util2();
      module2.exports = SchemaObject;
      function SchemaObject(obj) {
        util32.copy(obj, this);
      }
    });
    require_json_schema_traverse2 = __commonJS2((exports2, module2) => {
      var traverse = module2.exports = function(schema, opts, cb) {
        if (typeof opts == "function") {
          cb = opts;
          opts = {};
        }
        cb = opts.cb || cb;
        var pre = typeof cb == "function" ? cb : cb.pre || function() {
        };
        var post = cb.post || function() {
        };
        _traverse(opts, pre, post, schema, "", schema);
      };
      traverse.keywords = {
        additionalItems: true,
        items: true,
        contains: true,
        additionalProperties: true,
        propertyNames: true,
        not: true
      };
      traverse.arrayKeywords = {
        items: true,
        allOf: true,
        anyOf: true,
        oneOf: true
      };
      traverse.propsKeywords = {
        definitions: true,
        properties: true,
        patternProperties: true,
        dependencies: true
      };
      traverse.skipKeywords = {
        default: true,
        enum: true,
        const: true,
        required: true,
        maximum: true,
        minimum: true,
        exclusiveMaximum: true,
        exclusiveMinimum: true,
        multipleOf: true,
        maxLength: true,
        minLength: true,
        pattern: true,
        format: true,
        maxItems: true,
        minItems: true,
        uniqueItems: true,
        maxProperties: true,
        minProperties: true
      };
      function _traverse(opts, pre, post, schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
        if (schema && typeof schema == "object" && !Array.isArray(schema)) {
          pre(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
          for (var key in schema) {
            var sch = schema[key];
            if (Array.isArray(sch)) {
              if (key in traverse.arrayKeywords) {
                for (var i2 = 0; i2 < sch.length; i2++)
                  _traverse(opts, pre, post, sch[i2], jsonPtr + "/" + key + "/" + i2, rootSchema, jsonPtr, key, schema, i2);
              }
            } else if (key in traverse.propsKeywords) {
              if (sch && typeof sch == "object") {
                for (var prop in sch)
                  _traverse(opts, pre, post, sch[prop], jsonPtr + "/" + key + "/" + escapeJsonPtr(prop), rootSchema, jsonPtr, key, schema, prop);
              }
            } else if (key in traverse.keywords || opts.allKeys && !(key in traverse.skipKeywords)) {
              _traverse(opts, pre, post, sch, jsonPtr + "/" + key, rootSchema, jsonPtr, key, schema);
            }
          }
          post(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
        }
      }
      function escapeJsonPtr(str) {
        return str.replace(/~/g, "~0").replace(/\//g, "~1");
      }
    });
    require_resolve2 = __commonJS2((exports2, module2) => {
      var URI2 = require_uri_all();
      var equal = require_fast_deep_equal2();
      var util32 = require_util2();
      var SchemaObject = require_schema_obj();
      var traverse = require_json_schema_traverse2();
      module2.exports = resolve3;
      resolve3.normalizeId = normalizeId;
      resolve3.fullPath = getFullPath;
      resolve3.url = resolveUrl;
      resolve3.ids = resolveIds;
      resolve3.inlineRef = inlineRef;
      resolve3.schema = resolveSchema;
      function resolve3(compile2, root, ref) {
        var refVal = this._refs[ref];
        if (typeof refVal == "string") {
          if (this._refs[refVal])
            refVal = this._refs[refVal];
          else
            return resolve3.call(this, compile2, root, refVal);
        }
        refVal = refVal || this._schemas[ref];
        if (refVal instanceof SchemaObject) {
          return inlineRef(refVal.schema, this._opts.inlineRefs) ? refVal.schema : refVal.validate || this._compile(refVal);
        }
        var res = resolveSchema.call(this, root, ref);
        var schema, v, baseId;
        if (res) {
          schema = res.schema;
          root = res.root;
          baseId = res.baseId;
        }
        if (schema instanceof SchemaObject) {
          v = schema.validate || compile2.call(this, schema.schema, root, void 0, baseId);
        } else if (schema !== void 0) {
          v = inlineRef(schema, this._opts.inlineRefs) ? schema : compile2.call(this, schema, root, void 0, baseId);
        }
        return v;
      }
      function resolveSchema(root, ref) {
        var p2 = URI2.parse(ref), refPath = _getFullPath(p2), baseId = getFullPath(this._getId(root.schema));
        if (Object.keys(root.schema).length === 0 || refPath !== baseId) {
          var id2 = normalizeId(refPath);
          var refVal = this._refs[id2];
          if (typeof refVal == "string") {
            return resolveRecursive.call(this, root, refVal, p2);
          } else if (refVal instanceof SchemaObject) {
            if (!refVal.validate)
              this._compile(refVal);
            root = refVal;
          } else {
            refVal = this._schemas[id2];
            if (refVal instanceof SchemaObject) {
              if (!refVal.validate)
                this._compile(refVal);
              if (id2 == normalizeId(ref))
                return { schema: refVal, root, baseId };
              root = refVal;
            } else {
              return;
            }
          }
          if (!root.schema)
            return;
          baseId = getFullPath(this._getId(root.schema));
        }
        return getJsonPointer.call(this, p2, baseId, root.schema, root);
      }
      function resolveRecursive(root, ref, parsedRef) {
        var res = resolveSchema.call(this, root, ref);
        if (res) {
          var schema = res.schema;
          var baseId = res.baseId;
          root = res.root;
          var id2 = this._getId(schema);
          if (id2)
            baseId = resolveUrl(baseId, id2);
          return getJsonPointer.call(this, parsedRef, baseId, schema, root);
        }
      }
      var PREVENT_SCOPE_CHANGE = util32.toHash(["properties", "patternProperties", "enum", "dependencies", "definitions"]);
      function getJsonPointer(parsedRef, baseId, schema, root) {
        parsedRef.fragment = parsedRef.fragment || "";
        if (parsedRef.fragment.slice(0, 1) != "/")
          return;
        var parts2 = parsedRef.fragment.split("/");
        for (var i2 = 1; i2 < parts2.length; i2++) {
          var part = parts2[i2];
          if (part) {
            part = util32.unescapeFragment(part);
            schema = schema[part];
            if (schema === void 0)
              break;
            var id2;
            if (!PREVENT_SCOPE_CHANGE[part]) {
              id2 = this._getId(schema);
              if (id2)
                baseId = resolveUrl(baseId, id2);
              if (schema.$ref) {
                var $ref = resolveUrl(baseId, schema.$ref);
                var res = resolveSchema.call(this, root, $ref);
                if (res) {
                  schema = res.schema;
                  root = res.root;
                  baseId = res.baseId;
                }
              }
            }
          }
        }
        if (schema !== void 0 && schema !== root.schema)
          return { schema, root, baseId };
      }
      var SIMPLE_INLINED = util32.toHash([
        "type",
        "format",
        "pattern",
        "maxLength",
        "minLength",
        "maxProperties",
        "minProperties",
        "maxItems",
        "minItems",
        "maximum",
        "minimum",
        "uniqueItems",
        "multipleOf",
        "required",
        "enum"
      ]);
      function inlineRef(schema, limit) {
        if (limit === false)
          return false;
        if (limit === void 0 || limit === true)
          return checkNoRef(schema);
        else if (limit)
          return countKeys(schema) <= limit;
      }
      function checkNoRef(schema) {
        var item;
        if (Array.isArray(schema)) {
          for (var i2 = 0; i2 < schema.length; i2++) {
            item = schema[i2];
            if (typeof item == "object" && !checkNoRef(item))
              return false;
          }
        } else {
          for (var key in schema) {
            if (key == "$ref")
              return false;
            item = schema[key];
            if (typeof item == "object" && !checkNoRef(item))
              return false;
          }
        }
        return true;
      }
      function countKeys(schema) {
        var count2 = 0, item;
        if (Array.isArray(schema)) {
          for (var i2 = 0; i2 < schema.length; i2++) {
            item = schema[i2];
            if (typeof item == "object")
              count2 += countKeys(item);
            if (count2 == Infinity)
              return Infinity;
          }
        } else {
          for (var key in schema) {
            if (key == "$ref")
              return Infinity;
            if (SIMPLE_INLINED[key]) {
              count2++;
            } else {
              item = schema[key];
              if (typeof item == "object")
                count2 += countKeys(item) + 1;
              if (count2 == Infinity)
                return Infinity;
            }
          }
        }
        return count2;
      }
      function getFullPath(id2, normalize4) {
        if (normalize4 !== false)
          id2 = normalizeId(id2);
        var p2 = URI2.parse(id2);
        return _getFullPath(p2);
      }
      function _getFullPath(p2) {
        return URI2.serialize(p2).split("#")[0] + "#";
      }
      var TRAILING_SLASH_HASH = /#\/?$/;
      function normalizeId(id2) {
        return id2 ? id2.replace(TRAILING_SLASH_HASH, "") : "";
      }
      function resolveUrl(baseId, id2) {
        id2 = normalizeId(id2);
        return URI2.resolve(baseId, id2);
      }
      function resolveIds(schema) {
        var schemaId = normalizeId(this._getId(schema));
        var baseIds = { "": schemaId };
        var fullPaths = { "": getFullPath(schemaId, false) };
        var localRefs = {};
        var self2 = this;
        traverse(schema, { allKeys: true }, function(sch, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
          if (jsonPtr === "")
            return;
          var id2 = self2._getId(sch);
          var baseId = baseIds[parentJsonPtr];
          var fullPath = fullPaths[parentJsonPtr] + "/" + parentKeyword;
          if (keyIndex !== void 0)
            fullPath += "/" + (typeof keyIndex == "number" ? keyIndex : util32.escapeFragment(keyIndex));
          if (typeof id2 == "string") {
            id2 = baseId = normalizeId(baseId ? URI2.resolve(baseId, id2) : id2);
            var refVal = self2._refs[id2];
            if (typeof refVal == "string")
              refVal = self2._refs[refVal];
            if (refVal && refVal.schema) {
              if (!equal(sch, refVal.schema))
                throw new Error('id "' + id2 + '" resolves to more than one schema');
            } else if (id2 != normalizeId(fullPath)) {
              if (id2[0] == "#") {
                if (localRefs[id2] && !equal(sch, localRefs[id2]))
                  throw new Error('id "' + id2 + '" resolves to more than one schema');
                localRefs[id2] = sch;
              } else {
                self2._refs[id2] = fullPath;
              }
            }
          }
          baseIds[jsonPtr] = baseId;
          fullPaths[jsonPtr] = fullPath;
        });
        return localRefs;
      }
    });
    require_error_classes = __commonJS2((exports2, module2) => {
      var resolve3 = require_resolve2();
      module2.exports = {
        Validation: errorSubclass(ValidationError),
        MissingRef: errorSubclass(MissingRefError)
      };
      function ValidationError(errors2) {
        this.message = "validation failed";
        this.errors = errors2;
        this.ajv = this.validation = true;
      }
      MissingRefError.message = function(baseId, ref) {
        return "can't resolve reference " + ref + " from id " + baseId;
      };
      function MissingRefError(baseId, ref, message) {
        this.message = message || MissingRefError.message(baseId, ref);
        this.missingRef = resolve3.url(baseId, ref);
        this.missingSchema = resolve3.normalizeId(resolve3.fullPath(this.missingRef));
      }
      function errorSubclass(Subclass) {
        Subclass.prototype = Object.create(Error.prototype);
        Subclass.prototype.constructor = Subclass;
        return Subclass;
      }
    });
    require_fast_json_stable_stringify = __commonJS2((exports2, module2) => {
      module2.exports = function(data, opts) {
        if (!opts)
          opts = {};
        if (typeof opts === "function")
          opts = { cmp: opts };
        var cycles = typeof opts.cycles === "boolean" ? opts.cycles : false;
        var cmp = opts.cmp && /* @__PURE__ */ function(f2) {
          return function(node) {
            return function(a, b) {
              var aobj = { key: a, value: node[a] };
              var bobj = { key: b, value: node[b] };
              return f2(aobj, bobj);
            };
          };
        }(opts.cmp);
        var seen = [];
        return function stringify2(node) {
          if (node && node.toJSON && typeof node.toJSON === "function") {
            node = node.toJSON();
          }
          if (node === void 0)
            return;
          if (typeof node == "number")
            return isFinite(node) ? "" + node : "null";
          if (typeof node !== "object")
            return JSON.stringify(node);
          var i2, out2;
          if (Array.isArray(node)) {
            out2 = "[";
            for (i2 = 0; i2 < node.length; i2++) {
              if (i2)
                out2 += ",";
              out2 += stringify2(node[i2]) || "null";
            }
            return out2 + "]";
          }
          if (node === null)
            return "null";
          if (seen.indexOf(node) !== -1) {
            if (cycles)
              return JSON.stringify("__cycle__");
            throw new TypeError("Converting circular structure to JSON");
          }
          var seenIndex = seen.push(node) - 1;
          var keys = Object.keys(node).sort(cmp && cmp(node));
          out2 = "";
          for (i2 = 0; i2 < keys.length; i2++) {
            var key = keys[i2];
            var value = stringify2(node[key]);
            if (!value)
              continue;
            if (out2)
              out2 += ",";
            out2 += JSON.stringify(key) + ":" + value;
          }
          seen.splice(seenIndex, 1);
          return "{" + out2 + "}";
        }(data);
      };
    });
    require_validate2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_validate(it, $keyword, $ruleType) {
        var out2 = "";
        var $async = it.schema.$async === true, $refKeywords = it.util.schemaHasRulesExcept(it.schema, it.RULES.all, "$ref"), $id = it.self._getId(it.schema);
        if (it.opts.strictKeywords) {
          var $unknownKwd = it.util.schemaUnknownRules(it.schema, it.RULES.keywords);
          if ($unknownKwd) {
            var $keywordsMsg = "unknown keyword: " + $unknownKwd;
            if (it.opts.strictKeywords === "log")
              it.logger.warn($keywordsMsg);
            else
              throw new Error($keywordsMsg);
          }
        }
        if (it.isTop) {
          out2 += " var validate = ";
          if ($async) {
            it.async = true;
            out2 += "async ";
          }
          out2 += "function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ";
          if ($id && (it.opts.sourceCode || it.opts.processCode)) {
            out2 += " " + ("/*# sourceURL=" + $id + " */") + " ";
          }
        }
        if (typeof it.schema == "boolean" || !($refKeywords || it.schema.$ref)) {
          var $keyword = "false schema";
          var $lvl = it.level;
          var $dataLvl = it.dataLevel;
          var $schema = it.schema[$keyword];
          var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
          var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
          var $breakOnError = !it.opts.allErrors;
          var $errorKeyword;
          var $data = "data" + ($dataLvl || "");
          var $valid = "valid" + $lvl;
          if (it.schema === false) {
            if (it.isTop) {
              $breakOnError = true;
            } else {
              out2 += " var " + $valid + " = false; ";
            }
            var $$outStack = $$outStack || [];
            $$outStack.push(out2);
            out2 = "";
            if (it.createErrors !== false) {
              out2 += " { keyword: '" + ($errorKeyword || "false schema") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
              if (it.opts.messages !== false) {
                out2 += " , message: 'boolean schema is false' ";
              }
              if (it.opts.verbose) {
                out2 += " , schema: false , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
              }
              out2 += " } ";
            } else {
              out2 += " {} ";
            }
            var __err = out2;
            out2 = $$outStack.pop();
            if (!it.compositeRule && $breakOnError) {
              if (it.async) {
                out2 += " throw new ValidationError([" + __err + "]); ";
              } else {
                out2 += " validate.errors = [" + __err + "]; return false; ";
              }
            } else {
              out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
            }
          } else {
            if (it.isTop) {
              if ($async) {
                out2 += " return data; ";
              } else {
                out2 += " validate.errors = null; return true; ";
              }
            } else {
              out2 += " var " + $valid + " = true; ";
            }
          }
          if (it.isTop) {
            out2 += " }; return validate; ";
          }
          return out2;
        }
        if (it.isTop) {
          var $top = it.isTop, $lvl = it.level = 0, $dataLvl = it.dataLevel = 0, $data = "data";
          it.rootId = it.resolve.fullPath(it.self._getId(it.root.schema));
          it.baseId = it.baseId || it.rootId;
          delete it.isTop;
          it.dataPathArr = [""];
          if (it.schema.default !== void 0 && it.opts.useDefaults && it.opts.strictDefaults) {
            var $defaultMsg = "default is ignored in the schema root";
            if (it.opts.strictDefaults === "log")
              it.logger.warn($defaultMsg);
            else
              throw new Error($defaultMsg);
          }
          out2 += " var vErrors = null; ";
          out2 += " var errors = 0;     ";
          out2 += " if (rootData === undefined) rootData = data; ";
        } else {
          var { level: $lvl, dataLevel: $dataLvl } = it, $data = "data" + ($dataLvl || "");
          if ($id)
            it.baseId = it.resolve.url(it.baseId, $id);
          if ($async && !it.async)
            throw new Error("async schema in sync schema");
          out2 += " var errs_" + $lvl + " = errors;";
        }
        var $valid = "valid" + $lvl, $breakOnError = !it.opts.allErrors, $closingBraces1 = "", $closingBraces2 = "";
        var $errorKeyword;
        var $typeSchema = it.schema.type, $typeIsArray = Array.isArray($typeSchema);
        if ($typeSchema && it.opts.nullable && it.schema.nullable === true) {
          if ($typeIsArray) {
            if ($typeSchema.indexOf("null") == -1)
              $typeSchema = $typeSchema.concat("null");
          } else if ($typeSchema != "null") {
            $typeSchema = [$typeSchema, "null"];
            $typeIsArray = true;
          }
        }
        if ($typeIsArray && $typeSchema.length == 1) {
          $typeSchema = $typeSchema[0];
          $typeIsArray = false;
        }
        if (it.schema.$ref && $refKeywords) {
          if (it.opts.extendRefs == "fail") {
            throw new Error('$ref: validation keywords used in schema at path "' + it.errSchemaPath + '" (see option extendRefs)');
          } else if (it.opts.extendRefs !== true) {
            $refKeywords = false;
            it.logger.warn('$ref: keywords ignored in schema at path "' + it.errSchemaPath + '"');
          }
        }
        if (it.schema.$comment && it.opts.$comment) {
          out2 += " " + it.RULES.all.$comment.code(it, "$comment");
        }
        if ($typeSchema) {
          if (it.opts.coerceTypes) {
            var $coerceToTypes = it.util.coerceToTypes(it.opts.coerceTypes, $typeSchema);
          }
          var $rulesGroup = it.RULES.types[$typeSchema];
          if ($coerceToTypes || $typeIsArray || $rulesGroup === true || $rulesGroup && !$shouldUseGroup($rulesGroup)) {
            var $schemaPath = it.schemaPath + ".type", $errSchemaPath = it.errSchemaPath + "/type";
            var $schemaPath = it.schemaPath + ".type", $errSchemaPath = it.errSchemaPath + "/type", $method = $typeIsArray ? "checkDataTypes" : "checkDataType";
            out2 += " if (" + it.util[$method]($typeSchema, $data, it.opts.strictNumbers, true) + ") { ";
            if ($coerceToTypes) {
              var $dataType = "dataType" + $lvl, $coerced = "coerced" + $lvl;
              out2 += " var " + $dataType + " = typeof " + $data + "; var " + $coerced + " = undefined; ";
              if (it.opts.coerceTypes == "array") {
                out2 += " if (" + $dataType + " == 'object' && Array.isArray(" + $data + ") && " + $data + ".length == 1) { " + $data + " = " + $data + "[0]; " + $dataType + " = typeof " + $data + "; if (" + it.util.checkDataType(it.schema.type, $data, it.opts.strictNumbers) + ") " + $coerced + " = " + $data + "; } ";
              }
              out2 += " if (" + $coerced + " !== undefined) ; ";
              var arr1 = $coerceToTypes;
              if (arr1) {
                var $type, $i = -1, l1 = arr1.length - 1;
                while ($i < l1) {
                  $type = arr1[$i += 1];
                  if ($type == "string") {
                    out2 += " else if (" + $dataType + " == 'number' || " + $dataType + " == 'boolean') " + $coerced + " = '' + " + $data + "; else if (" + $data + " === null) " + $coerced + " = ''; ";
                  } else if ($type == "number" || $type == "integer") {
                    out2 += " else if (" + $dataType + " == 'boolean' || " + $data + " === null || (" + $dataType + " == 'string' && " + $data + " && " + $data + " == +" + $data + " ";
                    if ($type == "integer") {
                      out2 += " && !(" + $data + " % 1)";
                    }
                    out2 += ")) " + $coerced + " = +" + $data + "; ";
                  } else if ($type == "boolean") {
                    out2 += " else if (" + $data + " === 'false' || " + $data + " === 0 || " + $data + " === null) " + $coerced + " = false; else if (" + $data + " === 'true' || " + $data + " === 1) " + $coerced + " = true; ";
                  } else if ($type == "null") {
                    out2 += " else if (" + $data + " === '' || " + $data + " === 0 || " + $data + " === false) " + $coerced + " = null; ";
                  } else if (it.opts.coerceTypes == "array" && $type == "array") {
                    out2 += " else if (" + $dataType + " == 'string' || " + $dataType + " == 'number' || " + $dataType + " == 'boolean' || " + $data + " == null) " + $coerced + " = [" + $data + "]; ";
                  }
                }
              }
              out2 += " else {   ";
              var $$outStack = $$outStack || [];
              $$outStack.push(out2);
              out2 = "";
              if (it.createErrors !== false) {
                out2 += " { keyword: '" + ($errorKeyword || "type") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { type: '";
                if ($typeIsArray) {
                  out2 += "" + $typeSchema.join(",");
                } else {
                  out2 += "" + $typeSchema;
                }
                out2 += "' } ";
                if (it.opts.messages !== false) {
                  out2 += " , message: 'should be ";
                  if ($typeIsArray) {
                    out2 += "" + $typeSchema.join(",");
                  } else {
                    out2 += "" + $typeSchema;
                  }
                  out2 += "' ";
                }
                if (it.opts.verbose) {
                  out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                }
                out2 += " } ";
              } else {
                out2 += " {} ";
              }
              var __err = out2;
              out2 = $$outStack.pop();
              if (!it.compositeRule && $breakOnError) {
                if (it.async) {
                  out2 += " throw new ValidationError([" + __err + "]); ";
                } else {
                  out2 += " validate.errors = [" + __err + "]; return false; ";
                }
              } else {
                out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
              }
              out2 += " } if (" + $coerced + " !== undefined) {  ";
              var $parentData = $dataLvl ? "data" + ($dataLvl - 1 || "") : "parentData", $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : "parentDataProperty";
              out2 += " " + $data + " = " + $coerced + "; ";
              if (!$dataLvl) {
                out2 += "if (" + $parentData + " !== undefined)";
              }
              out2 += " " + $parentData + "[" + $parentDataProperty + "] = " + $coerced + "; } ";
            } else {
              var $$outStack = $$outStack || [];
              $$outStack.push(out2);
              out2 = "";
              if (it.createErrors !== false) {
                out2 += " { keyword: '" + ($errorKeyword || "type") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { type: '";
                if ($typeIsArray) {
                  out2 += "" + $typeSchema.join(",");
                } else {
                  out2 += "" + $typeSchema;
                }
                out2 += "' } ";
                if (it.opts.messages !== false) {
                  out2 += " , message: 'should be ";
                  if ($typeIsArray) {
                    out2 += "" + $typeSchema.join(",");
                  } else {
                    out2 += "" + $typeSchema;
                  }
                  out2 += "' ";
                }
                if (it.opts.verbose) {
                  out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                }
                out2 += " } ";
              } else {
                out2 += " {} ";
              }
              var __err = out2;
              out2 = $$outStack.pop();
              if (!it.compositeRule && $breakOnError) {
                if (it.async) {
                  out2 += " throw new ValidationError([" + __err + "]); ";
                } else {
                  out2 += " validate.errors = [" + __err + "]; return false; ";
                }
              } else {
                out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
              }
            }
            out2 += " } ";
          }
        }
        if (it.schema.$ref && !$refKeywords) {
          out2 += " " + it.RULES.all.$ref.code(it, "$ref") + " ";
          if ($breakOnError) {
            out2 += " } if (errors === ";
            if ($top) {
              out2 += "0";
            } else {
              out2 += "errs_" + $lvl;
            }
            out2 += ") { ";
            $closingBraces2 += "}";
          }
        } else {
          var arr2 = it.RULES;
          if (arr2) {
            var $rulesGroup, i2 = -1, l22 = arr2.length - 1;
            while (i2 < l22) {
              $rulesGroup = arr2[i2 += 1];
              if ($shouldUseGroup($rulesGroup)) {
                if ($rulesGroup.type) {
                  out2 += " if (" + it.util.checkDataType($rulesGroup.type, $data, it.opts.strictNumbers) + ") { ";
                }
                if (it.opts.useDefaults) {
                  if ($rulesGroup.type == "object" && it.schema.properties) {
                    var $schema = it.schema.properties, $schemaKeys = Object.keys($schema);
                    var arr3 = $schemaKeys;
                    if (arr3) {
                      var $propertyKey, i3 = -1, l3 = arr3.length - 1;
                      while (i3 < l3) {
                        $propertyKey = arr3[i3 += 1];
                        var $sch = $schema[$propertyKey];
                        if ($sch.default !== void 0) {
                          var $passData = $data + it.util.getProperty($propertyKey);
                          if (it.compositeRule) {
                            if (it.opts.strictDefaults) {
                              var $defaultMsg = "default is ignored for: " + $passData;
                              if (it.opts.strictDefaults === "log")
                                it.logger.warn($defaultMsg);
                              else
                                throw new Error($defaultMsg);
                            }
                          } else {
                            out2 += " if (" + $passData + " === undefined ";
                            if (it.opts.useDefaults == "empty") {
                              out2 += " || " + $passData + " === null || " + $passData + " === '' ";
                            }
                            out2 += " ) " + $passData + " = ";
                            if (it.opts.useDefaults == "shared") {
                              out2 += " " + it.useDefault($sch.default) + " ";
                            } else {
                              out2 += " " + JSON.stringify($sch.default) + " ";
                            }
                            out2 += "; ";
                          }
                        }
                      }
                    }
                  } else if ($rulesGroup.type == "array" && Array.isArray(it.schema.items)) {
                    var arr4 = it.schema.items;
                    if (arr4) {
                      var $sch, $i = -1, l4 = arr4.length - 1;
                      while ($i < l4) {
                        $sch = arr4[$i += 1];
                        if ($sch.default !== void 0) {
                          var $passData = $data + "[" + $i + "]";
                          if (it.compositeRule) {
                            if (it.opts.strictDefaults) {
                              var $defaultMsg = "default is ignored for: " + $passData;
                              if (it.opts.strictDefaults === "log")
                                it.logger.warn($defaultMsg);
                              else
                                throw new Error($defaultMsg);
                            }
                          } else {
                            out2 += " if (" + $passData + " === undefined ";
                            if (it.opts.useDefaults == "empty") {
                              out2 += " || " + $passData + " === null || " + $passData + " === '' ";
                            }
                            out2 += " ) " + $passData + " = ";
                            if (it.opts.useDefaults == "shared") {
                              out2 += " " + it.useDefault($sch.default) + " ";
                            } else {
                              out2 += " " + JSON.stringify($sch.default) + " ";
                            }
                            out2 += "; ";
                          }
                        }
                      }
                    }
                  }
                }
                var arr5 = $rulesGroup.rules;
                if (arr5) {
                  var $rule, i5 = -1, l5 = arr5.length - 1;
                  while (i5 < l5) {
                    $rule = arr5[i5 += 1];
                    if ($shouldUseRule($rule)) {
                      var $code = $rule.code(it, $rule.keyword, $rulesGroup.type);
                      if ($code) {
                        out2 += " " + $code + " ";
                        if ($breakOnError) {
                          $closingBraces1 += "}";
                        }
                      }
                    }
                  }
                }
                if ($breakOnError) {
                  out2 += " " + $closingBraces1 + " ";
                  $closingBraces1 = "";
                }
                if ($rulesGroup.type) {
                  out2 += " } ";
                  if ($typeSchema && $typeSchema === $rulesGroup.type && !$coerceToTypes) {
                    out2 += " else { ";
                    var $schemaPath = it.schemaPath + ".type", $errSchemaPath = it.errSchemaPath + "/type";
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out2);
                    out2 = "";
                    if (it.createErrors !== false) {
                      out2 += " { keyword: '" + ($errorKeyword || "type") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { type: '";
                      if ($typeIsArray) {
                        out2 += "" + $typeSchema.join(",");
                      } else {
                        out2 += "" + $typeSchema;
                      }
                      out2 += "' } ";
                      if (it.opts.messages !== false) {
                        out2 += " , message: 'should be ";
                        if ($typeIsArray) {
                          out2 += "" + $typeSchema.join(",");
                        } else {
                          out2 += "" + $typeSchema;
                        }
                        out2 += "' ";
                      }
                      if (it.opts.verbose) {
                        out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                      }
                      out2 += " } ";
                    } else {
                      out2 += " {} ";
                    }
                    var __err = out2;
                    out2 = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) {
                      if (it.async) {
                        out2 += " throw new ValidationError([" + __err + "]); ";
                      } else {
                        out2 += " validate.errors = [" + __err + "]; return false; ";
                      }
                    } else {
                      out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
                    }
                    out2 += " } ";
                  }
                }
                if ($breakOnError) {
                  out2 += " if (errors === ";
                  if ($top) {
                    out2 += "0";
                  } else {
                    out2 += "errs_" + $lvl;
                  }
                  out2 += ") { ";
                  $closingBraces2 += "}";
                }
              }
            }
          }
        }
        if ($breakOnError) {
          out2 += " " + $closingBraces2 + " ";
        }
        if ($top) {
          if ($async) {
            out2 += " if (errors === 0) return data;           ";
            out2 += " else throw new ValidationError(vErrors); ";
          } else {
            out2 += " validate.errors = vErrors; ";
            out2 += " return errors === 0;       ";
          }
          out2 += " }; return validate;";
        } else {
          out2 += " var " + $valid + " = errors === errs_" + $lvl + ";";
        }
        function $shouldUseGroup($rulesGroup2) {
          var rules = $rulesGroup2.rules;
          for (var i4 = 0; i4 < rules.length; i4++)
            if ($shouldUseRule(rules[i4]))
              return true;
        }
        function $shouldUseRule($rule2) {
          return it.schema[$rule2.keyword] !== void 0 || $rule2.implements && $ruleImplementsSomeKeyword($rule2);
        }
        function $ruleImplementsSomeKeyword($rule2) {
          var impl = $rule2.implements;
          for (var i4 = 0; i4 < impl.length; i4++)
            if (it.schema[impl[i4]] !== void 0)
              return true;
        }
        return out2;
      };
    });
    require_compile2 = __commonJS2((exports2, module2) => {
      var resolve3 = require_resolve2();
      var util32 = require_util2();
      var errorClasses = require_error_classes();
      var stableStringify = require_fast_json_stable_stringify();
      var validateGenerator = require_validate2();
      var ucs2length = util32.ucs2length;
      var equal = require_fast_deep_equal2();
      var ValidationError = errorClasses.Validation;
      module2.exports = compile2;
      function compile2(schema, root, localRefs, baseId) {
        var self2 = this, opts = this._opts, refVal = [void 0], refs = {}, patterns = [], patternsHash = {}, defaults2 = [], defaultsHash = {}, customRules = [];
        root = root || { schema, refVal, refs };
        var c = checkCompiling.call(this, schema, root, baseId);
        var compilation = this._compilations[c.index];
        if (c.compiling)
          return compilation.callValidate = callValidate;
        var formats = this._formats;
        var RULES = this.RULES;
        try {
          var v = localCompile(schema, root, localRefs, baseId);
          compilation.validate = v;
          var cv = compilation.callValidate;
          if (cv) {
            cv.schema = v.schema;
            cv.errors = null;
            cv.refs = v.refs;
            cv.refVal = v.refVal;
            cv.root = v.root;
            cv.$async = v.$async;
            if (opts.sourceCode)
              cv.source = v.source;
          }
          return v;
        } finally {
          endCompiling.call(this, schema, root, baseId);
        }
        function callValidate() {
          var validate = compilation.validate;
          var result = validate.apply(this, arguments);
          callValidate.errors = validate.errors;
          return result;
        }
        function localCompile(_schema, _root, localRefs2, baseId2) {
          var isRoot = !_root || _root && _root.schema == _schema;
          if (_root.schema != root.schema)
            return compile2.call(self2, _schema, _root, localRefs2, baseId2);
          var $async = _schema.$async === true;
          var sourceCode = validateGenerator({
            isTop: true,
            schema: _schema,
            isRoot,
            baseId: baseId2,
            root: _root,
            schemaPath: "",
            errSchemaPath: "#",
            errorPath: '""',
            MissingRefError: errorClasses.MissingRef,
            RULES,
            validate: validateGenerator,
            util: util32,
            resolve: resolve3,
            resolveRef,
            usePattern,
            useDefault,
            useCustomRule,
            opts,
            formats,
            logger: self2.logger,
            self: self2
          });
          sourceCode = vars(refVal, refValCode) + vars(patterns, patternCode) + vars(defaults2, defaultCode) + vars(customRules, customRuleCode) + sourceCode;
          if (opts.processCode)
            sourceCode = opts.processCode(sourceCode, _schema);
          var validate;
          try {
            var makeValidate = new Function("self", "RULES", "formats", "root", "refVal", "defaults", "customRules", "equal", "ucs2length", "ValidationError", sourceCode);
            validate = makeValidate(self2, RULES, formats, root, refVal, defaults2, customRules, equal, ucs2length, ValidationError);
            refVal[0] = validate;
          } catch (e) {
            self2.logger.error("Error compiling schema, function code:", sourceCode);
            throw e;
          }
          validate.schema = _schema;
          validate.errors = null;
          validate.refs = refs;
          validate.refVal = refVal;
          validate.root = isRoot ? validate : _root;
          if ($async)
            validate.$async = true;
          if (opts.sourceCode === true) {
            validate.source = {
              code: sourceCode,
              patterns,
              defaults: defaults2
            };
          }
          return validate;
        }
        function resolveRef(baseId2, ref, isRoot) {
          ref = resolve3.url(baseId2, ref);
          var refIndex = refs[ref];
          var _refVal, refCode;
          if (refIndex !== void 0) {
            _refVal = refVal[refIndex];
            refCode = "refVal[" + refIndex + "]";
            return resolvedRef(_refVal, refCode);
          }
          if (!isRoot && root.refs) {
            var rootRefId = root.refs[ref];
            if (rootRefId !== void 0) {
              _refVal = root.refVal[rootRefId];
              refCode = addLocalRef(ref, _refVal);
              return resolvedRef(_refVal, refCode);
            }
          }
          refCode = addLocalRef(ref);
          var v2 = resolve3.call(self2, localCompile, root, ref);
          if (v2 === void 0) {
            var localSchema = localRefs && localRefs[ref];
            if (localSchema) {
              v2 = resolve3.inlineRef(localSchema, opts.inlineRefs) ? localSchema : compile2.call(self2, localSchema, root, localRefs, baseId2);
            }
          }
          if (v2 === void 0) {
            removeLocalRef(ref);
          } else {
            replaceLocalRef(ref, v2);
            return resolvedRef(v2, refCode);
          }
        }
        function addLocalRef(ref, v2) {
          var refId = refVal.length;
          refVal[refId] = v2;
          refs[ref] = refId;
          return "refVal" + refId;
        }
        function removeLocalRef(ref) {
          delete refs[ref];
        }
        function replaceLocalRef(ref, v2) {
          var refId = refs[ref];
          refVal[refId] = v2;
        }
        function resolvedRef(refVal2, code3) {
          return typeof refVal2 == "object" || typeof refVal2 == "boolean" ? { code: code3, schema: refVal2, inline: true } : { code: code3, $async: refVal2 && !!refVal2.$async };
        }
        function usePattern(regexStr) {
          var index = patternsHash[regexStr];
          if (index === void 0) {
            index = patternsHash[regexStr] = patterns.length;
            patterns[index] = regexStr;
          }
          return "pattern" + index;
        }
        function useDefault(value) {
          switch (typeof value) {
            case "boolean":
            case "number":
              return "" + value;
            case "string":
              return util32.toQuotedString(value);
            case "object":
              if (value === null)
                return "null";
              var valueStr = stableStringify(value);
              var index = defaultsHash[valueStr];
              if (index === void 0) {
                index = defaultsHash[valueStr] = defaults2.length;
                defaults2[index] = value;
              }
              return "default" + index;
          }
        }
        function useCustomRule(rule, schema2, parentSchema, it) {
          if (self2._opts.validateSchema !== false) {
            var deps = rule.definition.dependencies;
            if (deps && !deps.every(function(keyword) {
              return Object.prototype.hasOwnProperty.call(parentSchema, keyword);
            }))
              throw new Error("parent schema must have all required keywords: " + deps.join(","));
            var validateSchema = rule.definition.validateSchema;
            if (validateSchema) {
              var valid = validateSchema(schema2);
              if (!valid) {
                var message = "keyword schema is invalid: " + self2.errorsText(validateSchema.errors);
                if (self2._opts.validateSchema == "log")
                  self2.logger.error(message);
                else
                  throw new Error(message);
              }
            }
          }
          var compile22 = rule.definition.compile, inline2 = rule.definition.inline, macro = rule.definition.macro;
          var validate;
          if (compile22) {
            validate = compile22.call(self2, schema2, parentSchema, it);
          } else if (macro) {
            validate = macro.call(self2, schema2, parentSchema, it);
            if (opts.validateSchema !== false)
              self2.validateSchema(validate, true);
          } else if (inline2) {
            validate = inline2.call(self2, it, rule.keyword, schema2, parentSchema);
          } else {
            validate = rule.definition.validate;
            if (!validate)
              return;
          }
          if (validate === void 0)
            throw new Error('custom keyword "' + rule.keyword + '"failed to compile');
          var index = customRules.length;
          customRules[index] = validate;
          return {
            code: "customRule" + index,
            validate
          };
        }
      }
      function checkCompiling(schema, root, baseId) {
        var index = compIndex.call(this, schema, root, baseId);
        if (index >= 0)
          return { index, compiling: true };
        index = this._compilations.length;
        this._compilations[index] = {
          schema,
          root,
          baseId
        };
        return { index, compiling: false };
      }
      function endCompiling(schema, root, baseId) {
        var i2 = compIndex.call(this, schema, root, baseId);
        if (i2 >= 0)
          this._compilations.splice(i2, 1);
      }
      function compIndex(schema, root, baseId) {
        for (var i2 = 0; i2 < this._compilations.length; i2++) {
          var c = this._compilations[i2];
          if (c.schema == schema && c.root == root && c.baseId == baseId)
            return i2;
        }
        return -1;
      }
      function patternCode(i2, patterns) {
        return "var pattern" + i2 + " = new RegExp(" + util32.toQuotedString(patterns[i2]) + ");";
      }
      function defaultCode(i2) {
        return "var default" + i2 + " = defaults[" + i2 + "];";
      }
      function refValCode(i2, refVal) {
        return refVal[i2] === void 0 ? "" : "var refVal" + i2 + " = refVal[" + i2 + "];";
      }
      function customRuleCode(i2) {
        return "var customRule" + i2 + " = customRules[" + i2 + "];";
      }
      function vars(arr, statement) {
        if (!arr.length)
          return "";
        var code3 = "";
        for (var i2 = 0; i2 < arr.length; i2++)
          code3 += statement(i2, arr);
        return code3;
      }
    });
    require_cache = __commonJS2((exports2, module2) => {
      var Cache2 = module2.exports = function Cache3() {
        this._cache = {};
      };
      Cache2.prototype.put = function Cache_put(key, value) {
        this._cache[key] = value;
      };
      Cache2.prototype.get = function Cache_get(key) {
        return this._cache[key];
      };
      Cache2.prototype.del = function Cache_del(key) {
        delete this._cache[key];
      };
      Cache2.prototype.clear = function Cache_clear() {
        this._cache = {};
      };
    });
    require_formats = __commonJS2((exports2, module2) => {
      var util32 = require_util2();
      var DATE = /^(\d\d\d\d)-(\d\d)-(\d\d)$/;
      var DAYS = [0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
      var TIME = /^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i;
      var HOSTNAME = /^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i;
      var URI2 = /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
      var URIREF = /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
      var URITEMPLATE = /^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i;
      var URL2 = /^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i;
      var UUID = /^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i;
      var JSON_POINTER = /^(?:\/(?:[^~/]|~0|~1)*)*$/;
      var JSON_POINTER_URI_FRAGMENT = /^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i;
      var RELATIVE_JSON_POINTER = /^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;
      module2.exports = formats;
      function formats(mode) {
        mode = mode == "full" ? "full" : "fast";
        return util32.copy(formats[mode]);
      }
      formats.fast = {
        date: /^\d\d\d\d-[0-1]\d-[0-3]\d$/,
        time: /^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,
        "date-time": /^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,
        uri: /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,
        "uri-reference": /^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,
        "uri-template": URITEMPLATE,
        url: URL2,
        email: /^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,
        hostname: HOSTNAME,
        ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
        ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
        regex,
        uuid: UUID,
        "json-pointer": JSON_POINTER,
        "json-pointer-uri-fragment": JSON_POINTER_URI_FRAGMENT,
        "relative-json-pointer": RELATIVE_JSON_POINTER
      };
      formats.full = {
        date,
        time,
        "date-time": date_time,
        uri,
        "uri-reference": URIREF,
        "uri-template": URITEMPLATE,
        url: URL2,
        email: /^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,
        hostname: HOSTNAME,
        ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
        ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
        regex,
        uuid: UUID,
        "json-pointer": JSON_POINTER,
        "json-pointer-uri-fragment": JSON_POINTER_URI_FRAGMENT,
        "relative-json-pointer": RELATIVE_JSON_POINTER
      };
      function isLeapYear(year) {
        return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
      }
      function date(str) {
        var matches = str.match(DATE);
        if (!matches)
          return false;
        var year = +matches[1];
        var month = +matches[2];
        var day = +matches[3];
        return month >= 1 && month <= 12 && day >= 1 && day <= (month == 2 && isLeapYear(year) ? 29 : DAYS[month]);
      }
      function time(str, full) {
        var matches = str.match(TIME);
        if (!matches)
          return false;
        var hour = matches[1];
        var minute = matches[2];
        var second = matches[3];
        var timeZone = matches[5];
        return (hour <= 23 && minute <= 59 && second <= 59 || hour == 23 && minute == 59 && second == 60) && (!full || timeZone);
      }
      var DATE_TIME_SEPARATOR = /t|\s/i;
      function date_time(str) {
        var dateTime = str.split(DATE_TIME_SEPARATOR);
        return dateTime.length == 2 && date(dateTime[0]) && time(dateTime[1], true);
      }
      var NOT_URI_FRAGMENT = /\/|:/;
      function uri(str) {
        return NOT_URI_FRAGMENT.test(str) && URI2.test(str);
      }
      var Z_ANCHOR = /[^\\]\\Z/;
      function regex(str) {
        if (Z_ANCHOR.test(str))
          return false;
        try {
          new RegExp(str);
          return true;
        } catch (e) {
          return false;
        }
      }
    });
    require_ref2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_ref(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $async, $refCode;
        if ($schema == "#" || $schema == "#/") {
          if (it.isRoot) {
            $async = it.async;
            $refCode = "validate";
          } else {
            $async = it.root.schema.$async === true;
            $refCode = "root.refVal[0]";
          }
        } else {
          var $refVal = it.resolveRef(it.baseId, $schema, it.isRoot);
          if ($refVal === void 0) {
            var $message = it.MissingRefError.message(it.baseId, $schema);
            if (it.opts.missingRefs == "fail") {
              it.logger.error($message);
              var $$outStack = $$outStack || [];
              $$outStack.push(out2);
              out2 = "";
              if (it.createErrors !== false) {
                out2 += " { keyword: '$ref' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { ref: '" + it.util.escapeQuotes($schema) + "' } ";
                if (it.opts.messages !== false) {
                  out2 += " , message: 'can\\'t resolve reference " + it.util.escapeQuotes($schema) + "' ";
                }
                if (it.opts.verbose) {
                  out2 += " , schema: " + it.util.toQuotedString($schema) + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                }
                out2 += " } ";
              } else {
                out2 += " {} ";
              }
              var __err = out2;
              out2 = $$outStack.pop();
              if (!it.compositeRule && $breakOnError) {
                if (it.async) {
                  out2 += " throw new ValidationError([" + __err + "]); ";
                } else {
                  out2 += " validate.errors = [" + __err + "]; return false; ";
                }
              } else {
                out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
              }
              if ($breakOnError) {
                out2 += " if (false) { ";
              }
            } else if (it.opts.missingRefs == "ignore") {
              it.logger.warn($message);
              if ($breakOnError) {
                out2 += " if (true) { ";
              }
            } else {
              throw new it.MissingRefError(it.baseId, $schema, $message);
            }
          } else if ($refVal.inline) {
            var $it = it.util.copy(it);
            $it.level++;
            var $nextValid = "valid" + $it.level;
            $it.schema = $refVal.schema;
            $it.schemaPath = "";
            $it.errSchemaPath = $schema;
            var $code = it.validate($it).replace(/validate\.schema/g, $refVal.code);
            out2 += " " + $code + " ";
            if ($breakOnError) {
              out2 += " if (" + $nextValid + ") { ";
            }
          } else {
            $async = $refVal.$async === true || it.async && $refVal.$async !== false;
            $refCode = $refVal.code;
          }
        }
        if ($refCode) {
          var $$outStack = $$outStack || [];
          $$outStack.push(out2);
          out2 = "";
          if (it.opts.passContext) {
            out2 += " " + $refCode + ".call(this, ";
          } else {
            out2 += " " + $refCode + "( ";
          }
          out2 += " " + $data + ", (dataPath || '')";
          if (it.errorPath != '""') {
            out2 += " + " + it.errorPath;
          }
          var $parentData = $dataLvl ? "data" + ($dataLvl - 1 || "") : "parentData", $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : "parentDataProperty";
          out2 += " , " + $parentData + " , " + $parentDataProperty + ", rootData)  ";
          var __callValidate = out2;
          out2 = $$outStack.pop();
          if ($async) {
            if (!it.async)
              throw new Error("async schema referenced by sync schema");
            if ($breakOnError) {
              out2 += " var " + $valid + "; ";
            }
            out2 += " try { await " + __callValidate + "; ";
            if ($breakOnError) {
              out2 += " " + $valid + " = true; ";
            }
            out2 += " } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ";
            if ($breakOnError) {
              out2 += " " + $valid + " = false; ";
            }
            out2 += " } ";
            if ($breakOnError) {
              out2 += " if (" + $valid + ") { ";
            }
          } else {
            out2 += " if (!" + __callValidate + ") { if (vErrors === null) vErrors = " + $refCode + ".errors; else vErrors = vErrors.concat(" + $refCode + ".errors); errors = vErrors.length; } ";
            if ($breakOnError) {
              out2 += " else { ";
            }
          }
        }
        return out2;
      };
    });
    require_allOf2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_allOf(it, $keyword, $ruleType) {
        var out2 = " ";
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $it = it.util.copy(it);
        var $closingBraces = "";
        $it.level++;
        var $nextValid = "valid" + $it.level;
        var $currentBaseId = $it.baseId, $allSchemasEmpty = true;
        var arr1 = $schema;
        if (arr1) {
          var $sch, $i = -1, l1 = arr1.length - 1;
          while ($i < l1) {
            $sch = arr1[$i += 1];
            if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
              $allSchemasEmpty = false;
              $it.schema = $sch;
              $it.schemaPath = $schemaPath + "[" + $i + "]";
              $it.errSchemaPath = $errSchemaPath + "/" + $i;
              out2 += "  " + it.validate($it) + " ";
              $it.baseId = $currentBaseId;
              if ($breakOnError) {
                out2 += " if (" + $nextValid + ") { ";
                $closingBraces += "}";
              }
            }
          }
        }
        if ($breakOnError) {
          if ($allSchemasEmpty) {
            out2 += " if (true) { ";
          } else {
            out2 += " " + $closingBraces.slice(0, -1) + " ";
          }
        }
        return out2;
      };
    });
    require_anyOf2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_anyOf(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $errs = "errs__" + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = "";
        $it.level++;
        var $nextValid = "valid" + $it.level;
        var $noEmptySchema = $schema.every(function($sch2) {
          return it.opts.strictKeywords ? typeof $sch2 == "object" && Object.keys($sch2).length > 0 || $sch2 === false : it.util.schemaHasRules($sch2, it.RULES.all);
        });
        if ($noEmptySchema) {
          var $currentBaseId = $it.baseId;
          out2 += " var " + $errs + " = errors; var " + $valid + " = false;  ";
          var $wasComposite = it.compositeRule;
          it.compositeRule = $it.compositeRule = true;
          var arr1 = $schema;
          if (arr1) {
            var $sch, $i = -1, l1 = arr1.length - 1;
            while ($i < l1) {
              $sch = arr1[$i += 1];
              $it.schema = $sch;
              $it.schemaPath = $schemaPath + "[" + $i + "]";
              $it.errSchemaPath = $errSchemaPath + "/" + $i;
              out2 += "  " + it.validate($it) + " ";
              $it.baseId = $currentBaseId;
              out2 += " " + $valid + " = " + $valid + " || " + $nextValid + "; if (!" + $valid + ") { ";
              $closingBraces += "}";
            }
          }
          it.compositeRule = $it.compositeRule = $wasComposite;
          out2 += " " + $closingBraces + " if (!" + $valid + ") {   var err =   ";
          if (it.createErrors !== false) {
            out2 += " { keyword: 'anyOf' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
            if (it.opts.messages !== false) {
              out2 += " , message: 'should match some schema in anyOf' ";
            }
            if (it.opts.verbose) {
              out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out2 += " } ";
          } else {
            out2 += " {} ";
          }
          out2 += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out2 += " throw new ValidationError(vErrors); ";
            } else {
              out2 += " validate.errors = vErrors; return false; ";
            }
          }
          out2 += " } else {  errors = " + $errs + "; if (vErrors !== null) { if (" + $errs + ") vErrors.length = " + $errs + "; else vErrors = null; } ";
          if (it.opts.allErrors) {
            out2 += " } ";
          }
        } else {
          if ($breakOnError) {
            out2 += " if (true) { ";
          }
        }
        return out2;
      };
    });
    require_comment = __commonJS2((exports2, module2) => {
      module2.exports = function generate_comment(it, $keyword, $ruleType) {
        var out2 = " ";
        var $schema = it.schema[$keyword];
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $comment = it.util.toQuotedString($schema);
        if (it.opts.$comment === true) {
          out2 += " console.log(" + $comment + ");";
        } else if (typeof it.opts.$comment == "function") {
          out2 += " self._opts.$comment(" + $comment + ", " + it.util.toQuotedString($errSchemaPath) + ", validate.root.schema);";
        }
        return out2;
      };
    });
    require_const2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_const(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        if (!$isData) {
          out2 += " var schema" + $lvl + " = validate.schema" + $schemaPath + ";";
        }
        out2 += "var " + $valid + " = equal(" + $data + ", schema" + $lvl + "); if (!" + $valid + ") {   ";
        var $$outStack = $$outStack || [];
        $$outStack.push(out2);
        out2 = "";
        if (it.createErrors !== false) {
          out2 += " { keyword: 'const' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { allowedValue: schema" + $lvl + " } ";
          if (it.opts.messages !== false) {
            out2 += " , message: 'should be equal to constant' ";
          }
          if (it.opts.verbose) {
            out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        var __err = out2;
        out2 = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError([" + __err + "]); ";
          } else {
            out2 += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out2 += " }";
        if ($breakOnError) {
          out2 += " else { ";
        }
        return out2;
      };
    });
    require_contains2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_contains(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $errs = "errs__" + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = "";
        $it.level++;
        var $nextValid = "valid" + $it.level;
        var $idx = "i" + $lvl, $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = "data" + $dataNxt, $currentBaseId = it.baseId, $nonEmptySchema = it.opts.strictKeywords ? typeof $schema == "object" && Object.keys($schema).length > 0 || $schema === false : it.util.schemaHasRules($schema, it.RULES.all);
        out2 += "var " + $errs + " = errors;var " + $valid + ";";
        if ($nonEmptySchema) {
          var $wasComposite = it.compositeRule;
          it.compositeRule = $it.compositeRule = true;
          $it.schema = $schema;
          $it.schemaPath = $schemaPath;
          $it.errSchemaPath = $errSchemaPath;
          out2 += " var " + $nextValid + " = false; for (var " + $idx + " = 0; " + $idx + " < " + $data + ".length; " + $idx + "++) { ";
          $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
          var $passData = $data + "[" + $idx + "]";
          $it.dataPathArr[$dataNxt] = $idx;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out2 += " " + it.util.varReplace($code, $nextData, $passData) + " ";
          } else {
            out2 += " var " + $nextData + " = " + $passData + "; " + $code + " ";
          }
          out2 += " if (" + $nextValid + ") break; }  ";
          it.compositeRule = $it.compositeRule = $wasComposite;
          out2 += " " + $closingBraces + " if (!" + $nextValid + ") {";
        } else {
          out2 += " if (" + $data + ".length == 0) {";
        }
        var $$outStack = $$outStack || [];
        $$outStack.push(out2);
        out2 = "";
        if (it.createErrors !== false) {
          out2 += " { keyword: 'contains' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
          if (it.opts.messages !== false) {
            out2 += " , message: 'should contain a valid item' ";
          }
          if (it.opts.verbose) {
            out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        var __err = out2;
        out2 = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError([" + __err + "]); ";
          } else {
            out2 += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out2 += " } else { ";
        if ($nonEmptySchema) {
          out2 += "  errors = " + $errs + "; if (vErrors !== null) { if (" + $errs + ") vErrors.length = " + $errs + "; else vErrors = null; } ";
        }
        if (it.opts.allErrors) {
          out2 += " } ";
        }
        return out2;
      };
    });
    require_dependencies2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_dependencies(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $errs = "errs__" + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = "";
        $it.level++;
        var $nextValid = "valid" + $it.level;
        var $schemaDeps = {}, $propertyDeps = {}, $ownProperties = it.opts.ownProperties;
        for ($property in $schema) {
          if ($property == "__proto__")
            continue;
          var $sch = $schema[$property];
          var $deps = Array.isArray($sch) ? $propertyDeps : $schemaDeps;
          $deps[$property] = $sch;
        }
        out2 += "var " + $errs + " = errors;";
        var $currentErrorPath = it.errorPath;
        out2 += "var missing" + $lvl + ";";
        for (var $property in $propertyDeps) {
          $deps = $propertyDeps[$property];
          if ($deps.length) {
            out2 += " if ( " + $data + it.util.getProperty($property) + " !== undefined ";
            if ($ownProperties) {
              out2 += " && Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($property) + "') ";
            }
            if ($breakOnError) {
              out2 += " && ( ";
              var arr1 = $deps;
              if (arr1) {
                var $propertyKey, $i = -1, l1 = arr1.length - 1;
                while ($i < l1) {
                  $propertyKey = arr1[$i += 1];
                  if ($i) {
                    out2 += " || ";
                  }
                  var $prop = it.util.getProperty($propertyKey), $useData = $data + $prop;
                  out2 += " ( ( " + $useData + " === undefined ";
                  if ($ownProperties) {
                    out2 += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
                  }
                  out2 += ") && (missing" + $lvl + " = " + it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop) + ") ) ";
                }
              }
              out2 += ")) {  ";
              var $propertyPath = "missing" + $lvl, $missingProperty = "' + " + $propertyPath + " + '";
              if (it.opts._errorDataPathProperty) {
                it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + " + " + $propertyPath;
              }
              var $$outStack = $$outStack || [];
              $$outStack.push(out2);
              out2 = "";
              if (it.createErrors !== false) {
                out2 += " { keyword: 'dependencies' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { property: '" + it.util.escapeQuotes($property) + "', missingProperty: '" + $missingProperty + "', depsCount: " + $deps.length + ", deps: '" + it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", ")) + "' } ";
                if (it.opts.messages !== false) {
                  out2 += " , message: 'should have ";
                  if ($deps.length == 1) {
                    out2 += "property " + it.util.escapeQuotes($deps[0]);
                  } else {
                    out2 += "properties " + it.util.escapeQuotes($deps.join(", "));
                  }
                  out2 += " when property " + it.util.escapeQuotes($property) + " is present' ";
                }
                if (it.opts.verbose) {
                  out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                }
                out2 += " } ";
              } else {
                out2 += " {} ";
              }
              var __err = out2;
              out2 = $$outStack.pop();
              if (!it.compositeRule && $breakOnError) {
                if (it.async) {
                  out2 += " throw new ValidationError([" + __err + "]); ";
                } else {
                  out2 += " validate.errors = [" + __err + "]; return false; ";
                }
              } else {
                out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
              }
            } else {
              out2 += " ) { ";
              var arr2 = $deps;
              if (arr2) {
                var $propertyKey, i2 = -1, l22 = arr2.length - 1;
                while (i2 < l22) {
                  $propertyKey = arr2[i2 += 1];
                  var $prop = it.util.getProperty($propertyKey), $missingProperty = it.util.escapeQuotes($propertyKey), $useData = $data + $prop;
                  if (it.opts._errorDataPathProperty) {
                    it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
                  }
                  out2 += " if ( " + $useData + " === undefined ";
                  if ($ownProperties) {
                    out2 += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
                  }
                  out2 += ") {  var err =   ";
                  if (it.createErrors !== false) {
                    out2 += " { keyword: 'dependencies' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { property: '" + it.util.escapeQuotes($property) + "', missingProperty: '" + $missingProperty + "', depsCount: " + $deps.length + ", deps: '" + it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", ")) + "' } ";
                    if (it.opts.messages !== false) {
                      out2 += " , message: 'should have ";
                      if ($deps.length == 1) {
                        out2 += "property " + it.util.escapeQuotes($deps[0]);
                      } else {
                        out2 += "properties " + it.util.escapeQuotes($deps.join(", "));
                      }
                      out2 += " when property " + it.util.escapeQuotes($property) + " is present' ";
                    }
                    if (it.opts.verbose) {
                      out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                    }
                    out2 += " } ";
                  } else {
                    out2 += " {} ";
                  }
                  out2 += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ";
                }
              }
            }
            out2 += " }   ";
            if ($breakOnError) {
              $closingBraces += "}";
              out2 += " else { ";
            }
          }
        }
        it.errorPath = $currentErrorPath;
        var $currentBaseId = $it.baseId;
        for (var $property in $schemaDeps) {
          var $sch = $schemaDeps[$property];
          if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
            out2 += " " + $nextValid + " = true; if ( " + $data + it.util.getProperty($property) + " !== undefined ";
            if ($ownProperties) {
              out2 += " && Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($property) + "') ";
            }
            out2 += ") { ";
            $it.schema = $sch;
            $it.schemaPath = $schemaPath + it.util.getProperty($property);
            $it.errSchemaPath = $errSchemaPath + "/" + it.util.escapeFragment($property);
            out2 += "  " + it.validate($it) + " ";
            $it.baseId = $currentBaseId;
            out2 += " }  ";
            if ($breakOnError) {
              out2 += " if (" + $nextValid + ") { ";
              $closingBraces += "}";
            }
          }
        }
        if ($breakOnError) {
          out2 += "   " + $closingBraces + " if (" + $errs + " == errors) {";
        }
        return out2;
      };
    });
    require_enum2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_enum(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        var $i = "i" + $lvl, $vSchema = "schema" + $lvl;
        if (!$isData) {
          out2 += " var " + $vSchema + " = validate.schema" + $schemaPath + ";";
        }
        out2 += "var " + $valid + ";";
        if ($isData) {
          out2 += " if (schema" + $lvl + " === undefined) " + $valid + " = true; else if (!Array.isArray(schema" + $lvl + ")) " + $valid + " = false; else {";
        }
        out2 += "" + $valid + " = false;for (var " + $i + "=0; " + $i + "<" + $vSchema + ".length; " + $i + "++) if (equal(" + $data + ", " + $vSchema + "[" + $i + "])) { " + $valid + " = true; break; }";
        if ($isData) {
          out2 += "  }  ";
        }
        out2 += " if (!" + $valid + ") {   ";
        var $$outStack = $$outStack || [];
        $$outStack.push(out2);
        out2 = "";
        if (it.createErrors !== false) {
          out2 += " { keyword: 'enum' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { allowedValues: schema" + $lvl + " } ";
          if (it.opts.messages !== false) {
            out2 += " , message: 'should be equal to one of the allowed values' ";
          }
          if (it.opts.verbose) {
            out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        var __err = out2;
        out2 = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError([" + __err + "]); ";
          } else {
            out2 += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out2 += " }";
        if ($breakOnError) {
          out2 += " else { ";
        }
        return out2;
      };
    });
    require_format3 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_format(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        if (it.opts.format === false) {
          if ($breakOnError) {
            out2 += " if (true) { ";
          }
          return out2;
        }
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        var $unknownFormats = it.opts.unknownFormats, $allowUnknown = Array.isArray($unknownFormats);
        if ($isData) {
          var $format = "format" + $lvl, $isObject = "isObject" + $lvl, $formatType = "formatType" + $lvl;
          out2 += " var " + $format + " = formats[" + $schemaValue + "]; var " + $isObject + " = typeof " + $format + " == 'object' && !(" + $format + " instanceof RegExp) && " + $format + ".validate; var " + $formatType + " = " + $isObject + " && " + $format + ".type || 'string'; if (" + $isObject + ") { ";
          if (it.async) {
            out2 += " var async" + $lvl + " = " + $format + ".async; ";
          }
          out2 += " " + $format + " = " + $format + ".validate; } if (  ";
          if ($isData) {
            out2 += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'string') || ";
          }
          out2 += " (";
          if ($unknownFormats != "ignore") {
            out2 += " (" + $schemaValue + " && !" + $format + " ";
            if ($allowUnknown) {
              out2 += " && self._opts.unknownFormats.indexOf(" + $schemaValue + ") == -1 ";
            }
            out2 += ") || ";
          }
          out2 += " (" + $format + " && " + $formatType + " == '" + $ruleType + "' && !(typeof " + $format + " == 'function' ? ";
          if (it.async) {
            out2 += " (async" + $lvl + " ? await " + $format + "(" + $data + ") : " + $format + "(" + $data + ")) ";
          } else {
            out2 += " " + $format + "(" + $data + ") ";
          }
          out2 += " : " + $format + ".test(" + $data + "))))) {";
        } else {
          var $format = it.formats[$schema];
          if (!$format) {
            if ($unknownFormats == "ignore") {
              it.logger.warn('unknown format "' + $schema + '" ignored in schema at path "' + it.errSchemaPath + '"');
              if ($breakOnError) {
                out2 += " if (true) { ";
              }
              return out2;
            } else if ($allowUnknown && $unknownFormats.indexOf($schema) >= 0) {
              if ($breakOnError) {
                out2 += " if (true) { ";
              }
              return out2;
            } else {
              throw new Error('unknown format "' + $schema + '" is used in schema at path "' + it.errSchemaPath + '"');
            }
          }
          var $isObject = typeof $format == "object" && !($format instanceof RegExp) && $format.validate;
          var $formatType = $isObject && $format.type || "string";
          if ($isObject) {
            var $async = $format.async === true;
            $format = $format.validate;
          }
          if ($formatType != $ruleType) {
            if ($breakOnError) {
              out2 += " if (true) { ";
            }
            return out2;
          }
          if ($async) {
            if (!it.async)
              throw new Error("async format in sync schema");
            var $formatRef = "formats" + it.util.getProperty($schema) + ".validate";
            out2 += " if (!(await " + $formatRef + "(" + $data + "))) { ";
          } else {
            out2 += " if (! ";
            var $formatRef = "formats" + it.util.getProperty($schema);
            if ($isObject)
              $formatRef += ".validate";
            if (typeof $format == "function") {
              out2 += " " + $formatRef + "(" + $data + ") ";
            } else {
              out2 += " " + $formatRef + ".test(" + $data + ") ";
            }
            out2 += ") { ";
          }
        }
        var $$outStack = $$outStack || [];
        $$outStack.push(out2);
        out2 = "";
        if (it.createErrors !== false) {
          out2 += " { keyword: 'format' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { format:  ";
          if ($isData) {
            out2 += "" + $schemaValue;
          } else {
            out2 += "" + it.util.toQuotedString($schema);
          }
          out2 += "  } ";
          if (it.opts.messages !== false) {
            out2 += ` , message: 'should match format "`;
            if ($isData) {
              out2 += "' + " + $schemaValue + " + '";
            } else {
              out2 += "" + it.util.escapeQuotes($schema);
            }
            out2 += `"' `;
          }
          if (it.opts.verbose) {
            out2 += " , schema:  ";
            if ($isData) {
              out2 += "validate.schema" + $schemaPath;
            } else {
              out2 += "" + it.util.toQuotedString($schema);
            }
            out2 += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        var __err = out2;
        out2 = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError([" + __err + "]); ";
          } else {
            out2 += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out2 += " } ";
        if ($breakOnError) {
          out2 += " else { ";
        }
        return out2;
      };
    });
    require_if2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_if(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $errs = "errs__" + $lvl;
        var $it = it.util.copy(it);
        $it.level++;
        var $nextValid = "valid" + $it.level;
        var $thenSch = it.schema["then"], $elseSch = it.schema["else"], $thenPresent = $thenSch !== void 0 && (it.opts.strictKeywords ? typeof $thenSch == "object" && Object.keys($thenSch).length > 0 || $thenSch === false : it.util.schemaHasRules($thenSch, it.RULES.all)), $elsePresent = $elseSch !== void 0 && (it.opts.strictKeywords ? typeof $elseSch == "object" && Object.keys($elseSch).length > 0 || $elseSch === false : it.util.schemaHasRules($elseSch, it.RULES.all)), $currentBaseId = $it.baseId;
        if ($thenPresent || $elsePresent) {
          var $ifClause;
          $it.createErrors = false;
          $it.schema = $schema;
          $it.schemaPath = $schemaPath;
          $it.errSchemaPath = $errSchemaPath;
          out2 += " var " + $errs + " = errors; var " + $valid + " = true;  ";
          var $wasComposite = it.compositeRule;
          it.compositeRule = $it.compositeRule = true;
          out2 += "  " + it.validate($it) + " ";
          $it.baseId = $currentBaseId;
          $it.createErrors = true;
          out2 += "  errors = " + $errs + "; if (vErrors !== null) { if (" + $errs + ") vErrors.length = " + $errs + "; else vErrors = null; }  ";
          it.compositeRule = $it.compositeRule = $wasComposite;
          if ($thenPresent) {
            out2 += " if (" + $nextValid + ") {  ";
            $it.schema = it.schema["then"];
            $it.schemaPath = it.schemaPath + ".then";
            $it.errSchemaPath = it.errSchemaPath + "/then";
            out2 += "  " + it.validate($it) + " ";
            $it.baseId = $currentBaseId;
            out2 += " " + $valid + " = " + $nextValid + "; ";
            if ($thenPresent && $elsePresent) {
              $ifClause = "ifClause" + $lvl;
              out2 += " var " + $ifClause + " = 'then'; ";
            } else {
              $ifClause = "'then'";
            }
            out2 += " } ";
            if ($elsePresent) {
              out2 += " else { ";
            }
          } else {
            out2 += " if (!" + $nextValid + ") { ";
          }
          if ($elsePresent) {
            $it.schema = it.schema["else"];
            $it.schemaPath = it.schemaPath + ".else";
            $it.errSchemaPath = it.errSchemaPath + "/else";
            out2 += "  " + it.validate($it) + " ";
            $it.baseId = $currentBaseId;
            out2 += " " + $valid + " = " + $nextValid + "; ";
            if ($thenPresent && $elsePresent) {
              $ifClause = "ifClause" + $lvl;
              out2 += " var " + $ifClause + " = 'else'; ";
            } else {
              $ifClause = "'else'";
            }
            out2 += " } ";
          }
          out2 += " if (!" + $valid + ") {   var err =   ";
          if (it.createErrors !== false) {
            out2 += " { keyword: 'if' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { failingKeyword: " + $ifClause + " } ";
            if (it.opts.messages !== false) {
              out2 += ` , message: 'should match "' + ` + $ifClause + ` + '" schema' `;
            }
            if (it.opts.verbose) {
              out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out2 += " } ";
          } else {
            out2 += " {} ";
          }
          out2 += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out2 += " throw new ValidationError(vErrors); ";
            } else {
              out2 += " validate.errors = vErrors; return false; ";
            }
          }
          out2 += " }   ";
          if ($breakOnError) {
            out2 += " else { ";
          }
        } else {
          if ($breakOnError) {
            out2 += " if (true) { ";
          }
        }
        return out2;
      };
    });
    require_items2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_items(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $errs = "errs__" + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = "";
        $it.level++;
        var $nextValid = "valid" + $it.level;
        var $idx = "i" + $lvl, $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = "data" + $dataNxt, $currentBaseId = it.baseId;
        out2 += "var " + $errs + " = errors;var " + $valid + ";";
        if (Array.isArray($schema)) {
          var $additionalItems = it.schema.additionalItems;
          if ($additionalItems === false) {
            out2 += " " + $valid + " = " + $data + ".length <= " + $schema.length + "; ";
            var $currErrSchemaPath = $errSchemaPath;
            $errSchemaPath = it.errSchemaPath + "/additionalItems";
            out2 += "  if (!" + $valid + ") {   ";
            var $$outStack = $$outStack || [];
            $$outStack.push(out2);
            out2 = "";
            if (it.createErrors !== false) {
              out2 += " { keyword: 'additionalItems' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { limit: " + $schema.length + " } ";
              if (it.opts.messages !== false) {
                out2 += " , message: 'should NOT have more than " + $schema.length + " items' ";
              }
              if (it.opts.verbose) {
                out2 += " , schema: false , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
              }
              out2 += " } ";
            } else {
              out2 += " {} ";
            }
            var __err = out2;
            out2 = $$outStack.pop();
            if (!it.compositeRule && $breakOnError) {
              if (it.async) {
                out2 += " throw new ValidationError([" + __err + "]); ";
              } else {
                out2 += " validate.errors = [" + __err + "]; return false; ";
              }
            } else {
              out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
            }
            out2 += " } ";
            $errSchemaPath = $currErrSchemaPath;
            if ($breakOnError) {
              $closingBraces += "}";
              out2 += " else { ";
            }
          }
          var arr1 = $schema;
          if (arr1) {
            var $sch, $i = -1, l1 = arr1.length - 1;
            while ($i < l1) {
              $sch = arr1[$i += 1];
              if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
                out2 += " " + $nextValid + " = true; if (" + $data + ".length > " + $i + ") { ";
                var $passData = $data + "[" + $i + "]";
                $it.schema = $sch;
                $it.schemaPath = $schemaPath + "[" + $i + "]";
                $it.errSchemaPath = $errSchemaPath + "/" + $i;
                $it.errorPath = it.util.getPathExpr(it.errorPath, $i, it.opts.jsonPointers, true);
                $it.dataPathArr[$dataNxt] = $i;
                var $code = it.validate($it);
                $it.baseId = $currentBaseId;
                if (it.util.varOccurences($code, $nextData) < 2) {
                  out2 += " " + it.util.varReplace($code, $nextData, $passData) + " ";
                } else {
                  out2 += " var " + $nextData + " = " + $passData + "; " + $code + " ";
                }
                out2 += " }  ";
                if ($breakOnError) {
                  out2 += " if (" + $nextValid + ") { ";
                  $closingBraces += "}";
                }
              }
            }
          }
          if (typeof $additionalItems == "object" && (it.opts.strictKeywords ? typeof $additionalItems == "object" && Object.keys($additionalItems).length > 0 || $additionalItems === false : it.util.schemaHasRules($additionalItems, it.RULES.all))) {
            $it.schema = $additionalItems;
            $it.schemaPath = it.schemaPath + ".additionalItems";
            $it.errSchemaPath = it.errSchemaPath + "/additionalItems";
            out2 += " " + $nextValid + " = true; if (" + $data + ".length > " + $schema.length + ") {  for (var " + $idx + " = " + $schema.length + "; " + $idx + " < " + $data + ".length; " + $idx + "++) { ";
            $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
            var $passData = $data + "[" + $idx + "]";
            $it.dataPathArr[$dataNxt] = $idx;
            var $code = it.validate($it);
            $it.baseId = $currentBaseId;
            if (it.util.varOccurences($code, $nextData) < 2) {
              out2 += " " + it.util.varReplace($code, $nextData, $passData) + " ";
            } else {
              out2 += " var " + $nextData + " = " + $passData + "; " + $code + " ";
            }
            if ($breakOnError) {
              out2 += " if (!" + $nextValid + ") break; ";
            }
            out2 += " } }  ";
            if ($breakOnError) {
              out2 += " if (" + $nextValid + ") { ";
              $closingBraces += "}";
            }
          }
        } else if (it.opts.strictKeywords ? typeof $schema == "object" && Object.keys($schema).length > 0 || $schema === false : it.util.schemaHasRules($schema, it.RULES.all)) {
          $it.schema = $schema;
          $it.schemaPath = $schemaPath;
          $it.errSchemaPath = $errSchemaPath;
          out2 += "  for (var " + $idx + " = 0; " + $idx + " < " + $data + ".length; " + $idx + "++) { ";
          $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
          var $passData = $data + "[" + $idx + "]";
          $it.dataPathArr[$dataNxt] = $idx;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out2 += " " + it.util.varReplace($code, $nextData, $passData) + " ";
          } else {
            out2 += " var " + $nextData + " = " + $passData + "; " + $code + " ";
          }
          if ($breakOnError) {
            out2 += " if (!" + $nextValid + ") break; ";
          }
          out2 += " }";
        }
        if ($breakOnError) {
          out2 += " " + $closingBraces + " if (" + $errs + " == errors) {";
        }
        return out2;
      };
    });
    require__limit = __commonJS2((exports2, module2) => {
      module2.exports = function generate__limit(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $errorKeyword;
        var $data = "data" + ($dataLvl || "");
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        var $isMax = $keyword == "maximum", $exclusiveKeyword = $isMax ? "exclusiveMaximum" : "exclusiveMinimum", $schemaExcl = it.schema[$exclusiveKeyword], $isDataExcl = it.opts.$data && $schemaExcl && $schemaExcl.$data, $op = $isMax ? "<" : ">", $notOp = $isMax ? ">" : "<", $errorKeyword = void 0;
        if (!($isData || typeof $schema == "number" || $schema === void 0)) {
          throw new Error($keyword + " must be number");
        }
        if (!($isDataExcl || $schemaExcl === void 0 || typeof $schemaExcl == "number" || typeof $schemaExcl == "boolean")) {
          throw new Error($exclusiveKeyword + " must be number or boolean");
        }
        if ($isDataExcl) {
          var $schemaValueExcl = it.util.getData($schemaExcl.$data, $dataLvl, it.dataPathArr), $exclusive = "exclusive" + $lvl, $exclType = "exclType" + $lvl, $exclIsNumber = "exclIsNumber" + $lvl, $opExpr = "op" + $lvl, $opStr = "' + " + $opExpr + " + '";
          out2 += " var schemaExcl" + $lvl + " = " + $schemaValueExcl + "; ";
          $schemaValueExcl = "schemaExcl" + $lvl;
          out2 += " var " + $exclusive + "; var " + $exclType + " = typeof " + $schemaValueExcl + "; if (" + $exclType + " != 'boolean' && " + $exclType + " != 'undefined' && " + $exclType + " != 'number') { ";
          var $errorKeyword = $exclusiveKeyword;
          var $$outStack = $$outStack || [];
          $$outStack.push(out2);
          out2 = "";
          if (it.createErrors !== false) {
            out2 += " { keyword: '" + ($errorKeyword || "_exclusiveLimit") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
            if (it.opts.messages !== false) {
              out2 += " , message: '" + $exclusiveKeyword + " should be boolean' ";
            }
            if (it.opts.verbose) {
              out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out2 += " } ";
          } else {
            out2 += " {} ";
          }
          var __err = out2;
          out2 = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out2 += " throw new ValidationError([" + __err + "]); ";
            } else {
              out2 += " validate.errors = [" + __err + "]; return false; ";
            }
          } else {
            out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          }
          out2 += " } else if ( ";
          if ($isData) {
            out2 += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
          }
          out2 += " " + $exclType + " == 'number' ? ( (" + $exclusive + " = " + $schemaValue + " === undefined || " + $schemaValueExcl + " " + $op + "= " + $schemaValue + ") ? " + $data + " " + $notOp + "= " + $schemaValueExcl + " : " + $data + " " + $notOp + " " + $schemaValue + " ) : ( (" + $exclusive + " = " + $schemaValueExcl + " === true) ? " + $data + " " + $notOp + "= " + $schemaValue + " : " + $data + " " + $notOp + " " + $schemaValue + " ) || " + $data + " !== " + $data + ") { var op" + $lvl + " = " + $exclusive + " ? '" + $op + "' : '" + $op + "='; ";
          if ($schema === void 0) {
            $errorKeyword = $exclusiveKeyword;
            $errSchemaPath = it.errSchemaPath + "/" + $exclusiveKeyword;
            $schemaValue = $schemaValueExcl;
            $isData = $isDataExcl;
          }
        } else {
          var $exclIsNumber = typeof $schemaExcl == "number", $opStr = $op;
          if ($exclIsNumber && $isData) {
            var $opExpr = "'" + $opStr + "'";
            out2 += " if ( ";
            if ($isData) {
              out2 += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
            }
            out2 += " ( " + $schemaValue + " === undefined || " + $schemaExcl + " " + $op + "= " + $schemaValue + " ? " + $data + " " + $notOp + "= " + $schemaExcl + " : " + $data + " " + $notOp + " " + $schemaValue + " ) || " + $data + " !== " + $data + ") { ";
          } else {
            if ($exclIsNumber && $schema === void 0) {
              $exclusive = true;
              $errorKeyword = $exclusiveKeyword;
              $errSchemaPath = it.errSchemaPath + "/" + $exclusiveKeyword;
              $schemaValue = $schemaExcl;
              $notOp += "=";
            } else {
              if ($exclIsNumber)
                $schemaValue = Math[$isMax ? "min" : "max"]($schemaExcl, $schema);
              if ($schemaExcl === ($exclIsNumber ? $schemaValue : true)) {
                $exclusive = true;
                $errorKeyword = $exclusiveKeyword;
                $errSchemaPath = it.errSchemaPath + "/" + $exclusiveKeyword;
                $notOp += "=";
              } else {
                $exclusive = false;
                $opStr += "=";
              }
            }
            var $opExpr = "'" + $opStr + "'";
            out2 += " if ( ";
            if ($isData) {
              out2 += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
            }
            out2 += " " + $data + " " + $notOp + " " + $schemaValue + " || " + $data + " !== " + $data + ") { ";
          }
        }
        $errorKeyword = $errorKeyword || $keyword;
        var $$outStack = $$outStack || [];
        $$outStack.push(out2);
        out2 = "";
        if (it.createErrors !== false) {
          out2 += " { keyword: '" + ($errorKeyword || "_limit") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { comparison: " + $opExpr + ", limit: " + $schemaValue + ", exclusive: " + $exclusive + " } ";
          if (it.opts.messages !== false) {
            out2 += " , message: 'should be " + $opStr + " ";
            if ($isData) {
              out2 += "' + " + $schemaValue;
            } else {
              out2 += "" + $schemaValue + "'";
            }
          }
          if (it.opts.verbose) {
            out2 += " , schema:  ";
            if ($isData) {
              out2 += "validate.schema" + $schemaPath;
            } else {
              out2 += "" + $schema;
            }
            out2 += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        var __err = out2;
        out2 = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError([" + __err + "]); ";
          } else {
            out2 += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out2 += " } ";
        if ($breakOnError) {
          out2 += " else { ";
        }
        return out2;
      };
    });
    require__limitItems = __commonJS2((exports2, module2) => {
      module2.exports = function generate__limitItems(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $errorKeyword;
        var $data = "data" + ($dataLvl || "");
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        if (!($isData || typeof $schema == "number")) {
          throw new Error($keyword + " must be number");
        }
        var $op = $keyword == "maxItems" ? ">" : "<";
        out2 += "if ( ";
        if ($isData) {
          out2 += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
        }
        out2 += " " + $data + ".length " + $op + " " + $schemaValue + ") { ";
        var $errorKeyword = $keyword;
        var $$outStack = $$outStack || [];
        $$outStack.push(out2);
        out2 = "";
        if (it.createErrors !== false) {
          out2 += " { keyword: '" + ($errorKeyword || "_limitItems") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { limit: " + $schemaValue + " } ";
          if (it.opts.messages !== false) {
            out2 += " , message: 'should NOT have ";
            if ($keyword == "maxItems") {
              out2 += "more";
            } else {
              out2 += "fewer";
            }
            out2 += " than ";
            if ($isData) {
              out2 += "' + " + $schemaValue + " + '";
            } else {
              out2 += "" + $schema;
            }
            out2 += " items' ";
          }
          if (it.opts.verbose) {
            out2 += " , schema:  ";
            if ($isData) {
              out2 += "validate.schema" + $schemaPath;
            } else {
              out2 += "" + $schema;
            }
            out2 += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        var __err = out2;
        out2 = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError([" + __err + "]); ";
          } else {
            out2 += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out2 += "} ";
        if ($breakOnError) {
          out2 += " else { ";
        }
        return out2;
      };
    });
    require__limitLength = __commonJS2((exports2, module2) => {
      module2.exports = function generate__limitLength(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $errorKeyword;
        var $data = "data" + ($dataLvl || "");
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        if (!($isData || typeof $schema == "number")) {
          throw new Error($keyword + " must be number");
        }
        var $op = $keyword == "maxLength" ? ">" : "<";
        out2 += "if ( ";
        if ($isData) {
          out2 += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
        }
        if (it.opts.unicode === false) {
          out2 += " " + $data + ".length ";
        } else {
          out2 += " ucs2length(" + $data + ") ";
        }
        out2 += " " + $op + " " + $schemaValue + ") { ";
        var $errorKeyword = $keyword;
        var $$outStack = $$outStack || [];
        $$outStack.push(out2);
        out2 = "";
        if (it.createErrors !== false) {
          out2 += " { keyword: '" + ($errorKeyword || "_limitLength") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { limit: " + $schemaValue + " } ";
          if (it.opts.messages !== false) {
            out2 += " , message: 'should NOT be ";
            if ($keyword == "maxLength") {
              out2 += "longer";
            } else {
              out2 += "shorter";
            }
            out2 += " than ";
            if ($isData) {
              out2 += "' + " + $schemaValue + " + '";
            } else {
              out2 += "" + $schema;
            }
            out2 += " characters' ";
          }
          if (it.opts.verbose) {
            out2 += " , schema:  ";
            if ($isData) {
              out2 += "validate.schema" + $schemaPath;
            } else {
              out2 += "" + $schema;
            }
            out2 += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        var __err = out2;
        out2 = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError([" + __err + "]); ";
          } else {
            out2 += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out2 += "} ";
        if ($breakOnError) {
          out2 += " else { ";
        }
        return out2;
      };
    });
    require__limitProperties = __commonJS2((exports2, module2) => {
      module2.exports = function generate__limitProperties(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $errorKeyword;
        var $data = "data" + ($dataLvl || "");
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        if (!($isData || typeof $schema == "number")) {
          throw new Error($keyword + " must be number");
        }
        var $op = $keyword == "maxProperties" ? ">" : "<";
        out2 += "if ( ";
        if ($isData) {
          out2 += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'number') || ";
        }
        out2 += " Object.keys(" + $data + ").length " + $op + " " + $schemaValue + ") { ";
        var $errorKeyword = $keyword;
        var $$outStack = $$outStack || [];
        $$outStack.push(out2);
        out2 = "";
        if (it.createErrors !== false) {
          out2 += " { keyword: '" + ($errorKeyword || "_limitProperties") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { limit: " + $schemaValue + " } ";
          if (it.opts.messages !== false) {
            out2 += " , message: 'should NOT have ";
            if ($keyword == "maxProperties") {
              out2 += "more";
            } else {
              out2 += "fewer";
            }
            out2 += " than ";
            if ($isData) {
              out2 += "' + " + $schemaValue + " + '";
            } else {
              out2 += "" + $schema;
            }
            out2 += " properties' ";
          }
          if (it.opts.verbose) {
            out2 += " , schema:  ";
            if ($isData) {
              out2 += "validate.schema" + $schemaPath;
            } else {
              out2 += "" + $schema;
            }
            out2 += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        var __err = out2;
        out2 = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError([" + __err + "]); ";
          } else {
            out2 += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out2 += "} ";
        if ($breakOnError) {
          out2 += " else { ";
        }
        return out2;
      };
    });
    require_multipleOf2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_multipleOf(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        if (!($isData || typeof $schema == "number")) {
          throw new Error($keyword + " must be number");
        }
        out2 += "var division" + $lvl + ";if (";
        if ($isData) {
          out2 += " " + $schemaValue + " !== undefined && ( typeof " + $schemaValue + " != 'number' || ";
        }
        out2 += " (division" + $lvl + " = " + $data + " / " + $schemaValue + ", ";
        if (it.opts.multipleOfPrecision) {
          out2 += " Math.abs(Math.round(division" + $lvl + ") - division" + $lvl + ") > 1e-" + it.opts.multipleOfPrecision + " ";
        } else {
          out2 += " division" + $lvl + " !== parseInt(division" + $lvl + ") ";
        }
        out2 += " ) ";
        if ($isData) {
          out2 += "  )  ";
        }
        out2 += " ) {   ";
        var $$outStack = $$outStack || [];
        $$outStack.push(out2);
        out2 = "";
        if (it.createErrors !== false) {
          out2 += " { keyword: 'multipleOf' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { multipleOf: " + $schemaValue + " } ";
          if (it.opts.messages !== false) {
            out2 += " , message: 'should be multiple of ";
            if ($isData) {
              out2 += "' + " + $schemaValue;
            } else {
              out2 += "" + $schemaValue + "'";
            }
          }
          if (it.opts.verbose) {
            out2 += " , schema:  ";
            if ($isData) {
              out2 += "validate.schema" + $schemaPath;
            } else {
              out2 += "" + $schema;
            }
            out2 += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        var __err = out2;
        out2 = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError([" + __err + "]); ";
          } else {
            out2 += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out2 += "} ";
        if ($breakOnError) {
          out2 += " else { ";
        }
        return out2;
      };
    });
    require_not2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_not(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $errs = "errs__" + $lvl;
        var $it = it.util.copy(it);
        $it.level++;
        var $nextValid = "valid" + $it.level;
        if (it.opts.strictKeywords ? typeof $schema == "object" && Object.keys($schema).length > 0 || $schema === false : it.util.schemaHasRules($schema, it.RULES.all)) {
          $it.schema = $schema;
          $it.schemaPath = $schemaPath;
          $it.errSchemaPath = $errSchemaPath;
          out2 += " var " + $errs + " = errors;  ";
          var $wasComposite = it.compositeRule;
          it.compositeRule = $it.compositeRule = true;
          $it.createErrors = false;
          var $allErrorsOption;
          if ($it.opts.allErrors) {
            $allErrorsOption = $it.opts.allErrors;
            $it.opts.allErrors = false;
          }
          out2 += " " + it.validate($it) + " ";
          $it.createErrors = true;
          if ($allErrorsOption)
            $it.opts.allErrors = $allErrorsOption;
          it.compositeRule = $it.compositeRule = $wasComposite;
          out2 += " if (" + $nextValid + ") {   ";
          var $$outStack = $$outStack || [];
          $$outStack.push(out2);
          out2 = "";
          if (it.createErrors !== false) {
            out2 += " { keyword: 'not' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
            if (it.opts.messages !== false) {
              out2 += " , message: 'should NOT be valid' ";
            }
            if (it.opts.verbose) {
              out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out2 += " } ";
          } else {
            out2 += " {} ";
          }
          var __err = out2;
          out2 = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out2 += " throw new ValidationError([" + __err + "]); ";
            } else {
              out2 += " validate.errors = [" + __err + "]; return false; ";
            }
          } else {
            out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          }
          out2 += " } else {  errors = " + $errs + "; if (vErrors !== null) { if (" + $errs + ") vErrors.length = " + $errs + "; else vErrors = null; } ";
          if (it.opts.allErrors) {
            out2 += " } ";
          }
        } else {
          out2 += "  var err =   ";
          if (it.createErrors !== false) {
            out2 += " { keyword: 'not' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: {} ";
            if (it.opts.messages !== false) {
              out2 += " , message: 'should NOT be valid' ";
            }
            if (it.opts.verbose) {
              out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out2 += " } ";
          } else {
            out2 += " {} ";
          }
          out2 += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          if ($breakOnError) {
            out2 += " if (false) { ";
          }
        }
        return out2;
      };
    });
    require_oneOf2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_oneOf(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $errs = "errs__" + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = "";
        $it.level++;
        var $nextValid = "valid" + $it.level;
        var $currentBaseId = $it.baseId, $prevValid = "prevValid" + $lvl, $passingSchemas = "passingSchemas" + $lvl;
        out2 += "var " + $errs + " = errors , " + $prevValid + " = false , " + $valid + " = false , " + $passingSchemas + " = null; ";
        var $wasComposite = it.compositeRule;
        it.compositeRule = $it.compositeRule = true;
        var arr1 = $schema;
        if (arr1) {
          var $sch, $i = -1, l1 = arr1.length - 1;
          while ($i < l1) {
            $sch = arr1[$i += 1];
            if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
              $it.schema = $sch;
              $it.schemaPath = $schemaPath + "[" + $i + "]";
              $it.errSchemaPath = $errSchemaPath + "/" + $i;
              out2 += "  " + it.validate($it) + " ";
              $it.baseId = $currentBaseId;
            } else {
              out2 += " var " + $nextValid + " = true; ";
            }
            if ($i) {
              out2 += " if (" + $nextValid + " && " + $prevValid + ") { " + $valid + " = false; " + $passingSchemas + " = [" + $passingSchemas + ", " + $i + "]; } else { ";
              $closingBraces += "}";
            }
            out2 += " if (" + $nextValid + ") { " + $valid + " = " + $prevValid + " = true; " + $passingSchemas + " = " + $i + "; }";
          }
        }
        it.compositeRule = $it.compositeRule = $wasComposite;
        out2 += "" + $closingBraces + "if (!" + $valid + ") {   var err =   ";
        if (it.createErrors !== false) {
          out2 += " { keyword: 'oneOf' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { passingSchemas: " + $passingSchemas + " } ";
          if (it.opts.messages !== false) {
            out2 += " , message: 'should match exactly one schema in oneOf' ";
          }
          if (it.opts.verbose) {
            out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        out2 += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError(vErrors); ";
          } else {
            out2 += " validate.errors = vErrors; return false; ";
          }
        }
        out2 += "} else {  errors = " + $errs + "; if (vErrors !== null) { if (" + $errs + ") vErrors.length = " + $errs + "; else vErrors = null; }";
        if (it.opts.allErrors) {
          out2 += " } ";
        }
        return out2;
      };
    });
    require_pattern2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_pattern(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        var $regexp = $isData ? "(new RegExp(" + $schemaValue + "))" : it.usePattern($schema);
        out2 += "if ( ";
        if ($isData) {
          out2 += " (" + $schemaValue + " !== undefined && typeof " + $schemaValue + " != 'string') || ";
        }
        out2 += " !" + $regexp + ".test(" + $data + ") ) {   ";
        var $$outStack = $$outStack || [];
        $$outStack.push(out2);
        out2 = "";
        if (it.createErrors !== false) {
          out2 += " { keyword: 'pattern' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { pattern:  ";
          if ($isData) {
            out2 += "" + $schemaValue;
          } else {
            out2 += "" + it.util.toQuotedString($schema);
          }
          out2 += "  } ";
          if (it.opts.messages !== false) {
            out2 += ` , message: 'should match pattern "`;
            if ($isData) {
              out2 += "' + " + $schemaValue + " + '";
            } else {
              out2 += "" + it.util.escapeQuotes($schema);
            }
            out2 += `"' `;
          }
          if (it.opts.verbose) {
            out2 += " , schema:  ";
            if ($isData) {
              out2 += "validate.schema" + $schemaPath;
            } else {
              out2 += "" + it.util.toQuotedString($schema);
            }
            out2 += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
          }
          out2 += " } ";
        } else {
          out2 += " {} ";
        }
        var __err = out2;
        out2 = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          if (it.async) {
            out2 += " throw new ValidationError([" + __err + "]); ";
          } else {
            out2 += " validate.errors = [" + __err + "]; return false; ";
          }
        } else {
          out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
        }
        out2 += "} ";
        if ($breakOnError) {
          out2 += " else { ";
        }
        return out2;
      };
    });
    require_properties2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_properties(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $errs = "errs__" + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = "";
        $it.level++;
        var $nextValid = "valid" + $it.level;
        var $key = "key" + $lvl, $idx = "idx" + $lvl, $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = "data" + $dataNxt, $dataProperties = "dataProperties" + $lvl;
        var $schemaKeys = Object.keys($schema || {}).filter(notProto), $pProperties = it.schema.patternProperties || {}, $pPropertyKeys = Object.keys($pProperties).filter(notProto), $aProperties = it.schema.additionalProperties, $someProperties = $schemaKeys.length || $pPropertyKeys.length, $noAdditional = $aProperties === false, $additionalIsSchema = typeof $aProperties == "object" && Object.keys($aProperties).length, $removeAdditional = it.opts.removeAdditional, $checkAdditional = $noAdditional || $additionalIsSchema || $removeAdditional, $ownProperties = it.opts.ownProperties, $currentBaseId = it.baseId;
        var $required = it.schema.required;
        if ($required && !(it.opts.$data && $required.$data) && $required.length < it.opts.loopRequired) {
          var $requiredHash = it.util.toHash($required);
        }
        function notProto(p2) {
          return p2 !== "__proto__";
        }
        out2 += "var " + $errs + " = errors;var " + $nextValid + " = true;";
        if ($ownProperties) {
          out2 += " var " + $dataProperties + " = undefined;";
        }
        if ($checkAdditional) {
          if ($ownProperties) {
            out2 += " " + $dataProperties + " = " + $dataProperties + " || Object.keys(" + $data + "); for (var " + $idx + "=0; " + $idx + "<" + $dataProperties + ".length; " + $idx + "++) { var " + $key + " = " + $dataProperties + "[" + $idx + "]; ";
          } else {
            out2 += " for (var " + $key + " in " + $data + ") { ";
          }
          if ($someProperties) {
            out2 += " var isAdditional" + $lvl + " = !(false ";
            if ($schemaKeys.length) {
              if ($schemaKeys.length > 8) {
                out2 += " || validate.schema" + $schemaPath + ".hasOwnProperty(" + $key + ") ";
              } else {
                var arr1 = $schemaKeys;
                if (arr1) {
                  var $propertyKey, i1 = -1, l1 = arr1.length - 1;
                  while (i1 < l1) {
                    $propertyKey = arr1[i1 += 1];
                    out2 += " || " + $key + " == " + it.util.toQuotedString($propertyKey) + " ";
                  }
                }
              }
            }
            if ($pPropertyKeys.length) {
              var arr2 = $pPropertyKeys;
              if (arr2) {
                var $pProperty, $i = -1, l22 = arr2.length - 1;
                while ($i < l22) {
                  $pProperty = arr2[$i += 1];
                  out2 += " || " + it.usePattern($pProperty) + ".test(" + $key + ") ";
                }
              }
            }
            out2 += " ); if (isAdditional" + $lvl + ") { ";
          }
          if ($removeAdditional == "all") {
            out2 += " delete " + $data + "[" + $key + "]; ";
          } else {
            var $currentErrorPath = it.errorPath;
            var $additionalProperty = "' + " + $key + " + '";
            if (it.opts._errorDataPathProperty) {
              it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
            }
            if ($noAdditional) {
              if ($removeAdditional) {
                out2 += " delete " + $data + "[" + $key + "]; ";
              } else {
                out2 += " " + $nextValid + " = false; ";
                var $currErrSchemaPath = $errSchemaPath;
                $errSchemaPath = it.errSchemaPath + "/additionalProperties";
                var $$outStack = $$outStack || [];
                $$outStack.push(out2);
                out2 = "";
                if (it.createErrors !== false) {
                  out2 += " { keyword: 'additionalProperties' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { additionalProperty: '" + $additionalProperty + "' } ";
                  if (it.opts.messages !== false) {
                    out2 += " , message: '";
                    if (it.opts._errorDataPathProperty) {
                      out2 += "is an invalid additional property";
                    } else {
                      out2 += "should NOT have additional properties";
                    }
                    out2 += "' ";
                  }
                  if (it.opts.verbose) {
                    out2 += " , schema: false , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                  }
                  out2 += " } ";
                } else {
                  out2 += " {} ";
                }
                var __err = out2;
                out2 = $$outStack.pop();
                if (!it.compositeRule && $breakOnError) {
                  if (it.async) {
                    out2 += " throw new ValidationError([" + __err + "]); ";
                  } else {
                    out2 += " validate.errors = [" + __err + "]; return false; ";
                  }
                } else {
                  out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
                }
                $errSchemaPath = $currErrSchemaPath;
                if ($breakOnError) {
                  out2 += " break; ";
                }
              }
            } else if ($additionalIsSchema) {
              if ($removeAdditional == "failing") {
                out2 += " var " + $errs + " = errors;  ";
                var $wasComposite = it.compositeRule;
                it.compositeRule = $it.compositeRule = true;
                $it.schema = $aProperties;
                $it.schemaPath = it.schemaPath + ".additionalProperties";
                $it.errSchemaPath = it.errSchemaPath + "/additionalProperties";
                $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
                var $passData = $data + "[" + $key + "]";
                $it.dataPathArr[$dataNxt] = $key;
                var $code = it.validate($it);
                $it.baseId = $currentBaseId;
                if (it.util.varOccurences($code, $nextData) < 2) {
                  out2 += " " + it.util.varReplace($code, $nextData, $passData) + " ";
                } else {
                  out2 += " var " + $nextData + " = " + $passData + "; " + $code + " ";
                }
                out2 += " if (!" + $nextValid + ") { errors = " + $errs + "; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete " + $data + "[" + $key + "]; }  ";
                it.compositeRule = $it.compositeRule = $wasComposite;
              } else {
                $it.schema = $aProperties;
                $it.schemaPath = it.schemaPath + ".additionalProperties";
                $it.errSchemaPath = it.errSchemaPath + "/additionalProperties";
                $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
                var $passData = $data + "[" + $key + "]";
                $it.dataPathArr[$dataNxt] = $key;
                var $code = it.validate($it);
                $it.baseId = $currentBaseId;
                if (it.util.varOccurences($code, $nextData) < 2) {
                  out2 += " " + it.util.varReplace($code, $nextData, $passData) + " ";
                } else {
                  out2 += " var " + $nextData + " = " + $passData + "; " + $code + " ";
                }
                if ($breakOnError) {
                  out2 += " if (!" + $nextValid + ") break; ";
                }
              }
            }
            it.errorPath = $currentErrorPath;
          }
          if ($someProperties) {
            out2 += " } ";
          }
          out2 += " }  ";
          if ($breakOnError) {
            out2 += " if (" + $nextValid + ") { ";
            $closingBraces += "}";
          }
        }
        var $useDefaults = it.opts.useDefaults && !it.compositeRule;
        if ($schemaKeys.length) {
          var arr3 = $schemaKeys;
          if (arr3) {
            var $propertyKey, i3 = -1, l3 = arr3.length - 1;
            while (i3 < l3) {
              $propertyKey = arr3[i3 += 1];
              var $sch = $schema[$propertyKey];
              if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
                var $prop = it.util.getProperty($propertyKey), $passData = $data + $prop, $hasDefault = $useDefaults && $sch.default !== void 0;
                $it.schema = $sch;
                $it.schemaPath = $schemaPath + $prop;
                $it.errSchemaPath = $errSchemaPath + "/" + it.util.escapeFragment($propertyKey);
                $it.errorPath = it.util.getPath(it.errorPath, $propertyKey, it.opts.jsonPointers);
                $it.dataPathArr[$dataNxt] = it.util.toQuotedString($propertyKey);
                var $code = it.validate($it);
                $it.baseId = $currentBaseId;
                if (it.util.varOccurences($code, $nextData) < 2) {
                  $code = it.util.varReplace($code, $nextData, $passData);
                  var $useData = $passData;
                } else {
                  var $useData = $nextData;
                  out2 += " var " + $nextData + " = " + $passData + "; ";
                }
                if ($hasDefault) {
                  out2 += " " + $code + " ";
                } else {
                  if ($requiredHash && $requiredHash[$propertyKey]) {
                    out2 += " if ( " + $useData + " === undefined ";
                    if ($ownProperties) {
                      out2 += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
                    }
                    out2 += ") { " + $nextValid + " = false; ";
                    var $currentErrorPath = it.errorPath, $currErrSchemaPath = $errSchemaPath, $missingProperty = it.util.escapeQuotes($propertyKey);
                    if (it.opts._errorDataPathProperty) {
                      it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
                    }
                    $errSchemaPath = it.errSchemaPath + "/required";
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out2);
                    out2 = "";
                    if (it.createErrors !== false) {
                      out2 += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
                      if (it.opts.messages !== false) {
                        out2 += " , message: '";
                        if (it.opts._errorDataPathProperty) {
                          out2 += "is a required property";
                        } else {
                          out2 += "should have required property \\'" + $missingProperty + "\\'";
                        }
                        out2 += "' ";
                      }
                      if (it.opts.verbose) {
                        out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                      }
                      out2 += " } ";
                    } else {
                      out2 += " {} ";
                    }
                    var __err = out2;
                    out2 = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) {
                      if (it.async) {
                        out2 += " throw new ValidationError([" + __err + "]); ";
                      } else {
                        out2 += " validate.errors = [" + __err + "]; return false; ";
                      }
                    } else {
                      out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
                    }
                    $errSchemaPath = $currErrSchemaPath;
                    it.errorPath = $currentErrorPath;
                    out2 += " } else { ";
                  } else {
                    if ($breakOnError) {
                      out2 += " if ( " + $useData + " === undefined ";
                      if ($ownProperties) {
                        out2 += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
                      }
                      out2 += ") { " + $nextValid + " = true; } else { ";
                    } else {
                      out2 += " if (" + $useData + " !== undefined ";
                      if ($ownProperties) {
                        out2 += " &&   Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
                      }
                      out2 += " ) { ";
                    }
                  }
                  out2 += " " + $code + " } ";
                }
              }
              if ($breakOnError) {
                out2 += " if (" + $nextValid + ") { ";
                $closingBraces += "}";
              }
            }
          }
        }
        if ($pPropertyKeys.length) {
          var arr4 = $pPropertyKeys;
          if (arr4) {
            var $pProperty, i4 = -1, l4 = arr4.length - 1;
            while (i4 < l4) {
              $pProperty = arr4[i4 += 1];
              var $sch = $pProperties[$pProperty];
              if (it.opts.strictKeywords ? typeof $sch == "object" && Object.keys($sch).length > 0 || $sch === false : it.util.schemaHasRules($sch, it.RULES.all)) {
                $it.schema = $sch;
                $it.schemaPath = it.schemaPath + ".patternProperties" + it.util.getProperty($pProperty);
                $it.errSchemaPath = it.errSchemaPath + "/patternProperties/" + it.util.escapeFragment($pProperty);
                if ($ownProperties) {
                  out2 += " " + $dataProperties + " = " + $dataProperties + " || Object.keys(" + $data + "); for (var " + $idx + "=0; " + $idx + "<" + $dataProperties + ".length; " + $idx + "++) { var " + $key + " = " + $dataProperties + "[" + $idx + "]; ";
                } else {
                  out2 += " for (var " + $key + " in " + $data + ") { ";
                }
                out2 += " if (" + it.usePattern($pProperty) + ".test(" + $key + ")) { ";
                $it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
                var $passData = $data + "[" + $key + "]";
                $it.dataPathArr[$dataNxt] = $key;
                var $code = it.validate($it);
                $it.baseId = $currentBaseId;
                if (it.util.varOccurences($code, $nextData) < 2) {
                  out2 += " " + it.util.varReplace($code, $nextData, $passData) + " ";
                } else {
                  out2 += " var " + $nextData + " = " + $passData + "; " + $code + " ";
                }
                if ($breakOnError) {
                  out2 += " if (!" + $nextValid + ") break; ";
                }
                out2 += " } ";
                if ($breakOnError) {
                  out2 += " else " + $nextValid + " = true; ";
                }
                out2 += " }  ";
                if ($breakOnError) {
                  out2 += " if (" + $nextValid + ") { ";
                  $closingBraces += "}";
                }
              }
            }
          }
        }
        if ($breakOnError) {
          out2 += " " + $closingBraces + " if (" + $errs + " == errors) {";
        }
        return out2;
      };
    });
    require_propertyNames2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_propertyNames(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $errs = "errs__" + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = "";
        $it.level++;
        var $nextValid = "valid" + $it.level;
        out2 += "var " + $errs + " = errors;";
        if (it.opts.strictKeywords ? typeof $schema == "object" && Object.keys($schema).length > 0 || $schema === false : it.util.schemaHasRules($schema, it.RULES.all)) {
          $it.schema = $schema;
          $it.schemaPath = $schemaPath;
          $it.errSchemaPath = $errSchemaPath;
          var $key = "key" + $lvl, $idx = "idx" + $lvl, $i = "i" + $lvl, $invalidName = "' + " + $key + " + '", $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = "data" + $dataNxt, $dataProperties = "dataProperties" + $lvl, $ownProperties = it.opts.ownProperties, $currentBaseId = it.baseId;
          if ($ownProperties) {
            out2 += " var " + $dataProperties + " = undefined; ";
          }
          if ($ownProperties) {
            out2 += " " + $dataProperties + " = " + $dataProperties + " || Object.keys(" + $data + "); for (var " + $idx + "=0; " + $idx + "<" + $dataProperties + ".length; " + $idx + "++) { var " + $key + " = " + $dataProperties + "[" + $idx + "]; ";
          } else {
            out2 += " for (var " + $key + " in " + $data + ") { ";
          }
          out2 += " var startErrs" + $lvl + " = errors; ";
          var $passData = $key;
          var $wasComposite = it.compositeRule;
          it.compositeRule = $it.compositeRule = true;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out2 += " " + it.util.varReplace($code, $nextData, $passData) + " ";
          } else {
            out2 += " var " + $nextData + " = " + $passData + "; " + $code + " ";
          }
          it.compositeRule = $it.compositeRule = $wasComposite;
          out2 += " if (!" + $nextValid + ") { for (var " + $i + "=startErrs" + $lvl + "; " + $i + "<errors; " + $i + "++) { vErrors[" + $i + "].propertyName = " + $key + "; }   var err =   ";
          if (it.createErrors !== false) {
            out2 += " { keyword: 'propertyNames' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { propertyName: '" + $invalidName + "' } ";
            if (it.opts.messages !== false) {
              out2 += " , message: 'property name \\'" + $invalidName + "\\' is invalid' ";
            }
            if (it.opts.verbose) {
              out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out2 += " } ";
          } else {
            out2 += " {} ";
          }
          out2 += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out2 += " throw new ValidationError(vErrors); ";
            } else {
              out2 += " validate.errors = vErrors; return false; ";
            }
          }
          if ($breakOnError) {
            out2 += " break; ";
          }
          out2 += " } }";
        }
        if ($breakOnError) {
          out2 += " " + $closingBraces + " if (" + $errs + " == errors) {";
        }
        return out2;
      };
    });
    require_required2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_required(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        var $vSchema = "schema" + $lvl;
        if (!$isData) {
          if ($schema.length < it.opts.loopRequired && it.schema.properties && Object.keys(it.schema.properties).length) {
            var $required = [];
            var arr1 = $schema;
            if (arr1) {
              var $property, i1 = -1, l1 = arr1.length - 1;
              while (i1 < l1) {
                $property = arr1[i1 += 1];
                var $propertySch = it.schema.properties[$property];
                if (!($propertySch && (it.opts.strictKeywords ? typeof $propertySch == "object" && Object.keys($propertySch).length > 0 || $propertySch === false : it.util.schemaHasRules($propertySch, it.RULES.all)))) {
                  $required[$required.length] = $property;
                }
              }
            }
          } else {
            var $required = $schema;
          }
        }
        if ($isData || $required.length) {
          var $currentErrorPath = it.errorPath, $loopRequired = $isData || $required.length >= it.opts.loopRequired, $ownProperties = it.opts.ownProperties;
          if ($breakOnError) {
            out2 += " var missing" + $lvl + "; ";
            if ($loopRequired) {
              if (!$isData) {
                out2 += " var " + $vSchema + " = validate.schema" + $schemaPath + "; ";
              }
              var $i = "i" + $lvl, $propertyPath = "schema" + $lvl + "[" + $i + "]", $missingProperty = "' + " + $propertyPath + " + '";
              if (it.opts._errorDataPathProperty) {
                it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
              }
              out2 += " var " + $valid + " = true; ";
              if ($isData) {
                out2 += " if (schema" + $lvl + " === undefined) " + $valid + " = true; else if (!Array.isArray(schema" + $lvl + ")) " + $valid + " = false; else {";
              }
              out2 += " for (var " + $i + " = 0; " + $i + " < " + $vSchema + ".length; " + $i + "++) { " + $valid + " = " + $data + "[" + $vSchema + "[" + $i + "]] !== undefined ";
              if ($ownProperties) {
                out2 += " &&   Object.prototype.hasOwnProperty.call(" + $data + ", " + $vSchema + "[" + $i + "]) ";
              }
              out2 += "; if (!" + $valid + ") break; } ";
              if ($isData) {
                out2 += "  }  ";
              }
              out2 += "  if (!" + $valid + ") {   ";
              var $$outStack = $$outStack || [];
              $$outStack.push(out2);
              out2 = "";
              if (it.createErrors !== false) {
                out2 += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
                if (it.opts.messages !== false) {
                  out2 += " , message: '";
                  if (it.opts._errorDataPathProperty) {
                    out2 += "is a required property";
                  } else {
                    out2 += "should have required property \\'" + $missingProperty + "\\'";
                  }
                  out2 += "' ";
                }
                if (it.opts.verbose) {
                  out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                }
                out2 += " } ";
              } else {
                out2 += " {} ";
              }
              var __err = out2;
              out2 = $$outStack.pop();
              if (!it.compositeRule && $breakOnError) {
                if (it.async) {
                  out2 += " throw new ValidationError([" + __err + "]); ";
                } else {
                  out2 += " validate.errors = [" + __err + "]; return false; ";
                }
              } else {
                out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
              }
              out2 += " } else { ";
            } else {
              out2 += " if ( ";
              var arr2 = $required;
              if (arr2) {
                var $propertyKey, $i = -1, l22 = arr2.length - 1;
                while ($i < l22) {
                  $propertyKey = arr2[$i += 1];
                  if ($i) {
                    out2 += " || ";
                  }
                  var $prop = it.util.getProperty($propertyKey), $useData = $data + $prop;
                  out2 += " ( ( " + $useData + " === undefined ";
                  if ($ownProperties) {
                    out2 += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
                  }
                  out2 += ") && (missing" + $lvl + " = " + it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop) + ") ) ";
                }
              }
              out2 += ") {  ";
              var $propertyPath = "missing" + $lvl, $missingProperty = "' + " + $propertyPath + " + '";
              if (it.opts._errorDataPathProperty) {
                it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + " + " + $propertyPath;
              }
              var $$outStack = $$outStack || [];
              $$outStack.push(out2);
              out2 = "";
              if (it.createErrors !== false) {
                out2 += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
                if (it.opts.messages !== false) {
                  out2 += " , message: '";
                  if (it.opts._errorDataPathProperty) {
                    out2 += "is a required property";
                  } else {
                    out2 += "should have required property \\'" + $missingProperty + "\\'";
                  }
                  out2 += "' ";
                }
                if (it.opts.verbose) {
                  out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                }
                out2 += " } ";
              } else {
                out2 += " {} ";
              }
              var __err = out2;
              out2 = $$outStack.pop();
              if (!it.compositeRule && $breakOnError) {
                if (it.async) {
                  out2 += " throw new ValidationError([" + __err + "]); ";
                } else {
                  out2 += " validate.errors = [" + __err + "]; return false; ";
                }
              } else {
                out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
              }
              out2 += " } else { ";
            }
          } else {
            if ($loopRequired) {
              if (!$isData) {
                out2 += " var " + $vSchema + " = validate.schema" + $schemaPath + "; ";
              }
              var $i = "i" + $lvl, $propertyPath = "schema" + $lvl + "[" + $i + "]", $missingProperty = "' + " + $propertyPath + " + '";
              if (it.opts._errorDataPathProperty) {
                it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
              }
              if ($isData) {
                out2 += " if (" + $vSchema + " && !Array.isArray(" + $vSchema + ")) {  var err =   ";
                if (it.createErrors !== false) {
                  out2 += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
                  if (it.opts.messages !== false) {
                    out2 += " , message: '";
                    if (it.opts._errorDataPathProperty) {
                      out2 += "is a required property";
                    } else {
                      out2 += "should have required property \\'" + $missingProperty + "\\'";
                    }
                    out2 += "' ";
                  }
                  if (it.opts.verbose) {
                    out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                  }
                  out2 += " } ";
                } else {
                  out2 += " {} ";
                }
                out2 += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if (" + $vSchema + " !== undefined) { ";
              }
              out2 += " for (var " + $i + " = 0; " + $i + " < " + $vSchema + ".length; " + $i + "++) { if (" + $data + "[" + $vSchema + "[" + $i + "]] === undefined ";
              if ($ownProperties) {
                out2 += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", " + $vSchema + "[" + $i + "]) ";
              }
              out2 += ") {  var err =   ";
              if (it.createErrors !== false) {
                out2 += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
                if (it.opts.messages !== false) {
                  out2 += " , message: '";
                  if (it.opts._errorDataPathProperty) {
                    out2 += "is a required property";
                  } else {
                    out2 += "should have required property \\'" + $missingProperty + "\\'";
                  }
                  out2 += "' ";
                }
                if (it.opts.verbose) {
                  out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                }
                out2 += " } ";
              } else {
                out2 += " {} ";
              }
              out2 += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ";
              if ($isData) {
                out2 += "  }  ";
              }
            } else {
              var arr3 = $required;
              if (arr3) {
                var $propertyKey, i3 = -1, l3 = arr3.length - 1;
                while (i3 < l3) {
                  $propertyKey = arr3[i3 += 1];
                  var $prop = it.util.getProperty($propertyKey), $missingProperty = it.util.escapeQuotes($propertyKey), $useData = $data + $prop;
                  if (it.opts._errorDataPathProperty) {
                    it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
                  }
                  out2 += " if ( " + $useData + " === undefined ";
                  if ($ownProperties) {
                    out2 += " || ! Object.prototype.hasOwnProperty.call(" + $data + ", '" + it.util.escapeQuotes($propertyKey) + "') ";
                  }
                  out2 += ") {  var err =   ";
                  if (it.createErrors !== false) {
                    out2 += " { keyword: 'required' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { missingProperty: '" + $missingProperty + "' } ";
                    if (it.opts.messages !== false) {
                      out2 += " , message: '";
                      if (it.opts._errorDataPathProperty) {
                        out2 += "is a required property";
                      } else {
                        out2 += "should have required property \\'" + $missingProperty + "\\'";
                      }
                      out2 += "' ";
                    }
                    if (it.opts.verbose) {
                      out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
                    }
                    out2 += " } ";
                  } else {
                    out2 += " {} ";
                  }
                  out2 += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ";
                }
              }
            }
          }
          it.errorPath = $currentErrorPath;
        } else if ($breakOnError) {
          out2 += " if (true) {";
        }
        return out2;
      };
    });
    require_uniqueItems2 = __commonJS2((exports2, module2) => {
      module2.exports = function generate_uniqueItems(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        if (($schema || $isData) && it.opts.uniqueItems !== false) {
          if ($isData) {
            out2 += " var " + $valid + "; if (" + $schemaValue + " === false || " + $schemaValue + " === undefined) " + $valid + " = true; else if (typeof " + $schemaValue + " != 'boolean') " + $valid + " = false; else { ";
          }
          out2 += " var i = " + $data + ".length , " + $valid + " = true , j; if (i > 1) { ";
          var $itemType = it.schema.items && it.schema.items.type, $typeIsArray = Array.isArray($itemType);
          if (!$itemType || $itemType == "object" || $itemType == "array" || $typeIsArray && ($itemType.indexOf("object") >= 0 || $itemType.indexOf("array") >= 0)) {
            out2 += " outer: for (;i--;) { for (j = i; j--;) { if (equal(" + $data + "[i], " + $data + "[j])) { " + $valid + " = false; break outer; } } } ";
          } else {
            out2 += " var itemIndices = {}, item; for (;i--;) { var item = " + $data + "[i]; ";
            var $method = "checkDataType" + ($typeIsArray ? "s" : "");
            out2 += " if (" + it.util[$method]($itemType, "item", it.opts.strictNumbers, true) + ") continue; ";
            if ($typeIsArray) {
              out2 += ` if (typeof item == 'string') item = '"' + item; `;
            }
            out2 += " if (typeof itemIndices[item] == 'number') { " + $valid + " = false; j = itemIndices[item]; break; } itemIndices[item] = i; } ";
          }
          out2 += " } ";
          if ($isData) {
            out2 += "  }  ";
          }
          out2 += " if (!" + $valid + ") {   ";
          var $$outStack = $$outStack || [];
          $$outStack.push(out2);
          out2 = "";
          if (it.createErrors !== false) {
            out2 += " { keyword: 'uniqueItems' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { i: i, j: j } ";
            if (it.opts.messages !== false) {
              out2 += " , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' ";
            }
            if (it.opts.verbose) {
              out2 += " , schema:  ";
              if ($isData) {
                out2 += "validate.schema" + $schemaPath;
              } else {
                out2 += "" + $schema;
              }
              out2 += "         , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out2 += " } ";
          } else {
            out2 += " {} ";
          }
          var __err = out2;
          out2 = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out2 += " throw new ValidationError([" + __err + "]); ";
            } else {
              out2 += " validate.errors = [" + __err + "]; return false; ";
            }
          } else {
            out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          }
          out2 += " } ";
          if ($breakOnError) {
            out2 += " else { ";
          }
        } else {
          if ($breakOnError) {
            out2 += " if (true) { ";
          }
        }
        return out2;
      };
    });
    require_dotjs = __commonJS2((exports2, module2) => {
      module2.exports = {
        $ref: require_ref2(),
        allOf: require_allOf2(),
        anyOf: require_anyOf2(),
        $comment: require_comment(),
        const: require_const2(),
        contains: require_contains2(),
        dependencies: require_dependencies2(),
        enum: require_enum2(),
        format: require_format3(),
        if: require_if2(),
        items: require_items2(),
        maximum: require__limit(),
        minimum: require__limit(),
        maxItems: require__limitItems(),
        minItems: require__limitItems(),
        maxLength: require__limitLength(),
        minLength: require__limitLength(),
        maxProperties: require__limitProperties(),
        minProperties: require__limitProperties(),
        multipleOf: require_multipleOf2(),
        not: require_not2(),
        oneOf: require_oneOf2(),
        pattern: require_pattern2(),
        properties: require_properties2(),
        propertyNames: require_propertyNames2(),
        required: require_required2(),
        uniqueItems: require_uniqueItems2(),
        validate: require_validate2()
      };
    });
    require_rules2 = __commonJS2((exports2, module2) => {
      var ruleModules = require_dotjs();
      var toHash = require_util2().toHash;
      module2.exports = function rules() {
        var RULES = [
          {
            type: "number",
            rules: [
              { maximum: ["exclusiveMaximum"] },
              { minimum: ["exclusiveMinimum"] },
              "multipleOf",
              "format"
            ]
          },
          {
            type: "string",
            rules: ["maxLength", "minLength", "pattern", "format"]
          },
          {
            type: "array",
            rules: ["maxItems", "minItems", "items", "contains", "uniqueItems"]
          },
          {
            type: "object",
            rules: [
              "maxProperties",
              "minProperties",
              "required",
              "dependencies",
              "propertyNames",
              { properties: ["additionalProperties", "patternProperties"] }
            ]
          },
          { rules: ["$ref", "const", "enum", "not", "anyOf", "oneOf", "allOf", "if"] }
        ];
        var ALL = ["type", "$comment"];
        var KEYWORDS = [
          "$schema",
          "$id",
          "id",
          "$data",
          "$async",
          "title",
          "description",
          "default",
          "definitions",
          "examples",
          "readOnly",
          "writeOnly",
          "contentMediaType",
          "contentEncoding",
          "additionalItems",
          "then",
          "else"
        ];
        var TYPES = ["number", "integer", "string", "array", "object", "boolean", "null"];
        RULES.all = toHash(ALL);
        RULES.types = toHash(TYPES);
        RULES.forEach(function(group) {
          group.rules = group.rules.map(function(keyword) {
            var implKeywords;
            if (typeof keyword == "object") {
              var key = Object.keys(keyword)[0];
              implKeywords = keyword[key];
              keyword = key;
              implKeywords.forEach(function(k) {
                ALL.push(k);
                RULES.all[k] = true;
              });
            }
            ALL.push(keyword);
            var rule = RULES.all[keyword] = {
              keyword,
              code: ruleModules[keyword],
              implements: implKeywords
            };
            return rule;
          });
          RULES.all.$comment = {
            keyword: "$comment",
            code: ruleModules.$comment
          };
          if (group.type)
            RULES.types[group.type] = group;
        });
        RULES.keywords = toHash(ALL.concat(KEYWORDS));
        RULES.custom = {};
        return RULES;
      };
    });
    require_data2 = __commonJS2((exports2, module2) => {
      var KEYWORDS = [
        "multipleOf",
        "maximum",
        "exclusiveMaximum",
        "minimum",
        "exclusiveMinimum",
        "maxLength",
        "minLength",
        "pattern",
        "additionalItems",
        "maxItems",
        "minItems",
        "uniqueItems",
        "maxProperties",
        "minProperties",
        "required",
        "additionalProperties",
        "enum",
        "format",
        "const"
      ];
      module2.exports = function(metaSchema, keywordsJsonPointers) {
        for (var i2 = 0; i2 < keywordsJsonPointers.length; i2++) {
          metaSchema = JSON.parse(JSON.stringify(metaSchema));
          var segments = keywordsJsonPointers[i2].split("/");
          var keywords = metaSchema;
          var j;
          for (j = 1; j < segments.length; j++)
            keywords = keywords[segments[j]];
          for (j = 0; j < KEYWORDS.length; j++) {
            var key = KEYWORDS[j];
            var schema = keywords[key];
            if (schema) {
              keywords[key] = {
                anyOf: [
                  schema,
                  { $ref: "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#" }
                ]
              };
            }
          }
        }
        return metaSchema;
      };
    });
    require_async = __commonJS2((exports2, module2) => {
      var MissingRefError = require_error_classes().MissingRef;
      module2.exports = compileAsync;
      function compileAsync(schema, meta, callback) {
        var self2 = this;
        if (typeof this._opts.loadSchema != "function")
          throw new Error("options.loadSchema should be a function");
        if (typeof meta == "function") {
          callback = meta;
          meta = void 0;
        }
        var p2 = loadMetaSchemaOf(schema).then(function() {
          var schemaObj = self2._addSchema(schema, void 0, meta);
          return schemaObj.validate || _compileAsync(schemaObj);
        });
        if (callback) {
          p2.then(function(v) {
            callback(null, v);
          }, callback);
        }
        return p2;
        function loadMetaSchemaOf(sch) {
          var $schema = sch.$schema;
          return $schema && !self2.getSchema($schema) ? compileAsync.call(self2, { $ref: $schema }, true) : Promise.resolve();
        }
        function _compileAsync(schemaObj) {
          try {
            return self2._compile(schemaObj);
          } catch (e) {
            if (e instanceof MissingRefError)
              return loadMissingSchema(e);
            throw e;
          }
          function loadMissingSchema(e) {
            var ref = e.missingSchema;
            if (added(ref))
              throw new Error("Schema " + ref + " is loaded but " + e.missingRef + " cannot be resolved");
            var schemaPromise = self2._loadingSchemas[ref];
            if (!schemaPromise) {
              schemaPromise = self2._loadingSchemas[ref] = self2._opts.loadSchema(ref);
              schemaPromise.then(removePromise, removePromise);
            }
            return schemaPromise.then(function(sch) {
              if (!added(ref)) {
                return loadMetaSchemaOf(sch).then(function() {
                  if (!added(ref))
                    self2.addSchema(sch, ref, void 0, meta);
                });
              }
            }).then(function() {
              return _compileAsync(schemaObj);
            });
            function removePromise() {
              delete self2._loadingSchemas[ref];
            }
            function added(ref2) {
              return self2._refs[ref2] || self2._schemas[ref2];
            }
          }
        }
      }
    });
    require_custom = __commonJS2((exports2, module2) => {
      module2.exports = function generate_custom(it, $keyword, $ruleType) {
        var out2 = " ";
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + "/" + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $errorKeyword;
        var $data = "data" + ($dataLvl || "");
        var $valid = "valid" + $lvl;
        var $errs = "errs__" + $lvl;
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
          out2 += " var schema" + $lvl + " = " + it.util.getData($schema.$data, $dataLvl, it.dataPathArr) + "; ";
          $schemaValue = "schema" + $lvl;
        } else {
          $schemaValue = $schema;
        }
        var $rule = this, $definition = "definition" + $lvl, $rDef = $rule.definition, $closingBraces = "";
        var $compile, $inline, $macro, $ruleValidate, $validateCode;
        if ($isData && $rDef.$data) {
          $validateCode = "keywordValidate" + $lvl;
          var $validateSchema = $rDef.validateSchema;
          out2 += " var " + $definition + " = RULES.custom['" + $keyword + "'].definition; var " + $validateCode + " = " + $definition + ".validate;";
        } else {
          $ruleValidate = it.useCustomRule($rule, $schema, it.schema, it);
          if (!$ruleValidate)
            return;
          $schemaValue = "validate.schema" + $schemaPath;
          $validateCode = $ruleValidate.code;
          $compile = $rDef.compile;
          $inline = $rDef.inline;
          $macro = $rDef.macro;
        }
        var $ruleErrs = $validateCode + ".errors", $i = "i" + $lvl, $ruleErr = "ruleErr" + $lvl, $asyncKeyword = $rDef.async;
        if ($asyncKeyword && !it.async)
          throw new Error("async keyword in sync schema");
        if (!($inline || $macro)) {
          out2 += "" + $ruleErrs + " = null;";
        }
        out2 += "var " + $errs + " = errors;var " + $valid + ";";
        if ($isData && $rDef.$data) {
          $closingBraces += "}";
          out2 += " if (" + $schemaValue + " === undefined) { " + $valid + " = true; } else { ";
          if ($validateSchema) {
            $closingBraces += "}";
            out2 += " " + $valid + " = " + $definition + ".validateSchema(" + $schemaValue + "); if (" + $valid + ") { ";
          }
        }
        if ($inline) {
          if ($rDef.statements) {
            out2 += " " + $ruleValidate.validate + " ";
          } else {
            out2 += " " + $valid + " = " + $ruleValidate.validate + "; ";
          }
        } else if ($macro) {
          var $it = it.util.copy(it);
          var $closingBraces = "";
          $it.level++;
          var $nextValid = "valid" + $it.level;
          $it.schema = $ruleValidate.validate;
          $it.schemaPath = "";
          var $wasComposite = it.compositeRule;
          it.compositeRule = $it.compositeRule = true;
          var $code = it.validate($it).replace(/validate\.schema/g, $validateCode);
          it.compositeRule = $it.compositeRule = $wasComposite;
          out2 += " " + $code;
        } else {
          var $$outStack = $$outStack || [];
          $$outStack.push(out2);
          out2 = "";
          out2 += "  " + $validateCode + ".call( ";
          if (it.opts.passContext) {
            out2 += "this";
          } else {
            out2 += "self";
          }
          if ($compile || $rDef.schema === false) {
            out2 += " , " + $data + " ";
          } else {
            out2 += " , " + $schemaValue + " , " + $data + " , validate.schema" + it.schemaPath + " ";
          }
          out2 += " , (dataPath || '')";
          if (it.errorPath != '""') {
            out2 += " + " + it.errorPath;
          }
          var $parentData = $dataLvl ? "data" + ($dataLvl - 1 || "") : "parentData", $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : "parentDataProperty";
          out2 += " , " + $parentData + " , " + $parentDataProperty + " , rootData )  ";
          var def_callRuleValidate = out2;
          out2 = $$outStack.pop();
          if ($rDef.errors === false) {
            out2 += " " + $valid + " = ";
            if ($asyncKeyword) {
              out2 += "await ";
            }
            out2 += "" + def_callRuleValidate + "; ";
          } else {
            if ($asyncKeyword) {
              $ruleErrs = "customErrors" + $lvl;
              out2 += " var " + $ruleErrs + " = null; try { " + $valid + " = await " + def_callRuleValidate + "; } catch (e) { " + $valid + " = false; if (e instanceof ValidationError) " + $ruleErrs + " = e.errors; else throw e; } ";
            } else {
              out2 += " " + $ruleErrs + " = null; " + $valid + " = " + def_callRuleValidate + "; ";
            }
          }
        }
        if ($rDef.modifying) {
          out2 += " if (" + $parentData + ") " + $data + " = " + $parentData + "[" + $parentDataProperty + "];";
        }
        out2 += "" + $closingBraces;
        if ($rDef.valid) {
          if ($breakOnError) {
            out2 += " if (true) { ";
          }
        } else {
          out2 += " if ( ";
          if ($rDef.valid === void 0) {
            out2 += " !";
            if ($macro) {
              out2 += "" + $nextValid;
            } else {
              out2 += "" + $valid;
            }
          } else {
            out2 += " " + !$rDef.valid + " ";
          }
          out2 += ") { ";
          $errorKeyword = $rule.keyword;
          var $$outStack = $$outStack || [];
          $$outStack.push(out2);
          out2 = "";
          var $$outStack = $$outStack || [];
          $$outStack.push(out2);
          out2 = "";
          if (it.createErrors !== false) {
            out2 += " { keyword: '" + ($errorKeyword || "custom") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { keyword: '" + $rule.keyword + "' } ";
            if (it.opts.messages !== false) {
              out2 += ` , message: 'should pass "` + $rule.keyword + `" keyword validation' `;
            }
            if (it.opts.verbose) {
              out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
            }
            out2 += " } ";
          } else {
            out2 += " {} ";
          }
          var __err = out2;
          out2 = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            if (it.async) {
              out2 += " throw new ValidationError([" + __err + "]); ";
            } else {
              out2 += " validate.errors = [" + __err + "]; return false; ";
            }
          } else {
            out2 += " var err = " + __err + ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
          }
          var def_customError = out2;
          out2 = $$outStack.pop();
          if ($inline) {
            if ($rDef.errors) {
              if ($rDef.errors != "full") {
                out2 += "  for (var " + $i + "=" + $errs + "; " + $i + "<errors; " + $i + "++) { var " + $ruleErr + " = vErrors[" + $i + "]; if (" + $ruleErr + ".dataPath === undefined) " + $ruleErr + ".dataPath = (dataPath || '') + " + it.errorPath + "; if (" + $ruleErr + ".schemaPath === undefined) { " + $ruleErr + '.schemaPath = "' + $errSchemaPath + '"; } ';
                if (it.opts.verbose) {
                  out2 += " " + $ruleErr + ".schema = " + $schemaValue + "; " + $ruleErr + ".data = " + $data + "; ";
                }
                out2 += " } ";
              }
            } else {
              if ($rDef.errors === false) {
                out2 += " " + def_customError + " ";
              } else {
                out2 += " if (" + $errs + " == errors) { " + def_customError + " } else {  for (var " + $i + "=" + $errs + "; " + $i + "<errors; " + $i + "++) { var " + $ruleErr + " = vErrors[" + $i + "]; if (" + $ruleErr + ".dataPath === undefined) " + $ruleErr + ".dataPath = (dataPath || '') + " + it.errorPath + "; if (" + $ruleErr + ".schemaPath === undefined) { " + $ruleErr + '.schemaPath = "' + $errSchemaPath + '"; } ';
                if (it.opts.verbose) {
                  out2 += " " + $ruleErr + ".schema = " + $schemaValue + "; " + $ruleErr + ".data = " + $data + "; ";
                }
                out2 += " } } ";
              }
            }
          } else if ($macro) {
            out2 += "   var err =   ";
            if (it.createErrors !== false) {
              out2 += " { keyword: '" + ($errorKeyword || "custom") + "' , dataPath: (dataPath || '') + " + it.errorPath + " , schemaPath: " + it.util.toQuotedString($errSchemaPath) + " , params: { keyword: '" + $rule.keyword + "' } ";
              if (it.opts.messages !== false) {
                out2 += ` , message: 'should pass "` + $rule.keyword + `" keyword validation' `;
              }
              if (it.opts.verbose) {
                out2 += " , schema: validate.schema" + $schemaPath + " , parentSchema: validate.schema" + it.schemaPath + " , data: " + $data + " ";
              }
              out2 += " } ";
            } else {
              out2 += " {} ";
            }
            out2 += ";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
            if (!it.compositeRule && $breakOnError) {
              if (it.async) {
                out2 += " throw new ValidationError(vErrors); ";
              } else {
                out2 += " validate.errors = vErrors; return false; ";
              }
            }
          } else {
            if ($rDef.errors === false) {
              out2 += " " + def_customError + " ";
            } else {
              out2 += " if (Array.isArray(" + $ruleErrs + ")) { if (vErrors === null) vErrors = " + $ruleErrs + "; else vErrors = vErrors.concat(" + $ruleErrs + "); errors = vErrors.length;  for (var " + $i + "=" + $errs + "; " + $i + "<errors; " + $i + "++) { var " + $ruleErr + " = vErrors[" + $i + "]; if (" + $ruleErr + ".dataPath === undefined) " + $ruleErr + ".dataPath = (dataPath || '') + " + it.errorPath + ";  " + $ruleErr + '.schemaPath = "' + $errSchemaPath + '";  ';
              if (it.opts.verbose) {
                out2 += " " + $ruleErr + ".schema = " + $schemaValue + "; " + $ruleErr + ".data = " + $data + "; ";
              }
              out2 += " } } else { " + def_customError + " } ";
            }
          }
          out2 += " } ";
          if ($breakOnError) {
            out2 += " else { ";
          }
        }
        return out2;
      };
    });
    require_json_schema_draft_072 = __commonJS2((exports2, module2) => {
      module2.exports = {
        $schema: "http://json-schema.org/draft-07/schema#",
        $id: "http://json-schema.org/draft-07/schema#",
        title: "Core schema meta-schema",
        definitions: {
          schemaArray: {
            type: "array",
            minItems: 1,
            items: { $ref: "#" }
          },
          nonNegativeInteger: {
            type: "integer",
            minimum: 0
          },
          nonNegativeIntegerDefault0: {
            allOf: [
              { $ref: "#/definitions/nonNegativeInteger" },
              { default: 0 }
            ]
          },
          simpleTypes: {
            enum: [
              "array",
              "boolean",
              "integer",
              "null",
              "number",
              "object",
              "string"
            ]
          },
          stringArray: {
            type: "array",
            items: { type: "string" },
            uniqueItems: true,
            default: []
          }
        },
        type: ["object", "boolean"],
        properties: {
          $id: {
            type: "string",
            format: "uri-reference"
          },
          $schema: {
            type: "string",
            format: "uri"
          },
          $ref: {
            type: "string",
            format: "uri-reference"
          },
          $comment: {
            type: "string"
          },
          title: {
            type: "string"
          },
          description: {
            type: "string"
          },
          default: true,
          readOnly: {
            type: "boolean",
            default: false
          },
          examples: {
            type: "array",
            items: true
          },
          multipleOf: {
            type: "number",
            exclusiveMinimum: 0
          },
          maximum: {
            type: "number"
          },
          exclusiveMaximum: {
            type: "number"
          },
          minimum: {
            type: "number"
          },
          exclusiveMinimum: {
            type: "number"
          },
          maxLength: { $ref: "#/definitions/nonNegativeInteger" },
          minLength: { $ref: "#/definitions/nonNegativeIntegerDefault0" },
          pattern: {
            type: "string",
            format: "regex"
          },
          additionalItems: { $ref: "#" },
          items: {
            anyOf: [
              { $ref: "#" },
              { $ref: "#/definitions/schemaArray" }
            ],
            default: true
          },
          maxItems: { $ref: "#/definitions/nonNegativeInteger" },
          minItems: { $ref: "#/definitions/nonNegativeIntegerDefault0" },
          uniqueItems: {
            type: "boolean",
            default: false
          },
          contains: { $ref: "#" },
          maxProperties: { $ref: "#/definitions/nonNegativeInteger" },
          minProperties: { $ref: "#/definitions/nonNegativeIntegerDefault0" },
          required: { $ref: "#/definitions/stringArray" },
          additionalProperties: { $ref: "#" },
          definitions: {
            type: "object",
            additionalProperties: { $ref: "#" },
            default: {}
          },
          properties: {
            type: "object",
            additionalProperties: { $ref: "#" },
            default: {}
          },
          patternProperties: {
            type: "object",
            additionalProperties: { $ref: "#" },
            propertyNames: { format: "regex" },
            default: {}
          },
          dependencies: {
            type: "object",
            additionalProperties: {
              anyOf: [
                { $ref: "#" },
                { $ref: "#/definitions/stringArray" }
              ]
            }
          },
          propertyNames: { $ref: "#" },
          const: true,
          enum: {
            type: "array",
            items: true,
            minItems: 1,
            uniqueItems: true
          },
          type: {
            anyOf: [
              { $ref: "#/definitions/simpleTypes" },
              {
                type: "array",
                items: { $ref: "#/definitions/simpleTypes" },
                minItems: 1,
                uniqueItems: true
              }
            ]
          },
          format: { type: "string" },
          contentMediaType: { type: "string" },
          contentEncoding: { type: "string" },
          if: { $ref: "#" },
          then: { $ref: "#" },
          else: { $ref: "#" },
          allOf: { $ref: "#/definitions/schemaArray" },
          anyOf: { $ref: "#/definitions/schemaArray" },
          oneOf: { $ref: "#/definitions/schemaArray" },
          not: { $ref: "#" }
        },
        default: true
      };
    });
    require_definition_schema = __commonJS2((exports2, module2) => {
      var metaSchema = require_json_schema_draft_072();
      module2.exports = {
        $id: "https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js",
        definitions: {
          simpleTypes: metaSchema.definitions.simpleTypes
        },
        type: "object",
        dependencies: {
          schema: ["validate"],
          $data: ["validate"],
          statements: ["inline"],
          valid: { not: { required: ["macro"] } }
        },
        properties: {
          type: metaSchema.properties.type,
          schema: { type: "boolean" },
          statements: { type: "boolean" },
          dependencies: {
            type: "array",
            items: { type: "string" }
          },
          metaSchema: { type: "object" },
          modifying: { type: "boolean" },
          valid: { type: "boolean" },
          $data: { type: "boolean" },
          async: { type: "boolean" },
          errors: {
            anyOf: [
              { type: "boolean" },
              { const: "full" }
            ]
          }
        }
      };
    });
    require_keyword2 = __commonJS2((exports2, module2) => {
      var IDENTIFIER = /^[a-z_$][a-z0-9_$-]*$/i;
      var customRuleCode = require_custom();
      var definitionSchema = require_definition_schema();
      module2.exports = {
        add: addKeyword,
        get: getKeyword,
        remove: removeKeyword,
        validate: validateKeyword
      };
      function addKeyword(keyword, definition) {
        var RULES = this.RULES;
        if (RULES.keywords[keyword])
          throw new Error("Keyword " + keyword + " is already defined");
        if (!IDENTIFIER.test(keyword))
          throw new Error("Keyword " + keyword + " is not a valid identifier");
        if (definition) {
          this.validateKeyword(definition, true);
          var dataType = definition.type;
          if (Array.isArray(dataType)) {
            for (var i2 = 0; i2 < dataType.length; i2++)
              _addRule(keyword, dataType[i2], definition);
          } else {
            _addRule(keyword, dataType, definition);
          }
          var metaSchema = definition.metaSchema;
          if (metaSchema) {
            if (definition.$data && this._opts.$data) {
              metaSchema = {
                anyOf: [
                  metaSchema,
                  { $ref: "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#" }
                ]
              };
            }
            definition.validateSchema = this.compile(metaSchema, true);
          }
        }
        RULES.keywords[keyword] = RULES.all[keyword] = true;
        function _addRule(keyword2, dataType2, definition2) {
          var ruleGroup;
          for (var i22 = 0; i22 < RULES.length; i22++) {
            var rg = RULES[i22];
            if (rg.type == dataType2) {
              ruleGroup = rg;
              break;
            }
          }
          if (!ruleGroup) {
            ruleGroup = { type: dataType2, rules: [] };
            RULES.push(ruleGroup);
          }
          var rule = {
            keyword: keyword2,
            definition: definition2,
            custom: true,
            code: customRuleCode,
            implements: definition2.implements
          };
          ruleGroup.rules.push(rule);
          RULES.custom[keyword2] = rule;
        }
        return this;
      }
      function getKeyword(keyword) {
        var rule = this.RULES.custom[keyword];
        return rule ? rule.definition : this.RULES.keywords[keyword] || false;
      }
      function removeKeyword(keyword) {
        var RULES = this.RULES;
        delete RULES.keywords[keyword];
        delete RULES.all[keyword];
        delete RULES.custom[keyword];
        for (var i2 = 0; i2 < RULES.length; i2++) {
          var rules = RULES[i2].rules;
          for (var j = 0; j < rules.length; j++) {
            if (rules[j].keyword == keyword) {
              rules.splice(j, 1);
              break;
            }
          }
        }
        return this;
      }
      function validateKeyword(definition, throwError2) {
        validateKeyword.errors = null;
        var v = this._validateKeyword = this._validateKeyword || this.compile(definitionSchema, true);
        if (v(definition))
          return true;
        validateKeyword.errors = v.errors;
        if (throwError2)
          throw new Error("custom keyword definition is invalid: " + this.errorsText(v.errors));
        else
          return false;
      }
    });
    require_data22 = __commonJS2((exports2, module2) => {
      module2.exports = {
        $schema: "http://json-schema.org/draft-07/schema#",
        $id: "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#",
        description: "Meta-schema for $data reference (JSON Schema extension proposal)",
        type: "object",
        required: ["$data"],
        properties: {
          $data: {
            type: "string",
            anyOf: [
              { format: "relative-json-pointer" },
              { format: "json-pointer" }
            ]
          }
        },
        additionalProperties: false
      };
    });
    require_ajv2 = __commonJS2((exports2, module2) => {
      var compileSchema = require_compile2();
      var resolve3 = require_resolve2();
      var Cache2 = require_cache();
      var SchemaObject = require_schema_obj();
      var stableStringify = require_fast_json_stable_stringify();
      var formats = require_formats();
      var rules = require_rules2();
      var $dataMetaSchema = require_data2();
      var util32 = require_util2();
      module2.exports = Ajv3;
      Ajv3.prototype.validate = validate;
      Ajv3.prototype.compile = compile2;
      Ajv3.prototype.addSchema = addSchema;
      Ajv3.prototype.addMetaSchema = addMetaSchema;
      Ajv3.prototype.validateSchema = validateSchema;
      Ajv3.prototype.getSchema = getSchema;
      Ajv3.prototype.removeSchema = removeSchema;
      Ajv3.prototype.addFormat = addFormat2;
      Ajv3.prototype.errorsText = errorsText;
      Ajv3.prototype._addSchema = _addSchema;
      Ajv3.prototype._compile = _compile;
      Ajv3.prototype.compileAsync = require_async();
      var customKeyword = require_keyword2();
      Ajv3.prototype.addKeyword = customKeyword.add;
      Ajv3.prototype.getKeyword = customKeyword.get;
      Ajv3.prototype.removeKeyword = customKeyword.remove;
      Ajv3.prototype.validateKeyword = customKeyword.validate;
      var errorClasses = require_error_classes();
      Ajv3.ValidationError = errorClasses.Validation;
      Ajv3.MissingRefError = errorClasses.MissingRef;
      Ajv3.$dataMetaSchema = $dataMetaSchema;
      var META_SCHEMA_ID = "http://json-schema.org/draft-07/schema";
      var META_IGNORE_OPTIONS = ["removeAdditional", "useDefaults", "coerceTypes", "strictDefaults"];
      var META_SUPPORT_DATA = ["/properties"];
      function Ajv3(opts) {
        if (!(this instanceof Ajv3))
          return new Ajv3(opts);
        opts = this._opts = util32.copy(opts) || {};
        setLogger(this);
        this._schemas = {};
        this._refs = {};
        this._fragments = {};
        this._formats = formats(opts.format);
        this._cache = opts.cache || new Cache2();
        this._loadingSchemas = {};
        this._compilations = [];
        this.RULES = rules();
        this._getId = chooseGetId(opts);
        opts.loopRequired = opts.loopRequired || Infinity;
        if (opts.errorDataPath == "property")
          opts._errorDataPathProperty = true;
        if (opts.serialize === void 0)
          opts.serialize = stableStringify;
        this._metaOpts = getMetaSchemaOptions(this);
        if (opts.formats)
          addInitialFormats(this);
        if (opts.keywords)
          addInitialKeywords(this);
        addDefaultMetaSchema(this);
        if (typeof opts.meta == "object")
          this.addMetaSchema(opts.meta);
        if (opts.nullable)
          this.addKeyword("nullable", { metaSchema: { type: "boolean" } });
        addInitialSchemas(this);
      }
      function validate(schemaKeyRef, data) {
        var v;
        if (typeof schemaKeyRef == "string") {
          v = this.getSchema(schemaKeyRef);
          if (!v)
            throw new Error('no schema with key or ref "' + schemaKeyRef + '"');
        } else {
          var schemaObj = this._addSchema(schemaKeyRef);
          v = schemaObj.validate || this._compile(schemaObj);
        }
        var valid = v(data);
        if (v.$async !== true)
          this.errors = v.errors;
        return valid;
      }
      function compile2(schema, _meta) {
        var schemaObj = this._addSchema(schema, void 0, _meta);
        return schemaObj.validate || this._compile(schemaObj);
      }
      function addSchema(schema, key, _skipValidation, _meta) {
        if (Array.isArray(schema)) {
          for (var i2 = 0; i2 < schema.length; i2++)
            this.addSchema(schema[i2], void 0, _skipValidation, _meta);
          return this;
        }
        var id2 = this._getId(schema);
        if (id2 !== void 0 && typeof id2 != "string")
          throw new Error("schema id must be string");
        key = resolve3.normalizeId(key || id2);
        checkUnique(this, key);
        this._schemas[key] = this._addSchema(schema, _skipValidation, _meta, true);
        return this;
      }
      function addMetaSchema(schema, key, skipValidation) {
        this.addSchema(schema, key, skipValidation, true);
        return this;
      }
      function validateSchema(schema, throwOrLogError) {
        var $schema = schema.$schema;
        if ($schema !== void 0 && typeof $schema != "string")
          throw new Error("$schema must be a string");
        $schema = $schema || this._opts.defaultMeta || defaultMeta(this);
        if (!$schema) {
          this.logger.warn("meta-schema not available");
          this.errors = null;
          return true;
        }
        var valid = this.validate($schema, schema);
        if (!valid && throwOrLogError) {
          var message = "schema is invalid: " + this.errorsText();
          if (this._opts.validateSchema == "log")
            this.logger.error(message);
          else
            throw new Error(message);
        }
        return valid;
      }
      function defaultMeta(self2) {
        var meta = self2._opts.meta;
        self2._opts.defaultMeta = typeof meta == "object" ? self2._getId(meta) || meta : self2.getSchema(META_SCHEMA_ID) ? META_SCHEMA_ID : void 0;
        return self2._opts.defaultMeta;
      }
      function getSchema(keyRef) {
        var schemaObj = _getSchemaObj(this, keyRef);
        switch (typeof schemaObj) {
          case "object":
            return schemaObj.validate || this._compile(schemaObj);
          case "string":
            return this.getSchema(schemaObj);
          case "undefined":
            return _getSchemaFragment(this, keyRef);
        }
      }
      function _getSchemaFragment(self2, ref) {
        var res = resolve3.schema.call(self2, { schema: {} }, ref);
        if (res) {
          var { schema, root, baseId } = res;
          var v = compileSchema.call(self2, schema, root, void 0, baseId);
          self2._fragments[ref] = new SchemaObject({
            ref,
            fragment: true,
            schema,
            root,
            baseId,
            validate: v
          });
          return v;
        }
      }
      function _getSchemaObj(self2, keyRef) {
        keyRef = resolve3.normalizeId(keyRef);
        return self2._schemas[keyRef] || self2._refs[keyRef] || self2._fragments[keyRef];
      }
      function removeSchema(schemaKeyRef) {
        if (schemaKeyRef instanceof RegExp) {
          _removeAllSchemas(this, this._schemas, schemaKeyRef);
          _removeAllSchemas(this, this._refs, schemaKeyRef);
          return this;
        }
        switch (typeof schemaKeyRef) {
          case "undefined":
            _removeAllSchemas(this, this._schemas);
            _removeAllSchemas(this, this._refs);
            this._cache.clear();
            return this;
          case "string":
            var schemaObj = _getSchemaObj(this, schemaKeyRef);
            if (schemaObj)
              this._cache.del(schemaObj.cacheKey);
            delete this._schemas[schemaKeyRef];
            delete this._refs[schemaKeyRef];
            return this;
          case "object":
            var serialize2 = this._opts.serialize;
            var cacheKey = serialize2 ? serialize2(schemaKeyRef) : schemaKeyRef;
            this._cache.del(cacheKey);
            var id2 = this._getId(schemaKeyRef);
            if (id2) {
              id2 = resolve3.normalizeId(id2);
              delete this._schemas[id2];
              delete this._refs[id2];
            }
        }
        return this;
      }
      function _removeAllSchemas(self2, schemas, regex) {
        for (var keyRef in schemas) {
          var schemaObj = schemas[keyRef];
          if (!schemaObj.meta && (!regex || regex.test(keyRef))) {
            self2._cache.del(schemaObj.cacheKey);
            delete schemas[keyRef];
          }
        }
      }
      function _addSchema(schema, skipValidation, meta, shouldAddSchema) {
        if (typeof schema != "object" && typeof schema != "boolean")
          throw new Error("schema should be object or boolean");
        var serialize2 = this._opts.serialize;
        var cacheKey = serialize2 ? serialize2(schema) : schema;
        var cached = this._cache.get(cacheKey);
        if (cached)
          return cached;
        shouldAddSchema = shouldAddSchema || this._opts.addUsedSchema !== false;
        var id2 = resolve3.normalizeId(this._getId(schema));
        if (id2 && shouldAddSchema)
          checkUnique(this, id2);
        var willValidate = this._opts.validateSchema !== false && !skipValidation;
        var recursiveMeta;
        if (willValidate && !(recursiveMeta = id2 && id2 == resolve3.normalizeId(schema.$schema)))
          this.validateSchema(schema, true);
        var localRefs = resolve3.ids.call(this, schema);
        var schemaObj = new SchemaObject({
          id: id2,
          schema,
          localRefs,
          cacheKey,
          meta
        });
        if (id2[0] != "#" && shouldAddSchema)
          this._refs[id2] = schemaObj;
        this._cache.put(cacheKey, schemaObj);
        if (willValidate && recursiveMeta)
          this.validateSchema(schema, true);
        return schemaObj;
      }
      function _compile(schemaObj, root) {
        if (schemaObj.compiling) {
          schemaObj.validate = callValidate;
          callValidate.schema = schemaObj.schema;
          callValidate.errors = null;
          callValidate.root = root ? root : callValidate;
          if (schemaObj.schema.$async === true)
            callValidate.$async = true;
          return callValidate;
        }
        schemaObj.compiling = true;
        var currentOpts;
        if (schemaObj.meta) {
          currentOpts = this._opts;
          this._opts = this._metaOpts;
        }
        var v;
        try {
          v = compileSchema.call(this, schemaObj.schema, root, schemaObj.localRefs);
        } catch (e) {
          delete schemaObj.validate;
          throw e;
        } finally {
          schemaObj.compiling = false;
          if (schemaObj.meta)
            this._opts = currentOpts;
        }
        schemaObj.validate = v;
        schemaObj.refs = v.refs;
        schemaObj.refVal = v.refVal;
        schemaObj.root = v.root;
        return v;
        function callValidate() {
          var _validate = schemaObj.validate;
          var result = _validate.apply(this, arguments);
          callValidate.errors = _validate.errors;
          return result;
        }
      }
      function chooseGetId(opts) {
        switch (opts.schemaId) {
          case "auto":
            return _get$IdOrId;
          case "id":
            return _getId;
          default:
            return _get$Id;
        }
      }
      function _getId(schema) {
        if (schema.$id)
          this.logger.warn("schema $id ignored", schema.$id);
        return schema.id;
      }
      function _get$Id(schema) {
        if (schema.id)
          this.logger.warn("schema id ignored", schema.id);
        return schema.$id;
      }
      function _get$IdOrId(schema) {
        if (schema.$id && schema.id && schema.$id != schema.id)
          throw new Error("schema $id is different from id");
        return schema.$id || schema.id;
      }
      function errorsText(errors2, options) {
        errors2 = errors2 || this.errors;
        if (!errors2)
          return "No errors";
        options = options || {};
        var separator = options.separator === void 0 ? ", " : options.separator;
        var dataVar = options.dataVar === void 0 ? "data" : options.dataVar;
        var text3 = "";
        for (var i2 = 0; i2 < errors2.length; i2++) {
          var e = errors2[i2];
          if (e)
            text3 += dataVar + e.dataPath + " " + e.message + separator;
        }
        return text3.slice(0, -separator.length);
      }
      function addFormat2(name3, format4) {
        if (typeof format4 == "string")
          format4 = new RegExp(format4);
        this._formats[name3] = format4;
        return this;
      }
      function addDefaultMetaSchema(self2) {
        var $dataSchema;
        if (self2._opts.$data) {
          $dataSchema = require_data22();
          self2.addMetaSchema($dataSchema, $dataSchema.$id, true);
        }
        if (self2._opts.meta === false)
          return;
        var metaSchema = require_json_schema_draft_072();
        if (self2._opts.$data)
          metaSchema = $dataMetaSchema(metaSchema, META_SUPPORT_DATA);
        self2.addMetaSchema(metaSchema, META_SCHEMA_ID, true);
        self2._refs["http://json-schema.org/schema"] = META_SCHEMA_ID;
      }
      function addInitialSchemas(self2) {
        var optsSchemas = self2._opts.schemas;
        if (!optsSchemas)
          return;
        if (Array.isArray(optsSchemas))
          self2.addSchema(optsSchemas);
        else
          for (var key in optsSchemas)
            self2.addSchema(optsSchemas[key], key);
      }
      function addInitialFormats(self2) {
        for (var name3 in self2._opts.formats) {
          var format4 = self2._opts.formats[name3];
          self2.addFormat(name3, format4);
        }
      }
      function addInitialKeywords(self2) {
        for (var name3 in self2._opts.keywords) {
          var keyword = self2._opts.keywords[name3];
          self2.addKeyword(name3, keyword);
        }
      }
      function checkUnique(self2, id2) {
        if (self2._schemas[id2] || self2._refs[id2])
          throw new Error('schema with key or id "' + id2 + '" already exists');
      }
      function getMetaSchemaOptions(self2) {
        var metaOpts = util32.copy(self2._opts);
        for (var i2 = 0; i2 < META_IGNORE_OPTIONS.length; i2++)
          delete metaOpts[META_IGNORE_OPTIONS[i2]];
        return metaOpts;
      }
      function setLogger(self2) {
        var logger = self2._opts.logger;
        if (logger === false) {
          self2.logger = { log: noop3, warn: noop3, error: noop3 };
        } else {
          if (logger === void 0)
            logger = console;
          if (!(typeof logger == "object" && logger.log && logger.warn && logger.error))
            throw new Error("logger must implement log, warn and error methods");
          self2.logger = logger;
        }
      }
      function noop3() {
      }
    });
    DEFAULT_MAX_LISTENERS = 50;
    NodeFsOperations = {
      cwd() {
        return process.cwd();
      },
      existsSync(fsPath) {
        return fs2.existsSync(fsPath);
      },
      async stat(fsPath) {
        return (0, import_promises.stat)(fsPath);
      },
      statSync(fsPath) {
        return fs2.statSync(fsPath);
      },
      readFileSync(fsPath, options) {
        return fs2.readFileSync(fsPath, { encoding: options.encoding });
      },
      readFileBytesSync(fsPath) {
        return fs2.readFileSync(fsPath);
      },
      readSync(fsPath, options) {
        let fd = void 0;
        try {
          fd = fs2.openSync(fsPath, "r");
          const buffer = Buffer.alloc(options.length);
          const bytesRead = fs2.readSync(fd, buffer, 0, options.length, 0);
          return { buffer, bytesRead };
        } finally {
          if (fd)
            fs2.closeSync(fd);
        }
      },
      writeFileSync(fsPath, data, options) {
        if (!options.flush) {
          const writeOptions = {
            encoding: options.encoding
          };
          if (options.mode !== void 0) {
            writeOptions.mode = options.mode;
          }
          fs2.writeFileSync(fsPath, data, writeOptions);
          return;
        }
        let fd;
        try {
          const mode = options.mode !== void 0 ? options.mode : void 0;
          fd = fs2.openSync(fsPath, "w", mode);
          fs2.writeFileSync(fd, data, { encoding: options.encoding });
          fs2.fsyncSync(fd);
        } finally {
          if (fd) {
            fs2.closeSync(fd);
          }
        }
      },
      appendFileSync(path15, data) {
        fs2.appendFileSync(path15, data);
      },
      copyFileSync(src, dest) {
        fs2.copyFileSync(src, dest);
      },
      unlinkSync(path15) {
        fs2.unlinkSync(path15);
      },
      renameSync(oldPath, newPath) {
        fs2.renameSync(oldPath, newPath);
      },
      linkSync(target, path15) {
        fs2.linkSync(target, path15);
      },
      symlinkSync(target, path15) {
        fs2.symlinkSync(target, path15);
      },
      readlinkSync(path15) {
        return fs2.readlinkSync(path15);
      },
      realpathSync(path15) {
        return fs2.realpathSync(path15);
      },
      mkdirSync(dirPath) {
        if (!fs2.existsSync(dirPath)) {
          fs2.mkdirSync(dirPath, { recursive: true, mode: 448 });
        }
      },
      readdirSync(dirPath) {
        return fs2.readdirSync(dirPath, { withFileTypes: true });
      },
      readdirStringSync(dirPath) {
        return fs2.readdirSync(dirPath);
      },
      isDirEmptySync(dirPath) {
        const files = this.readdirSync(dirPath);
        return files.length === 0;
      },
      rmdirSync(dirPath) {
        fs2.rmdirSync(dirPath);
      },
      rmSync(path15, options) {
        fs2.rmSync(path15, options);
      },
      createWriteStream(path15) {
        return fs2.createWriteStream(path15);
      }
    };
    activeFs = NodeFsOperations;
    AbortError = class extends Error {
    };
    ProcessTransport = class {
      options;
      child;
      childStdin;
      childStdout;
      ready = false;
      abortController;
      exitError;
      exitListeners = [];
      processExitHandler;
      abortHandler;
      constructor(options) {
        this.options = options;
        this.abortController = options.abortController || createAbortController();
        this.initialize();
      }
      initialize() {
        try {
          const {
            additionalDirectories = [],
            agents,
            cwd: cwd2,
            executable = isRunningWithBun() ? "bun" : "node",
            executableArgs = [],
            extraArgs = {},
            pathToClaudeCodeExecutable,
            env: env21 = { ...process.env },
            stderr,
            customSystemPrompt,
            appendSystemPrompt,
            maxThinkingTokens,
            maxTurns,
            model,
            fallbackModel,
            permissionMode,
            permissionPromptToolName,
            continueConversation,
            resume,
            settingSources,
            allowedTools = [],
            disallowedTools = [],
            mcpServers,
            strictMcpConfig,
            canUseTool,
            includePartialMessages
          } = this.options;
          const args2 = [
            "--output-format",
            "stream-json",
            "--verbose",
            "--input-format",
            "stream-json"
          ];
          if (typeof customSystemPrompt === "string")
            args2.push("--system-prompt", customSystemPrompt);
          if (appendSystemPrompt)
            args2.push("--append-system-prompt", appendSystemPrompt);
          if (maxThinkingTokens !== void 0) {
            args2.push("--max-thinking-tokens", maxThinkingTokens.toString());
          }
          if (maxTurns)
            args2.push("--max-turns", maxTurns.toString());
          if (model)
            args2.push("--model", model);
          if (env21.DEBUG)
            args2.push("--debug-to-stderr");
          if (canUseTool) {
            if (permissionPromptToolName) {
              throw new Error("canUseTool callback cannot be used with permissionPromptToolName. Please use one or the other.");
            }
            args2.push("--permission-prompt-tool", "stdio");
          } else if (permissionPromptToolName) {
            args2.push("--permission-prompt-tool", permissionPromptToolName);
          }
          if (continueConversation)
            args2.push("--continue");
          if (resume)
            args2.push("--resume", resume);
          if (allowedTools.length > 0) {
            args2.push("--allowedTools", allowedTools.join(","));
          }
          if (disallowedTools.length > 0) {
            args2.push("--disallowedTools", disallowedTools.join(","));
          }
          if (mcpServers && Object.keys(mcpServers).length > 0) {
            args2.push("--mcp-config", JSON.stringify({ mcpServers }));
          }
          if (agents && Object.keys(agents).length > 0) {
            args2.push("--agents", JSON.stringify(agents));
          }
          if (settingSources) {
            args2.push("--setting-sources", settingSources.join(","));
          }
          if (strictMcpConfig) {
            args2.push("--strict-mcp-config");
          }
          if (permissionMode) {
            args2.push("--permission-mode", permissionMode);
          }
          if (fallbackModel) {
            if (model && fallbackModel === model) {
              throw new Error("Fallback model cannot be the same as the main model. Please specify a different model for fallbackModel option.");
            }
            args2.push("--fallback-model", fallbackModel);
          }
          if (includePartialMessages) {
            args2.push("--include-partial-messages");
          }
          for (const dir of additionalDirectories) {
            args2.push("--add-dir", dir);
          }
          if (this.options.forkSession) {
            args2.push("--fork-session");
          }
          if (this.options.resumeSessionAt) {
            args2.push("--resume-session-at", this.options.resumeSessionAt);
          }
          for (const [flag, value] of Object.entries(extraArgs)) {
            if (value === null) {
              args2.push(`--${flag}`);
            } else {
              args2.push(`--${flag}`, value);
            }
          }
          if (!env21.CLAUDE_CODE_ENTRYPOINT) {
            env21.CLAUDE_CODE_ENTRYPOINT = "sdk-ts";
          }
          const fs22 = getFsImplementation();
          if (!fs22.existsSync(pathToClaudeCodeExecutable)) {
            const errorMessage = isNativeBinary(pathToClaudeCodeExecutable) ? `Claude Code native binary not found at ${pathToClaudeCodeExecutable}. Please ensure Claude Code is installed via native installer or specify a valid path with options.pathToClaudeCodeExecutable.` : `Claude Code executable not found at ${pathToClaudeCodeExecutable}. Is options.pathToClaudeCodeExecutable set?`;
            throw new ReferenceError(errorMessage);
          }
          const isNative2 = isNativeBinary(pathToClaudeCodeExecutable);
          const spawnCommand = isNative2 ? pathToClaudeCodeExecutable : executable;
          const spawnArgs = isNative2 ? args2 : [...executableArgs, pathToClaudeCodeExecutable, ...args2];
          this.logForDebugging(isNative2 ? `Spawning Claude Code native binary: ${pathToClaudeCodeExecutable} ${args2.join(" ")}` : `Spawning Claude Code process: ${executable} ${[...executableArgs, pathToClaudeCodeExecutable, ...args2].join(" ")}`);
          const stderrMode = env21.DEBUG || stderr ? "pipe" : "ignore";
          this.child = (0, import_child_process.spawn)(spawnCommand, spawnArgs, {
            cwd: cwd2,
            stdio: ["pipe", "pipe", stderrMode],
            signal: this.abortController.signal,
            env: env21
          });
          this.childStdin = this.child.stdin;
          this.childStdout = this.child.stdout;
          if (env21.DEBUG || stderr) {
            this.child.stderr.on("data", (data) => {
              this.logForDebugging(`Claude Code stderr: ${data.toString()}`);
              if (stderr) {
                stderr(data.toString());
              }
            });
          }
          const cleanup = () => {
            if (this.child && !this.child.killed) {
              this.child.kill("SIGTERM");
            }
          };
          this.processExitHandler = cleanup;
          this.abortHandler = cleanup;
          process.on("exit", this.processExitHandler);
          this.abortController.signal.addEventListener("abort", this.abortHandler);
          this.child.on("error", (error2) => {
            this.ready = false;
            if (this.abortController.signal.aborted) {
              this.exitError = new AbortError("Claude Code process aborted by user");
            } else {
              this.exitError = new Error(`Failed to spawn Claude Code process: ${error2.message}`);
              this.logForDebugging(this.exitError.message);
            }
          });
          this.child.on("close", (code3, signal) => {
            this.ready = false;
            if (this.abortController.signal.aborted) {
              this.exitError = new AbortError("Claude Code process aborted by user");
            } else {
              const error2 = this.getProcessExitError(code3, signal);
              if (error2) {
                this.exitError = error2;
                this.logForDebugging(error2.message);
              }
            }
          });
          this.ready = true;
        } catch (error2) {
          this.ready = false;
          throw error2;
        }
      }
      getProcessExitError(code3, signal) {
        if (code3 !== 0 && code3 !== null) {
          return new Error(`Claude Code process exited with code ${code3}`);
        } else if (signal) {
          return new Error(`Claude Code process terminated by signal ${signal}`);
        }
        return;
      }
      logForDebugging(message) {
        if (process.env.DEBUG) {
          process.stderr.write(`${message}
`);
        }
        if (this.options.stderr) {
          this.options.stderr(message);
        }
      }
      write(data) {
        if (this.abortController.signal.aborted) {
          throw new AbortError("Operation aborted");
        }
        if (!this.ready || !this.childStdin) {
          throw new Error("ProcessTransport is not ready for writing");
        }
        if (this.child?.killed || this.child?.exitCode !== null) {
          throw new Error("Cannot write to terminated process");
        }
        if (this.exitError) {
          throw new Error(`Cannot write to process that exited with error: ${this.exitError.message}`);
        }
        if (process.env.DEBUG_SDK) {
          process.stderr.write(`[ProcessTransport] Writing to stdin: ${data.substring(0, 100)}
`);
        }
        try {
          const written = this.childStdin.write(data);
          if (!written && process.env.DEBUG_SDK) {
            console.warn("[ProcessTransport] Write buffer full, data queued");
          }
        } catch (error2) {
          this.ready = false;
          throw new Error(`Failed to write to process stdin: ${error2.message}`);
        }
      }
      close() {
        if (this.childStdin) {
          this.childStdin.end();
          this.childStdin = void 0;
        }
        if (this.processExitHandler) {
          process.off("exit", this.processExitHandler);
          this.processExitHandler = void 0;
        }
        if (this.abortHandler) {
          this.abortController.signal.removeEventListener("abort", this.abortHandler);
          this.abortHandler = void 0;
        }
        for (const { handler } of this.exitListeners) {
          this.child?.off("exit", handler);
        }
        this.exitListeners = [];
        if (this.child && !this.child.killed) {
          this.child.kill("SIGTERM");
          setTimeout(() => {
            if (this.child && !this.child.killed) {
              this.child.kill("SIGKILL");
            }
          }, 5e3);
        }
        this.ready = false;
      }
      isReady() {
        return this.ready;
      }
      async *readMessages() {
        if (!this.childStdout) {
          throw new Error("ProcessTransport output stream not available");
        }
        const rl = (0, import_readline.createInterface)({ input: this.childStdout });
        try {
          for await (const line of rl) {
            if (line.trim()) {
              const message = JSON.parse(line);
              yield message;
            }
          }
          await this.waitForExit();
        } catch (error2) {
          throw error2;
        } finally {
          rl.close();
        }
      }
      endInput() {
        if (this.childStdin) {
          this.childStdin.end();
        }
      }
      getInputStream() {
        return this.childStdin;
      }
      onExit(callback) {
        if (!this.child)
          return () => {
          };
        const handler = (code3, signal) => {
          const error2 = this.getProcessExitError(code3, signal);
          callback(error2);
        };
        this.child.on("exit", handler);
        this.exitListeners.push({ callback, handler });
        return () => {
          if (this.child) {
            this.child.off("exit", handler);
          }
          const index = this.exitListeners.findIndex((l3) => l3.handler === handler);
          if (index !== -1) {
            this.exitListeners.splice(index, 1);
          }
        };
      }
      async waitForExit() {
        if (!this.child) {
          if (this.exitError) {
            throw this.exitError;
          }
          return;
        }
        if (this.child.exitCode !== null || this.child.killed) {
          if (this.exitError) {
            throw this.exitError;
          }
          return;
        }
        return new Promise((resolve3, reject) => {
          const exitHandler = (code3, signal) => {
            if (this.abortController.signal.aborted) {
              reject(new AbortError("Operation aborted"));
              return;
            }
            const error2 = this.getProcessExitError(code3, signal);
            if (error2) {
              reject(error2);
            } else {
              resolve3();
            }
          };
          this.child.once("exit", exitHandler);
          const errorHandler2 = (error2) => {
            this.child.off("exit", exitHandler);
            reject(error2);
          };
          this.child.once("error", errorHandler2);
          this.child.once("exit", () => {
            this.child.off("error", errorHandler2);
          });
        });
      }
    };
    Stream2 = class {
      returned;
      queue = [];
      readResolve;
      readReject;
      isDone = false;
      hasError;
      started = false;
      constructor(returned) {
        this.returned = returned;
      }
      [Symbol.asyncIterator]() {
        if (this.started) {
          throw new Error("Stream can only be iterated once");
        }
        this.started = true;
        return this;
      }
      next() {
        if (this.queue.length > 0) {
          return Promise.resolve({
            done: false,
            value: this.queue.shift()
          });
        }
        if (this.isDone) {
          return Promise.resolve({ done: true, value: void 0 });
        }
        if (this.hasError) {
          return Promise.reject(this.hasError);
        }
        return new Promise((resolve3, reject) => {
          this.readResolve = resolve3;
          this.readReject = reject;
        });
      }
      enqueue(value) {
        if (this.readResolve) {
          const resolve3 = this.readResolve;
          this.readResolve = void 0;
          this.readReject = void 0;
          resolve3({ done: false, value });
        } else {
          this.queue.push(value);
        }
      }
      done() {
        this.isDone = true;
        if (this.readResolve) {
          const resolve3 = this.readResolve;
          this.readResolve = void 0;
          this.readReject = void 0;
          resolve3({ done: true, value: void 0 });
        }
      }
      error(error2) {
        this.hasError = error2;
        if (this.readReject) {
          const reject = this.readReject;
          this.readResolve = void 0;
          this.readReject = void 0;
          reject(error2);
        }
      }
      return() {
        this.isDone = true;
        if (this.returned) {
          this.returned();
        }
        return Promise.resolve({ done: true, value: void 0 });
      }
    };
    SdkControlServerTransport = class {
      sendMcpMessage;
      isClosed = false;
      constructor(sendMcpMessage) {
        this.sendMcpMessage = sendMcpMessage;
      }
      onclose;
      onerror;
      onmessage;
      async start() {
      }
      async send(message) {
        if (this.isClosed) {
          throw new Error("Transport is closed");
        }
        this.sendMcpMessage(message);
      }
      async close() {
        if (this.isClosed) {
          return;
        }
        this.isClosed = true;
        this.onclose?.();
      }
    };
    Query2 = class {
      transport;
      isSingleUserTurn;
      canUseTool;
      hooks;
      abortController;
      pendingControlResponses = /* @__PURE__ */ new Map();
      cleanupPerformed = false;
      sdkMessages;
      inputStream = new Stream2();
      initialization;
      cancelControllers = /* @__PURE__ */ new Map();
      hookCallbacks = /* @__PURE__ */ new Map();
      nextCallbackId = 0;
      sdkMcpTransports = /* @__PURE__ */ new Map();
      pendingMcpResponses = /* @__PURE__ */ new Map();
      firstResultReceivedPromise;
      firstResultReceivedResolve;
      constructor(transport, isSingleUserTurn, canUseTool, hooks, abortController, sdkMcpServers = /* @__PURE__ */ new Map()) {
        this.transport = transport;
        this.isSingleUserTurn = isSingleUserTurn;
        this.canUseTool = canUseTool;
        this.hooks = hooks;
        this.abortController = abortController;
        for (const [name3, server] of sdkMcpServers) {
          const sdkTransport = new SdkControlServerTransport((message) => this.sendMcpServerMessageToCli(name3, message));
          this.sdkMcpTransports.set(name3, sdkTransport);
          server.connect(sdkTransport);
        }
        this.sdkMessages = this.readSdkMessages();
        this.firstResultReceivedPromise = new Promise((resolve3) => {
          this.firstResultReceivedResolve = resolve3;
        });
        this.readMessages();
        this.initialization = this.initialize();
        this.initialization.catch(() => {
        });
      }
      setError(error2) {
        this.inputStream.error(error2);
      }
      cleanup(error2) {
        if (this.cleanupPerformed)
          return;
        this.cleanupPerformed = true;
        try {
          this.transport.close();
          this.pendingControlResponses.clear();
          this.pendingMcpResponses.clear();
          if (error2) {
            this.inputStream.error(error2);
          } else {
            this.inputStream.done();
          }
        } catch (_error) {
        }
      }
      next(...[value]) {
        return this.sdkMessages.next(...[value]);
      }
      return(value) {
        return this.sdkMessages.return(value);
      }
      throw(e) {
        return this.sdkMessages.throw(e);
      }
      [Symbol.asyncIterator]() {
        return this.sdkMessages;
      }
      [Symbol.asyncDispose]() {
        return this.sdkMessages[Symbol.asyncDispose]();
      }
      async readMessages() {
        try {
          for await (const message of this.transport.readMessages()) {
            if (message.type === "control_response") {
              const handler = this.pendingControlResponses.get(message.response.request_id);
              if (handler) {
                handler(message.response);
              }
              continue;
            } else if (message.type === "control_request") {
              this.handleControlRequest(message);
              continue;
            } else if (message.type === "control_cancel_request") {
              this.handleControlCancelRequest(message);
              continue;
            } else if (message.type === "keep_alive") {
              continue;
            }
            if (message.type === "result") {
              if (this.firstResultReceivedResolve) {
                this.firstResultReceivedResolve();
              }
              if (this.isSingleUserTurn) {
                this.transport.endInput();
              }
            }
            this.inputStream.enqueue(message);
          }
          this.inputStream.done();
          this.cleanup();
        } catch (error2) {
          this.inputStream.error(error2);
          this.cleanup(error2);
        }
      }
      async handleControlRequest(request2) {
        const controller = new AbortController();
        this.cancelControllers.set(request2.request_id, controller);
        try {
          const response = await this.processControlRequest(request2, controller.signal);
          const controlResponse = {
            type: "control_response",
            response: {
              subtype: "success",
              request_id: request2.request_id,
              response
            }
          };
          await Promise.resolve(this.transport.write(JSON.stringify(controlResponse) + `
`));
        } catch (error2) {
          const controlErrorResponse = {
            type: "control_response",
            response: {
              subtype: "error",
              request_id: request2.request_id,
              error: error2.message || String(error2)
            }
          };
          await Promise.resolve(this.transport.write(JSON.stringify(controlErrorResponse) + `
`));
        } finally {
          this.cancelControllers.delete(request2.request_id);
        }
      }
      handleControlCancelRequest(request2) {
        const controller = this.cancelControllers.get(request2.request_id);
        if (controller) {
          controller.abort();
          this.cancelControllers.delete(request2.request_id);
        }
      }
      async processControlRequest(request2, signal) {
        if (request2.request.subtype === "can_use_tool") {
          if (!this.canUseTool) {
            throw new Error("canUseTool callback is not provided.");
          }
          return this.canUseTool(request2.request.tool_name, request2.request.input, {
            signal,
            suggestions: request2.request.permission_suggestions
          });
        } else if (request2.request.subtype === "hook_callback") {
          const result = await this.handleHookCallbacks(request2.request.callback_id, request2.request.input, request2.request.tool_use_id, signal);
          return result;
        } else if (request2.request.subtype === "mcp_message") {
          const mcpRequest = request2.request;
          const transport = this.sdkMcpTransports.get(mcpRequest.server_name);
          if (!transport) {
            throw new Error(`SDK MCP server not found: ${mcpRequest.server_name}`);
          }
          if ("method" in mcpRequest.message && "id" in mcpRequest.message && mcpRequest.message.id !== null) {
            const response = await this.handleMcpControlRequest(mcpRequest.server_name, mcpRequest, transport);
            return { mcp_response: response };
          } else {
            if (transport.onmessage) {
              transport.onmessage(mcpRequest.message);
            }
            return { mcp_response: { jsonrpc: "2.0", result: {}, id: 0 } };
          }
        }
        throw new Error("Unsupported control request subtype: " + request2.request.subtype);
      }
      async *readSdkMessages() {
        for await (const message of this.inputStream) {
          yield message;
        }
      }
      async initialize() {
        let hooks;
        if (this.hooks) {
          hooks = {};
          for (const [event, matchers] of Object.entries(this.hooks)) {
            if (matchers.length > 0) {
              hooks[event] = matchers.map((matcher) => {
                const callbackIds = [];
                for (const callback of matcher.hooks) {
                  const callbackId = `hook_${this.nextCallbackId++}`;
                  this.hookCallbacks.set(callbackId, callback);
                  callbackIds.push(callbackId);
                }
                return {
                  matcher: matcher.matcher,
                  hookCallbackIds: callbackIds
                };
              });
            }
          }
        }
        const sdkMcpServers = this.sdkMcpTransports.size > 0 ? Array.from(this.sdkMcpTransports.keys()) : void 0;
        const initRequest = {
          subtype: "initialize",
          hooks,
          sdkMcpServers
        };
        const response = await this.request(initRequest);
        return response.response;
      }
      async interrupt() {
        await this.request({
          subtype: "interrupt"
        });
      }
      async setPermissionMode(mode) {
        await this.request({
          subtype: "set_permission_mode",
          mode
        });
      }
      async setModel(model) {
        await this.request({
          subtype: "set_model",
          model
        });
      }
      request(request2) {
        const requestId = Math.random().toString(36).substring(2, 15);
        const sdkRequest = {
          request_id: requestId,
          type: "control_request",
          request: request2
        };
        return new Promise((resolve3, reject) => {
          this.pendingControlResponses.set(requestId, (response) => {
            if (response.subtype === "success") {
              resolve3(response);
            } else {
              reject(new Error(response.error));
            }
          });
          Promise.resolve(this.transport.write(JSON.stringify(sdkRequest) + `
`));
        });
      }
      async supportedCommands() {
        return (await this.initialization).commands;
      }
      async supportedModels() {
        return (await this.initialization).models;
      }
      async mcpServerStatus() {
        const response = await this.request({
          subtype: "mcp_status"
        });
        const mcpStatusResponse = response.response;
        return mcpStatusResponse.mcpServers;
      }
      async streamInput(stream) {
        try {
          for await (const message of stream) {
            if (this.abortController?.signal.aborted)
              break;
            await Promise.resolve(this.transport.write(JSON.stringify(message) + `
`));
          }
          if (this.sdkMcpTransports.size > 0 && this.firstResultReceivedPromise) {
            const STREAM_CLOSE_TIMEOUT = 1e4;
            let timeoutId;
            await Promise.race([
              this.firstResultReceivedPromise.then(() => {
                if (timeoutId) {
                  clearTimeout(timeoutId);
                }
              }),
              new Promise((resolve3) => {
                timeoutId = setTimeout(() => {
                  resolve3();
                }, STREAM_CLOSE_TIMEOUT);
              })
            ]);
            if (timeoutId) {
              clearTimeout(timeoutId);
            }
          }
          this.transport.endInput();
        } catch (error2) {
          if (!(error2 instanceof AbortError)) {
            throw error2;
          }
        }
      }
      handleHookCallbacks(callbackId, input, toolUseID, abortSignal) {
        const callback = this.hookCallbacks.get(callbackId);
        if (!callback) {
          throw new Error(`No hook callback found for ID: ${callbackId}`);
        }
        return callback(input, toolUseID, {
          signal: abortSignal
        });
      }
      sendMcpServerMessageToCli(serverName, message) {
        if ("id" in message && message.id !== null && message.id !== void 0) {
          const key = `${serverName}:${message.id}`;
          const pending = this.pendingMcpResponses.get(key);
          if (pending) {
            pending.resolve(message);
            this.pendingMcpResponses.delete(key);
            return;
          }
        }
        throw new Error("No pending request found");
      }
      handleMcpControlRequest(serverName, mcpRequest, transport) {
        const messageId = "id" in mcpRequest.message ? mcpRequest.message.id : null;
        const key = `${serverName}:${messageId}`;
        return new Promise((resolve3, reject) => {
          let timeoutId = null;
          const cleanup = () => {
            if (timeoutId) {
              clearTimeout(timeoutId);
            }
            this.pendingMcpResponses.delete(key);
          };
          const resolveAndCleanup = (response) => {
            cleanup();
            resolve3(response);
          };
          const rejectAndCleanup = (error2) => {
            cleanup();
            reject(error2);
          };
          this.pendingMcpResponses.set(key, {
            resolve: resolveAndCleanup,
            reject: rejectAndCleanup
          });
          if (transport.onmessage) {
            transport.onmessage(mcpRequest.message);
          } else {
            cleanup();
            reject(new Error("No message handler registered"));
            return;
          }
          timeoutId = setTimeout(() => {
            if (this.pendingMcpResponses.has(key)) {
              cleanup();
              reject(new Error("Request timeout"));
            }
          }, 3e4);
        });
      }
    };
    exports_external = {};
    __export2(exports_external, {
      void: () => voidType,
      util: () => util,
      unknown: () => unknownType,
      union: () => unionType,
      undefined: () => undefinedType,
      tuple: () => tupleType,
      transformer: () => effectsType,
      symbol: () => symbolType,
      string: () => stringType,
      strictObject: () => strictObjectType,
      setErrorMap: () => setErrorMap,
      set: () => setType,
      record: () => recordType,
      quotelessJson: () => quotelessJson,
      promise: () => promiseType,
      preprocess: () => preprocessType,
      pipeline: () => pipelineType,
      ostring: () => ostring,
      optional: () => optionalType,
      onumber: () => onumber,
      oboolean: () => oboolean,
      objectUtil: () => objectUtil,
      object: () => objectType,
      number: () => numberType,
      nullable: () => nullableType,
      null: () => nullType,
      never: () => neverType,
      nativeEnum: () => nativeEnumType,
      nan: () => nanType,
      map: () => mapType,
      makeIssue: () => makeIssue,
      literal: () => literalType,
      lazy: () => lazyType,
      late: () => late,
      isValid: () => isValid,
      isDirty: () => isDirty,
      isAsync: () => isAsync,
      isAborted: () => isAborted,
      intersection: () => intersectionType,
      instanceof: () => instanceOfType,
      getParsedType: () => getParsedType,
      getErrorMap: () => getErrorMap,
      function: () => functionType,
      enum: () => enumType,
      effect: () => effectsType,
      discriminatedUnion: () => discriminatedUnionType,
      defaultErrorMap: () => en_default,
      datetimeRegex: () => datetimeRegex,
      date: () => dateType,
      custom: () => custom,
      coerce: () => coerce,
      boolean: () => booleanType,
      bigint: () => bigIntType,
      array: () => arrayType,
      any: () => anyType,
      addIssueToContext: () => addIssueToContext,
      ZodVoid: () => ZodVoid,
      ZodUnknown: () => ZodUnknown,
      ZodUnion: () => ZodUnion,
      ZodUndefined: () => ZodUndefined,
      ZodType: () => ZodType,
      ZodTuple: () => ZodTuple,
      ZodTransformer: () => ZodEffects,
      ZodSymbol: () => ZodSymbol,
      ZodString: () => ZodString,
      ZodSet: () => ZodSet,
      ZodSchema: () => ZodType,
      ZodRecord: () => ZodRecord,
      ZodReadonly: () => ZodReadonly,
      ZodPromise: () => ZodPromise,
      ZodPipeline: () => ZodPipeline,
      ZodParsedType: () => ZodParsedType,
      ZodOptional: () => ZodOptional,
      ZodObject: () => ZodObject,
      ZodNumber: () => ZodNumber,
      ZodNullable: () => ZodNullable,
      ZodNull: () => ZodNull,
      ZodNever: () => ZodNever,
      ZodNativeEnum: () => ZodNativeEnum,
      ZodNaN: () => ZodNaN,
      ZodMap: () => ZodMap,
      ZodLiteral: () => ZodLiteral,
      ZodLazy: () => ZodLazy,
      ZodIssueCode: () => ZodIssueCode,
      ZodIntersection: () => ZodIntersection,
      ZodFunction: () => ZodFunction,
      ZodFirstPartyTypeKind: () => ZodFirstPartyTypeKind,
      ZodError: () => ZodError,
      ZodEnum: () => ZodEnum,
      ZodEffects: () => ZodEffects,
      ZodDiscriminatedUnion: () => ZodDiscriminatedUnion,
      ZodDefault: () => ZodDefault,
      ZodDate: () => ZodDate,
      ZodCatch: () => ZodCatch,
      ZodBranded: () => ZodBranded,
      ZodBoolean: () => ZodBoolean,
      ZodBigInt: () => ZodBigInt,
      ZodArray: () => ZodArray,
      ZodAny: () => ZodAny,
      Schema: () => ZodType,
      ParseStatus: () => ParseStatus,
      OK: () => OK,
      NEVER: () => NEVER,
      INVALID: () => INVALID,
      EMPTY_PATH: () => EMPTY_PATH,
      DIRTY: () => DIRTY,
      BRAND: () => BRAND
    });
    (function(util22) {
      util22.assertEqual = (_) => {
      };
      function assertIs(_arg) {
      }
      util22.assertIs = assertIs;
      function assertNever2(_x) {
        throw new Error();
      }
      util22.assertNever = assertNever2;
      util22.arrayToEnum = (items) => {
        const obj = {};
        for (const item of items) {
          obj[item] = item;
        }
        return obj;
      };
      util22.getValidEnumValues = (obj) => {
        const validKeys = util22.objectKeys(obj).filter((k) => typeof obj[obj[k]] !== "number");
        const filtered = {};
        for (const k of validKeys) {
          filtered[k] = obj[k];
        }
        return util22.objectValues(filtered);
      };
      util22.objectValues = (obj) => {
        return util22.objectKeys(obj).map(function(e) {
          return obj[e];
        });
      };
      util22.objectKeys = typeof Object.keys === "function" ? (obj) => Object.keys(obj) : (object) => {
        const keys = [];
        for (const key in object) {
          if (Object.prototype.hasOwnProperty.call(object, key)) {
            keys.push(key);
          }
        }
        return keys;
      };
      util22.find = (arr, checker) => {
        for (const item of arr) {
          if (checker(item))
            return item;
        }
        return;
      };
      util22.isInteger = typeof Number.isInteger === "function" ? (val) => Number.isInteger(val) : (val) => typeof val === "number" && Number.isFinite(val) && Math.floor(val) === val;
      function joinValues(array, separator = " | ") {
        return array.map((val) => typeof val === "string" ? `'${val}'` : val).join(separator);
      }
      util22.joinValues = joinValues;
      util22.jsonStringifyReplacer = (_, value) => {
        if (typeof value === "bigint") {
          return value.toString();
        }
        return value;
      };
    })(util || (util = {}));
    (function(objectUtil2) {
      objectUtil2.mergeShapes = (first, second) => {
        return {
          ...first,
          ...second
        };
      };
    })(objectUtil || (objectUtil = {}));
    ZodParsedType = util.arrayToEnum([
      "string",
      "nan",
      "number",
      "integer",
      "float",
      "boolean",
      "date",
      "bigint",
      "symbol",
      "function",
      "undefined",
      "null",
      "array",
      "object",
      "unknown",
      "promise",
      "void",
      "never",
      "map",
      "set"
    ]);
    getParsedType = (data) => {
      const t92 = typeof data;
      switch (t92) {
        case "undefined":
          return ZodParsedType.undefined;
        case "string":
          return ZodParsedType.string;
        case "number":
          return Number.isNaN(data) ? ZodParsedType.nan : ZodParsedType.number;
        case "boolean":
          return ZodParsedType.boolean;
        case "function":
          return ZodParsedType.function;
        case "bigint":
          return ZodParsedType.bigint;
        case "symbol":
          return ZodParsedType.symbol;
        case "object":
          if (Array.isArray(data)) {
            return ZodParsedType.array;
          }
          if (data === null) {
            return ZodParsedType.null;
          }
          if (data.then && typeof data.then === "function" && data.catch && typeof data.catch === "function") {
            return ZodParsedType.promise;
          }
          if (typeof Map !== "undefined" && data instanceof Map) {
            return ZodParsedType.map;
          }
          if (typeof Set !== "undefined" && data instanceof Set) {
            return ZodParsedType.set;
          }
          if (typeof Date !== "undefined" && data instanceof Date) {
            return ZodParsedType.date;
          }
          return ZodParsedType.object;
        default:
          return ZodParsedType.unknown;
      }
    };
    ZodIssueCode = util.arrayToEnum([
      "invalid_type",
      "invalid_literal",
      "custom",
      "invalid_union",
      "invalid_union_discriminator",
      "invalid_enum_value",
      "unrecognized_keys",
      "invalid_arguments",
      "invalid_return_type",
      "invalid_date",
      "invalid_string",
      "too_small",
      "too_big",
      "invalid_intersection_types",
      "not_multiple_of",
      "not_finite"
    ]);
    quotelessJson = (obj) => {
      const json = JSON.stringify(obj, null, 2);
      return json.replace(/"([^"]+)":/g, "$1:");
    };
    ZodError = class _ZodError extends Error {
      get errors() {
        return this.issues;
      }
      constructor(issues) {
        super();
        this.issues = [];
        this.addIssue = (sub) => {
          this.issues = [...this.issues, sub];
        };
        this.addIssues = (subs = []) => {
          this.issues = [...this.issues, ...subs];
        };
        const actualProto = new.target.prototype;
        if (Object.setPrototypeOf) {
          Object.setPrototypeOf(this, actualProto);
        } else {
          this.__proto__ = actualProto;
        }
        this.name = "ZodError";
        this.issues = issues;
      }
      format(_mapper) {
        const mapper = _mapper || function(issue) {
          return issue.message;
        };
        const fieldErrors = { _errors: [] };
        const processError = (error2) => {
          for (const issue of error2.issues) {
            if (issue.code === "invalid_union") {
              issue.unionErrors.map(processError);
            } else if (issue.code === "invalid_return_type") {
              processError(issue.returnTypeError);
            } else if (issue.code === "invalid_arguments") {
              processError(issue.argumentsError);
            } else if (issue.path.length === 0) {
              fieldErrors._errors.push(mapper(issue));
            } else {
              let curr = fieldErrors;
              let i2 = 0;
              while (i2 < issue.path.length) {
                const el = issue.path[i2];
                const terminal = i2 === issue.path.length - 1;
                if (!terminal) {
                  curr[el] = curr[el] || { _errors: [] };
                } else {
                  curr[el] = curr[el] || { _errors: [] };
                  curr[el]._errors.push(mapper(issue));
                }
                curr = curr[el];
                i2++;
              }
            }
          }
        };
        processError(this);
        return fieldErrors;
      }
      static assert(value) {
        if (!(value instanceof _ZodError)) {
          throw new Error(`Not a ZodError: ${value}`);
        }
      }
      toString() {
        return this.message;
      }
      get message() {
        return JSON.stringify(this.issues, util.jsonStringifyReplacer, 2);
      }
      get isEmpty() {
        return this.issues.length === 0;
      }
      flatten(mapper = (issue) => issue.message) {
        const fieldErrors = {};
        const formErrors = [];
        for (const sub of this.issues) {
          if (sub.path.length > 0) {
            const firstEl = sub.path[0];
            fieldErrors[firstEl] = fieldErrors[firstEl] || [];
            fieldErrors[firstEl].push(mapper(sub));
          } else {
            formErrors.push(mapper(sub));
          }
        }
        return { formErrors, fieldErrors };
      }
      get formErrors() {
        return this.flatten();
      }
    };
    ZodError.create = (issues) => {
      const error2 = new ZodError(issues);
      return error2;
    };
    errorMap = (issue, _ctx) => {
      let message;
      switch (issue.code) {
        case ZodIssueCode.invalid_type:
          if (issue.received === ZodParsedType.undefined) {
            message = "Required";
          } else {
            message = `Expected ${issue.expected}, received ${issue.received}`;
          }
          break;
        case ZodIssueCode.invalid_literal:
          message = `Invalid literal value, expected ${JSON.stringify(issue.expected, util.jsonStringifyReplacer)}`;
          break;
        case ZodIssueCode.unrecognized_keys:
          message = `Unrecognized key(s) in object: ${util.joinValues(issue.keys, ", ")}`;
          break;
        case ZodIssueCode.invalid_union:
          message = `Invalid input`;
          break;
        case ZodIssueCode.invalid_union_discriminator:
          message = `Invalid discriminator value. Expected ${util.joinValues(issue.options)}`;
          break;
        case ZodIssueCode.invalid_enum_value:
          message = `Invalid enum value. Expected ${util.joinValues(issue.options)}, received '${issue.received}'`;
          break;
        case ZodIssueCode.invalid_arguments:
          message = `Invalid function arguments`;
          break;
        case ZodIssueCode.invalid_return_type:
          message = `Invalid function return type`;
          break;
        case ZodIssueCode.invalid_date:
          message = `Invalid date`;
          break;
        case ZodIssueCode.invalid_string:
          if (typeof issue.validation === "object") {
            if ("includes" in issue.validation) {
              message = `Invalid input: must include "${issue.validation.includes}"`;
              if (typeof issue.validation.position === "number") {
                message = `${message} at one or more positions greater than or equal to ${issue.validation.position}`;
              }
            } else if ("startsWith" in issue.validation) {
              message = `Invalid input: must start with "${issue.validation.startsWith}"`;
            } else if ("endsWith" in issue.validation) {
              message = `Invalid input: must end with "${issue.validation.endsWith}"`;
            } else {
              util.assertNever(issue.validation);
            }
          } else if (issue.validation !== "regex") {
            message = `Invalid ${issue.validation}`;
          } else {
            message = "Invalid";
          }
          break;
        case ZodIssueCode.too_small:
          if (issue.type === "array")
            message = `Array must contain ${issue.exact ? "exactly" : issue.inclusive ? `at least` : `more than`} ${issue.minimum} element(s)`;
          else if (issue.type === "string")
            message = `String must contain ${issue.exact ? "exactly" : issue.inclusive ? `at least` : `over`} ${issue.minimum} character(s)`;
          else if (issue.type === "number")
            message = `Number must be ${issue.exact ? `exactly equal to ` : issue.inclusive ? `greater than or equal to ` : `greater than `}${issue.minimum}`;
          else if (issue.type === "bigint")
            message = `Number must be ${issue.exact ? `exactly equal to ` : issue.inclusive ? `greater than or equal to ` : `greater than `}${issue.minimum}`;
          else if (issue.type === "date")
            message = `Date must be ${issue.exact ? `exactly equal to ` : issue.inclusive ? `greater than or equal to ` : `greater than `}${new Date(Number(issue.minimum))}`;
          else
            message = "Invalid input";
          break;
        case ZodIssueCode.too_big:
          if (issue.type === "array")
            message = `Array must contain ${issue.exact ? `exactly` : issue.inclusive ? `at most` : `less than`} ${issue.maximum} element(s)`;
          else if (issue.type === "string")
            message = `String must contain ${issue.exact ? `exactly` : issue.inclusive ? `at most` : `under`} ${issue.maximum} character(s)`;
          else if (issue.type === "number")
            message = `Number must be ${issue.exact ? `exactly` : issue.inclusive ? `less than or equal to` : `less than`} ${issue.maximum}`;
          else if (issue.type === "bigint")
            message = `BigInt must be ${issue.exact ? `exactly` : issue.inclusive ? `less than or equal to` : `less than`} ${issue.maximum}`;
          else if (issue.type === "date")
            message = `Date must be ${issue.exact ? `exactly` : issue.inclusive ? `smaller than or equal to` : `smaller than`} ${new Date(Number(issue.maximum))}`;
          else
            message = "Invalid input";
          break;
        case ZodIssueCode.custom:
          message = `Invalid input`;
          break;
        case ZodIssueCode.invalid_intersection_types:
          message = `Intersection results could not be merged`;
          break;
        case ZodIssueCode.not_multiple_of:
          message = `Number must be a multiple of ${issue.multipleOf}`;
          break;
        case ZodIssueCode.not_finite:
          message = "Number must be finite";
          break;
        default:
          message = _ctx.defaultError;
          util.assertNever(issue);
      }
      return { message };
    };
    en_default = errorMap;
    overrideErrorMap = en_default;
    makeIssue = (params) => {
      const { data, path: path15, errorMaps, issueData } = params;
      const fullPath = [...path15, ...issueData.path || []];
      const fullIssue = {
        ...issueData,
        path: fullPath
      };
      if (issueData.message !== void 0) {
        return {
          ...issueData,
          path: fullPath,
          message: issueData.message
        };
      }
      let errorMessage = "";
      const maps = errorMaps.filter((m2) => !!m2).slice().reverse();
      for (const map2 of maps) {
        errorMessage = map2(fullIssue, { data, defaultError: errorMessage }).message;
      }
      return {
        ...issueData,
        path: fullPath,
        message: errorMessage
      };
    };
    EMPTY_PATH = [];
    ParseStatus = class _ParseStatus {
      constructor() {
        this.value = "valid";
      }
      dirty() {
        if (this.value === "valid")
          this.value = "dirty";
      }
      abort() {
        if (this.value !== "aborted")
          this.value = "aborted";
      }
      static mergeArray(status, results) {
        const arrayValue = [];
        for (const s2 of results) {
          if (s2.status === "aborted")
            return INVALID;
          if (s2.status === "dirty")
            status.dirty();
          arrayValue.push(s2.value);
        }
        return { status: status.value, value: arrayValue };
      }
      static async mergeObjectAsync(status, pairs) {
        const syncPairs = [];
        for (const pair of pairs) {
          const key = await pair.key;
          const value = await pair.value;
          syncPairs.push({
            key,
            value
          });
        }
        return _ParseStatus.mergeObjectSync(status, syncPairs);
      }
      static mergeObjectSync(status, pairs) {
        const finalObject = {};
        for (const pair of pairs) {
          const { key, value } = pair;
          if (key.status === "aborted")
            return INVALID;
          if (value.status === "aborted")
            return INVALID;
          if (key.status === "dirty")
            status.dirty();
          if (value.status === "dirty")
            status.dirty();
          if (key.value !== "__proto__" && (typeof value.value !== "undefined" || pair.alwaysSet)) {
            finalObject[key.value] = value.value;
          }
        }
        return { status: status.value, value: finalObject };
      }
    };
    INVALID = Object.freeze({
      status: "aborted"
    });
    DIRTY = (value) => ({ status: "dirty", value });
    OK = (value) => ({ status: "valid", value });
    isAborted = (x) => x.status === "aborted";
    isDirty = (x) => x.status === "dirty";
    isValid = (x) => x.status === "valid";
    isAsync = (x) => typeof Promise !== "undefined" && x instanceof Promise;
    (function(errorUtil2) {
      errorUtil2.errToObj = (message) => typeof message === "string" ? { message } : message || {};
      errorUtil2.toString = (message) => typeof message === "string" ? message : message?.message;
    })(errorUtil || (errorUtil = {}));
    ParseInputLazyPath = class {
      constructor(parent, value, path15, key) {
        this._cachedPath = [];
        this.parent = parent;
        this.data = value;
        this._path = path15;
        this._key = key;
      }
      get path() {
        if (!this._cachedPath.length) {
          if (Array.isArray(this._key)) {
            this._cachedPath.push(...this._path, ...this._key);
          } else {
            this._cachedPath.push(...this._path, this._key);
          }
        }
        return this._cachedPath;
      }
    };
    handleResult = (ctx, result) => {
      if (isValid(result)) {
        return { success: true, data: result.value };
      } else {
        if (!ctx.common.issues.length) {
          throw new Error("Validation failed but no issues detected.");
        }
        return {
          success: false,
          get error() {
            if (this._error)
              return this._error;
            const error2 = new ZodError(ctx.common.issues);
            this._error = error2;
            return this._error;
          }
        };
      }
    };
    ZodType = class {
      get description() {
        return this._def.description;
      }
      _getType(input) {
        return getParsedType(input.data);
      }
      _getOrReturnCtx(input, ctx) {
        return ctx || {
          common: input.parent.common,
          data: input.data,
          parsedType: getParsedType(input.data),
          schemaErrorMap: this._def.errorMap,
          path: input.path,
          parent: input.parent
        };
      }
      _processInputParams(input) {
        return {
          status: new ParseStatus(),
          ctx: {
            common: input.parent.common,
            data: input.data,
            parsedType: getParsedType(input.data),
            schemaErrorMap: this._def.errorMap,
            path: input.path,
            parent: input.parent
          }
        };
      }
      _parseSync(input) {
        const result = this._parse(input);
        if (isAsync(result)) {
          throw new Error("Synchronous parse encountered promise.");
        }
        return result;
      }
      _parseAsync(input) {
        const result = this._parse(input);
        return Promise.resolve(result);
      }
      parse(data, params) {
        const result = this.safeParse(data, params);
        if (result.success)
          return result.data;
        throw result.error;
      }
      safeParse(data, params) {
        const ctx = {
          common: {
            issues: [],
            async: params?.async ?? false,
            contextualErrorMap: params?.errorMap
          },
          path: params?.path || [],
          schemaErrorMap: this._def.errorMap,
          parent: null,
          data,
          parsedType: getParsedType(data)
        };
        const result = this._parseSync({ data, path: ctx.path, parent: ctx });
        return handleResult(ctx, result);
      }
      "~validate"(data) {
        const ctx = {
          common: {
            issues: [],
            async: !!this["~standard"].async
          },
          path: [],
          schemaErrorMap: this._def.errorMap,
          parent: null,
          data,
          parsedType: getParsedType(data)
        };
        if (!this["~standard"].async) {
          try {
            const result = this._parseSync({ data, path: [], parent: ctx });
            return isValid(result) ? {
              value: result.value
            } : {
              issues: ctx.common.issues
            };
          } catch (err2) {
            if (err2?.message?.toLowerCase()?.includes("encountered")) {
              this["~standard"].async = true;
            }
            ctx.common = {
              issues: [],
              async: true
            };
          }
        }
        return this._parseAsync({ data, path: [], parent: ctx }).then((result) => isValid(result) ? {
          value: result.value
        } : {
          issues: ctx.common.issues
        });
      }
      async parseAsync(data, params) {
        const result = await this.safeParseAsync(data, params);
        if (result.success)
          return result.data;
        throw result.error;
      }
      async safeParseAsync(data, params) {
        const ctx = {
          common: {
            issues: [],
            contextualErrorMap: params?.errorMap,
            async: true
          },
          path: params?.path || [],
          schemaErrorMap: this._def.errorMap,
          parent: null,
          data,
          parsedType: getParsedType(data)
        };
        const maybeAsyncResult = this._parse({ data, path: ctx.path, parent: ctx });
        const result = await (isAsync(maybeAsyncResult) ? maybeAsyncResult : Promise.resolve(maybeAsyncResult));
        return handleResult(ctx, result);
      }
      refine(check, message) {
        const getIssueProperties = (val) => {
          if (typeof message === "string" || typeof message === "undefined") {
            return { message };
          } else if (typeof message === "function") {
            return message(val);
          } else {
            return message;
          }
        };
        return this._refinement((val, ctx) => {
          const result = check(val);
          const setError = () => ctx.addIssue({
            code: ZodIssueCode.custom,
            ...getIssueProperties(val)
          });
          if (typeof Promise !== "undefined" && result instanceof Promise) {
            return result.then((data) => {
              if (!data) {
                setError();
                return false;
              } else {
                return true;
              }
            });
          }
          if (!result) {
            setError();
            return false;
          } else {
            return true;
          }
        });
      }
      refinement(check, refinementData) {
        return this._refinement((val, ctx) => {
          if (!check(val)) {
            ctx.addIssue(typeof refinementData === "function" ? refinementData(val, ctx) : refinementData);
            return false;
          } else {
            return true;
          }
        });
      }
      _refinement(refinement) {
        return new ZodEffects({
          schema: this,
          typeName: ZodFirstPartyTypeKind.ZodEffects,
          effect: { type: "refinement", refinement }
        });
      }
      superRefine(refinement) {
        return this._refinement(refinement);
      }
      constructor(def) {
        this.spa = this.safeParseAsync;
        this._def = def;
        this.parse = this.parse.bind(this);
        this.safeParse = this.safeParse.bind(this);
        this.parseAsync = this.parseAsync.bind(this);
        this.safeParseAsync = this.safeParseAsync.bind(this);
        this.spa = this.spa.bind(this);
        this.refine = this.refine.bind(this);
        this.refinement = this.refinement.bind(this);
        this.superRefine = this.superRefine.bind(this);
        this.optional = this.optional.bind(this);
        this.nullable = this.nullable.bind(this);
        this.nullish = this.nullish.bind(this);
        this.array = this.array.bind(this);
        this.promise = this.promise.bind(this);
        this.or = this.or.bind(this);
        this.and = this.and.bind(this);
        this.transform = this.transform.bind(this);
        this.brand = this.brand.bind(this);
        this.default = this.default.bind(this);
        this.catch = this.catch.bind(this);
        this.describe = this.describe.bind(this);
        this.pipe = this.pipe.bind(this);
        this.readonly = this.readonly.bind(this);
        this.isNullable = this.isNullable.bind(this);
        this.isOptional = this.isOptional.bind(this);
        this["~standard"] = {
          version: 1,
          vendor: "zod",
          validate: (data) => this["~validate"](data)
        };
      }
      optional() {
        return ZodOptional.create(this, this._def);
      }
      nullable() {
        return ZodNullable.create(this, this._def);
      }
      nullish() {
        return this.nullable().optional();
      }
      array() {
        return ZodArray.create(this);
      }
      promise() {
        return ZodPromise.create(this, this._def);
      }
      or(option) {
        return ZodUnion.create([this, option], this._def);
      }
      and(incoming) {
        return ZodIntersection.create(this, incoming, this._def);
      }
      transform(transform2) {
        return new ZodEffects({
          ...processCreateParams(this._def),
          schema: this,
          typeName: ZodFirstPartyTypeKind.ZodEffects,
          effect: { type: "transform", transform: transform2 }
        });
      }
      default(def) {
        const defaultValueFunc = typeof def === "function" ? def : () => def;
        return new ZodDefault({
          ...processCreateParams(this._def),
          innerType: this,
          defaultValue: defaultValueFunc,
          typeName: ZodFirstPartyTypeKind.ZodDefault
        });
      }
      brand() {
        return new ZodBranded({
          typeName: ZodFirstPartyTypeKind.ZodBranded,
          type: this,
          ...processCreateParams(this._def)
        });
      }
      catch(def) {
        const catchValueFunc = typeof def === "function" ? def : () => def;
        return new ZodCatch({
          ...processCreateParams(this._def),
          innerType: this,
          catchValue: catchValueFunc,
          typeName: ZodFirstPartyTypeKind.ZodCatch
        });
      }
      describe(description) {
        const This = this.constructor;
        return new This({
          ...this._def,
          description
        });
      }
      pipe(target) {
        return ZodPipeline.create(this, target);
      }
      readonly() {
        return ZodReadonly.create(this);
      }
      isOptional() {
        return this.safeParse(void 0).success;
      }
      isNullable() {
        return this.safeParse(null).success;
      }
    };
    cuidRegex = /^c[^\s-]{8,}$/i;
    cuid2Regex = /^[0-9a-z]+$/;
    ulidRegex = /^[0-9A-HJKMNP-TV-Z]{26}$/i;
    uuidRegex = /^[0-9a-fA-F]{8}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{12}$/i;
    nanoidRegex = /^[a-z0-9_-]{21}$/i;
    jwtRegex = /^[A-Za-z0-9-_]+\.[A-Za-z0-9-_]+\.[A-Za-z0-9-_]*$/;
    durationRegex = /^[-+]?P(?!$)(?:(?:[-+]?\d+Y)|(?:[-+]?\d+[.,]\d+Y$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:(?:[-+]?\d+W)|(?:[-+]?\d+[.,]\d+W$))?(?:(?:[-+]?\d+D)|(?:[-+]?\d+[.,]\d+D$))?(?:T(?=[\d+-])(?:(?:[-+]?\d+H)|(?:[-+]?\d+[.,]\d+H$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:[-+]?\d+(?:[.,]\d+)?S)?)??$/;
    emailRegex = /^(?!\.)(?!.*\.\.)([A-Z0-9_'+\-\.]*)[A-Z0-9_+-]@([A-Z0-9][A-Z0-9\-]*\.)+[A-Z]{2,}$/i;
    _emojiRegex = `^(\\p{Extended_Pictographic}|\\p{Emoji_Component})+$`;
    ipv4Regex = /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/;
    ipv4CidrRegex = /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\/(3[0-2]|[12]?[0-9])$/;
    ipv6Regex = /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$/;
    ipv6CidrRegex = /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\/(12[0-8]|1[01][0-9]|[1-9]?[0-9])$/;
    base64Regex = /^([0-9a-zA-Z+/]{4})*(([0-9a-zA-Z+/]{2}==)|([0-9a-zA-Z+/]{3}=))?$/;
    base64urlRegex = /^([0-9a-zA-Z-_]{4})*(([0-9a-zA-Z-_]{2}(==)?)|([0-9a-zA-Z-_]{3}(=)?))?$/;
    dateRegexSource = `((\\d\\d[2468][048]|\\d\\d[13579][26]|\\d\\d0[48]|[02468][048]00|[13579][26]00)-02-29|\\d{4}-((0[13578]|1[02])-(0[1-9]|[12]\\d|3[01])|(0[469]|11)-(0[1-9]|[12]\\d|30)|(02)-(0[1-9]|1\\d|2[0-8])))`;
    dateRegex = new RegExp(`^${dateRegexSource}$`);
    ZodString = class _ZodString extends ZodType {
      _parse(input) {
        if (this._def.coerce) {
          input.data = String(input.data);
        }
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.string) {
          const ctx2 = this._getOrReturnCtx(input);
          addIssueToContext(ctx2, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.string,
            received: ctx2.parsedType
          });
          return INVALID;
        }
        const status = new ParseStatus();
        let ctx = void 0;
        for (const check of this._def.checks) {
          if (check.kind === "min") {
            if (input.data.length < check.value) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_small,
                minimum: check.value,
                type: "string",
                inclusive: true,
                exact: false,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "max") {
            if (input.data.length > check.value) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_big,
                maximum: check.value,
                type: "string",
                inclusive: true,
                exact: false,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "length") {
            const tooBig = input.data.length > check.value;
            const tooSmall = input.data.length < check.value;
            if (tooBig || tooSmall) {
              ctx = this._getOrReturnCtx(input, ctx);
              if (tooBig) {
                addIssueToContext(ctx, {
                  code: ZodIssueCode.too_big,
                  maximum: check.value,
                  type: "string",
                  inclusive: true,
                  exact: true,
                  message: check.message
                });
              } else if (tooSmall) {
                addIssueToContext(ctx, {
                  code: ZodIssueCode.too_small,
                  minimum: check.value,
                  type: "string",
                  inclusive: true,
                  exact: true,
                  message: check.message
                });
              }
              status.dirty();
            }
          } else if (check.kind === "email") {
            if (!emailRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "email",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "emoji") {
            if (!emojiRegex) {
              emojiRegex = new RegExp(_emojiRegex, "u");
            }
            if (!emojiRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "emoji",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "uuid") {
            if (!uuidRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "uuid",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "nanoid") {
            if (!nanoidRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "nanoid",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "cuid") {
            if (!cuidRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "cuid",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "cuid2") {
            if (!cuid2Regex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "cuid2",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "ulid") {
            if (!ulidRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "ulid",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "url") {
            try {
              new URL(input.data);
            } catch {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "url",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "regex") {
            check.regex.lastIndex = 0;
            const testResult = check.regex.test(input.data);
            if (!testResult) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "regex",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "trim") {
            input.data = input.data.trim();
          } else if (check.kind === "includes") {
            if (!input.data.includes(check.value, check.position)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: { includes: check.value, position: check.position },
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "toLowerCase") {
            input.data = input.data.toLowerCase();
          } else if (check.kind === "toUpperCase") {
            input.data = input.data.toUpperCase();
          } else if (check.kind === "startsWith") {
            if (!input.data.startsWith(check.value)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: { startsWith: check.value },
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "endsWith") {
            if (!input.data.endsWith(check.value)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: { endsWith: check.value },
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "datetime") {
            const regex = datetimeRegex(check);
            if (!regex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: "datetime",
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "date") {
            const regex = dateRegex;
            if (!regex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: "date",
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "time") {
            const regex = timeRegex(check);
            if (!regex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: "time",
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "duration") {
            if (!durationRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "duration",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "ip") {
            if (!isValidIP(input.data, check.version)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "ip",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "jwt") {
            if (!isValidJWT(input.data, check.alg)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "jwt",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "cidr") {
            if (!isValidCidr(input.data, check.version)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "cidr",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "base64") {
            if (!base64Regex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "base64",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "base64url") {
            if (!base64urlRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "base64url",
                code: ZodIssueCode.invalid_string,
                message: check.message
              });
              status.dirty();
            }
          } else {
            util.assertNever(check);
          }
        }
        return { status: status.value, value: input.data };
      }
      _regex(regex, validation, message) {
        return this.refinement((data) => regex.test(data), {
          validation,
          code: ZodIssueCode.invalid_string,
          ...errorUtil.errToObj(message)
        });
      }
      _addCheck(check) {
        return new _ZodString({
          ...this._def,
          checks: [...this._def.checks, check]
        });
      }
      email(message) {
        return this._addCheck({ kind: "email", ...errorUtil.errToObj(message) });
      }
      url(message) {
        return this._addCheck({ kind: "url", ...errorUtil.errToObj(message) });
      }
      emoji(message) {
        return this._addCheck({ kind: "emoji", ...errorUtil.errToObj(message) });
      }
      uuid(message) {
        return this._addCheck({ kind: "uuid", ...errorUtil.errToObj(message) });
      }
      nanoid(message) {
        return this._addCheck({ kind: "nanoid", ...errorUtil.errToObj(message) });
      }
      cuid(message) {
        return this._addCheck({ kind: "cuid", ...errorUtil.errToObj(message) });
      }
      cuid2(message) {
        return this._addCheck({ kind: "cuid2", ...errorUtil.errToObj(message) });
      }
      ulid(message) {
        return this._addCheck({ kind: "ulid", ...errorUtil.errToObj(message) });
      }
      base64(message) {
        return this._addCheck({ kind: "base64", ...errorUtil.errToObj(message) });
      }
      base64url(message) {
        return this._addCheck({
          kind: "base64url",
          ...errorUtil.errToObj(message)
        });
      }
      jwt(options) {
        return this._addCheck({ kind: "jwt", ...errorUtil.errToObj(options) });
      }
      ip(options) {
        return this._addCheck({ kind: "ip", ...errorUtil.errToObj(options) });
      }
      cidr(options) {
        return this._addCheck({ kind: "cidr", ...errorUtil.errToObj(options) });
      }
      datetime(options) {
        if (typeof options === "string") {
          return this._addCheck({
            kind: "datetime",
            precision: null,
            offset: false,
            local: false,
            message: options
          });
        }
        return this._addCheck({
          kind: "datetime",
          precision: typeof options?.precision === "undefined" ? null : options?.precision,
          offset: options?.offset ?? false,
          local: options?.local ?? false,
          ...errorUtil.errToObj(options?.message)
        });
      }
      date(message) {
        return this._addCheck({ kind: "date", message });
      }
      time(options) {
        if (typeof options === "string") {
          return this._addCheck({
            kind: "time",
            precision: null,
            message: options
          });
        }
        return this._addCheck({
          kind: "time",
          precision: typeof options?.precision === "undefined" ? null : options?.precision,
          ...errorUtil.errToObj(options?.message)
        });
      }
      duration(message) {
        return this._addCheck({ kind: "duration", ...errorUtil.errToObj(message) });
      }
      regex(regex, message) {
        return this._addCheck({
          kind: "regex",
          regex,
          ...errorUtil.errToObj(message)
        });
      }
      includes(value, options) {
        return this._addCheck({
          kind: "includes",
          value,
          position: options?.position,
          ...errorUtil.errToObj(options?.message)
        });
      }
      startsWith(value, message) {
        return this._addCheck({
          kind: "startsWith",
          value,
          ...errorUtil.errToObj(message)
        });
      }
      endsWith(value, message) {
        return this._addCheck({
          kind: "endsWith",
          value,
          ...errorUtil.errToObj(message)
        });
      }
      min(minLength, message) {
        return this._addCheck({
          kind: "min",
          value: minLength,
          ...errorUtil.errToObj(message)
        });
      }
      max(maxLength, message) {
        return this._addCheck({
          kind: "max",
          value: maxLength,
          ...errorUtil.errToObj(message)
        });
      }
      length(len, message) {
        return this._addCheck({
          kind: "length",
          value: len,
          ...errorUtil.errToObj(message)
        });
      }
      nonempty(message) {
        return this.min(1, errorUtil.errToObj(message));
      }
      trim() {
        return new _ZodString({
          ...this._def,
          checks: [...this._def.checks, { kind: "trim" }]
        });
      }
      toLowerCase() {
        return new _ZodString({
          ...this._def,
          checks: [...this._def.checks, { kind: "toLowerCase" }]
        });
      }
      toUpperCase() {
        return new _ZodString({
          ...this._def,
          checks: [...this._def.checks, { kind: "toUpperCase" }]
        });
      }
      get isDatetime() {
        return !!this._def.checks.find((ch) => ch.kind === "datetime");
      }
      get isDate() {
        return !!this._def.checks.find((ch) => ch.kind === "date");
      }
      get isTime() {
        return !!this._def.checks.find((ch) => ch.kind === "time");
      }
      get isDuration() {
        return !!this._def.checks.find((ch) => ch.kind === "duration");
      }
      get isEmail() {
        return !!this._def.checks.find((ch) => ch.kind === "email");
      }
      get isURL() {
        return !!this._def.checks.find((ch) => ch.kind === "url");
      }
      get isEmoji() {
        return !!this._def.checks.find((ch) => ch.kind === "emoji");
      }
      get isUUID() {
        return !!this._def.checks.find((ch) => ch.kind === "uuid");
      }
      get isNANOID() {
        return !!this._def.checks.find((ch) => ch.kind === "nanoid");
      }
      get isCUID() {
        return !!this._def.checks.find((ch) => ch.kind === "cuid");
      }
      get isCUID2() {
        return !!this._def.checks.find((ch) => ch.kind === "cuid2");
      }
      get isULID() {
        return !!this._def.checks.find((ch) => ch.kind === "ulid");
      }
      get isIP() {
        return !!this._def.checks.find((ch) => ch.kind === "ip");
      }
      get isCIDR() {
        return !!this._def.checks.find((ch) => ch.kind === "cidr");
      }
      get isBase64() {
        return !!this._def.checks.find((ch) => ch.kind === "base64");
      }
      get isBase64url() {
        return !!this._def.checks.find((ch) => ch.kind === "base64url");
      }
      get minLength() {
        let min2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "min") {
            if (min2 === null || ch.value > min2)
              min2 = ch.value;
          }
        }
        return min2;
      }
      get maxLength() {
        let max2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "max") {
            if (max2 === null || ch.value < max2)
              max2 = ch.value;
          }
        }
        return max2;
      }
    };
    ZodString.create = (params) => {
      return new ZodString({
        checks: [],
        typeName: ZodFirstPartyTypeKind.ZodString,
        coerce: params?.coerce ?? false,
        ...processCreateParams(params)
      });
    };
    ZodNumber = class _ZodNumber extends ZodType {
      constructor() {
        super(...arguments);
        this.min = this.gte;
        this.max = this.lte;
        this.step = this.multipleOf;
      }
      _parse(input) {
        if (this._def.coerce) {
          input.data = Number(input.data);
        }
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.number) {
          const ctx2 = this._getOrReturnCtx(input);
          addIssueToContext(ctx2, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.number,
            received: ctx2.parsedType
          });
          return INVALID;
        }
        let ctx = void 0;
        const status = new ParseStatus();
        for (const check of this._def.checks) {
          if (check.kind === "int") {
            if (!util.isInteger(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_type,
                expected: "integer",
                received: "float",
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "min") {
            const tooSmall = check.inclusive ? input.data < check.value : input.data <= check.value;
            if (tooSmall) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_small,
                minimum: check.value,
                type: "number",
                inclusive: check.inclusive,
                exact: false,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "max") {
            const tooBig = check.inclusive ? input.data > check.value : input.data >= check.value;
            if (tooBig) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_big,
                maximum: check.value,
                type: "number",
                inclusive: check.inclusive,
                exact: false,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "multipleOf") {
            if (floatSafeRemainder(input.data, check.value) !== 0) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.not_multiple_of,
                multipleOf: check.value,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "finite") {
            if (!Number.isFinite(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.not_finite,
                message: check.message
              });
              status.dirty();
            }
          } else {
            util.assertNever(check);
          }
        }
        return { status: status.value, value: input.data };
      }
      gte(value, message) {
        return this.setLimit("min", value, true, errorUtil.toString(message));
      }
      gt(value, message) {
        return this.setLimit("min", value, false, errorUtil.toString(message));
      }
      lte(value, message) {
        return this.setLimit("max", value, true, errorUtil.toString(message));
      }
      lt(value, message) {
        return this.setLimit("max", value, false, errorUtil.toString(message));
      }
      setLimit(kind, value, inclusive, message) {
        return new _ZodNumber({
          ...this._def,
          checks: [
            ...this._def.checks,
            {
              kind,
              value,
              inclusive,
              message: errorUtil.toString(message)
            }
          ]
        });
      }
      _addCheck(check) {
        return new _ZodNumber({
          ...this._def,
          checks: [...this._def.checks, check]
        });
      }
      int(message) {
        return this._addCheck({
          kind: "int",
          message: errorUtil.toString(message)
        });
      }
      positive(message) {
        return this._addCheck({
          kind: "min",
          value: 0,
          inclusive: false,
          message: errorUtil.toString(message)
        });
      }
      negative(message) {
        return this._addCheck({
          kind: "max",
          value: 0,
          inclusive: false,
          message: errorUtil.toString(message)
        });
      }
      nonpositive(message) {
        return this._addCheck({
          kind: "max",
          value: 0,
          inclusive: true,
          message: errorUtil.toString(message)
        });
      }
      nonnegative(message) {
        return this._addCheck({
          kind: "min",
          value: 0,
          inclusive: true,
          message: errorUtil.toString(message)
        });
      }
      multipleOf(value, message) {
        return this._addCheck({
          kind: "multipleOf",
          value,
          message: errorUtil.toString(message)
        });
      }
      finite(message) {
        return this._addCheck({
          kind: "finite",
          message: errorUtil.toString(message)
        });
      }
      safe(message) {
        return this._addCheck({
          kind: "min",
          inclusive: true,
          value: Number.MIN_SAFE_INTEGER,
          message: errorUtil.toString(message)
        })._addCheck({
          kind: "max",
          inclusive: true,
          value: Number.MAX_SAFE_INTEGER,
          message: errorUtil.toString(message)
        });
      }
      get minValue() {
        let min2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "min") {
            if (min2 === null || ch.value > min2)
              min2 = ch.value;
          }
        }
        return min2;
      }
      get maxValue() {
        let max2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "max") {
            if (max2 === null || ch.value < max2)
              max2 = ch.value;
          }
        }
        return max2;
      }
      get isInt() {
        return !!this._def.checks.find((ch) => ch.kind === "int" || ch.kind === "multipleOf" && util.isInteger(ch.value));
      }
      get isFinite() {
        let max2 = null;
        let min2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "finite" || ch.kind === "int" || ch.kind === "multipleOf") {
            return true;
          } else if (ch.kind === "min") {
            if (min2 === null || ch.value > min2)
              min2 = ch.value;
          } else if (ch.kind === "max") {
            if (max2 === null || ch.value < max2)
              max2 = ch.value;
          }
        }
        return Number.isFinite(min2) && Number.isFinite(max2);
      }
    };
    ZodNumber.create = (params) => {
      return new ZodNumber({
        checks: [],
        typeName: ZodFirstPartyTypeKind.ZodNumber,
        coerce: params?.coerce || false,
        ...processCreateParams(params)
      });
    };
    ZodBigInt = class _ZodBigInt extends ZodType {
      constructor() {
        super(...arguments);
        this.min = this.gte;
        this.max = this.lte;
      }
      _parse(input) {
        if (this._def.coerce) {
          try {
            input.data = BigInt(input.data);
          } catch {
            return this._getInvalidInput(input);
          }
        }
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.bigint) {
          return this._getInvalidInput(input);
        }
        let ctx = void 0;
        const status = new ParseStatus();
        for (const check of this._def.checks) {
          if (check.kind === "min") {
            const tooSmall = check.inclusive ? input.data < check.value : input.data <= check.value;
            if (tooSmall) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_small,
                type: "bigint",
                minimum: check.value,
                inclusive: check.inclusive,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "max") {
            const tooBig = check.inclusive ? input.data > check.value : input.data >= check.value;
            if (tooBig) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_big,
                type: "bigint",
                maximum: check.value,
                inclusive: check.inclusive,
                message: check.message
              });
              status.dirty();
            }
          } else if (check.kind === "multipleOf") {
            if (input.data % check.value !== BigInt(0)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.not_multiple_of,
                multipleOf: check.value,
                message: check.message
              });
              status.dirty();
            }
          } else {
            util.assertNever(check);
          }
        }
        return { status: status.value, value: input.data };
      }
      _getInvalidInput(input) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.bigint,
          received: ctx.parsedType
        });
        return INVALID;
      }
      gte(value, message) {
        return this.setLimit("min", value, true, errorUtil.toString(message));
      }
      gt(value, message) {
        return this.setLimit("min", value, false, errorUtil.toString(message));
      }
      lte(value, message) {
        return this.setLimit("max", value, true, errorUtil.toString(message));
      }
      lt(value, message) {
        return this.setLimit("max", value, false, errorUtil.toString(message));
      }
      setLimit(kind, value, inclusive, message) {
        return new _ZodBigInt({
          ...this._def,
          checks: [
            ...this._def.checks,
            {
              kind,
              value,
              inclusive,
              message: errorUtil.toString(message)
            }
          ]
        });
      }
      _addCheck(check) {
        return new _ZodBigInt({
          ...this._def,
          checks: [...this._def.checks, check]
        });
      }
      positive(message) {
        return this._addCheck({
          kind: "min",
          value: BigInt(0),
          inclusive: false,
          message: errorUtil.toString(message)
        });
      }
      negative(message) {
        return this._addCheck({
          kind: "max",
          value: BigInt(0),
          inclusive: false,
          message: errorUtil.toString(message)
        });
      }
      nonpositive(message) {
        return this._addCheck({
          kind: "max",
          value: BigInt(0),
          inclusive: true,
          message: errorUtil.toString(message)
        });
      }
      nonnegative(message) {
        return this._addCheck({
          kind: "min",
          value: BigInt(0),
          inclusive: true,
          message: errorUtil.toString(message)
        });
      }
      multipleOf(value, message) {
        return this._addCheck({
          kind: "multipleOf",
          value,
          message: errorUtil.toString(message)
        });
      }
      get minValue() {
        let min2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "min") {
            if (min2 === null || ch.value > min2)
              min2 = ch.value;
          }
        }
        return min2;
      }
      get maxValue() {
        let max2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "max") {
            if (max2 === null || ch.value < max2)
              max2 = ch.value;
          }
        }
        return max2;
      }
    };
    ZodBigInt.create = (params) => {
      return new ZodBigInt({
        checks: [],
        typeName: ZodFirstPartyTypeKind.ZodBigInt,
        coerce: params?.coerce ?? false,
        ...processCreateParams(params)
      });
    };
    ZodBoolean = class extends ZodType {
      _parse(input) {
        if (this._def.coerce) {
          input.data = Boolean(input.data);
        }
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.boolean) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.boolean,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return OK(input.data);
      }
    };
    ZodBoolean.create = (params) => {
      return new ZodBoolean({
        typeName: ZodFirstPartyTypeKind.ZodBoolean,
        coerce: params?.coerce || false,
        ...processCreateParams(params)
      });
    };
    ZodDate = class _ZodDate extends ZodType {
      _parse(input) {
        if (this._def.coerce) {
          input.data = new Date(input.data);
        }
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.date) {
          const ctx2 = this._getOrReturnCtx(input);
          addIssueToContext(ctx2, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.date,
            received: ctx2.parsedType
          });
          return INVALID;
        }
        if (Number.isNaN(input.data.getTime())) {
          const ctx2 = this._getOrReturnCtx(input);
          addIssueToContext(ctx2, {
            code: ZodIssueCode.invalid_date
          });
          return INVALID;
        }
        const status = new ParseStatus();
        let ctx = void 0;
        for (const check of this._def.checks) {
          if (check.kind === "min") {
            if (input.data.getTime() < check.value) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_small,
                message: check.message,
                inclusive: true,
                exact: false,
                minimum: check.value,
                type: "date"
              });
              status.dirty();
            }
          } else if (check.kind === "max") {
            if (input.data.getTime() > check.value) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_big,
                message: check.message,
                inclusive: true,
                exact: false,
                maximum: check.value,
                type: "date"
              });
              status.dirty();
            }
          } else {
            util.assertNever(check);
          }
        }
        return {
          status: status.value,
          value: new Date(input.data.getTime())
        };
      }
      _addCheck(check) {
        return new _ZodDate({
          ...this._def,
          checks: [...this._def.checks, check]
        });
      }
      min(minDate, message) {
        return this._addCheck({
          kind: "min",
          value: minDate.getTime(),
          message: errorUtil.toString(message)
        });
      }
      max(maxDate, message) {
        return this._addCheck({
          kind: "max",
          value: maxDate.getTime(),
          message: errorUtil.toString(message)
        });
      }
      get minDate() {
        let min2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "min") {
            if (min2 === null || ch.value > min2)
              min2 = ch.value;
          }
        }
        return min2 != null ? new Date(min2) : null;
      }
      get maxDate() {
        let max2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "max") {
            if (max2 === null || ch.value < max2)
              max2 = ch.value;
          }
        }
        return max2 != null ? new Date(max2) : null;
      }
    };
    ZodDate.create = (params) => {
      return new ZodDate({
        checks: [],
        coerce: params?.coerce || false,
        typeName: ZodFirstPartyTypeKind.ZodDate,
        ...processCreateParams(params)
      });
    };
    ZodSymbol = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.symbol) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.symbol,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return OK(input.data);
      }
    };
    ZodSymbol.create = (params) => {
      return new ZodSymbol({
        typeName: ZodFirstPartyTypeKind.ZodSymbol,
        ...processCreateParams(params)
      });
    };
    ZodUndefined = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.undefined) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.undefined,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return OK(input.data);
      }
    };
    ZodUndefined.create = (params) => {
      return new ZodUndefined({
        typeName: ZodFirstPartyTypeKind.ZodUndefined,
        ...processCreateParams(params)
      });
    };
    ZodNull = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.null) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.null,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return OK(input.data);
      }
    };
    ZodNull.create = (params) => {
      return new ZodNull({
        typeName: ZodFirstPartyTypeKind.ZodNull,
        ...processCreateParams(params)
      });
    };
    ZodAny = class extends ZodType {
      constructor() {
        super(...arguments);
        this._any = true;
      }
      _parse(input) {
        return OK(input.data);
      }
    };
    ZodAny.create = (params) => {
      return new ZodAny({
        typeName: ZodFirstPartyTypeKind.ZodAny,
        ...processCreateParams(params)
      });
    };
    ZodUnknown = class extends ZodType {
      constructor() {
        super(...arguments);
        this._unknown = true;
      }
      _parse(input) {
        return OK(input.data);
      }
    };
    ZodUnknown.create = (params) => {
      return new ZodUnknown({
        typeName: ZodFirstPartyTypeKind.ZodUnknown,
        ...processCreateParams(params)
      });
    };
    ZodNever = class extends ZodType {
      _parse(input) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.never,
          received: ctx.parsedType
        });
        return INVALID;
      }
    };
    ZodNever.create = (params) => {
      return new ZodNever({
        typeName: ZodFirstPartyTypeKind.ZodNever,
        ...processCreateParams(params)
      });
    };
    ZodVoid = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.undefined) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.void,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return OK(input.data);
      }
    };
    ZodVoid.create = (params) => {
      return new ZodVoid({
        typeName: ZodFirstPartyTypeKind.ZodVoid,
        ...processCreateParams(params)
      });
    };
    ZodArray = class _ZodArray extends ZodType {
      _parse(input) {
        const { ctx, status } = this._processInputParams(input);
        const def = this._def;
        if (ctx.parsedType !== ZodParsedType.array) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.array,
            received: ctx.parsedType
          });
          return INVALID;
        }
        if (def.exactLength !== null) {
          const tooBig = ctx.data.length > def.exactLength.value;
          const tooSmall = ctx.data.length < def.exactLength.value;
          if (tooBig || tooSmall) {
            addIssueToContext(ctx, {
              code: tooBig ? ZodIssueCode.too_big : ZodIssueCode.too_small,
              minimum: tooSmall ? def.exactLength.value : void 0,
              maximum: tooBig ? def.exactLength.value : void 0,
              type: "array",
              inclusive: true,
              exact: true,
              message: def.exactLength.message
            });
            status.dirty();
          }
        }
        if (def.minLength !== null) {
          if (ctx.data.length < def.minLength.value) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_small,
              minimum: def.minLength.value,
              type: "array",
              inclusive: true,
              exact: false,
              message: def.minLength.message
            });
            status.dirty();
          }
        }
        if (def.maxLength !== null) {
          if (ctx.data.length > def.maxLength.value) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_big,
              maximum: def.maxLength.value,
              type: "array",
              inclusive: true,
              exact: false,
              message: def.maxLength.message
            });
            status.dirty();
          }
        }
        if (ctx.common.async) {
          return Promise.all([...ctx.data].map((item, i2) => {
            return def.type._parseAsync(new ParseInputLazyPath(ctx, item, ctx.path, i2));
          })).then((result2) => {
            return ParseStatus.mergeArray(status, result2);
          });
        }
        const result = [...ctx.data].map((item, i2) => {
          return def.type._parseSync(new ParseInputLazyPath(ctx, item, ctx.path, i2));
        });
        return ParseStatus.mergeArray(status, result);
      }
      get element() {
        return this._def.type;
      }
      min(minLength, message) {
        return new _ZodArray({
          ...this._def,
          minLength: { value: minLength, message: errorUtil.toString(message) }
        });
      }
      max(maxLength, message) {
        return new _ZodArray({
          ...this._def,
          maxLength: { value: maxLength, message: errorUtil.toString(message) }
        });
      }
      length(len, message) {
        return new _ZodArray({
          ...this._def,
          exactLength: { value: len, message: errorUtil.toString(message) }
        });
      }
      nonempty(message) {
        return this.min(1, message);
      }
    };
    ZodArray.create = (schema, params) => {
      return new ZodArray({
        type: schema,
        minLength: null,
        maxLength: null,
        exactLength: null,
        typeName: ZodFirstPartyTypeKind.ZodArray,
        ...processCreateParams(params)
      });
    };
    ZodObject = class _ZodObject extends ZodType {
      constructor() {
        super(...arguments);
        this._cached = null;
        this.nonstrict = this.passthrough;
        this.augment = this.extend;
      }
      _getCached() {
        if (this._cached !== null)
          return this._cached;
        const shape = this._def.shape();
        const keys = util.objectKeys(shape);
        this._cached = { shape, keys };
        return this._cached;
      }
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.object) {
          const ctx2 = this._getOrReturnCtx(input);
          addIssueToContext(ctx2, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.object,
            received: ctx2.parsedType
          });
          return INVALID;
        }
        const { status, ctx } = this._processInputParams(input);
        const { shape, keys: shapeKeys } = this._getCached();
        const extraKeys = [];
        if (!(this._def.catchall instanceof ZodNever && this._def.unknownKeys === "strip")) {
          for (const key in ctx.data) {
            if (!shapeKeys.includes(key)) {
              extraKeys.push(key);
            }
          }
        }
        const pairs = [];
        for (const key of shapeKeys) {
          const keyValidator = shape[key];
          const value = ctx.data[key];
          pairs.push({
            key: { status: "valid", value: key },
            value: keyValidator._parse(new ParseInputLazyPath(ctx, value, ctx.path, key)),
            alwaysSet: key in ctx.data
          });
        }
        if (this._def.catchall instanceof ZodNever) {
          const unknownKeys = this._def.unknownKeys;
          if (unknownKeys === "passthrough") {
            for (const key of extraKeys) {
              pairs.push({
                key: { status: "valid", value: key },
                value: { status: "valid", value: ctx.data[key] }
              });
            }
          } else if (unknownKeys === "strict") {
            if (extraKeys.length > 0) {
              addIssueToContext(ctx, {
                code: ZodIssueCode.unrecognized_keys,
                keys: extraKeys
              });
              status.dirty();
            }
          } else if (unknownKeys === "strip") {
          } else {
            throw new Error(`Internal ZodObject error: invalid unknownKeys value.`);
          }
        } else {
          const catchall = this._def.catchall;
          for (const key of extraKeys) {
            const value = ctx.data[key];
            pairs.push({
              key: { status: "valid", value: key },
              value: catchall._parse(new ParseInputLazyPath(ctx, value, ctx.path, key)),
              alwaysSet: key in ctx.data
            });
          }
        }
        if (ctx.common.async) {
          return Promise.resolve().then(async () => {
            const syncPairs = [];
            for (const pair of pairs) {
              const key = await pair.key;
              const value = await pair.value;
              syncPairs.push({
                key,
                value,
                alwaysSet: pair.alwaysSet
              });
            }
            return syncPairs;
          }).then((syncPairs) => {
            return ParseStatus.mergeObjectSync(status, syncPairs);
          });
        } else {
          return ParseStatus.mergeObjectSync(status, pairs);
        }
      }
      get shape() {
        return this._def.shape();
      }
      strict(message) {
        errorUtil.errToObj;
        return new _ZodObject({
          ...this._def,
          unknownKeys: "strict",
          ...message !== void 0 ? {
            errorMap: (issue, ctx) => {
              const defaultError = this._def.errorMap?.(issue, ctx).message ?? ctx.defaultError;
              if (issue.code === "unrecognized_keys")
                return {
                  message: errorUtil.errToObj(message).message ?? defaultError
                };
              return {
                message: defaultError
              };
            }
          } : {}
        });
      }
      strip() {
        return new _ZodObject({
          ...this._def,
          unknownKeys: "strip"
        });
      }
      passthrough() {
        return new _ZodObject({
          ...this._def,
          unknownKeys: "passthrough"
        });
      }
      extend(augmentation) {
        return new _ZodObject({
          ...this._def,
          shape: () => ({
            ...this._def.shape(),
            ...augmentation
          })
        });
      }
      merge(merging) {
        const merged = new _ZodObject({
          unknownKeys: merging._def.unknownKeys,
          catchall: merging._def.catchall,
          shape: () => ({
            ...this._def.shape(),
            ...merging._def.shape()
          }),
          typeName: ZodFirstPartyTypeKind.ZodObject
        });
        return merged;
      }
      setKey(key, schema) {
        return this.augment({ [key]: schema });
      }
      catchall(index) {
        return new _ZodObject({
          ...this._def,
          catchall: index
        });
      }
      pick(mask) {
        const shape = {};
        for (const key of util.objectKeys(mask)) {
          if (mask[key] && this.shape[key]) {
            shape[key] = this.shape[key];
          }
        }
        return new _ZodObject({
          ...this._def,
          shape: () => shape
        });
      }
      omit(mask) {
        const shape = {};
        for (const key of util.objectKeys(this.shape)) {
          if (!mask[key]) {
            shape[key] = this.shape[key];
          }
        }
        return new _ZodObject({
          ...this._def,
          shape: () => shape
        });
      }
      deepPartial() {
        return deepPartialify(this);
      }
      partial(mask) {
        const newShape = {};
        for (const key of util.objectKeys(this.shape)) {
          const fieldSchema = this.shape[key];
          if (mask && !mask[key]) {
            newShape[key] = fieldSchema;
          } else {
            newShape[key] = fieldSchema.optional();
          }
        }
        return new _ZodObject({
          ...this._def,
          shape: () => newShape
        });
      }
      required(mask) {
        const newShape = {};
        for (const key of util.objectKeys(this.shape)) {
          if (mask && !mask[key]) {
            newShape[key] = this.shape[key];
          } else {
            const fieldSchema = this.shape[key];
            let newField = fieldSchema;
            while (newField instanceof ZodOptional) {
              newField = newField._def.innerType;
            }
            newShape[key] = newField;
          }
        }
        return new _ZodObject({
          ...this._def,
          shape: () => newShape
        });
      }
      keyof() {
        return createZodEnum(util.objectKeys(this.shape));
      }
    };
    ZodObject.create = (shape, params) => {
      return new ZodObject({
        shape: () => shape,
        unknownKeys: "strip",
        catchall: ZodNever.create(),
        typeName: ZodFirstPartyTypeKind.ZodObject,
        ...processCreateParams(params)
      });
    };
    ZodObject.strictCreate = (shape, params) => {
      return new ZodObject({
        shape: () => shape,
        unknownKeys: "strict",
        catchall: ZodNever.create(),
        typeName: ZodFirstPartyTypeKind.ZodObject,
        ...processCreateParams(params)
      });
    };
    ZodObject.lazycreate = (shape, params) => {
      return new ZodObject({
        shape,
        unknownKeys: "strip",
        catchall: ZodNever.create(),
        typeName: ZodFirstPartyTypeKind.ZodObject,
        ...processCreateParams(params)
      });
    };
    ZodUnion = class extends ZodType {
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        const options = this._def.options;
        function handleResults(results) {
          for (const result of results) {
            if (result.result.status === "valid") {
              return result.result;
            }
          }
          for (const result of results) {
            if (result.result.status === "dirty") {
              ctx.common.issues.push(...result.ctx.common.issues);
              return result.result;
            }
          }
          const unionErrors = results.map((result) => new ZodError(result.ctx.common.issues));
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_union,
            unionErrors
          });
          return INVALID;
        }
        if (ctx.common.async) {
          return Promise.all(options.map(async (option) => {
            const childCtx = {
              ...ctx,
              common: {
                ...ctx.common,
                issues: []
              },
              parent: null
            };
            return {
              result: await option._parseAsync({
                data: ctx.data,
                path: ctx.path,
                parent: childCtx
              }),
              ctx: childCtx
            };
          })).then(handleResults);
        } else {
          let dirty = void 0;
          const issues = [];
          for (const option of options) {
            const childCtx = {
              ...ctx,
              common: {
                ...ctx.common,
                issues: []
              },
              parent: null
            };
            const result = option._parseSync({
              data: ctx.data,
              path: ctx.path,
              parent: childCtx
            });
            if (result.status === "valid") {
              return result;
            } else if (result.status === "dirty" && !dirty) {
              dirty = { result, ctx: childCtx };
            }
            if (childCtx.common.issues.length) {
              issues.push(childCtx.common.issues);
            }
          }
          if (dirty) {
            ctx.common.issues.push(...dirty.ctx.common.issues);
            return dirty.result;
          }
          const unionErrors = issues.map((issues2) => new ZodError(issues2));
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_union,
            unionErrors
          });
          return INVALID;
        }
      }
      get options() {
        return this._def.options;
      }
    };
    ZodUnion.create = (types2, params) => {
      return new ZodUnion({
        options: types2,
        typeName: ZodFirstPartyTypeKind.ZodUnion,
        ...processCreateParams(params)
      });
    };
    getDiscriminator = (type) => {
      if (type instanceof ZodLazy) {
        return getDiscriminator(type.schema);
      } else if (type instanceof ZodEffects) {
        return getDiscriminator(type.innerType());
      } else if (type instanceof ZodLiteral) {
        return [type.value];
      } else if (type instanceof ZodEnum) {
        return type.options;
      } else if (type instanceof ZodNativeEnum) {
        return util.objectValues(type.enum);
      } else if (type instanceof ZodDefault) {
        return getDiscriminator(type._def.innerType);
      } else if (type instanceof ZodUndefined) {
        return [void 0];
      } else if (type instanceof ZodNull) {
        return [null];
      } else if (type instanceof ZodOptional) {
        return [void 0, ...getDiscriminator(type.unwrap())];
      } else if (type instanceof ZodNullable) {
        return [null, ...getDiscriminator(type.unwrap())];
      } else if (type instanceof ZodBranded) {
        return getDiscriminator(type.unwrap());
      } else if (type instanceof ZodReadonly) {
        return getDiscriminator(type.unwrap());
      } else if (type instanceof ZodCatch) {
        return getDiscriminator(type._def.innerType);
      } else {
        return [];
      }
    };
    ZodDiscriminatedUnion = class _ZodDiscriminatedUnion extends ZodType {
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.object) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.object,
            received: ctx.parsedType
          });
          return INVALID;
        }
        const discriminator = this.discriminator;
        const discriminatorValue = ctx.data[discriminator];
        const option = this.optionsMap.get(discriminatorValue);
        if (!option) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_union_discriminator,
            options: Array.from(this.optionsMap.keys()),
            path: [discriminator]
          });
          return INVALID;
        }
        if (ctx.common.async) {
          return option._parseAsync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          });
        } else {
          return option._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          });
        }
      }
      get discriminator() {
        return this._def.discriminator;
      }
      get options() {
        return this._def.options;
      }
      get optionsMap() {
        return this._def.optionsMap;
      }
      static create(discriminator, options, params) {
        const optionsMap = /* @__PURE__ */ new Map();
        for (const type of options) {
          const discriminatorValues = getDiscriminator(type.shape[discriminator]);
          if (!discriminatorValues.length) {
            throw new Error(`A discriminator value for key \`${discriminator}\` could not be extracted from all schema options`);
          }
          for (const value of discriminatorValues) {
            if (optionsMap.has(value)) {
              throw new Error(`Discriminator property ${String(discriminator)} has duplicate value ${String(value)}`);
            }
            optionsMap.set(value, type);
          }
        }
        return new _ZodDiscriminatedUnion({
          typeName: ZodFirstPartyTypeKind.ZodDiscriminatedUnion,
          discriminator,
          options,
          optionsMap,
          ...processCreateParams(params)
        });
      }
    };
    ZodIntersection = class extends ZodType {
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        const handleParsed = (parsedLeft, parsedRight) => {
          if (isAborted(parsedLeft) || isAborted(parsedRight)) {
            return INVALID;
          }
          const merged = mergeValues(parsedLeft.value, parsedRight.value);
          if (!merged.valid) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.invalid_intersection_types
            });
            return INVALID;
          }
          if (isDirty(parsedLeft) || isDirty(parsedRight)) {
            status.dirty();
          }
          return { status: status.value, value: merged.data };
        };
        if (ctx.common.async) {
          return Promise.all([
            this._def.left._parseAsync({
              data: ctx.data,
              path: ctx.path,
              parent: ctx
            }),
            this._def.right._parseAsync({
              data: ctx.data,
              path: ctx.path,
              parent: ctx
            })
          ]).then(([left, right]) => handleParsed(left, right));
        } else {
          return handleParsed(this._def.left._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          }), this._def.right._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          }));
        }
      }
    };
    ZodIntersection.create = (left, right, params) => {
      return new ZodIntersection({
        left,
        right,
        typeName: ZodFirstPartyTypeKind.ZodIntersection,
        ...processCreateParams(params)
      });
    };
    ZodTuple = class _ZodTuple extends ZodType {
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.array) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.array,
            received: ctx.parsedType
          });
          return INVALID;
        }
        if (ctx.data.length < this._def.items.length) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_small,
            minimum: this._def.items.length,
            inclusive: true,
            exact: false,
            type: "array"
          });
          return INVALID;
        }
        const rest = this._def.rest;
        if (!rest && ctx.data.length > this._def.items.length) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_big,
            maximum: this._def.items.length,
            inclusive: true,
            exact: false,
            type: "array"
          });
          status.dirty();
        }
        const items = [...ctx.data].map((item, itemIndex) => {
          const schema = this._def.items[itemIndex] || this._def.rest;
          if (!schema)
            return null;
          return schema._parse(new ParseInputLazyPath(ctx, item, ctx.path, itemIndex));
        }).filter((x) => !!x);
        if (ctx.common.async) {
          return Promise.all(items).then((results) => {
            return ParseStatus.mergeArray(status, results);
          });
        } else {
          return ParseStatus.mergeArray(status, items);
        }
      }
      get items() {
        return this._def.items;
      }
      rest(rest) {
        return new _ZodTuple({
          ...this._def,
          rest
        });
      }
    };
    ZodTuple.create = (schemas, params) => {
      if (!Array.isArray(schemas)) {
        throw new Error("You must pass an array of schemas to z.tuple([ ... ])");
      }
      return new ZodTuple({
        items: schemas,
        typeName: ZodFirstPartyTypeKind.ZodTuple,
        rest: null,
        ...processCreateParams(params)
      });
    };
    ZodRecord = class _ZodRecord extends ZodType {
      get keySchema() {
        return this._def.keyType;
      }
      get valueSchema() {
        return this._def.valueType;
      }
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.object) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.object,
            received: ctx.parsedType
          });
          return INVALID;
        }
        const pairs = [];
        const keyType = this._def.keyType;
        const valueType = this._def.valueType;
        for (const key in ctx.data) {
          pairs.push({
            key: keyType._parse(new ParseInputLazyPath(ctx, key, ctx.path, key)),
            value: valueType._parse(new ParseInputLazyPath(ctx, ctx.data[key], ctx.path, key)),
            alwaysSet: key in ctx.data
          });
        }
        if (ctx.common.async) {
          return ParseStatus.mergeObjectAsync(status, pairs);
        } else {
          return ParseStatus.mergeObjectSync(status, pairs);
        }
      }
      get element() {
        return this._def.valueType;
      }
      static create(first, second, third) {
        if (second instanceof ZodType) {
          return new _ZodRecord({
            keyType: first,
            valueType: second,
            typeName: ZodFirstPartyTypeKind.ZodRecord,
            ...processCreateParams(third)
          });
        }
        return new _ZodRecord({
          keyType: ZodString.create(),
          valueType: first,
          typeName: ZodFirstPartyTypeKind.ZodRecord,
          ...processCreateParams(second)
        });
      }
    };
    ZodMap = class extends ZodType {
      get keySchema() {
        return this._def.keyType;
      }
      get valueSchema() {
        return this._def.valueType;
      }
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.map) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.map,
            received: ctx.parsedType
          });
          return INVALID;
        }
        const keyType = this._def.keyType;
        const valueType = this._def.valueType;
        const pairs = [...ctx.data.entries()].map(([key, value], index) => {
          return {
            key: keyType._parse(new ParseInputLazyPath(ctx, key, ctx.path, [index, "key"])),
            value: valueType._parse(new ParseInputLazyPath(ctx, value, ctx.path, [index, "value"]))
          };
        });
        if (ctx.common.async) {
          const finalMap = /* @__PURE__ */ new Map();
          return Promise.resolve().then(async () => {
            for (const pair of pairs) {
              const key = await pair.key;
              const value = await pair.value;
              if (key.status === "aborted" || value.status === "aborted") {
                return INVALID;
              }
              if (key.status === "dirty" || value.status === "dirty") {
                status.dirty();
              }
              finalMap.set(key.value, value.value);
            }
            return { status: status.value, value: finalMap };
          });
        } else {
          const finalMap = /* @__PURE__ */ new Map();
          for (const pair of pairs) {
            const key = pair.key;
            const value = pair.value;
            if (key.status === "aborted" || value.status === "aborted") {
              return INVALID;
            }
            if (key.status === "dirty" || value.status === "dirty") {
              status.dirty();
            }
            finalMap.set(key.value, value.value);
          }
          return { status: status.value, value: finalMap };
        }
      }
    };
    ZodMap.create = (keyType, valueType, params) => {
      return new ZodMap({
        valueType,
        keyType,
        typeName: ZodFirstPartyTypeKind.ZodMap,
        ...processCreateParams(params)
      });
    };
    ZodSet = class _ZodSet extends ZodType {
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.set) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.set,
            received: ctx.parsedType
          });
          return INVALID;
        }
        const def = this._def;
        if (def.minSize !== null) {
          if (ctx.data.size < def.minSize.value) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_small,
              minimum: def.minSize.value,
              type: "set",
              inclusive: true,
              exact: false,
              message: def.minSize.message
            });
            status.dirty();
          }
        }
        if (def.maxSize !== null) {
          if (ctx.data.size > def.maxSize.value) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_big,
              maximum: def.maxSize.value,
              type: "set",
              inclusive: true,
              exact: false,
              message: def.maxSize.message
            });
            status.dirty();
          }
        }
        const valueType = this._def.valueType;
        function finalizeSet(elements2) {
          const parsedSet = /* @__PURE__ */ new Set();
          for (const element of elements2) {
            if (element.status === "aborted")
              return INVALID;
            if (element.status === "dirty")
              status.dirty();
            parsedSet.add(element.value);
          }
          return { status: status.value, value: parsedSet };
        }
        const elements = [...ctx.data.values()].map((item, i2) => valueType._parse(new ParseInputLazyPath(ctx, item, ctx.path, i2)));
        if (ctx.common.async) {
          return Promise.all(elements).then((elements2) => finalizeSet(elements2));
        } else {
          return finalizeSet(elements);
        }
      }
      min(minSize, message) {
        return new _ZodSet({
          ...this._def,
          minSize: { value: minSize, message: errorUtil.toString(message) }
        });
      }
      max(maxSize, message) {
        return new _ZodSet({
          ...this._def,
          maxSize: { value: maxSize, message: errorUtil.toString(message) }
        });
      }
      size(size, message) {
        return this.min(size, message).max(size, message);
      }
      nonempty(message) {
        return this.min(1, message);
      }
    };
    ZodSet.create = (valueType, params) => {
      return new ZodSet({
        valueType,
        minSize: null,
        maxSize: null,
        typeName: ZodFirstPartyTypeKind.ZodSet,
        ...processCreateParams(params)
      });
    };
    ZodFunction = class _ZodFunction extends ZodType {
      constructor() {
        super(...arguments);
        this.validate = this.implement;
      }
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.function) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.function,
            received: ctx.parsedType
          });
          return INVALID;
        }
        function makeArgsIssue(args2, error2) {
          return makeIssue({
            data: args2,
            path: ctx.path,
            errorMaps: [ctx.common.contextualErrorMap, ctx.schemaErrorMap, getErrorMap(), en_default].filter((x) => !!x),
            issueData: {
              code: ZodIssueCode.invalid_arguments,
              argumentsError: error2
            }
          });
        }
        function makeReturnsIssue(returns, error2) {
          return makeIssue({
            data: returns,
            path: ctx.path,
            errorMaps: [ctx.common.contextualErrorMap, ctx.schemaErrorMap, getErrorMap(), en_default].filter((x) => !!x),
            issueData: {
              code: ZodIssueCode.invalid_return_type,
              returnTypeError: error2
            }
          });
        }
        const params = { errorMap: ctx.common.contextualErrorMap };
        const fn = ctx.data;
        if (this._def.returns instanceof ZodPromise) {
          const me = this;
          return OK(async function(...args2) {
            const error2 = new ZodError([]);
            const parsedArgs = await me._def.args.parseAsync(args2, params).catch((e) => {
              error2.addIssue(makeArgsIssue(args2, e));
              throw error2;
            });
            const result = await Reflect.apply(fn, this, parsedArgs);
            const parsedReturns = await me._def.returns._def.type.parseAsync(result, params).catch((e) => {
              error2.addIssue(makeReturnsIssue(result, e));
              throw error2;
            });
            return parsedReturns;
          });
        } else {
          const me = this;
          return OK(function(...args2) {
            const parsedArgs = me._def.args.safeParse(args2, params);
            if (!parsedArgs.success) {
              throw new ZodError([makeArgsIssue(args2, parsedArgs.error)]);
            }
            const result = Reflect.apply(fn, this, parsedArgs.data);
            const parsedReturns = me._def.returns.safeParse(result, params);
            if (!parsedReturns.success) {
              throw new ZodError([makeReturnsIssue(result, parsedReturns.error)]);
            }
            return parsedReturns.data;
          });
        }
      }
      parameters() {
        return this._def.args;
      }
      returnType() {
        return this._def.returns;
      }
      args(...items) {
        return new _ZodFunction({
          ...this._def,
          args: ZodTuple.create(items).rest(ZodUnknown.create())
        });
      }
      returns(returnType) {
        return new _ZodFunction({
          ...this._def,
          returns: returnType
        });
      }
      implement(func2) {
        const validatedFunc = this.parse(func2);
        return validatedFunc;
      }
      strictImplement(func2) {
        const validatedFunc = this.parse(func2);
        return validatedFunc;
      }
      static create(args2, returns, params) {
        return new _ZodFunction({
          args: args2 ? args2 : ZodTuple.create([]).rest(ZodUnknown.create()),
          returns: returns || ZodUnknown.create(),
          typeName: ZodFirstPartyTypeKind.ZodFunction,
          ...processCreateParams(params)
        });
      }
    };
    ZodLazy = class extends ZodType {
      get schema() {
        return this._def.getter();
      }
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        const lazySchema = this._def.getter();
        return lazySchema._parse({ data: ctx.data, path: ctx.path, parent: ctx });
      }
    };
    ZodLazy.create = (getter, params) => {
      return new ZodLazy({
        getter,
        typeName: ZodFirstPartyTypeKind.ZodLazy,
        ...processCreateParams(params)
      });
    };
    ZodLiteral = class extends ZodType {
      _parse(input) {
        if (input.data !== this._def.value) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            received: ctx.data,
            code: ZodIssueCode.invalid_literal,
            expected: this._def.value
          });
          return INVALID;
        }
        return { status: "valid", value: input.data };
      }
      get value() {
        return this._def.value;
      }
    };
    ZodLiteral.create = (value, params) => {
      return new ZodLiteral({
        value,
        typeName: ZodFirstPartyTypeKind.ZodLiteral,
        ...processCreateParams(params)
      });
    };
    ZodEnum = class _ZodEnum extends ZodType {
      _parse(input) {
        if (typeof input.data !== "string") {
          const ctx = this._getOrReturnCtx(input);
          const expectedValues = this._def.values;
          addIssueToContext(ctx, {
            expected: util.joinValues(expectedValues),
            received: ctx.parsedType,
            code: ZodIssueCode.invalid_type
          });
          return INVALID;
        }
        if (!this._cache) {
          this._cache = new Set(this._def.values);
        }
        if (!this._cache.has(input.data)) {
          const ctx = this._getOrReturnCtx(input);
          const expectedValues = this._def.values;
          addIssueToContext(ctx, {
            received: ctx.data,
            code: ZodIssueCode.invalid_enum_value,
            options: expectedValues
          });
          return INVALID;
        }
        return OK(input.data);
      }
      get options() {
        return this._def.values;
      }
      get enum() {
        const enumValues = {};
        for (const val of this._def.values) {
          enumValues[val] = val;
        }
        return enumValues;
      }
      get Values() {
        const enumValues = {};
        for (const val of this._def.values) {
          enumValues[val] = val;
        }
        return enumValues;
      }
      get Enum() {
        const enumValues = {};
        for (const val of this._def.values) {
          enumValues[val] = val;
        }
        return enumValues;
      }
      extract(values, newDef = this._def) {
        return _ZodEnum.create(values, {
          ...this._def,
          ...newDef
        });
      }
      exclude(values, newDef = this._def) {
        return _ZodEnum.create(this.options.filter((opt) => !values.includes(opt)), {
          ...this._def,
          ...newDef
        });
      }
    };
    ZodEnum.create = createZodEnum;
    ZodNativeEnum = class extends ZodType {
      _parse(input) {
        const nativeEnumValues = util.getValidEnumValues(this._def.values);
        const ctx = this._getOrReturnCtx(input);
        if (ctx.parsedType !== ZodParsedType.string && ctx.parsedType !== ZodParsedType.number) {
          const expectedValues = util.objectValues(nativeEnumValues);
          addIssueToContext(ctx, {
            expected: util.joinValues(expectedValues),
            received: ctx.parsedType,
            code: ZodIssueCode.invalid_type
          });
          return INVALID;
        }
        if (!this._cache) {
          this._cache = new Set(util.getValidEnumValues(this._def.values));
        }
        if (!this._cache.has(input.data)) {
          const expectedValues = util.objectValues(nativeEnumValues);
          addIssueToContext(ctx, {
            received: ctx.data,
            code: ZodIssueCode.invalid_enum_value,
            options: expectedValues
          });
          return INVALID;
        }
        return OK(input.data);
      }
      get enum() {
        return this._def.values;
      }
    };
    ZodNativeEnum.create = (values, params) => {
      return new ZodNativeEnum({
        values,
        typeName: ZodFirstPartyTypeKind.ZodNativeEnum,
        ...processCreateParams(params)
      });
    };
    ZodPromise = class extends ZodType {
      unwrap() {
        return this._def.type;
      }
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.promise && ctx.common.async === false) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.promise,
            received: ctx.parsedType
          });
          return INVALID;
        }
        const promisified = ctx.parsedType === ZodParsedType.promise ? ctx.data : Promise.resolve(ctx.data);
        return OK(promisified.then((data) => {
          return this._def.type.parseAsync(data, {
            path: ctx.path,
            errorMap: ctx.common.contextualErrorMap
          });
        }));
      }
    };
    ZodPromise.create = (schema, params) => {
      return new ZodPromise({
        type: schema,
        typeName: ZodFirstPartyTypeKind.ZodPromise,
        ...processCreateParams(params)
      });
    };
    ZodEffects = class extends ZodType {
      innerType() {
        return this._def.schema;
      }
      sourceType() {
        return this._def.schema._def.typeName === ZodFirstPartyTypeKind.ZodEffects ? this._def.schema.sourceType() : this._def.schema;
      }
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        const effect = this._def.effect || null;
        const checkCtx = {
          addIssue: (arg) => {
            addIssueToContext(ctx, arg);
            if (arg.fatal) {
              status.abort();
            } else {
              status.dirty();
            }
          },
          get path() {
            return ctx.path;
          }
        };
        checkCtx.addIssue = checkCtx.addIssue.bind(checkCtx);
        if (effect.type === "preprocess") {
          const processed = effect.transform(ctx.data, checkCtx);
          if (ctx.common.async) {
            return Promise.resolve(processed).then(async (processed2) => {
              if (status.value === "aborted")
                return INVALID;
              const result = await this._def.schema._parseAsync({
                data: processed2,
                path: ctx.path,
                parent: ctx
              });
              if (result.status === "aborted")
                return INVALID;
              if (result.status === "dirty")
                return DIRTY(result.value);
              if (status.value === "dirty")
                return DIRTY(result.value);
              return result;
            });
          } else {
            if (status.value === "aborted")
              return INVALID;
            const result = this._def.schema._parseSync({
              data: processed,
              path: ctx.path,
              parent: ctx
            });
            if (result.status === "aborted")
              return INVALID;
            if (result.status === "dirty")
              return DIRTY(result.value);
            if (status.value === "dirty")
              return DIRTY(result.value);
            return result;
          }
        }
        if (effect.type === "refinement") {
          const executeRefinement = (acc) => {
            const result = effect.refinement(acc, checkCtx);
            if (ctx.common.async) {
              return Promise.resolve(result);
            }
            if (result instanceof Promise) {
              throw new Error("Async refinement encountered during synchronous parse operation. Use .parseAsync instead.");
            }
            return acc;
          };
          if (ctx.common.async === false) {
            const inner = this._def.schema._parseSync({
              data: ctx.data,
              path: ctx.path,
              parent: ctx
            });
            if (inner.status === "aborted")
              return INVALID;
            if (inner.status === "dirty")
              status.dirty();
            executeRefinement(inner.value);
            return { status: status.value, value: inner.value };
          } else {
            return this._def.schema._parseAsync({ data: ctx.data, path: ctx.path, parent: ctx }).then((inner) => {
              if (inner.status === "aborted")
                return INVALID;
              if (inner.status === "dirty")
                status.dirty();
              return executeRefinement(inner.value).then(() => {
                return { status: status.value, value: inner.value };
              });
            });
          }
        }
        if (effect.type === "transform") {
          if (ctx.common.async === false) {
            const base2 = this._def.schema._parseSync({
              data: ctx.data,
              path: ctx.path,
              parent: ctx
            });
            if (!isValid(base2))
              return INVALID;
            const result = effect.transform(base2.value, checkCtx);
            if (result instanceof Promise) {
              throw new Error(`Asynchronous transform encountered during synchronous parse operation. Use .parseAsync instead.`);
            }
            return { status: status.value, value: result };
          } else {
            return this._def.schema._parseAsync({ data: ctx.data, path: ctx.path, parent: ctx }).then((base2) => {
              if (!isValid(base2))
                return INVALID;
              return Promise.resolve(effect.transform(base2.value, checkCtx)).then((result) => ({
                status: status.value,
                value: result
              }));
            });
          }
        }
        util.assertNever(effect);
      }
    };
    ZodEffects.create = (schema, effect, params) => {
      return new ZodEffects({
        schema,
        typeName: ZodFirstPartyTypeKind.ZodEffects,
        effect,
        ...processCreateParams(params)
      });
    };
    ZodEffects.createWithPreprocess = (preprocess, schema, params) => {
      return new ZodEffects({
        schema,
        effect: { type: "preprocess", transform: preprocess },
        typeName: ZodFirstPartyTypeKind.ZodEffects,
        ...processCreateParams(params)
      });
    };
    ZodOptional = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType === ZodParsedType.undefined) {
          return OK(void 0);
        }
        return this._def.innerType._parse(input);
      }
      unwrap() {
        return this._def.innerType;
      }
    };
    ZodOptional.create = (type, params) => {
      return new ZodOptional({
        innerType: type,
        typeName: ZodFirstPartyTypeKind.ZodOptional,
        ...processCreateParams(params)
      });
    };
    ZodNullable = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType === ZodParsedType.null) {
          return OK(null);
        }
        return this._def.innerType._parse(input);
      }
      unwrap() {
        return this._def.innerType;
      }
    };
    ZodNullable.create = (type, params) => {
      return new ZodNullable({
        innerType: type,
        typeName: ZodFirstPartyTypeKind.ZodNullable,
        ...processCreateParams(params)
      });
    };
    ZodDefault = class extends ZodType {
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        let data = ctx.data;
        if (ctx.parsedType === ZodParsedType.undefined) {
          data = this._def.defaultValue();
        }
        return this._def.innerType._parse({
          data,
          path: ctx.path,
          parent: ctx
        });
      }
      removeDefault() {
        return this._def.innerType;
      }
    };
    ZodDefault.create = (type, params) => {
      return new ZodDefault({
        innerType: type,
        typeName: ZodFirstPartyTypeKind.ZodDefault,
        defaultValue: typeof params.default === "function" ? params.default : () => params.default,
        ...processCreateParams(params)
      });
    };
    ZodCatch = class extends ZodType {
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        const newCtx = {
          ...ctx,
          common: {
            ...ctx.common,
            issues: []
          }
        };
        const result = this._def.innerType._parse({
          data: newCtx.data,
          path: newCtx.path,
          parent: {
            ...newCtx
          }
        });
        if (isAsync(result)) {
          return result.then((result2) => {
            return {
              status: "valid",
              value: result2.status === "valid" ? result2.value : this._def.catchValue({
                get error() {
                  return new ZodError(newCtx.common.issues);
                },
                input: newCtx.data
              })
            };
          });
        } else {
          return {
            status: "valid",
            value: result.status === "valid" ? result.value : this._def.catchValue({
              get error() {
                return new ZodError(newCtx.common.issues);
              },
              input: newCtx.data
            })
          };
        }
      }
      removeCatch() {
        return this._def.innerType;
      }
    };
    ZodCatch.create = (type, params) => {
      return new ZodCatch({
        innerType: type,
        typeName: ZodFirstPartyTypeKind.ZodCatch,
        catchValue: typeof params.catch === "function" ? params.catch : () => params.catch,
        ...processCreateParams(params)
      });
    };
    ZodNaN = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.nan) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.nan,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return { status: "valid", value: input.data };
      }
    };
    ZodNaN.create = (params) => {
      return new ZodNaN({
        typeName: ZodFirstPartyTypeKind.ZodNaN,
        ...processCreateParams(params)
      });
    };
    BRAND = Symbol("zod_brand");
    ZodBranded = class extends ZodType {
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        const data = ctx.data;
        return this._def.type._parse({
          data,
          path: ctx.path,
          parent: ctx
        });
      }
      unwrap() {
        return this._def.type;
      }
    };
    ZodPipeline = class _ZodPipeline extends ZodType {
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        if (ctx.common.async) {
          const handleAsync = async () => {
            const inResult = await this._def.in._parseAsync({
              data: ctx.data,
              path: ctx.path,
              parent: ctx
            });
            if (inResult.status === "aborted")
              return INVALID;
            if (inResult.status === "dirty") {
              status.dirty();
              return DIRTY(inResult.value);
            } else {
              return this._def.out._parseAsync({
                data: inResult.value,
                path: ctx.path,
                parent: ctx
              });
            }
          };
          return handleAsync();
        } else {
          const inResult = this._def.in._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          });
          if (inResult.status === "aborted")
            return INVALID;
          if (inResult.status === "dirty") {
            status.dirty();
            return {
              status: "dirty",
              value: inResult.value
            };
          } else {
            return this._def.out._parseSync({
              data: inResult.value,
              path: ctx.path,
              parent: ctx
            });
          }
        }
      }
      static create(a, b) {
        return new _ZodPipeline({
          in: a,
          out: b,
          typeName: ZodFirstPartyTypeKind.ZodPipeline
        });
      }
    };
    ZodReadonly = class extends ZodType {
      _parse(input) {
        const result = this._def.innerType._parse(input);
        const freeze = (data) => {
          if (isValid(data)) {
            data.value = Object.freeze(data.value);
          }
          return data;
        };
        return isAsync(result) ? result.then((data) => freeze(data)) : freeze(result);
      }
      unwrap() {
        return this._def.innerType;
      }
    };
    ZodReadonly.create = (type, params) => {
      return new ZodReadonly({
        innerType: type,
        typeName: ZodFirstPartyTypeKind.ZodReadonly,
        ...processCreateParams(params)
      });
    };
    late = {
      object: ZodObject.lazycreate
    };
    (function(ZodFirstPartyTypeKind2) {
      ZodFirstPartyTypeKind2["ZodString"] = "ZodString";
      ZodFirstPartyTypeKind2["ZodNumber"] = "ZodNumber";
      ZodFirstPartyTypeKind2["ZodNaN"] = "ZodNaN";
      ZodFirstPartyTypeKind2["ZodBigInt"] = "ZodBigInt";
      ZodFirstPartyTypeKind2["ZodBoolean"] = "ZodBoolean";
      ZodFirstPartyTypeKind2["ZodDate"] = "ZodDate";
      ZodFirstPartyTypeKind2["ZodSymbol"] = "ZodSymbol";
      ZodFirstPartyTypeKind2["ZodUndefined"] = "ZodUndefined";
      ZodFirstPartyTypeKind2["ZodNull"] = "ZodNull";
      ZodFirstPartyTypeKind2["ZodAny"] = "ZodAny";
      ZodFirstPartyTypeKind2["ZodUnknown"] = "ZodUnknown";
      ZodFirstPartyTypeKind2["ZodNever"] = "ZodNever";
      ZodFirstPartyTypeKind2["ZodVoid"] = "ZodVoid";
      ZodFirstPartyTypeKind2["ZodArray"] = "ZodArray";
      ZodFirstPartyTypeKind2["ZodObject"] = "ZodObject";
      ZodFirstPartyTypeKind2["ZodUnion"] = "ZodUnion";
      ZodFirstPartyTypeKind2["ZodDiscriminatedUnion"] = "ZodDiscriminatedUnion";
      ZodFirstPartyTypeKind2["ZodIntersection"] = "ZodIntersection";
      ZodFirstPartyTypeKind2["ZodTuple"] = "ZodTuple";
      ZodFirstPartyTypeKind2["ZodRecord"] = "ZodRecord";
      ZodFirstPartyTypeKind2["ZodMap"] = "ZodMap";
      ZodFirstPartyTypeKind2["ZodSet"] = "ZodSet";
      ZodFirstPartyTypeKind2["ZodFunction"] = "ZodFunction";
      ZodFirstPartyTypeKind2["ZodLazy"] = "ZodLazy";
      ZodFirstPartyTypeKind2["ZodLiteral"] = "ZodLiteral";
      ZodFirstPartyTypeKind2["ZodEnum"] = "ZodEnum";
      ZodFirstPartyTypeKind2["ZodEffects"] = "ZodEffects";
      ZodFirstPartyTypeKind2["ZodNativeEnum"] = "ZodNativeEnum";
      ZodFirstPartyTypeKind2["ZodOptional"] = "ZodOptional";
      ZodFirstPartyTypeKind2["ZodNullable"] = "ZodNullable";
      ZodFirstPartyTypeKind2["ZodDefault"] = "ZodDefault";
      ZodFirstPartyTypeKind2["ZodCatch"] = "ZodCatch";
      ZodFirstPartyTypeKind2["ZodPromise"] = "ZodPromise";
      ZodFirstPartyTypeKind2["ZodBranded"] = "ZodBranded";
      ZodFirstPartyTypeKind2["ZodPipeline"] = "ZodPipeline";
      ZodFirstPartyTypeKind2["ZodReadonly"] = "ZodReadonly";
    })(ZodFirstPartyTypeKind || (ZodFirstPartyTypeKind = {}));
    instanceOfType = (cls, params = {
      message: `Input not instance of ${cls.name}`
    }) => custom((data) => data instanceof cls, params);
    stringType = ZodString.create;
    numberType = ZodNumber.create;
    nanType = ZodNaN.create;
    bigIntType = ZodBigInt.create;
    booleanType = ZodBoolean.create;
    dateType = ZodDate.create;
    symbolType = ZodSymbol.create;
    undefinedType = ZodUndefined.create;
    nullType = ZodNull.create;
    anyType = ZodAny.create;
    unknownType = ZodUnknown.create;
    neverType = ZodNever.create;
    voidType = ZodVoid.create;
    arrayType = ZodArray.create;
    objectType = ZodObject.create;
    strictObjectType = ZodObject.strictCreate;
    unionType = ZodUnion.create;
    discriminatedUnionType = ZodDiscriminatedUnion.create;
    intersectionType = ZodIntersection.create;
    tupleType = ZodTuple.create;
    recordType = ZodRecord.create;
    mapType = ZodMap.create;
    setType = ZodSet.create;
    functionType = ZodFunction.create;
    lazyType = ZodLazy.create;
    literalType = ZodLiteral.create;
    enumType = ZodEnum.create;
    nativeEnumType = ZodNativeEnum.create;
    promiseType = ZodPromise.create;
    effectsType = ZodEffects.create;
    optionalType = ZodOptional.create;
    nullableType = ZodNullable.create;
    preprocessType = ZodEffects.createWithPreprocess;
    pipelineType = ZodPipeline.create;
    ostring = () => stringType().optional();
    onumber = () => numberType().optional();
    oboolean = () => booleanType().optional();
    coerce = {
      string: (arg) => ZodString.create({ ...arg, coerce: true }),
      number: (arg) => ZodNumber.create({ ...arg, coerce: true }),
      boolean: (arg) => ZodBoolean.create({
        ...arg,
        coerce: true
      }),
      bigint: (arg) => ZodBigInt.create({ ...arg, coerce: true }),
      date: (arg) => ZodDate.create({ ...arg, coerce: true })
    };
    NEVER = INVALID;
    LATEST_PROTOCOL_VERSION = "2025-06-18";
    SUPPORTED_PROTOCOL_VERSIONS = [
      LATEST_PROTOCOL_VERSION,
      "2025-03-26",
      "2024-11-05",
      "2024-10-07"
    ];
    JSONRPC_VERSION = "2.0";
    ProgressTokenSchema = exports_external.union([exports_external.string(), exports_external.number().int()]);
    CursorSchema = exports_external.string();
    RequestMetaSchema = exports_external.object({
      progressToken: exports_external.optional(ProgressTokenSchema)
    }).passthrough();
    BaseRequestParamsSchema = exports_external.object({
      _meta: exports_external.optional(RequestMetaSchema)
    }).passthrough();
    RequestSchema = exports_external.object({
      method: exports_external.string(),
      params: exports_external.optional(BaseRequestParamsSchema)
    });
    BaseNotificationParamsSchema = exports_external.object({
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    }).passthrough();
    NotificationSchema = exports_external.object({
      method: exports_external.string(),
      params: exports_external.optional(BaseNotificationParamsSchema)
    });
    ResultSchema = exports_external.object({
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    }).passthrough();
    RequestIdSchema = exports_external.union([exports_external.string(), exports_external.number().int()]);
    JSONRPCRequestSchema = exports_external.object({
      jsonrpc: exports_external.literal(JSONRPC_VERSION),
      id: RequestIdSchema
    }).merge(RequestSchema).strict();
    isJSONRPCRequest = (value) => JSONRPCRequestSchema.safeParse(value).success;
    JSONRPCNotificationSchema = exports_external.object({
      jsonrpc: exports_external.literal(JSONRPC_VERSION)
    }).merge(NotificationSchema).strict();
    isJSONRPCNotification = (value) => JSONRPCNotificationSchema.safeParse(value).success;
    JSONRPCResponseSchema = exports_external.object({
      jsonrpc: exports_external.literal(JSONRPC_VERSION),
      id: RequestIdSchema,
      result: ResultSchema
    }).strict();
    isJSONRPCResponse = (value) => JSONRPCResponseSchema.safeParse(value).success;
    (function(ErrorCode2) {
      ErrorCode2[ErrorCode2["ConnectionClosed"] = -32e3] = "ConnectionClosed";
      ErrorCode2[ErrorCode2["RequestTimeout"] = -32001] = "RequestTimeout";
      ErrorCode2[ErrorCode2["ParseError"] = -32700] = "ParseError";
      ErrorCode2[ErrorCode2["InvalidRequest"] = -32600] = "InvalidRequest";
      ErrorCode2[ErrorCode2["MethodNotFound"] = -32601] = "MethodNotFound";
      ErrorCode2[ErrorCode2["InvalidParams"] = -32602] = "InvalidParams";
      ErrorCode2[ErrorCode2["InternalError"] = -32603] = "InternalError";
    })(ErrorCode || (ErrorCode = {}));
    JSONRPCErrorSchema = exports_external.object({
      jsonrpc: exports_external.literal(JSONRPC_VERSION),
      id: RequestIdSchema,
      error: exports_external.object({
        code: exports_external.number().int(),
        message: exports_external.string(),
        data: exports_external.optional(exports_external.unknown())
      })
    }).strict();
    isJSONRPCError = (value) => JSONRPCErrorSchema.safeParse(value).success;
    JSONRPCMessageSchema = exports_external.union([
      JSONRPCRequestSchema,
      JSONRPCNotificationSchema,
      JSONRPCResponseSchema,
      JSONRPCErrorSchema
    ]);
    EmptyResultSchema = ResultSchema.strict();
    CancelledNotificationSchema = NotificationSchema.extend({
      method: exports_external.literal("notifications/cancelled"),
      params: BaseNotificationParamsSchema.extend({
        requestId: RequestIdSchema,
        reason: exports_external.string().optional()
      })
    });
    BaseMetadataSchema = exports_external.object({
      name: exports_external.string(),
      title: exports_external.optional(exports_external.string())
    }).passthrough();
    ImplementationSchema = BaseMetadataSchema.extend({
      version: exports_external.string()
    });
    ClientCapabilitiesSchema = exports_external.object({
      experimental: exports_external.optional(exports_external.object({}).passthrough()),
      sampling: exports_external.optional(exports_external.object({}).passthrough()),
      elicitation: exports_external.optional(exports_external.object({}).passthrough()),
      roots: exports_external.optional(exports_external.object({
        listChanged: exports_external.optional(exports_external.boolean())
      }).passthrough())
    }).passthrough();
    InitializeRequestSchema = RequestSchema.extend({
      method: exports_external.literal("initialize"),
      params: BaseRequestParamsSchema.extend({
        protocolVersion: exports_external.string(),
        capabilities: ClientCapabilitiesSchema,
        clientInfo: ImplementationSchema
      })
    });
    ServerCapabilitiesSchema = exports_external.object({
      experimental: exports_external.optional(exports_external.object({}).passthrough()),
      logging: exports_external.optional(exports_external.object({}).passthrough()),
      completions: exports_external.optional(exports_external.object({}).passthrough()),
      prompts: exports_external.optional(exports_external.object({
        listChanged: exports_external.optional(exports_external.boolean())
      }).passthrough()),
      resources: exports_external.optional(exports_external.object({
        subscribe: exports_external.optional(exports_external.boolean()),
        listChanged: exports_external.optional(exports_external.boolean())
      }).passthrough()),
      tools: exports_external.optional(exports_external.object({
        listChanged: exports_external.optional(exports_external.boolean())
      }).passthrough())
    }).passthrough();
    InitializeResultSchema = ResultSchema.extend({
      protocolVersion: exports_external.string(),
      capabilities: ServerCapabilitiesSchema,
      serverInfo: ImplementationSchema,
      instructions: exports_external.optional(exports_external.string())
    });
    InitializedNotificationSchema = NotificationSchema.extend({
      method: exports_external.literal("notifications/initialized")
    });
    PingRequestSchema = RequestSchema.extend({
      method: exports_external.literal("ping")
    });
    ProgressSchema = exports_external.object({
      progress: exports_external.number(),
      total: exports_external.optional(exports_external.number()),
      message: exports_external.optional(exports_external.string())
    }).passthrough();
    ProgressNotificationSchema = NotificationSchema.extend({
      method: exports_external.literal("notifications/progress"),
      params: BaseNotificationParamsSchema.merge(ProgressSchema).extend({
        progressToken: ProgressTokenSchema
      })
    });
    PaginatedRequestSchema = RequestSchema.extend({
      params: BaseRequestParamsSchema.extend({
        cursor: exports_external.optional(CursorSchema)
      }).optional()
    });
    PaginatedResultSchema = ResultSchema.extend({
      nextCursor: exports_external.optional(CursorSchema)
    });
    ResourceContentsSchema = exports_external.object({
      uri: exports_external.string(),
      mimeType: exports_external.optional(exports_external.string()),
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    }).passthrough();
    TextResourceContentsSchema = ResourceContentsSchema.extend({
      text: exports_external.string()
    });
    Base64Schema = exports_external.string().refine((val) => {
      try {
        atob(val);
        return true;
      } catch (_a17) {
        return false;
      }
    }, { message: "Invalid Base64 string" });
    BlobResourceContentsSchema = ResourceContentsSchema.extend({
      blob: Base64Schema
    });
    ResourceSchema = BaseMetadataSchema.extend({
      uri: exports_external.string(),
      description: exports_external.optional(exports_external.string()),
      mimeType: exports_external.optional(exports_external.string()),
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    });
    ResourceTemplateSchema = BaseMetadataSchema.extend({
      uriTemplate: exports_external.string(),
      description: exports_external.optional(exports_external.string()),
      mimeType: exports_external.optional(exports_external.string()),
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    });
    ListResourcesRequestSchema = PaginatedRequestSchema.extend({
      method: exports_external.literal("resources/list")
    });
    ListResourcesResultSchema = PaginatedResultSchema.extend({
      resources: exports_external.array(ResourceSchema)
    });
    ListResourceTemplatesRequestSchema = PaginatedRequestSchema.extend({
      method: exports_external.literal("resources/templates/list")
    });
    ListResourceTemplatesResultSchema = PaginatedResultSchema.extend({
      resourceTemplates: exports_external.array(ResourceTemplateSchema)
    });
    ReadResourceRequestSchema = RequestSchema.extend({
      method: exports_external.literal("resources/read"),
      params: BaseRequestParamsSchema.extend({
        uri: exports_external.string()
      })
    });
    ReadResourceResultSchema = ResultSchema.extend({
      contents: exports_external.array(exports_external.union([TextResourceContentsSchema, BlobResourceContentsSchema]))
    });
    ResourceListChangedNotificationSchema = NotificationSchema.extend({
      method: exports_external.literal("notifications/resources/list_changed")
    });
    SubscribeRequestSchema = RequestSchema.extend({
      method: exports_external.literal("resources/subscribe"),
      params: BaseRequestParamsSchema.extend({
        uri: exports_external.string()
      })
    });
    UnsubscribeRequestSchema = RequestSchema.extend({
      method: exports_external.literal("resources/unsubscribe"),
      params: BaseRequestParamsSchema.extend({
        uri: exports_external.string()
      })
    });
    ResourceUpdatedNotificationSchema = NotificationSchema.extend({
      method: exports_external.literal("notifications/resources/updated"),
      params: BaseNotificationParamsSchema.extend({
        uri: exports_external.string()
      })
    });
    PromptArgumentSchema = exports_external.object({
      name: exports_external.string(),
      description: exports_external.optional(exports_external.string()),
      required: exports_external.optional(exports_external.boolean())
    }).passthrough();
    PromptSchema = BaseMetadataSchema.extend({
      description: exports_external.optional(exports_external.string()),
      arguments: exports_external.optional(exports_external.array(PromptArgumentSchema)),
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    });
    ListPromptsRequestSchema = PaginatedRequestSchema.extend({
      method: exports_external.literal("prompts/list")
    });
    ListPromptsResultSchema = PaginatedResultSchema.extend({
      prompts: exports_external.array(PromptSchema)
    });
    GetPromptRequestSchema = RequestSchema.extend({
      method: exports_external.literal("prompts/get"),
      params: BaseRequestParamsSchema.extend({
        name: exports_external.string(),
        arguments: exports_external.optional(exports_external.record(exports_external.string()))
      })
    });
    TextContentSchema = exports_external.object({
      type: exports_external.literal("text"),
      text: exports_external.string(),
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    }).passthrough();
    ImageContentSchema = exports_external.object({
      type: exports_external.literal("image"),
      data: Base64Schema,
      mimeType: exports_external.string(),
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    }).passthrough();
    AudioContentSchema = exports_external.object({
      type: exports_external.literal("audio"),
      data: Base64Schema,
      mimeType: exports_external.string(),
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    }).passthrough();
    EmbeddedResourceSchema = exports_external.object({
      type: exports_external.literal("resource"),
      resource: exports_external.union([TextResourceContentsSchema, BlobResourceContentsSchema]),
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    }).passthrough();
    ResourceLinkSchema = ResourceSchema.extend({
      type: exports_external.literal("resource_link")
    });
    ContentBlockSchema = exports_external.union([
      TextContentSchema,
      ImageContentSchema,
      AudioContentSchema,
      ResourceLinkSchema,
      EmbeddedResourceSchema
    ]);
    PromptMessageSchema = exports_external.object({
      role: exports_external.enum(["user", "assistant"]),
      content: ContentBlockSchema
    }).passthrough();
    GetPromptResultSchema = ResultSchema.extend({
      description: exports_external.optional(exports_external.string()),
      messages: exports_external.array(PromptMessageSchema)
    });
    PromptListChangedNotificationSchema = NotificationSchema.extend({
      method: exports_external.literal("notifications/prompts/list_changed")
    });
    ToolAnnotationsSchema = exports_external.object({
      title: exports_external.optional(exports_external.string()),
      readOnlyHint: exports_external.optional(exports_external.boolean()),
      destructiveHint: exports_external.optional(exports_external.boolean()),
      idempotentHint: exports_external.optional(exports_external.boolean()),
      openWorldHint: exports_external.optional(exports_external.boolean())
    }).passthrough();
    ToolSchema = BaseMetadataSchema.extend({
      description: exports_external.optional(exports_external.string()),
      inputSchema: exports_external.object({
        type: exports_external.literal("object"),
        properties: exports_external.optional(exports_external.object({}).passthrough()),
        required: exports_external.optional(exports_external.array(exports_external.string()))
      }).passthrough(),
      outputSchema: exports_external.optional(exports_external.object({
        type: exports_external.literal("object"),
        properties: exports_external.optional(exports_external.object({}).passthrough()),
        required: exports_external.optional(exports_external.array(exports_external.string()))
      }).passthrough()),
      annotations: exports_external.optional(ToolAnnotationsSchema),
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    });
    ListToolsRequestSchema = PaginatedRequestSchema.extend({
      method: exports_external.literal("tools/list")
    });
    ListToolsResultSchema = PaginatedResultSchema.extend({
      tools: exports_external.array(ToolSchema)
    });
    CallToolResultSchema = ResultSchema.extend({
      content: exports_external.array(ContentBlockSchema).default([]),
      structuredContent: exports_external.object({}).passthrough().optional(),
      isError: exports_external.optional(exports_external.boolean())
    });
    CompatibilityCallToolResultSchema = CallToolResultSchema.or(ResultSchema.extend({
      toolResult: exports_external.unknown()
    }));
    CallToolRequestSchema = RequestSchema.extend({
      method: exports_external.literal("tools/call"),
      params: BaseRequestParamsSchema.extend({
        name: exports_external.string(),
        arguments: exports_external.optional(exports_external.record(exports_external.unknown()))
      })
    });
    ToolListChangedNotificationSchema = NotificationSchema.extend({
      method: exports_external.literal("notifications/tools/list_changed")
    });
    LoggingLevelSchema = exports_external.enum([
      "debug",
      "info",
      "notice",
      "warning",
      "error",
      "critical",
      "alert",
      "emergency"
    ]);
    SetLevelRequestSchema = RequestSchema.extend({
      method: exports_external.literal("logging/setLevel"),
      params: BaseRequestParamsSchema.extend({
        level: LoggingLevelSchema
      })
    });
    LoggingMessageNotificationSchema = NotificationSchema.extend({
      method: exports_external.literal("notifications/message"),
      params: BaseNotificationParamsSchema.extend({
        level: LoggingLevelSchema,
        logger: exports_external.optional(exports_external.string()),
        data: exports_external.unknown()
      })
    });
    ModelHintSchema = exports_external.object({
      name: exports_external.string().optional()
    }).passthrough();
    ModelPreferencesSchema = exports_external.object({
      hints: exports_external.optional(exports_external.array(ModelHintSchema)),
      costPriority: exports_external.optional(exports_external.number().min(0).max(1)),
      speedPriority: exports_external.optional(exports_external.number().min(0).max(1)),
      intelligencePriority: exports_external.optional(exports_external.number().min(0).max(1))
    }).passthrough();
    SamplingMessageSchema = exports_external.object({
      role: exports_external.enum(["user", "assistant"]),
      content: exports_external.union([TextContentSchema, ImageContentSchema, AudioContentSchema])
    }).passthrough();
    CreateMessageRequestSchema = RequestSchema.extend({
      method: exports_external.literal("sampling/createMessage"),
      params: BaseRequestParamsSchema.extend({
        messages: exports_external.array(SamplingMessageSchema),
        systemPrompt: exports_external.optional(exports_external.string()),
        includeContext: exports_external.optional(exports_external.enum(["none", "thisServer", "allServers"])),
        temperature: exports_external.optional(exports_external.number()),
        maxTokens: exports_external.number().int(),
        stopSequences: exports_external.optional(exports_external.array(exports_external.string())),
        metadata: exports_external.optional(exports_external.object({}).passthrough()),
        modelPreferences: exports_external.optional(ModelPreferencesSchema)
      })
    });
    CreateMessageResultSchema = ResultSchema.extend({
      model: exports_external.string(),
      stopReason: exports_external.optional(exports_external.enum(["endTurn", "stopSequence", "maxTokens"]).or(exports_external.string())),
      role: exports_external.enum(["user", "assistant"]),
      content: exports_external.discriminatedUnion("type", [
        TextContentSchema,
        ImageContentSchema,
        AudioContentSchema
      ])
    });
    BooleanSchemaSchema = exports_external.object({
      type: exports_external.literal("boolean"),
      title: exports_external.optional(exports_external.string()),
      description: exports_external.optional(exports_external.string()),
      default: exports_external.optional(exports_external.boolean())
    }).passthrough();
    StringSchemaSchema = exports_external.object({
      type: exports_external.literal("string"),
      title: exports_external.optional(exports_external.string()),
      description: exports_external.optional(exports_external.string()),
      minLength: exports_external.optional(exports_external.number()),
      maxLength: exports_external.optional(exports_external.number()),
      format: exports_external.optional(exports_external.enum(["email", "uri", "date", "date-time"]))
    }).passthrough();
    NumberSchemaSchema = exports_external.object({
      type: exports_external.enum(["number", "integer"]),
      title: exports_external.optional(exports_external.string()),
      description: exports_external.optional(exports_external.string()),
      minimum: exports_external.optional(exports_external.number()),
      maximum: exports_external.optional(exports_external.number())
    }).passthrough();
    EnumSchemaSchema = exports_external.object({
      type: exports_external.literal("string"),
      title: exports_external.optional(exports_external.string()),
      description: exports_external.optional(exports_external.string()),
      enum: exports_external.array(exports_external.string()),
      enumNames: exports_external.optional(exports_external.array(exports_external.string()))
    }).passthrough();
    PrimitiveSchemaDefinitionSchema = exports_external.union([
      BooleanSchemaSchema,
      StringSchemaSchema,
      NumberSchemaSchema,
      EnumSchemaSchema
    ]);
    ElicitRequestSchema = RequestSchema.extend({
      method: exports_external.literal("elicitation/create"),
      params: BaseRequestParamsSchema.extend({
        message: exports_external.string(),
        requestedSchema: exports_external.object({
          type: exports_external.literal("object"),
          properties: exports_external.record(exports_external.string(), PrimitiveSchemaDefinitionSchema),
          required: exports_external.optional(exports_external.array(exports_external.string()))
        }).passthrough()
      })
    });
    ElicitResultSchema = ResultSchema.extend({
      action: exports_external.enum(["accept", "decline", "cancel"]),
      content: exports_external.optional(exports_external.record(exports_external.string(), exports_external.unknown()))
    });
    ResourceTemplateReferenceSchema = exports_external.object({
      type: exports_external.literal("ref/resource"),
      uri: exports_external.string()
    }).passthrough();
    PromptReferenceSchema = exports_external.object({
      type: exports_external.literal("ref/prompt"),
      name: exports_external.string()
    }).passthrough();
    CompleteRequestSchema = RequestSchema.extend({
      method: exports_external.literal("completion/complete"),
      params: BaseRequestParamsSchema.extend({
        ref: exports_external.union([PromptReferenceSchema, ResourceTemplateReferenceSchema]),
        argument: exports_external.object({
          name: exports_external.string(),
          value: exports_external.string()
        }).passthrough(),
        context: exports_external.optional(exports_external.object({
          arguments: exports_external.optional(exports_external.record(exports_external.string(), exports_external.string()))
        }))
      })
    });
    CompleteResultSchema = ResultSchema.extend({
      completion: exports_external.object({
        values: exports_external.array(exports_external.string()).max(100),
        total: exports_external.optional(exports_external.number().int()),
        hasMore: exports_external.optional(exports_external.boolean())
      }).passthrough()
    });
    RootSchema = exports_external.object({
      uri: exports_external.string().startsWith("file://"),
      name: exports_external.optional(exports_external.string()),
      _meta: exports_external.optional(exports_external.object({}).passthrough())
    }).passthrough();
    ListRootsRequestSchema = RequestSchema.extend({
      method: exports_external.literal("roots/list")
    });
    ListRootsResultSchema = ResultSchema.extend({
      roots: exports_external.array(RootSchema)
    });
    RootsListChangedNotificationSchema = NotificationSchema.extend({
      method: exports_external.literal("notifications/roots/list_changed")
    });
    ClientRequestSchema = exports_external.union([
      PingRequestSchema,
      InitializeRequestSchema,
      CompleteRequestSchema,
      SetLevelRequestSchema,
      GetPromptRequestSchema,
      ListPromptsRequestSchema,
      ListResourcesRequestSchema,
      ListResourceTemplatesRequestSchema,
      ReadResourceRequestSchema,
      SubscribeRequestSchema,
      UnsubscribeRequestSchema,
      CallToolRequestSchema,
      ListToolsRequestSchema
    ]);
    ClientNotificationSchema = exports_external.union([
      CancelledNotificationSchema,
      ProgressNotificationSchema,
      InitializedNotificationSchema,
      RootsListChangedNotificationSchema
    ]);
    ClientResultSchema = exports_external.union([
      EmptyResultSchema,
      CreateMessageResultSchema,
      ElicitResultSchema,
      ListRootsResultSchema
    ]);
    ServerRequestSchema = exports_external.union([
      PingRequestSchema,
      CreateMessageRequestSchema,
      ElicitRequestSchema,
      ListRootsRequestSchema
    ]);
    ServerNotificationSchema = exports_external.union([
      CancelledNotificationSchema,
      ProgressNotificationSchema,
      LoggingMessageNotificationSchema,
      ResourceUpdatedNotificationSchema,
      ResourceListChangedNotificationSchema,
      ToolListChangedNotificationSchema,
      PromptListChangedNotificationSchema
    ]);
    ServerResultSchema = exports_external.union([
      EmptyResultSchema,
      InitializeResultSchema,
      CompleteResultSchema,
      GetPromptResultSchema,
      ListPromptsResultSchema,
      ListResourcesResultSchema,
      ListResourceTemplatesResultSchema,
      ReadResourceResultSchema,
      CallToolResultSchema,
      ListToolsResultSchema
    ]);
    McpError = class extends Error {
      constructor(code3, message, data) {
        super(`MCP error ${code3}: ${message}`);
        this.code = code3;
        this.data = data;
        this.name = "McpError";
      }
    };
    DEFAULT_REQUEST_TIMEOUT_MSEC = 6e4;
    Protocol = class {
      constructor(_options) {
        this._options = _options;
        this._requestMessageId = 0;
        this._requestHandlers = /* @__PURE__ */ new Map();
        this._requestHandlerAbortControllers = /* @__PURE__ */ new Map();
        this._notificationHandlers = /* @__PURE__ */ new Map();
        this._responseHandlers = /* @__PURE__ */ new Map();
        this._progressHandlers = /* @__PURE__ */ new Map();
        this._timeoutInfo = /* @__PURE__ */ new Map();
        this._pendingDebouncedNotifications = /* @__PURE__ */ new Set();
        this.setNotificationHandler(CancelledNotificationSchema, (notification) => {
          const controller = this._requestHandlerAbortControllers.get(notification.params.requestId);
          controller === null || controller === void 0 || controller.abort(notification.params.reason);
        });
        this.setNotificationHandler(ProgressNotificationSchema, (notification) => {
          this._onprogress(notification);
        });
        this.setRequestHandler(PingRequestSchema, (_request) => ({}));
      }
      _setupTimeout(messageId, timeout2, maxTotalTimeout, onTimeout, resetTimeoutOnProgress = false) {
        this._timeoutInfo.set(messageId, {
          timeoutId: setTimeout(onTimeout, timeout2),
          startTime: Date.now(),
          timeout: timeout2,
          maxTotalTimeout,
          resetTimeoutOnProgress,
          onTimeout
        });
      }
      _resetTimeout(messageId) {
        const info2 = this._timeoutInfo.get(messageId);
        if (!info2)
          return false;
        const totalElapsed = Date.now() - info2.startTime;
        if (info2.maxTotalTimeout && totalElapsed >= info2.maxTotalTimeout) {
          this._timeoutInfo.delete(messageId);
          throw new McpError(ErrorCode.RequestTimeout, "Maximum total timeout exceeded", { maxTotalTimeout: info2.maxTotalTimeout, totalElapsed });
        }
        clearTimeout(info2.timeoutId);
        info2.timeoutId = setTimeout(info2.onTimeout, info2.timeout);
        return true;
      }
      _cleanupTimeout(messageId) {
        const info2 = this._timeoutInfo.get(messageId);
        if (info2) {
          clearTimeout(info2.timeoutId);
          this._timeoutInfo.delete(messageId);
        }
      }
      async connect(transport) {
        var _a17, _b4, _c;
        this._transport = transport;
        const _onclose = (_a17 = this.transport) === null || _a17 === void 0 ? void 0 : _a17.onclose;
        this._transport.onclose = () => {
          _onclose === null || _onclose === void 0 || _onclose();
          this._onclose();
        };
        const _onerror2 = (_b4 = this.transport) === null || _b4 === void 0 ? void 0 : _b4.onerror;
        this._transport.onerror = (error2) => {
          _onerror2 === null || _onerror2 === void 0 || _onerror2(error2);
          this._onerror(error2);
        };
        const _onmessage = (_c = this._transport) === null || _c === void 0 ? void 0 : _c.onmessage;
        this._transport.onmessage = (message, extra) => {
          _onmessage === null || _onmessage === void 0 || _onmessage(message, extra);
          if (isJSONRPCResponse(message) || isJSONRPCError(message)) {
            this._onresponse(message);
          } else if (isJSONRPCRequest(message)) {
            this._onrequest(message, extra);
          } else if (isJSONRPCNotification(message)) {
            this._onnotification(message);
          } else {
            this._onerror(new Error(`Unknown message type: ${JSON.stringify(message)}`));
          }
        };
        await this._transport.start();
      }
      _onclose() {
        var _a17;
        const responseHandlers = this._responseHandlers;
        this._responseHandlers = /* @__PURE__ */ new Map();
        this._progressHandlers.clear();
        this._pendingDebouncedNotifications.clear();
        this._transport = void 0;
        (_a17 = this.onclose) === null || _a17 === void 0 || _a17.call(this);
        const error2 = new McpError(ErrorCode.ConnectionClosed, "Connection closed");
        for (const handler of responseHandlers.values()) {
          handler(error2);
        }
      }
      _onerror(error2) {
        var _a17;
        (_a17 = this.onerror) === null || _a17 === void 0 || _a17.call(this, error2);
      }
      _onnotification(notification) {
        var _a17;
        const handler = (_a17 = this._notificationHandlers.get(notification.method)) !== null && _a17 !== void 0 ? _a17 : this.fallbackNotificationHandler;
        if (handler === void 0) {
          return;
        }
        Promise.resolve().then(() => handler(notification)).catch((error2) => this._onerror(new Error(`Uncaught error in notification handler: ${error2}`)));
      }
      _onrequest(request2, extra) {
        var _a17, _b4;
        const handler = (_a17 = this._requestHandlers.get(request2.method)) !== null && _a17 !== void 0 ? _a17 : this.fallbackRequestHandler;
        const capturedTransport = this._transport;
        if (handler === void 0) {
          capturedTransport === null || capturedTransport === void 0 || capturedTransport.send({
            jsonrpc: "2.0",
            id: request2.id,
            error: {
              code: ErrorCode.MethodNotFound,
              message: "Method not found"
            }
          }).catch((error2) => this._onerror(new Error(`Failed to send an error response: ${error2}`)));
          return;
        }
        const abortController = new AbortController();
        this._requestHandlerAbortControllers.set(request2.id, abortController);
        const fullExtra = {
          signal: abortController.signal,
          sessionId: capturedTransport === null || capturedTransport === void 0 ? void 0 : capturedTransport.sessionId,
          _meta: (_b4 = request2.params) === null || _b4 === void 0 ? void 0 : _b4._meta,
          sendNotification: (notification) => this.notification(notification, { relatedRequestId: request2.id }),
          sendRequest: (r, resultSchema, options) => this.request(r, resultSchema, { ...options, relatedRequestId: request2.id }),
          authInfo: extra === null || extra === void 0 ? void 0 : extra.authInfo,
          requestId: request2.id,
          requestInfo: extra === null || extra === void 0 ? void 0 : extra.requestInfo
        };
        Promise.resolve().then(() => handler(request2, fullExtra)).then((result) => {
          if (abortController.signal.aborted) {
            return;
          }
          return capturedTransport === null || capturedTransport === void 0 ? void 0 : capturedTransport.send({
            result,
            jsonrpc: "2.0",
            id: request2.id
          });
        }, (error2) => {
          var _a22;
          if (abortController.signal.aborted) {
            return;
          }
          return capturedTransport === null || capturedTransport === void 0 ? void 0 : capturedTransport.send({
            jsonrpc: "2.0",
            id: request2.id,
            error: {
              code: Number.isSafeInteger(error2["code"]) ? error2["code"] : ErrorCode.InternalError,
              message: (_a22 = error2.message) !== null && _a22 !== void 0 ? _a22 : "Internal error"
            }
          });
        }).catch((error2) => this._onerror(new Error(`Failed to send response: ${error2}`))).finally(() => {
          this._requestHandlerAbortControllers.delete(request2.id);
        });
      }
      _onprogress(notification) {
        const { progressToken, ...params } = notification.params;
        const messageId = Number(progressToken);
        const handler = this._progressHandlers.get(messageId);
        if (!handler) {
          this._onerror(new Error(`Received a progress notification for an unknown token: ${JSON.stringify(notification)}`));
          return;
        }
        const responseHandler = this._responseHandlers.get(messageId);
        const timeoutInfo = this._timeoutInfo.get(messageId);
        if (timeoutInfo && responseHandler && timeoutInfo.resetTimeoutOnProgress) {
          try {
            this._resetTimeout(messageId);
          } catch (error2) {
            responseHandler(error2);
            return;
          }
        }
        handler(params);
      }
      _onresponse(response) {
        const messageId = Number(response.id);
        const handler = this._responseHandlers.get(messageId);
        if (handler === void 0) {
          this._onerror(new Error(`Received a response for an unknown message ID: ${JSON.stringify(response)}`));
          return;
        }
        this._responseHandlers.delete(messageId);
        this._progressHandlers.delete(messageId);
        this._cleanupTimeout(messageId);
        if (isJSONRPCResponse(response)) {
          handler(response);
        } else {
          const error2 = new McpError(response.error.code, response.error.message, response.error.data);
          handler(error2);
        }
      }
      get transport() {
        return this._transport;
      }
      async close() {
        var _a17;
        await ((_a17 = this._transport) === null || _a17 === void 0 ? void 0 : _a17.close());
      }
      request(request2, resultSchema, options) {
        const { relatedRequestId, resumptionToken, onresumptiontoken } = options !== null && options !== void 0 ? options : {};
        return new Promise((resolve3, reject) => {
          var _a17, _b4, _c, _d, _e, _f;
          if (!this._transport) {
            reject(new Error("Not connected"));
            return;
          }
          if (((_a17 = this._options) === null || _a17 === void 0 ? void 0 : _a17.enforceStrictCapabilities) === true) {
            this.assertCapabilityForMethod(request2.method);
          }
          (_b4 = options === null || options === void 0 ? void 0 : options.signal) === null || _b4 === void 0 || _b4.throwIfAborted();
          const messageId = this._requestMessageId++;
          const jsonrpcRequest = {
            ...request2,
            jsonrpc: "2.0",
            id: messageId
          };
          if (options === null || options === void 0 ? void 0 : options.onprogress) {
            this._progressHandlers.set(messageId, options.onprogress);
            jsonrpcRequest.params = {
              ...request2.params,
              _meta: {
                ...((_c = request2.params) === null || _c === void 0 ? void 0 : _c._meta) || {},
                progressToken: messageId
              }
            };
          }
          const cancel = (reason) => {
            var _a22;
            this._responseHandlers.delete(messageId);
            this._progressHandlers.delete(messageId);
            this._cleanupTimeout(messageId);
            (_a22 = this._transport) === null || _a22 === void 0 || _a22.send({
              jsonrpc: "2.0",
              method: "notifications/cancelled",
              params: {
                requestId: messageId,
                reason: String(reason)
              }
            }, { relatedRequestId, resumptionToken, onresumptiontoken }).catch((error2) => this._onerror(new Error(`Failed to send cancellation: ${error2}`)));
            reject(reason);
          };
          this._responseHandlers.set(messageId, (response) => {
            var _a22;
            if ((_a22 = options === null || options === void 0 ? void 0 : options.signal) === null || _a22 === void 0 ? void 0 : _a22.aborted) {
              return;
            }
            if (response instanceof Error) {
              return reject(response);
            }
            try {
              const result = resultSchema.parse(response.result);
              resolve3(result);
            } catch (error2) {
              reject(error2);
            }
          });
          (_d = options === null || options === void 0 ? void 0 : options.signal) === null || _d === void 0 || _d.addEventListener("abort", () => {
            var _a22;
            cancel((_a22 = options === null || options === void 0 ? void 0 : options.signal) === null || _a22 === void 0 ? void 0 : _a22.reason);
          });
          const timeout2 = (_e = options === null || options === void 0 ? void 0 : options.timeout) !== null && _e !== void 0 ? _e : DEFAULT_REQUEST_TIMEOUT_MSEC;
          const timeoutHandler = () => cancel(new McpError(ErrorCode.RequestTimeout, "Request timed out", { timeout: timeout2 }));
          this._setupTimeout(messageId, timeout2, options === null || options === void 0 ? void 0 : options.maxTotalTimeout, timeoutHandler, (_f = options === null || options === void 0 ? void 0 : options.resetTimeoutOnProgress) !== null && _f !== void 0 ? _f : false);
          this._transport.send(jsonrpcRequest, { relatedRequestId, resumptionToken, onresumptiontoken }).catch((error2) => {
            this._cleanupTimeout(messageId);
            reject(error2);
          });
        });
      }
      async notification(notification, options) {
        var _a17, _b4;
        if (!this._transport) {
          throw new Error("Not connected");
        }
        this.assertNotificationCapability(notification.method);
        const debouncedMethods = (_b4 = (_a17 = this._options) === null || _a17 === void 0 ? void 0 : _a17.debouncedNotificationMethods) !== null && _b4 !== void 0 ? _b4 : [];
        const canDebounce = debouncedMethods.includes(notification.method) && !notification.params && !(options === null || options === void 0 ? void 0 : options.relatedRequestId);
        if (canDebounce) {
          if (this._pendingDebouncedNotifications.has(notification.method)) {
            return;
          }
          this._pendingDebouncedNotifications.add(notification.method);
          Promise.resolve().then(() => {
            var _a22;
            this._pendingDebouncedNotifications.delete(notification.method);
            if (!this._transport) {
              return;
            }
            const jsonrpcNotification2 = {
              ...notification,
              jsonrpc: "2.0"
            };
            (_a22 = this._transport) === null || _a22 === void 0 || _a22.send(jsonrpcNotification2, options).catch((error2) => this._onerror(error2));
          });
          return;
        }
        const jsonrpcNotification = {
          ...notification,
          jsonrpc: "2.0"
        };
        await this._transport.send(jsonrpcNotification, options);
      }
      setRequestHandler(requestSchema, handler) {
        const method = requestSchema.shape.method.value;
        this.assertRequestHandlerCapability(method);
        this._requestHandlers.set(method, (request2, extra) => {
          return Promise.resolve(handler(requestSchema.parse(request2), extra));
        });
      }
      removeRequestHandler(method) {
        this._requestHandlers.delete(method);
      }
      assertCanSetRequestHandler(method) {
        if (this._requestHandlers.has(method)) {
          throw new Error(`A request handler for ${method} already exists, which would be overridden`);
        }
      }
      setNotificationHandler(notificationSchema, handler) {
        this._notificationHandlers.set(notificationSchema.shape.method.value, (notification) => Promise.resolve(handler(notificationSchema.parse(notification))));
      }
      removeNotificationHandler(method) {
        this._notificationHandlers.delete(method);
      }
    };
    import_ajv2 = __toESM2(require_ajv2(), 1);
    Server = class extends Protocol {
      constructor(_serverInfo, options) {
        var _a17;
        super(options);
        this._serverInfo = _serverInfo;
        this._capabilities = (_a17 = options === null || options === void 0 ? void 0 : options.capabilities) !== null && _a17 !== void 0 ? _a17 : {};
        this._instructions = options === null || options === void 0 ? void 0 : options.instructions;
        this.setRequestHandler(InitializeRequestSchema, (request2) => this._oninitialize(request2));
        this.setNotificationHandler(InitializedNotificationSchema, () => {
          var _a22;
          return (_a22 = this.oninitialized) === null || _a22 === void 0 ? void 0 : _a22.call(this);
        });
      }
      registerCapabilities(capabilities) {
        if (this.transport) {
          throw new Error("Cannot register capabilities after connecting to transport");
        }
        this._capabilities = mergeCapabilities(this._capabilities, capabilities);
      }
      assertCapabilityForMethod(method) {
        var _a17, _b4, _c;
        switch (method) {
          case "sampling/createMessage":
            if (!((_a17 = this._clientCapabilities) === null || _a17 === void 0 ? void 0 : _a17.sampling)) {
              throw new Error(`Client does not support sampling (required for ${method})`);
            }
            break;
          case "elicitation/create":
            if (!((_b4 = this._clientCapabilities) === null || _b4 === void 0 ? void 0 : _b4.elicitation)) {
              throw new Error(`Client does not support elicitation (required for ${method})`);
            }
            break;
          case "roots/list":
            if (!((_c = this._clientCapabilities) === null || _c === void 0 ? void 0 : _c.roots)) {
              throw new Error(`Client does not support listing roots (required for ${method})`);
            }
            break;
          case "ping":
            break;
        }
      }
      assertNotificationCapability(method) {
        switch (method) {
          case "notifications/message":
            if (!this._capabilities.logging) {
              throw new Error(`Server does not support logging (required for ${method})`);
            }
            break;
          case "notifications/resources/updated":
          case "notifications/resources/list_changed":
            if (!this._capabilities.resources) {
              throw new Error(`Server does not support notifying about resources (required for ${method})`);
            }
            break;
          case "notifications/tools/list_changed":
            if (!this._capabilities.tools) {
              throw new Error(`Server does not support notifying of tool list changes (required for ${method})`);
            }
            break;
          case "notifications/prompts/list_changed":
            if (!this._capabilities.prompts) {
              throw new Error(`Server does not support notifying of prompt list changes (required for ${method})`);
            }
            break;
          case "notifications/cancelled":
            break;
          case "notifications/progress":
            break;
        }
      }
      assertRequestHandlerCapability(method) {
        switch (method) {
          case "sampling/createMessage":
            if (!this._capabilities.sampling) {
              throw new Error(`Server does not support sampling (required for ${method})`);
            }
            break;
          case "logging/setLevel":
            if (!this._capabilities.logging) {
              throw new Error(`Server does not support logging (required for ${method})`);
            }
            break;
          case "prompts/get":
          case "prompts/list":
            if (!this._capabilities.prompts) {
              throw new Error(`Server does not support prompts (required for ${method})`);
            }
            break;
          case "resources/list":
          case "resources/templates/list":
          case "resources/read":
            if (!this._capabilities.resources) {
              throw new Error(`Server does not support resources (required for ${method})`);
            }
            break;
          case "tools/call":
          case "tools/list":
            if (!this._capabilities.tools) {
              throw new Error(`Server does not support tools (required for ${method})`);
            }
            break;
          case "ping":
          case "initialize":
            break;
        }
      }
      async _oninitialize(request2) {
        const requestedVersion = request2.params.protocolVersion;
        this._clientCapabilities = request2.params.capabilities;
        this._clientVersion = request2.params.clientInfo;
        const protocolVersion = SUPPORTED_PROTOCOL_VERSIONS.includes(requestedVersion) ? requestedVersion : LATEST_PROTOCOL_VERSION;
        return {
          protocolVersion,
          capabilities: this.getCapabilities(),
          serverInfo: this._serverInfo,
          ...this._instructions && { instructions: this._instructions }
        };
      }
      getClientCapabilities() {
        return this._clientCapabilities;
      }
      getClientVersion() {
        return this._clientVersion;
      }
      getCapabilities() {
        return this._capabilities;
      }
      async ping() {
        return this.request({ method: "ping" }, EmptyResultSchema);
      }
      async createMessage(params, options) {
        return this.request({ method: "sampling/createMessage", params }, CreateMessageResultSchema, options);
      }
      async elicitInput(params, options) {
        const result = await this.request({ method: "elicitation/create", params }, ElicitResultSchema, options);
        if (result.action === "accept" && result.content) {
          try {
            const ajv = new import_ajv2.default();
            const validate = ajv.compile(params.requestedSchema);
            const isValid2 = validate(result.content);
            if (!isValid2) {
              throw new McpError(ErrorCode.InvalidParams, `Elicitation response content does not match requested schema: ${ajv.errorsText(validate.errors)}`);
            }
          } catch (error2) {
            if (error2 instanceof McpError) {
              throw error2;
            }
            throw new McpError(ErrorCode.InternalError, `Error validating elicitation response: ${error2}`);
          }
        }
        return result;
      }
      async listRoots(params, options) {
        return this.request({ method: "roots/list", params }, ListRootsResultSchema, options);
      }
      async sendLoggingMessage(params) {
        return this.notification({ method: "notifications/message", params });
      }
      async sendResourceUpdated(params) {
        return this.notification({
          method: "notifications/resources/updated",
          params
        });
      }
      async sendResourceListChanged() {
        return this.notification({
          method: "notifications/resources/list_changed"
        });
      }
      async sendToolListChanged() {
        return this.notification({ method: "notifications/tools/list_changed" });
      }
      async sendPromptListChanged() {
        return this.notification({ method: "notifications/prompts/list_changed" });
      }
    };
    ignoreOverride = Symbol("Let zodToJsonSchema decide on which parser to use");
    defaultOptions = {
      name: void 0,
      $refStrategy: "root",
      basePath: ["#"],
      effectStrategy: "input",
      pipeStrategy: "all",
      dateStrategy: "format:date-time",
      mapStrategy: "entries",
      removeAdditionalStrategy: "passthrough",
      allowedAdditionalProperties: true,
      rejectedAdditionalProperties: false,
      definitionPath: "definitions",
      target: "jsonSchema7",
      strictUnions: false,
      definitions: {},
      errorMessages: false,
      markdownDescription: false,
      patternStrategy: "escape",
      applyRegexFlags: false,
      emailStrategy: "format:email",
      base64Strategy: "contentEncoding:base64",
      nameStrategy: "ref"
    };
    getDefaultOptions = (options) => typeof options === "string" ? {
      ...defaultOptions,
      name: options
    } : {
      ...defaultOptions,
      ...options
    };
    getRefs = (options) => {
      const _options = getDefaultOptions(options);
      const currentPath = _options.name !== void 0 ? [..._options.basePath, _options.definitionPath, _options.name] : _options.basePath;
      return {
        ..._options,
        currentPath,
        propertyPath: void 0,
        seen: new Map(Object.entries(_options.definitions).map(([name3, def]) => [
          def._def,
          {
            def: def._def,
            path: [..._options.basePath, _options.definitionPath, name3],
            jsonSchema: void 0
          }
        ]))
      };
    };
    parseCatchDef = (def, refs) => {
      return parseDef(def.innerType._def, refs);
    };
    integerDateParser = (def, refs) => {
      const res = {
        type: "integer",
        format: "unix-time"
      };
      if (refs.target === "openApi3") {
        return res;
      }
      for (const check of def.checks) {
        switch (check.kind) {
          case "min":
            setResponseValueAndErrors(res, "minimum", check.value, check.message, refs);
            break;
          case "max":
            setResponseValueAndErrors(res, "maximum", check.value, check.message, refs);
            break;
        }
      }
      return res;
    };
    isJsonSchema7AllOfType = (type) => {
      if ("type" in type && type.type === "string")
        return false;
      return "allOf" in type;
    };
    emojiRegex2 = void 0;
    zodPatterns = {
      cuid: /^[cC][^\s-]{8,}$/,
      cuid2: /^[0-9a-z]+$/,
      ulid: /^[0-9A-HJKMNP-TV-Z]{26}$/,
      email: /^(?!\.)(?!.*\.\.)([a-zA-Z0-9_'+\-\.]*)[a-zA-Z0-9_+-]@([a-zA-Z0-9][a-zA-Z0-9\-]*\.)+[a-zA-Z]{2,}$/,
      emoji: () => {
        if (emojiRegex2 === void 0) {
          emojiRegex2 = RegExp("^(\\p{Extended_Pictographic}|\\p{Emoji_Component})+$", "u");
        }
        return emojiRegex2;
      },
      uuid: /^[0-9a-fA-F]{8}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{12}$/,
      ipv4: /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/,
      ipv4Cidr: /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\/(3[0-2]|[12]?[0-9])$/,
      ipv6: /^(([a-f0-9]{1,4}:){7}|::([a-f0-9]{1,4}:){0,6}|([a-f0-9]{1,4}:){1}:([a-f0-9]{1,4}:){0,5}|([a-f0-9]{1,4}:){2}:([a-f0-9]{1,4}:){0,4}|([a-f0-9]{1,4}:){3}:([a-f0-9]{1,4}:){0,3}|([a-f0-9]{1,4}:){4}:([a-f0-9]{1,4}:){0,2}|([a-f0-9]{1,4}:){5}:([a-f0-9]{1,4}:){0,1})([a-f0-9]{1,4}|(((25[0-5])|(2[0-4][0-9])|(1[0-9]{2})|([0-9]{1,2}))\.){3}((25[0-5])|(2[0-4][0-9])|(1[0-9]{2})|([0-9]{1,2})))$/,
      ipv6Cidr: /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\/(12[0-8]|1[01][0-9]|[1-9]?[0-9])$/,
      base64: /^([0-9a-zA-Z+/]{4})*(([0-9a-zA-Z+/]{2}==)|([0-9a-zA-Z+/]{3}=))?$/,
      base64url: /^([0-9a-zA-Z-_]{4})*(([0-9a-zA-Z-_]{2}(==)?)|([0-9a-zA-Z-_]{3}(=)?))?$/,
      nanoid: /^[a-zA-Z0-9_-]{21}$/,
      jwt: /^[A-Za-z0-9-_]+\.[A-Za-z0-9-_]+\.[A-Za-z0-9-_]*$/
    };
    ALPHA_NUMERIC = new Set("ABCDEFGHIJKLMNOPQRSTUVXYZabcdefghijklmnopqrstuvxyz0123456789");
    primitiveMappings = {
      ZodString: "string",
      ZodNumber: "number",
      ZodBigInt: "integer",
      ZodBoolean: "boolean",
      ZodNull: "null"
    };
    asAnyOf = (def, refs) => {
      const anyOf = (def.options instanceof Map ? Array.from(def.options.values()) : def.options).map((x, i2) => parseDef(x._def, {
        ...refs,
        currentPath: [...refs.currentPath, "anyOf", `${i2}`]
      })).filter((x) => !!x && (!refs.strictUnions || typeof x === "object" && Object.keys(x).length > 0));
      return anyOf.length ? { anyOf } : void 0;
    };
    parseOptionalDef = (def, refs) => {
      if (refs.currentPath.toString() === refs.propertyPath?.toString()) {
        return parseDef(def.innerType._def, refs);
      }
      const innerSchema = parseDef(def.innerType._def, {
        ...refs,
        currentPath: [...refs.currentPath, "anyOf", "1"]
      });
      return innerSchema ? {
        anyOf: [
          {
            not: {}
          },
          innerSchema
        ]
      } : {};
    };
    parsePipelineDef = (def, refs) => {
      if (refs.pipeStrategy === "input") {
        return parseDef(def.in._def, refs);
      } else if (refs.pipeStrategy === "output") {
        return parseDef(def.out._def, refs);
      }
      const a = parseDef(def.in._def, {
        ...refs,
        currentPath: [...refs.currentPath, "allOf", "0"]
      });
      const b = parseDef(def.out._def, {
        ...refs,
        currentPath: [...refs.currentPath, "allOf", a ? "1" : "0"]
      });
      return {
        allOf: [a, b].filter((x) => x !== void 0)
      };
    };
    parseReadonlyDef = (def, refs) => {
      return parseDef(def.innerType._def, refs);
    };
    selectParser = (def, typeName, refs) => {
      switch (typeName) {
        case ZodFirstPartyTypeKind.ZodString:
          return parseStringDef(def, refs);
        case ZodFirstPartyTypeKind.ZodNumber:
          return parseNumberDef(def, 