"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = __importDefault(require("../logger"));
const authUtil = __importStar(require("../authentication/authentication_util"));
const util_1 = require("../util");
const authentication_types_1 = __importDefault(require("./authentication_types"));
class AuthOauthClientCredentials {
    connectionConfig;
    httpClient;
    _oauthImport;
    token;
    constructor(connectionConfig, httpClient) {
        this.connectionConfig = connectionConfig;
        this.httpClient = httpClient;
    }
    async getOauth4webapi() {
        if (!this._oauthImport) {
            this._oauthImport = await (0, util_1.dynamicImportESMInTypescriptWithCommonJS)('oauth4webapi');
        }
        return this._oauthImport;
    }
    updateBody(body) {
        if (this.token) {
            body.data.TOKEN = this.token;
        }
        body.data.AUTHENTICATOR = authentication_types_1.default.OAUTH_AUTHENTICATOR;
        body.data.CLIENT_ENVIRONMENT.OAUTH_TYPE = authentication_types_1.default.OAUTH_CLIENT_CREDENTIALS;
    }
    async authenticate() {
        const clientId = this.connectionConfig.getOauthClientId();
        const clientSecret = this.connectionConfig.getOauthClientSecret();
        const scope = await authUtil.prepareScope(this.connectionConfig);
        const parameters = new URLSearchParams();
        parameters.set('scope', scope);
        this.token = await this.requestToken(clientId, clientSecret, parameters);
    }
    async requestToken(clientId, clientSecret, parameters) {
        const oauth = await this.getOauth4webapi();
        const tokenUrl = authUtil.getTokenUrl(this.connectionConfig);
        const as = {
            // An issuer is an obligatory parameter in validation processed by oauth4webapi library, even when it isn't used
            issuer: 'UNKNOWN',
            // eslint-disable-next-line camelcase
            token_endpoint: tokenUrl.href,
        };
        const client = {
            // eslint-disable-next-line camelcase
            client_id: clientId,
        };
        try {
            (0, logger_1.default)().debug(`Executing token request: ${tokenUrl.href}`);
            const clientAuth = oauth.ClientSecretPost(clientSecret);
            const response = await oauth.clientCredentialsGrantRequest(as, client, clientAuth, parameters, {
                [oauth.allowInsecureRequests]: this.connectionConfig.getOauthHttpAllowed(),
                [oauth.customFetch]: async (url, options) => {
                    const response = await this.httpClient.requestAsync({ url, ...options });
                    return new Response(response.json, {
                        status: response.statusCode,
                        statusText: response.statusText,
                        headers: response.headers,
                    });
                },
            });
            const result = await oauth.processClientCredentialsResponse(as, client, response);
            if (result.access_token) {
                (0, logger_1.default)().debug(`Received new OAuth access token from: ${tokenUrl.href}`);
            }
            else {
                throw Error(`Response doesn't contain OAuth access token. Requested URI: ${tokenUrl.href}`);
            }
            return result.access_token;
        }
        catch (error) {
            throw new Error((0, util_1.format)('Error while getting access token. Message: %s', error.message));
        }
    }
}
exports.default = AuthOauthClientCredentials;
//# sourceMappingURL=auth_oauth_client_credentials.js.map