// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
export default {
  "application/1d-interleaved-parityfec": {
    "source": "iana"
  },
  "application/3gpdash-qoe-report+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/3gpp-ims+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/3gpphal+json": {
    "source": "iana",
    "compressible": true
  },
  "application/3gpphalforms+json": {
    "source": "iana",
    "compressible": true
  },
  "application/a2l": {
    "source": "iana"
  },
  "application/ace+cbor": {
    "source": "iana"
  },
  "application/ace+json": {
    "source": "iana",
    "compressible": true
  },
  "application/activemessage": {
    "source": "iana"
  },
  "application/activity+json": {
    "source": "iana",
    "compressible": true
  },
  "application/aif+cbor": {
    "source": "iana"
  },
  "application/aif+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-cdni+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-cdnifilter+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-costmap+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-costmapfilter+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-directory+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-endpointcost+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-endpointcostparams+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-endpointprop+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-endpointpropparams+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-error+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-networkmap+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-networkmapfilter+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-propmap+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-propmapparams+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-updatestreamcontrol+json": {
    "source": "iana",
    "compressible": true
  },
  "application/alto-updatestreamparams+json": {
    "source": "iana",
    "compressible": true
  },
  "application/aml": {
    "source": "iana"
  },
  "application/andrew-inset": {
    "source": "iana",
    "extensions": [
      "ez"
    ]
  },
  "application/appinstaller": {
    "compressible": false,
    "extensions": [
      "appinstaller"
    ]
  },
  "application/applefile": {
    "source": "iana"
  },
  "application/applixware": {
    "source": "apache",
    "extensions": [
      "aw"
    ]
  },
  "application/appx": {
    "compressible": false,
    "extensions": [
      "appx"
    ]
  },
  "application/appxbundle": {
    "compressible": false,
    "extensions": [
      "appxbundle"
    ]
  },
  "application/at+jwt": {
    "source": "iana"
  },
  "application/atf": {
    "source": "iana"
  },
  "application/atfx": {
    "source": "iana"
  },
  "application/atom+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "atom"
    ]
  },
  "application/atomcat+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "atomcat"
    ]
  },
  "application/atomdeleted+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "atomdeleted"
    ]
  },
  "application/atomicmail": {
    "source": "iana"
  },
  "application/atomsvc+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "atomsvc"
    ]
  },
  "application/atsc-dwd+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "dwd"
    ]
  },
  "application/atsc-dynamic-event-message": {
    "source": "iana"
  },
  "application/atsc-held+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "held"
    ]
  },
  "application/atsc-rdt+json": {
    "source": "iana",
    "compressible": true
  },
  "application/atsc-rsat+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rsat"
    ]
  },
  "application/atxml": {
    "source": "iana"
  },
  "application/auth-policy+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/automationml-aml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "aml"
    ]
  },
  "application/automationml-amlx+zip": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "amlx"
    ]
  },
  "application/bacnet-xdd+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/batch-smtp": {
    "source": "iana"
  },
  "application/bdoc": {
    "compressible": false,
    "extensions": [
      "bdoc"
    ]
  },
  "application/beep+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/calendar+json": {
    "source": "iana",
    "compressible": true
  },
  "application/calendar+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xcs"
    ]
  },
  "application/call-completion": {
    "source": "iana"
  },
  "application/cals-1840": {
    "source": "iana"
  },
  "application/captive+json": {
    "source": "iana",
    "compressible": true
  },
  "application/cbor": {
    "source": "iana"
  },
  "application/cbor-seq": {
    "source": "iana"
  },
  "application/cccex": {
    "source": "iana"
  },
  "application/ccmp+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/ccxml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "ccxml"
    ]
  },
  "application/cda+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/cdfx+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "cdfx"
    ]
  },
  "application/cdmi-capability": {
    "source": "iana",
    "extensions": [
      "cdmia"
    ]
  },
  "application/cdmi-container": {
    "source": "iana",
    "extensions": [
      "cdmic"
    ]
  },
  "application/cdmi-domain": {
    "source": "iana",
    "extensions": [
      "cdmid"
    ]
  },
  "application/cdmi-object": {
    "source": "iana",
    "extensions": [
      "cdmio"
    ]
  },
  "application/cdmi-queue": {
    "source": "iana",
    "extensions": [
      "cdmiq"
    ]
  },
  "application/cdni": {
    "source": "iana"
  },
  "application/cea": {
    "source": "iana"
  },
  "application/cea-2018+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/cellml+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/cfw": {
    "source": "iana"
  },
  "application/city+json": {
    "source": "iana",
    "compressible": true
  },
  "application/clr": {
    "source": "iana"
  },
  "application/clue+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/clue_info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/cms": {
    "source": "iana"
  },
  "application/cnrp+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/coap-group+json": {
    "source": "iana",
    "compressible": true
  },
  "application/coap-payload": {
    "source": "iana"
  },
  "application/commonground": {
    "source": "iana"
  },
  "application/concise-problem-details+cbor": {
    "source": "iana"
  },
  "application/conference-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/cose": {
    "source": "iana"
  },
  "application/cose-key": {
    "source": "iana"
  },
  "application/cose-key-set": {
    "source": "iana"
  },
  "application/cose-x509": {
    "source": "iana"
  },
  "application/cpl+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "cpl"
    ]
  },
  "application/csrattrs": {
    "source": "iana"
  },
  "application/csta+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/cstadata+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/csvm+json": {
    "source": "iana",
    "compressible": true
  },
  "application/cu-seeme": {
    "source": "apache",
    "extensions": [
      "cu"
    ]
  },
  "application/cwl": {
    "source": "iana",
    "extensions": [
      "cwl"
    ]
  },
  "application/cwl+json": {
    "source": "iana",
    "compressible": true
  },
  "application/cwt": {
    "source": "iana"
  },
  "application/cybercash": {
    "source": "iana"
  },
  "application/dart": {
    "compressible": true
  },
  "application/dash+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mpd"
    ]
  },
  "application/dash-patch+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mpp"
    ]
  },
  "application/dashdelta": {
    "source": "iana"
  },
  "application/davmount+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "davmount"
    ]
  },
  "application/dca-rft": {
    "source": "iana"
  },
  "application/dcd": {
    "source": "iana"
  },
  "application/dec-dx": {
    "source": "iana"
  },
  "application/dialog-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/dicom": {
    "source": "iana"
  },
  "application/dicom+json": {
    "source": "iana",
    "compressible": true
  },
  "application/dicom+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/dii": {
    "source": "iana"
  },
  "application/dit": {
    "source": "iana"
  },
  "application/dns": {
    "source": "iana"
  },
  "application/dns+json": {
    "source": "iana",
    "compressible": true
  },
  "application/dns-message": {
    "source": "iana"
  },
  "application/docbook+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "dbk"
    ]
  },
  "application/dots+cbor": {
    "source": "iana"
  },
  "application/dskpp+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/dssc+der": {
    "source": "iana",
    "extensions": [
      "dssc"
    ]
  },
  "application/dssc+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xdssc"
    ]
  },
  "application/dvcs": {
    "source": "iana"
  },
  "application/ecmascript": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "ecma"
    ]
  },
  "application/edi-consent": {
    "source": "iana"
  },
  "application/edi-x12": {
    "source": "iana",
    "compressible": false
  },
  "application/edifact": {
    "source": "iana",
    "compressible": false
  },
  "application/efi": {
    "source": "iana"
  },
  "application/elm+json": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/elm+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/emergencycalldata.cap+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/emergencycalldata.comment+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/emergencycalldata.control+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/emergencycalldata.deviceinfo+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/emergencycalldata.ecall.msd": {
    "source": "iana"
  },
  "application/emergencycalldata.legacyesn+json": {
    "source": "iana",
    "compressible": true
  },
  "application/emergencycalldata.providerinfo+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/emergencycalldata.serviceinfo+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/emergencycalldata.subscriberinfo+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/emergencycalldata.veds+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/emma+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "emma"
    ]
  },
  "application/emotionml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "emotionml"
    ]
  },
  "application/encaprtp": {
    "source": "iana"
  },
  "application/epp+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/epub+zip": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "epub"
    ]
  },
  "application/eshop": {
    "source": "iana"
  },
  "application/exi": {
    "source": "iana",
    "extensions": [
      "exi"
    ]
  },
  "application/expect-ct-report+json": {
    "source": "iana",
    "compressible": true
  },
  "application/express": {
    "source": "iana",
    "extensions": [
      "exp"
    ]
  },
  "application/fastinfoset": {
    "source": "iana"
  },
  "application/fastsoap": {
    "source": "iana"
  },
  "application/fdf": {
    "source": "iana",
    "extensions": [
      "fdf"
    ]
  },
  "application/fdt+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "fdt"
    ]
  },
  "application/fhir+json": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/fhir+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/fido.trusted-apps+json": {
    "compressible": true
  },
  "application/fits": {
    "source": "iana"
  },
  "application/flexfec": {
    "source": "iana"
  },
  "application/font-sfnt": {
    "source": "iana"
  },
  "application/font-tdpfr": {
    "source": "iana",
    "extensions": [
      "pfr"
    ]
  },
  "application/font-woff": {
    "source": "iana",
    "compressible": false
  },
  "application/framework-attributes+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/geo+json": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "geojson"
    ]
  },
  "application/geo+json-seq": {
    "source": "iana"
  },
  "application/geopackage+sqlite3": {
    "source": "iana"
  },
  "application/geoxacml+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/gltf-buffer": {
    "source": "iana"
  },
  "application/gml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "gml"
    ]
  },
  "application/gpx+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "gpx"
    ]
  },
  "application/gxf": {
    "source": "apache",
    "extensions": [
      "gxf"
    ]
  },
  "application/gzip": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "gz"
    ]
  },
  "application/h224": {
    "source": "iana"
  },
  "application/held+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/hjson": {
    "extensions": [
      "hjson"
    ]
  },
  "application/hl7v2+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/http": {
    "source": "iana"
  },
  "application/hyperstudio": {
    "source": "iana",
    "extensions": [
      "stk"
    ]
  },
  "application/ibe-key-request+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/ibe-pkg-reply+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/ibe-pp-data": {
    "source": "iana"
  },
  "application/iges": {
    "source": "iana"
  },
  "application/im-iscomposing+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/index": {
    "source": "iana"
  },
  "application/index.cmd": {
    "source": "iana"
  },
  "application/index.obj": {
    "source": "iana"
  },
  "application/index.response": {
    "source": "iana"
  },
  "application/index.vnd": {
    "source": "iana"
  },
  "application/inkml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "ink",
      "inkml"
    ]
  },
  "application/iotp": {
    "source": "iana"
  },
  "application/ipfix": {
    "source": "iana",
    "extensions": [
      "ipfix"
    ]
  },
  "application/ipp": {
    "source": "iana"
  },
  "application/isup": {
    "source": "iana"
  },
  "application/its+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "its"
    ]
  },
  "application/java-archive": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "jar",
      "war",
      "ear"
    ]
  },
  "application/java-serialized-object": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "ser"
    ]
  },
  "application/java-vm": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "class"
    ]
  },
  "application/javascript": {
    "source": "apache",
    "charset": "UTF-8",
    "compressible": true,
    "extensions": [
      "js"
    ]
  },
  "application/jf2feed+json": {
    "source": "iana",
    "compressible": true
  },
  "application/jose": {
    "source": "iana"
  },
  "application/jose+json": {
    "source": "iana",
    "compressible": true
  },
  "application/jrd+json": {
    "source": "iana",
    "compressible": true
  },
  "application/jscalendar+json": {
    "source": "iana",
    "compressible": true
  },
  "application/json": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true,
    "extensions": [
      "json",
      "map"
    ]
  },
  "application/json-patch+json": {
    "source": "iana",
    "compressible": true
  },
  "application/json-seq": {
    "source": "iana"
  },
  "application/json5": {
    "extensions": [
      "json5"
    ]
  },
  "application/jsonml+json": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "jsonml"
    ]
  },
  "application/jwk+json": {
    "source": "iana",
    "compressible": true
  },
  "application/jwk-set+json": {
    "source": "iana",
    "compressible": true
  },
  "application/jwt": {
    "source": "iana"
  },
  "application/kpml-request+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/kpml-response+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/ld+json": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "jsonld"
    ]
  },
  "application/lgr+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "lgr"
    ]
  },
  "application/link-format": {
    "source": "iana"
  },
  "application/linkset": {
    "source": "iana"
  },
  "application/linkset+json": {
    "source": "iana",
    "compressible": true
  },
  "application/load-control+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/logout+jwt": {
    "source": "iana"
  },
  "application/lost+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "lostxml"
    ]
  },
  "application/lostsync+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/lpf+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/lxf": {
    "source": "iana"
  },
  "application/mac-binhex40": {
    "source": "iana",
    "extensions": [
      "hqx"
    ]
  },
  "application/mac-compactpro": {
    "source": "apache",
    "extensions": [
      "cpt"
    ]
  },
  "application/macwriteii": {
    "source": "iana"
  },
  "application/mads+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mads"
    ]
  },
  "application/manifest+json": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true,
    "extensions": [
      "webmanifest"
    ]
  },
  "application/marc": {
    "source": "iana",
    "extensions": [
      "mrc"
    ]
  },
  "application/marcxml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mrcx"
    ]
  },
  "application/mathematica": {
    "source": "iana",
    "extensions": [
      "ma",
      "nb",
      "mb"
    ]
  },
  "application/mathml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mathml"
    ]
  },
  "application/mathml-content+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mathml-presentation+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-associated-procedure-description+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-deregister+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-envelope+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-msk+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-msk-response+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-protection-description+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-reception-report+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-register+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-register-response+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-schedule+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbms-user-service-description+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mbox": {
    "source": "iana",
    "extensions": [
      "mbox"
    ]
  },
  "application/media-policy-dataset+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mpf"
    ]
  },
  "application/media_control+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mediaservercontrol+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mscml"
    ]
  },
  "application/merge-patch+json": {
    "source": "iana",
    "compressible": true
  },
  "application/metalink+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "metalink"
    ]
  },
  "application/metalink4+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "meta4"
    ]
  },
  "application/mets+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mets"
    ]
  },
  "application/mf4": {
    "source": "iana"
  },
  "application/mikey": {
    "source": "iana"
  },
  "application/mipc": {
    "source": "iana"
  },
  "application/missing-blocks+cbor-seq": {
    "source": "iana"
  },
  "application/mmt-aei+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "maei"
    ]
  },
  "application/mmt-usd+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "musd"
    ]
  },
  "application/mods+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mods"
    ]
  },
  "application/moss-keys": {
    "source": "iana"
  },
  "application/moss-signature": {
    "source": "iana"
  },
  "application/mosskey-data": {
    "source": "iana"
  },
  "application/mosskey-request": {
    "source": "iana"
  },
  "application/mp21": {
    "source": "iana",
    "extensions": [
      "m21",
      "mp21"
    ]
  },
  "application/mp4": {
    "source": "iana",
    "extensions": [
      "mp4",
      "mpg4",
      "mp4s",
      "m4p"
    ]
  },
  "application/mpeg4-generic": {
    "source": "iana"
  },
  "application/mpeg4-iod": {
    "source": "iana"
  },
  "application/mpeg4-iod-xmt": {
    "source": "iana"
  },
  "application/mrb-consumer+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/mrb-publish+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/msc-ivr+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/msc-mixer+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/msix": {
    "compressible": false,
    "extensions": [
      "msix"
    ]
  },
  "application/msixbundle": {
    "compressible": false,
    "extensions": [
      "msixbundle"
    ]
  },
  "application/msword": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "doc",
      "dot"
    ]
  },
  "application/mud+json": {
    "source": "iana",
    "compressible": true
  },
  "application/multipart-core": {
    "source": "iana"
  },
  "application/mxf": {
    "source": "iana",
    "extensions": [
      "mxf"
    ]
  },
  "application/n-quads": {
    "source": "iana",
    "extensions": [
      "nq"
    ]
  },
  "application/n-triples": {
    "source": "iana",
    "extensions": [
      "nt"
    ]
  },
  "application/nasdata": {
    "source": "iana"
  },
  "application/news-checkgroups": {
    "source": "iana",
    "charset": "US-ASCII"
  },
  "application/news-groupinfo": {
    "source": "iana",
    "charset": "US-ASCII"
  },
  "application/news-transmission": {
    "source": "iana"
  },
  "application/nlsml+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/node": {
    "source": "iana",
    "extensions": [
      "cjs"
    ]
  },
  "application/nss": {
    "source": "iana"
  },
  "application/oauth-authz-req+jwt": {
    "source": "iana"
  },
  "application/oblivious-dns-message": {
    "source": "iana"
  },
  "application/ocsp-request": {
    "source": "iana"
  },
  "application/ocsp-response": {
    "source": "iana"
  },
  "application/octet-stream": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "bin",
      "dms",
      "lrf",
      "mar",
      "so",
      "dist",
      "distz",
      "pkg",
      "bpk",
      "dump",
      "elc",
      "deploy",
      "exe",
      "dll",
      "deb",
      "dmg",
      "iso",
      "img",
      "msi",
      "msp",
      "msm",
      "buffer"
    ]
  },
  "application/oda": {
    "source": "iana",
    "extensions": [
      "oda"
    ]
  },
  "application/odm+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/odx": {
    "source": "iana"
  },
  "application/oebps-package+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "opf"
    ]
  },
  "application/ogg": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "ogx"
    ]
  },
  "application/omdoc+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "omdoc"
    ]
  },
  "application/onenote": {
    "source": "apache",
    "extensions": [
      "onetoc",
      "onetoc2",
      "onetmp",
      "onepkg"
    ]
  },
  "application/opc-nodeset+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/oscore": {
    "source": "iana"
  },
  "application/oxps": {
    "source": "iana",
    "extensions": [
      "oxps"
    ]
  },
  "application/p21": {
    "source": "iana"
  },
  "application/p21+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/p2p-overlay+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "relo"
    ]
  },
  "application/parityfec": {
    "source": "iana"
  },
  "application/passport": {
    "source": "iana"
  },
  "application/patch-ops-error+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xer"
    ]
  },
  "application/pdf": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "pdf"
    ]
  },
  "application/pdx": {
    "source": "iana"
  },
  "application/pem-certificate-chain": {
    "source": "iana"
  },
  "application/pgp-encrypted": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "pgp"
    ]
  },
  "application/pgp-keys": {
    "source": "iana",
    "extensions": [
      "asc"
    ]
  },
  "application/pgp-signature": {
    "source": "iana",
    "extensions": [
      "sig",
      "asc"
    ]
  },
  "application/pics-rules": {
    "source": "apache",
    "extensions": [
      "prf"
    ]
  },
  "application/pidf+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/pidf-diff+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/pkcs10": {
    "source": "iana",
    "extensions": [
      "p10"
    ]
  },
  "application/pkcs12": {
    "source": "iana"
  },
  "application/pkcs7-mime": {
    "source": "iana",
    "extensions": [
      "p7m",
      "p7c"
    ]
  },
  "application/pkcs7-signature": {
    "source": "iana",
    "extensions": [
      "p7s"
    ]
  },
  "application/pkcs8": {
    "source": "iana",
    "extensions": [
      "p8"
    ]
  },
  "application/pkcs8-encrypted": {
    "source": "iana"
  },
  "application/pkix-attr-cert": {
    "source": "iana",
    "extensions": [
      "ac"
    ]
  },
  "application/pkix-cert": {
    "source": "iana",
    "extensions": [
      "cer"
    ]
  },
  "application/pkix-crl": {
    "source": "iana",
    "extensions": [
      "crl"
    ]
  },
  "application/pkix-pkipath": {
    "source": "iana",
    "extensions": [
      "pkipath"
    ]
  },
  "application/pkixcmp": {
    "source": "iana",
    "extensions": [
      "pki"
    ]
  },
  "application/pls+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "pls"
    ]
  },
  "application/poc-settings+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/postscript": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "ai",
      "eps",
      "ps"
    ]
  },
  "application/ppsp-tracker+json": {
    "source": "iana",
    "compressible": true
  },
  "application/problem+json": {
    "source": "iana",
    "compressible": true
  },
  "application/problem+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/provenance+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "provx"
    ]
  },
  "application/prs.alvestrand.titrax-sheet": {
    "source": "iana"
  },
  "application/prs.cww": {
    "source": "iana",
    "extensions": [
      "cww"
    ]
  },
  "application/prs.cyn": {
    "source": "iana",
    "charset": "7-BIT"
  },
  "application/prs.hpub+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/prs.nprend": {
    "source": "iana"
  },
  "application/prs.plucker": {
    "source": "iana"
  },
  "application/prs.rdf-xml-crypt": {
    "source": "iana"
  },
  "application/prs.xsf+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xsf"
    ]
  },
  "application/pskc+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "pskcxml"
    ]
  },
  "application/pvd+json": {
    "source": "iana",
    "compressible": true
  },
  "application/qsig": {
    "source": "iana"
  },
  "application/raml+yaml": {
    "compressible": true,
    "extensions": [
      "raml"
    ]
  },
  "application/raptorfec": {
    "source": "iana"
  },
  "application/rdap+json": {
    "source": "iana",
    "compressible": true
  },
  "application/rdf+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rdf",
      "owl"
    ]
  },
  "application/reginfo+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rif"
    ]
  },
  "application/relax-ng-compact-syntax": {
    "source": "iana",
    "extensions": [
      "rnc"
    ]
  },
  "application/remote-printing": {
    "source": "apache"
  },
  "application/reputon+json": {
    "source": "iana",
    "compressible": true
  },
  "application/resource-lists+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rl"
    ]
  },
  "application/resource-lists-diff+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rld"
    ]
  },
  "application/rfc+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/riscos": {
    "source": "iana"
  },
  "application/rlmi+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/rls-services+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rs"
    ]
  },
  "application/route-apd+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rapd"
    ]
  },
  "application/route-s-tsid+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "sls"
    ]
  },
  "application/route-usd+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rusd"
    ]
  },
  "application/rpki-checklist": {
    "source": "iana"
  },
  "application/rpki-ghostbusters": {
    "source": "iana",
    "extensions": [
      "gbr"
    ]
  },
  "application/rpki-manifest": {
    "source": "iana",
    "extensions": [
      "mft"
    ]
  },
  "application/rpki-publication": {
    "source": "iana"
  },
  "application/rpki-roa": {
    "source": "iana",
    "extensions": [
      "roa"
    ]
  },
  "application/rpki-updown": {
    "source": "iana"
  },
  "application/rsd+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "rsd"
    ]
  },
  "application/rss+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "rss"
    ]
  },
  "application/rtf": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rtf"
    ]
  },
  "application/rtploopback": {
    "source": "iana"
  },
  "application/rtx": {
    "source": "iana"
  },
  "application/samlassertion+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/samlmetadata+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/sarif+json": {
    "source": "iana",
    "compressible": true
  },
  "application/sarif-external-properties+json": {
    "source": "iana",
    "compressible": true
  },
  "application/sbe": {
    "source": "iana"
  },
  "application/sbml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "sbml"
    ]
  },
  "application/scaip+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/scim+json": {
    "source": "iana",
    "compressible": true
  },
  "application/scvp-cv-request": {
    "source": "iana",
    "extensions": [
      "scq"
    ]
  },
  "application/scvp-cv-response": {
    "source": "iana",
    "extensions": [
      "scs"
    ]
  },
  "application/scvp-vp-request": {
    "source": "iana",
    "extensions": [
      "spq"
    ]
  },
  "application/scvp-vp-response": {
    "source": "iana",
    "extensions": [
      "spp"
    ]
  },
  "application/sdp": {
    "source": "iana",
    "extensions": [
      "sdp"
    ]
  },
  "application/secevent+jwt": {
    "source": "iana"
  },
  "application/senml+cbor": {
    "source": "iana"
  },
  "application/senml+json": {
    "source": "iana",
    "compressible": true
  },
  "application/senml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "senmlx"
    ]
  },
  "application/senml-etch+cbor": {
    "source": "iana"
  },
  "application/senml-etch+json": {
    "source": "iana",
    "compressible": true
  },
  "application/senml-exi": {
    "source": "iana"
  },
  "application/sensml+cbor": {
    "source": "iana"
  },
  "application/sensml+json": {
    "source": "iana",
    "compressible": true
  },
  "application/sensml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "sensmlx"
    ]
  },
  "application/sensml-exi": {
    "source": "iana"
  },
  "application/sep+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/sep-exi": {
    "source": "iana"
  },
  "application/session-info": {
    "source": "iana"
  },
  "application/set-payment": {
    "source": "iana"
  },
  "application/set-payment-initiation": {
    "source": "iana",
    "extensions": [
      "setpay"
    ]
  },
  "application/set-registration": {
    "source": "iana"
  },
  "application/set-registration-initiation": {
    "source": "iana",
    "extensions": [
      "setreg"
    ]
  },
  "application/sgml": {
    "source": "iana"
  },
  "application/sgml-open-catalog": {
    "source": "iana"
  },
  "application/shf+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "shf"
    ]
  },
  "application/sieve": {
    "source": "iana",
    "extensions": [
      "siv",
      "sieve"
    ]
  },
  "application/simple-filter+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/simple-message-summary": {
    "source": "iana"
  },
  "application/simplesymbolcontainer": {
    "source": "iana"
  },
  "application/sipc": {
    "source": "iana"
  },
  "application/slate": {
    "source": "iana"
  },
  "application/smil": {
    "source": "apache"
  },
  "application/smil+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "smi",
      "smil"
    ]
  },
  "application/smpte336m": {
    "source": "iana"
  },
  "application/soap+fastinfoset": {
    "source": "iana"
  },
  "application/soap+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/sparql-query": {
    "source": "iana",
    "extensions": [
      "rq"
    ]
  },
  "application/sparql-results+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "srx"
    ]
  },
  "application/spdx+json": {
    "source": "iana",
    "compressible": true
  },
  "application/spirits-event+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/sql": {
    "source": "iana",
    "extensions": [
      "sql"
    ]
  },
  "application/srgs": {
    "source": "iana",
    "extensions": [
      "gram"
    ]
  },
  "application/srgs+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "grxml"
    ]
  },
  "application/sru+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "sru"
    ]
  },
  "application/ssdl+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "ssdl"
    ]
  },
  "application/ssml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "ssml"
    ]
  },
  "application/stix+json": {
    "source": "iana",
    "compressible": true
  },
  "application/swid+cbor": {
    "source": "iana"
  },
  "application/swid+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "swidtag"
    ]
  },
  "application/tamp-apex-update": {
    "source": "iana"
  },
  "application/tamp-apex-update-confirm": {
    "source": "iana"
  },
  "application/tamp-community-update": {
    "source": "iana"
  },
  "application/tamp-community-update-confirm": {
    "source": "iana"
  },
  "application/tamp-error": {
    "source": "iana"
  },
  "application/tamp-sequence-adjust": {
    "source": "iana"
  },
  "application/tamp-sequence-adjust-confirm": {
    "source": "iana"
  },
  "application/tamp-status-query": {
    "source": "iana"
  },
  "application/tamp-status-response": {
    "source": "iana"
  },
  "application/tamp-update": {
    "source": "iana"
  },
  "application/tamp-update-confirm": {
    "source": "iana"
  },
  "application/tar": {
    "compressible": true
  },
  "application/taxii+json": {
    "source": "iana",
    "compressible": true
  },
  "application/td+json": {
    "source": "iana",
    "compressible": true
  },
  "application/tei+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "tei",
      "teicorpus"
    ]
  },
  "application/tetra_isi": {
    "source": "iana"
  },
  "application/thraud+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "tfi"
    ]
  },
  "application/timestamp-query": {
    "source": "iana"
  },
  "application/timestamp-reply": {
    "source": "iana"
  },
  "application/timestamped-data": {
    "source": "iana",
    "extensions": [
      "tsd"
    ]
  },
  "application/tlsrpt+gzip": {
    "source": "iana"
  },
  "application/tlsrpt+json": {
    "source": "iana",
    "compressible": true
  },
  "application/tm+json": {
    "source": "iana",
    "compressible": true
  },
  "application/tnauthlist": {
    "source": "iana"
  },
  "application/token-introspection+jwt": {
    "source": "iana"
  },
  "application/toml": {
    "compressible": true,
    "extensions": [
      "toml"
    ]
  },
  "application/trickle-ice-sdpfrag": {
    "source": "iana"
  },
  "application/trig": {
    "source": "iana",
    "extensions": [
      "trig"
    ]
  },
  "application/ttml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "ttml"
    ]
  },
  "application/tve-trigger": {
    "source": "iana"
  },
  "application/tzif": {
    "source": "iana"
  },
  "application/tzif-leap": {
    "source": "iana"
  },
  "application/ubjson": {
    "compressible": false,
    "extensions": [
      "ubj"
    ]
  },
  "application/ulpfec": {
    "source": "iana"
  },
  "application/urc-grpsheet+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/urc-ressheet+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rsheet"
    ]
  },
  "application/urc-targetdesc+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "td"
    ]
  },
  "application/urc-uisocketdesc+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vcard+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vcard+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vemmi": {
    "source": "iana"
  },
  "application/vividence.scriptfile": {
    "source": "apache"
  },
  "application/vnd.1000minds.decision-model+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "1km"
    ]
  },
  "application/vnd.3gpp-prose+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp-prose-pc3a+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp-prose-pc3ach+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp-prose-pc3ch+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp-prose-pc8+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp-v2x-local-service-information": {
    "source": "iana"
  },
  "application/vnd.3gpp.5gnas": {
    "source": "iana"
  },
  "application/vnd.3gpp.access-transfer-events+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.bsf+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.gmop+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.gtpc": {
    "source": "iana"
  },
  "application/vnd.3gpp.interworking-data": {
    "source": "iana"
  },
  "application/vnd.3gpp.lpp": {
    "source": "iana"
  },
  "application/vnd.3gpp.mc-signalling-ear": {
    "source": "iana"
  },
  "application/vnd.3gpp.mcdata-affiliation-command+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcdata-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcdata-msgstore-ctrl-request+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcdata-payload": {
    "source": "iana"
  },
  "application/vnd.3gpp.mcdata-regroup+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcdata-service-config+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcdata-signalling": {
    "source": "iana"
  },
  "application/vnd.3gpp.mcdata-ue-config+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcdata-user-profile+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcptt-affiliation-command+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcptt-floor-request+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcptt-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcptt-location-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcptt-mbms-usage-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcptt-service-config+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcptt-signed+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcptt-ue-config+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcptt-ue-init-config+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcptt-user-profile+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcvideo-affiliation-command+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcvideo-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcvideo-location-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcvideo-mbms-usage-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcvideo-service-config+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcvideo-transmission-request+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcvideo-ue-config+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mcvideo-user-profile+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.mid-call+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.ngap": {
    "source": "iana"
  },
  "application/vnd.3gpp.pfcp": {
    "source": "iana"
  },
  "application/vnd.3gpp.pic-bw-large": {
    "source": "iana",
    "extensions": [
      "plb"
    ]
  },
  "application/vnd.3gpp.pic-bw-small": {
    "source": "iana",
    "extensions": [
      "psb"
    ]
  },
  "application/vnd.3gpp.pic-bw-var": {
    "source": "iana",
    "extensions": [
      "pvb"
    ]
  },
  "application/vnd.3gpp.s1ap": {
    "source": "iana"
  },
  "application/vnd.3gpp.seal-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.seal-location-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.sms": {
    "source": "iana"
  },
  "application/vnd.3gpp.sms+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.srvcc-ext+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.srvcc-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.state-and-event-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.ussd+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp.vae-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp2.bcmcsinfo+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.3gpp2.sms": {
    "source": "iana"
  },
  "application/vnd.3gpp2.tcap": {
    "source": "iana",
    "extensions": [
      "tcap"
    ]
  },
  "application/vnd.3lightssoftware.imagescal": {
    "source": "iana"
  },
  "application/vnd.3m.post-it-notes": {
    "source": "iana",
    "extensions": [
      "pwn"
    ]
  },
  "application/vnd.accpac.simply.aso": {
    "source": "iana",
    "extensions": [
      "aso"
    ]
  },
  "application/vnd.accpac.simply.imp": {
    "source": "iana",
    "extensions": [
      "imp"
    ]
  },
  "application/vnd.acucobol": {
    "source": "iana",
    "extensions": [
      "acu"
    ]
  },
  "application/vnd.acucorp": {
    "source": "iana",
    "extensions": [
      "atc",
      "acutc"
    ]
  },
  "application/vnd.adobe.air-application-installer-package+zip": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "air"
    ]
  },
  "application/vnd.adobe.flash.movie": {
    "source": "iana"
  },
  "application/vnd.adobe.formscentral.fcdt": {
    "source": "iana",
    "extensions": [
      "fcdt"
    ]
  },
  "application/vnd.adobe.fxp": {
    "source": "iana",
    "extensions": [
      "fxp",
      "fxpl"
    ]
  },
  "application/vnd.adobe.partial-upload": {
    "source": "iana"
  },
  "application/vnd.adobe.xdp+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xdp"
    ]
  },
  "application/vnd.adobe.xfdf": {
    "source": "apache",
    "extensions": [
      "xfdf"
    ]
  },
  "application/vnd.aether.imp": {
    "source": "iana"
  },
  "application/vnd.afpc.afplinedata": {
    "source": "iana"
  },
  "application/vnd.afpc.afplinedata-pagedef": {
    "source": "iana"
  },
  "application/vnd.afpc.cmoca-cmresource": {
    "source": "iana"
  },
  "application/vnd.afpc.foca-charset": {
    "source": "iana"
  },
  "application/vnd.afpc.foca-codedfont": {
    "source": "iana"
  },
  "application/vnd.afpc.foca-codepage": {
    "source": "iana"
  },
  "application/vnd.afpc.modca": {
    "source": "iana"
  },
  "application/vnd.afpc.modca-cmtable": {
    "source": "iana"
  },
  "application/vnd.afpc.modca-formdef": {
    "source": "iana"
  },
  "application/vnd.afpc.modca-mediummap": {
    "source": "iana"
  },
  "application/vnd.afpc.modca-objectcontainer": {
    "source": "iana"
  },
  "application/vnd.afpc.modca-overlay": {
    "source": "iana"
  },
  "application/vnd.afpc.modca-pagesegment": {
    "source": "iana"
  },
  "application/vnd.age": {
    "source": "iana",
    "extensions": [
      "age"
    ]
  },
  "application/vnd.ah-barcode": {
    "source": "apache"
  },
  "application/vnd.ahead.space": {
    "source": "iana",
    "extensions": [
      "ahead"
    ]
  },
  "application/vnd.airzip.filesecure.azf": {
    "source": "iana",
    "extensions": [
      "azf"
    ]
  },
  "application/vnd.airzip.filesecure.azs": {
    "source": "iana",
    "extensions": [
      "azs"
    ]
  },
  "application/vnd.amadeus+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.amazon.ebook": {
    "source": "apache",
    "extensions": [
      "azw"
    ]
  },
  "application/vnd.amazon.mobi8-ebook": {
    "source": "iana"
  },
  "application/vnd.americandynamics.acc": {
    "source": "iana",
    "extensions": [
      "acc"
    ]
  },
  "application/vnd.amiga.ami": {
    "source": "iana",
    "extensions": [
      "ami"
    ]
  },
  "application/vnd.amundsen.maze+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.android.ota": {
    "source": "iana"
  },
  "application/vnd.android.package-archive": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "apk"
    ]
  },
  "application/vnd.anki": {
    "source": "iana"
  },
  "application/vnd.anser-web-certificate-issue-initiation": {
    "source": "iana",
    "extensions": [
      "cii"
    ]
  },
  "application/vnd.anser-web-funds-transfer-initiation": {
    "source": "apache",
    "extensions": [
      "fti"
    ]
  },
  "application/vnd.antix.game-component": {
    "source": "iana",
    "extensions": [
      "atx"
    ]
  },
  "application/vnd.apache.arrow.file": {
    "source": "iana"
  },
  "application/vnd.apache.arrow.stream": {
    "source": "iana"
  },
  "application/vnd.apache.thrift.binary": {
    "source": "iana"
  },
  "application/vnd.apache.thrift.compact": {
    "source": "iana"
  },
  "application/vnd.apache.thrift.json": {
    "source": "iana"
  },
  "application/vnd.apexlang": {
    "source": "iana"
  },
  "application/vnd.api+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.aplextor.warrp+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.apothekende.reservation+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.apple.installer+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mpkg"
    ]
  },
  "application/vnd.apple.keynote": {
    "source": "iana",
    "extensions": [
      "key"
    ]
  },
  "application/vnd.apple.mpegurl": {
    "source": "iana",
    "extensions": [
      "m3u8"
    ]
  },
  "application/vnd.apple.numbers": {
    "source": "iana",
    "extensions": [
      "numbers"
    ]
  },
  "application/vnd.apple.pages": {
    "source": "iana",
    "extensions": [
      "pages"
    ]
  },
  "application/vnd.apple.pkpass": {
    "compressible": false,
    "extensions": [
      "pkpass"
    ]
  },
  "application/vnd.arastra.swi": {
    "source": "apache"
  },
  "application/vnd.aristanetworks.swi": {
    "source": "iana",
    "extensions": [
      "swi"
    ]
  },
  "application/vnd.artisan+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.artsquare": {
    "source": "iana"
  },
  "application/vnd.astraea-software.iota": {
    "source": "iana",
    "extensions": [
      "iota"
    ]
  },
  "application/vnd.audiograph": {
    "source": "iana",
    "extensions": [
      "aep"
    ]
  },
  "application/vnd.autopackage": {
    "source": "iana"
  },
  "application/vnd.avalon+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.avistar+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.balsamiq.bmml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "bmml"
    ]
  },
  "application/vnd.balsamiq.bmpr": {
    "source": "iana"
  },
  "application/vnd.banana-accounting": {
    "source": "iana"
  },
  "application/vnd.bbf.usp.error": {
    "source": "iana"
  },
  "application/vnd.bbf.usp.msg": {
    "source": "iana"
  },
  "application/vnd.bbf.usp.msg+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.bekitzur-stech+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.belightsoft.lhzd+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.belightsoft.lhzl+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.bint.med-content": {
    "source": "iana"
  },
  "application/vnd.biopax.rdf+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.blink-idb-value-wrapper": {
    "source": "iana"
  },
  "application/vnd.blueice.multipass": {
    "source": "iana",
    "extensions": [
      "mpm"
    ]
  },
  "application/vnd.bluetooth.ep.oob": {
    "source": "iana"
  },
  "application/vnd.bluetooth.le.oob": {
    "source": "iana"
  },
  "application/vnd.bmi": {
    "source": "iana",
    "extensions": [
      "bmi"
    ]
  },
  "application/vnd.bpf": {
    "source": "iana"
  },
  "application/vnd.bpf3": {
    "source": "iana"
  },
  "application/vnd.businessobjects": {
    "source": "iana",
    "extensions": [
      "rep"
    ]
  },
  "application/vnd.byu.uapi+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.cab-jscript": {
    "source": "iana"
  },
  "application/vnd.canon-cpdl": {
    "source": "iana"
  },
  "application/vnd.canon-lips": {
    "source": "iana"
  },
  "application/vnd.capasystems-pg+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.cendio.thinlinc.clientconf": {
    "source": "iana"
  },
  "application/vnd.century-systems.tcp_stream": {
    "source": "iana"
  },
  "application/vnd.chemdraw+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "cdxml"
    ]
  },
  "application/vnd.chess-pgn": {
    "source": "iana"
  },
  "application/vnd.chipnuts.karaoke-mmd": {
    "source": "iana",
    "extensions": [
      "mmd"
    ]
  },
  "application/vnd.ciedi": {
    "source": "iana"
  },
  "application/vnd.cinderella": {
    "source": "iana",
    "extensions": [
      "cdy"
    ]
  },
  "application/vnd.cirpack.isdn-ext": {
    "source": "iana"
  },
  "application/vnd.citationstyles.style+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "csl"
    ]
  },
  "application/vnd.claymore": {
    "source": "iana",
    "extensions": [
      "cla"
    ]
  },
  "application/vnd.cloanto.rp9": {
    "source": "iana",
    "extensions": [
      "rp9"
    ]
  },
  "application/vnd.clonk.c4group": {
    "source": "iana",
    "extensions": [
      "c4g",
      "c4d",
      "c4f",
      "c4p",
      "c4u"
    ]
  },
  "application/vnd.cluetrust.cartomobile-config": {
    "source": "iana",
    "extensions": [
      "c11amc"
    ]
  },
  "application/vnd.cluetrust.cartomobile-config-pkg": {
    "source": "iana",
    "extensions": [
      "c11amz"
    ]
  },
  "application/vnd.cncf.helm.chart.content.v1.tar+gzip": {
    "source": "iana"
  },
  "application/vnd.cncf.helm.chart.provenance.v1.prov": {
    "source": "iana"
  },
  "application/vnd.coffeescript": {
    "source": "iana"
  },
  "application/vnd.collabio.xodocuments.document": {
    "source": "iana"
  },
  "application/vnd.collabio.xodocuments.document-template": {
    "source": "iana"
  },
  "application/vnd.collabio.xodocuments.presentation": {
    "source": "iana"
  },
  "application/vnd.collabio.xodocuments.presentation-template": {
    "source": "iana"
  },
  "application/vnd.collabio.xodocuments.spreadsheet": {
    "source": "iana"
  },
  "application/vnd.collabio.xodocuments.spreadsheet-template": {
    "source": "iana"
  },
  "application/vnd.collection+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.collection.doc+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.collection.next+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.comicbook+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.comicbook-rar": {
    "source": "iana"
  },
  "application/vnd.commerce-battelle": {
    "source": "iana"
  },
  "application/vnd.commonspace": {
    "source": "iana",
    "extensions": [
      "csp"
    ]
  },
  "application/vnd.contact.cmsg": {
    "source": "iana",
    "extensions": [
      "cdbcmsg"
    ]
  },
  "application/vnd.coreos.ignition+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.cosmocaller": {
    "source": "iana",
    "extensions": [
      "cmc"
    ]
  },
  "application/vnd.crick.clicker": {
    "source": "iana",
    "extensions": [
      "clkx"
    ]
  },
  "application/vnd.crick.clicker.keyboard": {
    "source": "iana",
    "extensions": [
      "clkk"
    ]
  },
  "application/vnd.crick.clicker.palette": {
    "source": "iana",
    "extensions": [
      "clkp"
    ]
  },
  "application/vnd.crick.clicker.template": {
    "source": "iana",
    "extensions": [
      "clkt"
    ]
  },
  "application/vnd.crick.clicker.wordbank": {
    "source": "iana",
    "extensions": [
      "clkw"
    ]
  },
  "application/vnd.criticaltools.wbs+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "wbs"
    ]
  },
  "application/vnd.cryptii.pipe+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.crypto-shade-file": {
    "source": "iana"
  },
  "application/vnd.cryptomator.encrypted": {
    "source": "iana"
  },
  "application/vnd.cryptomator.vault": {
    "source": "iana"
  },
  "application/vnd.ctc-posml": {
    "source": "iana",
    "extensions": [
      "pml"
    ]
  },
  "application/vnd.ctct.ws+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.cups-pdf": {
    "source": "iana"
  },
  "application/vnd.cups-postscript": {
    "source": "iana"
  },
  "application/vnd.cups-ppd": {
    "source": "iana",
    "extensions": [
      "ppd"
    ]
  },
  "application/vnd.cups-raster": {
    "source": "iana"
  },
  "application/vnd.cups-raw": {
    "source": "iana"
  },
  "application/vnd.curl": {
    "source": "iana"
  },
  "application/vnd.curl.car": {
    "source": "apache",
    "extensions": [
      "car"
    ]
  },
  "application/vnd.curl.pcurl": {
    "source": "apache",
    "extensions": [
      "pcurl"
    ]
  },
  "application/vnd.cyan.dean.root+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.cybank": {
    "source": "iana"
  },
  "application/vnd.cyclonedx+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.cyclonedx+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.d2l.coursepackage1p0+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.d3m-dataset": {
    "source": "iana"
  },
  "application/vnd.d3m-problem": {
    "source": "iana"
  },
  "application/vnd.dart": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "dart"
    ]
  },
  "application/vnd.data-vision.rdz": {
    "source": "iana",
    "extensions": [
      "rdz"
    ]
  },
  "application/vnd.datalog": {
    "source": "iana"
  },
  "application/vnd.datapackage+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dataresource+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dbf": {
    "source": "iana",
    "extensions": [
      "dbf"
    ]
  },
  "application/vnd.debian.binary-package": {
    "source": "iana"
  },
  "application/vnd.dece.data": {
    "source": "iana",
    "extensions": [
      "uvf",
      "uvvf",
      "uvd",
      "uvvd"
    ]
  },
  "application/vnd.dece.ttml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "uvt",
      "uvvt"
    ]
  },
  "application/vnd.dece.unspecified": {
    "source": "iana",
    "extensions": [
      "uvx",
      "uvvx"
    ]
  },
  "application/vnd.dece.zip": {
    "source": "iana",
    "extensions": [
      "uvz",
      "uvvz"
    ]
  },
  "application/vnd.denovo.fcselayout-link": {
    "source": "iana",
    "extensions": [
      "fe_launch"
    ]
  },
  "application/vnd.desmume.movie": {
    "source": "iana"
  },
  "application/vnd.dir-bi.plate-dl-nosuffix": {
    "source": "iana"
  },
  "application/vnd.dm.delegation+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dna": {
    "source": "iana",
    "extensions": [
      "dna"
    ]
  },
  "application/vnd.document+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dolby.mlp": {
    "source": "apache",
    "extensions": [
      "mlp"
    ]
  },
  "application/vnd.dolby.mobile.1": {
    "source": "iana"
  },
  "application/vnd.dolby.mobile.2": {
    "source": "iana"
  },
  "application/vnd.doremir.scorecloud-binary-document": {
    "source": "iana"
  },
  "application/vnd.dpgraph": {
    "source": "iana",
    "extensions": [
      "dpg"
    ]
  },
  "application/vnd.dreamfactory": {
    "source": "iana",
    "extensions": [
      "dfac"
    ]
  },
  "application/vnd.drive+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ds-keypoint": {
    "source": "apache",
    "extensions": [
      "kpxx"
    ]
  },
  "application/vnd.dtg.local": {
    "source": "iana"
  },
  "application/vnd.dtg.local.flash": {
    "source": "iana"
  },
  "application/vnd.dtg.local.html": {
    "source": "iana"
  },
  "application/vnd.dvb.ait": {
    "source": "iana",
    "extensions": [
      "ait"
    ]
  },
  "application/vnd.dvb.dvbisl+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dvb.dvbj": {
    "source": "iana"
  },
  "application/vnd.dvb.esgcontainer": {
    "source": "iana"
  },
  "application/vnd.dvb.ipdcdftnotifaccess": {
    "source": "iana"
  },
  "application/vnd.dvb.ipdcesgaccess": {
    "source": "iana"
  },
  "application/vnd.dvb.ipdcesgaccess2": {
    "source": "iana"
  },
  "application/vnd.dvb.ipdcesgpdd": {
    "source": "iana"
  },
  "application/vnd.dvb.ipdcroaming": {
    "source": "iana"
  },
  "application/vnd.dvb.iptv.alfec-base": {
    "source": "iana"
  },
  "application/vnd.dvb.iptv.alfec-enhancement": {
    "source": "iana"
  },
  "application/vnd.dvb.notif-aggregate-root+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dvb.notif-container+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dvb.notif-generic+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dvb.notif-ia-msglist+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dvb.notif-ia-registration-request+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dvb.notif-ia-registration-response+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dvb.notif-init+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.dvb.pfr": {
    "source": "iana"
  },
  "application/vnd.dvb.service": {
    "source": "iana",
    "extensions": [
      "svc"
    ]
  },
  "application/vnd.dxr": {
    "source": "iana"
  },
  "application/vnd.dynageo": {
    "source": "iana",
    "extensions": [
      "geo"
    ]
  },
  "application/vnd.dzr": {
    "source": "iana"
  },
  "application/vnd.easykaraoke.cdgdownload": {
    "source": "iana"
  },
  "application/vnd.ecdis-update": {
    "source": "iana"
  },
  "application/vnd.ecip.rlp": {
    "source": "iana"
  },
  "application/vnd.eclipse.ditto+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ecowin.chart": {
    "source": "iana",
    "extensions": [
      "mag"
    ]
  },
  "application/vnd.ecowin.filerequest": {
    "source": "iana"
  },
  "application/vnd.ecowin.fileupdate": {
    "source": "iana"
  },
  "application/vnd.ecowin.series": {
    "source": "iana"
  },
  "application/vnd.ecowin.seriesrequest": {
    "source": "iana"
  },
  "application/vnd.ecowin.seriesupdate": {
    "source": "iana"
  },
  "application/vnd.efi.img": {
    "source": "iana"
  },
  "application/vnd.efi.iso": {
    "source": "iana"
  },
  "application/vnd.eln+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.emclient.accessrequest+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.enliven": {
    "source": "iana",
    "extensions": [
      "nml"
    ]
  },
  "application/vnd.enphase.envoy": {
    "source": "iana"
  },
  "application/vnd.eprints.data+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.epson.esf": {
    "source": "iana",
    "extensions": [
      "esf"
    ]
  },
  "application/vnd.epson.msf": {
    "source": "iana",
    "extensions": [
      "msf"
    ]
  },
  "application/vnd.epson.quickanime": {
    "source": "iana",
    "extensions": [
      "qam"
    ]
  },
  "application/vnd.epson.salt": {
    "source": "iana",
    "extensions": [
      "slt"
    ]
  },
  "application/vnd.epson.ssf": {
    "source": "iana",
    "extensions": [
      "ssf"
    ]
  },
  "application/vnd.ericsson.quickcall": {
    "source": "iana"
  },
  "application/vnd.espass-espass+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.eszigno3+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "es3",
      "et3"
    ]
  },
  "application/vnd.etsi.aoc+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.asic-e+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.etsi.asic-s+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.etsi.cug+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.iptvcommand+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.iptvdiscovery+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.iptvprofile+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.iptvsad-bc+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.iptvsad-cod+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.iptvsad-npvr+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.iptvservice+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.iptvsync+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.iptvueprofile+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.mcid+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.mheg5": {
    "source": "iana"
  },
  "application/vnd.etsi.overload-control-policy-dataset+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.pstn+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.sci+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.simservs+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.timestamp-token": {
    "source": "iana"
  },
  "application/vnd.etsi.tsl+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.etsi.tsl.der": {
    "source": "iana"
  },
  "application/vnd.eu.kasparian.car+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.eudora.data": {
    "source": "iana"
  },
  "application/vnd.evolv.ecig.profile": {
    "source": "iana"
  },
  "application/vnd.evolv.ecig.settings": {
    "source": "iana"
  },
  "application/vnd.evolv.ecig.theme": {
    "source": "iana"
  },
  "application/vnd.exstream-empower+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.exstream-package": {
    "source": "iana"
  },
  "application/vnd.ezpix-album": {
    "source": "iana",
    "extensions": [
      "ez2"
    ]
  },
  "application/vnd.ezpix-package": {
    "source": "iana",
    "extensions": [
      "ez3"
    ]
  },
  "application/vnd.f-secure.mobile": {
    "source": "iana"
  },
  "application/vnd.familysearch.gedcom+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.fastcopy-disk-image": {
    "source": "iana"
  },
  "application/vnd.fdf": {
    "source": "apache",
    "extensions": [
      "fdf"
    ]
  },
  "application/vnd.fdsn.mseed": {
    "source": "iana",
    "extensions": [
      "mseed"
    ]
  },
  "application/vnd.fdsn.seed": {
    "source": "iana",
    "extensions": [
      "seed",
      "dataless"
    ]
  },
  "application/vnd.ffsns": {
    "source": "iana"
  },
  "application/vnd.ficlab.flb+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.filmit.zfc": {
    "source": "iana"
  },
  "application/vnd.fints": {
    "source": "iana"
  },
  "application/vnd.firemonkeys.cloudcell": {
    "source": "iana"
  },
  "application/vnd.flographit": {
    "source": "iana",
    "extensions": [
      "gph"
    ]
  },
  "application/vnd.fluxtime.clip": {
    "source": "iana",
    "extensions": [
      "ftc"
    ]
  },
  "application/vnd.font-fontforge-sfd": {
    "source": "iana"
  },
  "application/vnd.framemaker": {
    "source": "iana",
    "extensions": [
      "fm",
      "frame",
      "maker",
      "book"
    ]
  },
  "application/vnd.frogans.fnc": {
    "source": "apache",
    "extensions": [
      "fnc"
    ]
  },
  "application/vnd.frogans.ltf": {
    "source": "apache",
    "extensions": [
      "ltf"
    ]
  },
  "application/vnd.fsc.weblaunch": {
    "source": "iana",
    "extensions": [
      "fsc"
    ]
  },
  "application/vnd.fujifilm.fb.docuworks": {
    "source": "iana"
  },
  "application/vnd.fujifilm.fb.docuworks.binder": {
    "source": "iana"
  },
  "application/vnd.fujifilm.fb.docuworks.container": {
    "source": "iana"
  },
  "application/vnd.fujifilm.fb.jfi+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.fujitsu.oasys": {
    "source": "iana",
    "extensions": [
      "oas"
    ]
  },
  "application/vnd.fujitsu.oasys2": {
    "source": "iana",
    "extensions": [
      "oa2"
    ]
  },
  "application/vnd.fujitsu.oasys3": {
    "source": "iana",
    "extensions": [
      "oa3"
    ]
  },
  "application/vnd.fujitsu.oasysgp": {
    "source": "iana",
    "extensions": [
      "fg5"
    ]
  },
  "application/vnd.fujitsu.oasysprs": {
    "source": "iana",
    "extensions": [
      "bh2"
    ]
  },
  "application/vnd.fujixerox.art-ex": {
    "source": "iana"
  },
  "application/vnd.fujixerox.art4": {
    "source": "iana"
  },
  "application/vnd.fujixerox.ddd": {
    "source": "iana",
    "extensions": [
      "ddd"
    ]
  },
  "application/vnd.fujixerox.docuworks": {
    "source": "iana",
    "extensions": [
      "xdw"
    ]
  },
  "application/vnd.fujixerox.docuworks.binder": {
    "source": "iana",
    "extensions": [
      "xbd"
    ]
  },
  "application/vnd.fujixerox.docuworks.container": {
    "source": "iana"
  },
  "application/vnd.fujixerox.hbpl": {
    "source": "iana"
  },
  "application/vnd.fut-misnet": {
    "source": "iana"
  },
  "application/vnd.futoin+cbor": {
    "source": "iana"
  },
  "application/vnd.futoin+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.fuzzysheet": {
    "source": "iana",
    "extensions": [
      "fzs"
    ]
  },
  "application/vnd.genomatix.tuxedo": {
    "source": "iana",
    "extensions": [
      "txd"
    ]
  },
  "application/vnd.genozip": {
    "source": "iana"
  },
  "application/vnd.gentics.grd+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.gentoo.catmetadata+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.gentoo.ebuild": {
    "source": "iana"
  },
  "application/vnd.gentoo.eclass": {
    "source": "iana"
  },
  "application/vnd.gentoo.gpkg": {
    "source": "iana"
  },
  "application/vnd.gentoo.manifest": {
    "source": "iana"
  },
  "application/vnd.gentoo.pkgmetadata+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.gentoo.xpak": {
    "source": "iana"
  },
  "application/vnd.geo+json": {
    "source": "apache",
    "compressible": true
  },
  "application/vnd.geocube+xml": {
    "source": "apache",
    "compressible": true
  },
  "application/vnd.geogebra.file": {
    "source": "iana",
    "extensions": [
      "ggb"
    ]
  },
  "application/vnd.geogebra.slides": {
    "source": "iana"
  },
  "application/vnd.geogebra.tool": {
    "source": "iana",
    "extensions": [
      "ggt"
    ]
  },
  "application/vnd.geometry-explorer": {
    "source": "iana",
    "extensions": [
      "gex",
      "gre"
    ]
  },
  "application/vnd.geonext": {
    "source": "iana",
    "extensions": [
      "gxt"
    ]
  },
  "application/vnd.geoplan": {
    "source": "iana",
    "extensions": [
      "g2w"
    ]
  },
  "application/vnd.geospace": {
    "source": "iana",
    "extensions": [
      "g3w"
    ]
  },
  "application/vnd.gerber": {
    "source": "iana"
  },
  "application/vnd.globalplatform.card-content-mgt": {
    "source": "iana"
  },
  "application/vnd.globalplatform.card-content-mgt-response": {
    "source": "iana"
  },
  "application/vnd.gmx": {
    "source": "iana",
    "extensions": [
      "gmx"
    ]
  },
  "application/vnd.gnu.taler.exchange+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.gnu.taler.merchant+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.google-apps.document": {
    "compressible": false,
    "extensions": [
      "gdoc"
    ]
  },
  "application/vnd.google-apps.presentation": {
    "compressible": false,
    "extensions": [
      "gslides"
    ]
  },
  "application/vnd.google-apps.spreadsheet": {
    "compressible": false,
    "extensions": [
      "gsheet"
    ]
  },
  "application/vnd.google-earth.kml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "kml"
    ]
  },
  "application/vnd.google-earth.kmz": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "kmz"
    ]
  },
  "application/vnd.gov.sk.e-form+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.gov.sk.e-form+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.gov.sk.xmldatacontainer+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.gpxsee.map+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.grafeq": {
    "source": "iana",
    "extensions": [
      "gqf",
      "gqs"
    ]
  },
  "application/vnd.gridmp": {
    "source": "iana"
  },
  "application/vnd.groove-account": {
    "source": "iana",
    "extensions": [
      "gac"
    ]
  },
  "application/vnd.groove-help": {
    "source": "iana",
    "extensions": [
      "ghf"
    ]
  },
  "application/vnd.groove-identity-message": {
    "source": "iana",
    "extensions": [
      "gim"
    ]
  },
  "application/vnd.groove-injector": {
    "source": "iana",
    "extensions": [
      "grv"
    ]
  },
  "application/vnd.groove-tool-message": {
    "source": "iana",
    "extensions": [
      "gtm"
    ]
  },
  "application/vnd.groove-tool-template": {
    "source": "iana",
    "extensions": [
      "tpl"
    ]
  },
  "application/vnd.groove-vcard": {
    "source": "iana",
    "extensions": [
      "vcg"
    ]
  },
  "application/vnd.hal+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.hal+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "hal"
    ]
  },
  "application/vnd.handheld-entertainment+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "zmm"
    ]
  },
  "application/vnd.hbci": {
    "source": "iana",
    "extensions": [
      "hbci"
    ]
  },
  "application/vnd.hc+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.hcl-bireports": {
    "source": "iana"
  },
  "application/vnd.hdt": {
    "source": "iana"
  },
  "application/vnd.heroku+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.hhe.lesson-player": {
    "source": "iana",
    "extensions": [
      "les"
    ]
  },
  "application/vnd.hp-hpgl": {
    "source": "iana",
    "extensions": [
      "hpgl"
    ]
  },
  "application/vnd.hp-hpid": {
    "source": "iana",
    "extensions": [
      "hpid"
    ]
  },
  "application/vnd.hp-hps": {
    "source": "iana",
    "extensions": [
      "hps"
    ]
  },
  "application/vnd.hp-jlyt": {
    "source": "iana",
    "extensions": [
      "jlt"
    ]
  },
  "application/vnd.hp-pcl": {
    "source": "iana",
    "extensions": [
      "pcl"
    ]
  },
  "application/vnd.hp-pclxl": {
    "source": "iana",
    "extensions": [
      "pclxl"
    ]
  },
  "application/vnd.hsl": {
    "source": "iana"
  },
  "application/vnd.httphone": {
    "source": "iana"
  },
  "application/vnd.hydrostatix.sof-data": {
    "source": "iana",
    "extensions": [
      "sfd-hdstx"
    ]
  },
  "application/vnd.hyper+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.hyper-item+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.hyperdrive+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.hzn-3d-crossword": {
    "source": "iana"
  },
  "application/vnd.ibm.afplinedata": {
    "source": "apache"
  },
  "application/vnd.ibm.electronic-media": {
    "source": "iana"
  },
  "application/vnd.ibm.minipay": {
    "source": "iana",
    "extensions": [
      "mpy"
    ]
  },
  "application/vnd.ibm.modcap": {
    "source": "apache",
    "extensions": [
      "afp",
      "listafp",
      "list3820"
    ]
  },
  "application/vnd.ibm.rights-management": {
    "source": "iana",
    "extensions": [
      "irm"
    ]
  },
  "application/vnd.ibm.secure-container": {
    "source": "iana",
    "extensions": [
      "sc"
    ]
  },
  "application/vnd.iccprofile": {
    "source": "iana",
    "extensions": [
      "icc",
      "icm"
    ]
  },
  "application/vnd.ieee.1905": {
    "source": "iana"
  },
  "application/vnd.igloader": {
    "source": "iana",
    "extensions": [
      "igl"
    ]
  },
  "application/vnd.imagemeter.folder+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.imagemeter.image+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.immervision-ivp": {
    "source": "iana",
    "extensions": [
      "ivp"
    ]
  },
  "application/vnd.immervision-ivu": {
    "source": "iana",
    "extensions": [
      "ivu"
    ]
  },
  "application/vnd.ims.imsccv1p1": {
    "source": "iana"
  },
  "application/vnd.ims.imsccv1p2": {
    "source": "iana"
  },
  "application/vnd.ims.imsccv1p3": {
    "source": "iana"
  },
  "application/vnd.ims.lis.v2.result+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ims.lti.v2.toolconsumerprofile+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ims.lti.v2.toolproxy+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ims.lti.v2.toolproxy.id+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ims.lti.v2.toolsettings+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ims.lti.v2.toolsettings.simple+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.informedcontrol.rms+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.informix-visionary": {
    "source": "apache"
  },
  "application/vnd.infotech.project": {
    "source": "iana"
  },
  "application/vnd.infotech.project+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.innopath.wamp.notification": {
    "source": "iana"
  },
  "application/vnd.insors.igm": {
    "source": "iana",
    "extensions": [
      "igm"
    ]
  },
  "application/vnd.intercon.formnet": {
    "source": "iana",
    "extensions": [
      "xpw",
      "xpx"
    ]
  },
  "application/vnd.intergeo": {
    "source": "iana",
    "extensions": [
      "i2g"
    ]
  },
  "application/vnd.intertrust.digibox": {
    "source": "iana"
  },
  "application/vnd.intertrust.nncp": {
    "source": "iana"
  },
  "application/vnd.intu.qbo": {
    "source": "iana",
    "extensions": [
      "qbo"
    ]
  },
  "application/vnd.intu.qfx": {
    "source": "iana",
    "extensions": [
      "qfx"
    ]
  },
  "application/vnd.ipld.car": {
    "source": "iana"
  },
  "application/vnd.ipld.dag-cbor": {
    "source": "iana"
  },
  "application/vnd.ipld.dag-json": {
    "source": "iana"
  },
  "application/vnd.ipld.raw": {
    "source": "iana"
  },
  "application/vnd.iptc.g2.catalogitem+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.iptc.g2.conceptitem+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.iptc.g2.knowledgeitem+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.iptc.g2.newsitem+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.iptc.g2.newsmessage+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.iptc.g2.packageitem+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.iptc.g2.planningitem+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ipunplugged.rcprofile": {
    "source": "iana",
    "extensions": [
      "rcprofile"
    ]
  },
  "application/vnd.irepository.package+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "irp"
    ]
  },
  "application/vnd.is-xpr": {
    "source": "iana",
    "extensions": [
      "xpr"
    ]
  },
  "application/vnd.isac.fcs": {
    "source": "iana",
    "extensions": [
      "fcs"
    ]
  },
  "application/vnd.iso11783-10+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.jam": {
    "source": "iana",
    "extensions": [
      "jam"
    ]
  },
  "application/vnd.japannet-directory-service": {
    "source": "iana"
  },
  "application/vnd.japannet-jpnstore-wakeup": {
    "source": "iana"
  },
  "application/vnd.japannet-payment-wakeup": {
    "source": "iana"
  },
  "application/vnd.japannet-registration": {
    "source": "iana"
  },
  "application/vnd.japannet-registration-wakeup": {
    "source": "iana"
  },
  "application/vnd.japannet-setstore-wakeup": {
    "source": "iana"
  },
  "application/vnd.japannet-verification": {
    "source": "iana"
  },
  "application/vnd.japannet-verification-wakeup": {
    "source": "iana"
  },
  "application/vnd.jcp.javame.midlet-rms": {
    "source": "iana",
    "extensions": [
      "rms"
    ]
  },
  "application/vnd.jisp": {
    "source": "iana",
    "extensions": [
      "jisp"
    ]
  },
  "application/vnd.joost.joda-archive": {
    "source": "iana",
    "extensions": [
      "joda"
    ]
  },
  "application/vnd.jsk.isdn-ngn": {
    "source": "iana"
  },
  "application/vnd.kahootz": {
    "source": "iana",
    "extensions": [
      "ktz",
      "ktr"
    ]
  },
  "application/vnd.kde.karbon": {
    "source": "iana",
    "extensions": [
      "karbon"
    ]
  },
  "application/vnd.kde.kchart": {
    "source": "iana",
    "extensions": [
      "chrt"
    ]
  },
  "application/vnd.kde.kformula": {
    "source": "iana",
    "extensions": [
      "kfo"
    ]
  },
  "application/vnd.kde.kivio": {
    "source": "iana",
    "extensions": [
      "flw"
    ]
  },
  "application/vnd.kde.kontour": {
    "source": "iana",
    "extensions": [
      "kon"
    ]
  },
  "application/vnd.kde.kpresenter": {
    "source": "iana",
    "extensions": [
      "kpr",
      "kpt"
    ]
  },
  "application/vnd.kde.kspread": {
    "source": "iana",
    "extensions": [
      "ksp"
    ]
  },
  "application/vnd.kde.kword": {
    "source": "iana",
    "extensions": [
      "kwd",
      "kwt"
    ]
  },
  "application/vnd.kenameaapp": {
    "source": "iana",
    "extensions": [
      "htke"
    ]
  },
  "application/vnd.kidspiration": {
    "source": "iana",
    "extensions": [
      "kia"
    ]
  },
  "application/vnd.kinar": {
    "source": "iana",
    "extensions": [
      "kne",
      "knp"
    ]
  },
  "application/vnd.koan": {
    "source": "iana",
    "extensions": [
      "skp",
      "skd",
      "skt",
      "skm"
    ]
  },
  "application/vnd.kodak-descriptor": {
    "source": "iana",
    "extensions": [
      "sse"
    ]
  },
  "application/vnd.las": {
    "source": "iana"
  },
  "application/vnd.las.las+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.las.las+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "lasxml"
    ]
  },
  "application/vnd.laszip": {
    "source": "iana"
  },
  "application/vnd.leap+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.liberty-request+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.llamagraphics.life-balance.desktop": {
    "source": "iana",
    "extensions": [
      "lbd"
    ]
  },
  "application/vnd.llamagraphics.life-balance.exchange+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "lbe"
    ]
  },
  "application/vnd.logipipe.circuit+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.loom": {
    "source": "iana"
  },
  "application/vnd.lotus-1-2-3": {
    "source": "iana",
    "extensions": [
      "123"
    ]
  },
  "application/vnd.lotus-approach": {
    "source": "iana",
    "extensions": [
      "apr"
    ]
  },
  "application/vnd.lotus-freelance": {
    "source": "iana",
    "extensions": [
      "pre"
    ]
  },
  "application/vnd.lotus-notes": {
    "source": "iana",
    "extensions": [
      "nsf"
    ]
  },
  "application/vnd.lotus-organizer": {
    "source": "iana",
    "extensions": [
      "org"
    ]
  },
  "application/vnd.lotus-screencam": {
    "source": "iana",
    "extensions": [
      "scm"
    ]
  },
  "application/vnd.lotus-wordpro": {
    "source": "iana",
    "extensions": [
      "lwp"
    ]
  },
  "application/vnd.macports.portpkg": {
    "source": "iana",
    "extensions": [
      "portpkg"
    ]
  },
  "application/vnd.mapbox-vector-tile": {
    "source": "iana",
    "extensions": [
      "mvt"
    ]
  },
  "application/vnd.marlin.drm.actiontoken+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.marlin.drm.conftoken+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.marlin.drm.license+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.marlin.drm.mdcf": {
    "source": "iana"
  },
  "application/vnd.mason+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.maxar.archive.3tz+zip": {
    "source": "iana",
    "compressible": false
  },
  "application/vnd.maxmind.maxmind-db": {
    "source": "iana"
  },
  "application/vnd.mcd": {
    "source": "iana",
    "extensions": [
      "mcd"
    ]
  },
  "application/vnd.medcalcdata": {
    "source": "iana",
    "extensions": [
      "mc1"
    ]
  },
  "application/vnd.mediastation.cdkey": {
    "source": "iana",
    "extensions": [
      "cdkey"
    ]
  },
  "application/vnd.medicalholodeck.recordxr": {
    "source": "iana"
  },
  "application/vnd.meridian-slingshot": {
    "source": "iana"
  },
  "application/vnd.mfer": {
    "source": "iana",
    "extensions": [
      "mwf"
    ]
  },
  "application/vnd.mfmp": {
    "source": "iana",
    "extensions": [
      "mfm"
    ]
  },
  "application/vnd.micro+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.micrografx.flo": {
    "source": "iana",
    "extensions": [
      "flo"
    ]
  },
  "application/vnd.micrografx.igx": {
    "source": "iana",
    "extensions": [
      "igx"
    ]
  },
  "application/vnd.microsoft.portable-executable": {
    "source": "iana"
  },
  "application/vnd.microsoft.windows.thumbnail-cache": {
    "source": "iana"
  },
  "application/vnd.miele+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.mif": {
    "source": "iana",
    "extensions": [
      "mif"
    ]
  },
  "application/vnd.minisoft-hp3000-save": {
    "source": "iana"
  },
  "application/vnd.mitsubishi.misty-guard.trustweb": {
    "source": "iana"
  },
  "application/vnd.mobius.daf": {
    "source": "iana",
    "extensions": [
      "daf"
    ]
  },
  "application/vnd.mobius.dis": {
    "source": "iana",
    "extensions": [
      "dis"
    ]
  },
  "application/vnd.mobius.mbk": {
    "source": "iana",
    "extensions": [
      "mbk"
    ]
  },
  "application/vnd.mobius.mqy": {
    "source": "iana",
    "extensions": [
      "mqy"
    ]
  },
  "application/vnd.mobius.msl": {
    "source": "iana",
    "extensions": [
      "msl"
    ]
  },
  "application/vnd.mobius.plc": {
    "source": "iana",
    "extensions": [
      "plc"
    ]
  },
  "application/vnd.mobius.txf": {
    "source": "iana",
    "extensions": [
      "txf"
    ]
  },
  "application/vnd.mophun.application": {
    "source": "iana",
    "extensions": [
      "mpn"
    ]
  },
  "application/vnd.mophun.certificate": {
    "source": "iana",
    "extensions": [
      "mpc"
    ]
  },
  "application/vnd.motorola.flexsuite": {
    "source": "iana"
  },
  "application/vnd.motorola.flexsuite.adsi": {
    "source": "iana"
  },
  "application/vnd.motorola.flexsuite.fis": {
    "source": "iana"
  },
  "application/vnd.motorola.flexsuite.gotap": {
    "source": "iana"
  },
  "application/vnd.motorola.flexsuite.kmr": {
    "source": "iana"
  },
  "application/vnd.motorola.flexsuite.ttc": {
    "source": "iana"
  },
  "application/vnd.motorola.flexsuite.wem": {
    "source": "iana"
  },
  "application/vnd.motorola.iprm": {
    "source": "iana"
  },
  "application/vnd.mozilla.xul+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xul"
    ]
  },
  "application/vnd.ms-3mfdocument": {
    "source": "iana"
  },
  "application/vnd.ms-artgalry": {
    "source": "iana",
    "extensions": [
      "cil"
    ]
  },
  "application/vnd.ms-asf": {
    "source": "iana"
  },
  "application/vnd.ms-cab-compressed": {
    "source": "iana",
    "extensions": [
      "cab"
    ]
  },
  "application/vnd.ms-color.iccprofile": {
    "source": "apache"
  },
  "application/vnd.ms-excel": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "xls",
      "xlm",
      "xla",
      "xlc",
      "xlt",
      "xlw"
    ]
  },
  "application/vnd.ms-excel.addin.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "xlam"
    ]
  },
  "application/vnd.ms-excel.sheet.binary.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "xlsb"
    ]
  },
  "application/vnd.ms-excel.sheet.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "xlsm"
    ]
  },
  "application/vnd.ms-excel.template.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "xltm"
    ]
  },
  "application/vnd.ms-fontobject": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "eot"
    ]
  },
  "application/vnd.ms-htmlhelp": {
    "source": "iana",
    "extensions": [
      "chm"
    ]
  },
  "application/vnd.ms-ims": {
    "source": "iana",
    "extensions": [
      "ims"
    ]
  },
  "application/vnd.ms-lrm": {
    "source": "iana",
    "extensions": [
      "lrm"
    ]
  },
  "application/vnd.ms-office.activex+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ms-officetheme": {
    "source": "iana",
    "extensions": [
      "thmx"
    ]
  },
  "application/vnd.ms-opentype": {
    "source": "apache",
    "compressible": true
  },
  "application/vnd.ms-outlook": {
    "compressible": false,
    "extensions": [
      "msg"
    ]
  },
  "application/vnd.ms-package.obfuscated-opentype": {
    "source": "apache"
  },
  "application/vnd.ms-pki.seccat": {
    "source": "apache",
    "extensions": [
      "cat"
    ]
  },
  "application/vnd.ms-pki.stl": {
    "source": "apache",
    "extensions": [
      "stl"
    ]
  },
  "application/vnd.ms-playready.initiator+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ms-powerpoint": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "ppt",
      "pps",
      "pot"
    ]
  },
  "application/vnd.ms-powerpoint.addin.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "ppam"
    ]
  },
  "application/vnd.ms-powerpoint.presentation.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "pptm"
    ]
  },
  "application/vnd.ms-powerpoint.slide.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "sldm"
    ]
  },
  "application/vnd.ms-powerpoint.slideshow.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "ppsm"
    ]
  },
  "application/vnd.ms-powerpoint.template.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "potm"
    ]
  },
  "application/vnd.ms-printdevicecapabilities+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ms-printing.printticket+xml": {
    "source": "apache",
    "compressible": true
  },
  "application/vnd.ms-printschematicket+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ms-project": {
    "source": "iana",
    "extensions": [
      "mpp",
      "mpt"
    ]
  },
  "application/vnd.ms-tnef": {
    "source": "iana"
  },
  "application/vnd.ms-windows.devicepairing": {
    "source": "iana"
  },
  "application/vnd.ms-windows.nwprinting.oob": {
    "source": "iana"
  },
  "application/vnd.ms-windows.printerpairing": {
    "source": "iana"
  },
  "application/vnd.ms-windows.wsd.oob": {
    "source": "iana"
  },
  "application/vnd.ms-wmdrm.lic-chlg-req": {
    "source": "iana"
  },
  "application/vnd.ms-wmdrm.lic-resp": {
    "source": "iana"
  },
  "application/vnd.ms-wmdrm.meter-chlg-req": {
    "source": "iana"
  },
  "application/vnd.ms-wmdrm.meter-resp": {
    "source": "iana"
  },
  "application/vnd.ms-word.document.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "docm"
    ]
  },
  "application/vnd.ms-word.template.macroenabled.12": {
    "source": "iana",
    "extensions": [
      "dotm"
    ]
  },
  "application/vnd.ms-works": {
    "source": "iana",
    "extensions": [
      "wps",
      "wks",
      "wcm",
      "wdb"
    ]
  },
  "application/vnd.ms-wpl": {
    "source": "iana",
    "extensions": [
      "wpl"
    ]
  },
  "application/vnd.ms-xpsdocument": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "xps"
    ]
  },
  "application/vnd.msa-disk-image": {
    "source": "iana"
  },
  "application/vnd.mseq": {
    "source": "iana",
    "extensions": [
      "mseq"
    ]
  },
  "application/vnd.msign": {
    "source": "iana"
  },
  "application/vnd.multiad.creator": {
    "source": "iana"
  },
  "application/vnd.multiad.creator.cif": {
    "source": "iana"
  },
  "application/vnd.music-niff": {
    "source": "iana"
  },
  "application/vnd.musician": {
    "source": "iana",
    "extensions": [
      "mus"
    ]
  },
  "application/vnd.muvee.style": {
    "source": "iana",
    "extensions": [
      "msty"
    ]
  },
  "application/vnd.mynfc": {
    "source": "iana",
    "extensions": [
      "taglet"
    ]
  },
  "application/vnd.nacamar.ybrid+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.ncd.control": {
    "source": "iana"
  },
  "application/vnd.ncd.reference": {
    "source": "iana"
  },
  "application/vnd.nearst.inv+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.nebumind.line": {
    "source": "iana"
  },
  "application/vnd.nervana": {
    "source": "iana"
  },
  "application/vnd.netfpx": {
    "source": "iana"
  },
  "application/vnd.neurolanguage.nlu": {
    "source": "iana",
    "extensions": [
      "nlu"
    ]
  },
  "application/vnd.nimn": {
    "source": "iana"
  },
  "application/vnd.nintendo.nitro.rom": {
    "source": "iana"
  },
  "application/vnd.nintendo.snes.rom": {
    "source": "iana"
  },
  "application/vnd.nitf": {
    "source": "iana",
    "extensions": [
      "ntf",
      "nitf"
    ]
  },
  "application/vnd.noblenet-directory": {
    "source": "iana",
    "extensions": [
      "nnd"
    ]
  },
  "application/vnd.noblenet-sealer": {
    "source": "iana",
    "extensions": [
      "nns"
    ]
  },
  "application/vnd.noblenet-web": {
    "source": "iana",
    "extensions": [
      "nnw"
    ]
  },
  "application/vnd.nokia.catalogs": {
    "source": "iana"
  },
  "application/vnd.nokia.conml+wbxml": {
    "source": "iana"
  },
  "application/vnd.nokia.conml+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.nokia.iptv.config+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.nokia.isds-radio-presets": {
    "source": "iana"
  },
  "application/vnd.nokia.landmark+wbxml": {
    "source": "iana"
  },
  "application/vnd.nokia.landmark+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.nokia.landmarkcollection+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.nokia.n-gage.ac+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "ac"
    ]
  },
  "application/vnd.nokia.n-gage.data": {
    "source": "iana",
    "extensions": [
      "ngdat"
    ]
  },
  "application/vnd.nokia.n-gage.symbian.install": {
    "source": "apache",
    "extensions": [
      "n-gage"
    ]
  },
  "application/vnd.nokia.ncd": {
    "source": "iana"
  },
  "application/vnd.nokia.pcd+wbxml": {
    "source": "iana"
  },
  "application/vnd.nokia.pcd+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.nokia.radio-preset": {
    "source": "iana",
    "extensions": [
      "rpst"
    ]
  },
  "application/vnd.nokia.radio-presets": {
    "source": "iana",
    "extensions": [
      "rpss"
    ]
  },
  "application/vnd.novadigm.edm": {
    "source": "iana",
    "extensions": [
      "edm"
    ]
  },
  "application/vnd.novadigm.edx": {
    "source": "iana",
    "extensions": [
      "edx"
    ]
  },
  "application/vnd.novadigm.ext": {
    "source": "iana",
    "extensions": [
      "ext"
    ]
  },
  "application/vnd.ntt-local.content-share": {
    "source": "iana"
  },
  "application/vnd.ntt-local.file-transfer": {
    "source": "iana"
  },
  "application/vnd.ntt-local.ogw_remote-access": {
    "source": "iana"
  },
  "application/vnd.ntt-local.sip-ta_remote": {
    "source": "iana"
  },
  "application/vnd.ntt-local.sip-ta_tcp_stream": {
    "source": "iana"
  },
  "application/vnd.oasis.opendocument.base": {
    "source": "iana"
  },
  "application/vnd.oasis.opendocument.chart": {
    "source": "iana",
    "extensions": [
      "odc"
    ]
  },
  "application/vnd.oasis.opendocument.chart-template": {
    "source": "iana",
    "extensions": [
      "otc"
    ]
  },
  "application/vnd.oasis.opendocument.database": {
    "source": "apache",
    "extensions": [
      "odb"
    ]
  },
  "application/vnd.oasis.opendocument.formula": {
    "source": "iana",
    "extensions": [
      "odf"
    ]
  },
  "application/vnd.oasis.opendocument.formula-template": {
    "source": "iana",
    "extensions": [
      "odft"
    ]
  },
  "application/vnd.oasis.opendocument.graphics": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "odg"
    ]
  },
  "application/vnd.oasis.opendocument.graphics-template": {
    "source": "iana",
    "extensions": [
      "otg"
    ]
  },
  "application/vnd.oasis.opendocument.image": {
    "source": "iana",
    "extensions": [
      "odi"
    ]
  },
  "application/vnd.oasis.opendocument.image-template": {
    "source": "iana",
    "extensions": [
      "oti"
    ]
  },
  "application/vnd.oasis.opendocument.presentation": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "odp"
    ]
  },
  "application/vnd.oasis.opendocument.presentation-template": {
    "source": "iana",
    "extensions": [
      "otp"
    ]
  },
  "application/vnd.oasis.opendocument.spreadsheet": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "ods"
    ]
  },
  "application/vnd.oasis.opendocument.spreadsheet-template": {
    "source": "iana",
    "extensions": [
      "ots"
    ]
  },
  "application/vnd.oasis.opendocument.text": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "odt"
    ]
  },
  "application/vnd.oasis.opendocument.text-master": {
    "source": "iana",
    "extensions": [
      "odm"
    ]
  },
  "application/vnd.oasis.opendocument.text-template": {
    "source": "iana",
    "extensions": [
      "ott"
    ]
  },
  "application/vnd.oasis.opendocument.text-web": {
    "source": "iana",
    "extensions": [
      "oth"
    ]
  },
  "application/vnd.obn": {
    "source": "iana"
  },
  "application/vnd.ocf+cbor": {
    "source": "iana"
  },
  "application/vnd.oci.image.manifest.v1+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oftn.l10n+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oipf.contentaccessdownload+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oipf.contentaccessstreaming+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oipf.cspg-hexbinary": {
    "source": "iana"
  },
  "application/vnd.oipf.dae.svg+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oipf.dae.xhtml+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oipf.mippvcontrolmessage+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oipf.pae.gem": {
    "source": "iana"
  },
  "application/vnd.oipf.spdiscovery+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oipf.spdlist+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oipf.ueprofile+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oipf.userprofile+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.olpc-sugar": {
    "source": "iana",
    "extensions": [
      "xo"
    ]
  },
  "application/vnd.oma-scws-config": {
    "source": "iana"
  },
  "application/vnd.oma-scws-http-request": {
    "source": "iana"
  },
  "application/vnd.oma-scws-http-response": {
    "source": "iana"
  },
  "application/vnd.oma.bcast.associated-procedure-parameter+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.bcast.drm-trigger+xml": {
    "source": "apache",
    "compressible": true
  },
  "application/vnd.oma.bcast.imd+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.bcast.ltkm": {
    "source": "iana"
  },
  "application/vnd.oma.bcast.notification+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.bcast.provisioningtrigger": {
    "source": "iana"
  },
  "application/vnd.oma.bcast.sgboot": {
    "source": "iana"
  },
  "application/vnd.oma.bcast.sgdd+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.bcast.sgdu": {
    "source": "iana"
  },
  "application/vnd.oma.bcast.simple-symbol-container": {
    "source": "iana"
  },
  "application/vnd.oma.bcast.smartcard-trigger+xml": {
    "source": "apache",
    "compressible": true
  },
  "application/vnd.oma.bcast.sprov+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.bcast.stkm": {
    "source": "iana"
  },
  "application/vnd.oma.cab-address-book+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.cab-feature-handler+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.cab-pcc+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.cab-subs-invite+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.cab-user-prefs+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.dcd": {
    "source": "iana"
  },
  "application/vnd.oma.dcdc": {
    "source": "iana"
  },
  "application/vnd.oma.dd2+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "dd2"
    ]
  },
  "application/vnd.oma.drm.risd+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.group-usage-list+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.lwm2m+cbor": {
    "source": "iana"
  },
  "application/vnd.oma.lwm2m+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.lwm2m+tlv": {
    "source": "iana"
  },
  "application/vnd.oma.pal+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.poc.detailed-progress-report+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.poc.final-report+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.poc.groups+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.poc.invocation-descriptor+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.poc.optimized-progress-report+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.push": {
    "source": "iana"
  },
  "application/vnd.oma.scidm.messages+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oma.xcap-directory+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.omads-email+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/vnd.omads-file+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/vnd.omads-folder+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/vnd.omaloc-supl-init": {
    "source": "iana"
  },
  "application/vnd.onepager": {
    "source": "iana"
  },
  "application/vnd.onepagertamp": {
    "source": "iana"
  },
  "application/vnd.onepagertamx": {
    "source": "iana"
  },
  "application/vnd.onepagertat": {
    "source": "iana"
  },
  "application/vnd.onepagertatp": {
    "source": "iana"
  },
  "application/vnd.onepagertatx": {
    "source": "iana"
  },
  "application/vnd.onvif.metadata": {
    "source": "iana"
  },
  "application/vnd.openblox.game+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "obgx"
    ]
  },
  "application/vnd.openblox.game-binary": {
    "source": "iana"
  },
  "application/vnd.openeye.oeb": {
    "source": "iana"
  },
  "application/vnd.openofficeorg.extension": {
    "source": "apache",
    "extensions": [
      "oxt"
    ]
  },
  "application/vnd.openstreetmap.data+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "osm"
    ]
  },
  "application/vnd.opentimestamps.ots": {
    "source": "iana"
  },
  "application/vnd.openxmlformats-officedocument.custom-properties+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.customxmlproperties+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.drawing+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.drawingml.diagramcolors+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.drawingml.diagramdata+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.drawingml.diagramlayout+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.drawingml.diagramstyle+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.extended-properties+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.commentauthors+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.comments+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.handoutmaster+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.notesmaster+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.notesslide+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "pptx"
    ]
  },
  "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.presprops+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.slide": {
    "source": "iana",
    "extensions": [
      "sldx"
    ]
  },
  "application/vnd.openxmlformats-officedocument.presentationml.slide+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.slidelayout+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.slidemaster+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.slideshow": {
    "source": "iana",
    "extensions": [
      "ppsx"
    ]
  },
  "application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.slideupdateinfo+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.tablestyles+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.tags+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.template": {
    "source": "iana",
    "extensions": [
      "potx"
    ]
  },
  "application/vnd.openxmlformats-officedocument.presentationml.template.main+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.presentationml.viewprops+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.calcchain+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.externallink+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcachedefinition+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcacherecords+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.pivottable+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.querytable+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionheaders+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionlog+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedstrings+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "xlsx"
    ]
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheetmetadata+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.tablesinglecells+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.template": {
    "source": "iana",
    "extensions": [
      "xltx"
    ]
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.usernames+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.volatiledependencies+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.theme+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.themeoverride+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.vmldrawing": {
    "source": "iana"
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "docx"
    ]
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.fonttable+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.template": {
    "source": "iana",
    "extensions": [
      "dotx"
    ]
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.websettings+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-package.core-properties+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.openxmlformats-package.relationships+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oracle.resource+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.orange.indata": {
    "source": "iana"
  },
  "application/vnd.osa.netdeploy": {
    "source": "iana"
  },
  "application/vnd.osgeo.mapguide.package": {
    "source": "iana",
    "extensions": [
      "mgp"
    ]
  },
  "application/vnd.osgi.bundle": {
    "source": "iana"
  },
  "application/vnd.osgi.dp": {
    "source": "iana",
    "extensions": [
      "dp"
    ]
  },
  "application/vnd.osgi.subsystem": {
    "source": "iana",
    "extensions": [
      "esa"
    ]
  },
  "application/vnd.otps.ct-kip+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.oxli.countgraph": {
    "source": "iana"
  },
  "application/vnd.pagerduty+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.palm": {
    "source": "iana",
    "extensions": [
      "pdb",
      "pqa",
      "oprc"
    ]
  },
  "application/vnd.panoply": {
    "source": "iana"
  },
  "application/vnd.paos.xml": {
    "source": "iana"
  },
  "application/vnd.patentdive": {
    "source": "iana"
  },
  "application/vnd.patientecommsdoc": {
    "source": "iana"
  },
  "application/vnd.pawaafile": {
    "source": "iana",
    "extensions": [
      "paw"
    ]
  },
  "application/vnd.pcos": {
    "source": "iana"
  },
  "application/vnd.pg.format": {
    "source": "iana",
    "extensions": [
      "str"
    ]
  },
  "application/vnd.pg.osasli": {
    "source": "iana",
    "extensions": [
      "ei6"
    ]
  },
  "application/vnd.piaccess.application-licence": {
    "source": "iana"
  },
  "application/vnd.picsel": {
    "source": "iana",
    "extensions": [
      "efif"
    ]
  },
  "application/vnd.pmi.widget": {
    "source": "iana",
    "extensions": [
      "wg"
    ]
  },
  "application/vnd.poc.group-advertisement+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.pocketlearn": {
    "source": "iana",
    "extensions": [
      "plf"
    ]
  },
  "application/vnd.powerbuilder6": {
    "source": "iana",
    "extensions": [
      "pbd"
    ]
  },
  "application/vnd.powerbuilder6-s": {
    "source": "iana"
  },
  "application/vnd.powerbuilder7": {
    "source": "iana"
  },
  "application/vnd.powerbuilder7-s": {
    "source": "iana"
  },
  "application/vnd.powerbuilder75": {
    "source": "iana"
  },
  "application/vnd.powerbuilder75-s": {
    "source": "iana"
  },
  "application/vnd.preminet": {
    "source": "iana"
  },
  "application/vnd.previewsystems.box": {
    "source": "iana",
    "extensions": [
      "box"
    ]
  },
  "application/vnd.proteus.magazine": {
    "source": "iana",
    "extensions": [
      "mgz"
    ]
  },
  "application/vnd.psfs": {
    "source": "iana"
  },
  "application/vnd.publishare-delta-tree": {
    "source": "iana",
    "extensions": [
      "qps"
    ]
  },
  "application/vnd.pvi.ptid1": {
    "source": "iana",
    "extensions": [
      "ptid"
    ]
  },
  "application/vnd.pwg-multiplexed": {
    "source": "iana"
  },
  "application/vnd.pwg-xhtml-print+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xhtm"
    ]
  },
  "application/vnd.qualcomm.brew-app-res": {
    "source": "iana"
  },
  "application/vnd.quarantainenet": {
    "source": "iana"
  },
  "application/vnd.quark.quarkxpress": {
    "source": "iana",
    "extensions": [
      "qxd",
      "qxt",
      "qwd",
      "qwt",
      "qxl",
      "qxb"
    ]
  },
  "application/vnd.quobject-quoxdocument": {
    "source": "iana"
  },
  "application/vnd.radisys.moml+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-audit+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-audit-conf+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-audit-conn+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-audit-dialog+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-audit-stream+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-conf+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-dialog+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-dialog-base+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-dialog-fax-detect+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-dialog-fax-sendrecv+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-dialog-group+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-dialog-speech+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.radisys.msml-dialog-transform+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.rainstor.data": {
    "source": "iana"
  },
  "application/vnd.rapid": {
    "source": "iana"
  },
  "application/vnd.rar": {
    "source": "iana",
    "extensions": [
      "rar"
    ]
  },
  "application/vnd.realvnc.bed": {
    "source": "iana",
    "extensions": [
      "bed"
    ]
  },
  "application/vnd.recordare.musicxml": {
    "source": "iana",
    "extensions": [
      "mxl"
    ]
  },
  "application/vnd.recordare.musicxml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "musicxml"
    ]
  },
  "application/vnd.renlearn.rlprint": {
    "source": "iana"
  },
  "application/vnd.resilient.logic": {
    "source": "iana"
  },
  "application/vnd.restful+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.rig.cryptonote": {
    "source": "iana",
    "extensions": [
      "cryptonote"
    ]
  },
  "application/vnd.rim.cod": {
    "source": "apache",
    "extensions": [
      "cod"
    ]
  },
  "application/vnd.rn-realmedia": {
    "source": "apache",
    "extensions": [
      "rm"
    ]
  },
  "application/vnd.rn-realmedia-vbr": {
    "source": "apache",
    "extensions": [
      "rmvb"
    ]
  },
  "application/vnd.route66.link66+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "link66"
    ]
  },
  "application/vnd.rs-274x": {
    "source": "iana"
  },
  "application/vnd.ruckus.download": {
    "source": "iana"
  },
  "application/vnd.s3sms": {
    "source": "iana"
  },
  "application/vnd.sailingtracker.track": {
    "source": "iana",
    "extensions": [
      "st"
    ]
  },
  "application/vnd.sar": {
    "source": "iana"
  },
  "application/vnd.sbm.cid": {
    "source": "iana"
  },
  "application/vnd.sbm.mid2": {
    "source": "iana"
  },
  "application/vnd.scribus": {
    "source": "iana"
  },
  "application/vnd.sealed.3df": {
    "source": "iana"
  },
  "application/vnd.sealed.csf": {
    "source": "iana"
  },
  "application/vnd.sealed.doc": {
    "source": "iana"
  },
  "application/vnd.sealed.eml": {
    "source": "iana"
  },
  "application/vnd.sealed.mht": {
    "source": "iana"
  },
  "application/vnd.sealed.net": {
    "source": "iana"
  },
  "application/vnd.sealed.ppt": {
    "source": "iana"
  },
  "application/vnd.sealed.tiff": {
    "source": "iana"
  },
  "application/vnd.sealed.xls": {
    "source": "iana"
  },
  "application/vnd.sealedmedia.softseal.html": {
    "source": "iana"
  },
  "application/vnd.sealedmedia.softseal.pdf": {
    "source": "iana"
  },
  "application/vnd.seemail": {
    "source": "iana",
    "extensions": [
      "see"
    ]
  },
  "application/vnd.seis+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.sema": {
    "source": "iana",
    "extensions": [
      "sema"
    ]
  },
  "application/vnd.semd": {
    "source": "iana",
    "extensions": [
      "semd"
    ]
  },
  "application/vnd.semf": {
    "source": "iana",
    "extensions": [
      "semf"
    ]
  },
  "application/vnd.shade-save-file": {
    "source": "iana"
  },
  "application/vnd.shana.informed.formdata": {
    "source": "iana",
    "extensions": [
      "ifm"
    ]
  },
  "application/vnd.shana.informed.formtemplate": {
    "source": "iana",
    "extensions": [
      "itp"
    ]
  },
  "application/vnd.shana.informed.interchange": {
    "source": "iana",
    "extensions": [
      "iif"
    ]
  },
  "application/vnd.shana.informed.package": {
    "source": "iana",
    "extensions": [
      "ipk"
    ]
  },
  "application/vnd.shootproof+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.shopkick+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.shp": {
    "source": "iana"
  },
  "application/vnd.shx": {
    "source": "iana"
  },
  "application/vnd.sigrok.session": {
    "source": "iana"
  },
  "application/vnd.simtech-mindmapper": {
    "source": "iana",
    "extensions": [
      "twd",
      "twds"
    ]
  },
  "application/vnd.siren+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.smaf": {
    "source": "iana",
    "extensions": [
      "mmf"
    ]
  },
  "application/vnd.smart.notebook": {
    "source": "iana"
  },
  "application/vnd.smart.teacher": {
    "source": "iana",
    "extensions": [
      "teacher"
    ]
  },
  "application/vnd.smintio.portals.archive": {
    "source": "iana"
  },
  "application/vnd.snesdev-page-table": {
    "source": "iana"
  },
  "application/vnd.software602.filler.form+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "fo"
    ]
  },
  "application/vnd.software602.filler.form-xml-zip": {
    "source": "iana"
  },
  "application/vnd.solent.sdkm+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "sdkm",
      "sdkd"
    ]
  },
  "application/vnd.spotfire.dxp": {
    "source": "iana",
    "extensions": [
      "dxp"
    ]
  },
  "application/vnd.spotfire.sfs": {
    "source": "iana",
    "extensions": [
      "sfs"
    ]
  },
  "application/vnd.sqlite3": {
    "source": "iana"
  },
  "application/vnd.sss-cod": {
    "source": "iana"
  },
  "application/vnd.sss-dtf": {
    "source": "iana"
  },
  "application/vnd.sss-ntf": {
    "source": "iana"
  },
  "application/vnd.stardivision.calc": {
    "source": "apache",
    "extensions": [
      "sdc"
    ]
  },
  "application/vnd.stardivision.draw": {
    "source": "apache",
    "extensions": [
      "sda"
    ]
  },
  "application/vnd.stardivision.impress": {
    "source": "apache",
    "extensions": [
      "sdd"
    ]
  },
  "application/vnd.stardivision.math": {
    "source": "apache",
    "extensions": [
      "smf"
    ]
  },
  "application/vnd.stardivision.writer": {
    "source": "apache",
    "extensions": [
      "sdw",
      "vor"
    ]
  },
  "application/vnd.stardivision.writer-global": {
    "source": "apache",
    "extensions": [
      "sgl"
    ]
  },
  "application/vnd.stepmania.package": {
    "source": "iana",
    "extensions": [
      "smzip"
    ]
  },
  "application/vnd.stepmania.stepchart": {
    "source": "iana",
    "extensions": [
      "sm"
    ]
  },
  "application/vnd.street-stream": {
    "source": "iana"
  },
  "application/vnd.sun.wadl+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "wadl"
    ]
  },
  "application/vnd.sun.xml.calc": {
    "source": "apache",
    "extensions": [
      "sxc"
    ]
  },
  "application/vnd.sun.xml.calc.template": {
    "source": "apache",
    "extensions": [
      "stc"
    ]
  },
  "application/vnd.sun.xml.draw": {
    "source": "apache",
    "extensions": [
      "sxd"
    ]
  },
  "application/vnd.sun.xml.draw.template": {
    "source": "apache",
    "extensions": [
      "std"
    ]
  },
  "application/vnd.sun.xml.impress": {
    "source": "apache",
    "extensions": [
      "sxi"
    ]
  },
  "application/vnd.sun.xml.impress.template": {
    "source": "apache",
    "extensions": [
      "sti"
    ]
  },
  "application/vnd.sun.xml.math": {
    "source": "apache",
    "extensions": [
      "sxm"
    ]
  },
  "application/vnd.sun.xml.writer": {
    "source": "apache",
    "extensions": [
      "sxw"
    ]
  },
  "application/vnd.sun.xml.writer.global": {
    "source": "apache",
    "extensions": [
      "sxg"
    ]
  },
  "application/vnd.sun.xml.writer.template": {
    "source": "apache",
    "extensions": [
      "stw"
    ]
  },
  "application/vnd.sus-calendar": {
    "source": "iana",
    "extensions": [
      "sus",
      "susp"
    ]
  },
  "application/vnd.svd": {
    "source": "iana",
    "extensions": [
      "svd"
    ]
  },
  "application/vnd.swiftview-ics": {
    "source": "iana"
  },
  "application/vnd.sybyl.mol2": {
    "source": "iana"
  },
  "application/vnd.sycle+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.syft+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.symbian.install": {
    "source": "apache",
    "extensions": [
      "sis",
      "sisx"
    ]
  },
  "application/vnd.syncml+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true,
    "extensions": [
      "xsm"
    ]
  },
  "application/vnd.syncml.dm+wbxml": {
    "source": "iana",
    "charset": "UTF-8",
    "extensions": [
      "bdm"
    ]
  },
  "application/vnd.syncml.dm+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true,
    "extensions": [
      "xdm"
    ]
  },
  "application/vnd.syncml.dm.notification": {
    "source": "iana"
  },
  "application/vnd.syncml.dmddf+wbxml": {
    "source": "iana"
  },
  "application/vnd.syncml.dmddf+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true,
    "extensions": [
      "ddf"
    ]
  },
  "application/vnd.syncml.dmtnds+wbxml": {
    "source": "iana"
  },
  "application/vnd.syncml.dmtnds+xml": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true
  },
  "application/vnd.syncml.ds.notification": {
    "source": "iana"
  },
  "application/vnd.tableschema+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.tao.intent-module-archive": {
    "source": "iana",
    "extensions": [
      "tao"
    ]
  },
  "application/vnd.tcpdump.pcap": {
    "source": "iana",
    "extensions": [
      "pcap",
      "cap",
      "dmp"
    ]
  },
  "application/vnd.think-cell.ppttc+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.tmd.mediaflex.api+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.tml": {
    "source": "iana"
  },
  "application/vnd.tmobile-livetv": {
    "source": "iana",
    "extensions": [
      "tmo"
    ]
  },
  "application/vnd.tri.onesource": {
    "source": "iana"
  },
  "application/vnd.trid.tpt": {
    "source": "iana",
    "extensions": [
      "tpt"
    ]
  },
  "application/vnd.triscape.mxs": {
    "source": "iana",
    "extensions": [
      "mxs"
    ]
  },
  "application/vnd.trueapp": {
    "source": "iana",
    "extensions": [
      "tra"
    ]
  },
  "application/vnd.truedoc": {
    "source": "iana"
  },
  "application/vnd.ubisoft.webplayer": {
    "source": "iana"
  },
  "application/vnd.ufdl": {
    "source": "iana",
    "extensions": [
      "ufd",
      "ufdl"
    ]
  },
  "application/vnd.uiq.theme": {
    "source": "iana",
    "extensions": [
      "utz"
    ]
  },
  "application/vnd.umajin": {
    "source": "iana",
    "extensions": [
      "umj"
    ]
  },
  "application/vnd.unity": {
    "source": "iana",
    "extensions": [
      "unityweb"
    ]
  },
  "application/vnd.uoml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "uoml",
      "uo"
    ]
  },
  "application/vnd.uplanet.alert": {
    "source": "iana"
  },
  "application/vnd.uplanet.alert-wbxml": {
    "source": "iana"
  },
  "application/vnd.uplanet.bearer-choice": {
    "source": "iana"
  },
  "application/vnd.uplanet.bearer-choice-wbxml": {
    "source": "iana"
  },
  "application/vnd.uplanet.cacheop": {
    "source": "iana"
  },
  "application/vnd.uplanet.cacheop-wbxml": {
    "source": "iana"
  },
  "application/vnd.uplanet.channel": {
    "source": "iana"
  },
  "application/vnd.uplanet.channel-wbxml": {
    "source": "iana"
  },
  "application/vnd.uplanet.list": {
    "source": "iana"
  },
  "application/vnd.uplanet.list-wbxml": {
    "source": "iana"
  },
  "application/vnd.uplanet.listcmd": {
    "source": "iana"
  },
  "application/vnd.uplanet.listcmd-wbxml": {
    "source": "iana"
  },
  "application/vnd.uplanet.signal": {
    "source": "iana"
  },
  "application/vnd.uri-map": {
    "source": "iana"
  },
  "application/vnd.valve.source.material": {
    "source": "iana"
  },
  "application/vnd.vcx": {
    "source": "iana",
    "extensions": [
      "vcx"
    ]
  },
  "application/vnd.vd-study": {
    "source": "iana"
  },
  "application/vnd.vectorworks": {
    "source": "iana"
  },
  "application/vnd.vel+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.verimatrix.vcas": {
    "source": "iana"
  },
  "application/vnd.veritone.aion+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.veryant.thin": {
    "source": "iana"
  },
  "application/vnd.ves.encrypted": {
    "source": "iana"
  },
  "application/vnd.vidsoft.vidconference": {
    "source": "iana"
  },
  "application/vnd.visio": {
    "source": "iana",
    "extensions": [
      "vsd",
      "vst",
      "vss",
      "vsw"
    ]
  },
  "application/vnd.visionary": {
    "source": "iana",
    "extensions": [
      "vis"
    ]
  },
  "application/vnd.vividence.scriptfile": {
    "source": "iana"
  },
  "application/vnd.vsf": {
    "source": "iana",
    "extensions": [
      "vsf"
    ]
  },
  "application/vnd.wap.sic": {
    "source": "iana"
  },
  "application/vnd.wap.slc": {
    "source": "iana"
  },
  "application/vnd.wap.wbxml": {
    "source": "iana",
    "charset": "UTF-8",
    "extensions": [
      "wbxml"
    ]
  },
  "application/vnd.wap.wmlc": {
    "source": "iana",
    "extensions": [
      "wmlc"
    ]
  },
  "application/vnd.wap.wmlscriptc": {
    "source": "iana",
    "extensions": [
      "wmlsc"
    ]
  },
  "application/vnd.wasmflow.wafl": {
    "source": "iana"
  },
  "application/vnd.webturbo": {
    "source": "iana",
    "extensions": [
      "wtb"
    ]
  },
  "application/vnd.wfa.dpp": {
    "source": "iana"
  },
  "application/vnd.wfa.p2p": {
    "source": "iana"
  },
  "application/vnd.wfa.wsc": {
    "source": "iana"
  },
  "application/vnd.windows.devicepairing": {
    "source": "iana"
  },
  "application/vnd.wmc": {
    "source": "iana"
  },
  "application/vnd.wmf.bootstrap": {
    "source": "iana"
  },
  "application/vnd.wolfram.mathematica": {
    "source": "iana"
  },
  "application/vnd.wolfram.mathematica.package": {
    "source": "iana"
  },
  "application/vnd.wolfram.player": {
    "source": "iana",
    "extensions": [
      "nbp"
    ]
  },
  "application/vnd.wordlift": {
    "source": "iana"
  },
  "application/vnd.wordperfect": {
    "source": "iana",
    "extensions": [
      "wpd"
    ]
  },
  "application/vnd.wqd": {
    "source": "iana",
    "extensions": [
      "wqd"
    ]
  },
  "application/vnd.wrq-hp3000-labelled": {
    "source": "iana"
  },
  "application/vnd.wt.stf": {
    "source": "iana",
    "extensions": [
      "stf"
    ]
  },
  "application/vnd.wv.csp+wbxml": {
    "source": "iana"
  },
  "application/vnd.wv.csp+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.wv.ssp+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.xacml+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.xara": {
    "source": "iana",
    "extensions": [
      "xar"
    ]
  },
  "application/vnd.xfdl": {
    "source": "iana",
    "extensions": [
      "xfdl"
    ]
  },
  "application/vnd.xfdl.webform": {
    "source": "iana"
  },
  "application/vnd.xmi+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/vnd.xmpie.cpkg": {
    "source": "iana"
  },
  "application/vnd.xmpie.dpkg": {
    "source": "iana"
  },
  "application/vnd.xmpie.plan": {
    "source": "iana"
  },
  "application/vnd.xmpie.ppkg": {
    "source": "iana"
  },
  "application/vnd.xmpie.xlim": {
    "source": "iana"
  },
  "application/vnd.yamaha.hv-dic": {
    "source": "iana",
    "extensions": [
      "hvd"
    ]
  },
  "application/vnd.yamaha.hv-script": {
    "source": "iana",
    "extensions": [
      "hvs"
    ]
  },
  "application/vnd.yamaha.hv-voice": {
    "source": "iana",
    "extensions": [
      "hvp"
    ]
  },
  "application/vnd.yamaha.openscoreformat": {
    "source": "iana",
    "extensions": [
      "osf"
    ]
  },
  "application/vnd.yamaha.openscoreformat.osfpvg+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "osfpvg"
    ]
  },
  "application/vnd.yamaha.remote-setup": {
    "source": "iana"
  },
  "application/vnd.yamaha.smaf-audio": {
    "source": "iana",
    "extensions": [
      "saf"
    ]
  },
  "application/vnd.yamaha.smaf-phrase": {
    "source": "iana",
    "extensions": [
      "spf"
    ]
  },
  "application/vnd.yamaha.through-ngn": {
    "source": "iana"
  },
  "application/vnd.yamaha.tunnel-udpencap": {
    "source": "iana"
  },
  "application/vnd.yaoweme": {
    "source": "iana"
  },
  "application/vnd.yellowriver-custom-menu": {
    "source": "iana",
    "extensions": [
      "cmp"
    ]
  },
  "application/vnd.zul": {
    "source": "iana",
    "extensions": [
      "zir",
      "zirz"
    ]
  },
  "application/vnd.zzazz.deck+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "zaz"
    ]
  },
  "application/voicexml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "vxml"
    ]
  },
  "application/voucher-cms+json": {
    "source": "iana",
    "compressible": true
  },
  "application/vq-rtcpxr": {
    "source": "iana"
  },
  "application/wasm": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "wasm"
    ]
  },
  "application/watcherinfo+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "wif"
    ]
  },
  "application/webpush-options+json": {
    "source": "iana",
    "compressible": true
  },
  "application/whoispp-query": {
    "source": "iana"
  },
  "application/whoispp-response": {
    "source": "iana"
  },
  "application/widget": {
    "source": "iana",
    "extensions": [
      "wgt"
    ]
  },
  "application/winhlp": {
    "source": "apache",
    "extensions": [
      "hlp"
    ]
  },
  "application/wita": {
    "source": "iana"
  },
  "application/wordperfect5.1": {
    "source": "iana"
  },
  "application/wsdl+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "wsdl"
    ]
  },
  "application/wspolicy+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "wspolicy"
    ]
  },
  "application/x-7z-compressed": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "7z"
    ]
  },
  "application/x-abiword": {
    "source": "apache",
    "extensions": [
      "abw"
    ]
  },
  "application/x-ace-compressed": {
    "source": "apache",
    "extensions": [
      "ace"
    ]
  },
  "application/x-amf": {
    "source": "apache"
  },
  "application/x-apple-diskimage": {
    "source": "apache",
    "extensions": [
      "dmg"
    ]
  },
  "application/x-arj": {
    "compressible": false,
    "extensions": [
      "arj"
    ]
  },
  "application/x-authorware-bin": {
    "source": "apache",
    "extensions": [
      "aab",
      "x32",
      "u32",
      "vox"
    ]
  },
  "application/x-authorware-map": {
    "source": "apache",
    "extensions": [
      "aam"
    ]
  },
  "application/x-authorware-seg": {
    "source": "apache",
    "extensions": [
      "aas"
    ]
  },
  "application/x-bcpio": {
    "source": "apache",
    "extensions": [
      "bcpio"
    ]
  },
  "application/x-bdoc": {
    "compressible": false,
    "extensions": [
      "bdoc"
    ]
  },
  "application/x-bittorrent": {
    "source": "apache",
    "extensions": [
      "torrent"
    ]
  },
  "application/x-blorb": {
    "source": "apache",
    "extensions": [
      "blb",
      "blorb"
    ]
  },
  "application/x-bzip": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "bz"
    ]
  },
  "application/x-bzip2": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "bz2",
      "boz"
    ]
  },
  "application/x-cbr": {
    "source": "apache",
    "extensions": [
      "cbr",
      "cba",
      "cbt",
      "cbz",
      "cb7"
    ]
  },
  "application/x-cdlink": {
    "source": "apache",
    "extensions": [
      "vcd"
    ]
  },
  "application/x-cfs-compressed": {
    "source": "apache",
    "extensions": [
      "cfs"
    ]
  },
  "application/x-chat": {
    "source": "apache",
    "extensions": [
      "chat"
    ]
  },
  "application/x-chess-pgn": {
    "source": "apache",
    "extensions": [
      "pgn"
    ]
  },
  "application/x-chrome-extension": {
    "extensions": [
      "crx"
    ]
  },
  "application/x-cocoa": {
    "source": "nginx",
    "extensions": [
      "cco"
    ]
  },
  "application/x-compress": {
    "source": "apache"
  },
  "application/x-conference": {
    "source": "apache",
    "extensions": [
      "nsc"
    ]
  },
  "application/x-cpio": {
    "source": "apache",
    "extensions": [
      "cpio"
    ]
  },
  "application/x-csh": {
    "source": "apache",
    "extensions": [
      "csh"
    ]
  },
  "application/x-deb": {
    "compressible": false
  },
  "application/x-debian-package": {
    "source": "apache",
    "extensions": [
      "deb",
      "udeb"
    ]
  },
  "application/x-dgc-compressed": {
    "source": "apache",
    "extensions": [
      "dgc"
    ]
  },
  "application/x-director": {
    "source": "apache",
    "extensions": [
      "dir",
      "dcr",
      "dxr",
      "cst",
      "cct",
      "cxt",
      "w3d",
      "fgd",
      "swa"
    ]
  },
  "application/x-doom": {
    "source": "apache",
    "extensions": [
      "wad"
    ]
  },
  "application/x-dtbncx+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "ncx"
    ]
  },
  "application/x-dtbook+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "dtb"
    ]
  },
  "application/x-dtbresource+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "res"
    ]
  },
  "application/x-dvi": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "dvi"
    ]
  },
  "application/x-envoy": {
    "source": "apache",
    "extensions": [
      "evy"
    ]
  },
  "application/x-eva": {
    "source": "apache",
    "extensions": [
      "eva"
    ]
  },
  "application/x-font-bdf": {
    "source": "apache",
    "extensions": [
      "bdf"
    ]
  },
  "application/x-font-dos": {
    "source": "apache"
  },
  "application/x-font-framemaker": {
    "source": "apache"
  },
  "application/x-font-ghostscript": {
    "source": "apache",
    "extensions": [
      "gsf"
    ]
  },
  "application/x-font-libgrx": {
    "source": "apache"
  },
  "application/x-font-linux-psf": {
    "source": "apache",
    "extensions": [
      "psf"
    ]
  },
  "application/x-font-pcf": {
    "source": "apache",
    "extensions": [
      "pcf"
    ]
  },
  "application/x-font-snf": {
    "source": "apache",
    "extensions": [
      "snf"
    ]
  },
  "application/x-font-speedo": {
    "source": "apache"
  },
  "application/x-font-sunos-news": {
    "source": "apache"
  },
  "application/x-font-type1": {
    "source": "apache",
    "extensions": [
      "pfa",
      "pfb",
      "pfm",
      "afm"
    ]
  },
  "application/x-font-vfont": {
    "source": "apache"
  },
  "application/x-freearc": {
    "source": "apache",
    "extensions": [
      "arc"
    ]
  },
  "application/x-futuresplash": {
    "source": "apache",
    "extensions": [
      "spl"
    ]
  },
  "application/x-gca-compressed": {
    "source": "apache",
    "extensions": [
      "gca"
    ]
  },
  "application/x-glulx": {
    "source": "apache",
    "extensions": [
      "ulx"
    ]
  },
  "application/x-gnumeric": {
    "source": "apache",
    "extensions": [
      "gnumeric"
    ]
  },
  "application/x-gramps-xml": {
    "source": "apache",
    "extensions": [
      "gramps"
    ]
  },
  "application/x-gtar": {
    "source": "apache",
    "extensions": [
      "gtar"
    ]
  },
  "application/x-gzip": {
    "source": "apache"
  },
  "application/x-hdf": {
    "source": "apache",
    "extensions": [
      "hdf"
    ]
  },
  "application/x-httpd-php": {
    "compressible": true,
    "extensions": [
      "php"
    ]
  },
  "application/x-install-instructions": {
    "source": "apache",
    "extensions": [
      "install"
    ]
  },
  "application/x-iso9660-image": {
    "source": "apache",
    "extensions": [
      "iso"
    ]
  },
  "application/x-iwork-keynote-sffkey": {
    "extensions": [
      "key"
    ]
  },
  "application/x-iwork-numbers-sffnumbers": {
    "extensions": [
      "numbers"
    ]
  },
  "application/x-iwork-pages-sffpages": {
    "extensions": [
      "pages"
    ]
  },
  "application/x-java-archive-diff": {
    "source": "nginx",
    "extensions": [
      "jardiff"
    ]
  },
  "application/x-java-jnlp-file": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "jnlp"
    ]
  },
  "application/x-javascript": {
    "compressible": true
  },
  "application/x-keepass2": {
    "extensions": [
      "kdbx"
    ]
  },
  "application/x-latex": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "latex"
    ]
  },
  "application/x-lua-bytecode": {
    "extensions": [
      "luac"
    ]
  },
  "application/x-lzh-compressed": {
    "source": "apache",
    "extensions": [
      "lzh",
      "lha"
    ]
  },
  "application/x-makeself": {
    "source": "nginx",
    "extensions": [
      "run"
    ]
  },
  "application/x-mie": {
    "source": "apache",
    "extensions": [
      "mie"
    ]
  },
  "application/x-mobipocket-ebook": {
    "source": "apache",
    "extensions": [
      "prc",
      "mobi"
    ]
  },
  "application/x-mpegurl": {
    "compressible": false
  },
  "application/x-ms-application": {
    "source": "apache",
    "extensions": [
      "application"
    ]
  },
  "application/x-ms-shortcut": {
    "source": "apache",
    "extensions": [
      "lnk"
    ]
  },
  "application/x-ms-wmd": {
    "source": "apache",
    "extensions": [
      "wmd"
    ]
  },
  "application/x-ms-wmz": {
    "source": "apache",
    "extensions": [
      "wmz"
    ]
  },
  "application/x-ms-xbap": {
    "source": "apache",
    "extensions": [
      "xbap"
    ]
  },
  "application/x-msaccess": {
    "source": "apache",
    "extensions": [
      "mdb"
    ]
  },
  "application/x-msbinder": {
    "source": "apache",
    "extensions": [
      "obd"
    ]
  },
  "application/x-mscardfile": {
    "source": "apache",
    "extensions": [
      "crd"
    ]
  },
  "application/x-msclip": {
    "source": "apache",
    "extensions": [
      "clp"
    ]
  },
  "application/x-msdos-program": {
    "extensions": [
      "exe"
    ]
  },
  "application/x-msdownload": {
    "source": "apache",
    "extensions": [
      "exe",
      "dll",
      "com",
      "bat",
      "msi"
    ]
  },
  "application/x-msmediaview": {
    "source": "apache",
    "extensions": [
      "mvb",
      "m13",
      "m14"
    ]
  },
  "application/x-msmetafile": {
    "source": "apache",
    "extensions": [
      "wmf",
      "wmz",
      "emf",
      "emz"
    ]
  },
  "application/x-msmoney": {
    "source": "apache",
    "extensions": [
      "mny"
    ]
  },
  "application/x-mspublisher": {
    "source": "apache",
    "extensions": [
      "pub"
    ]
  },
  "application/x-msschedule": {
    "source": "apache",
    "extensions": [
      "scd"
    ]
  },
  "application/x-msterminal": {
    "source": "apache",
    "extensions": [
      "trm"
    ]
  },
  "application/x-mswrite": {
    "source": "apache",
    "extensions": [
      "wri"
    ]
  },
  "application/x-netcdf": {
    "source": "apache",
    "extensions": [
      "nc",
      "cdf"
    ]
  },
  "application/x-ns-proxy-autoconfig": {
    "compressible": true,
    "extensions": [
      "pac"
    ]
  },
  "application/x-nzb": {
    "source": "apache",
    "extensions": [
      "nzb"
    ]
  },
  "application/x-perl": {
    "source": "nginx",
    "extensions": [
      "pl",
      "pm"
    ]
  },
  "application/x-pilot": {
    "source": "nginx",
    "extensions": [
      "prc",
      "pdb"
    ]
  },
  "application/x-pkcs12": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "p12",
      "pfx"
    ]
  },
  "application/x-pkcs7-certificates": {
    "source": "apache",
    "extensions": [
      "p7b",
      "spc"
    ]
  },
  "application/x-pkcs7-certreqresp": {
    "source": "apache",
    "extensions": [
      "p7r"
    ]
  },
  "application/x-pki-message": {
    "source": "iana"
  },
  "application/x-rar-compressed": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "rar"
    ]
  },
  "application/x-redhat-package-manager": {
    "source": "nginx",
    "extensions": [
      "rpm"
    ]
  },
  "application/x-research-info-systems": {
    "source": "apache",
    "extensions": [
      "ris"
    ]
  },
  "application/x-sea": {
    "source": "nginx",
    "extensions": [
      "sea"
    ]
  },
  "application/x-sh": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "sh"
    ]
  },
  "application/x-shar": {
    "source": "apache",
    "extensions": [
      "shar"
    ]
  },
  "application/x-shockwave-flash": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "swf"
    ]
  },
  "application/x-silverlight-app": {
    "source": "apache",
    "extensions": [
      "xap"
    ]
  },
  "application/x-sql": {
    "source": "apache",
    "extensions": [
      "sql"
    ]
  },
  "application/x-stuffit": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "sit"
    ]
  },
  "application/x-stuffitx": {
    "source": "apache",
    "extensions": [
      "sitx"
    ]
  },
  "application/x-subrip": {
    "source": "apache",
    "extensions": [
      "srt"
    ]
  },
  "application/x-sv4cpio": {
    "source": "apache",
    "extensions": [
      "sv4cpio"
    ]
  },
  "application/x-sv4crc": {
    "source": "apache",
    "extensions": [
      "sv4crc"
    ]
  },
  "application/x-t3vm-image": {
    "source": "apache",
    "extensions": [
      "t3"
    ]
  },
  "application/x-tads": {
    "source": "apache",
    "extensions": [
      "gam"
    ]
  },
  "application/x-tar": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "tar"
    ]
  },
  "application/x-tcl": {
    "source": "apache",
    "extensions": [
      "tcl",
      "tk"
    ]
  },
  "application/x-tex": {
    "source": "apache",
    "extensions": [
      "tex"
    ]
  },
  "application/x-tex-tfm": {
    "source": "apache",
    "extensions": [
      "tfm"
    ]
  },
  "application/x-texinfo": {
    "source": "apache",
    "extensions": [
      "texinfo",
      "texi"
    ]
  },
  "application/x-tgif": {
    "source": "apache",
    "extensions": [
      "obj"
    ]
  },
  "application/x-ustar": {
    "source": "apache",
    "extensions": [
      "ustar"
    ]
  },
  "application/x-virtualbox-hdd": {
    "compressible": true,
    "extensions": [
      "hdd"
    ]
  },
  "application/x-virtualbox-ova": {
    "compressible": true,
    "extensions": [
      "ova"
    ]
  },
  "application/x-virtualbox-ovf": {
    "compressible": true,
    "extensions": [
      "ovf"
    ]
  },
  "application/x-virtualbox-vbox": {
    "compressible": true,
    "extensions": [
      "vbox"
    ]
  },
  "application/x-virtualbox-vbox-extpack": {
    "compressible": false,
    "extensions": [
      "vbox-extpack"
    ]
  },
  "application/x-virtualbox-vdi": {
    "compressible": true,
    "extensions": [
      "vdi"
    ]
  },
  "application/x-virtualbox-vhd": {
    "compressible": true,
    "extensions": [
      "vhd"
    ]
  },
  "application/x-virtualbox-vmdk": {
    "compressible": true,
    "extensions": [
      "vmdk"
    ]
  },
  "application/x-wais-source": {
    "source": "apache",
    "extensions": [
      "src"
    ]
  },
  "application/x-web-app-manifest+json": {
    "compressible": true,
    "extensions": [
      "webapp"
    ]
  },
  "application/x-www-form-urlencoded": {
    "source": "iana",
    "compressible": true
  },
  "application/x-x509-ca-cert": {
    "source": "iana",
    "extensions": [
      "der",
      "crt",
      "pem"
    ]
  },
  "application/x-x509-ca-ra-cert": {
    "source": "iana"
  },
  "application/x-x509-next-ca-cert": {
    "source": "iana"
  },
  "application/x-xfig": {
    "source": "apache",
    "extensions": [
      "fig"
    ]
  },
  "application/x-xliff+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "xlf"
    ]
  },
  "application/x-xpinstall": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "xpi"
    ]
  },
  "application/x-xz": {
    "source": "apache",
    "extensions": [
      "xz"
    ]
  },
  "application/x-zmachine": {
    "source": "apache",
    "extensions": [
      "z1",
      "z2",
      "z3",
      "z4",
      "z5",
      "z6",
      "z7",
      "z8"
    ]
  },
  "application/x400-bp": {
    "source": "iana"
  },
  "application/xacml+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/xaml+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "xaml"
    ]
  },
  "application/xcap-att+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xav"
    ]
  },
  "application/xcap-caps+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xca"
    ]
  },
  "application/xcap-diff+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xdf"
    ]
  },
  "application/xcap-el+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xel"
    ]
  },
  "application/xcap-error+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/xcap-ns+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xns"
    ]
  },
  "application/xcon-conference-info+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/xcon-conference-info-diff+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/xenc+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xenc"
    ]
  },
  "application/xfdf": {
    "source": "iana",
    "extensions": [
      "xfdf"
    ]
  },
  "application/xhtml+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xhtml",
      "xht"
    ]
  },
  "application/xhtml-voice+xml": {
    "source": "apache",
    "compressible": true
  },
  "application/xliff+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xlf"
    ]
  },
  "application/xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xml",
      "xsl",
      "xsd",
      "rng"
    ]
  },
  "application/xml-dtd": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "dtd"
    ]
  },
  "application/xml-external-parsed-entity": {
    "source": "iana"
  },
  "application/xml-patch+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/xmpp+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/xop+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xop"
    ]
  },
  "application/xproc+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "xpl"
    ]
  },
  "application/xslt+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xsl",
      "xslt"
    ]
  },
  "application/xspf+xml": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "xspf"
    ]
  },
  "application/xv+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "mxml",
      "xhvml",
      "xvml",
      "xvm"
    ]
  },
  "application/yang": {
    "source": "iana",
    "extensions": [
      "yang"
    ]
  },
  "application/yang-data+cbor": {
    "source": "iana"
  },
  "application/yang-data+json": {
    "source": "iana",
    "compressible": true
  },
  "application/yang-data+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/yang-patch+json": {
    "source": "iana",
    "compressible": true
  },
  "application/yang-patch+xml": {
    "source": "iana",
    "compressible": true
  },
  "application/yin+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "yin"
    ]
  },
  "application/zip": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "zip"
    ]
  },
  "application/zlib": {
    "source": "iana"
  },
  "application/zstd": {
    "source": "iana"
  },
  "audio/1d-interleaved-parityfec": {
    "source": "iana"
  },
  "audio/32kadpcm": {
    "source": "iana"
  },
  "audio/3gpp": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "3gpp"
    ]
  },
  "audio/3gpp2": {
    "source": "iana"
  },
  "audio/aac": {
    "source": "iana",
    "extensions": [
      "adts",
      "aac"
    ]
  },
  "audio/ac3": {
    "source": "iana"
  },
  "audio/adpcm": {
    "source": "apache",
    "extensions": [
      "adp"
    ]
  },
  "audio/amr": {
    "source": "iana",
    "extensions": [
      "amr"
    ]
  },
  "audio/amr-wb": {
    "source": "iana"
  },
  "audio/amr-wb+": {
    "source": "iana"
  },
  "audio/aptx": {
    "source": "iana"
  },
  "audio/asc": {
    "source": "iana"
  },
  "audio/atrac-advanced-lossless": {
    "source": "iana"
  },
  "audio/atrac-x": {
    "source": "iana"
  },
  "audio/atrac3": {
    "source": "iana"
  },
  "audio/basic": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "au",
      "snd"
    ]
  },
  "audio/bv16": {
    "source": "iana"
  },
  "audio/bv32": {
    "source": "iana"
  },
  "audio/clearmode": {
    "source": "iana"
  },
  "audio/cn": {
    "source": "iana"
  },
  "audio/dat12": {
    "source": "iana"
  },
  "audio/dls": {
    "source": "iana"
  },
  "audio/dsr-es201108": {
    "source": "iana"
  },
  "audio/dsr-es202050": {
    "source": "iana"
  },
  "audio/dsr-es202211": {
    "source": "iana"
  },
  "audio/dsr-es202212": {
    "source": "iana"
  },
  "audio/dv": {
    "source": "iana"
  },
  "audio/dvi4": {
    "source": "iana"
  },
  "audio/eac3": {
    "source": "iana"
  },
  "audio/encaprtp": {
    "source": "iana"
  },
  "audio/evrc": {
    "source": "iana"
  },
  "audio/evrc-qcp": {
    "source": "iana"
  },
  "audio/evrc0": {
    "source": "iana"
  },
  "audio/evrc1": {
    "source": "iana"
  },
  "audio/evrcb": {
    "source": "iana"
  },
  "audio/evrcb0": {
    "source": "iana"
  },
  "audio/evrcb1": {
    "source": "iana"
  },
  "audio/evrcnw": {
    "source": "iana"
  },
  "audio/evrcnw0": {
    "source": "iana"
  },
  "audio/evrcnw1": {
    "source": "iana"
  },
  "audio/evrcwb": {
    "source": "iana"
  },
  "audio/evrcwb0": {
    "source": "iana"
  },
  "audio/evrcwb1": {
    "source": "iana"
  },
  "audio/evs": {
    "source": "iana"
  },
  "audio/flexfec": {
    "source": "iana"
  },
  "audio/fwdred": {
    "source": "iana"
  },
  "audio/g711-0": {
    "source": "iana"
  },
  "audio/g719": {
    "source": "iana"
  },
  "audio/g722": {
    "source": "iana"
  },
  "audio/g7221": {
    "source": "iana"
  },
  "audio/g723": {
    "source": "iana"
  },
  "audio/g726-16": {
    "source": "iana"
  },
  "audio/g726-24": {
    "source": "iana"
  },
  "audio/g726-32": {
    "source": "iana"
  },
  "audio/g726-40": {
    "source": "iana"
  },
  "audio/g728": {
    "source": "iana"
  },
  "audio/g729": {
    "source": "iana"
  },
  "audio/g7291": {
    "source": "iana"
  },
  "audio/g729d": {
    "source": "iana"
  },
  "audio/g729e": {
    "source": "iana"
  },
  "audio/gsm": {
    "source": "iana"
  },
  "audio/gsm-efr": {
    "source": "iana"
  },
  "audio/gsm-hr-08": {
    "source": "iana"
  },
  "audio/ilbc": {
    "source": "iana"
  },
  "audio/ip-mr_v2.5": {
    "source": "iana"
  },
  "audio/isac": {
    "source": "apache"
  },
  "audio/l16": {
    "source": "iana"
  },
  "audio/l20": {
    "source": "iana"
  },
  "audio/l24": {
    "source": "iana",
    "compressible": false
  },
  "audio/l8": {
    "source": "iana"
  },
  "audio/lpc": {
    "source": "iana"
  },
  "audio/melp": {
    "source": "iana"
  },
  "audio/melp1200": {
    "source": "iana"
  },
  "audio/melp2400": {
    "source": "iana"
  },
  "audio/melp600": {
    "source": "iana"
  },
  "audio/mhas": {
    "source": "iana"
  },
  "audio/midi": {
    "source": "apache",
    "extensions": [
      "mid",
      "midi",
      "kar",
      "rmi"
    ]
  },
  "audio/mobile-xmf": {
    "source": "iana",
    "extensions": [
      "mxmf"
    ]
  },
  "audio/mp3": {
    "compressible": false,
    "extensions": [
      "mp3"
    ]
  },
  "audio/mp4": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "m4a",
      "mp4a"
    ]
  },
  "audio/mp4a-latm": {
    "source": "iana"
  },
  "audio/mpa": {
    "source": "iana"
  },
  "audio/mpa-robust": {
    "source": "iana"
  },
  "audio/mpeg": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "mpga",
      "mp2",
      "mp2a",
      "mp3",
      "m2a",
      "m3a"
    ]
  },
  "audio/mpeg4-generic": {
    "source": "iana"
  },
  "audio/musepack": {
    "source": "apache"
  },
  "audio/ogg": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "oga",
      "ogg",
      "spx",
      "opus"
    ]
  },
  "audio/opus": {
    "source": "iana"
  },
  "audio/parityfec": {
    "source": "iana"
  },
  "audio/pcma": {
    "source": "iana"
  },
  "audio/pcma-wb": {
    "source": "iana"
  },
  "audio/pcmu": {
    "source": "iana"
  },
  "audio/pcmu-wb": {
    "source": "iana"
  },
  "audio/prs.sid": {
    "source": "iana"
  },
  "audio/qcelp": {
    "source": "iana"
  },
  "audio/raptorfec": {
    "source": "iana"
  },
  "audio/red": {
    "source": "iana"
  },
  "audio/rtp-enc-aescm128": {
    "source": "iana"
  },
  "audio/rtp-midi": {
    "source": "iana"
  },
  "audio/rtploopback": {
    "source": "iana"
  },
  "audio/rtx": {
    "source": "iana"
  },
  "audio/s3m": {
    "source": "apache",
    "extensions": [
      "s3m"
    ]
  },
  "audio/scip": {
    "source": "iana"
  },
  "audio/silk": {
    "source": "apache",
    "extensions": [
      "sil"
    ]
  },
  "audio/smv": {
    "source": "iana"
  },
  "audio/smv-qcp": {
    "source": "iana"
  },
  "audio/smv0": {
    "source": "iana"
  },
  "audio/sofa": {
    "source": "iana"
  },
  "audio/sp-midi": {
    "source": "iana"
  },
  "audio/speex": {
    "source": "iana"
  },
  "audio/t140c": {
    "source": "iana"
  },
  "audio/t38": {
    "source": "iana"
  },
  "audio/telephone-event": {
    "source": "iana"
  },
  "audio/tetra_acelp": {
    "source": "iana"
  },
  "audio/tetra_acelp_bb": {
    "source": "iana"
  },
  "audio/tone": {
    "source": "iana"
  },
  "audio/tsvcis": {
    "source": "iana"
  },
  "audio/uemclip": {
    "source": "iana"
  },
  "audio/ulpfec": {
    "source": "iana"
  },
  "audio/usac": {
    "source": "iana"
  },
  "audio/vdvi": {
    "source": "iana"
  },
  "audio/vmr-wb": {
    "source": "iana"
  },
  "audio/vnd.3gpp.iufp": {
    "source": "iana"
  },
  "audio/vnd.4sb": {
    "source": "iana"
  },
  "audio/vnd.audiokoz": {
    "source": "iana"
  },
  "audio/vnd.celp": {
    "source": "iana"
  },
  "audio/vnd.cisco.nse": {
    "source": "iana"
  },
  "audio/vnd.cmles.radio-events": {
    "source": "iana"
  },
  "audio/vnd.cns.anp1": {
    "source": "iana"
  },
  "audio/vnd.cns.inf1": {
    "source": "iana"
  },
  "audio/vnd.dece.audio": {
    "source": "iana",
    "extensions": [
      "uva",
      "uvva"
    ]
  },
  "audio/vnd.digital-winds": {
    "source": "iana",
    "extensions": [
      "eol"
    ]
  },
  "audio/vnd.dlna.adts": {
    "source": "iana"
  },
  "audio/vnd.dolby.heaac.1": {
    "source": "iana"
  },
  "audio/vnd.dolby.heaac.2": {
    "source": "iana"
  },
  "audio/vnd.dolby.mlp": {
    "source": "iana"
  },
  "audio/vnd.dolby.mps": {
    "source": "iana"
  },
  "audio/vnd.dolby.pl2": {
    "source": "iana"
  },
  "audio/vnd.dolby.pl2x": {
    "source": "iana"
  },
  "audio/vnd.dolby.pl2z": {
    "source": "iana"
  },
  "audio/vnd.dolby.pulse.1": {
    "source": "iana"
  },
  "audio/vnd.dra": {
    "source": "iana",
    "extensions": [
      "dra"
    ]
  },
  "audio/vnd.dts": {
    "source": "iana",
    "extensions": [
      "dts"
    ]
  },
  "audio/vnd.dts.hd": {
    "source": "iana",
    "extensions": [
      "dtshd"
    ]
  },
  "audio/vnd.dts.uhd": {
    "source": "iana"
  },
  "audio/vnd.dvb.file": {
    "source": "iana"
  },
  "audio/vnd.everad.plj": {
    "source": "iana"
  },
  "audio/vnd.hns.audio": {
    "source": "iana"
  },
  "audio/vnd.lucent.voice": {
    "source": "iana",
    "extensions": [
      "lvp"
    ]
  },
  "audio/vnd.ms-playready.media.pya": {
    "source": "iana",
    "extensions": [
      "pya"
    ]
  },
  "audio/vnd.nokia.mobile-xmf": {
    "source": "iana"
  },
  "audio/vnd.nortel.vbk": {
    "source": "iana"
  },
  "audio/vnd.nuera.ecelp4800": {
    "source": "iana",
    "extensions": [
      "ecelp4800"
    ]
  },
  "audio/vnd.nuera.ecelp7470": {
    "source": "iana",
    "extensions": [
      "ecelp7470"
    ]
  },
  "audio/vnd.nuera.ecelp9600": {
    "source": "iana",
    "extensions": [
      "ecelp9600"
    ]
  },
  "audio/vnd.octel.sbc": {
    "source": "iana"
  },
  "audio/vnd.presonus.multitrack": {
    "source": "iana"
  },
  "audio/vnd.qcelp": {
    "source": "apache"
  },
  "audio/vnd.rhetorex.32kadpcm": {
    "source": "iana"
  },
  "audio/vnd.rip": {
    "source": "iana",
    "extensions": [
      "rip"
    ]
  },
  "audio/vnd.rn-realaudio": {
    "compressible": false
  },
  "audio/vnd.sealedmedia.softseal.mpeg": {
    "source": "iana"
  },
  "audio/vnd.vmx.cvsd": {
    "source": "iana"
  },
  "audio/vnd.wave": {
    "compressible": false
  },
  "audio/vorbis": {
    "source": "iana",
    "compressible": false
  },
  "audio/vorbis-config": {
    "source": "iana"
  },
  "audio/wav": {
    "compressible": false,
    "extensions": [
      "wav"
    ]
  },
  "audio/wave": {
    "compressible": false,
    "extensions": [
      "wav"
    ]
  },
  "audio/webm": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "weba"
    ]
  },
  "audio/x-aac": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "aac"
    ]
  },
  "audio/x-aiff": {
    "source": "apache",
    "extensions": [
      "aif",
      "aiff",
      "aifc"
    ]
  },
  "audio/x-caf": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "caf"
    ]
  },
  "audio/x-flac": {
    "source": "apache",
    "extensions": [
      "flac"
    ]
  },
  "audio/x-m4a": {
    "source": "nginx",
    "extensions": [
      "m4a"
    ]
  },
  "audio/x-matroska": {
    "source": "apache",
    "extensions": [
      "mka"
    ]
  },
  "audio/x-mpegurl": {
    "source": "apache",
    "extensions": [
      "m3u"
    ]
  },
  "audio/x-ms-wax": {
    "source": "apache",
    "extensions": [
      "wax"
    ]
  },
  "audio/x-ms-wma": {
    "source": "apache",
    "extensions": [
      "wma"
    ]
  },
  "audio/x-pn-realaudio": {
    "source": "apache",
    "extensions": [
      "ram",
      "ra"
    ]
  },
  "audio/x-pn-realaudio-plugin": {
    "source": "apache",
    "extensions": [
      "rmp"
    ]
  },
  "audio/x-realaudio": {
    "source": "nginx",
    "extensions": [
      "ra"
    ]
  },
  "audio/x-tta": {
    "source": "apache"
  },
  "audio/x-wav": {
    "source": "apache",
    "extensions": [
      "wav"
    ]
  },
  "audio/xm": {
    "source": "apache",
    "extensions": [
      "xm"
    ]
  },
  "chemical/x-cdx": {
    "source": "apache",
    "extensions": [
      "cdx"
    ]
  },
  "chemical/x-cif": {
    "source": "apache",
    "extensions": [
      "cif"
    ]
  },
  "chemical/x-cmdf": {
    "source": "apache",
    "extensions": [
      "cmdf"
    ]
  },
  "chemical/x-cml": {
    "source": "apache",
    "extensions": [
      "cml"
    ]
  },
  "chemical/x-csml": {
    "source": "apache",
    "extensions": [
      "csml"
    ]
  },
  "chemical/x-pdb": {
    "source": "apache"
  },
  "chemical/x-xyz": {
    "source": "apache",
    "extensions": [
      "xyz"
    ]
  },
  "font/collection": {
    "source": "iana",
    "extensions": [
      "ttc"
    ]
  },
  "font/otf": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "otf"
    ]
  },
  "font/sfnt": {
    "source": "iana"
  },
  "font/ttf": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "ttf"
    ]
  },
  "font/woff": {
    "source": "iana",
    "extensions": [
      "woff"
    ]
  },
  "font/woff2": {
    "source": "iana",
    "extensions": [
      "woff2"
    ]
  },
  "image/aces": {
    "source": "iana",
    "extensions": [
      "exr"
    ]
  },
  "image/apng": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "apng"
    ]
  },
  "image/avci": {
    "source": "iana",
    "extensions": [
      "avci"
    ]
  },
  "image/avcs": {
    "source": "iana",
    "extensions": [
      "avcs"
    ]
  },
  "image/avif": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "avif"
    ]
  },
  "image/bmp": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "bmp",
      "dib"
    ]
  },
  "image/cgm": {
    "source": "iana",
    "extensions": [
      "cgm"
    ]
  },
  "image/dicom-rle": {
    "source": "iana",
    "extensions": [
      "drle"
    ]
  },
  "image/dpx": {
    "source": "iana",
    "extensions": [
      "dpx"
    ]
  },
  "image/emf": {
    "source": "iana",
    "extensions": [
      "emf"
    ]
  },
  "image/fits": {
    "source": "iana",
    "extensions": [
      "fits"
    ]
  },
  "image/g3fax": {
    "source": "iana",
    "extensions": [
      "g3"
    ]
  },
  "image/gif": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "gif"
    ]
  },
  "image/heic": {
    "source": "iana",
    "extensions": [
      "heic"
    ]
  },
  "image/heic-sequence": {
    "source": "iana",
    "extensions": [
      "heics"
    ]
  },
  "image/heif": {
    "source": "iana",
    "extensions": [
      "heif"
    ]
  },
  "image/heif-sequence": {
    "source": "iana",
    "extensions": [
      "heifs"
    ]
  },
  "image/hej2k": {
    "source": "iana",
    "extensions": [
      "hej2"
    ]
  },
  "image/hsj2": {
    "source": "iana",
    "extensions": [
      "hsj2"
    ]
  },
  "image/ief": {
    "source": "iana",
    "extensions": [
      "ief"
    ]
  },
  "image/jls": {
    "source": "iana",
    "extensions": [
      "jls"
    ]
  },
  "image/jp2": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "jp2",
      "jpg2"
    ]
  },
  "image/jpeg": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "jpeg",
      "jpg",
      "jpe"
    ]
  },
  "image/jph": {
    "source": "iana",
    "extensions": [
      "jph"
    ]
  },
  "image/jphc": {
    "source": "iana",
    "extensions": [
      "jhc"
    ]
  },
  "image/jpm": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "jpm",
      "jpgm"
    ]
  },
  "image/jpx": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "jpx",
      "jpf"
    ]
  },
  "image/jxr": {
    "source": "iana",
    "extensions": [
      "jxr"
    ]
  },
  "image/jxra": {
    "source": "iana",
    "extensions": [
      "jxra"
    ]
  },
  "image/jxrs": {
    "source": "iana",
    "extensions": [
      "jxrs"
    ]
  },
  "image/jxs": {
    "source": "iana",
    "extensions": [
      "jxs"
    ]
  },
  "image/jxsc": {
    "source": "iana",
    "extensions": [
      "jxsc"
    ]
  },
  "image/jxsi": {
    "source": "iana",
    "extensions": [
      "jxsi"
    ]
  },
  "image/jxss": {
    "source": "iana",
    "extensions": [
      "jxss"
    ]
  },
  "image/ktx": {
    "source": "iana",
    "extensions": [
      "ktx"
    ]
  },
  "image/ktx2": {
    "source": "iana",
    "extensions": [
      "ktx2"
    ]
  },
  "image/naplps": {
    "source": "iana"
  },
  "image/pjpeg": {
    "compressible": false
  },
  "image/png": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "png"
    ]
  },
  "image/prs.btif": {
    "source": "iana",
    "extensions": [
      "btif",
      "btf"
    ]
  },
  "image/prs.pti": {
    "source": "iana",
    "extensions": [
      "pti"
    ]
  },
  "image/pwg-raster": {
    "source": "iana"
  },
  "image/sgi": {
    "source": "apache",
    "extensions": [
      "sgi"
    ]
  },
  "image/svg+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "svg",
      "svgz"
    ]
  },
  "image/t38": {
    "source": "iana",
    "extensions": [
      "t38"
    ]
  },
  "image/tiff": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "tif",
      "tiff"
    ]
  },
  "image/tiff-fx": {
    "source": "iana",
    "extensions": [
      "tfx"
    ]
  },
  "image/vnd.adobe.photoshop": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "psd"
    ]
  },
  "image/vnd.airzip.accelerator.azv": {
    "source": "iana",
    "extensions": [
      "azv"
    ]
  },
  "image/vnd.cns.inf2": {
    "source": "iana"
  },
  "image/vnd.dece.graphic": {
    "source": "iana",
    "extensions": [
      "uvi",
      "uvvi",
      "uvg",
      "uvvg"
    ]
  },
  "image/vnd.djvu": {
    "source": "iana",
    "extensions": [
      "djvu",
      "djv"
    ]
  },
  "image/vnd.dvb.subtitle": {
    "source": "iana",
    "extensions": [
      "sub"
    ]
  },
  "image/vnd.dwg": {
    "source": "iana",
    "extensions": [
      "dwg"
    ]
  },
  "image/vnd.dxf": {
    "source": "iana",
    "extensions": [
      "dxf"
    ]
  },
  "image/vnd.fastbidsheet": {
    "source": "iana",
    "extensions": [
      "fbs"
    ]
  },
  "image/vnd.fpx": {
    "source": "iana",
    "extensions": [
      "fpx"
    ]
  },
  "image/vnd.fst": {
    "source": "iana",
    "extensions": [
      "fst"
    ]
  },
  "image/vnd.fujixerox.edmics-mmr": {
    "source": "iana",
    "extensions": [
      "mmr"
    ]
  },
  "image/vnd.fujixerox.edmics-rlc": {
    "source": "iana",
    "extensions": [
      "rlc"
    ]
  },
  "image/vnd.globalgraphics.pgb": {
    "source": "iana"
  },
  "image/vnd.microsoft.icon": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "ico"
    ]
  },
  "image/vnd.mix": {
    "source": "iana"
  },
  "image/vnd.mozilla.apng": {
    "source": "iana"
  },
  "image/vnd.ms-dds": {
    "compressible": true,
    "extensions": [
      "dds"
    ]
  },
  "image/vnd.ms-modi": {
    "source": "iana",
    "extensions": [
      "mdi"
    ]
  },
  "image/vnd.ms-photo": {
    "source": "apache",
    "extensions": [
      "wdp"
    ]
  },
  "image/vnd.net-fpx": {
    "source": "iana",
    "extensions": [
      "npx"
    ]
  },
  "image/vnd.pco.b16": {
    "source": "iana",
    "extensions": [
      "b16"
    ]
  },
  "image/vnd.radiance": {
    "source": "iana"
  },
  "image/vnd.sealed.png": {
    "source": "iana"
  },
  "image/vnd.sealedmedia.softseal.gif": {
    "source": "iana"
  },
  "image/vnd.sealedmedia.softseal.jpg": {
    "source": "iana"
  },
  "image/vnd.svf": {
    "source": "iana"
  },
  "image/vnd.tencent.tap": {
    "source": "iana",
    "extensions": [
      "tap"
    ]
  },
  "image/vnd.valve.source.texture": {
    "source": "iana",
    "extensions": [
      "vtf"
    ]
  },
  "image/vnd.wap.wbmp": {
    "source": "iana",
    "extensions": [
      "wbmp"
    ]
  },
  "image/vnd.xiff": {
    "source": "iana",
    "extensions": [
      "xif"
    ]
  },
  "image/vnd.zbrush.pcx": {
    "source": "iana",
    "extensions": [
      "pcx"
    ]
  },
  "image/webp": {
    "source": "iana",
    "extensions": [
      "webp"
    ]
  },
  "image/wmf": {
    "source": "iana",
    "extensions": [
      "wmf"
    ]
  },
  "image/x-3ds": {
    "source": "apache",
    "extensions": [
      "3ds"
    ]
  },
  "image/x-cmu-raster": {
    "source": "apache",
    "extensions": [
      "ras"
    ]
  },
  "image/x-cmx": {
    "source": "apache",
    "extensions": [
      "cmx"
    ]
  },
  "image/x-freehand": {
    "source": "apache",
    "extensions": [
      "fh",
      "fhc",
      "fh4",
      "fh5",
      "fh7"
    ]
  },
  "image/x-icon": {
    "source": "apache",
    "compressible": true,
    "extensions": [
      "ico"
    ]
  },
  "image/x-jng": {
    "source": "nginx",
    "extensions": [
      "jng"
    ]
  },
  "image/x-mrsid-image": {
    "source": "apache",
    "extensions": [
      "sid"
    ]
  },
  "image/x-ms-bmp": {
    "source": "nginx",
    "compressible": true,
    "extensions": [
      "bmp"
    ]
  },
  "image/x-pcx": {
    "source": "apache",
    "extensions": [
      "pcx"
    ]
  },
  "image/x-pict": {
    "source": "apache",
    "extensions": [
      "pic",
      "pct"
    ]
  },
  "image/x-portable-anymap": {
    "source": "apache",
    "extensions": [
      "pnm"
    ]
  },
  "image/x-portable-bitmap": {
    "source": "apache",
    "extensions": [
      "pbm"
    ]
  },
  "image/x-portable-graymap": {
    "source": "apache",
    "extensions": [
      "pgm"
    ]
  },
  "image/x-portable-pixmap": {
    "source": "apache",
    "extensions": [
      "ppm"
    ]
  },
  "image/x-rgb": {
    "source": "apache",
    "extensions": [
      "rgb"
    ]
  },
  "image/x-tga": {
    "source": "apache",
    "extensions": [
      "tga"
    ]
  },
  "image/x-xbitmap": {
    "source": "apache",
    "extensions": [
      "xbm"
    ]
  },
  "image/x-xcf": {
    "compressible": false
  },
  "image/x-xpixmap": {
    "source": "apache",
    "extensions": [
      "xpm"
    ]
  },
  "image/x-xwindowdump": {
    "source": "apache",
    "extensions": [
      "xwd"
    ]
  },
  "message/bhttp": {
    "source": "iana"
  },
  "message/cpim": {
    "source": "iana"
  },
  "message/delivery-status": {
    "source": "iana"
  },
  "message/disposition-notification": {
    "source": "iana",
    "extensions": [
      "disposition-notification"
    ]
  },
  "message/external-body": {
    "source": "iana"
  },
  "message/feedback-report": {
    "source": "iana"
  },
  "message/global": {
    "source": "iana",
    "extensions": [
      "u8msg"
    ]
  },
  "message/global-delivery-status": {
    "source": "iana",
    "extensions": [
      "u8dsn"
    ]
  },
  "message/global-disposition-notification": {
    "source": "iana",
    "extensions": [
      "u8mdn"
    ]
  },
  "message/global-headers": {
    "source": "iana",
    "extensions": [
      "u8hdr"
    ]
  },
  "message/http": {
    "source": "iana",
    "compressible": false
  },
  "message/imdn+xml": {
    "source": "iana",
    "compressible": true
  },
  "message/news": {
    "source": "apache"
  },
  "message/partial": {
    "source": "iana",
    "compressible": false
  },
  "message/rfc822": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "eml",
      "mime"
    ]
  },
  "message/s-http": {
    "source": "apache"
  },
  "message/sip": {
    "source": "iana"
  },
  "message/sipfrag": {
    "source": "iana"
  },
  "message/tracking-status": {
    "source": "iana"
  },
  "message/vnd.si.simp": {
    "source": "apache"
  },
  "message/vnd.wfa.wsc": {
    "source": "iana",
    "extensions": [
      "wsc"
    ]
  },
  "model/3mf": {
    "source": "iana",
    "extensions": [
      "3mf"
    ]
  },
  "model/e57": {
    "source": "iana"
  },
  "model/gltf+json": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "gltf"
    ]
  },
  "model/gltf-binary": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "glb"
    ]
  },
  "model/iges": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "igs",
      "iges"
    ]
  },
  "model/jt": {
    "source": "iana",
    "extensions": [
      "jt"
    ]
  },
  "model/mesh": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "msh",
      "mesh",
      "silo"
    ]
  },
  "model/mtl": {
    "source": "iana",
    "extensions": [
      "mtl"
    ]
  },
  "model/obj": {
    "source": "iana",
    "extensions": [
      "obj"
    ]
  },
  "model/prc": {
    "source": "iana",
    "extensions": [
      "prc"
    ]
  },
  "model/step": {
    "source": "iana"
  },
  "model/step+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "stpx"
    ]
  },
  "model/step+zip": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "stpz"
    ]
  },
  "model/step-xml+zip": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "stpxz"
    ]
  },
  "model/stl": {
    "source": "iana",
    "extensions": [
      "stl"
    ]
  },
  "model/u3d": {
    "source": "iana",
    "extensions": [
      "u3d"
    ]
  },
  "model/vnd.cld": {
    "source": "iana",
    "extensions": [
      "cld"
    ]
  },
  "model/vnd.collada+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "dae"
    ]
  },
  "model/vnd.dwf": {
    "source": "iana",
    "extensions": [
      "dwf"
    ]
  },
  "model/vnd.flatland.3dml": {
    "source": "iana"
  },
  "model/vnd.gdl": {
    "source": "iana",
    "extensions": [
      "gdl"
    ]
  },
  "model/vnd.gs-gdl": {
    "source": "apache"
  },
  "model/vnd.gs.gdl": {
    "source": "iana"
  },
  "model/vnd.gtw": {
    "source": "iana",
    "extensions": [
      "gtw"
    ]
  },
  "model/vnd.moml+xml": {
    "source": "iana",
    "compressible": true
  },
  "model/vnd.mts": {
    "source": "iana",
    "extensions": [
      "mts"
    ]
  },
  "model/vnd.opengex": {
    "source": "iana",
    "extensions": [
      "ogex"
    ]
  },
  "model/vnd.parasolid.transmit.binary": {
    "source": "iana",
    "extensions": [
      "x_b"
    ]
  },
  "model/vnd.parasolid.transmit.text": {
    "source": "iana",
    "extensions": [
      "x_t"
    ]
  },
  "model/vnd.pytha.pyox": {
    "source": "iana",
    "extensions": [
      "pyo",
      "pyox"
    ]
  },
  "model/vnd.rosette.annotated-data-model": {
    "source": "iana"
  },
  "model/vnd.sap.vds": {
    "source": "iana",
    "extensions": [
      "vds"
    ]
  },
  "model/vnd.usda": {
    "source": "iana",
    "extensions": [
      "usda"
    ]
  },
  "model/vnd.usdz+zip": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "usdz"
    ]
  },
  "model/vnd.valve.source.compiled-map": {
    "source": "iana",
    "extensions": [
      "bsp"
    ]
  },
  "model/vnd.vtu": {
    "source": "iana",
    "extensions": [
      "vtu"
    ]
  },
  "model/vrml": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "wrl",
      "vrml"
    ]
  },
  "model/x3d+binary": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "x3db",
      "x3dbz"
    ]
  },
  "model/x3d+fastinfoset": {
    "source": "iana",
    "extensions": [
      "x3db"
    ]
  },
  "model/x3d+vrml": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "x3dv",
      "x3dvz"
    ]
  },
  "model/x3d+xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "x3d",
      "x3dz"
    ]
  },
  "model/x3d-vrml": {
    "source": "iana",
    "extensions": [
      "x3dv"
    ]
  },
  "multipart/alternative": {
    "source": "iana",
    "compressible": false
  },
  "multipart/appledouble": {
    "source": "iana"
  },
  "multipart/byteranges": {
    "source": "iana"
  },
  "multipart/digest": {
    "source": "iana"
  },
  "multipart/encrypted": {
    "source": "iana",
    "compressible": false
  },
  "multipart/form-data": {
    "source": "iana",
    "compressible": false
  },
  "multipart/header-set": {
    "source": "iana"
  },
  "multipart/mixed": {
    "source": "iana"
  },
  "multipart/multilingual": {
    "source": "iana"
  },
  "multipart/parallel": {
    "source": "iana"
  },
  "multipart/related": {
    "source": "iana",
    "compressible": false
  },
  "multipart/report": {
    "source": "iana"
  },
  "multipart/signed": {
    "source": "iana",
    "compressible": false
  },
  "multipart/vnd.bint.med-plus": {
    "source": "iana"
  },
  "multipart/voice-message": {
    "source": "iana"
  },
  "multipart/x-mixed-replace": {
    "source": "iana"
  },
  "text/1d-interleaved-parityfec": {
    "source": "iana"
  },
  "text/cache-manifest": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "appcache",
      "manifest"
    ]
  },
  "text/calendar": {
    "source": "iana",
    "extensions": [
      "ics",
      "ifb"
    ]
  },
  "text/calender": {
    "compressible": true
  },
  "text/cmd": {
    "compressible": true
  },
  "text/coffeescript": {
    "extensions": [
      "coffee",
      "litcoffee"
    ]
  },
  "text/cql": {
    "source": "iana"
  },
  "text/cql-expression": {
    "source": "iana"
  },
  "text/cql-identifier": {
    "source": "iana"
  },
  "text/css": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true,
    "extensions": [
      "css"
    ]
  },
  "text/csv": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "csv"
    ]
  },
  "text/csv-schema": {
    "source": "iana"
  },
  "text/directory": {
    "source": "iana"
  },
  "text/dns": {
    "source": "iana"
  },
  "text/ecmascript": {
    "source": "apache"
  },
  "text/encaprtp": {
    "source": "iana"
  },
  "text/enriched": {
    "source": "iana"
  },
  "text/fhirpath": {
    "source": "iana"
  },
  "text/flexfec": {
    "source": "iana"
  },
  "text/fwdred": {
    "source": "iana"
  },
  "text/gff3": {
    "source": "iana"
  },
  "text/grammar-ref-list": {
    "source": "iana"
  },
  "text/hl7v2": {
    "source": "iana"
  },
  "text/html": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "html",
      "htm",
      "shtml"
    ]
  },
  "text/jade": {
    "extensions": [
      "jade"
    ]
  },
  "text/javascript": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true,
    "extensions": [
      "js",
      "mjs"
    ]
  },
  "text/jcr-cnd": {
    "source": "iana"
  },
  "text/jsx": {
    "compressible": true,
    "extensions": [
      "jsx"
    ]
  },
  "text/less": {
    "compressible": true,
    "extensions": [
      "less"
    ]
  },
  "text/markdown": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "md",
      "markdown"
    ]
  },
  "text/mathml": {
    "source": "nginx",
    "extensions": [
      "mml"
    ]
  },
  "text/mdx": {
    "compressible": true,
    "extensions": [
      "mdx"
    ]
  },
  "text/mizar": {
    "source": "iana"
  },
  "text/n3": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true,
    "extensions": [
      "n3"
    ]
  },
  "text/parameters": {
    "source": "iana",
    "charset": "UTF-8"
  },
  "text/parityfec": {
    "source": "iana"
  },
  "text/plain": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "txt",
      "text",
      "conf",
      "def",
      "list",
      "log",
      "in",
      "ini"
    ]
  },
  "text/provenance-notation": {
    "source": "iana",
    "charset": "UTF-8"
  },
  "text/prs.fallenstein.rst": {
    "source": "iana"
  },
  "text/prs.lines.tag": {
    "source": "iana",
    "extensions": [
      "dsc"
    ]
  },
  "text/prs.prop.logic": {
    "source": "iana"
  },
  "text/raptorfec": {
    "source": "iana"
  },
  "text/red": {
    "source": "iana"
  },
  "text/rfc822-headers": {
    "source": "iana"
  },
  "text/richtext": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rtx"
    ]
  },
  "text/rtf": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "rtf"
    ]
  },
  "text/rtp-enc-aescm128": {
    "source": "iana"
  },
  "text/rtploopback": {
    "source": "iana"
  },
  "text/rtx": {
    "source": "iana"
  },
  "text/sgml": {
    "source": "iana",
    "extensions": [
      "sgml",
      "sgm"
    ]
  },
  "text/shaclc": {
    "source": "iana"
  },
  "text/shex": {
    "source": "iana",
    "extensions": [
      "shex"
    ]
  },
  "text/slim": {
    "extensions": [
      "slim",
      "slm"
    ]
  },
  "text/spdx": {
    "source": "iana",
    "extensions": [
      "spdx"
    ]
  },
  "text/strings": {
    "source": "iana"
  },
  "text/stylus": {
    "extensions": [
      "stylus",
      "styl"
    ]
  },
  "text/t140": {
    "source": "iana"
  },
  "text/tab-separated-values": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "tsv"
    ]
  },
  "text/troff": {
    "source": "iana",
    "extensions": [
      "t",
      "tr",
      "roff",
      "man",
      "me",
      "ms"
    ]
  },
  "text/turtle": {
    "source": "iana",
    "charset": "UTF-8",
    "extensions": [
      "ttl"
    ]
  },
  "text/ulpfec": {
    "source": "iana"
  },
  "text/uri-list": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "uri",
      "uris",
      "urls"
    ]
  },
  "text/vcard": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "vcard"
    ]
  },
  "text/vnd.a": {
    "source": "iana"
  },
  "text/vnd.abc": {
    "source": "iana"
  },
  "text/vnd.ascii-art": {
    "source": "iana"
  },
  "text/vnd.curl": {
    "source": "iana",
    "extensions": [
      "curl"
    ]
  },
  "text/vnd.curl.dcurl": {
    "source": "apache",
    "extensions": [
      "dcurl"
    ]
  },
  "text/vnd.curl.mcurl": {
    "source": "apache",
    "extensions": [
      "mcurl"
    ]
  },
  "text/vnd.curl.scurl": {
    "source": "apache",
    "extensions": [
      "scurl"
    ]
  },
  "text/vnd.debian.copyright": {
    "source": "iana",
    "charset": "UTF-8"
  },
  "text/vnd.dmclientscript": {
    "source": "iana"
  },
  "text/vnd.dvb.subtitle": {
    "source": "iana",
    "extensions": [
      "sub"
    ]
  },
  "text/vnd.esmertec.theme-descriptor": {
    "source": "iana",
    "charset": "UTF-8"
  },
  "text/vnd.exchangeable": {
    "source": "iana"
  },
  "text/vnd.familysearch.gedcom": {
    "source": "iana",
    "extensions": [
      "ged"
    ]
  },
  "text/vnd.ficlab.flt": {
    "source": "iana"
  },
  "text/vnd.fly": {
    "source": "iana",
    "extensions": [
      "fly"
    ]
  },
  "text/vnd.fmi.flexstor": {
    "source": "iana",
    "extensions": [
      "flx"
    ]
  },
  "text/vnd.gml": {
    "source": "iana"
  },
  "text/vnd.graphviz": {
    "source": "iana",
    "extensions": [
      "gv"
    ]
  },
  "text/vnd.hans": {
    "source": "iana"
  },
  "text/vnd.hgl": {
    "source": "iana"
  },
  "text/vnd.in3d.3dml": {
    "source": "iana",
    "extensions": [
      "3dml"
    ]
  },
  "text/vnd.in3d.spot": {
    "source": "iana",
    "extensions": [
      "spot"
    ]
  },
  "text/vnd.iptc.newsml": {
    "source": "iana"
  },
  "text/vnd.iptc.nitf": {
    "source": "iana"
  },
  "text/vnd.latex-z": {
    "source": "iana"
  },
  "text/vnd.motorola.reflex": {
    "source": "iana"
  },
  "text/vnd.ms-mediapackage": {
    "source": "iana"
  },
  "text/vnd.net2phone.commcenter.command": {
    "source": "iana"
  },
  "text/vnd.radisys.msml-basic-layout": {
    "source": "iana"
  },
  "text/vnd.senx.warpscript": {
    "source": "iana"
  },
  "text/vnd.si.uricatalogue": {
    "source": "apache"
  },
  "text/vnd.sosi": {
    "source": "iana"
  },
  "text/vnd.sun.j2me.app-descriptor": {
    "source": "iana",
    "charset": "UTF-8",
    "extensions": [
      "jad"
    ]
  },
  "text/vnd.trolltech.linguist": {
    "source": "iana",
    "charset": "UTF-8"
  },
  "text/vnd.wap.si": {
    "source": "iana"
  },
  "text/vnd.wap.sl": {
    "source": "iana"
  },
  "text/vnd.wap.wml": {
    "source": "iana",
    "extensions": [
      "wml"
    ]
  },
  "text/vnd.wap.wmlscript": {
    "source": "iana",
    "extensions": [
      "wmls"
    ]
  },
  "text/vtt": {
    "source": "iana",
    "charset": "UTF-8",
    "compressible": true,
    "extensions": [
      "vtt"
    ]
  },
  "text/wgsl": {
    "source": "iana",
    "extensions": [
      "wgsl"
    ]
  },
  "text/x-asm": {
    "source": "apache",
    "extensions": [
      "s",
      "asm"
    ]
  },
  "text/x-c": {
    "source": "apache",
    "extensions": [
      "c",
      "cc",
      "cxx",
      "cpp",
      "h",
      "hh",
      "dic"
    ]
  },
  "text/x-component": {
    "source": "nginx",
    "extensions": [
      "htc"
    ]
  },
  "text/x-fortran": {
    "source": "apache",
    "extensions": [
      "f",
      "for",
      "f77",
      "f90"
    ]
  },
  "text/x-gwt-rpc": {
    "compressible": true
  },
  "text/x-handlebars-template": {
    "extensions": [
      "hbs"
    ]
  },
  "text/x-java-source": {
    "source": "apache",
    "extensions": [
      "java"
    ]
  },
  "text/x-jquery-tmpl": {
    "compressible": true
  },
  "text/x-lua": {
    "extensions": [
      "lua"
    ]
  },
  "text/x-markdown": {
    "compressible": true,
    "extensions": [
      "mkd"
    ]
  },
  "text/x-nfo": {
    "source": "apache",
    "extensions": [
      "nfo"
    ]
  },
  "text/x-opml": {
    "source": "apache",
    "extensions": [
      "opml"
    ]
  },
  "text/x-org": {
    "compressible": true,
    "extensions": [
      "org"
    ]
  },
  "text/x-pascal": {
    "source": "apache",
    "extensions": [
      "p",
      "pas"
    ]
  },
  "text/x-processing": {
    "compressible": true,
    "extensions": [
      "pde"
    ]
  },
  "text/x-sass": {
    "extensions": [
      "sass"
    ]
  },
  "text/x-scss": {
    "extensions": [
      "scss"
    ]
  },
  "text/x-setext": {
    "source": "apache",
    "extensions": [
      "etx"
    ]
  },
  "text/x-sfv": {
    "source": "apache",
    "extensions": [
      "sfv"
    ]
  },
  "text/x-suse-ymp": {
    "compressible": true,
    "extensions": [
      "ymp"
    ]
  },
  "text/x-uuencode": {
    "source": "apache",
    "extensions": [
      "uu"
    ]
  },
  "text/x-vcalendar": {
    "source": "apache",
    "extensions": [
      "vcs"
    ]
  },
  "text/x-vcard": {
    "source": "apache",
    "extensions": [
      "vcf"
    ]
  },
  "text/xml": {
    "source": "iana",
    "compressible": true,
    "extensions": [
      "xml"
    ]
  },
  "text/xml-external-parsed-entity": {
    "source": "iana"
  },
  "text/yaml": {
    "compressible": true,
    "extensions": [
      "yaml",
      "yml"
    ]
  },
  "video/1d-interleaved-parityfec": {
    "source": "iana"
  },
  "video/3gpp": {
    "source": "iana",
    "extensions": [
      "3gp",
      "3gpp"
    ]
  },
  "video/3gpp-tt": {
    "source": "iana"
  },
  "video/3gpp2": {
    "source": "iana",
    "extensions": [
      "3g2"
    ]
  },
  "video/av1": {
    "source": "iana"
  },
  "video/bmpeg": {
    "source": "iana"
  },
  "video/bt656": {
    "source": "iana"
  },
  "video/celb": {
    "source": "iana"
  },
  "video/dv": {
    "source": "iana"
  },
  "video/encaprtp": {
    "source": "iana"
  },
  "video/ffv1": {
    "source": "iana"
  },
  "video/flexfec": {
    "source": "iana"
  },
  "video/h261": {
    "source": "iana",
    "extensions": [
      "h261"
    ]
  },
  "video/h263": {
    "source": "iana",
    "extensions": [
      "h263"
    ]
  },
  "video/h263-1998": {
    "source": "iana"
  },
  "video/h263-2000": {
    "source": "iana"
  },
  "video/h264": {
    "source": "iana",
    "extensions": [
      "h264"
    ]
  },
  "video/h264-rcdo": {
    "source": "iana"
  },
  "video/h264-svc": {
    "source": "iana"
  },
  "video/h265": {
    "source": "iana"
  },
  "video/h266": {
    "source": "iana"
  },
  "video/iso.segment": {
    "source": "iana",
    "extensions": [
      "m4s"
    ]
  },
  "video/jpeg": {
    "source": "iana",
    "extensions": [
      "jpgv"
    ]
  },
  "video/jpeg2000": {
    "source": "iana"
  },
  "video/jpm": {
    "source": "apache",
    "extensions": [
      "jpm",
      "jpgm"
    ]
  },
  "video/jxsv": {
    "source": "iana"
  },
  "video/mj2": {
    "source": "iana",
    "extensions": [
      "mj2",
      "mjp2"
    ]
  },
  "video/mp1s": {
    "source": "iana"
  },
  "video/mp2p": {
    "source": "iana"
  },
  "video/mp2t": {
    "source": "iana",
    "extensions": [
      "ts"
    ]
  },
  "video/mp4": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "mp4",
      "mp4v",
      "mpg4"
    ]
  },
  "video/mp4v-es": {
    "source": "iana"
  },
  "video/mpeg": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "mpeg",
      "mpg",
      "mpe",
      "m1v",
      "m2v"
    ]
  },
  "video/mpeg4-generic": {
    "source": "iana"
  },
  "video/mpv": {
    "source": "iana"
  },
  "video/nv": {
    "source": "iana"
  },
  "video/ogg": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "ogv"
    ]
  },
  "video/parityfec": {
    "source": "iana"
  },
  "video/pointer": {
    "source": "iana"
  },
  "video/quicktime": {
    "source": "iana",
    "compressible": false,
    "extensions": [
      "qt",
      "mov"
    ]
  },
  "video/raptorfec": {
    "source": "iana"
  },
  "video/raw": {
    "source": "iana"
  },
  "video/rtp-enc-aescm128": {
    "source": "iana"
  },
  "video/rtploopback": {
    "source": "iana"
  },
  "video/rtx": {
    "source": "iana"
  },
  "video/scip": {
    "source": "iana"
  },
  "video/smpte291": {
    "source": "iana"
  },
  "video/smpte292m": {
    "source": "iana"
  },
  "video/ulpfec": {
    "source": "iana"
  },
  "video/vc1": {
    "source": "iana"
  },
  "video/vc2": {
    "source": "iana"
  },
  "video/vnd.cctv": {
    "source": "iana"
  },
  "video/vnd.dece.hd": {
    "source": "iana",
    "extensions": [
      "uvh",
      "uvvh"
    ]
  },
  "video/vnd.dece.mobile": {
    "source": "iana",
    "extensions": [
      "uvm",
      "uvvm"
    ]
  },
  "video/vnd.dece.mp4": {
    "source": "iana"
  },
  "video/vnd.dece.pd": {
    "source": "iana",
    "extensions": [
      "uvp",
      "uvvp"
    ]
  },
  "video/vnd.dece.sd": {
    "source": "iana",
    "extensions": [
      "uvs",
      "uvvs"
    ]
  },
  "video/vnd.dece.video": {
    "source": "iana",
    "extensions": [
      "uvv",
      "uvvv"
    ]
  },
  "video/vnd.directv.mpeg": {
    "source": "iana"
  },
  "video/vnd.directv.mpeg-tts": {
    "source": "iana"
  },
  "video/vnd.dlna.mpeg-tts": {
    "source": "iana"
  },
  "video/vnd.dvb.file": {
    "source": "iana",
    "extensions": [
      "dvb"
    ]
  },
  "video/vnd.fvt": {
    "source": "iana",
    "extensions": [
      "fvt"
    ]
  },
  "video/vnd.hns.video": {
    "source": "iana"
  },
  "video/vnd.iptvforum.1dparityfec-1010": {
    "source": "iana"
  },
  "video/vnd.iptvforum.1dparityfec-2005": {
    "source": "iana"
  },
  "video/vnd.iptvforum.2dparityfec-1010": {
    "source": "iana"
  },
  "video/vnd.iptvforum.2dparityfec-2005": {
    "source": "iana"
  },
  "video/vnd.iptvforum.ttsavc": {
    "source": "iana"
  },
  "video/vnd.iptvforum.ttsmpeg2": {
    "source": "iana"
  },
  "video/vnd.motorola.video": {
    "source": "iana"
  },
  "video/vnd.motorola.videop": {
    "source": "iana"
  },
  "video/vnd.mpegurl": {
    "source": "iana",
    "extensions": [
      "mxu",
      "m4u"
    ]
  },
  "video/vnd.ms-playready.media.pyv": {
    "source": "iana",
    "extensions": [
      "pyv"
    ]
  },
  "video/vnd.nokia.interleaved-multimedia": {
    "source": "iana"
  },
  "video/vnd.nokia.mp4vr": {
    "source": "iana"
  },
  "video/vnd.nokia.videovoip": {
    "source": "iana"
  },
  "video/vnd.objectvideo": {
    "source": "iana"
  },
  "video/vnd.radgamettools.bink": {
    "source": "iana"
  },
  "video/vnd.radgamettools.smacker": {
    "source": "apache"
  },
  "video/vnd.sealed.mpeg1": {
    "source": "iana"
  },
  "video/vnd.sealed.mpeg4": {
    "source": "iana"
  },
  "video/vnd.sealed.swf": {
    "source": "iana"
  },
  "video/vnd.sealedmedia.softseal.mov": {
    "source": "iana"
  },
  "video/vnd.uvvu.mp4": {
    "source": "iana",
    "extensions": [
      "uvu",
      "uvvu"
    ]
  },
  "video/vnd.vivo": {
    "source": "iana",
    "extensions": [
      "viv"
    ]
  },
  "video/vnd.youtube.yt": {
    "source": "iana"
  },
  "video/vp8": {
    "source": "iana"
  },
  "video/vp9": {
    "source": "iana"
  },
  "video/webm": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "webm"
    ]
  },
  "video/x-f4v": {
    "source": "apache",
    "extensions": [
      "f4v"
    ]
  },
  "video/x-fli": {
    "source": "apache",
    "extensions": [
      "fli"
    ]
  },
  "video/x-flv": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "flv"
    ]
  },
  "video/x-m4v": {
    "source": "apache",
    "extensions": [
      "m4v"
    ]
  },
  "video/x-matroska": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "mkv",
      "mk3d",
      "mks"
    ]
  },
  "video/x-mng": {
    "source": "apache",
    "extensions": [
      "mng"
    ]
  },
  "video/x-ms-asf": {
    "source": "apache",
    "extensions": [
      "asf",
      "asx"
    ]
  },
  "video/x-ms-vob": {
    "source": "apache",
    "extensions": [
      "vob"
    ]
  },
  "video/x-ms-wm": {
    "source": "apache",
    "extensions": [
      "wm"
    ]
  },
  "video/x-ms-wmv": {
    "source": "apache",
    "compressible": false,
    "extensions": [
      "wmv"
    ]
  },
  "video/x-ms-wmx": {
    "source": "apache",
    "extensions": [
      "wmx"
    ]
  },
  "video/x-ms-wvx": {
    "source": "apache",
    "extensions": [
      "wvx"
    ]
  },
  "video/x-msvideo": {
    "source": "apache",
    "extensions": [
      "avi"
    ]
  },
  "video/x-sgi-movie": {
    "source": "apache",
    "extensions": [
      "movie"
    ]
  },
  "video/x-smv": {
    "source": "apache",
    "extensions": [
      "smv"
    ]
  },
  "x-conference/x-cooltalk": {
    "source": "apache",
    "extensions": [
      "ice"
    ]
  },
  "x-shader/x-fragment": {
    "compressible": true
  },
  "x-shader/x-vertex": {
    "compressible": true
  }
};
//# sourceMappingURL=data:application/json;base64,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