// Ported from js-yaml v3.13.1:
// https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da
// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
export const BOM = 0xfeff; /* BOM */ 
export const TAB = 0x09; /* Tab */ 
export const LINE_FEED = 0x0a; /* LF */ 
export const CARRIAGE_RETURN = 0x0d; /* CR */ 
export const SPACE = 0x20; /* Space */ 
export const EXCLAMATION = 0x21; /* ! */ 
export const DOUBLE_QUOTE = 0x22; /* " */ 
export const SHARP = 0x23; /* # */ 
export const PERCENT = 0x25; /* % */ 
export const AMPERSAND = 0x26; /* & */ 
export const SINGLE_QUOTE = 0x27; /* ' */ 
export const ASTERISK = 0x2a; /* * */ 
export const PLUS = 0x2b; /* + */ 
export const COMMA = 0x2c; /* , */ 
export const MINUS = 0x2d; /* - */ 
export const DOT = 0x2e; /* . */ 
export const COLON = 0x3a; /* : */ 
export const SMALLER_THAN = 0x3c; /* < */ 
export const GREATER_THAN = 0x3e; /* > */ 
export const QUESTION = 0x3f; /* ? */ 
export const COMMERCIAL_AT = 0x40; /* @ */ 
export const LEFT_SQUARE_BRACKET = 0x5b; /* [ */ 
export const BACKSLASH = 0x5c; /* \ */ 
export const RIGHT_SQUARE_BRACKET = 0x5d; /* ] */ 
export const GRAVE_ACCENT = 0x60; /* ` */ 
export const LEFT_CURLY_BRACKET = 0x7b; /* { */ 
export const VERTICAL_LINE = 0x7c; /* | */ 
export const RIGHT_CURLY_BRACKET = 0x7d; /* } */ 
export function isEOL(c) {
  return c === LINE_FEED || c === CARRIAGE_RETURN;
}
export function isWhiteSpace(c) {
  return c === TAB || c === SPACE;
}
export function isWhiteSpaceOrEOL(c) {
  return isWhiteSpace(c) || isEOL(c);
}
export function isFlowIndicator(c) {
  return c === COMMA || c === LEFT_SQUARE_BRACKET || c === RIGHT_SQUARE_BRACKET || c === LEFT_CURLY_BRACKET || c === RIGHT_CURLY_BRACKET;
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=13874233409690842406,10037382643070472863