// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
import { FixedWidthBuilder } from '../builder.mjs';
import { setTime, setTimeSecond, setTimeMillisecond, setTimeMicrosecond, setTimeNanosecond } from '../visitor/set.mjs';
/** @ignore */
export class TimeBuilder extends FixedWidthBuilder {
}
TimeBuilder.prototype._setValue = setTime;
/** @ignore */
export class TimeSecondBuilder extends TimeBuilder {
}
TimeSecondBuilder.prototype._setValue = setTimeSecond;
/** @ignore */
export class TimeMillisecondBuilder extends TimeBuilder {
}
TimeMillisecondBuilder.prototype._setValue = setTimeMillisecond;
/** @ignore */
export class TimeMicrosecondBuilder extends TimeBuilder {
}
TimeMicrosecondBuilder.prototype._setValue = setTimeMicrosecond;
/** @ignore */
export class TimeNanosecondBuilder extends TimeBuilder {
}
TimeNanosecondBuilder.prototype._setValue = setTimeNanosecond;

//# sourceMappingURL=time.mjs.map
