// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
// Keep this up-to-date with Deno.build.os
/**
 * Operating system type, equivalent to the type of
 * {@linkcode https://deno.land/api?s=Deno.build | Deno.build.os}.
 */ function getOsType() {
  // deno-lint-ignore no-explicit-any
  return globalThis.Deno?.build.os || (navigator.userAgent.includes("Win") ? "windows" : "linux");
}
export const isWindows = getOsType() === "windows";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vanNyLmlvL0BzdGQvcGF0aC8xLjAuMC1yYy4yL19vcy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG4vLyBLZWVwIHRoaXMgdXAtdG8tZGF0ZSB3aXRoIERlbm8uYnVpbGQub3Ncbi8qKlxuICogT3BlcmF0aW5nIHN5c3RlbSB0eXBlLCBlcXVpdmFsZW50IHRvIHRoZSB0eXBlIG9mXG4gKiB7QGxpbmtjb2RlIGh0dHBzOi8vZGVuby5sYW5kL2FwaT9zPURlbm8uYnVpbGQgfCBEZW5vLmJ1aWxkLm9zfS5cbiAqL1xudHlwZSBPU1R5cGUgPVxuICB8IFwiZGFyd2luXCJcbiAgfCBcImxpbnV4XCJcbiAgfCBcIndpbmRvd3NcIlxuICB8IFwiZnJlZWJzZFwiXG4gIHwgXCJuZXRic2RcIlxuICB8IFwiYWl4XCJcbiAgfCBcInNvbGFyaXNcIlxuICB8IFwiaWxsdW1vc1wiXG4gIHwgXCJhbmRyb2lkXCI7XG5cbmZ1bmN0aW9uIGdldE9zVHlwZSgpOiBPU1R5cGUge1xuICAvLyBkZW5vLWxpbnQtaWdub3JlIG5vLWV4cGxpY2l0LWFueVxuICByZXR1cm4gKGdsb2JhbFRoaXMgYXMgYW55KS5EZW5vPy5idWlsZC5vcyB8fFxuICAgIChuYXZpZ2F0b3IudXNlckFnZW50LmluY2x1ZGVzKFwiV2luXCIpID8gXCJ3aW5kb3dzXCIgOiBcImxpbnV4XCIpO1xufVxuXG5leHBvcnQgY29uc3QgaXNXaW5kb3dzOiBib29sZWFuID0gZ2V0T3NUeXBlKCkgPT09IFwid2luZG93c1wiO1xuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLDBFQUEwRTtBQUMxRSxxQ0FBcUM7QUFFckMsMENBQTBDO0FBQzFDOzs7Q0FHQyxHQVlELFNBQVM7RUFDUCxtQ0FBbUM7RUFDbkMsT0FBTyxBQUFDLFdBQW1CLElBQUksRUFBRSxNQUFNLE1BQ3JDLENBQUMsVUFBVSxTQUFTLENBQUMsUUFBUSxDQUFDLFNBQVMsWUFBWSxPQUFPO0FBQzlEO0FBRUEsT0FBTyxNQUFNLFlBQXFCLGdCQUFnQixVQUFVIn0=