/*!--------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*//******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

export function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

export var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

export function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

export function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

export function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

export function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

export function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

export function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

export function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

export function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

export function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

export function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

export var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

export function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

export function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

export function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
export function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
export function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

export function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

export function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

export function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

export function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

export function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

export function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

export function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

export function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

export function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

export function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

export function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

export function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose, inner;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
            if (async) inner = dispose;
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;

}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

export function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

export default {
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
};


// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/_.contribution.js
var $pKc = class _$pKc {
  static {
    this.INSTANCE = new _$pKc();
  }
  get layoutInfos() {
    return this.a;
  }
  constructor() {
    this.a = [];
  }
  registerKeyboardLayout(layout) {
    this.a.push(layout);
  }
};

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/en.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000409", id: "", text: "US", isUSStandard: true },
  secondaryLayouts: [
    { name: "00000804", id: "", text: "Chinese (Simplified) - US Keyboard" },
    { name: "00000411", id: "", text: "Japanese" },
    { name: "00000412", id: "", text: "Korean" },
    { name: "00000404", id: "", text: "Chinese (Traditional) - US Keyboard" }
  ],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", "@", "", "", 0, "VK_2"],
    Digit3: ["3", "#", "", "", 0, "VK_3"],
    Digit4: ["4", "$", "", "", 0, "VK_4"],
    Digit5: ["5", "%", "", "", 0, "VK_5"],
    Digit6: ["6", "^", "", "", 0, "VK_6"],
    Digit7: ["7", "&", "", "", 0, "VK_7"],
    Digit8: ["8", "*", "", "", 0, "VK_8"],
    Digit9: ["9", "(", "", "", 0, "VK_9"],
    Digit0: ["0", ")", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    Equal: ["=", "+", "", "", 0, "VK_OEM_PLUS"],
    BracketLeft: ["[", "{", "", "", 0, "VK_OEM_4"],
    BracketRight: ["]", "}", "", "", 0, "VK_OEM_6"],
    Backslash: ["\\", "|", "", "", 0, "VK_OEM_5"],
    Semicolon: [";", ":", "", "", 0, "VK_OEM_1"],
    Quote: ["'", '"', "", "", 0, "VK_OEM_7"],
    Backquote: ["`", "~", "", "", 0, "VK_OEM_3"],
    Comma: [",", "<", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ">", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["/", "?", "", "", 0, "VK_OEM_2"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["\\", "|", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/es-latin.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "0000080A", id: "", text: "Latin American" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "@", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", '"', "", "", 0, "VK_2"],
    Digit3: ["3", "#", "", "", 0, "VK_3"],
    Digit4: ["4", "$", "", "", 0, "VK_4"],
    Digit5: ["5", "%", "", "", 0, "VK_5"],
    Digit6: ["6", "&", "", "", 0, "VK_6"],
    Digit7: ["7", "/", "", "", 0, "VK_7"],
    Digit8: ["8", "(", "", "", 0, "VK_8"],
    Digit9: ["9", ")", "", "", 0, "VK_9"],
    Digit0: ["0", "=", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["'", "?", "\\", "", 0, "VK_OEM_4"],
    Equal: ["\xBF", "\xA1", "", "", 0, "VK_OEM_6"],
    BracketLeft: ["\xB4", "\xA8", "", "", 0, "VK_OEM_1"],
    BracketRight: ["+", "*", "~", "", 0, "VK_OEM_PLUS"],
    Backslash: ["}", "]", "`", "", 0, "VK_OEM_2"],
    Semicolon: ["\xF1", "\xD1", "", "", 0, "VK_OEM_3"],
    Quote: ["{", "[", "^", "", 0, "VK_OEM_7"],
    Backquote: ["|", "\xB0", "\xAC", "", 0, "VK_OEM_5"],
    Comma: [",", ";", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/en-in.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00004009", id: "", text: "India" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "\u0101", "\u0100", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "\u1E0D", "\u1E0C", 0, "VK_D"],
    KeyE: ["e", "E", "\u0113", "\u0112", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "\u1E45", "\u1E44", 0, "VK_G"],
    KeyH: ["h", "H", "\u1E25", "\u1E24", 0, "VK_H"],
    KeyI: ["i", "I", "\u012B", "\u012A", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "l\u0325", "L\u0325", 0, "VK_L"],
    KeyM: ["m", "M", "\u1E41", "\u1E40", 0, "VK_M"],
    KeyN: ["n", "N", "\u1E47", "\u1E46", 0, "VK_N"],
    KeyO: ["o", "O", "\u014D", "\u014C", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "\xE6", "\xC6", 0, "VK_Q"],
    KeyR: ["r", "R", "r\u0325", "R\u0325", 0, "VK_R"],
    KeyS: ["s", "S", "\u015B", "\u015A", 0, "VK_S"],
    KeyT: ["t", "T", "\u1E6D", "\u1E6C", 0, "VK_T"],
    KeyU: ["u", "U", "\u016B", "\u016A", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "\u1E63", "\u1E62", 0, "VK_X"],
    KeyY: ["y", "Y", "\xF1", "\xD1", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", "@", "", "", 0, "VK_2"],
    Digit3: ["3", "#", "", "", 0, "VK_3"],
    Digit4: ["4", "$", "\u20B9", "", 0, "VK_4"],
    Digit5: ["5", "%", "", "", 0, "VK_5"],
    Digit6: ["6", "^", "", "\u02C6", 0, "VK_6"],
    Digit7: ["7", "&", "", "", 0, "VK_7"],
    Digit8: ["8", "*", "", "", 0, "VK_8"],
    Digit9: ["9", "(", "", "\u02D8", 0, "VK_9"],
    Digit0: ["0", ")", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["-", "_", "-", "\u02CD", 0, "VK_OEM_MINUS"],
    Equal: ["=", "+", "", "", 0, "VK_OEM_PLUS"],
    BracketLeft: ["[", "{", "", "", 0, "VK_OEM_4"],
    BracketRight: ["]", "}", "", "", 0, "VK_OEM_6"],
    Backslash: ["\\", "|", "", "", 0, "VK_OEM_5"],
    Semicolon: [";", ":", "", "", 0, "VK_OEM_1"],
    Quote: ["'", '"', "", "", 0, "VK_OEM_7"],
    Backquote: ["`", "~", "", "~", 0, "VK_OEM_3"],
    Comma: [",", "<", ",", "<", 0, "VK_OEM_COMMA"],
    Period: [".", ">", ".", "", 0, "VK_OEM_PERIOD"],
    Slash: ["/", "?", "", "", 0, "VK_OEM_2"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["\\", "|", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/de.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000407", id: "", text: "German" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "\xB5", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "@", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["z", "Z", "", "", 0, "VK_Z"],
    KeyZ: ["y", "Y", "", "", 0, "VK_Y"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", '"', "\xB2", "", 0, "VK_2"],
    Digit3: ["3", "\xA7", "\xB3", "", 0, "VK_3"],
    Digit4: ["4", "$", "", "", 0, "VK_4"],
    Digit5: ["5", "%", "", "", 0, "VK_5"],
    Digit6: ["6", "&", "", "", 0, "VK_6"],
    Digit7: ["7", "/", "{", "", 0, "VK_7"],
    Digit8: ["8", "(", "[", "", 0, "VK_8"],
    Digit9: ["9", ")", "]", "", 0, "VK_9"],
    Digit0: ["0", "=", "}", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["\xDF", "?", "\\", "\u1E9E", 0, "VK_OEM_4"],
    Equal: ["\xB4", "`", "", "", 0, "VK_OEM_6"],
    BracketLeft: ["\xFC", "\xDC", "", "", 0, "VK_OEM_1"],
    BracketRight: ["+", "*", "~", "", 0, "VK_OEM_PLUS"],
    Backslash: ["#", "'", "", "", 0, "VK_OEM_2"],
    Semicolon: ["\xF6", "\xD6", "", "", 0, "VK_OEM_3"],
    Quote: ["\xE4", "\xC4", "", "", 0, "VK_OEM_7"],
    Backquote: ["^", "\xB0", "", "", 0, "VK_OEM_5"],
    Comma: [",", ";", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "|", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/en-uk.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000809", id: "", text: "United Kingdom" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "\xE1", "\xC1", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\xE9", "\xC9", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "\xED", "\xCD", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "\xF3", "\xD3", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "\xFA", "\xDA", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", '"', "", "", 0, "VK_2"],
    Digit3: ["3", "\xA3", "", "", 0, "VK_3"],
    Digit4: ["4", "$", "\u20AC", "", 0, "VK_4"],
    Digit5: ["5", "%", "", "", 0, "VK_5"],
    Digit6: ["6", "^", "", "", 0, "VK_6"],
    Digit7: ["7", "&", "", "", 0, "VK_7"],
    Digit8: ["8", "*", "", "", 0, "VK_8"],
    Digit9: ["9", "(", "", "", 0, "VK_9"],
    Digit0: ["0", ")", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    Equal: ["=", "+", "", "", 0, "VK_OEM_PLUS"],
    BracketLeft: ["[", "{", "", "", 0, "VK_OEM_4"],
    BracketRight: ["]", "}", "", "", 0, "VK_OEM_6"],
    Backslash: ["#", "~", "\\", "|", 0, "VK_OEM_7"],
    Semicolon: [";", ":", "", "", 0, "VK_OEM_1"],
    Quote: ["'", "@", "", "", 0, "VK_OEM_3"],
    Backquote: ["`", "\xAC", "\xA6", "", 0, "VK_OEM_8"],
    Comma: [",", "<", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ">", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["/", "?", "", "", 0, "VK_OEM_2"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["\\", "|", "", "", 0, "VK_OEM_5"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/fr.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "0000040C", id: "", text: "French" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["q", "Q", "", "", 0, "VK_Q"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: [",", "?", "", "", 0, "VK_OEM_COMMA"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["a", "A", "", "", 0, "VK_A"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["z", "Z", "", "", 0, "VK_Z"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["w", "W", "", "", 0, "VK_W"],
    Digit1: ["&", "1", "", "", 0, "VK_1"],
    Digit2: ["\xE9", "2", "~", "", 0, "VK_2"],
    Digit3: ['"', "3", "#", "", 0, "VK_3"],
    Digit4: ["'", "4", "{", "", 0, "VK_4"],
    Digit5: ["(", "5", "[", "", 0, "VK_5"],
    Digit6: ["-", "6", "|", "", 0, "VK_6"],
    Digit7: ["\xE8", "7", "`", "", 0, "VK_7"],
    Digit8: ["_", "8", "\\", "", 0, "VK_8"],
    Digit9: ["\xE7", "9", "^", "", 0, "VK_9"],
    Digit0: ["\xE0", "0", "@", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: [")", "\xB0", "]", "", 0, "VK_OEM_4"],
    Equal: ["=", "+", "}", "", 0, "VK_OEM_PLUS"],
    BracketLeft: ["^", "\xA8", "", "", 0, "VK_OEM_6"],
    BracketRight: ["$", "\xA3", "\xA4", "", 0, "VK_OEM_1"],
    Backslash: ["*", "\xB5", "", "", 0, "VK_OEM_5"],
    Semicolon: ["m", "M", "", "", 0, "VK_M"],
    Quote: ["\xF9", "%", "", "", 0, "VK_OEM_3"],
    Backquote: ["\xB2", "", "", "", 0, "VK_OEM_7"],
    Comma: [";", ".", "", "", 0, "VK_OEM_PERIOD"],
    Period: [":", "/", "", "", 0, "VK_OEM_2"],
    Slash: ["!", "\xA7", "", "", 0, "VK_OEM_8"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/pt-br.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000416", id: "", text: "Portuguese (Brazilian ABNT)" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "\u20A2", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\xB0", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "/", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "?", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "\xB9", "", 0, "VK_1"],
    Digit2: ["2", "@", "\xB2", "", 0, "VK_2"],
    Digit3: ["3", "#", "\xB3", "", 0, "VK_3"],
    Digit4: ["4", "$", "\xA3", "", 0, "VK_4"],
    Digit5: ["5", "%", "\xA2", "", 0, "VK_5"],
    Digit6: ["6", "\xA8", "\xAC", "", 0, "VK_6"],
    Digit7: ["7", "&", "", "", 0, "VK_7"],
    Digit8: ["8", "*", "", "", 0, "VK_8"],
    Digit9: ["9", "(", "", "", 0, "VK_9"],
    Digit0: ["0", ")", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    Equal: ["=", "+", "\xA7", "", 0, "VK_OEM_PLUS"],
    BracketLeft: ["\xB4", "`", "", "", 0, "VK_OEM_4"],
    BracketRight: ["[", "{", "\xAA", "", 0, "VK_OEM_6"],
    Backslash: ["]", "}", "\xBA", "", 0, "VK_OEM_5"],
    Semicolon: ["\xE7", "\xC7", "", "", 0, "VK_OEM_1"],
    Quote: ["~", "^", "", "", 0, "VK_OEM_7"],
    Backquote: ["'", '"', "", "", 0, "VK_OEM_3"],
    Comma: [",", "<", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ">", "", "", 0, "VK_OEM_PERIOD"],
    Slash: [";", ":", "", "", 0, "VK_OEM_2"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["\\", "|", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [".", ".", "", "", 0, "VK_ABNT_C2"],
    IntlRo: ["/", "?", "\xB0", "", 0, "VK_ABNT_C1"],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/es.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "0000040A", id: "", text: "Spanish" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "|", "", 0, "VK_1"],
    Digit2: ["2", '"', "@", "", 0, "VK_2"],
    Digit3: ["3", "\xB7", "#", "", 0, "VK_3"],
    Digit4: ["4", "$", "~", "", 0, "VK_4"],
    Digit5: ["5", "%", "\u20AC", "", 0, "VK_5"],
    Digit6: ["6", "&", "\xAC", "", 0, "VK_6"],
    Digit7: ["7", "/", "", "", 0, "VK_7"],
    Digit8: ["8", "(", "", "", 0, "VK_8"],
    Digit9: ["9", ")", "", "", 0, "VK_9"],
    Digit0: ["0", "=", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["'", "?", "", "", 0, "VK_OEM_4"],
    Equal: ["\xA1", "\xBF", "", "", 0, "VK_OEM_6"],
    BracketLeft: ["`", "^", "[", "", 0, "VK_OEM_1"],
    BracketRight: ["+", "*", "]", "", 0, "VK_OEM_PLUS"],
    Backslash: ["\xE7", "\xC7", "}", "", 0, "VK_OEM_2"],
    Semicolon: ["\xF1", "\xD1", "", "", 0, "VK_OEM_3"],
    Quote: ["\xB4", "\xA8", "{", "", 0, "VK_OEM_7"],
    Backquote: ["\xBA", "\xAA", "\\", "", 0, "VK_OEM_5"],
    Comma: [",", ";", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/en-intl.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00020409", id: "0001", text: "United States-International" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "\xE1", "\xC1", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "\xA9", "\xA2", 0, "VK_C"],
    KeyD: ["d", "D", "\xF0", "\xD0", 0, "VK_D"],
    KeyE: ["e", "E", "\xE9", "\xC9", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "\xED", "\xCD", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "\xF8", "\xD8", 0, "VK_L"],
    KeyM: ["m", "M", "\xB5", "", 0, "VK_M"],
    KeyN: ["n", "N", "\xF1", "\xD1", 0, "VK_N"],
    KeyO: ["o", "O", "\xF3", "\xD3", 0, "VK_O"],
    KeyP: ["p", "P", "\xF6", "\xD6", 0, "VK_P"],
    KeyQ: ["q", "Q", "\xE4", "\xC4", 0, "VK_Q"],
    KeyR: ["r", "R", "\xAE", "", 0, "VK_R"],
    KeyS: ["s", "S", "\xDF", "\xA7", 0, "VK_S"],
    KeyT: ["t", "T", "\xFE", "\xDE", 0, "VK_T"],
    KeyU: ["u", "U", "\xFA", "\xDA", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "\xE5", "\xC5", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "\xFC", "\xDC", 0, "VK_Y"],
    KeyZ: ["z", "Z", "\xE6", "\xC6", 0, "VK_Z"],
    Digit1: ["1", "!", "\xA1", "\xB9", 0, "VK_1"],
    Digit2: ["2", "@", "\xB2", "", 0, "VK_2"],
    Digit3: ["3", "#", "\xB3", "", 0, "VK_3"],
    Digit4: ["4", "$", "\xA4", "\xA3", 0, "VK_4"],
    Digit5: ["5", "%", "\u20AC", "", 0, "VK_5"],
    Digit6: ["6", "^", "\xBC", "", 0, "VK_6"],
    Digit7: ["7", "&", "\xBD", "", 0, "VK_7"],
    Digit8: ["8", "*", "\xBE", "", 0, "VK_8"],
    Digit9: ["9", "(", "\u2018", "", 0, "VK_9"],
    Digit0: ["0", ")", "\u2019", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["-", "_", "\xA5", "", 0, "VK_OEM_MINUS"],
    Equal: ["=", "+", "\xD7", "\xF7", 0, "VK_OEM_PLUS"],
    BracketLeft: ["[", "{", "\xAB", "", 0, "VK_OEM_4"],
    BracketRight: ["]", "}", "\xBB", "", 0, "VK_OEM_6"],
    Backslash: ["\\", "|", "\xAC", "\xA6", 0, "VK_OEM_5"],
    Semicolon: [";", ":", "\xB6", "\xB0", 0, "VK_OEM_1"],
    Quote: ["'", '"', "\xB4", "\xA8", 0, "VK_OEM_7"],
    Backquote: ["`", "~", "", "", 0, "VK_OEM_3"],
    Comma: [",", "<", "\xE7", "\xC7", 0, "VK_OEM_COMMA"],
    Period: [".", ">", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["/", "?", "\xBF", "", 0, "VK_OEM_2"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["\\", "|", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/ru.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000419", id: "", text: "Russian" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["\u0444", "\u0424", "", "", 0, "VK_A"],
    KeyB: ["\u0438", "\u0418", "", "", 0, "VK_B"],
    KeyC: ["\u0441", "\u0421", "", "", 0, "VK_C"],
    KeyD: ["\u0432", "\u0412", "", "", 0, "VK_D"],
    KeyE: ["\u0443", "\u0423", "", "", 0, "VK_E"],
    KeyF: ["\u0430", "\u0410", "", "", 0, "VK_F"],
    KeyG: ["\u043F", "\u041F", "", "", 0, "VK_G"],
    KeyH: ["\u0440", "\u0420", "", "", 0, "VK_H"],
    KeyI: ["\u0448", "\u0428", "", "", 0, "VK_I"],
    KeyJ: ["\u043E", "\u041E", "", "", 0, "VK_J"],
    KeyK: ["\u043B", "\u041B", "", "", 0, "VK_K"],
    KeyL: ["\u0434", "\u0414", "", "", 0, "VK_L"],
    KeyM: ["\u044C", "\u042C", "", "", 0, "VK_M"],
    KeyN: ["\u0442", "\u0422", "", "", 0, "VK_N"],
    KeyO: ["\u0449", "\u0429", "", "", 0, "VK_O"],
    KeyP: ["\u0437", "\u0417", "", "", 0, "VK_P"],
    KeyQ: ["\u0439", "\u0419", "", "", 0, "VK_Q"],
    KeyR: ["\u043A", "\u041A", "", "", 0, "VK_R"],
    KeyS: ["\u044B", "\u042B", "", "", 0, "VK_S"],
    KeyT: ["\u0435", "\u0415", "", "", 0, "VK_T"],
    KeyU: ["\u0433", "\u0413", "", "", 0, "VK_U"],
    KeyV: ["\u043C", "\u041C", "", "", 0, "VK_V"],
    KeyW: ["\u0446", "\u0426", "", "", 0, "VK_W"],
    KeyX: ["\u0447", "\u0427", "", "", 0, "VK_X"],
    KeyY: ["\u043D", "\u041D", "", "", 0, "VK_Y"],
    KeyZ: ["\u044F", "\u042F", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", '"', "", "", 0, "VK_2"],
    Digit3: ["3", "\u2116", "", "", 0, "VK_3"],
    Digit4: ["4", ";", "", "", 0, "VK_4"],
    Digit5: ["5", "%", "", "", 0, "VK_5"],
    Digit6: ["6", ":", "", "", 0, "VK_6"],
    Digit7: ["7", "?", "", "", 0, "VK_7"],
    Digit8: ["8", "*", "\u20BD", "", 0, "VK_8"],
    Digit9: ["9", "(", "", "", 0, "VK_9"],
    Digit0: ["0", ")", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    Equal: ["=", "+", "", "", 0, "VK_OEM_PLUS"],
    BracketLeft: ["\u0445", "\u0425", "", "", 0, "VK_OEM_4"],
    BracketRight: ["\u044A", "\u042A", "", "", 0, "VK_OEM_6"],
    Backslash: ["\\", "/", "", "", 0, "VK_OEM_5"],
    Semicolon: ["\u0436", "\u0416", "", "", 0, "VK_OEM_1"],
    Quote: ["\u044D", "\u042D", "", "", 0, "VK_OEM_7"],
    Backquote: ["\u0451", "\u0401", "", "", 0, "VK_OEM_3"],
    Comma: ["\u0431", "\u0411", "", "", 0, "VK_OEM_COMMA"],
    Period: ["\u044E", "\u042E", "", "", 0, "VK_OEM_PERIOD"],
    Slash: [".", ",", "", "", 0, "VK_OEM_2"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["\\", "/", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/pl.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000415", id: "", text: "Polish (Programmers)" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "\u0105", "\u0104", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "\u0107", "\u0106", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u0119", "\u0118", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "\u0142", "\u0141", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "\u0144", "\u0143", 0, "VK_N"],
    KeyO: ["o", "O", "\xF3", "\xD3", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "\u015B", "\u015A", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "\u20AC", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "\u017A", "\u0179", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "\u017C", "\u017B", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", "@", "", "", 0, "VK_2"],
    Digit3: ["3", "#", "", "", 0, "VK_3"],
    Digit4: ["4", "$", "", "", 0, "VK_4"],
    Digit5: ["5", "%", "", "", 0, "VK_5"],
    Digit6: ["6", "^", "", "", 0, "VK_6"],
    Digit7: ["7", "&", "", "", 0, "VK_7"],
    Digit8: ["8", "*", "", "", 0, "VK_8"],
    Digit9: ["9", "(", "", "", 0, "VK_9"],
    Digit0: ["0", ")", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    Equal: ["=", "+", "", "", 0, "VK_OEM_PLUS"],
    BracketLeft: ["[", "{", "", "", 0, "VK_OEM_4"],
    BracketRight: ["]", "}", "", "", 0, "VK_OEM_6"],
    Backslash: ["\\", "|", "", "", 0, "VK_OEM_5"],
    Semicolon: [";", ":", "", "", 0, "VK_OEM_1"],
    Quote: ["'", '"', "", "", 0, "VK_OEM_7"],
    Backquote: ["`", "~", "", "", 0, "VK_OEM_3"],
    Comma: [",", "<", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ">", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["/", "?", "", "", 0, "VK_OEM_2"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["\\", "|", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/it.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000410", id: "", text: "Italian" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", '"', "", "", 0, "VK_2"],
    Digit3: ["3", "\xA3", "", "", 0, "VK_3"],
    Digit4: ["4", "$", "", "", 0, "VK_4"],
    Digit5: ["5", "%", "\u20AC", "", 0, "VK_5"],
    Digit6: ["6", "&", "", "", 0, "VK_6"],
    Digit7: ["7", "/", "", "", 0, "VK_7"],
    Digit8: ["8", "(", "", "", 0, "VK_8"],
    Digit9: ["9", ")", "", "", 0, "VK_9"],
    Digit0: ["0", "=", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["'", "?", "", "", 0, "VK_OEM_4"],
    Equal: ["\xEC", "^", "", "", 0, "VK_OEM_6"],
    BracketLeft: ["\xE8", "\xE9", "[", "{", 0, "VK_OEM_1"],
    BracketRight: ["+", "*", "]", "}", 0, "VK_OEM_PLUS"],
    Backslash: ["\xF9", "\xA7", "", "", 0, "VK_OEM_2"],
    Semicolon: ["\xF2", "\xE7", "@", "", 0, "VK_OEM_3"],
    Quote: ["\xE0", "\xB0", "#", "", 0, "VK_OEM_7"],
    Backquote: ["\\", "|", "", "", 0, "VK_OEM_5"],
    Comma: [",", ";", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/sv.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "0000041D", id: "", text: "Swedish" },
  secondaryLayouts: [
    { name: "0000040B", id: "", text: "Finnish" }
  ],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "\xB5", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", '"', "@", "", 0, "VK_2"],
    Digit3: ["3", "#", "\xA3", "", 0, "VK_3"],
    Digit4: ["4", "\xA4", "$", "", 0, "VK_4"],
    Digit5: ["5", "%", "\u20AC", "", 0, "VK_5"],
    Digit6: ["6", "&", "", "", 0, "VK_6"],
    Digit7: ["7", "/", "{", "", 0, "VK_7"],
    Digit8: ["8", "(", "[", "", 0, "VK_8"],
    Digit9: ["9", ")", "]", "", 0, "VK_9"],
    Digit0: ["0", "=", "}", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["+", "?", "\\", "", 0, "VK_OEM_PLUS"],
    Equal: ["\xB4", "`", "", "", 0, "VK_OEM_4"],
    BracketLeft: ["\xE5", "\xC5", "", "", 0, "VK_OEM_6"],
    BracketRight: ["\xA8", "^", "~", "", 0, "VK_OEM_1"],
    Backslash: ["'", "*", "", "", 0, "VK_OEM_2"],
    Semicolon: ["\xF6", "\xD6", "", "", 0, "VK_OEM_3"],
    Quote: ["\xE4", "\xC4", "", "", 0, "VK_OEM_7"],
    Backquote: ["\xA7", "\xBD", "", "", 0, "VK_OEM_5"],
    Comma: [",", ";", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "|", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/tr.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "0000041F", id: "", text: "Turkish Q" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "\xE6", "\xC6", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["\u0131", "I", "i", "\u0130", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "@", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "\xDF", "", 0, "VK_S"],
    KeyT: ["t", "T", "\u20BA", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", ">", "", 0, "VK_1"],
    Digit2: ["2", "'", "\xA3", "", 0, "VK_2"],
    Digit3: ["3", "^", "#", "", 0, "VK_3"],
    Digit4: ["4", "+", "$", "", 0, "VK_4"],
    Digit5: ["5", "%", "\xBD", "", 0, "VK_5"],
    Digit6: ["6", "&", "", "", 0, "VK_6"],
    Digit7: ["7", "/", "{", "", 0, "VK_7"],
    Digit8: ["8", "(", "[", "", 0, "VK_8"],
    Digit9: ["9", ")", "]", "", 0, "VK_9"],
    Digit0: ["0", "=", "}", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["*", "?", "\\", "", 0, "VK_OEM_8"],
    Equal: ["-", "_", "|", "", 0, "VK_OEM_MINUS"],
    BracketLeft: ["\u011F", "\u011E", "\xA8", "", 0, "VK_OEM_4"],
    BracketRight: ["\xFC", "\xDC", "~", "", 0, "VK_OEM_6"],
    Backslash: [",", ";", "`", "", 0, "VK_OEM_COMMA"],
    Semicolon: ["\u015F", "\u015E", "\xB4", "", 0, "VK_OEM_1"],
    Quote: ["i", "\u0130", "", "", 0, "VK_OEM_7"],
    Backquote: ['"', "\xE9", "<", "", 0, "VK_OEM_3"],
    Comma: ["\xF6", "\xD6", "", "", 0, "VK_OEM_2"],
    Period: ["\xE7", "\xC7", "", "", 0, "VK_OEM_5"],
    Slash: [".", ":", "", "", 0, "VK_OEM_PERIOD"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "|", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/pt.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000816", id: "", text: "Portuguese" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", '"', "@", "", 0, "VK_2"],
    Digit3: ["3", "#", "\xA3", "", 0, "VK_3"],
    Digit4: ["4", "$", "\xA7", "", 0, "VK_4"],
    Digit5: ["5", "%", "\u20AC", "", 0, "VK_5"],
    Digit6: ["6", "&", "", "", 0, "VK_6"],
    Digit7: ["7", "/", "{", "", 0, "VK_7"],
    Digit8: ["8", "(", "[", "", 0, "VK_8"],
    Digit9: ["9", ")", "]", "", 0, "VK_9"],
    Digit0: ["0", "=", "}", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["'", "?", "", "", 0, "VK_OEM_4"],
    Equal: ["\xAB", "\xBB", "", "", 0, "VK_OEM_6"],
    BracketLeft: ["+", "*", "\xA8", "", 0, "VK_OEM_PLUS"],
    BracketRight: ["\xB4", "`", "]", "", 0, "VK_OEM_1"],
    Backslash: ["~", "^", "", "", 0, "VK_OEM_2"],
    Semicolon: ["\xE7", "\xC7", "", "", 0, "VK_OEM_3"],
    Quote: ["\xBA", "\xAA", "", "", 0, "VK_OEM_7"],
    Backquote: ["\\", "|", "", "", 0, "VK_OEM_5"],
    Comma: [",", ";", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/dk.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000406", id: "", text: "Danish" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "\xB5", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", '"', "@", "", 0, "VK_2"],
    Digit3: ["3", "#", "\xA3", "", 0, "VK_3"],
    Digit4: ["4", "\xA4", "$", "", 0, "VK_4"],
    Digit5: ["5", "%", "\u20AC", "", 0, "VK_5"],
    Digit6: ["6", "&", "", "", 0, "VK_6"],
    Digit7: ["7", "/", "{", "", 0, "VK_7"],
    Digit8: ["8", "(", "[", "", 0, "VK_8"],
    Digit9: ["9", ")", "]", "", 0, "VK_9"],
    Digit0: ["0", "=", "}", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["+", "?", "", "", 0, "VK_OEM_PLUS"],
    Equal: ["\xB4", "`", "|", "", 0, "VK_OEM_4"],
    BracketLeft: ["\xE5", "\xC5", "", "", 0, "VK_OEM_6"],
    BracketRight: ["\xA8", "^", "~", "", 0, "VK_OEM_1"],
    Backslash: ["'", "*", "", "", 0, "VK_OEM_2"],
    Semicolon: ["\xE6", "\xC6", "", "", 0, "VK_OEM_3"],
    Quote: ["\xF8", "\xD8", "", "", 0, "VK_OEM_7"],
    Backquote: ["\xBD", "\xA7", "", "", 0, "VK_OEM_5"],
    Comma: [",", ";", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "\\", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/no.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000414", id: "", text: "Norwegian" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "\xB5", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["z", "Z", "", "", 0, "VK_Z"],
    Digit1: ["1", "!", "", "", 0, "VK_1"],
    Digit2: ["2", '"', "@", "", 0, "VK_2"],
    Digit3: ["3", "#", "\xA3", "", 0, "VK_3"],
    Digit4: ["4", "\xA4", "$", "", 0, "VK_4"],
    Digit5: ["5", "%", "\u20AC", "", 0, "VK_5"],
    Digit6: ["6", "&", "", "", 0, "VK_6"],
    Digit7: ["7", "/", "{", "", 0, "VK_7"],
    Digit8: ["8", "(", "[", "", 0, "VK_8"],
    Digit9: ["9", ")", "]", "", 0, "VK_9"],
    Digit0: ["0", "=", "}", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["+", "?", "", "", 0, "VK_OEM_PLUS"],
    Equal: ["\\", "`", "\xB4", "", 0, "VK_OEM_4"],
    BracketLeft: ["\xE5", "\xC5", "", "", 0, "VK_OEM_6"],
    BracketRight: ["\xA8", "^", "~", "", 0, "VK_OEM_1"],
    Backslash: ["'", "*", "", "", 0, "VK_OEM_2"],
    Semicolon: ["\xF8", "\xD8", "", "", 0, "VK_OEM_3"],
    Quote: ["\xE6", "\xC6", "", "", 0, "VK_OEM_7"],
    Backquote: ["|", "\xA7", "", "", 0, "VK_OEM_5"],
    Comma: [",", ";", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/thai.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "0000041E", id: "", text: "Thai Kedmanee" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["\u0E1F", "\u0E24", "", "", 0, "VK_A"],
    KeyB: ["\u0E34", "\u0E3A", "", "", 0, "VK_B"],
    KeyC: ["\u0E41", "\u0E09", "", "", 0, "VK_C"],
    KeyD: ["\u0E01", "\u0E0F", "", "", 0, "VK_D"],
    KeyE: ["\u0E33", "\u0E0E", "", "", 0, "VK_E"],
    KeyF: ["\u0E14", "\u0E42", "", "", 0, "VK_F"],
    KeyG: ["\u0E40", "\u0E0C", "", "", 0, "VK_G"],
    KeyH: ["\u0E49", "\u0E47", "", "", 0, "VK_H"],
    KeyI: ["\u0E23", "\u0E13", "", "", 0, "VK_I"],
    KeyJ: ["\u0E48", "\u0E4B", "", "", 0, "VK_J"],
    KeyK: ["\u0E32", "\u0E29", "", "", 0, "VK_K"],
    KeyL: ["\u0E2A", "\u0E28", "", "", 0, "VK_L"],
    KeyM: ["\u0E17", "?", "", "", 0, "VK_M"],
    KeyN: ["\u0E37", "\u0E4C", "", "", 0, "VK_N"],
    KeyO: ["\u0E19", "\u0E2F", "", "", 0, "VK_O"],
    KeyP: ["\u0E22", "\u0E0D", "", "", 0, "VK_P"],
    KeyQ: ["\u0E46", "\u0E50", "", "", 0, "VK_Q"],
    KeyR: ["\u0E1E", "\u0E11", "", "", 0, "VK_R"],
    KeyS: ["\u0E2B", "\u0E06", "", "", 0, "VK_S"],
    KeyT: ["\u0E30", "\u0E18", "", "", 0, "VK_T"],
    KeyU: ["\u0E35", "\u0E4A", "", "", 0, "VK_U"],
    KeyV: ["\u0E2D", "\u0E2E", "", "", 0, "VK_V"],
    KeyW: ["\u0E44", '"', "", "", 0, "VK_W"],
    KeyX: ["\u0E1B", ")", "", "", 0, "VK_X"],
    KeyY: ["\u0E31", "\u0E4D", "", "", 0, "VK_Y"],
    KeyZ: ["\u0E1C", "(", "", "", 0, "VK_Z"],
    Digit1: ["\u0E45", "+", "", "", 0, "VK_1"],
    Digit2: ["/", "\u0E51", "", "", 0, "VK_2"],
    Digit3: ["-", "\u0E52", "", "", 0, "VK_3"],
    Digit4: ["\u0E20", "\u0E53", "", "", 0, "VK_4"],
    Digit5: ["\u0E16", "\u0E54", "", "", 0, "VK_5"],
    Digit6: ["\u0E38", "\u0E39", "", "", 0, "VK_6"],
    Digit7: ["\u0E36", "\u0E3F", "", "", 0, "VK_7"],
    Digit8: ["\u0E04", "\u0E55", "", "", 0, "VK_8"],
    Digit9: ["\u0E15", "\u0E56", "", "", 0, "VK_9"],
    Digit0: ["\u0E08", "\u0E57", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["\u0E02", "\u0E58", "", "", 0, "VK_OEM_MINUS"],
    Equal: ["\u0E0A", "\u0E59", "", "", 0, "VK_OEM_PLUS"],
    BracketLeft: ["\u0E1A", "\u0E10", "", "", 0, "VK_OEM_4"],
    BracketRight: ["\u0E25", ",", "", "", 0, "VK_OEM_6"],
    Backslash: ["\u0E03", "\u0E05", "", "", 0, "VK_OEM_5"],
    Semicolon: ["\u0E27", "\u0E0B", "", "", 0, "VK_OEM_1"],
    Quote: ["\u0E07", ".", "", "", 0, "VK_OEM_7"],
    Backquote: ["_", "%", "", "", 0, "VK_OEM_3"],
    Comma: ["\u0E21", "\u0E12", "", "", 0, "VK_OEM_COMMA"],
    Period: ["\u0E43", "\u0E2C", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["\u0E1D", "\u0E26", "", "", 0, "VK_OEM_2"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["\u0E03", "\u0E05", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/hu.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "0000040E", id: "", text: "Hungarian" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "\xE4", "", 0, "VK_A"],
    KeyB: ["b", "B", "{", "", 0, "VK_B"],
    KeyC: ["c", "C", "&", "", 0, "VK_C"],
    KeyD: ["d", "D", "\u0110", "", 0, "VK_D"],
    KeyE: ["e", "E", "\xC4", "", 0, "VK_E"],
    KeyF: ["f", "F", "[", "", 0, "VK_F"],
    KeyG: ["g", "G", "]", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "\xCD", "", 0, "VK_I"],
    KeyJ: ["j", "J", "\xED", "", 0, "VK_J"],
    KeyK: ["k", "K", "\u0142", "", 0, "VK_K"],
    KeyL: ["l", "L", "\u0141", "", 0, "VK_L"],
    KeyM: ["m", "M", "<", "", 0, "VK_M"],
    KeyN: ["n", "N", "}", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "\\", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "\u0111", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "\u20AC", "", 0, "VK_U"],
    KeyV: ["v", "V", "@", "", 0, "VK_V"],
    KeyW: ["w", "W", "|", "", 0, "VK_W"],
    KeyX: ["x", "X", "#", "", 0, "VK_X"],
    KeyY: ["z", "Z", "", "", 0, "VK_Z"],
    KeyZ: ["y", "Y", ">", "", 0, "VK_Y"],
    Digit1: ["1", "'", "~", "", 0, "VK_1"],
    Digit2: ["2", '"', "\u02C7", "", 0, "VK_2"],
    Digit3: ["3", "+", "^", "", 0, "VK_3"],
    Digit4: ["4", "!", "\u02D8", "", 0, "VK_4"],
    Digit5: ["5", "%", "\xB0", "", 0, "VK_5"],
    Digit6: ["6", "/", "\u02DB", "", 0, "VK_6"],
    Digit7: ["7", "=", "`", "", 0, "VK_7"],
    Digit8: ["8", "(", "\u02D9", "", 0, "VK_8"],
    Digit9: ["9", ")", "\xB4", "", 0, "VK_9"],
    Digit0: ["\xF6", "\xD6", "\u02DD", "", 0, "VK_OEM_3"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["\xFC", "\xDC", "\xA8", "", 0, "VK_OEM_2"],
    Equal: ["\xF3", "\xD3", "\xB8", "", 0, "VK_OEM_PLUS"],
    BracketLeft: ["\u0151", "\u0150", "\xF7", "", 0, "VK_OEM_4"],
    BracketRight: ["\xFA", "\xDA", "\xD7", "", 0, "VK_OEM_6"],
    Backslash: ["\u0171", "\u0170", "\xA4", "", 0, "VK_OEM_5"],
    Semicolon: ["\xE9", "\xC9", "$", "", 0, "VK_OEM_1"],
    Quote: ["\xE1", "\xC1", "\xDF", "", 0, "VK_OEM_7"],
    Backquote: ["0", "\xA7", "", "", 0, "VK_0"],
    Comma: [",", "?", ";", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", ">", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "*", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["\xED", "\xCD", "<", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/de-swiss.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000807", id: "", text: "Swiss German" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["w", "W", "", "", 0, "VK_W"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["z", "Z", "", "", 0, "VK_Z"],
    KeyZ: ["y", "Y", "", "", 0, "VK_Y"],
    Digit1: ["1", "+", "\xA6", "", 0, "VK_1"],
    Digit2: ["2", '"', "@", "", 0, "VK_2"],
    Digit3: ["3", "*", "#", "", 0, "VK_3"],
    Digit4: ["4", "\xE7", "\xB0", "", 0, "VK_4"],
    Digit5: ["5", "%", "\xA7", "", 0, "VK_5"],
    Digit6: ["6", "&", "\xAC", "", 0, "VK_6"],
    Digit7: ["7", "/", "|", "", 0, "VK_7"],
    Digit8: ["8", "(", "\xA2", "", 0, "VK_8"],
    Digit9: ["9", ")", "", "", 0, "VK_9"],
    Digit0: ["0", "=", "", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["'", "?", "\xB4", "", 0, "VK_OEM_4"],
    Equal: ["^", "`", "~", "", 0, "VK_OEM_6"],
    BracketLeft: ["\xFC", "\xE8", "[", "", 0, "VK_OEM_1"],
    BracketRight: ["\xA8", "!", "]", "", 0, "VK_OEM_3"],
    Backslash: ["$", "\xA3", "}", "", 0, "VK_OEM_8"],
    Semicolon: ["\xF6", "\xE9", "", "", 0, "VK_OEM_7"],
    Quote: ["\xE4", "\xE0", "{", "", 0, "VK_OEM_5"],
    Backquote: ["\xA7", "\xB0", "", "", 0, "VK_OEM_2"],
    Comma: [",", ";", "", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", "", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "\\", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/en-belgian.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000813", id: "", text: "Belgian (Period)" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["q", "Q", "", "", 0, "VK_Q"],
    KeyB: ["b", "B", "", "", 0, "VK_B"],
    KeyC: ["c", "C", "", "", 0, "VK_C"],
    KeyD: ["d", "D", "", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "", "", 0, "VK_F"],
    KeyG: ["g", "G", "", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "", "", 0, "VK_K"],
    KeyL: ["l", "L", "", "", 0, "VK_L"],
    KeyM: [",", "?", "", "", 0, "VK_OEM_COMMA"],
    KeyN: ["n", "N", "", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["a", "A", "", "", 0, "VK_A"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "", "", 0, "VK_V"],
    KeyW: ["z", "Z", "", "", 0, "VK_Z"],
    KeyX: ["x", "X", "", "", 0, "VK_X"],
    KeyY: ["y", "Y", "", "", 0, "VK_Y"],
    KeyZ: ["w", "W", "", "", 0, "VK_W"],
    Digit1: ["&", "1", "|", "", 0, "VK_1"],
    Digit2: ["\xE9", "2", "@", "", 0, "VK_2"],
    Digit3: ['"', "3", "#", "", 0, "VK_3"],
    Digit4: ["'", "4", "{", "", 0, "VK_4"],
    Digit5: ["(", "5", "[", "", 0, "VK_5"],
    Digit6: ["\xA7", "6", "^", "", 0, "VK_6"],
    Digit7: ["\xE8", "7", "", "", 0, "VK_7"],
    Digit8: ["!", "8", "", "", 0, "VK_8"],
    Digit9: ["\xE7", "9", "{", "", 0, "VK_9"],
    Digit0: ["\xE0", "0", "}", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: [")", "\xB0", "", "", 0, "VK_OEM_4"],
    Equal: ["-", "_", "", "", 0, "VK_OEM_MINUS"],
    BracketLeft: ["^", "\xA8", "[", "", 0, "VK_OEM_6"],
    BracketRight: ["$", "*", "]", "", 0, "VK_OEM_1"],
    Backslash: ["\xB5", "\xA3", "`", "`", 0, "VK_OEM_5"],
    Semicolon: ["m", "M", "", "", 0, "VK_M"],
    Quote: ["\xF9", "%", "\xB4", "\xB4", 0, "VK_OEM_3"],
    Backquote: ["\xB2", "\xB3", "", "", 0, "VK_OEM_7"],
    Comma: [";", ".", "", "", 0, "VK_OEM_PERIOD"],
    Period: [":", "/", "", "", 0, "VK_OEM_2"],
    Slash: ["=", "+", "~", "~", 0, "VK_OEM_PLUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["<", ">", "\\", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});

// out-build/vs/workbench/services/keybinding/browser/keyboardLayouts/cz.win.js
$pKc.INSTANCE.registerKeyboardLayout({
  layout: { name: "00000405", id: "", text: "Czech" },
  secondaryLayouts: [],
  mapping: {
    Sleep: [],
    WakeUp: [],
    KeyA: ["a", "A", "", "", 0, "VK_A"],
    KeyB: ["b", "B", "{", "", 0, "VK_B"],
    KeyC: ["c", "C", "&", "", 0, "VK_C"],
    KeyD: ["d", "D", "\u0110", "", 0, "VK_D"],
    KeyE: ["e", "E", "\u20AC", "", 0, "VK_E"],
    KeyF: ["f", "F", "[", "", 0, "VK_F"],
    KeyG: ["g", "G", "]", "", 0, "VK_G"],
    KeyH: ["h", "H", "", "", 0, "VK_H"],
    KeyI: ["i", "I", "", "", 0, "VK_I"],
    KeyJ: ["j", "J", "", "", 0, "VK_J"],
    KeyK: ["k", "K", "\u0142", "", 0, "VK_K"],
    KeyL: ["l", "L", "\u0141", "", 0, "VK_L"],
    KeyM: ["m", "M", "", "", 0, "VK_M"],
    KeyN: ["n", "N", "}", "", 0, "VK_N"],
    KeyO: ["o", "O", "", "", 0, "VK_O"],
    KeyP: ["p", "P", "", "", 0, "VK_P"],
    KeyQ: ["q", "Q", "\\", "", 0, "VK_Q"],
    KeyR: ["r", "R", "", "", 0, "VK_R"],
    KeyS: ["s", "S", "\u0111", "", 0, "VK_S"],
    KeyT: ["t", "T", "", "", 0, "VK_T"],
    KeyU: ["u", "U", "", "", 0, "VK_U"],
    KeyV: ["v", "V", "@", "", 0, "VK_V"],
    KeyW: ["w", "W", "|", "", 0, "VK_W"],
    KeyX: ["x", "X", "#", "", 0, "VK_X"],
    KeyY: ["z", "Z", "", "", 0, "VK_Z"],
    KeyZ: ["y", "Y", "", "", 0, "VK_Y"],
    Digit1: ["+", "1", "~", "", 0, "VK_1"],
    Digit2: ["\u011B", "2", "\u02C7", "", 0, "VK_2"],
    Digit3: ["\u0161", "3", "^", "", 0, "VK_3"],
    Digit4: ["\u010D", "4", "\u02D8", "", 0, "VK_4"],
    Digit5: ["\u0159", "5", "\xB0", "", 0, "VK_5"],
    Digit6: ["\u017E", "6", "\u02DB", "", 0, "VK_6"],
    Digit7: ["\xFD", "7", "`", "", 0, "VK_7"],
    Digit8: ["\xE1", "8", "\u02D9", "", 0, "VK_8"],
    Digit9: ["\xED", "9", "\xB4", "", 0, "VK_9"],
    Digit0: ["\xE9", "0", "\u02DD", "", 0, "VK_0"],
    Enter: [],
    Escape: [],
    Backspace: [],
    Tab: [],
    Space: [" ", " ", "", "", 0, "VK_SPACE"],
    Minus: ["=", "%", "\xA8", "", 0, "VK_OEM_PLUS"],
    Equal: ["\xB4", "\u02C7", "\xB8", "", 0, "VK_OEM_2"],
    BracketLeft: ["\xFA", "/", "\xF7", "", 0, "VK_OEM_4"],
    BracketRight: [")", "(", "\xD7", "", 0, "VK_OEM_6"],
    Backslash: ["\xA8", "'", "\xA4", "", 0, "VK_OEM_5"],
    Semicolon: ["\u016F", '"', "$", "", 0, "VK_OEM_1"],
    Quote: ["\xA7", "!", "\xDF", "", 0, "VK_OEM_7"],
    Backquote: [";", "\xB0", "", "", 0, "VK_OEM_3"],
    Comma: [",", "?", "<", "", 0, "VK_OEM_COMMA"],
    Period: [".", ":", ">", "", 0, "VK_OEM_PERIOD"],
    Slash: ["-", "_", "*", "", 0, "VK_OEM_MINUS"],
    CapsLock: [],
    F1: [],
    F2: [],
    F3: [],
    F4: [],
    F5: [],
    F6: [],
    F7: [],
    F8: [],
    F9: [],
    F10: [],
    F11: [],
    F12: [],
    PrintScreen: [],
    ScrollLock: [],
    Pause: [],
    Insert: [],
    Home: [],
    PageUp: [],
    Delete: [],
    End: [],
    PageDown: [],
    ArrowRight: [],
    ArrowLeft: [],
    ArrowDown: [],
    ArrowUp: [],
    NumLock: [],
    NumpadDivide: ["/", "/", "", "", 0, "VK_DIVIDE"],
    NumpadMultiply: ["*", "*", "", "", 0, "VK_MULTIPLY"],
    NumpadSubtract: ["-", "-", "", "", 0, "VK_SUBTRACT"],
    NumpadAdd: ["+", "+", "", "", 0, "VK_ADD"],
    NumpadEnter: [],
    Numpad1: [],
    Numpad2: [],
    Numpad3: [],
    Numpad4: [],
    Numpad5: [],
    Numpad6: [],
    Numpad7: [],
    Numpad8: [],
    Numpad9: [],
    Numpad0: [],
    NumpadDecimal: [],
    IntlBackslash: ["\\", "|", "", "", 0, "VK_OEM_102"],
    ContextMenu: [],
    Power: [],
    NumpadEqual: [],
    F13: [],
    F14: [],
    F15: [],
    F16: [],
    F17: [],
    F18: [],
    F19: [],
    F20: [],
    F21: [],
    F22: [],
    F23: [],
    F24: [],
    Help: [],
    Undo: [],
    Cut: [],
    Copy: [],
    Paste: [],
    AudioVolumeMute: [],
    AudioVolumeUp: [],
    AudioVolumeDown: [],
    NumpadComma: [],
    IntlRo: [],
    KanaMode: [],
    IntlYen: [],
    Convert: [],
    NonConvert: [],
    Lang1: [],
    Lang2: [],
    Lang3: [],
    Lang4: [],
    ControlLeft: [],
    ShiftLeft: [],
    AltLeft: [],
    MetaLeft: [],
    ControlRight: [],
    ShiftRight: [],
    AltRight: [],
    MetaRight: [],
    MediaTrackNext: [],
    MediaTrackPrevious: [],
    MediaStop: [],
    Eject: [],
    MediaPlayPause: [],
    MediaSelect: [],
    LaunchMail: [],
    LaunchApp2: [],
    LaunchApp1: [],
    BrowserSearch: [],
    BrowserHome: [],
    BrowserBack: [],
    BrowserForward: [],
    BrowserStop: [],
    BrowserRefresh: [],
    BrowserFavorites: []
  }
});
export {
  $pKc as KeyboardLayoutContribution
};

//# sourceMappingURL=layout.contribution.win.js.map
