// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
// This `reason` comes from `AbortSignal` thus must be `any`.
// deno-lint-ignore no-explicit-any
export function createAbortError(reason) {
  return new DOMException(reason ? `Aborted: ${reason}` : "Aborted", "AbortError");
}
export function exponentialBackoffWithJitter(cap, base, attempt, multiplier, jitter) {
  const exp = Math.min(cap, base * multiplier ** attempt);
  return (1 - jitter * Math.random()) * exp;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vanNyLmlvL0BzdGQvYXN5bmMvMC4yMjQuMi9fdXRpbC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gVGhpcyBtb2R1bGUgaXMgYnJvd3NlciBjb21wYXRpYmxlLlxuXG4vLyBUaGlzIGByZWFzb25gIGNvbWVzIGZyb20gYEFib3J0U2lnbmFsYCB0aHVzIG11c3QgYmUgYGFueWAuXG4vLyBkZW5vLWxpbnQtaWdub3JlIG5vLWV4cGxpY2l0LWFueVxuZXhwb3J0IGZ1bmN0aW9uIGNyZWF0ZUFib3J0RXJyb3IocmVhc29uPzogYW55KTogRE9NRXhjZXB0aW9uIHtcbiAgcmV0dXJuIG5ldyBET01FeGNlcHRpb24oXG4gICAgcmVhc29uID8gYEFib3J0ZWQ6ICR7cmVhc29ufWAgOiBcIkFib3J0ZWRcIixcbiAgICBcIkFib3J0RXJyb3JcIixcbiAgKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGV4cG9uZW50aWFsQmFja29mZldpdGhKaXR0ZXIoXG4gIGNhcDogbnVtYmVyLFxuICBiYXNlOiBudW1iZXIsXG4gIGF0dGVtcHQ6IG51bWJlcixcbiAgbXVsdGlwbGllcjogbnVtYmVyLFxuICBqaXR0ZXI6IG51bWJlcixcbikge1xuICBjb25zdCBleHAgPSBNYXRoLm1pbihjYXAsIGJhc2UgKiBtdWx0aXBsaWVyICoqIGF0dGVtcHQpO1xuICByZXR1cm4gKDEgLSBqaXR0ZXIgKiBNYXRoLnJhbmRvbSgpKSAqIGV4cDtcbn1cbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwwRUFBMEU7QUFDMUUscUNBQXFDO0FBRXJDLDZEQUE2RDtBQUM3RCxtQ0FBbUM7QUFDbkMsT0FBTyxTQUFTLGlCQUFpQixNQUFZO0VBQzNDLE9BQU8sSUFBSSxhQUNULFNBQVMsQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLEdBQUcsV0FDaEM7QUFFSjtBQUVBLE9BQU8sU0FBUyw2QkFDZCxHQUFXLEVBQ1gsSUFBWSxFQUNaLE9BQWUsRUFDZixVQUFrQixFQUNsQixNQUFjO0VBRWQsTUFBTSxNQUFNLEtBQUssR0FBRyxDQUFDLEtBQUssT0FBTyxjQUFjO0VBQy9DLE9BQU8sQ0FBQyxJQUFJLFNBQVMsS0FBSyxNQUFNLEVBQUUsSUFBSTtBQUN4QyJ9