import { Endpoint } from "./Endpoint";
import { EndpointMode } from "./EndpointMode";
export const ENV_ENDPOINT_NAME = "AWS_EC2_METADATA_SERVICE_ENDPOINT";
export const CONFIG_ENDPOINT_NAME = "ec2_metadata_service_endpoint";
export const ENDPOINT_SELECTORS = {
    environmentVariableSelector: (env) => env[ENV_ENDPOINT_NAME],
    configFileSelector: (profile) => profile[CONFIG_ENDPOINT_NAME],
    default: Endpoint.IPv4,
};
export const ENV_ENDPOINT_MODE_NAME = "AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE";
export const CONFIG_ENDPOINT_MODE_NAME = "ec2_metadata_service_endpoint_mode";
export const ENDPOINT_MODE_SELECTORS = {
    environmentVariableSelector: (env) => env[ENV_ENDPOINT_MODE_NAME],
    configFileSelector: (profile) => profile[CONFIG_ENDPOINT_MODE_NAME],
    default: EndpointMode.IPv4,
};
export const AWS_EC2_METADATA_V1_DISABLED = "AWS_EC2_METADATA_V1_DISABLED";
export const PROFILE_AWS_EC2_METADATA_V1_DISABLED = "ec2_metadata_v1_disabled";
export const IMDSv1_DISABLED_SELECTORS = {
    environmentVariableSelector: (env) => env[AWS_EC2_METADATA_V1_DISABLED] ? env[AWS_EC2_METADATA_V1_DISABLED] !== "false" : undefined,
    configFileSelector: (profile) => profile[PROFILE_AWS_EC2_METADATA_V1_DISABLED]
        ? profile[PROFILE_AWS_EC2_METADATA_V1_DISABLED] !== "false"
        : undefined,
    default: false,
};
