// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
export const DEFAULT_CHUNK_SIZE = 16_640;
export const DEFAULT_BUFFER_SIZE = 32 * 1024;
/** Generate longest proper prefix which is also suffix array. */ export function createLPS(pat) {
  const length = pat.length;
  const lps = new Uint8Array(length);
  lps[0] = 0;
  let prefixEnd = 0;
  let i = 1;
  while(i < length){
    if (pat[i] === pat[prefixEnd]) {
      prefixEnd++;
      lps[i] = prefixEnd;
      i++;
    } else if (prefixEnd === 0) {
      lps[i] = 0;
      i++;
    } else {
      prefixEnd = lps[prefixEnd - 1];
    }
  }
  return lps;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vanNyLmlvL0BzdGQvc3RyZWFtcy8wLjIyNC41L19jb21tb24udHMiXSwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTgtMjAyNCB0aGUgRGVubyBhdXRob3JzLiBBbGwgcmlnaHRzIHJlc2VydmVkLiBNSVQgbGljZW5zZS5cbi8vIFRoaXMgbW9kdWxlIGlzIGJyb3dzZXIgY29tcGF0aWJsZS5cblxuZXhwb3J0IGNvbnN0IERFRkFVTFRfQ0hVTktfU0laRSA9IDE2XzY0MDtcbmV4cG9ydCBjb25zdCBERUZBVUxUX0JVRkZFUl9TSVpFID0gMzIgKiAxMDI0O1xuXG4vKiogR2VuZXJhdGUgbG9uZ2VzdCBwcm9wZXIgcHJlZml4IHdoaWNoIGlzIGFsc28gc3VmZml4IGFycmF5LiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGNyZWF0ZUxQUyhwYXQ6IFVpbnQ4QXJyYXkpOiBVaW50OEFycmF5IHtcbiAgY29uc3QgbGVuZ3RoID0gcGF0Lmxlbmd0aDtcbiAgY29uc3QgbHBzID0gbmV3IFVpbnQ4QXJyYXkobGVuZ3RoKTtcbiAgbHBzWzBdID0gMDtcbiAgbGV0IHByZWZpeEVuZCA9IDA7XG4gIGxldCBpID0gMTtcbiAgd2hpbGUgKGkgPCBsZW5ndGgpIHtcbiAgICBpZiAocGF0W2ldID09PSBwYXRbcHJlZml4RW5kXSkge1xuICAgICAgcHJlZml4RW5kKys7XG4gICAgICBscHNbaV0gPSBwcmVmaXhFbmQ7XG4gICAgICBpKys7XG4gICAgfSBlbHNlIGlmIChwcmVmaXhFbmQgPT09IDApIHtcbiAgICAgIGxwc1tpXSA9IDA7XG4gICAgICBpKys7XG4gICAgfSBlbHNlIHtcbiAgICAgIHByZWZpeEVuZCA9IGxwc1twcmVmaXhFbmQgLSAxXSE7XG4gICAgfVxuICB9XG4gIHJldHVybiBscHM7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLHFDQUFxQztBQUVyQyxPQUFPLE1BQU0scUJBQXFCLE9BQU87QUFDekMsT0FBTyxNQUFNLHNCQUFzQixLQUFLLEtBQUs7QUFFN0MsK0RBQStELEdBQy9ELE9BQU8sU0FBUyxVQUFVLEdBQWU7RUFDdkMsTUFBTSxTQUFTLElBQUksTUFBTTtFQUN6QixNQUFNLE1BQU0sSUFBSSxXQUFXO0VBQzNCLEdBQUcsQ0FBQyxFQUFFLEdBQUc7RUFDVCxJQUFJLFlBQVk7RUFDaEIsSUFBSSxJQUFJO0VBQ1IsTUFBTyxJQUFJLE9BQVE7SUFDakIsSUFBSSxHQUFHLENBQUMsRUFBRSxLQUFLLEdBQUcsQ0FBQyxVQUFVLEVBQUU7TUFDN0I7TUFDQSxHQUFHLENBQUMsRUFBRSxHQUFHO01BQ1Q7SUFDRixPQUFPLElBQUksY0FBYyxHQUFHO01BQzFCLEdBQUcsQ0FBQyxFQUFFLEdBQUc7TUFDVDtJQUNGLE9BQU87TUFDTCxZQUFZLEdBQUcsQ0FBQyxZQUFZLEVBQUU7SUFDaEM7RUFDRjtFQUNBLE9BQU87QUFDVCJ9