/* tslint:disable */
/* eslint-disable */
/**
 * Kallichore API
 * Kallichore is a Jupyter kernel gateway and supervisor
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: info@posit.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from './configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from './common';
import type { RequestArgs } from './base';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, BaseAPI, RequiredError, operationServerMap } from './base';

export interface ActiveSession {
    /**
     * A unique identifier for the session
     */
    'session_id': string;
    /**
     * The program and command-line parameters for the session
     */
    'argv': Array<string>;
    /**
     * The underlying process ID of the session, if the session is running.
     */
    'process_id'?: number;
    /**
     * The username of the user who owns the session
     */
    'username': string;
    /**
     * A human-readable name for the session
     */
    'display_name': string;
    /**
     * The interpreter language
     */
    'language': string;
    'interrupt_mode': InterruptMode;
    /**
     * The environment variables set when the session was started
     */
    'initial_env'?: { [key: string]: string; };
    /**
     * Whether the session is connected to a client
     */
    'connected': boolean;
    /**
     * An ISO 8601 timestamp of when the session was started
     */
    'started': string;
    'session_mode': SessionMode;
    /**
     * The session\'s current working directory
     */
    'working_directory': string;
    /**
     * For notebook sessions, the URI of the notebook file
     */
    'notebook_uri'?: string;
    /**
     * The text to use to prompt for input
     */
    'input_prompt': string;
    /**
     * The text to use to prompt for input continuations
     */
    'continuation_prompt': string;
    'execution_queue': ExecutionQueue;
    'status': Status;
    /**
     * The kernel information, as returned by the kernel_info_request message
     */
    'kernel_info': object;
    'resource_usage'?: ResourceUsage;
    /**
     * The number of seconds the session has been idle, or 0 if the session is busy
     */
    'idle_seconds': number;
    /**
     * The number of seconds the session has been busy, or 0 if the session is idle
     */
    'busy_seconds': number;
    /**
     * The path to the Unix domain socket used to send/receive data from the session, if applicable
     */
    'socket_path'?: string;
}


export interface ClientHeartbeat {
    /**
     * The process ID of the client sending the heartbeat
     */
    'process_id'?: number;
}
/**
 * Connection information for an existing session
 */
export interface ConnectionInfo {
    /**
     * The port for control messages
     */
    'control_port': number;
    /**
     * The port for shell messages
     */
    'shell_port': number;
    /**
     * The port for stdin messages
     */
    'stdin_port': number;
    /**
     * The port for heartbeat messages
     */
    'hb_port': number;
    /**
     * The port for IOPub messages
     */
    'iopub_port': number;
    /**
     * The signature scheme for messages
     */
    'signature_scheme': string;
    /**
     * The key for messages
     */
    'key': string;
    /**
     * The transport protocol
     */
    'transport': string;
    /**
     * The IP address for the connection
     */
    'ip': string;
}
/**
 * The execution queue for a session
 */
export interface ExecutionQueue {
    /**
     * The execution request currently being evaluated, if any
     */
    'active'?: object;
    /**
     * The number of items in the pending queue
     */
    'length': number;
    /**
     * The queue of pending execution requests
     */
    'pending': Array<object>;
}
/**
 * The mechansim for interrupting the session
 */

export const InterruptMode = {
    Signal: 'signal',
    Message: 'message'
} as const;

export type InterruptMode = typeof InterruptMode[keyof typeof InterruptMode];


export interface ModelError {
    'code': string;
    'message': string;
    'details'?: string;
}
export interface NewSession {
    /**
     * A unique identifier for the session
     */
    'session_id': string;
    /**
     * A human-readable name for the session
     */
    'display_name': string;
    /**
     * The interpreter language
     */
    'language': string;
    /**
     * The username of the user who owns the session
     */
    'username': string;
    /**
     * The text to use to prompt for input
     */
    'input_prompt': string;
    /**
     * The text to use to prompt for input continuations
     */
    'continuation_prompt': string;
    /**
     * The program and command-line parameters for the session
     */
    'argv': Array<string>;
    'session_mode': SessionMode;
    /**
     * The working directory in which to start the session.
     */
    'working_directory': string;
    /**
     * For notebook sessions, the URI of the notebook file
     */
    'notebook_uri'?: string;
    /**
     * A list of environment variable actions to perform
     */
    'env': Array<VarAction>;
    /**
     * The number of seconds to wait for a connection to the session\'s ZeroMQ sockets before timing out
     */
    'connection_timeout'?: number;
    'interrupt_mode': InterruptMode;
    /**
     * The Jupyter protocol version supported by the underlying kernel
     */
    'protocol_version'?: string;
    'startup_environment': StartupEnvironment;
    /**
     * The command or script to run before starting the session
     */
    'startup_environment_arg'?: string;
}


export interface NewSession200Response {
    /**
     * A unique identifier for the session
     */
    'session_id': string;
}
export interface ResourceUsage {
    /**
     * The percentage of CPU used by the kernel process and its child processes
     */
    'cpu_percent': number;
    /**
     * The amount of memory used by the kernel process and all of its child processes in bytes
     */
    'memory_bytes': number;
    /**
     * The total number of threads used by the kernel process and its child processes (Linux only)
     */
    'thread_count': number;
    /**
     * The sampling period in milliseconds over which the resource usage was measured
     */
    'sampling_period_ms': number;
    /**
     * A Unix timestamp in milliseconds indicating when the resource usage was sampled
     */
    'timestamp': number;
}
export interface RestartSession {
    /**
     * The desired working directory for the session after restart, if different from the session\'s working directory at startup
     */
    'working_directory'?: string;
    /**
     * A list of environment variable actions to perform
     */
    'env'?: Array<VarAction>;
}
export interface ServerConfiguration {
    /**
     * The number of hours the server will wait before shutting down idle sessions (-1 if idle shutdown is disabled)
     */
    'idle_shutdown_hours'?: number;
    /**
     * The interval in milliseconds at which resource usage is sampled. A value of 0 disables resource usage sampling.
     */
    'resource_sample_interval_ms'?: number;
    /**
     * The current log level
     */
    'log_level'?: ServerConfigurationLogLevelEnum;
}

export const ServerConfigurationLogLevelEnum = {
    Trace: 'trace',
    Debug: 'debug',
    Info: 'info',
    Warn: 'warn',
    Error: 'error'
} as const;

export type ServerConfigurationLogLevelEnum = typeof ServerConfigurationLogLevelEnum[keyof typeof ServerConfigurationLogLevelEnum];

export interface ServerStatus {
    'sessions': number;
    'active': number;
    'busy': boolean;
    /**
     * The number of seconds all sessions have been idle, or 0 if any session is busy
     */
    'idle_seconds': number;
    /**
     * The number of seconds any session has been busy, or 0 if all sessions are idle
     */
    'busy_seconds': number;
    /**
     * The number of seconds the server has been running
     */
    'uptime_seconds': number;
    /**
     * The version of the server
     */
    'version': string;
    /**
     * The server\'s operating system process identifier
     */
    'process_id': number;
    /**
     * An ISO 8601 timestamp of when the server was started
     */
    'started': string;
}
export interface SessionList {
    'total': number;
    'sessions': Array<ActiveSession>;
}
/**
 * The mode in which the session is running
 */

export const SessionMode = {
    Console: 'console',
    Notebook: 'notebook',
    Background: 'background'
} as const;

export type SessionMode = typeof SessionMode[keyof typeof SessionMode];


/**
 * The kernel\'s startup environment: \'none\' for normal startup, \'shell\' for a login shell, \'command\' for a preflight command, \'script\' to run a script. Only relevant on POSIX-like systems.
 */

export const StartupEnvironment = {
    None: 'none',
    Shell: 'shell',
    Command: 'command',
    Script: 'script'
} as const;

export type StartupEnvironment = typeof StartupEnvironment[keyof typeof StartupEnvironment];


export interface StartupError {
    /**
     * The exit code of the process, if it exited
     */
    'exit_code'?: number;
    /**
     * The output of the process (combined stdout and stderr) emitted during startup, if any
     */
    'output'?: string;
    'error': ModelError;
}
/**
 * The status of the session
 */

export const Status = {
    Uninitialized: 'uninitialized',
    Starting: 'starting',
    Ready: 'ready',
    Idle: 'idle',
    Busy: 'busy',
    Offline: 'offline',
    Exited: 'exited'
} as const;

export type Status = typeof Status[keyof typeof Status];


export interface VarAction {
    'action': VarActionType;
    /**
     * The name of the variable to act on
     */
    'name': string;
    /**
     * The value to replace, append, or prepend
     */
    'value': string;
}


/**
 * The type of action to perform on the environment variable
 */

export const VarActionType = {
    Replace: 'replace',
    Append: 'append',
    Prepend: 'prepend'
} as const;

export type VarActionType = typeof VarActionType[keyof typeof VarActionType];



/**
 * DefaultApi - axios parameter creator
 */
export const DefaultApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * 
         * @summary Adopt an existing session
         * @param {string} sessionId 
         * @param {ConnectionInfo} connectionInfo 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        adoptSession: async (sessionId: string, connectionInfo: ConnectionInfo, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('adoptSession', 'sessionId', sessionId)
            // verify required parameter 'connectionInfo' is not null or undefined
            assertParamExists('adoptSession', 'connectionInfo', connectionInfo)
            const localVarPath = `/sessions/{session_id}/adopt`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(connectionInfo, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Upgrade to a WebSocket or domain socket for channel communication
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        channelsUpgrade: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('channelsUpgrade', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/channels`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Notify the server that a client is connected
         * @param {ClientHeartbeat} clientHeartbeat 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        clientHeartbeat: async (clientHeartbeat: ClientHeartbeat, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'clientHeartbeat' is not null or undefined
            assertParamExists('clientHeartbeat', 'clientHeartbeat', clientHeartbeat)
            const localVarPath = `/client_heartbeat`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(clientHeartbeat, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Get Jupyter connection information for the session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        connectionInfo: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('connectionInfo', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/connection_info`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Delete session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteSession: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('deleteSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Get the server configuration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getServerConfiguration: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/server_configuration`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Get session details
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getSession: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('getSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Interrupt session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        interruptSession: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('interruptSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/interrupt`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Force quit session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        killSession: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('killSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/kill`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary List active sessions
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSessions: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/sessions`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Create a new session
         * @param {NewSession} newSession 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        newSession: async (newSession: NewSession, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'newSession' is not null or undefined
            assertParamExists('newSession', 'newSession', newSession)
            const localVarPath = `/sessions`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(newSession, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Restart a session
         * @param {string} sessionId 
         * @param {RestartSession} [restartSession] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        restartSession: async (sessionId: string, restartSession?: RestartSession, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('restartSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/restart`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(restartSession, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Get server status and information
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        serverStatus: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/status`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Change the server configuration
         * @param {ServerConfiguration} serverConfiguration 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        setServerConfiguration: async (serverConfiguration: ServerConfiguration, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'serverConfiguration' is not null or undefined
            assertParamExists('setServerConfiguration', 'serverConfiguration', serverConfiguration)
            const localVarPath = `/server_configuration`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(serverConfiguration, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Shut down all sessions and the server itself
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        shutdownServer: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/shutdown`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Start a session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        startSession: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('startSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/start`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * DefaultApi - functional programming interface
 */
export const DefaultApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = DefaultApiAxiosParamCreator(configuration)
    return {
        /**
         * 
         * @summary Adopt an existing session
         * @param {string} sessionId 
         * @param {ConnectionInfo} connectionInfo 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async adoptSession(sessionId: string, connectionInfo: ConnectionInfo, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.adoptSession(sessionId, connectionInfo, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.adoptSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Upgrade to a WebSocket or domain socket for channel communication
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async channelsUpgrade(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.channelsUpgrade(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.channelsUpgrade']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Notify the server that a client is connected
         * @param {ClientHeartbeat} clientHeartbeat 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async clientHeartbeat(clientHeartbeat: ClientHeartbeat, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.clientHeartbeat(clientHeartbeat, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.clientHeartbeat']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Get Jupyter connection information for the session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async connectionInfo(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ConnectionInfo>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.connectionInfo(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.connectionInfo']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Delete session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteSession(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteSession(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.deleteSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Get the server configuration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getServerConfiguration(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ServerConfiguration>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getServerConfiguration(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.getServerConfiguration']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Get session details
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getSession(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ActiveSession>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getSession(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.getSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Interrupt session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async interruptSession(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.interruptSession(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.interruptSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Force quit session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async killSession(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.killSession(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.killSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary List active sessions
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listSessions(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SessionList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listSessions(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.listSessions']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Create a new session
         * @param {NewSession} newSession 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async newSession(newSession: NewSession, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<NewSession200Response>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.newSession(newSession, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.newSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Restart a session
         * @param {string} sessionId 
         * @param {RestartSession} [restartSession] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async restartSession(sessionId: string, restartSession?: RestartSession, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.restartSession(sessionId, restartSession, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.restartSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Get server status and information
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async serverStatus(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ServerStatus>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.serverStatus(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.serverStatus']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Change the server configuration
         * @param {ServerConfiguration} serverConfiguration 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async setServerConfiguration(serverConfiguration: ServerConfiguration, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.setServerConfiguration(serverConfiguration, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.setServerConfiguration']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Shut down all sessions and the server itself
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async shutdownServer(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.shutdownServer(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.shutdownServer']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Start a session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async startSession(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.startSession(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.startSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * DefaultApi - factory interface
 */
export const DefaultApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = DefaultApiFp(configuration)
    return {
        /**
         * 
         * @summary Adopt an existing session
         * @param {string} sessionId 
         * @param {ConnectionInfo} connectionInfo 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        adoptSession(sessionId: string, connectionInfo: ConnectionInfo, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.adoptSession(sessionId, connectionInfo, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Upgrade to a WebSocket or domain socket for channel communication
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        channelsUpgrade(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.channelsUpgrade(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Notify the server that a client is connected
         * @param {ClientHeartbeat} clientHeartbeat 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        clientHeartbeat(clientHeartbeat: ClientHeartbeat, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.clientHeartbeat(clientHeartbeat, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Get Jupyter connection information for the session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        connectionInfo(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<ConnectionInfo> {
            return localVarFp.connectionInfo(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Delete session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteSession(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.deleteSession(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Get the server configuration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getServerConfiguration(options?: RawAxiosRequestConfig): AxiosPromise<ServerConfiguration> {
            return localVarFp.getServerConfiguration(options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Get session details
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getSession(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<ActiveSession> {
            return localVarFp.getSession(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Interrupt session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        interruptSession(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.interruptSession(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Force quit session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        killSession(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.killSession(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary List active sessions
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSessions(options?: RawAxiosRequestConfig): AxiosPromise<SessionList> {
            return localVarFp.listSessions(options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Create a new session
         * @param {NewSession} newSession 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        newSession(newSession: NewSession, options?: RawAxiosRequestConfig): AxiosPromise<NewSession200Response> {
            return localVarFp.newSession(newSession, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Restart a session
         * @param {string} sessionId 
         * @param {RestartSession} [restartSession] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        restartSession(sessionId: string, restartSession?: RestartSession, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.restartSession(sessionId, restartSession, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Get server status and information
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        serverStatus(options?: RawAxiosRequestConfig): AxiosPromise<ServerStatus> {
            return localVarFp.serverStatus(options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Change the server configuration
         * @param {ServerConfiguration} serverConfiguration 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        setServerConfiguration(serverConfiguration: ServerConfiguration, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.setServerConfiguration(serverConfiguration, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Shut down all sessions and the server itself
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        shutdownServer(options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.shutdownServer(options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Start a session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        startSession(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.startSession(sessionId, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * DefaultApi - object-oriented interface
 */
export class DefaultApi extends BaseAPI {
    /**
     * 
     * @summary Adopt an existing session
     * @param {string} sessionId 
     * @param {ConnectionInfo} connectionInfo 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public adoptSession(sessionId: string, connectionInfo: ConnectionInfo, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).adoptSession(sessionId, connectionInfo, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Upgrade to a WebSocket or domain socket for channel communication
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public channelsUpgrade(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).channelsUpgrade(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Notify the server that a client is connected
     * @param {ClientHeartbeat} clientHeartbeat 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public clientHeartbeat(clientHeartbeat: ClientHeartbeat, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).clientHeartbeat(clientHeartbeat, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Get Jupyter connection information for the session
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public connectionInfo(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).connectionInfo(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Delete session
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public deleteSession(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).deleteSession(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Get the server configuration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public getServerConfiguration(options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).getServerConfiguration(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Get session details
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public getSession(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).getSession(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Interrupt session
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public interruptSession(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).interruptSession(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Force quit session
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public killSession(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).killSession(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary List active sessions
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public listSessions(options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).listSessions(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Create a new session
     * @param {NewSession} newSession 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public newSession(newSession: NewSession, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).newSession(newSession, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Restart a session
     * @param {string} sessionId 
     * @param {RestartSession} [restartSession] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public restartSession(sessionId: string, restartSession?: RestartSession, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).restartSession(sessionId, restartSession, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Get server status and information
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public serverStatus(options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).serverStatus(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Change the server configuration
     * @param {ServerConfiguration} serverConfiguration 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public setServerConfiguration(serverConfiguration: ServerConfiguration, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).setServerConfiguration(serverConfiguration, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Shut down all sessions and the server itself
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public shutdownServer(options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).shutdownServer(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Start a session
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public startSession(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).startSession(sessionId, options).then((request) => request(this.axios, this.basePath));
    }
}



