// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
export function consumeToken(v) {
  const notPos = indexOf(v, isNotTokenChar);
  if (notPos === -1) {
    return [
      v,
      ""
    ];
  }
  if (notPos === 0) {
    return [
      "",
      v
    ];
  }
  return [
    v.slice(0, notPos),
    v.slice(notPos)
  ];
}
export function consumeValue(v) {
  if (!v) {
    return [
      "",
      v
    ];
  }
  if (v[0] !== `"`) {
    return consumeToken(v);
  }
  let value = "";
  for(let i = 1; i < v.length; i++){
    const r = v[i];
    if (r === `"`) {
      return [
        value,
        v.slice(i + 1)
      ];
    }
    const next = v[i + 1];
    if (r === "\\" && typeof next === "string" && isTSpecial(next)) {
      value += next;
      i++;
      continue;
    }
    if (r === "\r" || r === "\n") {
      return [
        "",
        v
      ];
    }
    value += v[i];
  }
  return [
    "",
    v
  ];
}
export function consumeMediaParam(v) {
  let rest = v.trimStart();
  if (!rest.startsWith(";")) {
    return [
      "",
      "",
      v
    ];
  }
  rest = rest.slice(1);
  rest = rest.trimStart();
  let param;
  [param, rest] = consumeToken(rest);
  param = param.toLowerCase();
  if (!param) {
    return [
      "",
      "",
      v
    ];
  }
  rest = rest.slice(1);
  rest = rest.trimStart();
  const [value, rest2] = consumeValue(rest);
  if (value === "" && rest2 === rest) {
    return [
      "",
      "",
      v
    ];
  }
  rest = rest2;
  return [
    param,
    value,
    rest
  ];
}
export function decode2331Encoding(v) {
  const sv = v.split(`'`, 3);
  if (sv.length !== 3) {
    return undefined;
  }
  const [sv0, , sv2] = sv;
  const charset = sv0.toLowerCase();
  if (!charset) {
    return undefined;
  }
  if (charset !== "us-ascii" && charset !== "utf-8") {
    return undefined;
  }
  const encv = decodeURI(sv2);
  if (!encv) {
    return undefined;
  }
  return encv;
}
function indexOf(s, fn) {
  let i = -1;
  for (const v of s){
    i++;
    if (fn(v)) {
      return i;
    }
  }
  return -1;
}
export function isIterator(obj) {
  if (obj === null || obj === undefined) {
    return false;
  }
  // deno-lint-ignore no-explicit-any
  return typeof obj[Symbol.iterator] === "function";
}
export function isToken(s) {
  if (!s) {
    return false;
  }
  return indexOf(s, isNotTokenChar) < 0;
}
function isNotTokenChar(r) {
  return !isTokenChar(r);
}
function isTokenChar(r) {
  const code = r.charCodeAt(0);
  return code > 0x20 && code < 0x7f && !isTSpecial(r);
}
export function isTSpecial(r) {
  return r[0] ? `()<>@,;:\\"/[]?=`.includes(r[0]) : false;
}
const CHAR_CODE_SPACE = " ".charCodeAt(0);
const CHAR_CODE_TILDE = "~".charCodeAt(0);
export function needsEncoding(s) {
  for (const b of s){
    const charCode = b.charCodeAt(0);
    if ((charCode < CHAR_CODE_SPACE || charCode > CHAR_CODE_TILDE) && b !== "\t") {
      return true;
    }
  }
  return false;
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=16989476407078447811,3132274078149217865