import * as v1 from "./v1.ts";
import * as v4 from "./v4.ts";
import * as v5 from "./v5.ts";
export const NIL_UUID = "00000000-0000-0000-0000-000000000000";
export function isNil(id) {
    return id === NIL_UUID;
}
export function validate(uuid) {
    return /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i
        .test(uuid);
}
export function version(uuid) {
    if (!validate(uuid)) {
        throw TypeError("Invalid UUID");
    }
    return parseInt(uuid[14], 16);
}
export { v1, v4, v5 };
//# sourceMappingURL=data:application/json;base64,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