export var Status;
(function (Status) {
    Status[Status["Continue"] = 100] = "Continue";
    Status[Status["SwitchingProtocols"] = 101] = "SwitchingProtocols";
    Status[Status["Processing"] = 102] = "Processing";
    Status[Status["EarlyHints"] = 103] = "EarlyHints";
    Status[Status["OK"] = 200] = "OK";
    Status[Status["Created"] = 201] = "Created";
    Status[Status["Accepted"] = 202] = "Accepted";
    Status[Status["NonAuthoritativeInfo"] = 203] = "NonAuthoritativeInfo";
    Status[Status["NoContent"] = 204] = "NoContent";
    Status[Status["ResetContent"] = 205] = "ResetContent";
    Status[Status["PartialContent"] = 206] = "PartialContent";
    Status[Status["MultiStatus"] = 207] = "MultiStatus";
    Status[Status["AlreadyReported"] = 208] = "AlreadyReported";
    Status[Status["IMUsed"] = 226] = "IMUsed";
    Status[Status["MultipleChoices"] = 300] = "MultipleChoices";
    Status[Status["MovedPermanently"] = 301] = "MovedPermanently";
    Status[Status["Found"] = 302] = "Found";
    Status[Status["SeeOther"] = 303] = "SeeOther";
    Status[Status["NotModified"] = 304] = "NotModified";
    Status[Status["UseProxy"] = 305] = "UseProxy";
    Status[Status["TemporaryRedirect"] = 307] = "TemporaryRedirect";
    Status[Status["PermanentRedirect"] = 308] = "PermanentRedirect";
    Status[Status["BadRequest"] = 400] = "BadRequest";
    Status[Status["Unauthorized"] = 401] = "Unauthorized";
    Status[Status["PaymentRequired"] = 402] = "PaymentRequired";
    Status[Status["Forbidden"] = 403] = "Forbidden";
    Status[Status["NotFound"] = 404] = "NotFound";
    Status[Status["MethodNotAllowed"] = 405] = "MethodNotAllowed";
    Status[Status["NotAcceptable"] = 406] = "NotAcceptable";
    Status[Status["ProxyAuthRequired"] = 407] = "ProxyAuthRequired";
    Status[Status["RequestTimeout"] = 408] = "RequestTimeout";
    Status[Status["Conflict"] = 409] = "Conflict";
    Status[Status["Gone"] = 410] = "Gone";
    Status[Status["LengthRequired"] = 411] = "LengthRequired";
    Status[Status["PreconditionFailed"] = 412] = "PreconditionFailed";
    Status[Status["RequestEntityTooLarge"] = 413] = "RequestEntityTooLarge";
    Status[Status["RequestURITooLong"] = 414] = "RequestURITooLong";
    Status[Status["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
    Status[Status["RequestedRangeNotSatisfiable"] = 416] = "RequestedRangeNotSatisfiable";
    Status[Status["ExpectationFailed"] = 417] = "ExpectationFailed";
    Status[Status["Teapot"] = 418] = "Teapot";
    Status[Status["MisdirectedRequest"] = 421] = "MisdirectedRequest";
    Status[Status["UnprocessableEntity"] = 422] = "UnprocessableEntity";
    Status[Status["Locked"] = 423] = "Locked";
    Status[Status["FailedDependency"] = 424] = "FailedDependency";
    Status[Status["TooEarly"] = 425] = "TooEarly";
    Status[Status["UpgradeRequired"] = 426] = "UpgradeRequired";
    Status[Status["PreconditionRequired"] = 428] = "PreconditionRequired";
    Status[Status["TooManyRequests"] = 429] = "TooManyRequests";
    Status[Status["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
    Status[Status["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
    Status[Status["InternalServerError"] = 500] = "InternalServerError";
    Status[Status["NotImplemented"] = 501] = "NotImplemented";
    Status[Status["BadGateway"] = 502] = "BadGateway";
    Status[Status["ServiceUnavailable"] = 503] = "ServiceUnavailable";
    Status[Status["GatewayTimeout"] = 504] = "GatewayTimeout";
    Status[Status["HTTPVersionNotSupported"] = 505] = "HTTPVersionNotSupported";
    Status[Status["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
    Status[Status["InsufficientStorage"] = 507] = "InsufficientStorage";
    Status[Status["LoopDetected"] = 508] = "LoopDetected";
    Status[Status["NotExtended"] = 510] = "NotExtended";
    Status[Status["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(Status || (Status = {}));
export const STATUS_TEXT = new Map([
    [Status.Continue, "Continue"],
    [Status.SwitchingProtocols, "Switching Protocols"],
    [Status.Processing, "Processing"],
    [Status.EarlyHints, "Early Hints"],
    [Status.OK, "OK"],
    [Status.Created, "Created"],
    [Status.Accepted, "Accepted"],
    [Status.NonAuthoritativeInfo, "Non-Authoritative Information"],
    [Status.NoContent, "No Content"],
    [Status.ResetContent, "Reset Content"],
    [Status.PartialContent, "Partial Content"],
    [Status.MultiStatus, "Multi-Status"],
    [Status.AlreadyReported, "Already Reported"],
    [Status.IMUsed, "IM Used"],
    [Status.MultipleChoices, "Multiple Choices"],
    [Status.MovedPermanently, "Moved Permanently"],
    [Status.Found, "Found"],
    [Status.SeeOther, "See Other"],
    [Status.NotModified, "Not Modified"],
    [Status.UseProxy, "Use Proxy"],
    [Status.TemporaryRedirect, "Temporary Redirect"],
    [Status.PermanentRedirect, "Permanent Redirect"],
    [Status.BadRequest, "Bad Request"],
    [Status.Unauthorized, "Unauthorized"],
    [Status.PaymentRequired, "Payment Required"],
    [Status.Forbidden, "Forbidden"],
    [Status.NotFound, "Not Found"],
    [Status.MethodNotAllowed, "Method Not Allowed"],
    [Status.NotAcceptable, "Not Acceptable"],
    [Status.ProxyAuthRequired, "Proxy Authentication Required"],
    [Status.RequestTimeout, "Request Timeout"],
    [Status.Conflict, "Conflict"],
    [Status.Gone, "Gone"],
    [Status.LengthRequired, "Length Required"],
    [Status.PreconditionFailed, "Precondition Failed"],
    [Status.RequestEntityTooLarge, "Request Entity Too Large"],
    [Status.RequestURITooLong, "Request URI Too Long"],
    [Status.UnsupportedMediaType, "Unsupported Media Type"],
    [Status.RequestedRangeNotSatisfiable, "Requested Range Not Satisfiable"],
    [Status.ExpectationFailed, "Expectation Failed"],
    [Status.Teapot, "I'm a teapot"],
    [Status.MisdirectedRequest, "Misdirected Request"],
    [Status.UnprocessableEntity, "Unprocessable Entity"],
    [Status.Locked, "Locked"],
    [Status.FailedDependency, "Failed Dependency"],
    [Status.TooEarly, "Too Early"],
    [Status.UpgradeRequired, "Upgrade Required"],
    [Status.PreconditionRequired, "Precondition Required"],
    [Status.TooManyRequests, "Too Many Requests"],
    [Status.RequestHeaderFieldsTooLarge, "Request Header Fields Too Large"],
    [Status.UnavailableForLegalReasons, "Unavailable For Legal Reasons"],
    [Status.InternalServerError, "Internal Server Error"],
    [Status.NotImplemented, "Not Implemented"],
    [Status.BadGateway, "Bad Gateway"],
    [Status.ServiceUnavailable, "Service Unavailable"],
    [Status.GatewayTimeout, "Gateway Timeout"],
    [Status.HTTPVersionNotSupported, "HTTP Version Not Supported"],
    [Status.VariantAlsoNegotiates, "Variant Also Negotiates"],
    [Status.InsufficientStorage, "Insufficient Storage"],
    [Status.LoopDetected, "Loop Detected"],
    [Status.NotExtended, "Not Extended"],
    [Status.NetworkAuthenticationRequired, "Network Authentication Required"],
]);
//# sourceMappingURL=data:application/json;base64,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