import { descend } from "./_comparators.ts";
export * from "./_comparators.ts";
function swap(array, a, b) {
    const temp = array[a];
    array[a] = array[b];
    array[b] = temp;
}
export class BinaryHeap {
    compare;
    data = [];
    constructor(compare = descend) {
        this.compare = compare;
    }
    static from(collection, options) {
        let result;
        let unmappedValues = [];
        if (collection instanceof BinaryHeap) {
            result = new BinaryHeap(options?.compare ?? collection.compare);
            if (options?.compare || options?.map) {
                unmappedValues = collection.data;
            }
            else {
                result.data = Array.from(collection.data);
            }
        }
        else {
            result = options?.compare
                ? new BinaryHeap(options.compare)
                : new BinaryHeap();
            unmappedValues = collection;
        }
        const values = options?.map
            ? Array.from(unmappedValues, options.map, options.thisArg)
            : unmappedValues;
        result.push(...values);
        return result;
    }
    get length() {
        return this.data.length;
    }
    peek() {
        return this.data[0];
    }
    pop() {
        const size = this.data.length - 1;
        swap(this.data, 0, size);
        let parent = 0;
        let right = 2 * (parent + 1);
        let left = right - 1;
        while (left < size) {
            if (this.compare(this.data[left], this.data[parent]) < 0 &&
                (right === size || this.compare(this.data[left], this.data[right]) < 0)) {
                swap(this.data, parent, left);
                parent = left;
            }
            else if (right < size && this.compare(this.data[right], this.data[parent]) < 0) {
                swap(this.data, parent, right);
                parent = right;
            }
            else {
                break;
            }
            right = 2 * (parent + 1);
            left = right - 1;
        }
        return this.data.pop();
    }
    push(...values) {
        for (const value of values) {
            let index = this.data.length;
            let parent = Math.floor(index / 2);
            this.data.push(value);
            while (index !== 0 && this.compare(this.data[index], this.data[parent]) < 0) {
                swap(this.data, parent, index);
                index = parent;
                parent = Math.floor(index / 2);
            }
        }
        return this.data.length;
    }
    clear() {
        this.data = [];
    }
    isEmpty() {
        return this.data.length === 0;
    }
    *drain() {
        while (!this.isEmpty()) {
            yield this.pop();
        }
    }
    *[Symbol.iterator]() {
        yield* this.drain();
    }
}
//# sourceMappingURL=data:application/json;base64,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