"use strict";
/*
 * index.ts
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getApi = getApi;
exports.handleOnBrowse = handleOnBrowse;
exports.validateState = validateState;
exports.run = run;
const tom_select_1 = __importDefault(require("tom-select"));
const credentials_1 = require("./credentials");
const interface_1 = require("./interface");
const languages_1 = require("./languages");
// TODO: Revert this to add back in animation
// The original implementation used explicit heights to animate the expand/collapse action.
// The specific styles were interferring with the custom select, so for now we have commented
// it out until we can find a better solution.
function sizeToContent(_el, _immediate = false, _trim = 0) {
    // if (!el) { return; }
    // const range = new Range();
    // range.selectNodeContents(el);
    // el.style.transition = immediate ? '' : 'height 500ms var(--ease-out)';
    // el.style.height = `${range.getBoundingClientRect().height + trim}px`;
    // el.style.boxSizing = 'content-box';
    // el.style.overflowY = 'hidden';
    // range.detach();
}
// TODO: Revert this to add back in animation
function resetSize(_el) {
    // if (!el) { return; }
    // el.style.transition = '';
    // el.style.height = '';
    // el.style.boxSizing = '';
}
// message ID for postMessage association
let mid = 0;
// convert to our own version of the WebviewApi for explicit events
let api;
function getApi() {
    if (!api) {
        api = acquireVsCodeApi();
    }
    return api;
}
function handleOnBrowse(directory = false, callback) {
    const vscode = getApi();
    const messageId = ++mid;
    const browseListener = (event) => {
        const { type, id, message } = event.data;
        // message id must match, otherwise this may have come from a
        // different browse_path event (unlikely)
        if (type !== "browse_path" || id !== messageId) {
            return;
        }
        window.removeEventListener("message", browseListener);
        if (!message) {
            return;
        }
        callback(event);
    };
    window.addEventListener("message", browseListener);
    vscode.postMessage({ event: "browse_path", id: messageId, directory });
}
function validateState(state) {
    var _a, _b;
    return !!(((_a = state.launchSpec) === null || _a === void 0 ? void 0 : _a.name) && (0, languages_1.validScriptExtension)(((_b = state.jobOptions) === null || _b === void 0 ? void 0 : _b.script) || ""));
}
function getSelectedCluster(launchSpec) {
    if (!launchSpec) {
        return;
    }
    const clusterName = launchSpec.cluster;
    let resourceId;
    if (launchSpec.container_image.length > 0) {
        resourceId = launchSpec.container_image;
    }
    else if (launchSpec.queues.length > 0) {
        resourceId = launchSpec.queues[0];
    }
    else {
        resourceId = null;
    }
    if (clusterName) {
        return { clusterName, resourceId };
    }
}
function run() {
    const vscode = getApi();
    const viewState = vscode.getState() || {};
    // ---- Create and wire up the launcher ----
    const launcherUiEl = document.getElementById("launcher-ui");
    const mainEl = document.getElementById("main");
    const startButton = document.getElementById("submit");
    const workbenches = ["RStudio"];
    try {
        const launcherInput = Object.assign(Object.assign({ default_names: workbenches.map((workbench) => `${workbench} Job`), show_clusters: ShowClusterType.NonInteractive, show_workbenches: false, workbenches }, viewState.input), { launch_spec: viewState.launchSpec || null });
        viewState.input = launcherInput;
        const launcherUiOptions = Object.assign(Object.assign(Object.assign({}, interface_1.DEFAULT_LAUNCHER_UI_OPTIONS), { job_name_label: "Job Name", job_name_placeholder: "New Job", table_layout: true }), viewState.uiOptions);
        viewState.uiOptions = launcherUiOptions;
        const launcher = new LauncherUI(launcherUiEl, () => {
            return new Promise((resolve) => {
                const infoListener = (event) => {
                    const { type, message } = event.data;
                    if (type !== "get_info") {
                        return;
                    }
                    // only want this to trigger once, so remove it once
                    // we receive the info that we requested
                    window.removeEventListener("message", infoListener);
                    resolve(message);
                };
                window.addEventListener("message", infoListener);
                vscode.postMessage({ event: "get_info" });
            });
        }, launcherInput, launcherUiOptions);
        const saveState = () => {
            viewState.launchSpec = launcher.getLaunchSpec();
            viewState.jobOptions = Object.assign({}, jobOptions);
            viewState.userModified = Object.assign({}, userModified);
            viewState.outputArgs = outputArgs.map((args) => args.map((arg) => {
                return Object.assign({}, arg);
            }));
            showPathWarning();
            vscode.setState(Object.assign({}, viewState));
            const valid = validateState(viewState);
            startButton.classList.toggle("disabled", !valid);
            return valid;
        };
        let lastSelected;
        launcher.setOnLaunchSpecModified((spec) => {
            // We want to only call this when the selected cluster changes
            const selected = getSelectedCluster(spec);
            if ((lastSelected === null || lastSelected === void 0 ? void 0 : lastSelected.clusterName) !== (selected === null || selected === void 0 ? void 0 : selected.clusterName) || (lastSelected === null || lastSelected === void 0 ? void 0 : lastSelected.resourceId) !== (selected === null || selected === void 0 ? void 0 : selected.resourceId)) {
                setCurrentScript(jobOptions.script);
            }
            lastSelected = selected;
            sizeToContent(launcherUiEl);
            saveState();
        });
        launcher.setOnUiRender(() => {
            var _a;
            resetSize(launcherUiEl);
            sizeToContent(launcherUiEl, true);
            // hack in the default name if the user has already changed it
            if ((_a = launcherInput.launch_spec) === null || _a === void 0 ? void 0 : _a.name) {
                launcher.setJobName(launcherInput.launch_spec.name);
                // just setting the job name won't trigger a save -- have to trigger it manually
                saveState();
            }
            setCurrentScript(jobOptions.script);
            // Add a keydown handler that prevents the form element from submitting itself (Enter key).
            // We don't want to allow this in this UI, which only allows submission through a direct
            // interaction with the submit button
            const formEl = launcherUiEl.querySelector("form.form-horizontal");
            formEl.addEventListener("keydown", (evt) => {
                if (evt.key === "Enter") {
                    evt.preventDefault();
                }
            });
            // add an event listener to the job name field so that we can store it's state immediately
            // following any user changes to it.
            const jobNameEl = launcherUiEl.querySelector("#rstudio_label_job_name");
            jobNameEl.addEventListener("change", () => {
                saveState();
            });
        });
        launcher.initialize();
        // ---- Wire up the other fields ----
        const activeFileInit = document.head.querySelector('meta[name="active-file"]').getAttribute("content");
        const outputArgs = viewState.outputArgs || [];
        const jobOptions = Object.assign({ script: (0, languages_1.validScriptExtension)(activeFileInit || "") ? activeFileInit : "", workDir: "", args: [] }, viewState.jobOptions);
        const userModified = Object.assign({}, viewState.userModified);
        const scriptOptionsEl = document.getElementById("script-options");
        resetSize(scriptOptionsEl);
        sizeToContent(scriptOptionsEl, true, -4);
        const showPathWarning = () => {
            var _a, _b, _c;
            // id comes from a placeholder added by version selector builder
            const warningEl = document.getElementById("version-path-warning");
            // if there is no version selector available, then bail immediately
            if (!warningEl) {
                return;
            }
            // show a path warning if the cluster is set to non-local and the user
            // selects an R version that is anything other than (System Default)
            // TODO: compare image name of the current k8s session (if applicable) for improved
            // warning accuracy, as the IDE does. Right now we don't have access to this information
            const version = ((_a = outputArgs.flat().find((arg) => { var _a; return (_a = arg.name) === null || _a === void 0 ? void 0 : _a.endsWith("-version"); })) === null || _a === void 0 ? void 0 : _a.value) || "(System Default)";
            if (((_b = viewState.launchSpec) === null || _b === void 0 ? void 0 : _b.cluster) !== "Local" && version !== "(System Default)") {
                warningEl.textContent = `Ensure version selection "${version}" exists in "${(_c = viewState.launchSpec) === null || _c === void 0 ? void 0 : _c.cluster}"`;
                warningEl.style.display = "";
            }
            else {
                warningEl.style.display = "none";
            }
            sizeToContent(scriptOptionsEl, false, -4);
        };
        const setCurrentScript = (path = "New Workbench Job") => {
            var _a, _b;
            if (!(0, languages_1.validScriptExtension)(path)) {
                return;
            }
            // only auto-update the name if the user has not modified it
            if (!((_a = viewState.launchSpec) === null || _a === void 0 ? void 0 : _a.name) || ((_b = viewState.launchSpec) === null || _b === void 0 ? void 0 : _b.name) === launcherInput.default_names[0]) {
                launcher.setJobName((0, languages_1.getScriptName)(path));
            }
            scriptPathInputEl.textContent = path;
            scriptPathInputEl.dispatchEvent(new Event("change"));
            const currentLanguage = (0, languages_1.detectFileType)(jobOptions.script);
            jobOptions.script = path;
            saveState();
            const language = (0, languages_1.detectFileType)(path);
            // clear args if it is a different language type
            if ((currentLanguage === null || currentLanguage === void 0 ? void 0 : currentLanguage.ext) !== (language === null || language === void 0 ? void 0 : language.ext)) {
                outputArgs.splice(0);
                jobOptions.args = [];
            }
            scriptPathInputEl.dataset.lang = (language === null || language === void 0 ? void 0 : language.ext) || "";
            const gridFormEl = document.getElementById("form-grid");
            const separatorEl = document.getElementById("arg-list");
            (0, languages_1.clearAfter)(gridFormEl, separatorEl);
            // unrecognized languages should not display r-version selector
            // or generic arguments list. Still resize in case there was
            // previously content which affected the height of the container
            if (!language) {
                sizeToContent(scriptOptionsEl, false, -4);
                return;
            }
            const messageId = ++mid;
            const scriptInfoListener = (event) => {
                const { type, id, message } = event.data;
                // message id must match, otherwise this may have come from a
                // different get_info_for_script event (unlikely)
                if (type !== "get_info_for_script" || id !== messageId) {
                    return;
                }
                window.removeEventListener("message", scriptInfoListener);
                let versionArgs = [];
                let scriptArgs = [];
                if (message) {
                    try {
                        const args = JSON.parse(message);
                        if (args.versionInfo) {
                            versionArgs = args.versionInfo;
                        }
                        if (args.scriptArgs) {
                            scriptArgs = args.scriptArgs;
                        }
                        if (!userModified.workDir && typeof args.workingDirectory === "string") {
                            jobOptions.workDir = args.workingDirectory;
                            workdirPathInputEl.textContent = jobOptions.workDir;
                        }
                    }
                    catch (_) {
                        /* do nothing */
                    }
                }
                const valuesOnly = (args) => {
                    return args.map((arg) => {
                        return { value: `${(arg.name || "").trim()} ${(arg.value || "").trim()}`.trim() };
                    });
                };
                (0, languages_1.clearAfter)(gridFormEl, separatorEl);
                // defaults can be modified by the render functions
                // to strip out already-consumed arguments
                const defaultArgs = [versionArgs.slice(), valuesOnly(scriptArgs)];
                for (let a = 0; a < language.controls.length; a++) {
                    const control = language.controls[a];
                    HTMLElement.prototype.append.apply(gridFormEl, control.render({
                        currents: (outputArgs[a] || defaultArgs[a]).map((arg) => {
                            return Object.assign({}, arg);
                        }),
                        defaults: defaultArgs[a],
                        set: (args) => {
                            outputArgs[a] = args;
                            jobOptions.args = outputArgs.flat();
                            sizeToContent(scriptOptionsEl, false, -4);
                            saveState();
                        }
                    }));
                    document.querySelectorAll("#py-version-selector,#r-version-selector").forEach((el) => {
                        var _a, _b;
                        const runtimes = JSON.parse(el.dataset.runtimes);
                        const options = runtimes
                            .map((runtime) => ({
                            text: runtime.displayName,
                            value: runtime.runtimeId,
                            runtime: runtime
                        }))
                            .concat({
                            text: "Other...",
                            value: "Other...",
                            runtime: undefined
                        });
                        if (!el.dataset.tomselectInitialized) {
                            new tom_select_1.default(el, {
                                options,
                                // It is guaranteed there exists at least one item, since we always
                                // concat `Other...`, but there should be a (System Default) as well.
                                items: [(_b = (_a = options.find((option) => { var _a; return (_a = option.runtime) === null || _a === void 0 ? void 0 : _a.current; })) === null || _a === void 0 ? void 0 : _a.value) !== null && _b !== void 0 ? _b : options[0].value],
                                // Trigger a change event. This is confusing, but `language.ts` depends
                                // on this event to set its initial values.
                                onInitialize: () => el.dispatchEvent(new Event("change")),
                                itemClass: "form-control",
                                render: {
                                    item: function (data, escape) {
                                        return "<div>" + escape(data.text) + "</div>";
                                    },
                                    option: function (data, escape) {
                                        var _a, _b;
                                        const runtime = data.runtime;
                                        const path = (_a = runtime === null || runtime === void 0 ? void 0 : runtime.path) !== null && _a !== void 0 ? _a : "";
                                        return `<div><div>${escape(data.text)}</div><div>${(_b = escape(path)) !== null && _b !== void 0 ? _b : ""}</div></div>`;
                                    }
                                }
                            });
                            // Mark the element as initialized
                            el.dataset.tomselectInitialized = "true";
                        }
                    });
                }
                sizeToContent(scriptOptionsEl, false, -4);
            };
            window.addEventListener("message", scriptInfoListener);
            const cluster = getSelectedCluster(viewState.launchSpec);
            vscode.postMessage({
                event: "get_info_for_script",
                id: messageId,
                ext: language.ext,
                script: jobOptions.script,
                cluster,
                launcherInfo: launcher.info
            });
        };
        const scriptPathInputEl = document.getElementById("launcher-script-path");
        const scriptPathBrowseEl = document.getElementById("launcher-browse-script-path");
        const workdirPathInputEl = document.getElementById("launcher-workdir-path");
        workdirPathInputEl.textContent = jobOptions.workDir;
        const workdirPathBrowseEl = document.getElementById("launcher-browse-workdir-path");
        const browseHandler = (targetEl, keyName, directory = false) => {
            return () => {
                handleOnBrowse(directory, (event) => {
                    const { message } = event.data;
                    targetEl.textContent = message;
                    userModified[keyName] = true;
                    targetEl.dispatchEvent(new Event("change"));
                    if (keyName !== "script") {
                        jobOptions[keyName] = message;
                        saveState();
                        return;
                    }
                    setCurrentScript(message);
                });
            };
        };
        scriptPathInputEl.addEventListener("click", browseHandler(scriptPathInputEl, "script"));
        scriptPathBrowseEl.addEventListener("click", browseHandler(scriptPathInputEl, "script"));
        workdirPathInputEl.addEventListener("click", browseHandler(workdirPathInputEl, "workDir", true));
        workdirPathBrowseEl.addEventListener("click", browseHandler(workdirPathInputEl, "workDir", true));
        window.addEventListener("message", (event) => {
            const { type, message: path } = event.data;
            if (type !== "active_file") {
                return;
            }
            if (!(0, languages_1.validScriptExtension)(path)) {
                return;
            }
            // this means the user has not changed the file manually, so we
            // can update the script path without overwriting their choice
            if (!userModified.script) {
                setCurrentScript(path);
            }
        });
        // Wire up the managed credentials input.
        const managedCreds = new credentials_1.ManagedCredentialsInput((enabled) => {
            jobOptions.managedCredentialsEnabled = enabled;
            saveState();
        });
        // Handle managed credentials messages (both during initialization and at
        // runtime when settings change).
        window.addEventListener("message", (event) => {
            if (event.data.type !== "managed_credentials") {
                return;
            }
            managedCreds.enable(event.data.enabled);
        });
        startButton.addEventListener("click", () => {
            const valid = saveState();
            if (!valid) {
                return;
            }
            // Add script name to end of arguments
            const ext = (0, languages_1.extension)(jobOptions.script);
            if (ext === languages_1.R) {
                jobOptions.args.push({ name: "-f", value: jobOptions.script });
            }
            else if (ext === languages_1.PYTHON) {
                jobOptions.args.push({ value: jobOptions.script });
            }
            vscode.postMessage({
                event: "launch",
                launchSpec: Object.assign({}, viewState.launchSpec),
                jobOptions: Object.assign({}, viewState.jobOptions)
            });
        });
    }
    catch (err) {
        mainEl.classList.toggle("error", true);
        console.error(err);
        const errorEl = document.getElementById("error");
        errorEl.textContent = "There was an error initializing the job launcher";
    }
}
//# sourceMappingURL=data:application/json;base64,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