"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const tls = __importStar(require("tls"));
const url_1 = require("url");
const https_proxy_agent_1 = require("https-proxy-agent");
const crl_validator_1 = require("./crl_validator");
const socket_util_1 = __importDefault(require("./socket_util"));
const proxy_util_1 = __importDefault(require("../proxy_util"));
const logger_1 = __importDefault(require("../logger"));
class SnowflakeHttpsProxyAgent extends https_proxy_agent_1.HttpsProxyAgent {
    useForOCSP;
    crlValidatorConfig;
    constructor(opts) {
        const { host, port, user, password, protocol: rawProtocol, useForOCSP, crlValidatorConfig, ...agentOptions } = opts;
        const protocol = rawProtocol.endsWith(':') ? rawProtocol : `${rawProtocol}:`;
        const proxyUrl = new url_1.URL(`${protocol}//${host}:${port}`);
        proxyUrl.username = user ?? '';
        proxyUrl.password = password ?? '';
        super(proxyUrl, agentOptions);
        this.useForOCSP = useForOCSP;
        this.crlValidatorConfig = crlValidatorConfig;
    }
    async connect(req, opts) {
        (0, logger_1.default)().debug('Using proxy=%s for host %s', this.proxy.hostname, opts.host);
        const socket = await super.connect(req, opts);
        if (socket instanceof tls.TLSSocket) {
            if ((0, crl_validator_1.isCrlValidationEnabled)(this.crlValidatorConfig)) {
                (0, crl_validator_1.corkSocketAndValidateCrl)(socket, this.crlValidatorConfig);
            }
            else {
                const isProxyRequiredForOCSP = this.useForOCSP &&
                    !proxy_util_1.default.isByPassProxy(this.proxy, socket_util_1.default.REGEX_SNOWFLAKE_ENDPOINT);
                socket_util_1.default.secureSocket(socket, this.proxy.hostname, isProxyRequiredForOCSP ? this : null);
            }
        }
        return socket;
    }
}
module.exports = SnowflakeHttpsProxyAgent;
//# sourceMappingURL=https_proxy_agent.js.map