############################################################################
# Copyright(c) Open Law Library. All rights reserved.                      #
# See ThirdPartyNotices.txt in the project root for additional notices.    #
#                                                                          #
# Licensed under the Apache License, Version 2.0 (the "License")           #
# you may not use this file except in compliance with the License.         #
# You may obtain a copy of the License at                                  #
#                                                                          #
#     http: // www.apache.org/licenses/LICENSE-2.0                         #
#                                                                          #
# Unless required by applicable law or agreed to in writing, software      #
# distributed under the License is distributed on an "AS IS" BASIS,        #
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. #
# See the License for the specific language governing permissions and      #
# limitations under the License.                                           #
############################################################################

# GENERATED FROM scripts/generate_code.py -- DO NOT EDIT
# flake8: noqa
from __future__ import annotations

from functools import reduce
import typing

if typing.TYPE_CHECKING:
    from positron._vendor.lsprotocol import types
    from typing import Any
    from typing import Literal
    from typing import Sequence
    from typing import Union

@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace'], default: None = None) -> types.WorkspaceClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace'], default: types.WorkspaceClientCapabilities) -> types.WorkspaceClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.apply_edit'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.apply_edit'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit'], default: None = None) -> types.WorkspaceEditClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit'], default: types.WorkspaceEditClientCapabilities) -> types.WorkspaceEditClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.document_changes'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.document_changes'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.resource_operations'], default: None = None) -> Sequence[types.ResourceOperationKind] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.resource_operations'], default: Sequence[types.ResourceOperationKind]) -> Sequence[types.ResourceOperationKind]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.failure_handling'], default: None = None) -> types.FailureHandlingKind | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.failure_handling'], default: types.FailureHandlingKind) -> types.FailureHandlingKind: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.normalizes_line_endings'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.normalizes_line_endings'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.change_annotation_support'], default: None = None) -> types.ChangeAnnotationsSupportOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.change_annotation_support'], default: types.ChangeAnnotationsSupportOptions) -> types.ChangeAnnotationsSupportOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.change_annotation_support.groups_on_label'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.change_annotation_support.groups_on_label'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.metadata_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.metadata_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.snippet_edit_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_edit.snippet_edit_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.did_change_configuration'], default: None = None) -> types.DidChangeConfigurationClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.did_change_configuration'], default: types.DidChangeConfigurationClientCapabilities) -> types.DidChangeConfigurationClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.did_change_configuration.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.did_change_configuration.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.did_change_watched_files'], default: None = None) -> types.DidChangeWatchedFilesClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.did_change_watched_files'], default: types.DidChangeWatchedFilesClientCapabilities) -> types.DidChangeWatchedFilesClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.did_change_watched_files.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.did_change_watched_files.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.did_change_watched_files.relative_pattern_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.did_change_watched_files.relative_pattern_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol'], default: None = None) -> types.WorkspaceSymbolClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol'], default: types.WorkspaceSymbolClientCapabilities) -> types.WorkspaceSymbolClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.symbol_kind'], default: None = None) -> types.ClientSymbolKindOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.symbol_kind'], default: types.ClientSymbolKindOptions) -> types.ClientSymbolKindOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.symbol_kind.value_set'], default: None = None) -> Sequence[types.SymbolKind] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.symbol_kind.value_set'], default: Sequence[types.SymbolKind]) -> Sequence[types.SymbolKind]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.tag_support'], default: None = None) -> types.ClientSymbolTagOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.tag_support'], default: types.ClientSymbolTagOptions) -> types.ClientSymbolTagOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.tag_support.value_set'], default: None = None) -> types.SymbolTag | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.tag_support.value_set'], default: types.SymbolTag) -> types.SymbolTag: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.resolve_support'], default: None = None) -> types.ClientSymbolResolveOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.resolve_support'], default: types.ClientSymbolResolveOptions) -> types.ClientSymbolResolveOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.resolve_support.properties'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.symbol.resolve_support.properties'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.execute_command'], default: None = None) -> types.ExecuteCommandClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.execute_command'], default: types.ExecuteCommandClientCapabilities) -> types.ExecuteCommandClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.execute_command.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.execute_command.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_folders'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.workspace_folders'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.configuration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.configuration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.semantic_tokens'], default: None = None) -> types.SemanticTokensWorkspaceClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.semantic_tokens'], default: types.SemanticTokensWorkspaceClientCapabilities) -> types.SemanticTokensWorkspaceClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.semantic_tokens.refresh_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.semantic_tokens.refresh_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.code_lens'], default: None = None) -> types.CodeLensWorkspaceClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.code_lens'], default: types.CodeLensWorkspaceClientCapabilities) -> types.CodeLensWorkspaceClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.code_lens.refresh_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.code_lens.refresh_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations'], default: None = None) -> types.FileOperationClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations'], default: types.FileOperationClientCapabilities) -> types.FileOperationClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.did_create'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.did_create'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.will_create'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.will_create'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.did_rename'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.did_rename'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.will_rename'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.will_rename'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.did_delete'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.did_delete'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.will_delete'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.file_operations.will_delete'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.inline_value'], default: None = None) -> types.InlineValueWorkspaceClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.inline_value'], default: types.InlineValueWorkspaceClientCapabilities) -> types.InlineValueWorkspaceClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.inline_value.refresh_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.inline_value.refresh_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.inlay_hint'], default: None = None) -> types.InlayHintWorkspaceClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.inlay_hint'], default: types.InlayHintWorkspaceClientCapabilities) -> types.InlayHintWorkspaceClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.inlay_hint.refresh_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.inlay_hint.refresh_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.diagnostics'], default: None = None) -> types.DiagnosticWorkspaceClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.diagnostics'], default: types.DiagnosticWorkspaceClientCapabilities) -> types.DiagnosticWorkspaceClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.diagnostics.refresh_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.diagnostics.refresh_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.folding_range'], default: None = None) -> types.FoldingRangeWorkspaceClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.folding_range'], default: types.FoldingRangeWorkspaceClientCapabilities) -> types.FoldingRangeWorkspaceClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.folding_range.refresh_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.folding_range.refresh_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.text_document_content'], default: None = None) -> types.TextDocumentContentClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.text_document_content'], default: types.TextDocumentContentClientCapabilities) -> types.TextDocumentContentClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.text_document_content.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['workspace.text_document_content.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document'], default: None = None) -> types.TextDocumentClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document'], default: types.TextDocumentClientCapabilities) -> types.TextDocumentClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.synchronization'], default: None = None) -> types.TextDocumentSyncClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.synchronization'], default: types.TextDocumentSyncClientCapabilities) -> types.TextDocumentSyncClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.synchronization.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.synchronization.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.synchronization.will_save'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.synchronization.will_save'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.synchronization.will_save_wait_until'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.synchronization.will_save_wait_until'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.synchronization.did_save'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.synchronization.did_save'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.filters'], default: None = None) -> types.TextDocumentFilterClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.filters'], default: types.TextDocumentFilterClientCapabilities) -> types.TextDocumentFilterClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.filters.relative_pattern_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.filters.relative_pattern_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion'], default: None = None) -> types.CompletionClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion'], default: types.CompletionClientCapabilities) -> types.CompletionClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item'], default: None = None) -> types.ClientCompletionItemOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item'], default: types.ClientCompletionItemOptions) -> types.ClientCompletionItemOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.snippet_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.snippet_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.commit_characters_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.commit_characters_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.documentation_format'], default: None = None) -> Sequence[types.MarkupKind] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.documentation_format'], default: Sequence[types.MarkupKind]) -> Sequence[types.MarkupKind]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.deprecated_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.deprecated_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.preselect_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.preselect_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.tag_support'], default: None = None) -> types.CompletionItemTagOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.tag_support'], default: types.CompletionItemTagOptions) -> types.CompletionItemTagOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.tag_support.value_set'], default: None = None) -> types.CompletionItemTag | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.tag_support.value_set'], default: types.CompletionItemTag) -> types.CompletionItemTag: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.insert_replace_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.insert_replace_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.resolve_support'], default: None = None) -> types.ClientCompletionItemResolveOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.resolve_support'], default: types.ClientCompletionItemResolveOptions) -> types.ClientCompletionItemResolveOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.resolve_support.properties'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.resolve_support.properties'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.insert_text_mode_support'], default: None = None) -> types.ClientCompletionItemInsertTextModeOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.insert_text_mode_support'], default: types.ClientCompletionItemInsertTextModeOptions) -> types.ClientCompletionItemInsertTextModeOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.insert_text_mode_support.value_set'], default: None = None) -> types.InsertTextMode | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.insert_text_mode_support.value_set'], default: types.InsertTextMode) -> types.InsertTextMode: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.label_details_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item.label_details_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item_kind'], default: None = None) -> types.ClientCompletionItemOptionsKind | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item_kind'], default: types.ClientCompletionItemOptionsKind) -> types.ClientCompletionItemOptionsKind: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item_kind.value_set'], default: None = None) -> Sequence[Union[types.CompletionItemKind, int]] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_item_kind.value_set'], default: Sequence[Union[types.CompletionItemKind, int]]) -> Sequence[Union[types.CompletionItemKind, int]]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.insert_text_mode'], default: None = None) -> types.InsertTextMode | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.insert_text_mode'], default: types.InsertTextMode) -> types.InsertTextMode: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.context_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.context_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_list'], default: None = None) -> types.CompletionListCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_list'], default: types.CompletionListCapabilities) -> types.CompletionListCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_list.item_defaults'], default: None = None) -> Sequence[str] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_list.item_defaults'], default: Sequence[str]) -> Sequence[str]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_list.apply_kind_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.completion.completion_list.apply_kind_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.hover'], default: None = None) -> types.HoverClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.hover'], default: types.HoverClientCapabilities) -> types.HoverClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.hover.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.hover.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.hover.content_format'], default: None = None) -> Sequence[types.MarkupKind] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.hover.content_format'], default: Sequence[types.MarkupKind]) -> Sequence[types.MarkupKind]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help'], default: None = None) -> types.SignatureHelpClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help'], default: types.SignatureHelpClientCapabilities) -> types.SignatureHelpClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information'], default: None = None) -> types.ClientSignatureInformationOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information'], default: types.ClientSignatureInformationOptions) -> types.ClientSignatureInformationOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information.documentation_format'], default: None = None) -> Sequence[types.MarkupKind] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information.documentation_format'], default: Sequence[types.MarkupKind]) -> Sequence[types.MarkupKind]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information.parameter_information'], default: None = None) -> types.ClientSignatureParameterInformationOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information.parameter_information'], default: types.ClientSignatureParameterInformationOptions) -> types.ClientSignatureParameterInformationOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information.parameter_information.label_offset_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information.parameter_information.label_offset_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information.active_parameter_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information.active_parameter_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information.no_active_parameter_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.signature_information.no_active_parameter_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.context_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.signature_help.context_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.declaration'], default: None = None) -> types.DeclarationClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.declaration'], default: types.DeclarationClientCapabilities) -> types.DeclarationClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.declaration.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.declaration.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.declaration.link_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.declaration.link_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.definition'], default: None = None) -> types.DefinitionClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.definition'], default: types.DefinitionClientCapabilities) -> types.DefinitionClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.definition.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.definition.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.definition.link_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.definition.link_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.type_definition'], default: None = None) -> types.TypeDefinitionClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.type_definition'], default: types.TypeDefinitionClientCapabilities) -> types.TypeDefinitionClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.type_definition.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.type_definition.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.type_definition.link_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.type_definition.link_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.implementation'], default: None = None) -> types.ImplementationClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.implementation'], default: types.ImplementationClientCapabilities) -> types.ImplementationClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.implementation.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.implementation.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.implementation.link_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.implementation.link_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.references'], default: None = None) -> types.ReferenceClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.references'], default: types.ReferenceClientCapabilities) -> types.ReferenceClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.references.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.references.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_highlight'], default: None = None) -> types.DocumentHighlightClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_highlight'], default: types.DocumentHighlightClientCapabilities) -> types.DocumentHighlightClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_highlight.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_highlight.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol'], default: None = None) -> types.DocumentSymbolClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol'], default: types.DocumentSymbolClientCapabilities) -> types.DocumentSymbolClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.symbol_kind'], default: None = None) -> types.ClientSymbolKindOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.symbol_kind'], default: types.ClientSymbolKindOptions) -> types.ClientSymbolKindOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.symbol_kind.value_set'], default: None = None) -> Sequence[types.SymbolKind] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.symbol_kind.value_set'], default: Sequence[types.SymbolKind]) -> Sequence[types.SymbolKind]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.hierarchical_document_symbol_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.hierarchical_document_symbol_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.tag_support'], default: None = None) -> types.ClientSymbolTagOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.tag_support'], default: types.ClientSymbolTagOptions) -> types.ClientSymbolTagOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.tag_support.value_set'], default: None = None) -> types.SymbolTag | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.tag_support.value_set'], default: types.SymbolTag) -> types.SymbolTag: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.label_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_symbol.label_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action'], default: None = None) -> types.CodeActionClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action'], default: types.CodeActionClientCapabilities) -> types.CodeActionClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.code_action_literal_support'], default: None = None) -> types.ClientCodeActionLiteralOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.code_action_literal_support'], default: types.ClientCodeActionLiteralOptions) -> types.ClientCodeActionLiteralOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.code_action_literal_support.code_action_kind'], default: None = None) -> types.ClientCodeActionKindOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.code_action_literal_support.code_action_kind'], default: types.ClientCodeActionKindOptions) -> types.ClientCodeActionKindOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.code_action_literal_support.code_action_kind.value_set'], default: None = None) -> Union[types.CodeActionKind, str] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.code_action_literal_support.code_action_kind.value_set'], default: Union[types.CodeActionKind, str]) -> Union[types.CodeActionKind, str]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.is_preferred_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.is_preferred_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.disabled_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.disabled_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.data_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.data_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.resolve_support'], default: None = None) -> types.ClientCodeActionResolveOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.resolve_support'], default: types.ClientCodeActionResolveOptions) -> types.ClientCodeActionResolveOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.resolve_support.properties'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.resolve_support.properties'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.honors_change_annotations'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.honors_change_annotations'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.documentation_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.documentation_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.tag_support'], default: None = None) -> types.CodeActionTagOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.tag_support'], default: types.CodeActionTagOptions) -> types.CodeActionTagOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.tag_support.value_set'], default: None = None) -> types.CodeActionTag | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_action.tag_support.value_set'], default: types.CodeActionTag) -> types.CodeActionTag: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_lens'], default: None = None) -> types.CodeLensClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_lens'], default: types.CodeLensClientCapabilities) -> types.CodeLensClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_lens.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_lens.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_lens.resolve_support'], default: None = None) -> types.ClientCodeLensResolveOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_lens.resolve_support'], default: types.ClientCodeLensResolveOptions) -> types.ClientCodeLensResolveOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_lens.resolve_support.properties'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.code_lens.resolve_support.properties'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_link'], default: None = None) -> types.DocumentLinkClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_link'], default: types.DocumentLinkClientCapabilities) -> types.DocumentLinkClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_link.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_link.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_link.tooltip_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.document_link.tooltip_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.color_provider'], default: None = None) -> types.DocumentColorClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.color_provider'], default: types.DocumentColorClientCapabilities) -> types.DocumentColorClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.color_provider.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.color_provider.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.formatting'], default: None = None) -> types.DocumentFormattingClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.formatting'], default: types.DocumentFormattingClientCapabilities) -> types.DocumentFormattingClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.formatting.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.formatting.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.range_formatting'], default: None = None) -> types.DocumentRangeFormattingClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.range_formatting'], default: types.DocumentRangeFormattingClientCapabilities) -> types.DocumentRangeFormattingClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.range_formatting.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.range_formatting.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.range_formatting.ranges_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.range_formatting.ranges_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.on_type_formatting'], default: None = None) -> types.DocumentOnTypeFormattingClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.on_type_formatting'], default: types.DocumentOnTypeFormattingClientCapabilities) -> types.DocumentOnTypeFormattingClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.on_type_formatting.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.on_type_formatting.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.rename'], default: None = None) -> types.RenameClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.rename'], default: types.RenameClientCapabilities) -> types.RenameClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.rename.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.rename.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.rename.prepare_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.rename.prepare_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.rename.prepare_support_default_behavior'], default: None = None) -> types.PrepareSupportDefaultBehavior | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.rename.prepare_support_default_behavior'], default: types.PrepareSupportDefaultBehavior) -> types.PrepareSupportDefaultBehavior: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.rename.honors_change_annotations'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.rename.honors_change_annotations'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range'], default: None = None) -> types.FoldingRangeClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range'], default: types.FoldingRangeClientCapabilities) -> types.FoldingRangeClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.range_limit'], default: None = None) -> None | int: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.range_limit'], default: int) -> int: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.line_folding_only'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.line_folding_only'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.folding_range_kind'], default: None = None) -> types.ClientFoldingRangeKindOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.folding_range_kind'], default: types.ClientFoldingRangeKindOptions) -> types.ClientFoldingRangeKindOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.folding_range_kind.value_set'], default: None = None) -> Sequence[Union[types.FoldingRangeKind, str]] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.folding_range_kind.value_set'], default: Sequence[Union[types.FoldingRangeKind, str]]) -> Sequence[Union[types.FoldingRangeKind, str]]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.folding_range'], default: None = None) -> types.ClientFoldingRangeOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.folding_range'], default: types.ClientFoldingRangeOptions) -> types.ClientFoldingRangeOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.folding_range.collapsed_text'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.folding_range.folding_range.collapsed_text'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.selection_range'], default: None = None) -> types.SelectionRangeClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.selection_range'], default: types.SelectionRangeClientCapabilities) -> types.SelectionRangeClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.selection_range.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.selection_range.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics'], default: None = None) -> types.PublishDiagnosticsClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics'], default: types.PublishDiagnosticsClientCapabilities) -> types.PublishDiagnosticsClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.version_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.version_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.related_information'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.related_information'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.tag_support'], default: None = None) -> types.ClientDiagnosticsTagOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.tag_support'], default: types.ClientDiagnosticsTagOptions) -> types.ClientDiagnosticsTagOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.tag_support.value_set'], default: None = None) -> types.DiagnosticTag | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.tag_support.value_set'], default: types.DiagnosticTag) -> types.DiagnosticTag: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.code_description_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.code_description_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.data_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.publish_diagnostics.data_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.call_hierarchy'], default: None = None) -> types.CallHierarchyClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.call_hierarchy'], default: types.CallHierarchyClientCapabilities) -> types.CallHierarchyClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.call_hierarchy.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.call_hierarchy.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens'], default: None = None) -> types.SemanticTokensClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens'], default: types.SemanticTokensClientCapabilities) -> types.SemanticTokensClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.requests'], default: None = None) -> types.ClientSemanticTokensRequestOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.requests'], default: types.ClientSemanticTokensRequestOptions) -> types.ClientSemanticTokensRequestOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.requests.range'], default: None = None) -> bool | None | Any: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.requests.range'], default: bool | Any) -> bool | Any: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.requests.full'], default: None = None) -> types.ClientSemanticTokensRequestFullDelta | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.requests.full'], default: types.ClientSemanticTokensRequestFullDelta | bool) -> types.ClientSemanticTokensRequestFullDelta | bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.requests.full.delta'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.requests.full.delta'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.token_types'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.token_types'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.token_modifiers'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.token_modifiers'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.formats'], default: None = None) -> types.TokenFormat | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.formats'], default: types.TokenFormat) -> types.TokenFormat: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.overlapping_token_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.overlapping_token_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.multiline_token_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.multiline_token_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.server_cancel_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.server_cancel_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.augments_syntax_tokens'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.semantic_tokens.augments_syntax_tokens'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.linked_editing_range'], default: None = None) -> types.LinkedEditingRangeClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.linked_editing_range'], default: types.LinkedEditingRangeClientCapabilities) -> types.LinkedEditingRangeClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.linked_editing_range.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.linked_editing_range.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.moniker'], default: None = None) -> types.MonikerClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.moniker'], default: types.MonikerClientCapabilities) -> types.MonikerClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.moniker.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.moniker.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.type_hierarchy'], default: None = None) -> types.TypeHierarchyClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.type_hierarchy'], default: types.TypeHierarchyClientCapabilities) -> types.TypeHierarchyClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.type_hierarchy.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.type_hierarchy.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inline_value'], default: None = None) -> types.InlineValueClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inline_value'], default: types.InlineValueClientCapabilities) -> types.InlineValueClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inline_value.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inline_value.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inlay_hint'], default: None = None) -> types.InlayHintClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inlay_hint'], default: types.InlayHintClientCapabilities) -> types.InlayHintClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inlay_hint.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inlay_hint.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inlay_hint.resolve_support'], default: None = None) -> types.ClientInlayHintResolveOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inlay_hint.resolve_support'], default: types.ClientInlayHintResolveOptions) -> types.ClientInlayHintResolveOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inlay_hint.resolve_support.properties'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inlay_hint.resolve_support.properties'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic'], default: None = None) -> types.DiagnosticClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic'], default: types.DiagnosticClientCapabilities) -> types.DiagnosticClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.related_document_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.related_document_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.related_information'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.related_information'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.tag_support'], default: None = None) -> types.ClientDiagnosticsTagOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.tag_support'], default: types.ClientDiagnosticsTagOptions) -> types.ClientDiagnosticsTagOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.tag_support.value_set'], default: None = None) -> types.DiagnosticTag | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.tag_support.value_set'], default: types.DiagnosticTag) -> types.DiagnosticTag: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.code_description_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.code_description_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.data_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.diagnostic.data_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inline_completion'], default: None = None) -> types.InlineCompletionClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inline_completion'], default: types.InlineCompletionClientCapabilities) -> types.InlineCompletionClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inline_completion.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['text_document.inline_completion.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['notebook_document'], default: None = None) -> types.NotebookDocumentClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['notebook_document'], default: types.NotebookDocumentClientCapabilities) -> types.NotebookDocumentClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['notebook_document.synchronization'], default: None = None) -> types.NotebookDocumentSyncClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['notebook_document.synchronization'], default: types.NotebookDocumentSyncClientCapabilities) -> types.NotebookDocumentSyncClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['notebook_document.synchronization.dynamic_registration'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['notebook_document.synchronization.dynamic_registration'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['notebook_document.synchronization.execution_summary_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['notebook_document.synchronization.execution_summary_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window'], default: None = None) -> types.WindowClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window'], default: types.WindowClientCapabilities) -> types.WindowClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.show_message'], default: None = None) -> types.ShowMessageRequestClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.show_message'], default: types.ShowMessageRequestClientCapabilities) -> types.ShowMessageRequestClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.show_message.message_action_item'], default: None = None) -> types.ClientShowMessageActionItemOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.show_message.message_action_item'], default: types.ClientShowMessageActionItemOptions) -> types.ClientShowMessageActionItemOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.show_message.message_action_item.additional_properties_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.show_message.message_action_item.additional_properties_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.show_document'], default: None = None) -> types.ShowDocumentClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.show_document'], default: types.ShowDocumentClientCapabilities) -> types.ShowDocumentClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.show_document.support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['window.show_document.support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general'], default: None = None) -> types.GeneralClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general'], default: types.GeneralClientCapabilities) -> types.GeneralClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.stale_request_support'], default: None = None) -> types.StaleRequestSupportOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.stale_request_support'], default: types.StaleRequestSupportOptions) -> types.StaleRequestSupportOptions: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.stale_request_support.cancel'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.stale_request_support.cancel'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.stale_request_support.retry_on_content_modified'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.stale_request_support.retry_on_content_modified'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.regular_expressions'], default: None = None) -> types.RegularExpressionsClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.regular_expressions'], default: types.RegularExpressionsClientCapabilities) -> types.RegularExpressionsClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.regular_expressions.engine'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.regular_expressions.engine'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.regular_expressions.version'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.regular_expressions.version'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.markdown'], default: None = None) -> types.MarkdownClientCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.markdown'], default: types.MarkdownClientCapabilities) -> types.MarkdownClientCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.markdown.parser'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.markdown.parser'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.markdown.version'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.markdown.version'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.markdown.allowed_tags'], default: None = None) -> Sequence[str] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.markdown.allowed_tags'], default: Sequence[str]) -> Sequence[str]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.position_encodings'], default: None = None) -> Sequence[Union[types.PositionEncodingKind, str]] | None: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['general.position_encodings'], default: Sequence[Union[types.PositionEncodingKind, str]]) -> Sequence[Union[types.PositionEncodingKind, str]]: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['experimental'], default: None = None) -> None | Any: ...
@typing.overload
def get_capability(capabilities: types.ClientCapabilities, field: Literal['experimental'], default: Any) -> Any: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['position_encoding'], default: None = None) -> types.PositionEncodingKind | None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['position_encoding'], default: types.PositionEncodingKind | str) -> types.PositionEncodingKind | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync'], default: None = None) -> types.TextDocumentSyncOptions | types.TextDocumentSyncKind | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync'], default: types.TextDocumentSyncOptions | types.TextDocumentSyncKind) -> types.TextDocumentSyncOptions | types.TextDocumentSyncKind: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.open_close'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.open_close'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.change'], default: None = None) -> types.TextDocumentSyncKind | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.change'], default: types.TextDocumentSyncKind) -> types.TextDocumentSyncKind: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.will_save'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.will_save'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.will_save_wait_until'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.will_save_wait_until'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.save'], default: None = None) -> types.SaveOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.save'], default: types.SaveOptions | bool) -> types.SaveOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.save.include_text'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['text_document_sync.save.include_text'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['notebook_document_sync'], default: None = None) -> types.NotebookDocumentSyncRegistrationOptions | types.NotebookDocumentSyncOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['notebook_document_sync'], default: types.NotebookDocumentSyncRegistrationOptions | types.NotebookDocumentSyncOptions) -> types.NotebookDocumentSyncRegistrationOptions | types.NotebookDocumentSyncOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['notebook_document_sync.notebook_selector'], default: None = None) -> Union[types.NotebookDocumentFilterWithNotebook, types.NotebookDocumentFilterWithCells] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['notebook_document_sync.notebook_selector'], default: Union[types.NotebookDocumentFilterWithNotebook, types.NotebookDocumentFilterWithCells]) -> Union[types.NotebookDocumentFilterWithNotebook, types.NotebookDocumentFilterWithCells]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['notebook_document_sync.save'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['notebook_document_sync.save'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['notebook_document_sync.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['notebook_document_sync.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider'], default: None = None) -> types.CompletionOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider'], default: types.CompletionOptions) -> types.CompletionOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.trigger_characters'], default: None = None) -> Sequence[str] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.trigger_characters'], default: Sequence[str]) -> Sequence[str]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.all_commit_characters'], default: None = None) -> Sequence[str] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.all_commit_characters'], default: Sequence[str]) -> Sequence[str]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.resolve_provider'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.resolve_provider'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.completion_item'], default: None = None) -> types.ServerCompletionItemOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.completion_item'], default: types.ServerCompletionItemOptions) -> types.ServerCompletionItemOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.completion_item.label_details_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.completion_item.label_details_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['completion_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['hover_provider'], default: None = None) -> types.HoverOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['hover_provider'], default: types.HoverOptions | bool) -> types.HoverOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['hover_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['hover_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['signature_help_provider'], default: None = None) -> types.SignatureHelpOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['signature_help_provider'], default: types.SignatureHelpOptions) -> types.SignatureHelpOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['signature_help_provider.trigger_characters'], default: None = None) -> Sequence[str] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['signature_help_provider.trigger_characters'], default: Sequence[str]) -> Sequence[str]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['signature_help_provider.retrigger_characters'], default: None = None) -> Sequence[str] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['signature_help_provider.retrigger_characters'], default: Sequence[str]) -> Sequence[str]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['signature_help_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['signature_help_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['declaration_provider'], default: None = None) -> types.DeclarationRegistrationOptions | types.DeclarationOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['declaration_provider'], default: types.DeclarationRegistrationOptions | types.DeclarationOptions | bool) -> types.DeclarationRegistrationOptions | types.DeclarationOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['declaration_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['declaration_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['declaration_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['declaration_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['declaration_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['declaration_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['definition_provider'], default: None = None) -> types.DefinitionOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['definition_provider'], default: types.DefinitionOptions | bool) -> types.DefinitionOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['definition_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['definition_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_definition_provider'], default: None = None) -> types.TypeDefinitionRegistrationOptions | types.TypeDefinitionOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_definition_provider'], default: types.TypeDefinitionRegistrationOptions | types.TypeDefinitionOptions | bool) -> types.TypeDefinitionRegistrationOptions | types.TypeDefinitionOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_definition_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_definition_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_definition_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_definition_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_definition_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_definition_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['implementation_provider'], default: None = None) -> types.ImplementationRegistrationOptions | types.ImplementationOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['implementation_provider'], default: types.ImplementationRegistrationOptions | types.ImplementationOptions | bool) -> types.ImplementationRegistrationOptions | types.ImplementationOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['implementation_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['implementation_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['implementation_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['implementation_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['implementation_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['implementation_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['references_provider'], default: None = None) -> types.ReferenceOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['references_provider'], default: types.ReferenceOptions | bool) -> types.ReferenceOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['references_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['references_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_highlight_provider'], default: None = None) -> types.DocumentHighlightOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_highlight_provider'], default: types.DocumentHighlightOptions | bool) -> types.DocumentHighlightOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_highlight_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_highlight_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_symbol_provider'], default: None = None) -> types.DocumentSymbolOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_symbol_provider'], default: types.DocumentSymbolOptions | bool) -> types.DocumentSymbolOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_symbol_provider.label'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_symbol_provider.label'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_symbol_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_symbol_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_action_provider'], default: None = None) -> types.CodeActionOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_action_provider'], default: types.CodeActionOptions | bool) -> types.CodeActionOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_action_provider.code_action_kinds'], default: None = None) -> Sequence[Union[types.CodeActionKind, str]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_action_provider.code_action_kinds'], default: Sequence[Union[types.CodeActionKind, str]]) -> Sequence[Union[types.CodeActionKind, str]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_action_provider.documentation'], default: None = None) -> Sequence[types.CodeActionKindDocumentation] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_action_provider.documentation'], default: Sequence[types.CodeActionKindDocumentation]) -> Sequence[types.CodeActionKindDocumentation]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_action_provider.resolve_provider'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_action_provider.resolve_provider'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_action_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_action_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_lens_provider'], default: None = None) -> types.CodeLensOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_lens_provider'], default: types.CodeLensOptions) -> types.CodeLensOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_lens_provider.resolve_provider'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_lens_provider.resolve_provider'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_lens_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['code_lens_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_link_provider'], default: None = None) -> types.DocumentLinkOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_link_provider'], default: types.DocumentLinkOptions) -> types.DocumentLinkOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_link_provider.resolve_provider'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_link_provider.resolve_provider'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_link_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_link_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['color_provider'], default: None = None) -> types.DocumentColorRegistrationOptions | types.DocumentColorOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['color_provider'], default: types.DocumentColorRegistrationOptions | types.DocumentColorOptions | bool) -> types.DocumentColorRegistrationOptions | types.DocumentColorOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['color_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['color_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['color_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['color_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['color_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['color_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace_symbol_provider'], default: None = None) -> types.WorkspaceSymbolOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace_symbol_provider'], default: types.WorkspaceSymbolOptions | bool) -> types.WorkspaceSymbolOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace_symbol_provider.resolve_provider'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace_symbol_provider.resolve_provider'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace_symbol_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace_symbol_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_formatting_provider'], default: None = None) -> types.DocumentFormattingOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_formatting_provider'], default: types.DocumentFormattingOptions | bool) -> types.DocumentFormattingOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_formatting_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_formatting_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_range_formatting_provider'], default: None = None) -> types.DocumentRangeFormattingOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_range_formatting_provider'], default: types.DocumentRangeFormattingOptions | bool) -> types.DocumentRangeFormattingOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_range_formatting_provider.ranges_support'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_range_formatting_provider.ranges_support'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_range_formatting_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_range_formatting_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_on_type_formatting_provider'], default: None = None) -> types.DocumentOnTypeFormattingOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_on_type_formatting_provider'], default: types.DocumentOnTypeFormattingOptions) -> types.DocumentOnTypeFormattingOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_on_type_formatting_provider.first_trigger_character'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_on_type_formatting_provider.first_trigger_character'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_on_type_formatting_provider.more_trigger_character'], default: None = None) -> Sequence[str] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['document_on_type_formatting_provider.more_trigger_character'], default: Sequence[str]) -> Sequence[str]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['rename_provider'], default: None = None) -> types.RenameOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['rename_provider'], default: types.RenameOptions | bool) -> types.RenameOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['rename_provider.prepare_provider'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['rename_provider.prepare_provider'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['rename_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['rename_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['folding_range_provider'], default: None = None) -> types.FoldingRangeRegistrationOptions | types.FoldingRangeOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['folding_range_provider'], default: types.FoldingRangeRegistrationOptions | types.FoldingRangeOptions | bool) -> types.FoldingRangeRegistrationOptions | types.FoldingRangeOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['folding_range_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['folding_range_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['folding_range_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['folding_range_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['folding_range_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['folding_range_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['selection_range_provider'], default: None = None) -> types.SelectionRangeRegistrationOptions | types.SelectionRangeOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['selection_range_provider'], default: types.SelectionRangeRegistrationOptions | types.SelectionRangeOptions | bool) -> types.SelectionRangeRegistrationOptions | types.SelectionRangeOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['selection_range_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['selection_range_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['selection_range_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['selection_range_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['selection_range_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['selection_range_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['execute_command_provider'], default: None = None) -> types.ExecuteCommandOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['execute_command_provider'], default: types.ExecuteCommandOptions) -> types.ExecuteCommandOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['execute_command_provider.commands'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['execute_command_provider.commands'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['execute_command_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['execute_command_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['call_hierarchy_provider'], default: None = None) -> types.CallHierarchyRegistrationOptions | types.CallHierarchyOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['call_hierarchy_provider'], default: types.CallHierarchyRegistrationOptions | types.CallHierarchyOptions | bool) -> types.CallHierarchyRegistrationOptions | types.CallHierarchyOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['call_hierarchy_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['call_hierarchy_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['call_hierarchy_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['call_hierarchy_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['call_hierarchy_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['call_hierarchy_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['linked_editing_range_provider'], default: None = None) -> types.LinkedEditingRangeRegistrationOptions | types.LinkedEditingRangeOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['linked_editing_range_provider'], default: types.LinkedEditingRangeRegistrationOptions | types.LinkedEditingRangeOptions | bool) -> types.LinkedEditingRangeRegistrationOptions | types.LinkedEditingRangeOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['linked_editing_range_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['linked_editing_range_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['linked_editing_range_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['linked_editing_range_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['linked_editing_range_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['linked_editing_range_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider'], default: None = None) -> types.SemanticTokensRegistrationOptions | types.SemanticTokensOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider'], default: types.SemanticTokensRegistrationOptions | types.SemanticTokensOptions) -> types.SemanticTokensRegistrationOptions | types.SemanticTokensOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.legend'], default: None = None) -> types.SemanticTokensLegend | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.legend'], default: types.SemanticTokensLegend) -> types.SemanticTokensLegend: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.legend.token_types'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.legend.token_types'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.legend.token_modifiers'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.legend.token_modifiers'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.range'], default: None = None) -> bool | None | Any: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.range'], default: bool | Any) -> bool | Any: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.full'], default: None = None) -> types.SemanticTokensFullDelta | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.full'], default: types.SemanticTokensFullDelta | bool) -> types.SemanticTokensFullDelta | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.full.delta'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.full.delta'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['semantic_tokens_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['moniker_provider'], default: None = None) -> types.MonikerRegistrationOptions | types.MonikerOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['moniker_provider'], default: types.MonikerRegistrationOptions | types.MonikerOptions | bool) -> types.MonikerRegistrationOptions | types.MonikerOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['moniker_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['moniker_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['moniker_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['moniker_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_hierarchy_provider'], default: None = None) -> types.TypeHierarchyRegistrationOptions | types.TypeHierarchyOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_hierarchy_provider'], default: types.TypeHierarchyRegistrationOptions | types.TypeHierarchyOptions | bool) -> types.TypeHierarchyRegistrationOptions | types.TypeHierarchyOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_hierarchy_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_hierarchy_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_hierarchy_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_hierarchy_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_hierarchy_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['type_hierarchy_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_value_provider'], default: None = None) -> types.InlineValueRegistrationOptions | types.InlineValueOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_value_provider'], default: types.InlineValueRegistrationOptions | types.InlineValueOptions | bool) -> types.InlineValueRegistrationOptions | types.InlineValueOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_value_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_value_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_value_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_value_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_value_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_value_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inlay_hint_provider'], default: None = None) -> types.InlayHintRegistrationOptions | types.InlayHintOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inlay_hint_provider'], default: types.InlayHintRegistrationOptions | types.InlayHintOptions | bool) -> types.InlayHintRegistrationOptions | types.InlayHintOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inlay_hint_provider.resolve_provider'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inlay_hint_provider.resolve_provider'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inlay_hint_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inlay_hint_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inlay_hint_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inlay_hint_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inlay_hint_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inlay_hint_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider'], default: None = None) -> types.DiagnosticRegistrationOptions | types.DiagnosticOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider'], default: types.DiagnosticRegistrationOptions | types.DiagnosticOptions) -> types.DiagnosticRegistrationOptions | types.DiagnosticOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.inter_file_dependencies'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.inter_file_dependencies'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.workspace_diagnostics'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.workspace_diagnostics'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.identifier'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.identifier'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.document_selector'], default: None = None) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]] | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.document_selector'], default: Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]) -> Sequence[Union[types.TextDocumentFilterLanguage, types.TextDocumentFilterScheme, types.TextDocumentFilterPattern, types.NotebookCellTextDocumentFilter]]: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['diagnostic_provider.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_completion_provider'], default: None = None) -> types.InlineCompletionOptions | bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_completion_provider'], default: types.InlineCompletionOptions | bool) -> types.InlineCompletionOptions | bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_completion_provider.work_done_progress'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['inline_completion_provider.work_done_progress'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace'], default: None = None) -> types.WorkspaceOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace'], default: types.WorkspaceOptions) -> types.WorkspaceOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.workspace_folders'], default: None = None) -> types.WorkspaceFoldersServerCapabilities | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.workspace_folders'], default: types.WorkspaceFoldersServerCapabilities) -> types.WorkspaceFoldersServerCapabilities: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.workspace_folders.supported'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.workspace_folders.supported'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.workspace_folders.change_notifications'], default: None = None) -> bool | None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.workspace_folders.change_notifications'], default: bool | str) -> bool | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations'], default: None = None) -> types.FileOperationOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations'], default: types.FileOperationOptions) -> types.FileOperationOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create'], default: None = None) -> types.FileOperationRegistrationOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create'], default: types.FileOperationRegistrationOptions) -> types.FileOperationRegistrationOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters'], default: None = None) -> types.FileOperationFilter | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters'], default: types.FileOperationFilter) -> types.FileOperationFilter: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.pattern'], default: None = None) -> types.FileOperationPattern | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.pattern'], default: types.FileOperationPattern) -> types.FileOperationPattern: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.pattern.glob'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.pattern.glob'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.pattern.matches'], default: None = None) -> types.FileOperationPatternKind | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.pattern.matches'], default: types.FileOperationPatternKind) -> types.FileOperationPatternKind: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.pattern.options'], default: None = None) -> types.FileOperationPatternOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.pattern.options'], default: types.FileOperationPatternOptions) -> types.FileOperationPatternOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.pattern.options.ignore_case'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.pattern.options.ignore_case'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.scheme'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_create.filters.scheme'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create'], default: None = None) -> types.FileOperationRegistrationOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create'], default: types.FileOperationRegistrationOptions) -> types.FileOperationRegistrationOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters'], default: None = None) -> types.FileOperationFilter | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters'], default: types.FileOperationFilter) -> types.FileOperationFilter: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.pattern'], default: None = None) -> types.FileOperationPattern | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.pattern'], default: types.FileOperationPattern) -> types.FileOperationPattern: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.pattern.glob'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.pattern.glob'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.pattern.matches'], default: None = None) -> types.FileOperationPatternKind | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.pattern.matches'], default: types.FileOperationPatternKind) -> types.FileOperationPatternKind: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.pattern.options'], default: None = None) -> types.FileOperationPatternOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.pattern.options'], default: types.FileOperationPatternOptions) -> types.FileOperationPatternOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.pattern.options.ignore_case'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.pattern.options.ignore_case'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.scheme'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_create.filters.scheme'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename'], default: None = None) -> types.FileOperationRegistrationOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename'], default: types.FileOperationRegistrationOptions) -> types.FileOperationRegistrationOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters'], default: None = None) -> types.FileOperationFilter | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters'], default: types.FileOperationFilter) -> types.FileOperationFilter: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.pattern'], default: None = None) -> types.FileOperationPattern | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.pattern'], default: types.FileOperationPattern) -> types.FileOperationPattern: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.pattern.glob'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.pattern.glob'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.pattern.matches'], default: None = None) -> types.FileOperationPatternKind | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.pattern.matches'], default: types.FileOperationPatternKind) -> types.FileOperationPatternKind: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.pattern.options'], default: None = None) -> types.FileOperationPatternOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.pattern.options'], default: types.FileOperationPatternOptions) -> types.FileOperationPatternOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.pattern.options.ignore_case'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.pattern.options.ignore_case'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.scheme'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_rename.filters.scheme'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename'], default: None = None) -> types.FileOperationRegistrationOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename'], default: types.FileOperationRegistrationOptions) -> types.FileOperationRegistrationOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters'], default: None = None) -> types.FileOperationFilter | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters'], default: types.FileOperationFilter) -> types.FileOperationFilter: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.pattern'], default: None = None) -> types.FileOperationPattern | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.pattern'], default: types.FileOperationPattern) -> types.FileOperationPattern: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.pattern.glob'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.pattern.glob'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.pattern.matches'], default: None = None) -> types.FileOperationPatternKind | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.pattern.matches'], default: types.FileOperationPatternKind) -> types.FileOperationPatternKind: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.pattern.options'], default: None = None) -> types.FileOperationPatternOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.pattern.options'], default: types.FileOperationPatternOptions) -> types.FileOperationPatternOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.pattern.options.ignore_case'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.pattern.options.ignore_case'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.scheme'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_rename.filters.scheme'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete'], default: None = None) -> types.FileOperationRegistrationOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete'], default: types.FileOperationRegistrationOptions) -> types.FileOperationRegistrationOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters'], default: None = None) -> types.FileOperationFilter | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters'], default: types.FileOperationFilter) -> types.FileOperationFilter: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.pattern'], default: None = None) -> types.FileOperationPattern | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.pattern'], default: types.FileOperationPattern) -> types.FileOperationPattern: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.pattern.glob'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.pattern.glob'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.pattern.matches'], default: None = None) -> types.FileOperationPatternKind | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.pattern.matches'], default: types.FileOperationPatternKind) -> types.FileOperationPatternKind: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.pattern.options'], default: None = None) -> types.FileOperationPatternOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.pattern.options'], default: types.FileOperationPatternOptions) -> types.FileOperationPatternOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.pattern.options.ignore_case'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.pattern.options.ignore_case'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.scheme'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.did_delete.filters.scheme'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete'], default: None = None) -> types.FileOperationRegistrationOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete'], default: types.FileOperationRegistrationOptions) -> types.FileOperationRegistrationOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters'], default: None = None) -> types.FileOperationFilter | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters'], default: types.FileOperationFilter) -> types.FileOperationFilter: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.pattern'], default: None = None) -> types.FileOperationPattern | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.pattern'], default: types.FileOperationPattern) -> types.FileOperationPattern: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.pattern.glob'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.pattern.glob'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.pattern.matches'], default: None = None) -> types.FileOperationPatternKind | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.pattern.matches'], default: types.FileOperationPatternKind) -> types.FileOperationPatternKind: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.pattern.options'], default: None = None) -> types.FileOperationPatternOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.pattern.options'], default: types.FileOperationPatternOptions) -> types.FileOperationPatternOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.pattern.options.ignore_case'], default: None = None) -> bool | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.pattern.options.ignore_case'], default: bool) -> bool: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.scheme'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.file_operations.will_delete.filters.scheme'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.text_document_content'], default: None = None) -> types.TextDocumentContentRegistrationOptions | types.TextDocumentContentOptions | None: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.text_document_content'], default: types.TextDocumentContentRegistrationOptions | types.TextDocumentContentOptions) -> types.TextDocumentContentRegistrationOptions | types.TextDocumentContentOptions: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.text_document_content.schemes'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.text_document_content.schemes'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.text_document_content.id'], default: None = None) -> None | str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['workspace.text_document_content.id'], default: str) -> str: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['experimental'], default: None = None) -> None | Any: ...
@typing.overload
def get_capability(capabilities: types.ServerCapabilities, field: Literal['experimental'], default: Any) -> Any: ...
@typing.overload
def get_capability(capabilities: Any, field: str, default: Any | None = None) -> Any | None: ...
def get_capability(capabilities, field, default = None):
    """Return the value of some nested capability with a fallback value to use in the
       case where it does not exist."""
    try:
        value = reduce(getattr, field.split("."), capabilities)
    except AttributeError:
        return default

    return value if value is not None else default
