/* tslint:disable */
/* eslint-disable */
/**
 * Kallichore API
 * Kallichore is a Jupyter kernel gateway and supervisor
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: info@posit.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from './configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from './common';
import type { RequestArgs } from './base';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, BaseAPI, RequiredError, operationServerMap } from './base';

/**
 * 
 * @export
 * @interface ActiveSession
 */
export interface ActiveSession {
    /**
     * A unique identifier for the session
     * @type {string}
     * @memberof ActiveSession
     */
    'session_id': string;
    /**
     * The program and command-line parameters for the session
     * @type {Array<string>}
     * @memberof ActiveSession
     */
    'argv': Array<string>;
    /**
     * The underlying process ID of the session, if the session is running.
     * @type {number}
     * @memberof ActiveSession
     */
    'process_id'?: number;
    /**
     * The username of the user who owns the session
     * @type {string}
     * @memberof ActiveSession
     */
    'username': string;
    /**
     * A human-readable name for the session
     * @type {string}
     * @memberof ActiveSession
     */
    'display_name': string;
    /**
     * The interpreter language
     * @type {string}
     * @memberof ActiveSession
     */
    'language': string;
    /**
     * 
     * @type {InterruptMode}
     * @memberof ActiveSession
     */
    'interrupt_mode': InterruptMode;
    /**
     * The environment variables set when the session was started
     * @type {{ [key: string]: string; }}
     * @memberof ActiveSession
     */
    'initial_env'?: { [key: string]: string; };
    /**
     * Whether the session is connected to a client
     * @type {boolean}
     * @memberof ActiveSession
     */
    'connected': boolean;
    /**
     * An ISO 8601 timestamp of when the session was started
     * @type {string}
     * @memberof ActiveSession
     */
    'started': string;
    /**
     * The session\'s current working directory
     * @type {string}
     * @memberof ActiveSession
     */
    'working_directory': string;
    /**
     * The text to use to prompt for input
     * @type {string}
     * @memberof ActiveSession
     */
    'input_prompt': string;
    /**
     * The text to use to prompt for input continuations
     * @type {string}
     * @memberof ActiveSession
     */
    'continuation_prompt': string;
    /**
     * 
     * @type {ExecutionQueue}
     * @memberof ActiveSession
     */
    'execution_queue': ExecutionQueue;
    /**
     * 
     * @type {Status}
     * @memberof ActiveSession
     */
    'status': Status;
    /**
     * The kernel information, as returned by the kernel_info_request message
     * @type {object}
     * @memberof ActiveSession
     */
    'kernel_info': object;
    /**
     * The number of seconds the session has been idle, or 0 if the session is busy
     * @type {number}
     * @memberof ActiveSession
     */
    'idle_seconds': number;
    /**
     * The number of seconds the session has been busy, or 0 if the session is idle
     * @type {number}
     * @memberof ActiveSession
     */
    'busy_seconds': number;
    /**
     * The path to the Unix domain socket used to send/receive data from the session, if applicable
     * @type {string}
     * @memberof ActiveSession
     */
    'socket_path'?: string;
}


/**
 * 
 * @export
 * @interface ClientHeartbeat
 */
export interface ClientHeartbeat {
    /**
     * The process ID of the client sending the heartbeat
     * @type {number}
     * @memberof ClientHeartbeat
     */
    'process_id'?: number;
}
/**
 * Connection information for an existing session
 * @export
 * @interface ConnectionInfo
 */
export interface ConnectionInfo {
    /**
     * The port for control messages
     * @type {number}
     * @memberof ConnectionInfo
     */
    'control_port': number;
    /**
     * The port for shell messages
     * @type {number}
     * @memberof ConnectionInfo
     */
    'shell_port': number;
    /**
     * The port for stdin messages
     * @type {number}
     * @memberof ConnectionInfo
     */
    'stdin_port': number;
    /**
     * The port for heartbeat messages
     * @type {number}
     * @memberof ConnectionInfo
     */
    'hb_port': number;
    /**
     * The port for IOPub messages
     * @type {number}
     * @memberof ConnectionInfo
     */
    'iopub_port': number;
    /**
     * The signature scheme for messages
     * @type {string}
     * @memberof ConnectionInfo
     */
    'signature_scheme': string;
    /**
     * The key for messages
     * @type {string}
     * @memberof ConnectionInfo
     */
    'key': string;
    /**
     * The transport protocol
     * @type {string}
     * @memberof ConnectionInfo
     */
    'transport': string;
    /**
     * The IP address for the connection
     * @type {string}
     * @memberof ConnectionInfo
     */
    'ip': string;
}
/**
 * The execution queue for a session
 * @export
 * @interface ExecutionQueue
 */
export interface ExecutionQueue {
    /**
     * The execution request currently being evaluated, if any
     * @type {object}
     * @memberof ExecutionQueue
     */
    'active'?: object;
    /**
     * The number of items in the pending queue
     * @type {number}
     * @memberof ExecutionQueue
     */
    'length': number;
    /**
     * The queue of pending execution requests
     * @type {Array<object>}
     * @memberof ExecutionQueue
     */
    'pending': Array<object>;
}
/**
 * The mechansim for interrupting the session
 * @export
 * @enum {string}
 */

export const InterruptMode = {
    Signal: 'signal',
    Message: 'message'
} as const;

export type InterruptMode = typeof InterruptMode[keyof typeof InterruptMode];


/**
 * 
 * @export
 * @interface ModelError
 */
export interface ModelError {
    /**
     * 
     * @type {string}
     * @memberof ModelError
     */
    'code': string;
    /**
     * 
     * @type {string}
     * @memberof ModelError
     */
    'message': string;
    /**
     * 
     * @type {string}
     * @memberof ModelError
     */
    'details'?: string;
}
/**
 * 
 * @export
 * @interface NewSession
 */
export interface NewSession {
    /**
     * A unique identifier for the session
     * @type {string}
     * @memberof NewSession
     */
    'session_id': string;
    /**
     * A human-readable name for the session
     * @type {string}
     * @memberof NewSession
     */
    'display_name': string;
    /**
     * The interpreter language
     * @type {string}
     * @memberof NewSession
     */
    'language': string;
    /**
     * The username of the user who owns the session
     * @type {string}
     * @memberof NewSession
     */
    'username': string;
    /**
     * The text to use to prompt for input
     * @type {string}
     * @memberof NewSession
     */
    'input_prompt': string;
    /**
     * The text to use to prompt for input continuations
     * @type {string}
     * @memberof NewSession
     */
    'continuation_prompt': string;
    /**
     * The program and command-line parameters for the session
     * @type {Array<string>}
     * @memberof NewSession
     */
    'argv': Array<string>;
    /**
     * The working directory in which to start the session.
     * @type {string}
     * @memberof NewSession
     */
    'working_directory': string;
    /**
     * A list of environment variable actions to perform
     * @type {Array<VarAction>}
     * @memberof NewSession
     */
    'env': Array<VarAction>;
    /**
     * The number of seconds to wait for a connection to the session\'s ZeroMQ sockets before timing out
     * @type {number}
     * @memberof NewSession
     */
    'connection_timeout'?: number;
    /**
     * 
     * @type {InterruptMode}
     * @memberof NewSession
     */
    'interrupt_mode': InterruptMode;
    /**
     * The Jupyter protocol version supported by the underlying kernel
     * @type {string}
     * @memberof NewSession
     */
    'protocol_version'?: string;
    /**
     * Whether to run the session inside a login shell; only relevant on POSIX systems
     * @type {boolean}
     * @memberof NewSession
     */
    'run_in_shell'?: boolean;
}


/**
 * 
 * @export
 * @interface NewSession200Response
 */
export interface NewSession200Response {
    /**
     * A unique identifier for the session
     * @type {string}
     * @memberof NewSession200Response
     */
    'session_id': string;
}
/**
 * 
 * @export
 * @interface RestartSession
 */
export interface RestartSession {
    /**
     * The desired working directory for the session after restart, if different from the session\'s working directory at startup
     * @type {string}
     * @memberof RestartSession
     */
    'working_directory'?: string;
    /**
     * A list of environment variable actions to perform
     * @type {Array<VarAction>}
     * @memberof RestartSession
     */
    'env'?: Array<VarAction>;
}
/**
 * 
 * @export
 * @interface ServerConfiguration
 */
export interface ServerConfiguration {
    /**
     * The number of hours the server will wait before shutting down idle sessions (-1 if idle shutdown is disabled)
     * @type {number}
     * @memberof ServerConfiguration
     */
    'idle_shutdown_hours'?: number;
    /**
     * The current log level
     * @type {string}
     * @memberof ServerConfiguration
     */
    'log_level'?: ServerConfigurationLogLevelEnum;
}

export const ServerConfigurationLogLevelEnum = {
    Trace: 'trace',
    Debug: 'debug',
    Info: 'info',
    Warn: 'warn',
    Error: 'error'
} as const;

export type ServerConfigurationLogLevelEnum = typeof ServerConfigurationLogLevelEnum[keyof typeof ServerConfigurationLogLevelEnum];

/**
 * 
 * @export
 * @interface ServerStatus
 */
export interface ServerStatus {
    /**
     * 
     * @type {number}
     * @memberof ServerStatus
     */
    'sessions': number;
    /**
     * 
     * @type {number}
     * @memberof ServerStatus
     */
    'active': number;
    /**
     * 
     * @type {boolean}
     * @memberof ServerStatus
     */
    'busy': boolean;
    /**
     * The number of seconds all sessions have been idle, or 0 if any session is busy
     * @type {number}
     * @memberof ServerStatus
     */
    'idle_seconds': number;
    /**
     * The number of seconds any session has been busy, or 0 if all sessions are idle
     * @type {number}
     * @memberof ServerStatus
     */
    'busy_seconds': number;
    /**
     * The version of the server
     * @type {string}
     * @memberof ServerStatus
     */
    'version': string;
    /**
     * The server\'s operating system process identifier
     * @type {number}
     * @memberof ServerStatus
     */
    'process_id': number;
}
/**
 * 
 * @export
 * @interface SessionList
 */
export interface SessionList {
    /**
     * 
     * @type {number}
     * @memberof SessionList
     */
    'total': number;
    /**
     * 
     * @type {Array<ActiveSession>}
     * @memberof SessionList
     */
    'sessions': Array<ActiveSession>;
}
/**
 * 
 * @export
 * @interface StartupError
 */
export interface StartupError {
    /**
     * The exit code of the process, if it exited
     * @type {number}
     * @memberof StartupError
     */
    'exit_code'?: number;
    /**
     * The output of the process (combined stdout and stderr) emitted during startup, if any
     * @type {string}
     * @memberof StartupError
     */
    'output'?: string;
    /**
     * 
     * @type {ModelError}
     * @memberof StartupError
     */
    'error': ModelError;
}
/**
 * The status of the session
 * @export
 * @enum {string}
 */

export const Status = {
    Uninitialized: 'uninitialized',
    Starting: 'starting',
    Ready: 'ready',
    Idle: 'idle',
    Busy: 'busy',
    Offline: 'offline',
    Exited: 'exited'
} as const;

export type Status = typeof Status[keyof typeof Status];


/**
 * 
 * @export
 * @interface VarAction
 */
export interface VarAction {
    /**
     * 
     * @type {VarActionType}
     * @memberof VarAction
     */
    'action': VarActionType;
    /**
     * The name of the variable to act on
     * @type {string}
     * @memberof VarAction
     */
    'name': string;
    /**
     * The value to replace, append, or prepend
     * @type {string}
     * @memberof VarAction
     */
    'value': string;
}


/**
 * The type of action to perform on the environment variable
 * @export
 * @enum {string}
 */

export const VarActionType = {
    Replace: 'replace',
    Append: 'append',
    Prepend: 'prepend'
} as const;

export type VarActionType = typeof VarActionType[keyof typeof VarActionType];



/**
 * DefaultApi - axios parameter creator
 * @export
 */
export const DefaultApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * 
         * @summary Adopt an existing session
         * @param {string} sessionId 
         * @param {ConnectionInfo} connectionInfo 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        adoptSession: async (sessionId: string, connectionInfo: ConnectionInfo, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('adoptSession', 'sessionId', sessionId)
            // verify required parameter 'connectionInfo' is not null or undefined
            assertParamExists('adoptSession', 'connectionInfo', connectionInfo)
            const localVarPath = `/sessions/{session_id}/adopt`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(connectionInfo, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Upgrade to a WebSocket or domain socket for channel communication
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        channelsUpgrade: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('channelsUpgrade', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/channels`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Notify the server that a client is connected
         * @param {ClientHeartbeat} clientHeartbeat 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        clientHeartbeat: async (clientHeartbeat: ClientHeartbeat, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'clientHeartbeat' is not null or undefined
            assertParamExists('clientHeartbeat', 'clientHeartbeat', clientHeartbeat)
            const localVarPath = `/client_heartbeat`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(clientHeartbeat, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Get Jupyter connection information for the session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        connectionInfo: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('connectionInfo', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/connection_info`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Delete session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteSession: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('deleteSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Get the server configuration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getServerConfiguration: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/server_configuration`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Get session details
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getSession: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('getSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Interrupt session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        interruptSession: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('interruptSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/interrupt`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Force quit session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        killSession: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('killSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/kill`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary List active sessions
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSessions: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/sessions`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Create a new session
         * @param {NewSession} newSession 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        newSession: async (newSession: NewSession, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'newSession' is not null or undefined
            assertParamExists('newSession', 'newSession', newSession)
            const localVarPath = `/sessions`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(newSession, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Restart a session
         * @param {string} sessionId 
         * @param {RestartSession} [restartSession] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        restartSession: async (sessionId: string, restartSession?: RestartSession, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('restartSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/restart`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(restartSession, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Get server status and information
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        serverStatus: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/status`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Change the server configuration
         * @param {ServerConfiguration} serverConfiguration 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        setServerConfiguration: async (serverConfiguration: ServerConfiguration, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'serverConfiguration' is not null or undefined
            assertParamExists('setServerConfiguration', 'serverConfiguration', serverConfiguration)
            const localVarPath = `/server_configuration`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(serverConfiguration, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Shut down all sessions and the server itself
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        shutdownServer: async (options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            const localVarPath = `/shutdown`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * 
         * @summary Start a session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        startSession: async (sessionId: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'sessionId' is not null or undefined
            assertParamExists('startSession', 'sessionId', sessionId)
            const localVarPath = `/sessions/{session_id}/start`
                .replace(`{${"session_id"}}`, encodeURIComponent(String(sessionId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * DefaultApi - functional programming interface
 * @export
 */
export const DefaultApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = DefaultApiAxiosParamCreator(configuration)
    return {
        /**
         * 
         * @summary Adopt an existing session
         * @param {string} sessionId 
         * @param {ConnectionInfo} connectionInfo 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async adoptSession(sessionId: string, connectionInfo: ConnectionInfo, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.adoptSession(sessionId, connectionInfo, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.adoptSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Upgrade to a WebSocket or domain socket for channel communication
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async channelsUpgrade(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<string>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.channelsUpgrade(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.channelsUpgrade']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Notify the server that a client is connected
         * @param {ClientHeartbeat} clientHeartbeat 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async clientHeartbeat(clientHeartbeat: ClientHeartbeat, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.clientHeartbeat(clientHeartbeat, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.clientHeartbeat']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Get Jupyter connection information for the session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async connectionInfo(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ConnectionInfo>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.connectionInfo(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.connectionInfo']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Delete session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteSession(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteSession(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.deleteSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Get the server configuration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getServerConfiguration(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ServerConfiguration>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getServerConfiguration(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.getServerConfiguration']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Get session details
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getSession(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ActiveSession>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getSession(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.getSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Interrupt session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async interruptSession(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.interruptSession(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.interruptSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Force quit session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async killSession(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.killSession(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.killSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary List active sessions
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async listSessions(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SessionList>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.listSessions(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.listSessions']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Create a new session
         * @param {NewSession} newSession 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async newSession(newSession: NewSession, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<NewSession200Response>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.newSession(newSession, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.newSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Restart a session
         * @param {string} sessionId 
         * @param {RestartSession} [restartSession] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async restartSession(sessionId: string, restartSession?: RestartSession, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.restartSession(sessionId, restartSession, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.restartSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Get server status and information
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async serverStatus(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ServerStatus>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.serverStatus(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.serverStatus']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Change the server configuration
         * @param {ServerConfiguration} serverConfiguration 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async setServerConfiguration(serverConfiguration: ServerConfiguration, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.setServerConfiguration(serverConfiguration, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.setServerConfiguration']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Shut down all sessions and the server itself
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async shutdownServer(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.shutdownServer(options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.shutdownServer']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * 
         * @summary Start a session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async startSession(sessionId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<any>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.startSession(sessionId, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['DefaultApi.startSession']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * DefaultApi - factory interface
 * @export
 */
export const DefaultApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = DefaultApiFp(configuration)
    return {
        /**
         * 
         * @summary Adopt an existing session
         * @param {string} sessionId 
         * @param {ConnectionInfo} connectionInfo 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        adoptSession(sessionId: string, connectionInfo: ConnectionInfo, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.adoptSession(sessionId, connectionInfo, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Upgrade to a WebSocket or domain socket for channel communication
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        channelsUpgrade(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<string> {
            return localVarFp.channelsUpgrade(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Notify the server that a client is connected
         * @param {ClientHeartbeat} clientHeartbeat 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        clientHeartbeat(clientHeartbeat: ClientHeartbeat, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.clientHeartbeat(clientHeartbeat, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Get Jupyter connection information for the session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        connectionInfo(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<ConnectionInfo> {
            return localVarFp.connectionInfo(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Delete session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteSession(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.deleteSession(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Get the server configuration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getServerConfiguration(options?: RawAxiosRequestConfig): AxiosPromise<ServerConfiguration> {
            return localVarFp.getServerConfiguration(options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Get session details
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getSession(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<ActiveSession> {
            return localVarFp.getSession(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Interrupt session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        interruptSession(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.interruptSession(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Force quit session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        killSession(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.killSession(sessionId, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary List active sessions
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listSessions(options?: RawAxiosRequestConfig): AxiosPromise<SessionList> {
            return localVarFp.listSessions(options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Create a new session
         * @param {NewSession} newSession 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        newSession(newSession: NewSession, options?: RawAxiosRequestConfig): AxiosPromise<NewSession200Response> {
            return localVarFp.newSession(newSession, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Restart a session
         * @param {string} sessionId 
         * @param {RestartSession} [restartSession] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        restartSession(sessionId: string, restartSession?: RestartSession, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.restartSession(sessionId, restartSession, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Get server status and information
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        serverStatus(options?: RawAxiosRequestConfig): AxiosPromise<ServerStatus> {
            return localVarFp.serverStatus(options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Change the server configuration
         * @param {ServerConfiguration} serverConfiguration 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        setServerConfiguration(serverConfiguration: ServerConfiguration, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.setServerConfiguration(serverConfiguration, options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Shut down all sessions and the server itself
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        shutdownServer(options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.shutdownServer(options).then((request) => request(axios, basePath));
        },
        /**
         * 
         * @summary Start a session
         * @param {string} sessionId 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        startSession(sessionId: string, options?: RawAxiosRequestConfig): AxiosPromise<any> {
            return localVarFp.startSession(sessionId, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * DefaultApi - object-oriented interface
 * @export
 * @class DefaultApi
 * @extends {BaseAPI}
 */
export class DefaultApi extends BaseAPI {
    /**
     * 
     * @summary Adopt an existing session
     * @param {string} sessionId 
     * @param {ConnectionInfo} connectionInfo 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public adoptSession(sessionId: string, connectionInfo: ConnectionInfo, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).adoptSession(sessionId, connectionInfo, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Upgrade to a WebSocket or domain socket for channel communication
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public channelsUpgrade(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).channelsUpgrade(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Notify the server that a client is connected
     * @param {ClientHeartbeat} clientHeartbeat 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public clientHeartbeat(clientHeartbeat: ClientHeartbeat, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).clientHeartbeat(clientHeartbeat, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Get Jupyter connection information for the session
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public connectionInfo(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).connectionInfo(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Delete session
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public deleteSession(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).deleteSession(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Get the server configuration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public getServerConfiguration(options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).getServerConfiguration(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Get session details
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public getSession(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).getSession(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Interrupt session
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public interruptSession(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).interruptSession(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Force quit session
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public killSession(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).killSession(sessionId, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary List active sessions
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public listSessions(options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).listSessions(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Create a new session
     * @param {NewSession} newSession 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public newSession(newSession: NewSession, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).newSession(newSession, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Restart a session
     * @param {string} sessionId 
     * @param {RestartSession} [restartSession] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public restartSession(sessionId: string, restartSession?: RestartSession, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).restartSession(sessionId, restartSession, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Get server status and information
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public serverStatus(options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).serverStatus(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Change the server configuration
     * @param {ServerConfiguration} serverConfiguration 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public setServerConfiguration(serverConfiguration: ServerConfiguration, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).setServerConfiguration(serverConfiguration, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Shut down all sessions and the server itself
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public shutdownServer(options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).shutdownServer(options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * 
     * @summary Start a session
     * @param {string} sessionId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    public startSession(sessionId: string, options?: RawAxiosRequestConfig) {
        return DefaultApiFp(this.configuration).startSession(sessionId, options).then((request) => request(this.axios, this.basePath));
    }
}



