"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const languages_1 = require("../languages");
const validScriptPaths = [
    '/path/to/code.R',
    '/path/to/code.r',
    '/path/to/code.Py',
    '/path/to/code.pY',
    '/path/to/code.py',
];
const invalidScriptPaths = [
    '/path/to/code.aR',
    '/path/to/code.sh',
    '/path/to/code.pi',
    '/path/to/code',
    '/path/to/code.InB',
    '/path/to/code.ipyn',
    '/path/to/code.md',
    '/path/to/code.IpYnB',
    '/path/to/code.ipynb',
    '/path/to/code.Qmd',
    '/path/to/code.qmd',
    '/path/to/code.Rmd',
    '/path/to/code.rmd'
];
test('test valid script acceptance', () => {
    for (const path of validScriptPaths) {
        expect((0, languages_1.validScriptExtension)(path)).toBe(true);
    }
});
test('test invalid script rejection', () => {
    for (const path of invalidScriptPaths) {
        expect((0, languages_1.validScriptExtension)(path)).toBe(false);
    }
});
test('test valid filetype detection', () => {
    // tests both detectFileType() AND extension() in languages.ts
    for (const path of validScriptPaths) {
        expect((0, languages_1.detectFileType)(path)).not.toBe(undefined);
    }
});
test('test invalid filetypes', () => {
    for (const path of invalidScriptPaths) {
        expect((0, languages_1.detectFileType)(path)).toBe(undefined);
    }
});
test.each([
    '/path/to/code.R',
    '/path/to/code.r',
    '/path/to/code.Py',
    '/path/to/code.pY',
    '/path/to/code.py',
    '/path/to/code.aR',
    '/path/to/code.sh',
    '/path/to/code.pi',
    '/path/to/code.InB',
    '/path/to/code.ipyn',
    '/path/to/code.md',
    '/path/to/code.IpYnB',
    '/path/to/code.ipynb',
    '/path/to/code.Qmd',
    '/path/to/code.qmd',
    '/path/to/code.Rmd',
    '/path/to/code.rmd'
])('extract script names for path: %s', (path) => {
    expect((0, languages_1.getScriptName)(path)).toBe('code');
});
test.each([
    '',
    '/path/to/code'
])('extract script name for path %s triggers fallback to `New Workbench Job`', (path) => {
    expect((0, languages_1.getScriptName)(path)).toBe('New Workbench Job');
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFuZ3VhZ2VzLnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvdGVzdHMvbGFuZ3VhZ2VzLnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSw0Q0FBbUY7QUFFbkYsTUFBTSxnQkFBZ0IsR0FBRztJQUN2QixpQkFBaUI7SUFDakIsaUJBQWlCO0lBQ2pCLGtCQUFrQjtJQUNsQixrQkFBa0I7SUFDbEIsa0JBQWtCO0NBQ25CLENBQUM7QUFFRixNQUFNLGtCQUFrQixHQUFHO0lBQ3pCLGtCQUFrQjtJQUNsQixrQkFBa0I7SUFDbEIsa0JBQWtCO0lBQ2xCLGVBQWU7SUFDZixtQkFBbUI7SUFDbkIsb0JBQW9CO0lBQ3BCLGtCQUFrQjtJQUNsQixxQkFBcUI7SUFDckIscUJBQXFCO0lBQ3JCLG1CQUFtQjtJQUNuQixtQkFBbUI7SUFDbkIsbUJBQW1CO0lBQ25CLG1CQUFtQjtDQUNwQixDQUFDO0FBR0YsSUFBSSxDQUFDLDhCQUE4QixFQUFFLEdBQUcsRUFBRTtJQUV4QyxLQUFLLE1BQU0sSUFBSSxJQUFJLGdCQUFnQixFQUFFLENBQUM7UUFDcEMsTUFBTSxDQUFDLElBQUEsZ0NBQW9CLEVBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDaEQsQ0FBQztBQUNILENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLCtCQUErQixFQUFFLEdBQUcsRUFBRTtJQUV6QyxLQUFLLE1BQU0sSUFBSSxJQUFJLGtCQUFrQixFQUFFLENBQUM7UUFDdEMsTUFBTSxDQUFDLElBQUEsZ0NBQW9CLEVBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDakQsQ0FBQztBQUNILENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLCtCQUErQixFQUFFLEdBQUcsRUFBRTtJQUV6Qyw4REFBOEQ7SUFDOUQsS0FBSyxNQUFNLElBQUksSUFBSSxnQkFBZ0IsRUFBRSxDQUFDO1FBQ3BDLE1BQU0sQ0FBQyxJQUFBLDBCQUFjLEVBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ25ELENBQUM7QUFDSCxDQUFDLENBQUMsQ0FBQztBQUVILElBQUksQ0FBQyx3QkFBd0IsRUFBRSxHQUFHLEVBQUU7SUFFbEMsS0FBSyxNQUFNLElBQUksSUFBSSxrQkFBa0IsRUFBRSxDQUFDO1FBQ3RDLE1BQU0sQ0FBQyxJQUFBLDBCQUFjLEVBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDL0MsQ0FBQztBQUNILENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLElBQUksQ0FBQztJQUNSLGlCQUFpQjtJQUNqQixpQkFBaUI7SUFDakIsa0JBQWtCO0lBQ2xCLGtCQUFrQjtJQUNsQixrQkFBa0I7SUFDbEIsa0JBQWtCO0lBQ2xCLGtCQUFrQjtJQUNsQixrQkFBa0I7SUFDbEIsbUJBQW1CO0lBQ25CLG9CQUFvQjtJQUNwQixrQkFBa0I7SUFDbEIscUJBQXFCO0lBQ3JCLHFCQUFxQjtJQUNyQixtQkFBbUI7SUFDbkIsbUJBQW1CO0lBQ25CLG1CQUFtQjtJQUNuQixtQkFBbUI7Q0FDcEIsQ0FBQyxDQUFDLG1DQUFtQyxFQUFFLENBQUMsSUFBSSxFQUFFLEVBQUU7SUFDL0MsTUFBTSxDQUFDLElBQUEseUJBQWEsRUFBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztBQUMzQyxDQUFDLENBQUMsQ0FBQztBQUVILElBQUksQ0FBQyxJQUFJLENBQUM7SUFDUixFQUFFO0lBQ0YsZUFBZTtDQUNoQixDQUFDLENBQUMsMEVBQTBFLEVBQUUsQ0FBQyxJQUFJLEVBQUUsRUFBRTtJQUN0RixNQUFNLENBQUMsSUFBQSx5QkFBYSxFQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLENBQUM7QUFDeEQsQ0FBQyxDQUFDLENBQUMifQ==