"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const https_1 = require("https");
const crl_validator_1 = require("./crl_validator");
// TODO: when OCSP is removed, rename to HttpsAgent
class HttpsCrlAgent extends https_1.Agent {
    crlValidatorConfig;
    constructor(opts) {
        const { crlValidatorConfig, ...agentOptions } = opts;
        super(agentOptions);
        this.crlValidatorConfig = crlValidatorConfig;
    }
    createConnection(...args) {
        const createConnection = https_1.Agent.prototype.createConnection;
        const socket = createConnection.apply(this, args);
        (0, crl_validator_1.corkSocketAndValidateCrl)(socket, this.crlValidatorConfig);
        return socket;
    }
}
exports.default = HttpsCrlAgent;
//# sourceMappingURL=https_crl_agent.js.map