// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * An abstract interface which when implemented provides an interface to read
 * bytes into an array buffer asynchronously.
 */ export var SeekMode;
(function(SeekMode) {
  /* Seek from the start of the file/resource. */ SeekMode[SeekMode["Start"] = 0] = "Start";
  /* Seek from the current position within the file/resource. */ SeekMode[SeekMode["Current"] = 1] = "Current";
  /* Seek from the end of the current file/resource. */ SeekMode[SeekMode["End"] = 2] = "End";
})(SeekMode || (SeekMode = {}));
//# sourceMappingURL=data:application/json;base64,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