"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_AZURE_ENTRA_ID_RESOURCE = void 0;
exports.getAzureAttestationToken = getAzureAttestationToken;
const identity_1 = require("@azure/identity");
const logger_1 = __importDefault(require("../../logger"));
exports.DEFAULT_AZURE_ENTRA_ID_RESOURCE = 'api://fd3f753b-eed3-462c-b6a7-a4b5bb650aad';
async function getAzureAttestationToken(options = {}) {
    const credential = new identity_1.DefaultAzureCredential({
        managedIdentityClientId: options.managedIdentityClientId,
    });
    (0, logger_1.default)().debug('Getting Azure auth token');
    const token = await credential.getToken(options.entraIdResource ?? exports.DEFAULT_AZURE_ENTRA_ID_RESOURCE);
    return token.token;
}
//# sourceMappingURL=attestation_azure.js.map