// Ported from js-yaml v3.13.1:
// https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da
// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
import { isPlainObject } from "../_utils.ts";
function resolveYamlPairs(data) {
  if (data === null) return true;
  return data.every((it)=>isPlainObject(it) && Object.keys(it).length === 1);
}
export const pairs = {
  tag: "tag:yaml.org,2002:pairs",
  construct (data) {
    // Converts an array of objects into an array of key-value pairs.
    return data?.flatMap(Object.entries) ?? [];
  },
  kind: "sequence",
  resolve: resolveYamlPairs
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vanNyLmlvL0BzdGQveWFtbC8xLjAuNS9fdHlwZS9wYWlycy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBQb3J0ZWQgZnJvbSBqcy15YW1sIHYzLjEzLjE6XG4vLyBodHRwczovL2dpdGh1Yi5jb20vbm9kZWNhL2pzLXlhbWwvY29tbWl0LzY2NWFhZGRhNDIzNDlkY2FlODY5ZjEyMDQwZDliMTBlZjE4ZDEyZGFcbi8vIENvcHlyaWdodCAyMDExLTIwMTUgYnkgVml0YWx5IFB1enJpbi4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG4vLyBDb3B5cmlnaHQgMjAxOC0yMDI0IHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuXG5pbXBvcnQgdHlwZSB7IFR5cGUgfSBmcm9tIFwiLi4vX3R5cGUudHNcIjtcbmltcG9ydCB7IGlzUGxhaW5PYmplY3QgfSBmcm9tIFwiLi4vX3V0aWxzLnRzXCI7XG5cbmZ1bmN0aW9uIHJlc29sdmVZYW1sUGFpcnMoZGF0YTogdW5rbm93bltdW10pOiBib29sZWFuIHtcbiAgaWYgKGRhdGEgPT09IG51bGwpIHJldHVybiB0cnVlO1xuICByZXR1cm4gZGF0YS5ldmVyeSgoaXQpID0+IGlzUGxhaW5PYmplY3QoaXQpICYmIE9iamVjdC5rZXlzKGl0KS5sZW5ndGggPT09IDEpO1xufVxuXG5leHBvcnQgY29uc3QgcGFpcnM6IFR5cGU8XCJzZXF1ZW5jZVwiPiA9IHtcbiAgdGFnOiBcInRhZzp5YW1sLm9yZywyMDAyOnBhaXJzXCIsXG4gIGNvbnN0cnVjdChkYXRhOiBSZWNvcmQ8c3RyaW5nLCB1bmtub3duPltdIHwgbnVsbCk6IFtzdHJpbmcsIHVua25vd25dW10ge1xuICAgIC8vIENvbnZlcnRzIGFuIGFycmF5IG9mIG9iamVjdHMgaW50byBhbiBhcnJheSBvZiBrZXktdmFsdWUgcGFpcnMuXG4gICAgcmV0dXJuIGRhdGE/LmZsYXRNYXAoT2JqZWN0LmVudHJpZXMpID8/IFtdO1xuICB9LFxuICBraW5kOiBcInNlcXVlbmNlXCIsXG4gIHJlc29sdmU6IHJlc29sdmVZYW1sUGFpcnMsXG59O1xuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLCtCQUErQjtBQUMvQixvRkFBb0Y7QUFDcEYsMEVBQTBFO0FBQzFFLDBFQUEwRTtBQUcxRSxTQUFTLGFBQWEsUUFBUSxlQUFlO0FBRTdDLFNBQVMsaUJBQWlCLElBQWlCO0VBQ3pDLElBQUksU0FBUyxNQUFNLE9BQU87RUFDMUIsT0FBTyxLQUFLLEtBQUssQ0FBQyxDQUFDLEtBQU8sY0FBYyxPQUFPLE9BQU8sSUFBSSxDQUFDLElBQUksTUFBTSxLQUFLO0FBQzVFO0FBRUEsT0FBTyxNQUFNLFFBQTBCO0VBQ3JDLEtBQUs7RUFDTCxXQUFVLElBQXNDO0lBQzlDLGlFQUFpRTtJQUNqRSxPQUFPLE1BQU0sUUFBUSxPQUFPLE9BQU8sS0FBSyxFQUFFO0VBQzVDO0VBQ0EsTUFBTTtFQUNOLFNBQVM7QUFDWCxFQUFFIn0=