// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
var _computedKey;
import { getLevelByName, getLevelName } from "./levels.ts";
const DEFAULT_FORMATTER = ({ levelName, msg })=>`${levelName} ${msg}`;
_computedKey = Symbol.dispose;
export class BaseHandler {
  #levelName;
  #level;
  formatter;
  constructor(levelName, options){
    const { formatter = DEFAULT_FORMATTER } = options ?? {};
    this.#levelName = levelName;
    this.#level = getLevelByName(levelName);
    this.formatter = formatter;
  }
  get level() {
    return this.#level;
  }
  set level(level) {
    this.#level = level;
    this.#levelName = getLevelName(level);
  }
  get levelName() {
    return this.#levelName;
  }
  set levelName(levelName) {
    this.#levelName = levelName;
    this.#level = getLevelByName(levelName);
  }
  handle(logRecord) {
    if (this.level > logRecord.level) return;
    const msg = this.format(logRecord);
    this.log(msg);
  }
  format(logRecord) {
    return this.formatter(logRecord);
  }
  setup() {}
  destroy() {}
  [_computedKey]() {
    this.destroy();
  }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vanNyLmlvL0BzdGQvbG9nLzAuMjI0LjcvYmFzZV9oYW5kbGVyLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDE4LTIwMjQgdGhlIERlbm8gYXV0aG9ycy4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG4vLyBUaGlzIG1vZHVsZSBpcyBicm93c2VyIGNvbXBhdGlibGUuXG5pbXBvcnQge1xuICBnZXRMZXZlbEJ5TmFtZSxcbiAgZ2V0TGV2ZWxOYW1lLFxuICB0eXBlIExldmVsTmFtZSxcbiAgdHlwZSBMb2dMZXZlbCxcbn0gZnJvbSBcIi4vbGV2ZWxzLnRzXCI7XG5pbXBvcnQgdHlwZSB7IExvZ1JlY29yZCB9IGZyb20gXCIuL2xvZ2dlci50c1wiO1xuXG5leHBvcnQgdHlwZSBGb3JtYXR0ZXJGdW5jdGlvbiA9IChsb2dSZWNvcmQ6IExvZ1JlY29yZCkgPT4gc3RyaW5nO1xuY29uc3QgREVGQVVMVF9GT1JNQVRURVI6IEZvcm1hdHRlckZ1bmN0aW9uID0gKHsgbGV2ZWxOYW1lLCBtc2cgfSkgPT5cbiAgYCR7bGV2ZWxOYW1lfSAke21zZ31gO1xuXG5leHBvcnQgaW50ZXJmYWNlIEJhc2VIYW5kbGVyT3B0aW9ucyB7XG4gIGZvcm1hdHRlcj86IEZvcm1hdHRlckZ1bmN0aW9uO1xufVxuXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQmFzZUhhbmRsZXIge1xuICAjbGV2ZWxOYW1lOiBMZXZlbE5hbWU7XG4gICNsZXZlbDogTG9nTGV2ZWw7XG4gIGZvcm1hdHRlcjogRm9ybWF0dGVyRnVuY3Rpb247XG5cbiAgY29uc3RydWN0b3IoXG4gICAgbGV2ZWxOYW1lOiBMZXZlbE5hbWUsXG4gICAgb3B0aW9ucz86IEJhc2VIYW5kbGVyT3B0aW9ucyxcbiAgKSB7XG4gICAgY29uc3QgeyBmb3JtYXR0ZXIgPSBERUZBVUxUX0ZPUk1BVFRFUiB9ID0gb3B0aW9ucyA/PyB7fTtcbiAgICB0aGlzLiNsZXZlbE5hbWUgPSBsZXZlbE5hbWU7XG4gICAgdGhpcy4jbGV2ZWwgPSBnZXRMZXZlbEJ5TmFtZShsZXZlbE5hbWUpO1xuICAgIHRoaXMuZm9ybWF0dGVyID0gZm9ybWF0dGVyO1xuICB9XG5cbiAgZ2V0IGxldmVsKCk6IExvZ0xldmVsIHtcbiAgICByZXR1cm4gdGhpcy4jbGV2ZWw7XG4gIH1cblxuICBzZXQgbGV2ZWwobGV2ZWw6IExvZ0xldmVsKSB7XG4gICAgdGhpcy4jbGV2ZWwgPSBsZXZlbDtcbiAgICB0aGlzLiNsZXZlbE5hbWUgPSBnZXRMZXZlbE5hbWUobGV2ZWwpO1xuICB9XG5cbiAgZ2V0IGxldmVsTmFtZSgpOiBMZXZlbE5hbWUge1xuICAgIHJldHVybiB0aGlzLiNsZXZlbE5hbWU7XG4gIH1cbiAgc2V0IGxldmVsTmFtZShsZXZlbE5hbWU6IExldmVsTmFtZSkge1xuICAgIHRoaXMuI2xldmVsTmFtZSA9IGxldmVsTmFtZTtcbiAgICB0aGlzLiNsZXZlbCA9IGdldExldmVsQnlOYW1lKGxldmVsTmFtZSk7XG4gIH1cblxuICBoYW5kbGUobG9nUmVjb3JkOiBMb2dSZWNvcmQpIHtcbiAgICBpZiAodGhpcy5sZXZlbCA+IGxvZ1JlY29yZC5sZXZlbCkgcmV0dXJuO1xuXG4gICAgY29uc3QgbXNnID0gdGhpcy5mb3JtYXQobG9nUmVjb3JkKTtcbiAgICB0aGlzLmxvZyhtc2cpO1xuICB9XG5cbiAgZm9ybWF0KGxvZ1JlY29yZDogTG9nUmVjb3JkKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy5mb3JtYXR0ZXIobG9nUmVjb3JkKTtcbiAgfVxuXG4gIGFic3RyYWN0IGxvZyhtc2c6IHN0cmluZyk6IHZvaWQ7XG4gIHNldHVwKCkge31cbiAgZGVzdHJveSgpIHt9XG5cbiAgW1N5bWJvbC5kaXNwb3NlXSgpIHtcbiAgICB0aGlzLmRlc3Ryb3koKTtcbiAgfVxufVxuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLDBFQUEwRTtBQUMxRSxxQ0FBcUM7O0FBQ3JDLFNBQ0UsY0FBYyxFQUNkLFlBQVksUUFHUCxjQUFjO0FBSXJCLE1BQU0sb0JBQXVDLENBQUMsRUFBRSxTQUFTLEVBQUUsR0FBRyxFQUFFLEdBQzlELENBQUMsRUFBRSxVQUFVLENBQUMsRUFBRSxJQUFJLENBQUM7ZUFxRHBCLE9BQU8sT0FBTztBQS9DakIsT0FBTyxNQUFlO0VBQ3BCLENBQUEsU0FBVSxDQUFZO0VBQ3RCLENBQUEsS0FBTSxDQUFXO0VBQ2pCLFVBQTZCO0VBRTdCLFlBQ0UsU0FBb0IsRUFDcEIsT0FBNEIsQ0FDNUI7SUFDQSxNQUFNLEVBQUUsWUFBWSxpQkFBaUIsRUFBRSxHQUFHLFdBQVcsQ0FBQztJQUN0RCxJQUFJLENBQUMsQ0FBQSxTQUFVLEdBQUc7SUFDbEIsSUFBSSxDQUFDLENBQUEsS0FBTSxHQUFHLGVBQWU7SUFDN0IsSUFBSSxDQUFDLFNBQVMsR0FBRztFQUNuQjtFQUVBLElBQUksUUFBa0I7SUFDcEIsT0FBTyxJQUFJLENBQUMsQ0FBQSxLQUFNO0VBQ3BCO0VBRUEsSUFBSSxNQUFNLEtBQWUsRUFBRTtJQUN6QixJQUFJLENBQUMsQ0FBQSxLQUFNLEdBQUc7SUFDZCxJQUFJLENBQUMsQ0FBQSxTQUFVLEdBQUcsYUFBYTtFQUNqQztFQUVBLElBQUksWUFBdUI7SUFDekIsT0FBTyxJQUFJLENBQUMsQ0FBQSxTQUFVO0VBQ3hCO0VBQ0EsSUFBSSxVQUFVLFNBQW9CLEVBQUU7SUFDbEMsSUFBSSxDQUFDLENBQUEsU0FBVSxHQUFHO0lBQ2xCLElBQUksQ0FBQyxDQUFBLEtBQU0sR0FBRyxlQUFlO0VBQy9CO0VBRUEsT0FBTyxTQUFvQixFQUFFO0lBQzNCLElBQUksSUFBSSxDQUFDLEtBQUssR0FBRyxVQUFVLEtBQUssRUFBRTtJQUVsQyxNQUFNLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUN4QixJQUFJLENBQUMsR0FBRyxDQUFDO0VBQ1g7RUFFQSxPQUFPLFNBQW9CLEVBQVU7SUFDbkMsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0VBQ3hCO0VBR0EsUUFBUSxDQUFDO0VBQ1QsVUFBVSxDQUFDO0VBRVgsaUJBQW1CO0lBQ2pCLElBQUksQ0FBQyxPQUFPO0VBQ2Q7QUFDRiJ9