/**
 * Kallichore API
 * Kallichore is a Jupyter kernel gateway and supervisor
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: info@posit.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { RequestFile } from './models';
import { InterruptMode } from './interruptMode';
import { VarAction } from './varAction';

export class NewSession {
    /**
    * A unique identifier for the session
    */
    'sessionId': string;
    /**
    * A human-readable name for the session
    */
    'displayName': string;
    /**
    * The interpreter language
    */
    'language': string;
    /**
    * The username of the user who owns the session
    */
    'username': string;
    /**
    * The text to use to prompt for input
    */
    'inputPrompt': string;
    /**
    * The text to use to prompt for input continuations
    */
    'continuationPrompt': string;
    /**
    * The program and command-line parameters for the session
    */
    'argv': Array<string>;
    /**
    * The working directory in which to start the session.
    */
    'workingDirectory': string;
    /**
    * A list of environment variable actions to perform
    */
    'env': Array<VarAction>;
    /**
    * The number of seconds to wait for a connection to the session\'s ZeroMQ sockets before timing out
    */
    'connectionTimeout'?: number = 30;
    'interruptMode': InterruptMode;
    /**
    * The Jupyter protocol version supported by the underlying kernel
    */
    'protocolVersion'?: string = '5.3';
    /**
    * Whether to run the session inside a login shell; only relevant on POSIX systems
    */
    'runInShell'?: boolean = false;

    static discriminator: string | undefined = undefined;

    static attributeTypeMap: Array<{name: string, baseName: string, type: string}> = [
        {
            "name": "sessionId",
            "baseName": "session_id",
            "type": "string"
        },
        {
            "name": "displayName",
            "baseName": "display_name",
            "type": "string"
        },
        {
            "name": "language",
            "baseName": "language",
            "type": "string"
        },
        {
            "name": "username",
            "baseName": "username",
            "type": "string"
        },
        {
            "name": "inputPrompt",
            "baseName": "input_prompt",
            "type": "string"
        },
        {
            "name": "continuationPrompt",
            "baseName": "continuation_prompt",
            "type": "string"
        },
        {
            "name": "argv",
            "baseName": "argv",
            "type": "Array<string>"
        },
        {
            "name": "workingDirectory",
            "baseName": "working_directory",
            "type": "string"
        },
        {
            "name": "env",
            "baseName": "env",
            "type": "Array<VarAction>"
        },
        {
            "name": "connectionTimeout",
            "baseName": "connection_timeout",
            "type": "number"
        },
        {
            "name": "interruptMode",
            "baseName": "interrupt_mode",
            "type": "InterruptMode"
        },
        {
            "name": "protocolVersion",
            "baseName": "protocol_version",
            "type": "string"
        },
        {
            "name": "runInShell",
            "baseName": "run_in_shell",
            "type": "boolean"
        }    ];

    static getAttributeTypeMap() {
        return NewSession.attributeTypeMap;
    }
}

export namespace NewSession {
}
